simFile_loc = [MatlabPath Sim_name_folder '\'];

calllib('QBladeDLL','setLibraryPath',DllPath)
calllib('QBladeDLL','createInstance',1,24)
simName = 'NREL5MW_WSETSRK.sim';
calllib('QBladeDLL','loadSimDefinition',[simFile_loc simName])
calllib('QBladeDLL','initializeSimulation')

simTime = 4000; %in timestep, actual time is timestep*#timesteps %TO DO CHANGE
valuestr = 'Time [s]';
valuestr1 = 'Rotational Speed [rpm]';
valuestr2 = 'Gen. HSS Torque [Nm]';
valuestr3 = 'SWAP[46] [-]'; %Generator torque
valuestr4 = 'Abs Wind Vel. at Hub [m/s]';
valuestr5 = 'SWAP[84] [-]'; %Estimated wind speed
valuestr6 = 'Tip Speed Ratio [-]';
valuestr7 = 'SWAP[85] [-]'; %Estimated tip-speed ratio

f = waitbar(0,'Initializing Simulation') ;

for i_for2 = 1:1:simTime

    calllib('QBladeDLL','advanceTurbineSimulation')
    calllib('QBladeDLL','advanceController_at_num',[0 0 0 0 0],0)
    
    Time = calllib('QBladeDLL','getCustomData_at_num',valuestr, 0, 0); 
    Rpm = calllib('QBladeDLL','getCustomData_at_num',valuestr1, 0, 0);
    GenTg = calllib('QBladeDLL','getCustomData_at_num',valuestr2, 0, 0); 
    GenTgSWAP = calllib('QBladeDLL','getCustomData_at_num',valuestr3, 0, 0); 
    U = calllib('QBladeDLL','getCustomData_at_num',valuestr4, 0, 0); 
    Uest = calllib('QBladeDLL','getCustomData_at_num',valuestr5, 0, 0); 
    TSR = calllib('QBladeDLL','getCustomData_at_num',valuestr6, 0, 0); 
    TSRest = calllib('QBladeDLL','getCustomData_at_num',valuestr7, 0, 0); 
    
    DATA.time(i_for2,:) = Time;
    DATA.Omega(i_for2,:) = Rpm;
    DATA.Tg(i_for2,:) = GenTg;
    DATA.TgSWAP(i_for2,:) = GenTgSWAP;
    DATA.U(i_for2,:) = U;
    DATA.Uest(i_for2,:) = Uest;
    DATA.TSR(i_for2,:) = TSR;
    DATA.TSRest(i_for2,:) = TSRest;

    waitbar(i_for2/simTime,f,'Simulation Running')

end
close(f)

calllib('QBladeDLL','closeInstance')
