%%
% Writing DISCON loop.

%%
clear all
close all 
clc

%% Define paths

%set the absolute path to your qblade directory here
UserPath = '<userpath>\QBladeCE_2.0.5.2\'; 
disconPath = [UserPath];
MatlabPath = [UserPath 'MATLAB_Files\4p4_DRC_Cases\4p41_BaselineTorqueControl\'];
SourcePath = [UserPath 'Source'] ;
DllPath = [UserPath 'QBladeCE_2.0.5.2.dll'];

addpath('..\Functions');
addpath('..\..\..\');
%%

%this is setup using relative path and depends on the location of this file, if there are issues use absolute path to these files
loadlibrary(DllPath,'../../QBladeDLLFunctions.h','alias','QBladeDLL') 

m = libfunctions('QBladeDLL') ;

if isempty(m)
    fprintf('Error')
end

%% Defining Settings
Pitchb1 = 0;
Pitchb2 = 0;
Pitchb3 = 0;
KpTSR = [-1635.1714 -2079.5682];
KiTSR = [-6451.3008 -11.6565];	
KpWSE = [8.0258 11.2468];	
KiWSE = [0.2796 0.2775];
TSRref = [7.2385 7.7187];
K = [0.0000 0.0000];
Tg0 = [25000.0000 25000.0000];

SimNr = length(TSRref);
tic
for i_for1 = 1:1:SimNr

    Sim_name_folder = ['Sim_', num2str(i_for1)] ;
    
    copyfile([SourcePath],Sim_name_folder);

    cd(disconPath)

    writeDisconWSETSR(Pitchb1,Pitchb2,Pitchb3, ...
        KpTSR(i_for1),KiTSR(i_for1),KpWSE(i_for1),KiWSE(i_for1), ...
        TSRref(i_for1),K(i_for1),Tg0(i_for1))
    cd(MatlabPath)

    run Torque_Simulation.m
    
    cd(Sim_name_folder)
    
    save(['Output_',num2str(i_for1)],'DATA')
    cd('..\..\..\..\')
    %delete('discon.in');
    cd(MatlabPath)
end
%%
toc

figure();grid on;
subplot(1,4,1)
title('Generator Torque')
plot(DATA.time,DATA.Tg); hold on;
plot(DATA.time,DATA.TgSWAP);
subplot(1,4,2)
title('Rotational speed')
plot(DATA.time,DATA.Omega);
subplot(1,4,3)
title('Tip-speed ratio')
plot(DATA.time,DATA.TSR);
hold on;
plot(DATA.time,DATA.TSRest);
legend('Measured','Estimated');
subplot(1,4,4)
title('Rotor-effective wind speed')
plot(DATA.time,DATA.U);
hold on;
plot(DATA.time,DATA.Uest);
legend('Measured','Estimated');
