%%
%Step in wind simulation.

%%
clear all
close all 
clc

addpath('..\..\');

%this is setup using relative path and depends on the location of this file, if there are issues use absolute path to these files
loadlibrary('../../QBladeCE_2.0.5.2.dll','../QBladeDLLFunctions.h','alias','QBladeDLL') 

m = libfunctions('QBladeDLL') ;

if isempty(m)
    fprintf('Error')
end

%this is setup using relative path and depends on the location of this file, if there are issues use absolute path to these files
calllib('QBladeDLL','setLibraryPath','../../QBladeCE_2.0.5.2.dll')

calllib('QBladeDLL','createInstance',0,24)

%this is setup using relative path and depends on the location of this file, if there are issues use absolute path to these files
projectFile = '../../Source/NREL5MW.qpr';

calllib('QBladeDLL','loadProject',projectFile)
calllib('QBladeDLL','initializeSimulation')

simTime = 3000; %in timestep, actual time is timestep*#timesteps
valuestr = 'Rotational Speed [rpm]';
valuestr2 = 'Gen. HSS Torque [Nm]';
f = waitbar(0,'Initializing Simulation') ;


K = 2.24;
N = 97;
startWind = 1500;
for i = 1:1:simTime

    calllib('QBladeDLL','advanceTurbineSimulation')
    if i > startWind
    calllib('QBladeDLL','setPowerLawWind', 10, 0, 0, 0, 87.6)
    end
    omega = calllib('QBladeDLL','getCustomData_at_num',valuestr, 0.5, 0) ;
    genTorqueQB = calllib('QBladeDLL','getCustomData_at_num',valuestr2, 0, 0) ;
    genTorqueQB_store(i,:) = genTorqueQB;

    omega_g = omega*N;
    genTorque = K.*(omega_g*(2*pi/60))^2;
    genTorque_store(i,:) = genTorque ;

    calllib('QBladeDLL','setControlVars_at_num',[genTorque 0 0 0 0],0)
    V_hub(i,:) = calllib('QBladeDLL','getWindspeed', -20, 0, 87.6, [0 0 0]);
    waitbar(i/simTime,f,'Simulation Running')

end

close(f)
% calllib('QBladeDLL','storeProject','Test.qpr')
calllib('QBladeDLL','closeInstance')

figure;
subplot(2,1,1)
plot(genTorqueQB_store)
hold on
plot(genTorque_store)
grid on
legend('QB HSS Torque','K omega^2')

subplot(2,1,2)
plot(V_hub)
grid on
legend('Wind Speed [m/s]')