%%
% This is a minimum working example on how to interface with the Qblade
% DLL. A project called 'NREL5MW.qpr' has been provided to work with. This
% script establishes a connection to the QBlade .dll, calls the library
% QBladeDLL and then initializes QBlade and the project. It runs the
% simulation for 100 simulation steps, and outputs the rpm. The time length
% of the simulation equals the number of simulation steps times the time
% step with which the simulation has been set up. At the end, the QBlade
% instance is closed again.

%%
clear all
close all 
clc

addpath('..\..\');
% Establish connection

%this is setup using relative path and depends on the location of this file, if there are issues use absolute path to these files
loadlibrary('../../QBladeCE_2.0.5.2.dll','../QBladeDLLFunctions.h','alias','QBladeDLL') 

m = libfunctions('QBladeDLL') ;

if isempty(m)
    fprintf('Error')
end

%this is setup using relative path and depends on the location of this file, if there are issues use absolute path to these files
calllib('QBladeDLL','setLibraryPath','../../QBladeCE_2.0.5.2.dll')  

calllib('QBladeDLL','createInstance',0,24)

%this is setup using relative path and depends on the location of this file, if there are issues use absolute path to these files
projectFile = '../../Source/NREL5MW.qpr';  

calllib('QBladeDLL','loadProject',projectFile)
calllib('QBladeDLL','initializeSimulation')
simTime = 100; %in timestep, actual time is timestep*#timesteps
valuestr = 'Rotational Speed [rpm]';

f = waitbar(0,'Initializing Simulation') ;

for i = 1:1:simTime
    calllib('QBladeDLL','advanceTurbineSimulation')
    a = calllib('QBladeDLL','getCustomData_at_num',valuestr, 0, 0);
    rpm(i,:) = a;

    waitbar(i/simTime,f,'Simulation Running')

end

close(f);
%calllib('QBladeDLL','storeProject','check.qpr')
calllib('QBladeDLL','closeInstance')

