%% Motion of an active droplet  considering wall effects
clc 
clear all

%% The system parameters
u_fa=6*0.42;% nondimensional average imposed flow velocity (upstream 0.42) multiplied by the constant 6
w=50e-6; % half channel width(m)
z_dhalf=25e-6; %half channel depth (h m)
ar=w/z_dhalf; % channel aspect ratio
r_d=25e-6; %droplet radius (m)
l=w/r_d; 
mu=1.003e-3; %viscosity of surrounding liquid
v_0=29.5e-6; %  intrinsic droplet swimming velocity (m/s)
t_0=r_d/v_0; %time scale
t_f=10000; % total time period for solution 10000(s)
dt=0.02; % time interval for solution
t_fnd=t_f/t_0;
dt_nd=dt/t_0;
tspan=linspace(0,t_fnd,t_fnd/dt_nd);

c_1=1.0; % flow constant 1.34
k_b=1.380648e-23; %Boltzmann constant
T=273+25; 
D_r=(k_b*T)/(8*pi*1.003e-3*(r_d)^3);
Pe_r=((u_fa/6)*v_0)/(D_r*w);

%% Values of singularity strengths
%p=6*pi*mu*v_0*r_d^2; % strength of force dipole
a_fd=0.16;%(p/(8*pi*mu*v_0*r_d^2)); 0.16
b_sd=0.26;%(s/(v_0*r_d^3));0.26
c_sq=0.0;%-0.08

c_2=1.0;% correction for omega
c_3=1.0;%correction for vx
%% Solution of the Equation 
f=@(tt,yy) [sin(yy(2))+a_fd*(((3*(3*(sin(yy(2))).^2-1))./(8*(l+yy(1)).^2))+((7-11*(sin(yy(2))).^2)./(64*(l+yy(1)).^4))-((3*(3*(sin(yy(2))).^2-1))./(8*(yy(1)-l).^2))-((7-11*(sin(yy(2))).^2)./(64*(yy(1)-l).^4)))+b_sd*((-(1./(l+yy(1)).^3)+(1./(8*(l+yy(1)).^5))+(1./(yy(1)-l).^3)-(1./(8*(yy(1)-l).^5))-17/16).*sin(yy(2)))+c_sq*(((3*(7*(sin(yy(2))).^2+3))./(16*(l+yy(1)).^4))-((5*(11-7*(sin(yy(2))).^2))./(128*(l+yy(1)).^6))-((3*(7*(sin(yy(2))).^2+3))./(16*(yy(1)-l).^4))+((5*(11-7*(sin(yy(2))).^2))./(128*(yy(1)-l).^6)));-(c_1*u_fa*yy(1)/l^2)+(2*c_2*(u_fa/l)).*((0.445)*(yy(1)/l)-(0.0898*(yy(1)/l).^3)-(0.042*(yy(1)/l).^5))-0.1875*a_fd*(sin(2*yy(2))./((l+yy(1)).^3))+0.375*b_sd*(cos(yy(2))./((l+yy(1)).^4))+0.1875*a_fd*(sin(2*yy(2))./((yy(1)-l).^3))-0.375*b_sd*(cos(yy(2))./((yy(1)-l).^4))+0.375*c_sq*(sin(2*yy(2))./((l+yy(1)).^5))-0.375*c_sq*(sin(2*yy(2))./((yy(1)-l).^5))];%-((0.68627/6)*(pi/2)*(yy(1)/l).^3)-((2.622286/120)*((pi/2)^3)*(yy(1)/l).^5)

%Initial condition 
init=[0.7498 pi*32/180];%[0.7498 pi*32/180]
%Psi_0=(pi*110/180)/pi
% init=[0.0138 pi*112/180];%
 
%Solution of the equation
[tt,yy]=ode45(f,tspan,init);

%% Orientation angle
plotting_range1=yy(:,2)./pi; % plotting range 
% colorMap_b='coolwarm';
col2=coolwarm(length(plotting_range1));
plotting_range_timetheo=tt;

%% Solution for the x-co-ordinate
vx=cos(yy(:,2))-c_1*u_fa*(1-(yy(:,1)/l).^2-(1/3)*(1/l)^2)+(4*c_3*u_fa)*(0.193064-(0.222557*(yy(:,1)/l).^2)+(0.022458*(yy(:,1)./l).^4))+a_fd*((0.875./((l+yy(:,1)).^2))+(0.078125./((l+yy(:,1)).^4))-(0.875./((yy(:,1)-l).^2))-(0.078125./((yy(:,1)-l).^4))).*sin(2*yy(:,2))+b_sd*(-(1./(4*(l+yy(:,1)).^3))+(3./(16*(l+yy(:,1)).^5))+(1./(4*(yy(:,1)-l).^3))-(3./(16*(yy(:,1)-l).^5))-17/16).*cos(yy(:,2))+c_sq*(-(5./(128*(l+yy(:,1)).^6))-(3./(16*(l+yy(:,1)).^4))+(3./(16*(yy(:,1)-l).^4))+(5./(128*(yy(:,1)-l).^6))).*sin(2*yy(:,2));
xx=cumtrapz(tt,vx);

%% Solution for the ycomponent of velocity
vy=sin(yy(:,2))+a_fd*(((3*(3*(sin(yy(:,2))).^2-1))./(8*(l+yy(:,1)).^2))+((7-11*(sin(yy(:,2))).^2)./(64*(l+yy(:,1)).^4))-((3*(3*(sin(yy(:,2))).^2-1))./(8*(yy(:,1)-l).^2))-((7-11*(sin(yy(:,2))).^2)./(64*(yy(:,1)-l).^4)))+b_sd*(-(1./(l+yy(:,1)).^3)+(1./(8*(l+yy(:,1)).^5))+(1./(yy(:,1)-l).^3)-(1./(8*(yy(:,1)-l).^5))-17/16).*sin(yy(:,2))+c_sq*(((3*(7*(sin(yy(:,2))).^2+3))./(16*(l+yy(:,1)).^4))-((5*(11-7*(sin(yy(:,2))).^2))./(128*(l+yy(:,1)).^6))-((3*(7*(sin(yy(:,2))).^2+3))./(16*(yy(:,1)-l).^4))+((5*(11-7*(sin(yy(:,2))).^2))./(128*(yy(:,1)-l).^6))); 

%% Droplet speed 
drop_v=(sqrt(vx.^2+vy.^2)); % Rheotactic velocity in the lab refernce frame
plotting_range2=drop_v; % plotting range 
% colorMap_b='jet';
col1=summer(length(plotting_range2));

%% Experimental data
data_exp_4a=importdata('data_fig4a_alpha_psidot.txt');
% data_exp_4a=importdata('data_fig4a.txt');
x_4a=data_exp_4a(:,1);
y_4a=data_exp_4a(:,2);
y_4a_max=max(y_4a);
shi_4a=data_exp_4a(:,3)./pi;
alpha_4a=data_exp_4a(:,5)./pi;
%v_dir=shi_4a+alpha_4a;
plotting_range3=shi_4a;  
col3=coolwarm(length(plotting_range3));
vx_4a=data_exp_4a(:,6)*1e-6./v_0;
vy_4a=data_exp_4a(:,7)*1e-6./v_0;
dv_4a=sqrt(vx_4a.^2+vy_4a.^2);
plotting_range5=dv_4a;
col5=viridis(length(plotting_range5));
t_exp=linspace(0,12.92/t_0,12.92/0.04);
plotting_range_timeexp=t_exp(1,17:200);
col7=plasma(length(plotting_range_timeexp));

data_exp_4b=importdata('data_fig4b_alpha_psidot.txt');
x_4b=data_exp_4b(:,1);
y_4b=data_exp_4b(:,2);
shi_4b=data_exp_4b(:,3)./pi;
alpha_4b=data_exp_4b(:,5)./pi;
v_dir_b=shi_4b+alpha_4b;
plotting_range5=shi_4b;  
col5=coolwarm(length(plotting_range5));
t_exp2=linspace(0,16.92/t_0,16.92/0.04);
% plotting_range_timeexp=t_exp2;

% data_exp_2c=importdata('data_fig2c.txt');
% x_2c=data_exp_2c(:,1);
% y_2c=data_exp_2c(:,2);
% dv_2c=data_exp_2c(:,3);
% plotting_range5b=dv_2c; % plotting range 
% % colorMap_b='jet';
% col5b=viridis(length(plotting_range5b));
% t_exp5b=linspace(0,6.4/t_0,6.4/0.02);
% plotting_range_timeexp5b=t_exp(1,1:191);

%% New experimental limit cycles
% data_exp_lc2=importdata('Limit_cycle_seq2_2_0.txt');
% x_lc2=data_exp_lc2(:,4)./r_d;
% y_lc2=data_exp_lc2(:,2);
% shi_lc2=data_exp_lc2(:,1);
 
data_exp_lc3=importdata('Limit_cycle_seq1_3a_0.txt');
x_lc3=data_exp_lc3(:,4)./r_d;
y_lc3=data_exp_lc3(:,2);
shi_lc3=data_exp_lc3(:,1);
 
data_exp_lc4=importdata('Limit_cycle_seq1_3a_33.txt');
x_lc4=data_exp_lc4(:,4)./r_d;
y_lc4=data_exp_lc4(:,2);
shi_lc4=data_exp_lc4(:,1);

data_exp_lc5=importdata('Limit_cycle_seq1_3a_54.txt');
x_lc5=data_exp_lc5(:,4)./r_d;
y_lc5=data_exp_lc5(:,2);
shi_lc5=data_exp_lc5(:,1);


%% Phase plots
data_store=zeros(size(xx,1),5);
data_store(:,1)=xx(:,1);
data_store(:,2)=yy(:,1);
data_store(:,3)=yy(:,2); %psi in radians
data_store(:,4)=drop_v(:,1);
data_store(:,5)=tt(:,1);

data_range_upper=372060;%changed from 372014
data_range_lower=373450;%372925
xx_wl=data_store(data_range_upper:data_range_lower,1);
data_store_wl=zeros(size(xx_wl,1),4);
data_store_wl(:,1)=data_store(data_range_upper:data_range_lower,1)-data_store(data_range_upper,1)*ones(size(xx_wl,1),1);
data_store_wl(:,2)=data_store(data_range_upper:data_range_lower,2);
data_store_wl(:,3)=data_store(data_range_upper:data_range_lower,3);
data_store_wl(:,4)=data_store(data_range_upper:data_range_lower,4);
data_store_wl(:,5)=data_store(data_range_upper:data_range_lower,5)-data_store(data_range_upper,5)*ones(size(xx_wl,1),1);
data_store_ymax=max(data_store_wl(:,2));
plotting_range6=data_store_wl(:,3)./pi;  
col6=coolwarm(length(plotting_range6));
plotting_range_time_wl=data_store_wl(:,5);
col8=plasma(length(plotting_range_time_wl));

nm=1000;
psi_cp=linspace(min(data_store_wl(:,3)),max(data_store_wl(:,3)),nm);
yy_cp=linspace(min(data_store_wl(:,2)),max(data_store_wl(:,2)),nm);

[PSI_cp,YY_cp]=meshgrid(psi_cp,yy_cp);
vx_cp=zeros(nm,nm);
vy_cp=zeros(nm,nm);
vr_cp=zeros(nm,nm);
psidot_cp=zeros(nm,nm);
for ii=1:1:size(yy_cp,2)
    for jj=1:1:size(psi_cp,2)
        vx_cp(ii,jj)=cos(PSI_cp(ii,jj))-c_1*u_fa*(1-(YY_cp(ii,jj)/l).^2-(1/3)*(1/l)^2)+(4*c_3*u_fa)*(0.193064-(0.222557*(YY_cp(ii,jj)/l).^2)+(0.022458*(YY_cp(ii,jj)./l).^4))+a_fd*((0.875./((l+YY_cp(ii,jj)).^2))+(0.078125./((l+YY_cp(ii,jj)).^4))-(0.875./((YY_cp(ii,jj)-l).^2))-(0.078125./((YY_cp(ii,jj)-l).^4))).*sin(2*PSI_cp(ii,jj))+b_sd*(-(1./(4*(l+YY_cp(ii,jj)).^3))+(3./(16*(l+YY_cp(ii,jj)).^5))+(1./(4*(YY_cp(ii,jj)-l).^3))-(3./(16*(YY_cp(ii,jj)-l).^5))-17/16).*cos(PSI_cp(ii,jj))+c_sq*(-(5./(128*(l+YY_cp(ii,jj)).^6))-(3./(16*(l+YY_cp(ii,jj)).^4))+(3./(16*(YY_cp(ii,jj)-l).^4))+(5./(128*(YY_cp(ii,jj)-l).^6))).*sin(2*PSI_cp(ii,jj));
        vy_cp(ii,jj)=sin(PSI_cp(ii,jj))+a_fd*(((3*(3*(sin(PSI_cp(ii,jj))).^2-1))./(8*(l+YY_cp(ii,jj)).^2))+((7-11*(sin(PSI_cp(ii,jj))).^2)./(64*(l+YY_cp(ii,jj)).^4))-((3*(3*(sin(PSI_cp(ii,jj))).^2-1))./(8*(YY_cp(ii,jj)-l).^2))-((7-11*(sin(PSI_cp(ii,jj))).^2)./(64*(YY_cp(ii,jj)-l).^4)))+b_sd*(-(1./(l+YY_cp(ii,jj)).^3)+(1./(8*(l+YY_cp(ii,jj)).^5))+(1./(YY_cp(ii,jj)-l).^3)-(1./(8*(YY_cp(ii,jj)-l).^5))-17/16).*sin(PSI_cp(ii,jj))+c_sq*(((3*(7*(sin(PSI_cp(ii,jj))).^2+3))./(16*(l+YY_cp(ii,jj)).^4))-((5*(11-7*(sin(PSI_cp(ii,jj))).^2))./(128*(l+YY_cp(ii,jj)).^6))-((3*(7*(sin(PSI_cp(ii,jj))).^2+3))./(16*(YY_cp(ii,jj)-l).^4))+((5*(11-7*(sin(PSI_cp(ii,jj))).^2))./(128*(YY_cp(ii,jj)-l).^6))); 
        vr_cp(ii,jj)=sqrt(vx_cp(ii,jj)^2+vy_cp(ii,jj)^2);
        psidot_cp(ii,jj)=-(c_1*u_fa*YY_cp(ii,jj)/l^2)+(2*c_2*(u_fa/l)).*((0.445)*(YY_cp(ii,jj)/l)-(0.0898*(YY_cp(ii,jj)/l).^3)-(0.042*(YY_cp(ii,jj)/l).^5))-0.1875*a_fd*(sin(2*PSI_cp(ii,jj))./((l+YY_cp(ii,jj)).^3))+0.375*b_sd*(cos(PSI_cp(ii,jj))./((l+YY_cp(ii,jj)).^4))+0.1875*a_fd*(sin(2*PSI_cp(ii,jj))./((YY_cp(ii,jj)-l).^3))-0.375*b_sd*(cos(PSI_cp(ii,jj))./((YY_cp(ii,jj)-l).^4))+0.375*c_sq*(sin(2*PSI_cp(ii,jj))./((l+YY_cp(ii,jj)).^5))-0.375*c_sq*(sin(2*PSI_cp(ii,jj))./((YY_cp(ii,jj)-l).^5));
    end 
end
 %% Search for fixed points
% fp=@(yf) [sin(yf(2))+a_fd*(((3*(3*(sin(yf(2))).^2-1))./(8*(l+yf(1)).^2))+((7-11*(sin(yf(2))).^2)./(64*(l+yf(1)).^4))-((3*(3*(sin(yf(2))).^2-1))./(8*(yf(1)-l).^2))-((7-11*(sin(yf(2))).^2)./(64*(yf(1)-l).^4)))+b_sd*((-(1./(l+yf(1)).^3)+(1./(8*(l+yf(1)).^5))+(1./(yf(1)-l).^3)-(1./(8*(yf(1)-l).^5))-17/16).*sin(yf(2)))+c_sq*(((3*(7*(sin(yf(2))).^2+3))./(16*(l+yf(1)).^4))-((5*(11-7*(sin(yf(2))).^2))./(128*(l+yf(1)).^6))-((3*(7*(sin(yf(2))).^2+3))./(16*(yf(1)-l).^4))+((5*(11-7*(sin(yf(2))).^2))./(128*(yf(1)-l).^6)));-(c_1*u_fa*yf(1)/l^2)-0.1875*a_fd*(sin(2*yf(2))./((l+yf(1)).^3))+0.375*b_sd*(cos(yf(2))./((l+yf(1)).^4))+0.1875*a_fd*(sin(2*yf(2))./((yf(1)-l).^3))-0.375*b_sd*(cos(yf(2))./((yf(1)-l).^4))+0.375*c_sq*(sin(2*yf(2))./((l+yf(1)).^5))-0.375*c_sq*(sin(2*yf(2))./((yf(1)-l).^5))];
% yf0=[1.25783;pi*0/180];
% options=optimoptions('fsolve','FunctionTolerance', 1e-12, 'MaxIterations',1000,'StepTolerance',1e-12);
% [yf,fval,exitflag,output] = fsolve(fp,yf0,options);

%% plot the solutions 
% figure(1) % entire trajectory plot
% hold on
% plot(x_100_4a,y_100_4a,'or')
% hold on
% plot(xx(:,1),yy(:,1),'-k','Linewidth',3)
% xlim([100 1e4])
% xlim([min(xx) max(xx)])
% ylim([-l +l])
% hold on
% box ('on')
% pbaspect([5 3 1])

% % figure(2)
% % hold on
% % plot(x_100_4a+652.1*ones(size(x_100_4a)),y_100_4a,'or')
% % hold on
% % plot(xx(:,1),yy(:,1),'-b','Linewidth',3)
% % xlim([650 660])
% % ylim([-2 +2])
% % hold on

figure (4) %theoretical y vs x with Psi
hold on 
hScat1 = scatter(xx(:,1)-998.051*ones(size(xx)), yy(:,1),200,plotting_range1, 'Filled') %998.051
colormap('coolwarm')
colorbar
xlim([0 12])
% ylim([-l +l])
ylim([-2 +2])
box ('on')
pbaspect([5 3 1]) 

figure(3)
hold on
plot_slc=plot(xx(:,1)-998.051*ones(size(xx)), yy(:,1),'-r','LineWidth',12)
plot_slc.Color(4)=0.4;
xlim([0 12])
ylim([-2 +2])
box ('on')
pbaspect([5 3 1]) 

% figure (4)
% hold on 
% hScat2 = scatter(x_4a, y_4a,200,plotting_range3, 'Filled')
% colormap('coolwarm')
% colorbar
% ylim([-2 +2])
% box ('on')
% pbaspect([5 3 1])
 
% figure (3)
% hold on 
% hScat3 = scatter(xx(:,1)-998.051*ones(size(xx)), yy(:,1),200,plotting_range2, 'Filled')
% colormap('viridis')
% colorbar
% xlim([0 120])
% % ylim([-l +l])
% ylim([-2 +2])
% box ('on')
% pbaspect([5 3 1]) 
 
% figure (6)
% hold on 
% hScat4 = scatter(x_4a,y_4a,200,plotting_range5, 'Filled')
% colormap('viridis')
% colorbar
% ylim([-2 +2])
% box ('on')
% pbaspect([5 3 1])

% figure (7)
% hold on 
% hScat5 = scatter(x_4b,y_4b,220,plotting_range5, 'Filled')
% colormap('coolwarm')
% colorbar
% ylim([-2 +2])
% box ('on')
% pbaspect([5 3 1])

% figure (1)
% hold on 
% plot(t_exp2,shi_4b+alpha_4b,'--ok','LineWidth',3)
% hold on 
% pbaspect([1 1 1])

% figure (7)
% hold on
% plot(tt,yy(:,2)./pi,'-r','LineWidth',3)
% box ('on')
% pbaspect([1 1 1])
 
% figure (7)
% hold on 
% plot(t_exp,v_dir,'--k','LineWidth',3)
% box ('on')
% pbaspect([1 1 1])
 
% figure (1)
% hold on
% yyaxis left
% plot(t_exp2,shi_4b,'--ob','LineWidth',3)
% yyaxis right
% plot(t_exp2,alpha_4b,'--sr','LineWidth',3)
% % box ('on')
% % pbaspect([1 1 1])

% % figure (9)
% % hold on 
% % plot(t_exp2,v_dir_b,'--ok','LineWidth',3)
% % %ylim([-0.5 +0.5])
% % box ('on')
% % pbaspect([1 1 1])
 
% figure (10)
% hold on 
% hScat5=scatter(shi_4a(17:191,1),y_4a(17:191,1),120,plotting_range_timeexp,'Filled')
% colormap('jet')
% colorbar
% box ('on')
% pbaspect([1 1 1])
 
% figure (11)
% % hold on
% % plot(0,0,'o','MarkerFaceColor','r')
% hold on 
% hScat6=scatter(yy(:,2)./pi,yy(:,1),80,plotting_range_timetheo,'Filled')
% colormap('plasma')
% colorbar
% % hold on
% % plot(shi_4a(17:191,1),y_4a(17:191,1),'sk','MarkerFaceColor','k')
% % hold on
% box ('on')
% pbaspect([1 1 1])
 
% figure (12)
% hold on
% plot(0,0,'*','MarkerFaceColor','r')
% hold on 
% % plot(yy(:,2)./pi,yy(:,1),'-k','LineWidth',3)
% % hold on
% % plot(data_store_wl(:,3)./pi,data_store_wl(:,2),'-r','LineWidth',3)
% % hold on
% hscat_exp=scatter(shi_4a(17:191,1),y_4a(17:191,1),'filled','MarkerFaceColor','b'); %17:191
% hscat_exp.MarkerFaceAlpha=0.5;
% hold on
% hscat_exp5=scatter(shi_lc5(1:194,1),y_lc5(1:194,1),'filled','MarkerFaceColor','c'); %17:191
% hscat_exp5.MarkerFaceAlpha=0.5;
% box ('on')
% pbaspect([1 1 1])

% figure (13)
% hold on
% hscat_exp2=scatter(shi_lc2(1:224,1),y_lc2(1:224,1),'o','filled','MarkerFaceColor','r'); %17:191
% hscat_exp2.MarkerFaceAlpha=0.5;
% hold on
% hscat_exp3=scatter(shi_lc3(1:199,1),y_lc3(1:199,1),'s','filled','MarkerFaceColor','r'); %17:191
% hscat_exp3.MarkerFaceAlpha=0.5;
% hold on
% hscat_exp4=scatter(shi_lc4(1:194,1),y_lc4(1:194,1),'>','filled','MarkerFaceColor','g'); %17:191
% hscat_exp4.MarkerFaceAlpha=0.5;
% box ('on')
% hscat_exp5=scatter(shi_lc5(1:188,1),y_lc5(1:188,1),'o','filled','MarkerFaceColor','b'); %17:191
% hscat_exp5.MarkerFaceAlpha=0.5;
% hold on
% hscat_exp=scatter(shi_4a(17:191,1),y_4a(17:191,1),'o','filled','MarkerFaceColor','b'); %17:191
% hscat_exp.MarkerFaceAlpha=1.0;
% hold on
% ylim([-1.5 +1.5])
% box ('on')
% pbaspect([1 1 1])
 
% figure (1)
% hold on 
% plot(yy(:,1),drop_v,'-k','LineWidth',3)
% hold on
 
% figure (1)
% hold on 
% hScat5=scatter(y_2c(1:191,1),dv_2c(1:191,1),120,plotting_range_timeexp5b,'Filled')
% colormap('plasma')
% colorbar
% box ('on')
% pbaspect([1 1 1])

% figure(14)
% hold on 
% contourf(PSI_cp./pi,YY_cp,vr_cp,'Linecolor','none')
% % axis equal
% colormap('viridis')      
% colorbar('eastoutside')
% hold on  
% plot(data_store_wl(:,3)./pi,data_store_wl(:,2),'-r','LineWidth',8)
% box ('on')
% pbaspect([1 1 1])

% figure(15)
% hold on
% plot_slc=plot(data_store_wl(:,3)./pi,data_store_wl(:,2),'-k','LineWidth',10)
% plot_slc.Color(4)=1.0;
% hold on
% box ('on')
% grid('on')
% pbaspect([1 1 1])

% figure(16)
% hold on
% hscat_exp=scatter(y_4a(17:197,1),dv_4a(17:197,1),200,'filled','MarkerFaceColor','b'); %17:191
% hscat_exp.MarkerFaceAlpha=0.5;
% hold on
% plot_slc=plot(data_store_wl(:,2),data_store_wl(:,4),'-r','LineWidth',3)
% plot_slc.Color(4)=1;
% hold on
% box ('on')
% grid('on')
% pbaspect([1 1 1])

% figure(2)
% hold on
% hscat6=scatter(data_store_wl(:,5),data_store_wl(:,2),80,plotting_range6,'Filled')
% colormap('coolwarm')
% colorbar
% ylim([-2 +2])
% box ('on')
% pbaspect([5 3 1])

% figure(18)
% hold on
% plot_slc=plot(data_store_wl(:,5),data_store_wl(:,2),'-b','LineWidth',4)
% plot_slc.Color(4)=1;
% hold on
% box ('on')
% grid('on')
% pbaspect([5 3 1])

% figure(1)
% hold on
% plot(data_store_wl(:,3)./pi,data_store_wl(:,2)./data_store_ymax,'-r','LineWidth',3)
% hold on
% hscat_exp=scatter(shi_4a(17:191,1),y_4a(17:191,1)./y_4a_max,220,'filled','MarkerFaceColor','b'); %17:191
% hscat_exp.MarkerFaceAlpha=0.70;
% hold on
% box ('on')
% grid('on')
% pbaspect([1 1 1])

% figure(2)
% hold on
% % hscat_theo=scatter(data_store_wl(:,2)./data_store_ymax,data_store_wl(:,4),100,plotting_range_time_wl,'Filled')
% % colormap('plasma')
% % colorbar
% plot(data_store_wl(:,2)./data_store_ymax,data_store_wl(:,4),'-k','Linewidth',4)
% hold on
% % hscat_exp=scatter(y_4a(17:200,1)./y_4a_max,dv_4a(17:200,1),220,plotting_range_timeexp,'Filled'); %17:191
% % hscat_exp.MarkerFaceAlpha=0.75;
% % colormap('plasma')
% % colorbar
% hold on
% box ('on')
% grid('on')
% pbaspect([1 1 1])