(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     15606,        530]
NotebookOptionsPosition[     14954,        506]
NotebookOutlinePosition[     15330,        522]
CellTagsIndexPosition[     15287,        519]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], "\n", 
 StyleBox[
  RowBox[{
   RowBox[{"xsing", "=", 
    RowBox[{"{", 
     RowBox[{"x0", ",", "y0"}], "}"}]}], ";"}],
  FontFamily->"Courier New",
  FontSize->14], "\n", 
 StyleBox[
  RowBox[{
   RowBox[{"hbw", "=", 
    RowBox[{"(", 
     RowBox[{"w", "+", "y0"}], ")"}]}], ";"}],
  FontFamily->"Courier New",
  FontSize->14], "\n", 
 StyleBox[
  RowBox[{
   RowBox[{"imgdist", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"2", "*", "hbw"}]}], "}"}]}], ";"}],
  FontFamily->"Courier New",
  FontSize->14], "\n", 
 StyleBox[
  RowBox[{
   RowBox[{"ximg", "=", 
    RowBox[{"xsing", "-", "imgdist"}]}], ";"}],
  FontFamily->"Courier New",
  FontSize->14], "\n", 
 StyleBox[
  RowBox[{
   RowBox[{"xx", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "^", "1"}], ",", 
      RowBox[{"y", "^", "1"}]}], "}"}]}], ";"}],
  FontFamily->"Courier New",
  FontSize->14], "\n", 
 StyleBox[
  RowBox[{
   RowBox[{"Deltaxx", "=", 
    RowBox[{"xx", "-", "ximg"}]}], ";"}],
  FontFamily->"Courier New",
  FontSize->14], "\n", 
 StyleBox[
  RowBox[{
   RowBox[{"Deltarr", "=", 
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Deltaxx", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"Deltaxx", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "^", "2"}]}], "]"}]}], ";"}],
  FontFamily->"Courier New",
  FontSize->14], "\n", 
 StyleBox[
  RowBox[{
   RowBox[{"xhat", "=", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}]}], ";"}],
  FontFamily->"Courier New",
  FontSize->14], "\n", 
 StyleBox[
  RowBox[{
   RowBox[{
    RowBox[{"yhat", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]"}],
  FontFamily->"Courier New",
  FontSize->14], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SDI1", "=", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Deltarr", "^", 
         RowBox[{"-", "3"}]}], "*", "xhat"}], ")"}]}], "+", 
     RowBox[{"(", 
      RowBox[{"3", "*", 
       RowBox[{"Deltarr", "^", 
        RowBox[{"-", "5"}]}], "*", 
       RowBox[{"Dot", "[", 
        RowBox[{"xhat", ",", "Deltaxx"}], "]"}], "*", "Deltaxx"}], ")"}], "-", 
     RowBox[{"2", "*", "hbw", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"3", "*", 
           RowBox[{"Deltarr", "^", 
            RowBox[{"-", "5"}]}], "*", 
           RowBox[{"Dot", "[", 
            RowBox[{"xhat", ",", "Deltaxx"}], "]"}], "*", "yhat"}], ")"}]}], 
        "-", 
        RowBox[{"(", 
         RowBox[{"3", "*", 
          RowBox[{"Deltarr", "^", 
           RowBox[{"-", "5"}]}], "*", 
          RowBox[{"Dot", "[", 
           RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "*", "xhat"}], ")"}], "+", 
        RowBox[{"(", 
         RowBox[{"15", "*", 
          RowBox[{"Deltarr", "^", 
           RowBox[{"-", "7"}]}], "*", 
          RowBox[{"Dot", "[", 
           RowBox[{"xhat", ",", "Deltaxx"}], "]"}], "*", 
          RowBox[{"Dot", "[", 
           RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "*", "Deltaxx"}], ")"}]}],
        ")"}]}], "+", 
     RowBox[{"2", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Deltarr", "^", 
           RowBox[{"-", "3"}]}], "*", "xhat"}], ")"}], "+", 
        RowBox[{"(", 
         RowBox[{"15", "*", 
          RowBox[{"Deltarr", "^", 
           RowBox[{"-", "7"}]}], "*", 
          RowBox[{"Dot", "[", 
           RowBox[{"xhat", ",", "Deltaxx"}], "]"}], "*", 
          RowBox[{
           RowBox[{"Dot", "[", 
            RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "^", "2"}], "*", 
          "Deltaxx"}], ")"}], "-", 
        RowBox[{"(", 
         RowBox[{"3", "*", 
          RowBox[{"Deltarr", "^", 
           RowBox[{"-", "5"}]}], "*", 
          RowBox[{"Dot", "[", 
           RowBox[{"xhat", ",", "Deltaxx"}], "]"}], "*", "Deltaxx"}], ")"}], 
        "-", 
        RowBox[{"(", 
         RowBox[{"3", "*", 
          RowBox[{"Deltarr", "^", 
           RowBox[{"-", "5"}]}], "*", 
          RowBox[{
           RowBox[{"Dot", "[", 
            RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "^", "2"}], "*", 
          "xhat"}], ")"}]}], ")"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    StyleBox["SDI2",
     FontFamily->"Courier New",
     FontSize->14], 
    StyleBox["=",
     FontFamily->"Courier New",
     FontSize->14], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"3", "*", 
       RowBox[{"Deltarr", "^", 
        RowBox[{"-", "3"}]}], "*", "yhat"}], ")"}], "-", 
     RowBox[{"(", 
      RowBox[{"9", "*", 
       RowBox[{"Deltarr", "^", 
        RowBox[{"-", "5"}]}], "*", 
       RowBox[{"Dot", "[", 
        RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "*", "Deltaxx"}], ")"}], "+", 
     RowBox[{"2", "*", "hbw", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"6", "*", 
           RowBox[{"Deltarr", "^", 
            RowBox[{"-", "5"}]}], "*", 
           RowBox[{"Dot", "[", 
            RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "*", "yhat"}], ")"}]}], 
        "-", 
        RowBox[{"(", 
         RowBox[{"3", "*", 
          RowBox[{"Deltarr", "^", 
           RowBox[{"-", "5"}]}], "*", "Deltaxx"}], ")"}], "+", 
        RowBox[{"(", 
         RowBox[{"15", "*", 
          RowBox[{"Deltarr", "^", 
           RowBox[{"-", "7"}]}], "*", 
          RowBox[{
           RowBox[{"Dot", "[", 
            RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "^", "2"}], "*", 
          "Deltaxx"}], ")"}]}], ")"}]}], "-", 
     RowBox[{"2", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Deltarr", "^", 
           RowBox[{"-", "3"}]}], "*", "yhat"}], ")"}], "+", 
        RowBox[{"(", 
         RowBox[{"15", "*", 
          RowBox[{"Deltarr", "^", 
           RowBox[{"-", "7"}]}], "*", 
          RowBox[{
           RowBox[{"Dot", "[", 
            RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "^", "3"}], "*", 
          "Deltaxx"}], ")"}], "-", 
        RowBox[{"(", 
         RowBox[{"9", "*", 
          RowBox[{"Deltarr", "^", 
           RowBox[{"-", "5"}]}], "*", 
          RowBox[{"Dot", "[", 
           RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "*", "Deltaxx"}], ")"}], 
        "-", 
        RowBox[{"(", 
         RowBox[{"3", "*", 
          RowBox[{"Deltarr", "^", 
           RowBox[{"-", "5"}]}], "*", 
          RowBox[{
           RowBox[{"Dot", "[", 
            RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "^", "2"}], "*", 
          "yhat"}], ")"}]}], ")"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    StyleBox[
     RowBox[{"S", 
      StyleBox["DI",
       FontFamily->"Courier New",
       FontSize->14]}]], 
    StyleBox["=",
     FontFamily->"Courier New",
     FontSize->14], 
    StyleBox[
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", "psi", "]"}], "*", "SDI1"}], "+", 
      RowBox[{
       RowBox[{"Sin", "[", "psi", "]"}], "*", "SDI2"}]}],
     FontFamily->"Courier New",
     FontSize->14]}], 
   StyleBox[";",
    FontFamily->"Courier New",
    FontSize->14]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DSDipolexx", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"SDI", "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", "x0"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DSDipolexy", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"SDI", "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", "y0"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DSDipoleyx", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"SDI", "[", 
      RowBox[{"[", "2", "]"}], "]"}], ",", "x0"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DSDipoleyy", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"SDI", "[", 
      RowBox[{"[", "2", "]"}], "]"}], ",", "y0"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SQ1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", "psi", "]"}], "*", "DSDipolexx"}], "+", 
    RowBox[{
     RowBox[{"Sin", "[", "psi", "]"}], "*", "DSDipoleyx"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SQ2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", "psi", "]"}], "*", "DSDipolexy"}], "+", 
    RowBox[{
     RowBox[{"Sin", "[", "psi", "]"}], "*", "DSDipoleyy"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SQuad", "=", 
    RowBox[{"{", 
     RowBox[{"SQ1", ",", "SQ2"}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SDipolemod", "=", 
   RowBox[{"SDI", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"w", "+", "y0"}], ")"}], "\[Rule]", "hh"}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SDipoleF", "=", 
   RowBox[{"SDipolemod", 
    StyleBox["+",
     FontFamily->"Courier New",
     FontSize->14], 
    RowBox[{
     StyleBox[
      RowBox[{"(", 
       RowBox[{"1", "/", "6"}], ")"}],
      FontFamily->"Courier New",
      FontSize->14], 
     StyleBox["*",
      FontFamily->"Courier New",
      FontSize->14], 
     RowBox[{"Laplacian", "[", 
      RowBox[{"SDipolemod", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SDipoleFeval", "=", 
   RowBox[{"SDipoleF", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", " ", "x0"}], ",", 
      RowBox[{"y", "\[Rule]", " ", "y0"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "%", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SQuadmod", "=", 
   RowBox[{"SQuad", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"w", "+", "y0"}], ")"}], "\[Rule]", "hh"}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SQuadF", "=", 
   RowBox[{"SQuadmod", 
    StyleBox["+",
     FontFamily->"Courier New",
     FontSize->14], 
    RowBox[{
     StyleBox[
      RowBox[{"(", 
       RowBox[{"1", "/", "6"}], ")"}],
      FontFamily->"Courier New",
      FontSize->14], 
     StyleBox["*",
      FontFamily->"Courier New",
      FontSize->14], 
     RowBox[{"Laplacian", "[", 
      RowBox[{"SQuadmod", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SQuadFeval", "=", 
   RowBox[{"SQuadF", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", " ", "x0"}], ",", 
      RowBox[{"y", "\[Rule]", " ", "y0"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", "%", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"omegasq", "=", 
   RowBox[{"0.5", "*", 
    RowBox[{"Curl", "[", 
     RowBox[{"SQuadmod", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"omegasqeval", "=", 
   RowBox[{"omegasq", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", " ", "x0"}], ",", 
      RowBox[{"y", "\[Rule]", " ", "y0"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", "%", "]"}]}], "Input",
 CellChangeTimes->{{3.8045782392256837`*^9, 3.804578243005721*^9}, {
  3.8045783786730785`*^9, 3.804578384093133*^9}, {3.804578577534068*^9, 
  3.8045785836741295`*^9}, {3.8045786247375402`*^9, 3.8045786759580526`*^9}, {
  3.8045787396826897`*^9, 3.8045787690349836`*^9}, {3.8045788243965373`*^9, 
  3.8045788262875566`*^9}, {3.804578923273527*^9, 3.804578925183546*^9}, {
  3.8045789732450266`*^9, 3.8045789735650296`*^9}, {3.8049341710776863`*^9, 
  3.8049341747777233`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["hh", "2"]}]}], ")"}], " ", 
      RowBox[{"Cos", "[", "psi", "]"}]}], 
     RowBox[{"16", " ", 
      SuperscriptBox["hh", "4"], " ", 
      SqrtBox[
       SuperscriptBox["hh", "2"]]}]]}], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"8", " ", 
        SuperscriptBox["hh", "2"]}]}], ")"}], " ", 
     RowBox[{"Sin", "[", "psi", "]"}]}], 
    RowBox[{"8", " ", 
     SuperscriptBox["hh", "4"], " ", 
     SqrtBox[
      SuperscriptBox["hh", "2"]]}]]}], "}"}]], "Output",
 CellChangeTimes->{3.8049341842688184`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"5", "+", 
        RowBox[{"24", " ", 
         SuperscriptBox["hh", "2"]}]}], ")"}], " ", 
      RowBox[{"Cos", "[", "psi", "]"}], " ", 
      RowBox[{"Sin", "[", "psi", "]"}]}], 
     RowBox[{"64", " ", 
      SuperscriptBox["hh", "5"], " ", 
      SqrtBox[
       SuperscriptBox["hh", "2"]]}]]}], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"-", "75"}], "+", 
     RowBox[{"312", " ", 
      SuperscriptBox["hh", "2"]}], "-", 
     RowBox[{"7", " ", 
      RowBox[{"(", 
       RowBox[{"5", "+", 
        RowBox[{"24", " ", 
         SuperscriptBox["hh", "2"]}]}], ")"}], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "psi"}], "]"}]}]}], 
    RowBox[{"256", " ", 
     SuperscriptBox["hh", "5"], " ", 
     SqrtBox[
      SuperscriptBox["hh", "2"]]}]]}], "}"}]], "Output",
 CellChangeTimes->{3.804934184318819*^9}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"0.75`", " ", 
    SqrtBox[
     SuperscriptBox["hh", "2"]], " ", 
    RowBox[{"Cos", "[", "psi", "]"}], " ", 
    RowBox[{"Sin", "[", "psi", "]"}]}], 
   SuperscriptBox["hh", "6"]]}]], "Output",
 CellChangeTimes->{3.8049341847888236`*^9}]
}, Open  ]],

Cell[BoxData[" "], "Input",
 CellChangeTimes->{3.8049355250542307`*^9}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8049341522054977`*^9, 3.8049341522254972`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8049341506954823`*^9, 3.804934150765483*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8049341490254655`*^9, 3.8049341490854664`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{3.804578921313507*^9}]
},
WindowSize->{1920, 998},
WindowMargins->{{-8, Automatic}, {Automatic, 0}},
Magnification:>1.5 Inherited,
FrontEndVersion->"10.0 for Microsoft Windows (64-bit) (September 9, 2014)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 11885, 392, 1293, "Input"],
Cell[12468, 416, 774, 27, 89, "Output"],
Cell[13245, 445, 956, 32, 89, "Output"],
Cell[14204, 479, 294, 9, 81, "Output"]
}, Open  ]],
Cell[14513, 491, 71, 1, 45, "Input"],
Cell[14587, 494, 96, 1, 45, InheritFromParent],
Cell[14686, 497, 94, 1, 45, InheritFromParent],
Cell[14783, 500, 96, 1, 45, InheritFromParent],
Cell[14882, 503, 68, 1, 45, "Input"]
}
]
*)

(* End of internal cache information *)
