(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     44662,       1337]
NotebookOptionsPosition[     40829,       1232]
NotebookOutlinePosition[     41205,       1248]
CellTagsIndexPosition[     41162,       1245]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData["   "], "Input",
 CellChangeTimes->{3.8072540393420286`*^9, 3.8072591029903083`*^9, 
  3.8072610308448687`*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], "\n", 
 StyleBox[
  RowBox[{
   RowBox[{"xsing", "=", 
    RowBox[{"{", 
     RowBox[{"x0", ",", "y0"}], "}"}]}], ";"}],
  FontFamily->"Courier New",
  FontSize->14], "\n", 
 StyleBox[
  RowBox[{
   RowBox[{"hbw", "=", "h"}], ";"}],
  FontFamily->"Courier New",
  FontSize->14], "\n", 
 StyleBox[
  RowBox[{
   RowBox[{"imgdist", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"2", "*", "h"}]}], "}"}]}], ";"}],
  FontFamily->"Courier New",
  FontSize->14], "\n", 
 StyleBox[
  RowBox[{
   RowBox[{"ximg", "=", 
    RowBox[{"xsing", "-", "imgdist"}]}], ";"}],
  FontFamily->"Courier New",
  FontSize->14], "\n", 
 StyleBox[
  RowBox[{
   RowBox[{"xx", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "^", "1"}], ",", 
      RowBox[{"y", "^", "1"}]}], "}"}]}], ";"}],
  FontFamily->"Courier New",
  FontSize->14], "\n", 
 StyleBox[
  RowBox[{
   RowBox[{"Deltaxx", "=", 
    RowBox[{"xx", "-", "ximg"}]}], ";"}],
  FontFamily->"Courier New",
  FontSize->14], "\n", 
 StyleBox[
  RowBox[{
   RowBox[{"Deltarr", "=", 
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Deltaxx", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"Deltaxx", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "^", "2"}]}], "]"}]}], ";"}],
  FontFamily->"Courier New",
  FontSize->14], "\n", 
 StyleBox[
  RowBox[{
   RowBox[{"xhat", "=", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}]}], ";"}],
  FontFamily->"Courier New",
  FontSize->14], "\n", 
 StyleBox[
  RowBox[{
   RowBox[{
    RowBox[{"yhat", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], ";"}], "\n"}],
  FontFamily->"Courier New",
  FontSize->14], "\[IndentingNewLine]", 
 StyleBox[
  RowBox[{
   RowBox[{
    RowBox[{"FDI1", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Deltarr", "^", 
         RowBox[{"-", "3"}]}], "*", "Deltaxx"}], ")"}], "-", 
      RowBox[{"(", 
       RowBox[{"3", "*", 
        RowBox[{"Deltarr", "^", 
         RowBox[{"-", "5"}]}], "*", 
        RowBox[{
         RowBox[{"Dot", "[", 
          RowBox[{"xhat", ",", "Deltaxx"}], "]"}], "^", "2"}], "*", 
        "Deltaxx"}], ")"}], "+", 
      RowBox[{"2", "*", "hbw", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Deltarr", "^", 
             RowBox[{"-", "3"}]}], "*", "yhat"}], ")"}]}], "+", 
         RowBox[{"(", 
          RowBox[{"15", "*", 
           RowBox[{"Deltarr", "^", 
            RowBox[{"-", "7"}]}], "*", 
           RowBox[{
            RowBox[{"Dot", "[", 
             RowBox[{"xhat", ",", "Deltaxx"}], "]"}], "^", "2"}], "*", 
           RowBox[{"Dot", "[", 
            RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "*", "Deltaxx"}], ")"}], 
         "-", 
         RowBox[{"(", 
          RowBox[{"3", "*", 
           RowBox[{"Deltarr", "^", 
            RowBox[{"-", "5"}]}], "*", 
           RowBox[{"Dot", "[", 
            RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "*", "Deltaxx"}], ")"}], 
         "-", 
         RowBox[{"(", 
          RowBox[{"6", "*", 
           RowBox[{"Deltarr", "^", 
            RowBox[{"-", "5"}]}], "*", 
           RowBox[{"Dot", "[", 
            RowBox[{"xhat", ",", "Deltaxx"}], "]"}], "*", 
           RowBox[{"Dot", "[", 
            RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "*", "xhat"}], ")"}], 
         "+", 
         RowBox[{"(", 
          RowBox[{"3", "*", 
           RowBox[{"Deltarr", "^", 
            RowBox[{"-", "5"}]}], "*", 
           RowBox[{
            RowBox[{"Dot", "[", 
             RowBox[{"xhat", ",", "Deltaxx"}], "]"}], "^", "2"}], "*", 
           "yhat"}], ")"}]}], ")"}]}], "-", 
      RowBox[{"2", "*", 
       RowBox[{"hbw", "^", "2"}], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{"3", "*", 
            RowBox[{"Deltarr", "^", 
             RowBox[{"-", "5"}]}], "*", "Deltaxx"}], ")"}]}], "-", 
         RowBox[{"(", 
          RowBox[{"6", "*", 
           RowBox[{"Deltarr", "^", 
            RowBox[{"-", "5"}]}], "*", 
           RowBox[{"Dot", "[", 
            RowBox[{"xhat", ",", "Deltaxx"}], "]"}], "*", "xhat"}], ")"}], 
         "+", 
         RowBox[{"(", 
          RowBox[{"15", "*", 
           RowBox[{"Deltarr", "^", 
            RowBox[{"-", "7"}]}], "*", 
           RowBox[{
            RowBox[{"Dot", "[", 
             RowBox[{"xhat", ",", "Deltaxx"}], "]"}], "^", "2"}], "*", 
           "Deltaxx"}], ")"}]}], ")"}]}]}]}], ";"}], "\[IndentingNewLine]"}],
  FontFamily->"Courier New",
  FontSize->14], "\n", 
 StyleBox[
  RowBox[{
   RowBox[{
    RowBox[{"FDI2", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Deltarr", "^", 
         RowBox[{"-", "3"}]}], "*", "Deltaxx"}], ")"}], "-", 
      RowBox[{"(", 
       RowBox[{"3", "*", 
        RowBox[{"Deltarr", "^", 
         RowBox[{"-", "5"}]}], "*", 
        RowBox[{
         RowBox[{"Dot", "[", 
          RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "^", "2"}], "*", 
        "Deltaxx"}], ")"}], "+", 
      RowBox[{"4", "*", "hbw", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Deltarr", "^", 
             RowBox[{"-", "3"}]}], "*", "yhat"}], ")"}]}], "+", 
         RowBox[{"(", 
          RowBox[{"3", "*", 
           RowBox[{"Deltarr", "^", 
            RowBox[{"-", "5"}]}], "*", 
           RowBox[{"Dot", "[", 
            RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "*", "Deltaxx"}], 
          ")"}]}], ")"}]}], "-", 
      RowBox[{"2", "*", 
       RowBox[{"hbw", "^", "2"}], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{"3", "*", 
            RowBox[{"Deltarr", "^", 
             RowBox[{"-", "5"}]}], "*", "Deltaxx"}], ")"}]}], "-", 
         RowBox[{"(", 
          RowBox[{"6", "*", 
           RowBox[{"Deltarr", "^", 
            RowBox[{"-", "5"}]}], "*", 
           RowBox[{"Dot", "[", 
            RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "*", "yhat"}], ")"}], 
         "+", 
         RowBox[{"(", 
          RowBox[{"15", "*", 
           RowBox[{"Deltarr", "^", 
            RowBox[{"-", "7"}]}], "*", 
           RowBox[{
            RowBox[{"Dot", "[", 
             RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "^", "2"}], "*", 
           "Deltaxx"}], ")"}]}], ")"}]}], "+", 
      RowBox[{"2", "*", "hbw", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Deltarr", "^", 
            RowBox[{"-", "3"}]}], "*", "yhat"}], ")"}], "+", 
         RowBox[{"(", 
          RowBox[{"15", "*", 
           RowBox[{"Deltarr", "^", 
            RowBox[{"-", "7"}]}], "*", 
           RowBox[{
            RowBox[{"Dot", "[", 
             RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "^", "3"}], "*", 
           "Deltaxx"}], ")"}], "-", 
         RowBox[{"(", 
          RowBox[{"9", "*", 
           RowBox[{"Deltarr", "^", 
            RowBox[{"-", "5"}]}], "*", 
           RowBox[{"Dot", "[", 
            RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "*", "Deltaxx"}], ")"}], 
         "-", 
         RowBox[{"(", 
          RowBox[{"3", "*", 
           RowBox[{"Deltarr", "^", 
            RowBox[{"-", "5"}]}], "*", 
           RowBox[{
            RowBox[{"Dot", "[", 
             RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "^", "2"}], "*", 
           "yhat"}], ")"}]}], ")"}]}]}]}], ";"}], "\[IndentingNewLine]"}],
  FontFamily->"Courier New",
  FontSize->14], "\n", 
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"FDI3", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"6", "*", 
        RowBox[{"Deltarr", "^", 
         RowBox[{"-", "5"}]}], "*", 
        RowBox[{"Dot", "[", 
         RowBox[{"xhat", ",", "Deltaxx"}], "]"}], "*", 
        RowBox[{"Dot", "[", 
         RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "*", "Deltaxx"}], ")"}], 
      "-", 
      RowBox[{"4", "*", "hbw", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Deltarr", "^", 
             RowBox[{"-", "3"}]}], "*", "xhat"}], ")"}]}], "+", 
         RowBox[{"(", 
          RowBox[{"3", "*", 
           RowBox[{"Deltarr", "^", 
            RowBox[{"-", "5"}]}], "*", 
           RowBox[{"Dot", "[", 
            RowBox[{"xhat", ",", "Deltaxx"}], "]"}], "*", "Deltaxx"}], 
          ")"}]}], ")"}]}], "+", 
      RowBox[{"4", "*", 
       RowBox[{"hbw", "^", "2"}], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{"3", "*", 
            RowBox[{"Deltarr", "^", 
             RowBox[{"-", "5"}]}], "*", 
            RowBox[{"Dot", "[", 
             RowBox[{"xhat", ",", "Deltaxx"}], "]"}], "*", "yhat"}], ")"}]}], 
         "-", 
         RowBox[{"(", 
          RowBox[{"3", "*", 
           RowBox[{"Deltarr", "^", 
            RowBox[{"-", "5"}]}], "*", 
           RowBox[{"Dot", "[", 
            RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "*", "xhat"}], ")"}], 
         "+", 
         RowBox[{"(", 
          RowBox[{"15", "*", 
           RowBox[{"Deltarr", "^", 
            RowBox[{"-", "7"}]}], "*", 
           RowBox[{"Dot", "[", 
            RowBox[{"xhat", ",", "Deltaxx"}], "]"}], "*", 
           RowBox[{"Dot", "[", 
            RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "*", "Deltaxx"}], 
          ")"}]}], ")"}]}], "-", 
      RowBox[{"4", "*", "hbw", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Deltarr", "^", 
             RowBox[{"-", "3"}]}], "*", "xhat"}], ")"}]}], "+", 
         RowBox[{"(", 
          RowBox[{"15", "*", 
           RowBox[{"Deltarr", "^", 
            RowBox[{"-", "7"}]}], "*", 
           RowBox[{"Dot", "[", 
            RowBox[{"xhat", ",", "Deltaxx"}], "]"}], "*", 
           RowBox[{
            RowBox[{"Dot", "[", 
             RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "^", "2"}], "*", 
           "Deltaxx"}], ")"}], "-", 
         RowBox[{"(", 
          RowBox[{"3", "*", 
           RowBox[{"Deltarr", "^", 
            RowBox[{"-", "5"}]}], "*", 
           RowBox[{"Dot", "[", 
            RowBox[{"xhat", ",", "Deltaxx"}], "]"}], "*", "Deltaxx"}], ")"}], 
         "-", 
         RowBox[{"(", 
          RowBox[{"3", "*", 
           RowBox[{"Deltarr", "^", 
            RowBox[{"-", "5"}]}], "*", 
           RowBox[{
            RowBox[{"Dot", "[", 
             RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "^", "2"}], "*", 
           "xhat"}], ")"}]}], ")"}]}]}]}], ";"}],
   FontFamily->"Courier New",
   FontSize->14], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SDI1", "=", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Deltarr", "^", 
         RowBox[{"-", "3"}]}], "*", "xhat"}], ")"}]}], "+", 
     RowBox[{"(", 
      RowBox[{"3", "*", 
       RowBox[{"Deltarr", "^", 
        RowBox[{"-", "5"}]}], "*", 
       RowBox[{"Dot", "[", 
        RowBox[{"xhat", ",", "Deltaxx"}], "]"}], "*", "Deltaxx"}], ")"}], "-", 
     RowBox[{"2", "*", "hbw", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"3", "*", 
           RowBox[{"Deltarr", "^", 
            RowBox[{"-", "5"}]}], "*", 
           RowBox[{"Dot", "[", 
            RowBox[{"xhat", ",", "Deltaxx"}], "]"}], "*", "yhat"}], ")"}]}], 
        "-", 
        RowBox[{"(", 
         RowBox[{"3", "*", 
          RowBox[{"Deltarr", "^", 
           RowBox[{"-", "5"}]}], "*", 
          RowBox[{"Dot", "[", 
           RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "*", "xhat"}], ")"}], "+", 
        RowBox[{"(", 
         RowBox[{"15", "*", 
          RowBox[{"Deltarr", "^", 
           RowBox[{"-", "7"}]}], "*", 
          RowBox[{"Dot", "[", 
           RowBox[{"xhat", ",", "Deltaxx"}], "]"}], "*", 
          RowBox[{"Dot", "[", 
           RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "*", "Deltaxx"}], ")"}]}],
        ")"}]}], "+", 
     RowBox[{"2", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Deltarr", "^", 
           RowBox[{"-", "3"}]}], "*", "xhat"}], ")"}], "+", 
        RowBox[{"(", 
         RowBox[{"15", "*", 
          RowBox[{"Deltarr", "^", 
           RowBox[{"-", "7"}]}], "*", 
          RowBox[{"Dot", "[", 
           RowBox[{"xhat", ",", "Deltaxx"}], "]"}], "*", 
          RowBox[{
           RowBox[{"Dot", "[", 
            RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "^", "2"}], "*", 
          "Deltaxx"}], ")"}], "-", 
        RowBox[{"(", 
         RowBox[{"3", "*", 
          RowBox[{"Deltarr", "^", 
           RowBox[{"-", "5"}]}], "*", 
          RowBox[{"Dot", "[", 
           RowBox[{"xhat", ",", "Deltaxx"}], "]"}], "*", "Deltaxx"}], ")"}], 
        "-", 
        RowBox[{"(", 
         RowBox[{"3", "*", 
          RowBox[{"Deltarr", "^", 
           RowBox[{"-", "5"}]}], "*", 
          RowBox[{
           RowBox[{"Dot", "[", 
            RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "^", "2"}], "*", 
          "xhat"}], ")"}]}], ")"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    StyleBox["SDI2",
     FontFamily->"Courier New",
     FontSize->14], 
    StyleBox["=",
     FontFamily->"Courier New",
     FontSize->14], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"3", "*", 
       RowBox[{"Deltarr", "^", 
        RowBox[{"-", "3"}]}], "*", "yhat"}], ")"}], "-", 
     RowBox[{"(", 
      RowBox[{"9", "*", 
       RowBox[{"Deltarr", "^", 
        RowBox[{"-", "5"}]}], "*", 
       RowBox[{"Dot", "[", 
        RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "*", "Deltaxx"}], ")"}], "+", 
     RowBox[{"2", "*", "hbw", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"6", "*", 
           RowBox[{"Deltarr", "^", 
            RowBox[{"-", "5"}]}], "*", 
           RowBox[{"Dot", "[", 
            RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "*", "yhat"}], ")"}]}], 
        "-", 
        RowBox[{"(", 
         RowBox[{"3", "*", 
          RowBox[{"Deltarr", "^", 
           RowBox[{"-", "5"}]}], "*", "Deltaxx"}], ")"}], "+", 
        RowBox[{"(", 
         RowBox[{"15", "*", 
          RowBox[{"Deltarr", "^", 
           RowBox[{"-", "7"}]}], "*", 
          RowBox[{
           RowBox[{"Dot", "[", 
            RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "^", "2"}], "*", 
          "Deltaxx"}], ")"}]}], ")"}]}], "-", 
     RowBox[{"2", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Deltarr", "^", 
           RowBox[{"-", "3"}]}], "*", "yhat"}], ")"}], "+", 
        RowBox[{"(", 
         RowBox[{"15", "*", 
          RowBox[{"Deltarr", "^", 
           RowBox[{"-", "7"}]}], "*", 
          RowBox[{
           RowBox[{"Dot", "[", 
            RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "^", "3"}], "*", 
          "Deltaxx"}], ")"}], "-", 
        RowBox[{"(", 
         RowBox[{"9", "*", 
          RowBox[{"Deltarr", "^", 
           RowBox[{"-", "5"}]}], "*", 
          RowBox[{"Dot", "[", 
           RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "*", "Deltaxx"}], ")"}], 
        "-", 
        RowBox[{"(", 
         RowBox[{"3", "*", 
          RowBox[{"Deltarr", "^", 
           RowBox[{"-", "5"}]}], "*", 
          RowBox[{
           RowBox[{"Dot", "[", 
            RowBox[{"yhat", ",", "Deltaxx"}], "]"}], "^", "2"}], "*", 
          "yhat"}], ")"}]}], ")"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 StyleBox[
  RowBox[{
   RowBox[{"FDI", "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", "psi", "]"}], "^", "2"}], "*", "FDI1"}], "+", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", "psi", "]"}], "^", "2"}], "*", "FDI2"}], "+", 
     RowBox[{"0.5", "*", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", "*", "psi"}], "]"}], "*", "FDI3"}]}]}], ";"}],
  FontFamily->"Courier New",
  FontSize->14], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    StyleBox[
     RowBox[{"S", 
      StyleBox["DI",
       FontFamily->"Courier New",
       FontSize->14]}]], 
    StyleBox["=",
     FontFamily->"Courier New",
     FontSize->14], 
    StyleBox[
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", "psi", "]"}], "*", "SDI1"}], "+", 
      RowBox[{
       RowBox[{"Sin", "[", "psi", "]"}], "*", "SDI2"}]}],
     FontFamily->"Courier New",
     FontSize->14]}], 
   StyleBox[";",
    FontFamily->"Courier New",
    FontSize->14]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   StyleBox["check1",
    FontFamily->"Courier New",
    FontSize->14], 
   StyleBox["=",
    FontFamily->"Courier New",
    FontSize->14], 
   RowBox[{"FDI", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", " ", "x0"}], ",", 
      RowBox[{"y", "\[Rule]", " ", "y0"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    StyleBox["check2",
     FontFamily->"Courier New",
     FontSize->14], 
    StyleBox["=",
     FontFamily->"Courier New",
     FontSize->14], 
    RowBox[{
     StyleBox[
      RowBox[{
       StyleBox["S",
        FontFamily->"Courier New",
        FontSize->14], "DI"}]], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", " ", "x0"}], ",", 
       RowBox[{"y", "\[Rule]", " ", "y0"}]}], "}"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   StyleBox["Term3A",
    FontFamily->"Courier New",
    FontSize->14], 
   StyleBox["=",
    FontFamily->"Courier New",
    FontSize->14], 
   RowBox[{
    StyleBox["FDI",
     FontFamily->"Courier New",
     FontSize->14], 
    StyleBox["+",
     FontFamily->"Courier New",
     FontSize->14], 
    RowBox[{
     StyleBox[
      RowBox[{"(", 
       RowBox[{"1", "/", "6"}], ")"}],
      FontFamily->"Courier New",
      FontSize->14], 
     StyleBox["*",
      FontFamily->"Courier New",
      FontSize->14], 
     RowBox[{"Laplacian", "[", 
      RowBox[{"FDI", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Term3Aeval", "=", 
   RowBox[{"Term3A", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", " ", "x0"}], ",", 
      RowBox[{"y", "\[Rule]", " ", "y0"}]}], "}"}]}]}], ";"}], "\n", 
 RowBox[{"Simplify", "[", "%", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   StyleBox["Term3B",
    FontFamily->"Courier New",
    FontSize->14], 
   StyleBox["=",
    FontFamily->"Courier New",
    FontSize->14], 
   RowBox[{
    StyleBox["SDI",
     FontFamily->"Courier New",
     FontSize->14], 
    StyleBox["+",
     FontFamily->"Courier New",
     FontSize->14], 
    RowBox[{
     StyleBox[
      RowBox[{"(", 
       RowBox[{"1", "/", "6"}], ")"}],
      FontFamily->"Courier New",
      FontSize->14], 
     StyleBox["*",
      FontFamily->"Courier New",
      FontSize->14], 
     RowBox[{"Laplacian", "[", 
      RowBox[{"SDI", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Term3Beval", "=", 
   RowBox[{"Term3B", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", " ", "x0"}], ",", 
      RowBox[{"y", "\[Rule]", " ", "y0"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", "%", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"uflow", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "c1"}], "*", "ufa", "*", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{
         RowBox[{"y", "^", "2"}], "*", 
         RowBox[{"l", "^", "2"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "/", "3"}], ")"}], "*", 
         RowBox[{"l", "^", "2"}]}]}], ")"}]}], ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"utotal", "=", 
   RowBox[{"uflow", "+", 
    RowBox[{"alpha", "*", "FDI"}], "+", 
    RowBox[{"beta", "*", "SDI"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"omegaxy", "=", 
   RowBox[{"0.5", "*", 
    RowBox[{"Curl", "[", 
     RowBox[{"utotal", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"omegaxyeval", "=", 
   RowBox[{"omegaxy", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", " ", "x0"}], ",", 
      RowBox[{"y", "\[Rule]", " ", "y0"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", "%", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"omegacheck1", "=", 
   RowBox[{"0.5", "*", 
    RowBox[{"Curl", "[", 
     RowBox[{
      RowBox[{"alpha", "*", "FDI"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"omegavalcheck1", "=", 
    RowBox[{"omegacheck1", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", " ", "x0"}], ",", 
       RowBox[{"y", "\[Rule]", " ", "y0"}]}], "}"}]}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", "%", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"omegacheck2", "=", 
   RowBox[{"0.5", "*", 
    RowBox[{"Curl", "[", 
     RowBox[{
      RowBox[{"beta", "*", "SDI"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"omegavalcheck2", "=", 
    RowBox[{"omegacheck2", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", " ", "x0"}], ",", 
       RowBox[{"y", "\[Rule]", " ", "y0"}]}], "}"}]}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", "%", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xcomp", "=", 
   RowBox[{
    RowBox[{"Term3Aeval", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "+", 
    RowBox[{"Term3Beval", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", "%", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ycomp", "=", 
   RowBox[{
    RowBox[{"Term3Aeval", "[", 
     RowBox[{"[", "2", "]"}], "]"}], "+", 
    RowBox[{"Term3Beval", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", "%", "]"}]}], "Input",
 CellChangeTimes->{{3.799741028810018*^9, 3.799741028820018*^9}, 
   3.7997421528550177`*^9, {3.799742206368018*^9, 3.799742269658018*^9}, {
   3.799742427266018*^9, 3.799742450936018*^9}, {3.799742504627018*^9, 
   3.799742520380018*^9}, {3.7997425772010183`*^9, 3.799742674622018*^9}, {
   3.799742709595018*^9, 3.7997427506760178`*^9}, {3.799742841599018*^9, 
   3.799742945224018*^9}, {3.799743136599018*^9, 3.799743156489018*^9}, {
   3.799743530207018*^9, 3.799743546247018*^9}, {3.799743595371018*^9, 
   3.7997436342220182`*^9}, {3.799744091130018*^9, 3.799744109861018*^9}, {
   3.799745593310018*^9, 3.799745601370018*^9}, {3.799745656243018*^9, 
   3.799745673304018*^9}, {3.7997464346750183`*^9, 3.799746441705018*^9}, {
   3.799746656611018*^9, 3.799746667132018*^9}, {3.7997467920430183`*^9, 
   3.799746793393018*^9}, {3.799746900818018*^9, 3.799747175823018*^9}, {
   3.799747277036018*^9, 3.799747285286018*^9}, {3.799747430481018*^9, 
   3.7997474381310177`*^9}, {3.799748493478018*^9, 3.7997485004180183`*^9}, {
   3.799748587030018*^9, 3.799748591930018*^9}, 3.799748660593018*^9, {
   3.799748791547018*^9, 3.7997488228080177`*^9}, {3.7997490849840183`*^9, 
   3.799749092894018*^9}, {3.799749371410018*^9, 3.799749391580018*^9}, {
   3.799749478501018*^9, 3.7997494936420183`*^9}, {3.799749556944018*^9, 
   3.7997495689840183`*^9}, {3.799749717728018*^9, 3.799749719628018*^9}, {
   3.7997497834000177`*^9, 3.799749784080018*^9}, {3.799749901912018*^9, 
   3.799749917132018*^9}, {3.799750260710018*^9, 3.799750263740018*^9}, {
   3.799750364502018*^9, 3.799750370082018*^9}, {3.799750504145018*^9, 
   3.799750511045018*^9}, {3.799750741629018*^9, 3.799750760259018*^9}, {
   3.799751200569018*^9, 3.799751221121018*^9}, {3.8000846858911514`*^9, 
   3.800084695481151*^9}, {3.800084810902151*^9, 3.8000848572731514`*^9}, {
   3.8000849034431515`*^9, 3.800084903763151*^9}, {3.8000849963861513`*^9, 
   3.800085162727151*^9}, 3.800085196618151*^9, {3.800085240569151*^9, 
   3.800085365921151*^9}, {3.8000853981811514`*^9, 3.800085398361151*^9}, {
   3.8000854292421513`*^9, 3.8000854729431515`*^9}, {3.8000855587941513`*^9, 
   3.800085570994151*^9}, {3.800085778007151*^9, 3.800085789547151*^9}, {
   3.800085825928151*^9, 3.800085864029151*^9}, {3.8000859153701515`*^9, 
   3.800085972040151*^9}, {3.800086003991151*^9, 3.800086232404151*^9}, {
   3.800090575300151*^9, 3.800090757225151*^9}, 3.800090797006151*^9, {
   3.800097655012162*^9, 3.8000976708731623`*^9}, {3.800097704753162*^9, 
   3.8000977562741623`*^9}, {3.800098014780162*^9, 3.800098015930162*^9}, {
   3.8002592762207346`*^9, 3.800259279920735*^9}, {3.800259457704735*^9, 
   3.800259553619735*^9}, {3.800259591729735*^9, 3.8002595941997347`*^9}, {
   3.800259904591735*^9, 3.800259927171735*^9}, {3.8002601123667345`*^9, 
   3.800260134466735*^9}, {3.800260429905735*^9, 3.800260589579735*^9}, {
   3.800265314917735*^9, 3.800265321497735*^9}, {3.8002653918897347`*^9, 
   3.8002653929097347`*^9}, {3.800868328538721*^9, 3.800868329543822*^9}, {
   3.8008684030123053`*^9, 3.8008684048191247`*^9}, {3.8012958374913483`*^9, 
   3.801296005888348*^9}, {3.801296037509348*^9, 3.8012960467493477`*^9}, {
   3.801296860095348*^9, 3.801296861155348*^9}, {3.801296916687348*^9, 
   3.801296917537348*^9}, {3.801297001678348*^9, 3.801297005648348*^9}, {
   3.8012971135323477`*^9, 3.8012971238523483`*^9}, {3.8027593988823986`*^9, 
   3.802759495954399*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"0.078125`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.875`", " ", 
        SuperscriptBox["h", "2"]}]}], ")"}], " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "psi"}], "]"}]}], 
    RowBox[{
     SuperscriptBox["h", "3"], " ", 
     SqrtBox[
      SuperscriptBox["h", "2"]]}]], ",", 
   FractionBox[
    RowBox[{"3", "+", 
     RowBox[{"24", " ", 
      SuperscriptBox["h", "2"]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"11", "-", 
        RowBox[{"72", " ", 
         SuperscriptBox["h", "2"]}]}], ")"}], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "psi"}], "]"}]}]}], 
    RowBox[{"128", " ", 
     SuperscriptBox["h", "3"], " ", 
     SqrtBox[
      SuperscriptBox["h", "2"]]}]]}], "}"}]], "Output",
 CellChangeTimes->{3.802759502534399*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["h", "2"]}]}], ")"}], " ", 
      RowBox[{"Cos", "[", "psi", "]"}]}], 
     RowBox[{"16", " ", 
      SuperscriptBox["h", "4"], " ", 
      SqrtBox[
       SuperscriptBox["h", "2"]]}]]}], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"8", " ", 
        SuperscriptBox["h", "2"]}]}], ")"}], " ", 
     RowBox[{"Sin", "[", "psi", "]"}]}], 
    RowBox[{"8", " ", 
     SuperscriptBox["h", "4"], " ", 
     SqrtBox[
      SuperscriptBox["h", "2"]]}]]}], "}"}]], "Output",
 CellChangeTimes->{3.8027595025543985`*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "c1", " ", "h", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["h", "2"], ")"}], 
     RowBox[{"3", "/", "2"}]], " ", 
    SuperscriptBox["l", "2"], " ", "ufa", " ", "y0"}], "+", 
   RowBox[{"0.375`", " ", "beta", " ", 
    RowBox[{"Cos", "[", "psi", "]"}]}], "+", 
   RowBox[{"0.375`", " ", "alpha", " ", "h", " ", 
    RowBox[{"Cos", "[", "psi", "]"}], " ", 
    RowBox[{"Sin", "[", "psi", "]"}]}]}], 
  RowBox[{
   SuperscriptBox["h", "3"], " ", 
   SqrtBox[
    SuperscriptBox["h", "2"]]}]]], "Output",
 CellChangeTimes->{3.802759502754399*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"0.1875`", " ", "alpha", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"2", " ", "psi"}], "]"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    SuperscriptBox["h", "2"], ")"}], 
   RowBox[{"3", "/", "2"}]]]], "Output",
 CellChangeTimes->{3.802759502774399*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"0.375`", " ", "beta", " ", 
   SqrtBox[
    SuperscriptBox["h", "2"]], " ", 
   RowBox[{"Cos", "[", "psi", "]"}]}], 
  SuperscriptBox["h", "5"]]], "Output",
 CellChangeTimes->{3.802759502774399*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"0.1875000000000002`", "\[VeryThinSpace]", "-", 
      RowBox[{"0.25000000000000006`", " ", 
       SuperscriptBox["h", "2"]}]}], ")"}], " ", 
    RowBox[{"Cos", "[", "psi", "]"}]}], "+", 
   RowBox[{"h", " ", 
    RowBox[{"(", 
     RowBox[{"0.078125`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.875`", " ", 
       SuperscriptBox["h", "2"]}]}], ")"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"2", " ", "psi"}], "]"}]}]}], 
  RowBox[{
   SuperscriptBox["h", "4"], " ", 
   SqrtBox[
    SuperscriptBox["h", "2"]]}]]], "Output",
 CellChangeTimes->{3.802759502794399*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"3", " ", 
    RowBox[{"(", 
     RowBox[{"h", "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["h", "3"]}]}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"11", " ", "h"}], "-", 
      RowBox[{"72", " ", 
       SuperscriptBox["h", "3"]}]}], ")"}], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "psi"}], "]"}]}], "-", 
   RowBox[{"16", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["h", "2"]}]}], ")"}], " ", 
    RowBox[{"Sin", "[", "psi", "]"}]}]}], 
  RowBox[{"128", " ", 
   SuperscriptBox["h", "4"], " ", 
   SqrtBox[
    SuperscriptBox["h", "2"]]}]]], "Output",
 CellChangeTimes->{3.8027595028443985`*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{3.8027594721443987`*^9}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.802759273109399*^9, 3.8027592731393986`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8027592713893986`*^9, 3.802759271419399*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8027592699593987`*^9, 3.802759269989399*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.802759268789399*^9, 3.802759268819399*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.802759267239399*^9, 3.802759267289399*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.801296994248348*^9, 3.801297044540348*^9}, 
   3.801297111232348*^9}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.801296992548348*^9, 3.801296992578348*^9}, {
  3.801297095302348*^9, 3.801297099092348*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.801296991148348*^9, 3.8012969911683483`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.801296988408348*^9, 3.801296988468348*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Curl", "::", "ndimv"}], "MessageName"], ":", 
  " ", "\<\"There is no \[NoBreak]\\!\\(3\\)\[NoBreak]-dimensional curl for \
the \[NoBreak]\\!\\(2\\)\[NoBreak]-dimensional vector \
\[NoBreak]\\!\\({\\(\\(0.5`\\\\ alpha\\\\ \\(\\((\\(\\(-\\(\\(\\(3\\\\ \
h\\^3\\)\\/\\(4\\\\ \\((h\\^2)\\)\\^\\(5/2\\)\\)\\)\\)\\)\\) + \\(5\\\\ \
h\\)\\/\\(2\\\\ \\((h\\^2)\\)\\^\\(3/2\\)\\))\\)\\)\\\\ \\(\\(Sin[\\(\\(2\\\\ \
psi\\)\\)]\\)\\)\\)\\), \\(\\(alpha\\\\ \\(\\((\\(\\(0.` \
\[VeryThinSpace]\\)\\) + \\(\\(\\(\\((\\(3\\\\ h\\^3\\)\\/\\(8\\\\ \\((h\\^2)\
\\)\\^\\(5/2\\)\\) - \\(3\\\\ h\\)\\/\\(4\\\\ \
\\((h\\^2)\\)\\^\\(3/2\\)\\))\\)\\)\\\\ \\(Cos[psi]\\)\\^2\\)\\) + \
\\(\\(\\(\\((\\(\\(-\\(\\(\\(3\\\\ h\\^3\\)\\/\\(4\\\\ \\((h\\^2)\\)\\^\\(5/2\
\\)\\)\\)\\)\\)\\) + \\(5\\\\ h\\)\\/\\(4\\\\ \\((h\\^2)\\)\\^\\(3/2\\)\\) - \
\\(\\(2\\\\ h\\^2\\\\ \\(\\((\\(\\(15\\/16\\\\ \\(\\(Power[\\(\\(\
\[LeftSkeleton] 2 \[RightSkeleton]\\)\\)]\\)\\)\\\\ \\(\\(Power[\\(\\(\
\[LeftSkeleton] 2 \[RightSkeleton]\\)\\)]\\)\\)\\)\\) - \\(\\(9\\/16\\\\ \
h\\\\ \\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\)\\)\\))\\)\\)\\)\\) + \\(\\(2\\\\ h\\\\ \
\\(\\((\\(\\(15\\/8\\\\ \\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\)\\\\ \\(\\(Power[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\)\\)\\) - \\(\\(11\\/8\\\\ \\(\\(Power[\\(\\(\
\[LeftSkeleton] 2 \[RightSkeleton]\\)\\)]\\)\\)\\)\\))\\)\\)\\)\\))\\)\\)\\\\ \
\\(Sin[psi]\\)\\^2\\)\\))\\)\\)\\)\\)}\\)\[NoBreak]. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/Curl\\\", ButtonNote -> \
\\\"Curl::ndimv\\\"]\\)\"\>"}]], "Message", "MSG",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.801296868005348*^9, {3.8012969101573477`*^9, 3.801296910967348*^9}, 
   3.802759265539399*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.801296907547348*^9, 3.801296907607348*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8012968548523483`*^9, 3.801296854872348*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.801296853622348*^9, 3.801296853652348*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.801296852272348*^9, 3.801296852302348*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8012968507023478`*^9, 3.801296850752348*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{3.801296035339348*^9}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8012960334593477`*^9, 3.801296033479348*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.801295638863348*^9, 3.801295638883348*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.801295635553348*^9, 3.8012956355833483`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.801295633803348*^9, 3.801295633853348*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.800265389079735*^9, 3.800265389089735*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8002653859497347`*^9, 3.8002653876097345`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8002653840697346`*^9, 3.800265384099735*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8002653739397345`*^9, 3.8002653739897346`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.800265309467735*^9, 3.800265311657735*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.800265304287735*^9, 3.8002653042977347`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.800265302197735*^9, 3.800265302257735*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.800258035072735*^9, 3.8002580351027346`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.800258033362735*^9, 3.8002580334227347`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.800098217405162*^9, 3.8000982174251623`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8000982154251623`*^9, 3.800098215455162*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.800098212995162*^9, 3.8000982130251617`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8000982109651623`*^9, 3.800098211055162*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.800097661393162*^9, 3.800097661423162*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8000908000561514`*^9, 3.8000908067071514`*^9}, 
   3.800097658983162*^9}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.800097657993162*^9, 3.800097658063162*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8000907937851515`*^9, 3.800090793805151*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8000863636171513`*^9, 3.800086368647151*^9}, {
  3.800090790015151*^9, 3.8000907916151514`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.800090788915151*^9, 3.800090788975151*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8000863593071513`*^9, 3.800086359317151*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.800086357797151*^9, 3.800086357817151*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.800084680470151*^9, 3.8000846804901514`*^9}, {
  3.800086298066151*^9, 3.800086356257151*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.800086355197151*^9, 3.8000863552471514`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8000863266671515`*^9, 3.800086326717151*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8000863085961514`*^9, 3.8000863086461515`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8000862582151513`*^9, 3.800086292826151*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.800086290216151*^9, 3.800086290276151*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.800084368454151*^9, 3.800084377704151*^9}, 
   3.800084681730151*^9}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.800084678480151*^9, 3.8000846785301514`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8000843625541515`*^9, 3.8000843626341515`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.7997512189210176`*^9, 3.799751218971018*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.799750769559018*^9, 3.799750782200018*^9}, 
   3.799751215530018*^9}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.799751213520018*^9, 3.799751213570018*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.799750752549018*^9, 3.799750752579018*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.7997504744840183`*^9, 3.7997504745840178`*^9}, {
   3.799750525936018*^9, 3.7997505348660183`*^9}, 3.799750750199018*^9}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.799750749009018*^9, 3.799750749069018*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.7997504780640182`*^9, 3.7997504780840178`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.7997499263520184`*^9, 3.7997499264720182`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.799749930672018*^9, 3.799749930712018*^9}, {
   3.7997504400830183`*^9, 3.799750447443018*^9}, 3.7997504796640177`*^9}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.799750476304018*^9, 3.7997504763140182`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.799749797110018*^9, 3.799749797210018*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.799749729278018*^9, 3.7997497293480177`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.799749734628018*^9, 3.799749734728018*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{3.799749551634018*^9}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.799749341429018*^9, 3.7997493414990177`*^9}, 
   3.799749514413018*^9, 3.799749550594018*^9}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.7997495486640177`*^9, 3.799749548714018*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.799749345349018*^9, 3.799749345389018*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.799748861569018*^9, 3.7997488626490183`*^9}, {
   3.799749157955018*^9, 3.799749164845018*^9}, 3.799749351020018*^9}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.7997493491090183`*^9, 3.799749349119018*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.799748699434018*^9, 3.799748699684018*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.799748641393018*^9, 3.799748641413018*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.799748536989018*^9, 3.7997485388590183`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.799748546759018*^9, 3.7997485469990177`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.799747590325018*^9, 3.799747590345018*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.799747585325018*^9, 3.799747585505018*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.7997473689990177`*^9, 3.799747369019018*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.799747365969018*^9, 3.799747366079018*^9}}],

Cell[BoxData[" "], "Input",
 CellChangeTimes->{3.799745556969018*^9}]
},
WindowSize->{1904, 998},
WindowMargins->{{-8, Automatic}, {Automatic, 0}},
Magnification:>1.3 Inherited,
FrontEndVersion->"10.0 for Microsoft Windows (64-bit) (September 9, 2014)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 124, 2, 39, "Input"],
Cell[CellGroupData[{
Cell[707, 26, 25941, 768, 1590, "Input"],
Cell[26651, 796, 889, 30, 70, "Output"],
Cell[27543, 828, 768, 27, 70, "Output"],
Cell[28314, 857, 649, 19, 71, "Output"],
Cell[28966, 878, 289, 9, 68, "Output"],
Cell[29258, 889, 237, 7, 66, "Output"],
Cell[29498, 898, 656, 20, 70, "Output"],
Cell[30157, 920, 773, 27, 70, "Output"]
}, Open  ]],
Cell[30945, 950, 70, 1, 39, "Input"],
Cell[31018, 953, 94, 1, 39, "Input"],
Cell[31115, 956, 94, 1, 39, "Input"],
Cell[31212, 959, 94, 1, 39, "Input"],
Cell[31309, 962, 92, 1, 39, "Input"],
Cell[31404, 965, 92, 1, 39, "Input"],
Cell[31499, 968, 118, 2, 39, "Input"],
Cell[31620, 972, 141, 2, 39, "Input"],
Cell[31764, 976, 94, 1, 39, "Input"],
Cell[CellGroupData[{
Cell[31883, 981, 92, 1, 39, "Input"],
Cell[31978, 984, 1906, 32, 93, "Message"]
}, Open  ]],
Cell[33899, 1019, 92, 1, 39, "Input"],
Cell[33994, 1022, 94, 1, 50, "Input"],
Cell[34091, 1025, 92, 1, 50, "Input"],
Cell[34186, 1028, 92, 1, 50, "Input"],
Cell[34281, 1031, 94, 1, 50, "Input"],
Cell[34378, 1034, 68, 1, 50, "Input"],
Cell[34449, 1037, 94, 1, 50, "Input"],
Cell[34546, 1040, 92, 1, 50, "Input"],
Cell[34641, 1043, 94, 1, 50, "Input"],
Cell[34738, 1046, 92, 1, 50, "Input"],
Cell[34833, 1049, 92, 1, 50, "Input"],
Cell[34928, 1052, 96, 1, 50, "Input"],
Cell[35027, 1055, 94, 1, 50, "Input"],
Cell[35124, 1058, 96, 1, 50, "Input"],
Cell[35223, 1061, 92, 1, 50, "Input"],
Cell[35318, 1064, 94, 1, 50, "Input"],
Cell[35415, 1067, 92, 1, 50, "Input"],
Cell[35510, 1070, 94, 1, 50, "Input"],
Cell[35607, 1073, 94, 1, 50, "Input"],
Cell[35704, 1076, 94, 1, 50, "Input"],
Cell[35801, 1079, 94, 1, 50, "Input"],
Cell[35898, 1082, 94, 1, 50, "Input"],
Cell[35995, 1085, 94, 1, 50, "Input"],
Cell[36092, 1088, 92, 1, 50, "Input"],
Cell[36187, 1091, 122, 2, 50, "Input"],
Cell[36312, 1095, 92, 1, 84, "Input"],
Cell[36407, 1098, 94, 1, 84, "Input"],
Cell[36504, 1101, 145, 2, 84, "Input"],
Cell[36652, 1105, 92, 1, 84, "Input"],
Cell[36747, 1108, 94, 1, 84, "Input"],
Cell[36844, 1111, 92, 1, 84, "Input"],
Cell[36939, 1114, 143, 2, 84, "Input"],
Cell[37085, 1118, 94, 1, 84, "Input"],
Cell[37182, 1121, 94, 1, 84, "Input"],
Cell[37279, 1124, 96, 1, 84, "Input"],
Cell[37378, 1127, 94, 1, 153, "Input"],
Cell[37475, 1130, 92, 1, 141, "Input"],
Cell[37570, 1133, 118, 2, 141, "Input"],
Cell[37691, 1137, 94, 1, 141, "Input"],
Cell[37788, 1140, 96, 1, 141, "Input"],
Cell[37887, 1143, 94, 1, 211, "Input"],
Cell[37984, 1146, 118, 2, 318, "Input"],
Cell[38105, 1150, 92, 1, 318, "Input"],
Cell[38200, 1153, 92, 1, 318, "Input"],
Cell[38295, 1156, 170, 2, 318, "Input"],
Cell[38468, 1160, 92, 1, 318, "Input"],
Cell[38563, 1163, 96, 1, 318, "Input"],
Cell[38662, 1166, 96, 1, 318, "Input"],
Cell[38761, 1169, 168, 2, 318, "Input"],
Cell[38932, 1173, 94, 1, 318, "Input"],
Cell[39029, 1176, 92, 1, 318, "Input"],
Cell[39124, 1179, 94, 1, 318, "Input"],
Cell[39221, 1182, 92, 1, 318, "Input"],
Cell[39316, 1185, 68, 1, 318, "Input"],
Cell[39387, 1188, 142, 2, 318, "Input"],
Cell[39532, 1192, 94, 1, 318, "Input"],
Cell[39629, 1195, 92, 1, 318, "Input"],
Cell[39724, 1198, 166, 2, 318, "Input"],
Cell[39893, 1202, 94, 1, 318, "Input"],
Cell[39990, 1205, 92, 1, 318, "Input"],
Cell[40085, 1208, 92, 1, 318, "Input"],
Cell[40180, 1211, 94, 1, 318, "Input"],
Cell[40277, 1214, 94, 1, 479, InheritFromParent],
Cell[40374, 1217, 92, 1, 479, InheritFromParent],
Cell[40469, 1220, 92, 1, 479, InheritFromParent],
Cell[40564, 1223, 94, 1, 479, InheritFromParent],
Cell[40661, 1226, 92, 1, 479, InheritFromParent],
Cell[40756, 1229, 69, 1, 479, "Input"]
}
]
*)

(* End of internal cache information *)
