SloFor wave flume data
======================

Data set contents
-----------------

This data set features 18 NetCDF files with measurements from the SloFor (Sloping Foreshore) wave flume experiments. The filenames all start with 'SloFor_' followed by the test name. The entire data set is comprised of the following files:

* SloFor_D101a.nc
* SloFor_D102.nc
* SloFor_D103b.nc
* SloFor_D111.nc
* SloFor_D112.nc
* SloFor_D113a.nc
* SloFor_D201.nc
* SloFor_D202.nc
* SloFor_D203.nc
* SloFor_D211.nc
* SloFor_D212.nc
* SloFor_D213a.nc
* SloFor_L201.nc
* SloFor_L202.nc
* SloFor_L203.nc
* SloFor_L211.nc
* SloFor_L212.nc
* SloFor_L213a.nc

Each file contains the measured signals of the wave gauges present during the experiments. Details on the location and calibration of the measurement instruments are present in the meta-data of the files. The measurement signals are divided into a period that should not be included in analyses ('time_pre') and a period that can be analyzed ('time'), since there is some spin-up time needed (waves and reflections need to be present in the entire flume).

Experimental layout
-------------------
The details regarding the placement of the measurement instruments can be found within the NetCDF files listed above. During these experiments, a construction was present in the wave flume (the construction was the same for all 18 experiments). The dimensions of this construction are constant over the width of the flume. Additionally, the construction can be considered as impermeable and smooth. The coordinates of the structure contour in x (x = 0 m at the wave board and positive in the direction away from the waveboard) and z (z = 0 m at the bottom of the facility and positive upwards) are listed below.

* x = 11.277 m; z = 0.000 m
* x = 17.787 m; z = 0.434 m
* x = 23.580 m; z = 0.434 m
* x = 40.560 m; z = 0.717 m
* x = 40.560 m; z = 0.000 m

In addition to the structure described above, a passive wave absorber was present on the landward side of the structure starting from the highest point.

License
-------

This data is licensed under CC BY-SA 4.0. To view a copy of this license, visit https://creativecommons.org/licenses/by-sa/4.0/