function find_sliplength

clear all, close all

xlsfile = 'Carreau_100um_XG_02wt_Jeff.xlsx';
%sheet = [1e2 316.2 1e3 1585 3162 1e4 31623 1e5 316228 1e6 3162278 1e7];
%sheet = [1e-07 1e-06 1e-05 1e-03 1];
sheet = [999.005 999.01 999.02];
for k = 1:length(sheet)
theta_num(k,:) = xlsread(xlsfile,num2str(sheet(k)),'A2:A100');
u_av_num(k,:) = xlsread(xlsfile,num2str(sheet(k)),'B2:B100');
dPdx_num(k,:) = xlsread(xlsfile,num2str(sheet(k)),'C2:C100');
end

vars = load('finitedifference_carreau_evaluation_100um_XG005_2.mat');
wars = load('finitedifference_carreau_evaluation_100um_XG01_2.mat');
zars = load('finitedifference_carreau_evaluation_100um_XG02_2.mat');

% slip length profile for water as function of theta
H = 100e-6; %m
mu = 8.9e-4; %Pa s
theta_h2o = xlsread(xlsfile,'1e-05_water','A2:A100');
u_av_h2o = xlsread(xlsfile,'1e-05_water','B2:B100');
dPdx_h2o = xlsread(xlsfile,'1e-05_water','C2:C100');
b_h2o = (-u_av_h2o - H.^2./(12.*mu).*dPdx_h2o)./(u_av_h2o./H + H./(3.*mu).*dPdx_h2o);

% slip length profile for water as function of u_av
theta_h2o_0 = xlsread(xlsfile,'999_water','A2:A100');
u_av_h2o_0 = xlsread(xlsfile,'999_water','B2:B100');
dPdx_h2o_0 = xlsread(xlsfile,'999_water','C2:C100');
b_h2o_0 = (-u_av_h2o_0 - H.^2./(12.*mu).*dPdx_h2o_0)./(u_av_h2o_0./H + H./(3.*mu).*dPdx_h2o_0);

index_0deg = find(abs(theta_h2o - 1/180*pi)<1/180*pi);
theta_h2o_1deg = theta_h2o(index_0deg);
b_h2o_1deg = b_h2o(index_0deg);

% theoretical maximum
nn_theor = [0.563 0.503 0.406];
epsilon_theor = 1/2;
b_max_theor = (1-(1-epsilon_theor).^(1./nn_theor))./((1./nn_theor+3).*(1-epsilon_theor).^(1./nn_theor));
b_h20_theor = 1/4.*epsilon_theor./(1-epsilon_theor);
E_b = b_max_theor./b_h20_theor;
xpoints = logspace(0,8,9);
for k = 1:length(nn_theor)
    E_b_points(k,:) = ones(1,9).*E_b(k);
end


L_g = 10e-6;
b_num_init = 0e-6;
options = optimset('MaxFunEvals',1e8,'MaxIter',1e5,'Display','iter','TolFun',1e-12,'TolX',1e-12); %'iter'

for k=1:length(sheet)
    for l=1:length(u_av_num(k,:))
        u_av_in = u_av_num(k,l);
        dPdx_in = dPdx_num(k,l);
        b_num(k,l) = fsolve(@findb_num,b_num_init,options,u_av_in,dPdx_in);
    end
end

for k=2:length(sheet)
    for l=1:length(u_av_num(k,:))
        u_av_in = u_av_num(k,l);
        dPdx_in = dPdx_num(k,l);
        b_num(k,l) = fsolve(@findb_num2,b_num_init,options,u_av_in,dPdx_in);
    end
end

for k=3:length(sheet)
    for l=1:length(u_av_num(k,:))
        u_av_in = u_av_num(k,l);
        dPdx_in = dPdx_num(k,l);
        b_num(k,l) = fsolve(@findb_num3,b_num_init,options,u_av_in,dPdx_in);
    end
end

figure(1)
hold on
map=cbrewer('seq','OrRdBlGr',length(sheet));
symbols = {'o','s','d','^','v','h'};
%map=paruly(length(sheet));
for k=1:length(sheet)
    plot(theta_num(k,:).*180./pi,b_num(k,:)./(0.5*L_g),...
        'Marker',symbols{k},'MarkerEdgeColor',map(k,:),'LineStyle','--','Color',map(k,:))
    legendInfo{k} = ['$10^{' num2str(log10(sheet(k))) '}$ m/s'];
end
plot(theta_h2o.*180./pi,b_h2o./(0.5*L_g),'.--','Color',[0.3 0.3 0.3]);%,'DisplayName',num2str(sheet(k)));
legendInfo{length(sheet)+1} = ['H$_2$O'];
hold off
%legend('Show')
h = legend(legendInfo);
% v = get(h,'Title');
% set(v,'String','-dP/dx [Pa/m]');
legend('boxoff');
box on
xlim([-90 90])
xlabel('$\vartheta$ [$^{\circ}$]')
ylabel('$2b/L_g$')
%title('Dimensionless slip length')

tikzfile = ['find_sliplength_theta_b.tikz'];
matlab2tikz(tikzfile, 'height', '\figureheight', 'width', '\figurewidth');

figure(2)
hold on
h = surf(vars.b(2:end),log10(-vars.dPdx(1:end)),log10(vars.u_av(:,2:end)));
%set(h, 'edgecolor','none');
cmap = jet;
colormap(cmap)
scatter3(b_num(1,:),log10(-dPdx_num(1,:)),log10(u_av_num(1,:)),'filled','MarkerEdgeColor','k','MarkerFaceColor','k')
hold off
xlabel('b [m]')
ylabel('log_{10}(-dP/dx) [Pa/m]')
zlabel('log_{10}(u_{av}) [m/s]')
box off
grid on
view(-50,15)

figure(3)
hold on
for k=1:length(sheet)
    plot(theta_num(k,:).*180./pi,u_av_num(k,:),...
        'o--','Color',map(k,:));%,'DisplayName',num2str(sheet(k)));
    legendInfo{k} = ['$-10^{' num2str(log10(sheet(k))) '}$ Pa/m'];
end
xlim([-90 90])
% plot(-dPdx_num,u_av_num,'o--','Color',map(1,:));
hold off
h = legend(legendInfo);
legend('boxoff');
box on
xlabel('$\vartheta [^{\circ}]$')
ylabel('$u_av$ [m/s]')
set(gca,'XScale','linear','YScale','linear')

figure(4)
hold on
color = cbrewer('seq','OrRdBlGr',1);
for k=1:length(sheet)
%     plot(-dPdx_num(k,:),b_num(k,:)/(0.5*L_g),...
%         'o--','Color',map(k,:));
    plot(-dPdx_num(k,:),b_num(k,:)/b_h2o_1deg,...
        'Marker',symbols{k},'MarkerEdgeColor',map(k,:),'LineStyle','--','Color',map(k,:))        
end
for k=1:length(nn_theor)
    plot(xpoints,E_b_points(k,:),...
        '--','Color',map(k,:));
end
hold off
legend('0.05 wt\%','0.1 wt\%','0.2 wt\%')
legend('boxoff');
box on
xlim([1e1 1e7])
%xlabel('$u_{av}$ [m/s]')
xlabel('$-\dd P/\dd x$ [Pa/m]')
ylabel('$b/b_{H2O}$')
title('(b) H = 100 um, Lg = 10 um, epsilon = 1/2')
set(gca,'XScale','log','YScale','linear')

tikzfile = ['find_sliplength_dpdx_b.tikz'];
matlab2tikz(tikzfile, 'height', '\figureheight', 'width', '\figurewidth');

figure(5)
hold on
color = cbrewer('seq','OrRdBlGr',1);
%plot(-dPdx_num(:,10),b_num(:,10)./(0.5*L_g),'o--','Color',color(1,:));
for k=1:length(sheet)
    plot(u_av_num(k,:),b_num(k,:)/(0.5*L_g),...
    'Marker',symbols{k},'MarkerEdgeColor',map(k,:),'LineStyle','--','Color',map(k,:))
end
plot(u_av_h2o_0.*180./pi,b_h2o_0./(0.5*L_g),'.--','Color',[0.3 0.3 0.3]);%,'DisplayName',num2str(sheet(k)));
legendInfo{length(sheet)+1} = ['H$_2$O'];
hold off
legend('0.05 wt\%','0.1 wt\%','0.2 wt\%','H2O')
legend('boxoff');
box on
xlim([1e-7 1e1])
xlabel('$u_{av}$ [m/s]')
%xlabel('$\dd P/\dd x$ [Pa/m]')
ylabel('$2b/L_g$')
title('(a) H = 100 um, Lg = 10 um, epsilon = 1/2')
set(gca,'XScale','log','YScale','linear')

tikzfile = ['find_sliplength_uav_b.tikz'];
matlab2tikz(tikzfile, 'height', '\figureheight', 'width', '\figurewidth');

    function F = findb_num(b_num,u_av_in,dPdx_in)
        F = u_av_in - interp2(vars.b,vars.dPdx,vars.u_av,b_num,dPdx_in,'spline');
    end

    function F = findb_num2(b_num,u_av_in,dPdx_in)
        F = u_av_in - interp2(wars.b,wars.dPdx,wars.u_av,b_num,dPdx_in,'spline');
    end

    function F = findb_num3(b_num,u_av_in,dPdx_in)
        F = u_av_in - interp2(zars.b,zars.dPdx,zars.u_av,b_num,dPdx_in,'spline');
    end

end