
clear all, close all;

% import data from csv files to plot slip length profiles for different
% power law fluid exponents nn

epsilon = 1/2;
nn = [.5 .75 1 1.25 1.5];
n = length(nn);

% extract data from 'comsol' files
file = 'b_L001to1000';
for j = 1:n
    csvfile{j} = [file '_e0' num2str(epsilon*100) '_nn' num2str(nn(j)*100)  '_highres.csv'];
    b_max(j) = (1-(1-epsilon)^(1/nn(j)))/((1/nn(j)+3)*(1-epsilon)^(1/nn(j)));
    M = csvread(csvfile{j},8,0); % start reading from cell (9,0), numbering is zero-based
    L(j,:) = M(:,1); % dimensionless L, i.e. L = 10 implies the length is 10R
    b(j,:) = M(:,2); % dimensionless slip length b/R
    dbdL(j,:) = gradient(b(j,:),L(j,:));
    log_dbdL(j,:) = gradient(log(b(j,:)),log(L(j,:)));
end

nn_theor = .2:.01:1.8;
b_max_theor = (1-(1-epsilon).^(1./nn_theor))./((1./nn_theor+3).*(1-epsilon).^(1./nn_theor));
b_max_theor_nn1 = 0.25*epsilon/(1-epsilon);

% % find value of L/R where b/R reaches 95% of b_max
% for j = 1:n
%     index(j) = min(find(b(j,:) >= .95*b_max(j)));
%     L99(j) = L(j,index(j));
% end

% plot figures
if n < 3
   nt = 3;
else
   nt = n;
end
map=cbrewer('seq','OrRdBlGr',nt);
symbols = {'o','s','d','^','v','h'};
mm = 0;

% plot slip length
mm = mm + 1;
figure(mm)
hold on;
for j = 1:n
    plot(L(j,:),b(j,:),'Marker',symbols{j},'LineStyle','none','MarkerEdgeColor',map(j,:))
    legendentries{j} = ['n = ' num2str(nn(j))];
end
for j = 1:n
    plot([min(L(j,:)) max(L(j,:))],[b_max(j) b_max(j)],'--','Color',map(j,:))
end
hold off
%ylim([3e-4,3e-1])
set(gca,'xscale','log','yscale','log')
box on
%legend(['lim(b/R) = ' num2str(b_max)],'b/R','Location','SouthEast')
legend(legendentries,'Location','SouthEast')
legend('boxoff');
ylabel('b/R')
xlabel('L/R')
title(['\varepsilon = ' num2str(epsilon)])
matlab2tikz('boverRmax.tikz', 'height', '\figureheight', 'width', '\figurewidth');

% plot scaled (to maximum) dimensionless slip length
mm = mm + 1;
figure(mm)
hold on;
for j = 1:n
    plot(L(j,:),b(j,:)./max(b(j,:)),'Marker',symbols{j},'LineStyle','none','MarkerEdgeColor',map(j,:))
    legendentries{j} = ['n = ' num2str(nn(j))];
end
hold off
%ylim([3e-4,3e-1])
set(gca,'xscale','log','yscale','log')
box on
%legend(['lim(b/R) = ' num2str(b_max)],'b/R','Location','SouthEast')
legend(legendentries,'Location','SouthEast')
legend('boxoff');
ylabel('(b/R)/(b/R)_{max}')
xlabel('L/R')
title(['\varepsilon = ' num2str(epsilon)])
matlab2tikz('boverRmax_scaled.tikz', 'height', '\figureheight', 'width', '\figurewidth');

% plot of b/R scaled to slip length for n = 1 (Newtonian flow)
mm = mm + 1;
figure(mm)
hold on;
for j = 1:n
    plot(L(j,:),b(j,:)./b(3,:),'Marker',symbols{j},'LineStyle','none','MarkerEdgeColor',map(j,:))
    legendentries{j} = ['n = ' num2str(nn(j))];
end
hold off
%ylim([3e-4,3e-1])
set(gca,'xscale','log','yscale','linear')
box on
%legend(['lim(b/R) = ' num2str(b_max)],'b/R','Location','SouthEast')
legend(legendentries,'Location','SouthEast')
legend('boxoff');
ylabel('(b/R)/(b/R)_{n=1}')
xlabel('L/R')
%title(['\epsilon = ' num2str(epsilon)])

% plot of slip length non-dimensionalised as 2b/Lg = (b/R)*(2R)/(epsilon*L)
mm = mm + 1;
figure(mm)
hold on;
for j = 1:n
    plot(L(j,:),2.*b(j,:)./(epsilon.*L(j,:)),'Marker',symbols{j},'LineStyle','none','MarkerEdgeColor',map(j,:))
    legendentries{j} = ['n = ' num2str(nn(j))];
end
for j = 1:n
    plot(L(j,:),2.*b_max(j)./(epsilon.*L(j,:)),'--','Color',map(j,:))
end
hold off
%ylim([3e-4,3e-1])
set(gca,'xscale','log','yscale','log')
box on
%legend(['lim(b/R) = ' num2str(b_max)],'b/R','Location','SouthEast')
legend(legendentries,'Location','SouthWest')
legend('boxoff');
ylabel('2b/L_g = (b/R)*(2R)/(epsilon*L)')
xlabel('L/R')
title(['\varepsilon = ' num2str(epsilon)])
matlab2tikz('boverLgmax.tikz', 'height', '\figureheight', 'width', '\figurewidth');

% plot of 2b/L_g scaled to slip length for n = 1 (Newtonian flow)
mm = mm + 1;
figure(mm)
hold on;
for j = 1:n
    plot(L(j,:),(2.*b(j,:)./(epsilon.*L(j,:)))./(2.*b(3,:)./(epsilon.*L(3,:))),'Marker',symbols{j},'LineStyle','none','MarkerEdgeColor',map(j,:))
    legendentries{j} = ['n = ' num2str(nn(j))];
end
hold off
%ylim([3e-4,3e-1])
set(gca,'xscale','log','yscale','linear')
box on
%legend(['lim(b/R) = ' num2str(b_max)],'b/R','Location','SouthEast')
legend(legendentries,'Location','SouthEast')
legend('boxoff');
ylabel('(2b/L_g)/(2b/L_g)_{n=1}')
xlabel('L/R')
%title(['\epsilon = ' num2str(epsilon)])

mm = mm + 1;
figure(mm)
hold on;
for j = 1:n
    %plot(L(j,:),dbdL(j,:)./(1./nn(j)+3),'Marker',symbols{j},'LineStyle','none','MarkerEdgeColor',map(j,:))
    plot(L(j,:),dbdL(j,:),'Marker',symbols{j},'LineStyle','none','MarkerEdgeColor',map(j,:))
    legendentries{j} = ['n = ' num2str(nn(j))];
end
hold off
%ylim([3e-4,3e-1])
set(gca,'xscale','log','yscale','lin')
box on
legend(legendentries,'Location','NorthEast')
legend('boxoff');
ylabel('d(b/R)/d(L/R)')
xlabel('L/R')
title(['\varepsilon = ' num2str(epsilon)])
matlab2tikz('dboverRdL.tikz', 'height', '\figureheight', 'width', '\figurewidth');

mm = mm + 1;
figure(mm)
hold on;
for j = 1:n
    plot(L(j,:),log_dbdL(j,:),'Marker',symbols{j},'LineStyle','none','MarkerEdgeColor',map(j,:))
    legendentries{j} = ['n = ' num2str(nn(j))];
end
hold off
%ylim([3e-4,3e-1])
set(gca,'xscale','log','yscale','log')
box on
legend(legendentries,'Location','SouthWest')
legend('boxoff');
ylabel('log[d(b/R)/d(L/R)]')
xlabel('L/R')

% mm = mm + 1;
% figure(mm)
% hold on;
% plot(epsilon,L99,'o','Color',map(1,:))
% hold off
% %ylim([1e1,1e3])
% %set(gca,'xscale','lin','yscale','log')
% box on
% %legend(legendentries,'Location','SouthWest')
% %legend('boxoff');
% ylabel('(L/R)_{95}')
% xlabel('\epsilon')

% mm = mm + 1;
% figure(mm)
% hold on;
% plot(nn_theor,b_max_theor,'o','Color',map(1,:))
% hold off
% %ylim([1e1,1e3])
% %set(gca,'xscale','lin','yscale','log')
% box on
% %legend(legendentries,'Location','SouthWest')
% %legend('boxoff');
% ylabel('(b/R)_{max}')
% xlabel('n')

mm = mm + 1;
figure(mm)
hold on
[hax,hline1,hline2] = plotyy(nn_theor,b_max_theor,nn_theor,b_max_theor./b_max_theor_nn1);
set(hline1,'LineStyle','-','Marker','o','Color',map(1,:));
set(hline2,'LineStyle','-','Marker','s','Color',map(end,:));
set(hax(1),'XScale','lin','ycolor','k')
set(hax(2),'XScale','lin','ycolor','k')
%set(hax(1),'XScale','log','ycolor','k','YTick',[0 .25 .5 .75 1],'YTickLabel',{'$1/3$','','$5/12$','','$1/2$'});
%set(hax(2),'XScale','log','ycolor','k','YTick',[0 .25 .5 .75 1],'YTickLabel',{'$3.66$','','$4.72$','','$5.78$'});
%xlim(hax(1),[1e-5 100]);
%xlim(hax(2),[1e-5 100]);
%ylim(hax(1),[-0.025 1.025]);
%ylim(hax(2),[-0.025 1.025]);
%set(gcf,'Color','w');
box on
xlabel('n')
ylabel(hax(1),'(b/R)_{max}');
ylabel(hax(2),'(b/R)_{max}/(b/R)_{max} (n = 1)');
%legend('$\beta_f$');
%legend('Location','NorthWest');
%legend('boxoff');
% legend(hline1,'$ \beta $','boxoff');
% legend(hline1,'Location','NorthWest');
% legend(hline2,'$\textrm{Nu}_{x} (\infty) $','Location','SouthEast','Box','off','Color', 'none');
% legend([hline1 hline2],'$ \beta $','$\textrm{Nu}_{x} (\infty) $');
% legend(hline1,'Location','NorthWest');
% legend(hline2,'Location','NorthWest');
hold off

% maximum slip length for different porosities
epsilon_theor = [1/3 1/2 2/3];
%nn_theor = 0.2:0.005:1.8;
b_max_theor_nn = 0.25.*epsilon_theor./(1-epsilon_theor);
for j = 1:length(epsilon_theor)
    b_max_theor(j,:) = (1-(1-epsilon_theor(j)).^(1./nn_theor))./((1./nn_theor+3).*(1-epsilon_theor(j)).^(1./nn_theor));
end

mm = mm + 1;
figure(mm)
hold on
for j = 1:length(epsilon_theor)
    plot(nn_theor,b_max_theor(j,:)./b_max_theor_nn(j),'Marker','none','LineStyle','-','color',map(j,:),'MarkerEdgeColor',map(j,:))
    legendentries{j} = ['\varepsilon = ' num2str(epsilon_theor(j))];
end
hold off
box on
xlabel('n')
ylabel('(b/R)_{max}');
legend(legendentries,'Location','NorthEast')
legend('boxoff');
matlab2tikz('b_max_theoretical.tikz', 'height', '\figureheight', 'width', '\figurewidth');