(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    389990,      10297]
NotebookOptionsPosition[    360416,       9809]
NotebookOutlinePosition[    360812,       9825]
CellTagsIndexPosition[    360769,       9822]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Spin Echo", "Section",
 CellChangeTimes->{{3.9241784005323277`*^9, 
  3.9241784046283245`*^9}},ExpressionUUID->"1211c674-d148-40ea-a798-\
41a3349fcb82"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"corr", "[", 
    RowBox[{"t1_", ",", "t2_"}], "]"}], ":=", 
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", "\[Kappa]"}], " ", 
     RowBox[{"Abs", "[", 
      RowBox[{"t2", "-", "t1"}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9241779852162247`*^9, 3.924178002125658*^9}, {
  3.9241780372696304`*^9, 3.92417803790178*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"1d26f30c-808c-41e9-a8e9-5f2b5860020a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"I1", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"corr", "[", 
     RowBox[{"t1", ",", "t2"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t1", ",", "0", ",", "T"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t2", ",", "0", ",", "T"}], "}"}], ",", 
    RowBox[{"Assumptions", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"T", ">", "0"}], ",", 
       RowBox[{"\[Kappa]", ">", "0"}]}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9241780736790237`*^9, 3.9241780973893056`*^9}, {
  3.9241782035745153`*^9, 3.9241782152774935`*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"09b94106-a6f6-4538-a6ae-bafcb322b9f7"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "T"}], " ", "\[Kappa]"}]], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"T", " ", "\[Kappa]"}]], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"T", " ", "\[Kappa]"}]], " ", "T", " ", "\[Kappa]"}]}], 
    ")"}]}], 
  SuperscriptBox["\[Kappa]", "2"]]], "Output",
 CellChangeTimes->{{3.9241780900490723`*^9, 3.9241780996965733`*^9}, 
   3.9241782245698533`*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"6823cd8b-84e5-4dd2-8872-e6fc8d01676a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"I2", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"corr", "[", 
     RowBox[{"t1", ",", "t2"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t1", ",", "0", ",", "T"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t2", ",", "T", ",", 
      RowBox[{"2", "T"}]}], "}"}], ",", 
    RowBox[{"Assumptions", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"T", ">", "0"}], ",", 
       RowBox[{"\[Kappa]", ">", "0"}]}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.92417776529585*^9, 3.9241778220938015`*^9}, {
  3.9241780090296316`*^9, 3.924178051317404*^9}, {3.9241782068859396`*^9, 
  3.9241782175660048`*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"c08ffb49-bb39-4c0e-a763-7056087490b1"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "2"}], " ", "T", " ", "\[Kappa]"}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"T", " ", "\[Kappa]"}]]}], ")"}], "2"]}], 
  SuperscriptBox["\[Kappa]", "2"]]], "Output",
 CellChangeTimes->{{3.9241780347712655`*^9, 3.9241780629961853`*^9}, 
   3.9241782255117083`*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"71ec24fb-8d23-4a24-934f-a1acfd0aaca8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"I1", "-", "I2"}], ")"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.924178234343474*^9, 3.9241782531414576`*^9}, {
   3.924178448341301*^9, 3.924178461477372*^9}, 3.924178491574098*^9},
 CellLabel->"In[20]:=",ExpressionUUID->"c0c47fbd-811f-4414-b585-049583e3ddd9"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"3", "+", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "T", " ", "\[Kappa]"}]], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "T"}], " ", "\[Kappa]"}]]}], "-", 
    RowBox[{"2", " ", "T", " ", "\[Kappa]"}]}], 
   SuperscriptBox["\[Kappa]", "2"]]}]], "Output",
 CellChangeTimes->{{3.924178239854554*^9, 3.9241782539260874`*^9}, {
  3.924178462005356*^9, 3.924178491844621*^9}},
 CellLabel->"Out[20]=",ExpressionUUID->"924016f5-7971-4676-aec4-5cedd84aa415"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"3", "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "2"}], " ", "T", " ", "\[Kappa]"}]], "-", 
     RowBox[{"4", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "T"}], " ", "\[Kappa]"}]]}], "-", 
     RowBox[{"2", " ", "T", " ", "\[Kappa]"}]}], 
    SuperscriptBox["\[Kappa]", "2"]]}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Kappa]", "->", 
     RowBox[{"(", 
      RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}]}], ",", 
    RowBox[{"T", "->", "1"}]}], "}"}]}]], "Input",
 CellChangeTimes->{3.9241785029252715`*^9},
 CellLabel->"In[21]:=",ExpressionUUID->"1b8d2bd7-fd7b-4221-a2d5-ffa1661b7a8d"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"3", "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]"}]]}], "+", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"(", 
       RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}]}]], "-", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}]}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}], "2"]]}]], "Output",
 CellChangeTimes->{3.924178503637453*^9},
 CellLabel->"Out[21]=",ExpressionUUID->"86cf128a-9599-4773-9f1a-895d79777a6d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Exp", "[", 
        FractionBox[
         RowBox[{"3", "+", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", "T", " ", "\[Kappa]"}]], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "T"}], " ", "\[Kappa]"}]]}], "-", 
          RowBox[{"2", " ", "T", " ", "\[Kappa]"}]}], 
         SuperscriptBox["\[Kappa]", "2"]], "]"}], ",", 
       RowBox[{"Exp", "[", 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"-", "T"}], " ", "\[Kappa]"}]], " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"T", " ", "\[Kappa]"}]], "+", 
              RowBox[{
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"T", " ", "\[Kappa]"}]], " ", "T", " ", 
               "\[Kappa]"}]}], ")"}]}], 
           SuperscriptBox["\[Kappa]", "2"]]}], "/.", 
         RowBox[{"T", "->", 
          RowBox[{"2", "T"}]}]}], "]"}]}], "}"}], "/.", 
     RowBox[{"\[Kappa]", "->", "1"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.924178552511198*^9, 3.9241786196290045`*^9}, {
  3.9241786671650677`*^9, 3.9241786735171485`*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"a2d0737a-7260-4017-aff3-50fa100585cd"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2], 
         Opacity[1.], LineBox[CompressedData["
1:eJwV1nk01c8bB3BLX3Fx3aV885Olb0J2KqXSMyVkLaKy7y4VoeyKrClE2ZWd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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ], 
       TagBox[
        {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[2], 
         Opacity[1.], LineBox[CompressedData["
1:eJwV1Gc81f8bBnAce56hrRwlhEhJGXV/ZM+iUIisbCHkxxGREbISkr0iMkJl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          "]]},
        Annotation[#, "Charting`Private`Tag#2"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
      Slot["HighlightElements"], 
      Slot["LayoutOptions"], 
      Slot["Meta"], 
      Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
          Annotation[{
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]], 
            Line[CompressedData["
1:eJwV1nk01c8bB3BLX3Fx3aV885Olb0J2KqXSMyVkLaKy7y4VoeyKrClE2ZWd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             "]]}, "Charting`Private`Tag#1"], 
          Annotation[{
            Directive[
             Opacity[1.], 
             RGBColor[0.880722, 0.611041, 0.142051], 
             AbsoluteThickness[2]], 
            Line[CompressedData["
1:eJwV1Gc81f8bBnAce56hrRwlhEhJGXV/ZM+iUIisbCHkxxGREbISkr0iMkJl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             "]]}, "Charting`Private`Tag#2"]}}, {}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{0, 5}, {0., 0.9999999999999998}}, 
          "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0},
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             RGBColor[0.880722, 0.611041, 0.142051], 
             AbsoluteThickness[2]], 
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>]]& )[<|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0, 5}, {0., 0.9999999999999998}}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            RGBColor[0.880722, 0.611041, 0.142051], 
            AbsoluteThickness[2]], 
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>],
     ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
      4.503599627370496*^15, -4.503599627370496*^15}}]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]], 
         Line[CompressedData["
1:eJwV1nk01c8bB3BLX3Fx3aV885Olb0J2KqXSMyVkLaKy7y4VoeyKrClE2ZWd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          "]]}, "Charting`Private`Tag#1"], 
       Annotation[{
         Directive[
          Opacity[1.], 
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[2]], 
         Line[CompressedData["
1:eJwV1Gc81f8bBnAce56hrRwlhEhJGXV/ZM+iUIisbCHkxxGREbISkr0iMkJl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          "]]}, "Charting`Private`Tag#2"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PlotRange" -> {{0, 5}, {0., 0.9999999999999998}}, 
       "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
       "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
       "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[2]], 
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 5}, {0., 0.9999999999999998}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.92417856221973*^9, 3.9241785764902105`*^9}, {
  3.92417860718723*^9, 3.924178619880813*^9}, {3.9241786686243215`*^9, 
  3.9241786737794204`*^9}},
 CellLabel->"Out[28]=",ExpressionUUID->"694bbecb-a20f-4799-8caf-eae14d954b34"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integral of Uncorrelated Terms", "Section",
 CellChangeTimes->{{3.903427151183447*^9, 
  3.903427162703624*^9}},ExpressionUUID->"01752563-49dc-4898-b6e5-\
1e0e445c72d3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"conds1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"L", ">", "0"}], ",", 
     RowBox[{"v", ">", "0"}], ",", 
     RowBox[{
      SubscriptBox["T", "2"], ">", 
      SubscriptBox["T", "0"], ">", 
      SubscriptBox["T", "1"], ">", "0"}], ",", 
     RowBox[{
      SubscriptBox["\[Kappa]", "x"], ">", "0"}], ",", 
     RowBox[{
      SubscriptBox["\[Kappa]", "t"], ">", "0"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.902294390398444*^9, 3.90229441984711*^9}, {
   3.9022944542414827`*^9, 3.9022944628337107`*^9}, {3.902294527693212*^9, 
   3.90229454397414*^9}, {3.902304461873769*^9, 3.9023045396040263`*^9}, 
   3.9025660560593376`*^9, {3.9028889830794487`*^9, 3.902888983233806*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"3b3fc3e0-645e-460c-a798-a13a1f658bfb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"conds2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"L", ">", "0"}], ",", 
     RowBox[{"v", ">", "0"}], ",", 
     RowBox[{
      SubscriptBox["T", "2"], ">", 
      SubscriptBox["T", "1"], ">", 
      SubscriptBox["T", "0"], ">", "0"}], ",", 
     RowBox[{
      SubscriptBox["\[Kappa]", "x"], ">", "0"}], ",", 
     RowBox[{
      SubscriptBox["\[Kappa]", "t"], ">", "0"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.902566060107026*^9, 3.902566064746812*^9}, 
   3.9028889889542007`*^9},
 CellLabel->"In[2]:=",ExpressionUUID->"6ddc5d11-113a-4d92-9410-ccd08235144a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rule", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["T", "1"], "->", 
      RowBox[{"L", "/", "v"}]}], ",", 
     RowBox[{
      SubscriptBox["T", "2"], "->", 
      RowBox[{
       SubscriptBox["T", "0"], "+", 
       RowBox[{"L", "/", "v"}]}]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.902304767864176*^9, 3.902304789111107*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"3ffa81d4-f351-45b3-b203-6921adda819b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rule0", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Beta]", "->", 
      RowBox[{
       SubscriptBox["T", "1"], 
       SubscriptBox["\[Kappa]", "t"]}]}], ",", 
     RowBox[{"\[Gamma]", "->", 
      RowBox[{"L", " ", 
       SubscriptBox["\[Kappa]", "x"]}]}], ",", 
     RowBox[{"\[Tau]", "->", 
      RowBox[{
       SubscriptBox["T", "0"], " ", 
       SubscriptBox["\[Kappa]", "t"]}]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.902317961382621*^9, 3.9023179737607794`*^9}, {
  3.9028888242934384`*^9, 3.9028888362747307`*^9}, {3.9028891829720488`*^9, 
  3.9028892261688843`*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"cd4ea6e4-e07f-41e1-8d44-d2c8bd6f1144"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rule1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Kappa]", "t"], "->", "1"}], ",", 
     RowBox[{
      SubscriptBox["\[Kappa]", "x"], "->", "1"}], ",", 
     RowBox[{
      SubscriptBox["T", "1"], "->", "\[Beta]"}], ",", 
     RowBox[{"L", " ", "->", "\[Gamma]"}], ",", 
     RowBox[{
      SubscriptBox["T", "0"], " ", "->", "\[Tau]"}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.9028900187821646`*^9, 3.9028900438984356`*^9}, {
  3.902891034327613*^9, 3.902891060697199*^9}, {3.9029793355654383`*^9, 
  3.902979359155294*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"61632bc0-0e15-42b7-abf1-2f9388d58a49"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"P1", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["\[Kappa]", "t"], "+", 
          RowBox[{
           SubscriptBox["\[Kappa]", "x"], 
           FractionBox["L", 
            SubscriptBox["T", "1"]]}]}], ")"}]}], 
       RowBox[{"Abs", "[", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["t", "1"], "-", 
          SubscriptBox["t", "2"]}], ")"}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", "0", ",", 
       SubscriptBox["T", "1"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", "0", ",", 
       SubscriptBox["T", "1"]}], "}"}], ",", 
     RowBox[{"Assumptions", "->", "conds1"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.9029803021895027`*^9, 3.902980309975552*^9}, {
   3.903001386286585*^9, 3.903001386771142*^9}, {3.903001467911707*^9, 
   3.9030014949541883`*^9}, {3.903001526146584*^9, 3.903001593950693*^9}, 
   3.903419825900319*^9},
 CellLabel->"In[6]:=",ExpressionUUID->"ca189b91-643d-4bf0-8aef-1f0da9c06025"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", 
    SubsuperscriptBox["T", "1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SubscriptBox["T", "1"]}], " ", 
         SubscriptBox["\[Kappa]", "t"]}], "-", 
        RowBox[{"L", " ", 
         SubscriptBox["\[Kappa]", "x"]}]}]], "-", 
      RowBox[{
       SubscriptBox["T", "1"], " ", 
       SubscriptBox["\[Kappa]", "t"]}], "-", 
      RowBox[{"L", " ", 
       SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubscriptBox["T", "1"], " ", 
       SubscriptBox["\[Kappa]", "t"]}], "+", 
      RowBox[{"L", " ", 
       SubscriptBox["\[Kappa]", "x"]}]}], ")"}], "2"]]}]], "Output",
 CellChangeTimes->{{3.9030013799161377`*^9, 3.903001389671968*^9}, 
   3.903001502948923*^9, {3.9030015340643682`*^9, 3.903001596311792*^9}, 
   3.9034191486344967`*^9, 3.903419322354003*^9, 3.9034198330117493`*^9, 
   3.9034271734302673`*^9, {3.9034332866020994`*^9, 3.9034333095729313`*^9}, 
   3.90396674873073*^9, 3.904639162782829*^9, 3.905056601221806*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"b2d625fa-0aae-457c-9d18-fdd234c415d2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"P2", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", 
        SubscriptBox["\[Kappa]", "t"]}], 
       RowBox[{"Abs", "[", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["t", "1"], "-", 
          SubscriptBox["t", "2"]}], ")"}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", "0", ",", 
       SubscriptBox["T", "0"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", "0", ",", 
       SubscriptBox["T", "0"]}], "}"}], ",", 
     RowBox[{"Assumptions", "->", "conds1"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.9030015833936253`*^9, 3.903001585410089*^9}, 
   3.903001706963386*^9, {3.903001789695506*^9, 3.9030018256797667`*^9}, 
   3.903419827732342*^9},
 CellLabel->"In[7]:=",ExpressionUUID->"d18824b1-4be6-49c4-9aac-5db0ab5d6f95"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", 
        SubscriptBox["T", "0"]}], " ", 
       SubscriptBox["\[Kappa]", "t"]}]], "+", 
     RowBox[{
      SubscriptBox["T", "0"], " ", 
      SubscriptBox["\[Kappa]", "t"]}]}], ")"}]}], 
  SubsuperscriptBox["\[Kappa]", "t", "2"]]], "Output",
 CellChangeTimes->{
  3.903001585638866*^9, {3.903001792389874*^9, 3.903001827379334*^9}, 
   3.9034191510817175`*^9, 3.9034193247782216`*^9, 3.9034198348364058`*^9, 
   3.9034271753350215`*^9, {3.903433290746758*^9, 3.9034333120669622`*^9}, 
   3.9039667499645357`*^9, 3.904639168380605*^9, 3.9050566024664927`*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"2f548710-5f85-4f20-a34b-e262c00345d7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"P3", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["t", "2"], "-", 
          SubscriptBox["t", "1"]}], ")"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], "L", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          FractionBox[
           SubscriptBox["t", "1"], 
           SubscriptBox["T", "1"]]}], ")"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", "0", ",", 
       SubscriptBox["T", "1"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", 
       SubscriptBox["T", "1"], ",", 
       RowBox[{
        SubscriptBox["T", "1"], "+", 
        SubscriptBox["T", "0"]}]}], "}"}], ",", 
     RowBox[{"Assumptions", "->", "conds1"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.903419840380893*^9, 3.9034198979321485`*^9}, {
  3.9034220512888365`*^9, 3.9034221467444177`*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"55f11a6e-63fb-424f-9399-fa909cfe9deb"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["T", "0"], "+", 
          SubscriptBox["T", "1"]}], ")"}], " ", 
        SubscriptBox["\[Kappa]", "t"]}], ")"}]}], "-", 
     RowBox[{"L", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       SubscriptBox["T", "0"], " ", 
       SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{
        SubscriptBox["T", "1"], " ", 
        SubscriptBox["\[Kappa]", "t"]}], "+", 
       RowBox[{"L", " ", 
        SubscriptBox["\[Kappa]", "x"]}]}]]}], ")"}], " ", 
   SubscriptBox["T", "1"]}], 
  RowBox[{
   SubscriptBox["\[Kappa]", "t"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["T", "1"], " ", 
      SubscriptBox["\[Kappa]", "t"]}], "+", 
     RowBox[{"L", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]]], "Output",
 CellChangeTimes->{{3.903422111978685*^9, 3.903422151068927*^9}, 
   3.9034271779403777`*^9, 3.9034281676131363`*^9, 3.9034333156737003`*^9, 
   3.903966751750928*^9, 3.9046391720589495`*^9, 3.905056604282199*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"1374a7a6-246a-4faa-b967-8279903c16df"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"P4", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["t", "1"], "-", 
          SubscriptBox["t", "2"]}], ")"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], "L", 
        FractionBox[
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["t", "1"], "-", 
           SubscriptBox["T", "0"]}], ")"}], 
         SubscriptBox["T", "1"]]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", "0", ",", 
       SubscriptBox["T", "0"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", 
       SubscriptBox["T", "0"], ",", 
       RowBox[{
        SubscriptBox["T", "1"], "+", 
        SubscriptBox["T", "0"]}]}], "}"}], ",", 
     RowBox[{"Assumptions", "->", "conds2"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.9034221546084633`*^9, 3.9034221822483664`*^9}, {
  3.9034254132286386`*^9, 3.903425416611226*^9}, {3.9034254950192184`*^9, 
  3.903425504379138*^9}, {3.9034255929638586`*^9, 3.903425601296089*^9}, {
  3.9034275805365*^9, 3.9034275806479554`*^9}, {3.9034280949989557`*^9, 
  3.9034281002629275`*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"abdc7f38-3b3c-4f19-9a43-8843a5e0293e"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["T", "0"], "+", 
          SubscriptBox["T", "1"]}], ")"}], " ", 
        SubscriptBox["\[Kappa]", "t"]}], ")"}]}], "-", 
     RowBox[{"L", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       SubscriptBox["T", "0"], " ", 
       SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{
        SubscriptBox["T", "1"], " ", 
        SubscriptBox["\[Kappa]", "t"]}], "+", 
       RowBox[{"L", " ", 
        SubscriptBox["\[Kappa]", "x"]}]}]]}], ")"}], " ", 
   SubscriptBox["T", "1"]}], 
  RowBox[{
   SubscriptBox["\[Kappa]", "t"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["T", "1"], " ", 
      SubscriptBox["\[Kappa]", "t"]}], "+", 
     RowBox[{"L", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]]], "Output",
 CellChangeTimes->{{3.9034221676213975`*^9, 3.903422185140012*^9}, 
   3.90342552537027*^9, {3.9034255970527782`*^9, 3.9034256038147755`*^9}, 
   3.9034256751079807`*^9, 3.9034257801956787`*^9, 3.9034271804626665`*^9, 
   3.903427584420839*^9, 3.903427722640746*^9, 3.903428103573021*^9, 
   3.903428169713047*^9, 3.9034333186270685`*^9, 3.903966753209853*^9, 
   3.9046391750396595`*^9, 3.905056605765799*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"6186de8a-393b-4b86-b457-5e6873b9a007"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"P3", "==", "P4"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.9034281762088184`*^9, 3.9034281798338203`*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"76972250-327d-4ac2-be76-6e75f2c14de2"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9034281800268974`*^9, 3.9046391750836997`*^9, 
  3.90505660580569*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"10c4c713-f572-4d2e-b69c-1565c4ae7993"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{"-", "P1"}], "]"}], "/.", "rule0"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"L", "->", "1"}], ",", 
      RowBox[{
       SubscriptBox["\[Kappa]", "t"], "->", "1"}], ",", 
      RowBox[{
       SubscriptBox["\[Kappa]", "x"], "->", "1"}], ",", 
      RowBox[{
       SubscriptBox["T", "1"], "->", 
       RowBox[{"1", "/", "v"}]}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0.2", ",", "30"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9029100162210407`*^9, 3.902910114892714*^9}, {
  3.902911225660654*^9, 3.9029112854297943`*^9}, {3.9029796171748333`*^9, 
  3.902979617594512*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"bc723f35-7c50-4618-b15c-bff6fe992119"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV1nk0Ve0XB3BU5syuMRkzJjIUuvauFC8KUcYUKUqhlEhvMjSXTCVjJUqo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       "]]},
     Annotation[#, "Charting`Private`Tag$273607#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->{341.7599999999991, Automatic},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.9029112536355815`*^9, 3.9029112858789864`*^9}, 
   3.902979584696474*^9, 3.9029796183647213`*^9, 3.903419180474837*^9, 
   3.9034271805897818`*^9, 3.905056605841591*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"ed62ed51-5f04-4555-9f2a-0b65e46482b9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"P1", "/.", "rule1"}]], "Input",
 CellChangeTimes->{{3.903433320600569*^9, 3.9034333330945253`*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"2d1066ce-4528-486b-b7b8-05dd1cf2dfaa"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox["\[Beta]", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]"}]], "-", "\[Beta]", "-", 
      "\[Gamma]"}], ")"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}], "2"]]}]], "Output",
 CellChangeTimes->{3.90343333342214*^9, 3.905056605855023*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"cec5ab23-1a08-49a2-a2c1-2fb1bc984286"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"P2", "/.", "rule1"}]], "Input",
 CellChangeTimes->{{3.903433339854426*^9, 3.9034333399346466`*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"269cc34e-e983-4cc2-af98-e7e554464f3a"],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "\[Tau]"}]], "+", "\[Tau]"}], ")"}]}]], "Output",
 CellChangeTimes->{3.903433340229665*^9, 3.905056605875702*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"d7b57341-91f7-4b20-98f2-290577a6a64a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"P3", "/.", "rule1"}]], "Input",
 CellChangeTimes->{{3.903433344190793*^9, 3.9034333443025084`*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"6c05800c-9336-4ad9-a372-c77cabd6f290"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]", "-", "\[Tau]"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[Beta]", "+", "\[Gamma]"}]]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}], " ", "\[Beta]"}], 
  RowBox[{"\[Beta]", "+", "\[Gamma]"}]]], "Output",
 CellChangeTimes->{3.9034333446455092`*^9, 3.905056605885953*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"3fba1778-90a7-43f0-b35e-b6635eabbdee"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"A", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["T", "1"], " ", 
      SubscriptBox["\[Kappa]", "t"]}], ",", 
     RowBox[{"L", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}], "]"}], "/", 
   SuperscriptBox[
    SubscriptBox["\[Kappa]", "t"], "2"]}], "==", 
  RowBox[{"-", 
   FractionBox[
    RowBox[{"2", " ", 
     SubsuperscriptBox["T", "1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["T", "1"]}], " ", 
          SubscriptBox["\[Kappa]", "t"]}], "-", 
         RowBox[{"L", " ", 
          SubscriptBox["\[Kappa]", "x"]}]}]], "-", 
       RowBox[{
        SubscriptBox["T", "1"], " ", 
        SubscriptBox["\[Kappa]", "t"]}], "-", 
       RowBox[{"L", " ", 
        SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["T", "1"], " ", 
        SubscriptBox["\[Kappa]", "t"]}], "+", 
       RowBox[{"L", " ", 
        SubscriptBox["\[Kappa]", "x"]}]}], ")"}], "2"]]}]}]], "Input",
 CellChangeTimes->{{3.922509877415985*^9, 3.92250991635254*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"0b0b99b0-c26e-4a54-a25b-9cabbc740138"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.9225098955548487`*^9, 3.922509916700628*^9}},
 CellLabel->"Out[16]=",ExpressionUUID->"ec24ee2f-c6e4-478e-97d6-cd3f305c9bc4"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"A", "[", 
   RowBox[{"\[Beta]_", ",", "\[Gamma]_"}], "]"}], ":=", 
  RowBox[{"-", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["\[Beta]", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]"}]], "-", "\[Beta]", "-", 
       "\[Gamma]"}], ")"}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}], "2"]]}]}]], "Input",
 CellChangeTimes->{{3.922509010911546*^9, 3.922509016815065*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"38a9adb7-8316-40b7-a8e8-10ca226ed46e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"W", "[", 
   RowBox[{
   "\[Sigma]_", ",", "T_", ",", "L_", ",", "\[Kappa]t_", ",", "\[Kappa]x_"}], 
   "]"}], ":=", 
  RowBox[{"Exp", "[", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"-", 
       SuperscriptBox["\[Sigma]", "2"]}], 
      RowBox[{"4", "\[Kappa]t", " ", "\[Kappa]x"}]], "/", 
     SuperscriptBox["\[Kappa]t", "2"]}], 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{
       RowBox[{"T", " ", "\[Kappa]t"}], ",", 
       RowBox[{"L", " ", "\[Kappa]x"}]}], "]"}], "/", "2"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.9225090218185616`*^9, 3.922509056351221*^9}, {
   3.922509713392312*^9, 3.922509757024382*^9}, {3.9225098063844376`*^9, 
   3.9225098575205526`*^9}, 3.922509922840438*^9},
 CellLabel->"In[17]:=",ExpressionUUID->"b98779dc-0fa6-4612-8986-9fbaef7f407b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"W", "[", 
   RowBox[{
    RowBox[{
     SqrtBox["2"], "/", "20"}], ",", "400", ",", "10", ",", 
    RowBox[{"1", "/", "20"}], ",", "10"}], "]"}], "//", "N"}]], "Input",
 CellChangeTimes->{{3.922509777529934*^9, 3.9225097985445375`*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"5939bc8f-6d52-4dd2-8c40-de8638e7ab0d"],

Cell[BoxData["0.03667882904777631`"], "Output",
 CellChangeTimes->{{3.922509796608754*^9, 3.9225098450098963`*^9}, 
   3.922509924481578*^9},
 CellLabel->"Out[18]=",ExpressionUUID->"ba3f725f-59f2-495b-9fec-7075bfd93cb7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"W", "[", 
      RowBox[{
       RowBox[{
        SqrtBox["2"], "/", "20"}], ",", "200", ",", "10", ",", 
       RowBox[{"1", "/", "20"}], ",", "10"}], "]"}]}], ")"}], "/", "2"}], "//",
   "N"}]], "Input",
 CellChangeTimes->{{3.922509966818743*^9, 3.9225099718005695`*^9}, {
  3.9225100082336273`*^9, 3.922510010344548*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"37200038-0c12-439b-b7d7-b41acfe6d957"],

Cell[BoxData["0.7031168952826874`"], "Output",
 CellChangeTimes->{3.9225099721143675`*^9, 3.9225100106898623`*^9},
 CellLabel->"Out[21]=",ExpressionUUID->"95249c31-40f7-42e3-87bd-ab4f8679ad23"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Integral of Correlated Terms", "Section"]], "Section",
 CellChangeTimes->{{3.90230461494832*^9, 3.902304616647047*^9}, {
  3.903427144327669*^9, 
  3.9034271478003845`*^9}},ExpressionUUID->"917b1e0d-4f02-4372-9bfd-\
856df324e2c2"],

Cell[TextData[StyleBox["Green", "Subsubsection"]], "Text",
 CellChangeTimes->{{3.9024523312273397`*^9, 
  3.9024523382581863`*^9}},ExpressionUUID->"36afa668-52c3-4996-b512-\
fb9700cd3944"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"C1", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"Abs", "[", 
         RowBox[{
          SubscriptBox["t", "1"], "-", 
          SubscriptBox["t", "2"]}], "]"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], "L"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", 
       SubscriptBox["T", "1"], ",", 
       RowBox[{
        SubscriptBox["T", "0"], "+", 
        SubscriptBox["T", "1"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", "0", ",", 
       SubscriptBox["T", "0"]}], "}"}], ",", 
     RowBox[{"Assumptions", "->", "conds1"}]}], "]"}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.902393686642087*^9, 3.902393789601017*^9}, {
   3.902393866830472*^9, 3.9023938704118853`*^9}, {3.902393921429933*^9, 
   3.902393936945325*^9}, {3.9023940065992517`*^9, 3.90239401185159*^9}, {
   3.902394092792444*^9, 3.9023940969295273`*^9}, {3.902394284031115*^9, 
   3.9023943236056004`*^9}, {3.90239435587798*^9, 3.90239439639316*^9}, {
   3.9023950162752733`*^9, 3.902395018421904*^9}, {3.902395053170281*^9, 
   3.902395055246456*^9}, {3.9024533399978323`*^9, 3.902453344178649*^9}, 
   3.902889004670104*^9, {3.9028893398213377`*^9, 3.902889340471383*^9}, {
   3.902889602651595*^9, 3.9028896034356537`*^9}, 3.902889772868865*^9, {
   3.9028898944318085`*^9, 3.9028898953664384`*^9}, {3.902896788304809*^9, 
   3.902896789157678*^9}, {3.902896868492719*^9, 3.9028968691413*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"e17d5f64-cf99-4b49-9d80-343fbed40db1"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["T", "0"], "+", 
          SubscriptBox["T", "1"]}], ")"}], " ", 
        SubscriptBox["\[Kappa]", "t"]}], ")"}]}], "-", 
     RowBox[{"L", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        SubscriptBox["T", "0"], " ", 
        SubscriptBox["\[Kappa]", "t"]}]]}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", " ", 
       SubscriptBox["T", "1"], " ", 
       SubscriptBox["\[Kappa]", "t"]}]], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["T", "0"], "+", 
          SubscriptBox["T", "1"]}], ")"}], " ", 
        SubscriptBox["\[Kappa]", "t"]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["T", "0"], "-", 
        SubscriptBox["T", "1"]}], ")"}], " ", 
      SubscriptBox["\[Kappa]", "t"]}]}], ")"}]}], 
  SubsuperscriptBox["\[Kappa]", "t", "2"]]], "Output",
 CellChangeTimes->{{3.9023937638324337`*^9, 3.90239379082658*^9}, 
   3.902393871773123*^9, {3.902393928918597*^9, 3.902393938220463*^9}, 
   3.902394013803075*^9, 3.902394101259001*^9, {3.9023942875240498`*^9, 
   3.902394326989444*^9}, {3.902394359079051*^9, 3.9023943995163603`*^9}, {
   3.902395049230513*^9, 3.902395058141214*^9}, 3.902453347225032*^9, 
   3.902814185521101*^9, 3.902889346714102*^9, 3.902889609195107*^9, 
   3.902889778578227*^9, 3.902896837183214*^9, 3.902896874981803*^9, 
   3.9029783050506372`*^9, 3.9034171392486567`*^9, 3.903435070808672*^9, 
   3.903966760220097*^9, 3.9046448866316996`*^9, 3.905056609605781*^9},
 CellLabel->"Out[15]=",ExpressionUUID->"08cbad2a-1a43-4771-877d-c55ae623d597"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"C1", "'"}], "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"Abs", "[", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["t", "1"], "-", 
           SubscriptBox["t", "2"]}], ")"}], "]"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], "L"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", 
       SubscriptBox["T", "1"], ",", 
       RowBox[{
        SubscriptBox["T", "0"], "+", 
        SubscriptBox["T", "1"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", "0", ",", 
       SubscriptBox["T", "0"]}], "}"}], ",", 
     RowBox[{"Assumptions", "->", "conds2"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.902479489106682*^9, 3.902479495366702*^9}, {
   3.9024819248091927`*^9, 3.9024819277557993`*^9}, {3.902814172847493*^9, 
   3.902814176782693*^9}, 3.9028890604002085`*^9, 3.9028890969746103`*^9, {
   3.902889343386202*^9, 3.9028893446293144`*^9}, 3.90288937728763*^9},
 CellLabel->"In[16]:=",ExpressionUUID->"85a1b555-fa5e-47bb-af6c-e194da86d697"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["T", "0"], "+", 
          SubscriptBox["T", "1"]}], ")"}], " ", 
        SubscriptBox["\[Kappa]", "t"]}], ")"}]}], "-", 
     RowBox[{"L", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        SubscriptBox["T", "0"], " ", 
        SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], "2"]}], 
  SubsuperscriptBox["\[Kappa]", "t", "2"]]], "Output",
 CellChangeTimes->{
  3.90247951868943*^9, 3.902481929295038*^9, 3.902814178205872*^9, {
   3.9028893649593825`*^9, 3.90288938429451*^9}, 3.9028897057500725`*^9, 
   3.902978306125657*^9, 3.903417142091237*^9, 3.9034350737763653`*^9, 
   3.903966673349889*^9, 3.9039667616590767`*^9, 3.9046448890609083`*^9, 
   3.905056611123995*^9},
 CellLabel->"Out[16]=",ExpressionUUID->"3eec85c9-a98f-4c81-bbde-32b160754c12"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"C1", "==", 
      RowBox[{"ToExpression", "[", 
       RowBox[{
       "\"\<\\\\frac{e^{-L \\\\kappa _x}}{\\\\kappa _t^2} \\\\left(2 \
(T_0-T_1) \\\\kappa _t-e^{-T_1 \\\\kappa _t}+e^{\\\\left(T_1-T_0\\\\right) \\\
\\kappa _t}-e^{\\\\left(T_0-T_2\\\\right) \\\\kappa _t}+e^{-T_2 \\\\kappa _t}\
\\\\right)\>\"", ",", "TeXForm"}], "]"}]}], "/.", 
     RowBox[{"e", "->", "\[ExponentialE]"}]}], "/.", 
    RowBox[{
     SubscriptBox["T", "2"], "->", 
     RowBox[{
      SubscriptBox["T", "0"], "+", 
      SubscriptBox["T", "1"]}]}]}], ",", "conds1"}], "]"}]], "Input",
 CellChangeTimes->{{3.902896688984304*^9, 3.9028967678673177`*^9}, 
   3.902897057167159*^9, {3.902897104513529*^9, 3.9028971070809174`*^9}, {
   3.9028971418160167`*^9, 3.902897151427356*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"cbbac6c0-5933-47b6-bff3-abe8c058ac62"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.902896724902356*^9, 3.9028967684170723`*^9}, 
   3.9028968384734926`*^9, 3.902897058202555*^9, 3.9028970905989666`*^9, {
   3.902897132216759*^9, 3.902897152221791*^9}, 3.903417142982566*^9, 
   3.9034350745738525`*^9, 3.90505661152075*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"a207c550-a7a3-40ff-ba83-8754a8f2419c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"C1", "==", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]", "-", "\[Tau]"}]], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "\[Beta]"}]], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"\[Tau]", "+", "\[Beta]"}]], " ", "\[Beta]"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"\[Tau]", "+", "\[Beta]"}]], " ", "\[Tau]"}]}], ")"}]}], 
      SubsuperscriptBox["\[Kappa]", "t", "2"]]}], "/.", "rule0"}], ",", 
   "conds1"}], "]"}]], "Input",
 CellChangeTimes->{{3.9028893138609486`*^9, 3.9028893314894495`*^9}, {
   3.902889389545638*^9, 3.902889546340002*^9}, {3.902889591365036*^9, 
   3.9028896381666956`*^9}, 3.9028901003228397`*^9},
 CellLabel->"In[18]:=",ExpressionUUID->"3374ad54-9ffd-4587-aa3a-8e5489aa88cf"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.90288932488647*^9, 3.9028893319902735`*^9}, {
   3.9028893871902514`*^9, 3.902889418045102*^9}, {3.9028894574415145`*^9, 
   3.902889461024794*^9}, 3.902889498238105*^9, {3.9028895310810537`*^9, 
   3.9028895465936103`*^9}, {3.9028895920835485`*^9, 3.9028896387999167`*^9}, 
   3.902890102064743*^9, {3.902896848742711*^9, 3.9028968510529337`*^9}, 
   3.9028971768516483`*^9, 3.903417143747614*^9, 3.903435075388592*^9, 
   3.905056611879776*^9},
 CellLabel->"Out[18]=",ExpressionUUID->"035ff678-8335-4580-ad13-79d2b96d3c6f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"C1", "'"}], "==", 
      RowBox[{"ToExpression", "[", 
       RowBox[{
       "\"\<\\\\frac{1}{\\\\kappa _t^2}\\\\left(e^{\\\\tau}-1\\\\right)^2 \
e^{-\\\\gamma-\\\\beta-\\\\tau}\>\"", ",", "TeXForm"}], "]"}]}], "/.", 
     RowBox[{"e", "->", "\[ExponentialE]"}]}], "/.", "rule0"}], ",", 
   "conds2"}], "]"}]], "Input",
 CellChangeTimes->{{3.902889666270437*^9, 3.902889689206287*^9}, 
   3.902889739682468*^9},
 CellLabel->"In[19]:=",ExpressionUUID->"1154fa2a-f18a-4d7c-9cbd-bb002245098f"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.902889689779333*^9, 3.902889741064512*^9}, 
   3.9034171443612185`*^9, 3.9034350761292543`*^9, 3.905056612204221*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"dc3dc997-09da-4c2e-a1af-df08e446efb8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"x", "+", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "x"}]], "-", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9047089752104797`*^9, 3.9047089928085966`*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"ecad9e5e-8129-4a4d-825f-d59587bc7eed"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwd0gk0lekfB/A3UlIRLRNZs1S6jERU3K9JZasmXErpdtEiSZSRGKHBWKOs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       "]]},
     Annotation[#, "Charting`Private`Tag$295793#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 2}, {0., 1.1353352479441754`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.90470898445479*^9, 3.90470899336109*^9}, 
   3.905056612262951*^9},
 CellLabel->"Out[20]=",ExpressionUUID->"f2f1ce3a-1966-463d-9212-9a66cb48d694"]
}, Open  ]],

Cell[TextData[StyleBox["Blue", "Subsubsection"]], "Text",
 CellChangeTimes->{{3.9024522948111353`*^9, 
  3.9024522954112453`*^9}},ExpressionUUID->"9cfd9054-8d2e-4287-a351-\
f7771ec283fa"],

Cell["I", "Text",
 CellChangeTimes->{
  3.9025646983249483`*^9},ExpressionUUID->"14822b5a-9f14-47a2-bfc3-\
0caa9726fc95"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"C2", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"Abs", "[", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["t", "1"], "-", 
           SubscriptBox["t", "2"]}], ")"}], "]"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], 
        FractionBox["L", 
         SubscriptBox["T", "1"]], 
        SubscriptBox["t", "1"]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", "0", ",", 
       SubscriptBox["T", "1"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", "0", ",", 
       SubscriptBox["T", "0"]}], "}"}], ",", 
     RowBox[{"Assumptions", "->", "conds1"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.902827708349539*^9, 3.902827740548834*^9}, 
   3.9028890090621557`*^9},
 CellLabel->"In[21]:=",ExpressionUUID->"0289b4d7-f63a-42b9-a79f-2adf966b64f1"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"L", " ", 
      SubsuperscriptBox["T", "1", "2"], " ", 
      SubsuperscriptBox["\[Kappa]", "t", "3"], " ", 
      SubscriptBox["\[Kappa]", "x"]}], "-", 
     RowBox[{
      SuperscriptBox["L", "3"], " ", 
      SubscriptBox["\[Kappa]", "t"], " ", 
      SubsuperscriptBox["\[Kappa]", "x", "3"]}]}]], 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SubscriptBox["T", "0"]}], " ", 
       SubscriptBox["\[Kappa]", "t"]}], "-", 
      RowBox[{
       SubscriptBox["T", "1"], " ", 
       SubscriptBox["\[Kappa]", "t"]}], "-", 
      RowBox[{"L", " ", 
       SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
    SubscriptBox["T", "1"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["T", "0"], "+", 
           SubscriptBox["T", "1"]}], ")"}], " ", 
         SubscriptBox["\[Kappa]", "t"]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"L", " ", 
           SubscriptBox["\[Kappa]", "x"]}]]}], ")"}], " ", 
       SubsuperscriptBox["T", "1", "2"], " ", 
       SubsuperscriptBox["\[Kappa]", "t", "2"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            SubscriptBox["T", "0"], " ", 
            SubscriptBox["\[Kappa]", "t"]}]]}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SubscriptBox["T", "1"], " ", 
           SubscriptBox["\[Kappa]", "t"]}]], "-", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SubscriptBox["T", "1"], " ", 
            SubscriptBox["\[Kappa]", "t"]}], "+", 
           RowBox[{"L", " ", 
            SubscriptBox["\[Kappa]", "x"]}]}]], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SubscriptBox["T", "0"], " ", 
            SubscriptBox["\[Kappa]", "t"]}], "+", 
           RowBox[{
            SubscriptBox["T", "1"], " ", 
            SubscriptBox["\[Kappa]", "t"]}], "+", 
           RowBox[{"L", " ", 
            SubscriptBox["\[Kappa]", "x"]}]}]]}], ")"}], " ", "L", " ", 
       SubscriptBox["T", "1"], " ", 
       SubscriptBox["\[Kappa]", "t"], " ", 
       SubscriptBox["\[Kappa]", "x"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           SubscriptBox["T", "0"], " ", 
           SubscriptBox["\[Kappa]", "t"]}]], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SubscriptBox["T", "1"], " ", 
           SubscriptBox["\[Kappa]", "t"]}]], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["T", "0"], "+", 
              SubscriptBox["T", "1"]}], ")"}], " ", 
            SubscriptBox["\[Kappa]", "t"]}]]}], "-", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SubscriptBox["T", "1"], " ", 
            SubscriptBox["\[Kappa]", "t"]}], "+", 
           RowBox[{"L", " ", 
            SubscriptBox["\[Kappa]", "x"]}]}]], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SubscriptBox["T", "0"], " ", 
            SubscriptBox["\[Kappa]", "t"]}], "+", 
           RowBox[{
            SubscriptBox["T", "1"], " ", 
            SubscriptBox["\[Kappa]", "t"]}], "+", 
           RowBox[{"L", " ", 
            SubscriptBox["\[Kappa]", "x"]}]}]]}], ")"}], " ", 
       SuperscriptBox["L", "2"], " ", 
       SubsuperscriptBox["\[Kappa]", "x", "2"]}]}], ")"}]}]}]}]], "Output",
 CellChangeTimes->{{3.902827726135701*^9, 3.902827743725334*^9}, 
   3.9028903322693005`*^9, 3.9029783087519693`*^9, 3.903417149653283*^9, 
   3.9034350817335477`*^9, 3.905056615216207*^9},
 CellLabel->"Out[21]=",ExpressionUUID->"a742ffca-55a6-4942-9e15-fc9560d29967"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"C21", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["t", "1"], "-", 
          SubscriptBox["t", "2"]}], ")"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], 
        FractionBox["L", 
         SubscriptBox["T", "1"]], 
        SubscriptBox["t", "1"]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", "0", ",", 
       SubscriptBox["T", "1"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", "0", ",", 
       SubscriptBox["t", "1"]}], "}"}], ",", 
     RowBox[{"Assumptions", "->", "conds1"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.902394992479555*^9, 3.902394998860025*^9}, {
   3.902395065240437*^9, 3.902395079944914*^9}, {3.902395126021299*^9, 
   3.9023951512208567`*^9}, {3.902827634885745*^9, 3.902827635746409*^9}, 
   3.9028890358587165`*^9},
 CellLabel->"In[22]:=",ExpressionUUID->"24a28f21-025c-4891-a4a7-8276dcb3cec2"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SubscriptBox["T", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"1", "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "L"}], " ", 
         SubscriptBox["\[Kappa]", "x"]}]]}], 
      RowBox[{"L", " ", 
       SubscriptBox["\[Kappa]", "x"]}]], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["T", "1"]}], " ", 
          SubscriptBox["\[Kappa]", "t"]}], "-", 
         RowBox[{"L", " ", 
          SubscriptBox["\[Kappa]", "x"]}]}]]}], 
      RowBox[{
       RowBox[{
        SubscriptBox["T", "1"], " ", 
        SubscriptBox["\[Kappa]", "t"]}], "+", 
       RowBox[{"L", " ", 
        SubscriptBox["\[Kappa]", "x"]}]}]]}], ")"}]}], 
  SubscriptBox["\[Kappa]", "t"]]], "Output",
 CellChangeTimes->{{3.902395072832982*^9, 3.9023950830545883`*^9}, {
   3.9023951454212503`*^9, 3.902395152680419*^9}, 3.902827690423903*^9, 
   3.9028903667738743`*^9, 3.903417152027439*^9, 3.903435084021624*^9, 
   3.903966770752496*^9, 3.905056616516446*^9},
 CellLabel->"Out[22]=",ExpressionUUID->"6b6187f0-1526-4b23-983e-c7f44a2e513c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"C22", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["t", "2"], "-", 
          SubscriptBox["t", "1"]}], ")"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], 
        FractionBox["L", 
         SubscriptBox["T", "1"]], 
        SubscriptBox["t", "1"]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", "0", ",", 
       SubscriptBox["T", "1"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", 
       SubscriptBox["t", "1"], ",", 
       SubscriptBox["T", "1"]}], "}"}], ",", 
     RowBox[{"Assumptions", "->", "conds1"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.9023951621757193`*^9, 3.902395171287384*^9}, {
   3.902827637785061*^9, 3.902827638332798*^9}, 3.902889043150876*^9},
 CellLabel->"In[23]:=",ExpressionUUID->"91ea8874-5527-4143-8de8-112b1f185b9f"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SubscriptBox["T", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"1", "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "L"}], " ", 
         SubscriptBox["\[Kappa]", "x"]}]]}], 
      RowBox[{"L", " ", 
       SubscriptBox["\[Kappa]", "x"]}]], "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", 
          SubscriptBox["T", "1"]}], " ", 
         SubscriptBox["\[Kappa]", "t"]}]], "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "L"}], " ", 
         SubscriptBox["\[Kappa]", "x"]}]]}], 
      RowBox[{
       RowBox[{
        SubscriptBox["T", "1"], " ", 
        SubscriptBox["\[Kappa]", "t"]}], "-", 
       RowBox[{"L", " ", 
        SubscriptBox["\[Kappa]", "x"]}]}]]}], ")"}]}], 
  SubscriptBox["\[Kappa]", "t"]]], "Output",
 CellChangeTimes->{3.902395172928615*^9, 3.902827691802288*^9, 
  3.9028903688514338`*^9, 3.903417154560738*^9, 3.903435086642002*^9, 
  3.90505661793922*^9},
 CellLabel->"Out[23]=",ExpressionUUID->"0172c988-0692-4f77-b694-2e572d6cfa49"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"C23", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["t", "2"], "-", 
          SubscriptBox["t", "1"]}], ")"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], 
        FractionBox["L", 
         SubscriptBox["T", "1"]], 
        SubscriptBox["t", "1"]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", "0", ",", 
       SubscriptBox["T", "1"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", 
       SubscriptBox["T", "1"], ",", 
       SubscriptBox["T", "0"]}], "}"}], ",", 
     RowBox[{"Assumptions", "->", "conds1"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.9023950965548973`*^9, 3.902395116349442*^9}, {
   3.902827640717498*^9, 3.902827641956066*^9}, 3.9028890159236064`*^9},
 CellLabel->"In[24]:=",ExpressionUUID->"2d8b2c76-f5f2-44d7-a10f-da687c8b7ed3"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["T", "0"], "+", 
          SubscriptBox["T", "1"]}], ")"}], " ", 
        SubscriptBox["\[Kappa]", "t"]}], ")"}]}], "-", 
     RowBox[{"L", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        SubscriptBox["T", "0"], " ", 
        SubscriptBox["\[Kappa]", "t"]}]]}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       SubscriptBox["T", "1"], " ", 
       SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        SubscriptBox["T", "1"], " ", 
        SubscriptBox["\[Kappa]", "t"]}]]}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"L", " ", 
       SubscriptBox["\[Kappa]", "x"]}]]}], ")"}], " ", 
   SubscriptBox["T", "1"]}], 
  RowBox[{
   SubscriptBox["\[Kappa]", "t"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["T", "1"], " ", 
      SubscriptBox["\[Kappa]", "t"]}], "-", 
     RowBox[{"L", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]]], "Output",
 CellChangeTimes->{3.902395118381104*^9, 3.90282769339775*^9, 
  3.902890371140207*^9, 3.9034171574763927`*^9, 3.9034350896860433`*^9, 
  3.905056619546441*^9},
 CellLabel->"Out[24]=",ExpressionUUID->"fda84951-a4b1-4a77-ad94-fcc17d1d0522"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C21", "+", "C22", "+", "C23"}], "==", "C2"}], "//", 
  "Simplify"}]], "Input",
 CellChangeTimes->{{3.902827694326092*^9, 3.902827699296341*^9}, {
  3.9028277444123363`*^9, 3.902827745256526*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"cabbde91-8f63-40b4-a7a9-d307fec4b66d"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.902827745621237*^9, 3.902890376464202*^9, 
  3.903417157774757*^9, 3.903435090047371*^9, 3.905056619763564*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"4ccffb39-369e-418e-b58f-f698dcc2b591"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"C2", "==", 
      RowBox[{"ToExpression", "[", 
       RowBox[{
       "\"\<\\\\frac{\\\\beta}{\\\\kappa _t^2 \
}(\\\\frac{e^{-\\\\tau}*(1-e^{\\\\beta-\\\\gamma})}{\\\\beta-\\\\gamma}-\\\\\
frac{1-e^{-\\\\beta-\\\\gamma}}{\\\\beta+\\\\gamma}+\\\\frac{2(1-e^{-\\\\\
gamma})}{\\\\gamma})\>\"", ",", "TeXForm"}], "]"}]}], "/.", 
     RowBox[{"e", "->", "\[ExponentialE]"}]}], "/.", "rule0"}], ",", 
   "conds1"}], "]"}]], "Input",
 CellChangeTimes->{{3.902890308265276*^9, 3.90289031754936*^9}, {
   3.9028903734499397`*^9, 3.9028903823529863`*^9}, {3.902890425033074*^9, 
   3.902890458393572*^9}, 3.90289049729259*^9, {3.902890546039384*^9, 
   3.9028905486042714`*^9}, {3.9028905983114014`*^9, 3.902890653458175*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"0169a95c-5460-4a44-8d22-e1ef4388b531"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.905056620519227*^9},
 CellLabel->"Out[26]=",ExpressionUUID->"484befbc-4257-4794-b648-a8e3308fa272"]
}, Open  ]],

Cell["II", "Text",
 CellChangeTimes->{{3.902564690288381*^9, 
  3.902564693043722*^9}},ExpressionUUID->"2088c8d6-ed5f-48ff-8426-\
ae87a4657567"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"C21", "'"}], "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["t", "1"], "-", 
          SubscriptBox["t", "2"]}], ")"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], 
        FractionBox["L", 
         SubscriptBox["T", "1"]], 
        SubscriptBox["t", "1"]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", 
       SubscriptBox["T", "0"], ",", 
       SubscriptBox["T", "1"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", "0", ",", 
       SubscriptBox["T", "0"]}], "}"}], ",", 
     RowBox[{"Assumptions", "->", "conds2"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.9024823827940283`*^9, 3.902482386588847*^9}, {
   3.902482431805501*^9, 3.902482457035424*^9}, {3.902810017346143*^9, 
   3.902810018689066*^9}, {3.9028276485603037`*^9, 3.9028276506589108`*^9}, 
   3.902889063776332*^9, 3.9028891030859385`*^9, 3.9028893749109335`*^9},
 CellLabel->"In[27]:=",ExpressionUUID->"1791ebdd-dca2-4a49-899d-27e5337ca2f8"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["T", "0"], "+", 
         SubscriptBox["T", "1"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["T", "1"], " ", 
          SubscriptBox["\[Kappa]", "t"]}], "+", 
         RowBox[{"L", " ", 
          SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}], 
      SubscriptBox["T", "1"]]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       SubscriptBox["T", "0"], " ", 
       SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{
        SubscriptBox["T", "1"], " ", 
        SubscriptBox["\[Kappa]", "t"]}], "+", 
       RowBox[{"L", " ", 
        SubscriptBox["\[Kappa]", "x"]}]}]], "-", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       SubscriptBox["T", "0"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[Kappa]", "t"], "+", 
         FractionBox[
          RowBox[{"L", " ", 
           SubscriptBox["\[Kappa]", "x"]}], 
          SubscriptBox["T", "1"]]}], ")"}]}]]}], ")"}], " ", 
   SubscriptBox["T", "1"]}], 
  RowBox[{
   SubscriptBox["\[Kappa]", "t"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["T", "1"], " ", 
      SubscriptBox["\[Kappa]", "t"]}], "+", 
     RowBox[{"L", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]]], "Output",
 CellChangeTimes->{
  3.902482460040041*^9, {3.902810005130032*^9, 3.902810028849082*^9}, 
   3.9028276803018723`*^9, 3.9028909216391854`*^9, 3.903417164454811*^9, 
   3.903435096918172*^9, 3.9050566233032227`*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"73bb92bc-d809-4194-a3e2-e30acd9d25fe"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"C22", "'"}], "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["t", "1"], "-", 
          SubscriptBox["t", "2"]}], ")"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], 
        FractionBox["L", 
         SubscriptBox["T", "1"]], 
        SubscriptBox["t", "1"]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", "0", ",", 
       SubscriptBox["T", "0"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", "0", ",", 
       SubscriptBox["t", "1"]}], "}"}], ",", 
     RowBox[{"Assumptions", "->", "conds2"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.902394992479555*^9, 3.902394998860025*^9}, {
   3.902395065240437*^9, 3.902395079944914*^9}, {3.902395126021299*^9, 
   3.9023951512208567`*^9}, {3.902482293336625*^9, 3.90248229607865*^9}, {
   3.902482333853258*^9, 3.902482335905431*^9}, {3.902810020546673*^9, 
   3.90281002143267*^9}, {3.9028276521371717`*^9, 3.902827652631318*^9}, 
   3.902889104446025*^9, 3.9028893749109335`*^9},
 CellLabel->"In[28]:=",ExpressionUUID->"cac04fa0-13a0-463d-8070-85a2fcbb2cc8"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SubscriptBox["T", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"1", "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"L", " ", 
           SubscriptBox["T", "0"], " ", 
           SubscriptBox["\[Kappa]", "x"]}], 
          SubscriptBox["T", "1"]]}]]}], 
      RowBox[{"L", " ", 
       SubscriptBox["\[Kappa]", "x"]}]], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         SubscriptBox["T", "0"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SubscriptBox["\[Kappa]", "t"]}], "-", 
           FractionBox[
            RowBox[{"L", " ", 
             SubscriptBox["\[Kappa]", "x"]}], 
            SubscriptBox["T", "1"]]}], ")"}]}]]}], 
      RowBox[{
       RowBox[{
        SubscriptBox["T", "1"], " ", 
        SubscriptBox["\[Kappa]", "t"]}], "+", 
       RowBox[{"L", " ", 
        SubscriptBox["\[Kappa]", "x"]}]}]]}], ")"}]}], 
  SubscriptBox["\[Kappa]", "t"]]], "Output",
 CellChangeTimes->{
  3.902482352802465*^9, {3.9028100063936653`*^9, 3.902810029804776*^9}, 
   3.9028276813635*^9, 3.9028909236896653`*^9, 3.9034171671352487`*^9, 
   3.9034350997108974`*^9, 3.905056624754438*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"810c913f-f1b1-4c95-bb89-e98de5f2b658"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"C23", "'"}], "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["t", "2"], "-", 
          SubscriptBox["t", "1"]}], ")"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], 
        FractionBox["L", 
         SubscriptBox["T", "1"]], 
        SubscriptBox["t", "1"]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", "0", ",", 
       SubscriptBox["T", "0"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", 
       SubscriptBox["t", "1"], ",", 
       SubscriptBox["T", "0"]}], "}"}], ",", 
     RowBox[{"Assumptions", "->", "conds2"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.9024823827940283`*^9, 3.9024824014397583`*^9}, {
   3.902482522790495*^9, 3.902482523520507*^9}, {3.9028100133169394`*^9, 
   3.902810023674114*^9}, {3.9028276546326427`*^9, 3.9028276559973717`*^9}, 
   3.9028891054701014`*^9, 3.9028893749109335`*^9},
 CellLabel->"In[29]:=",ExpressionUUID->"c7a912ae-6125-4ae3-8d84-852ed44a3086"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SubscriptBox["T", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", 
          FractionBox[
           RowBox[{"L", " ", 
            SubscriptBox["T", "0"], " ", 
            SubscriptBox["\[Kappa]", "x"]}], 
           SubscriptBox["T", "1"]]}]]}], ")"}], " ", 
      SubscriptBox["T", "1"], " ", 
      SubscriptBox["\[Kappa]", "t"]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["T", "0"]}], " ", 
          SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", "L", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}], 
  RowBox[{"L", " ", 
   SubscriptBox["\[Kappa]", "t"], " ", 
   SubscriptBox["\[Kappa]", "x"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["T", "1"], " ", 
      SubscriptBox["\[Kappa]", "t"]}], "-", 
     RowBox[{"L", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]]], "Output",
 CellChangeTimes->{{3.90248238828648*^9, 3.902482403203618*^9}, 
   3.902482526537726*^9, {3.902810007721919*^9, 3.902810030850255*^9}, 
   3.9028276825551662`*^9, 3.9028909259397755`*^9, 3.9034171698777375`*^9, 
   3.9034351026075172`*^9, 3.905056626256021*^9},
 CellLabel->"Out[29]=",ExpressionUUID->"7a974953-4384-452e-be73-4be2f6d826a3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"C2", "'"}], "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"Abs", "[", 
         RowBox[{
          SubscriptBox["t", "2"], "-", 
          SubscriptBox["t", "1"]}], "]"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], 
        FractionBox["L", 
         SubscriptBox["T", "1"]], 
        SubscriptBox["t", "1"]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", "0", ",", 
       SubscriptBox["T", "1"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", "0", ",", 
       SubscriptBox["T", "0"]}], "}"}], ",", 
     RowBox[{"Assumptions", "->", "conds2"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.902482494723316*^9, 3.9024825201298656`*^9}, {
   3.902482605207243*^9, 3.902482605508136*^9}, {3.9028100110461273`*^9, 
   3.9028100118676643`*^9}, {3.902827658912321*^9, 3.9028276603230343`*^9}, 
   3.9028891069900975`*^9, 3.9028893749109335`*^9},
 CellLabel->"In[30]:=",ExpressionUUID->"1c84807b-e564-419c-9395-c59c02186905"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    RowBox[{"L", " ", 
     SubsuperscriptBox["T", "1", "2"], " ", 
     SubsuperscriptBox["\[Kappa]", "t", "3"], " ", 
     SubscriptBox["\[Kappa]", "x"]}], "-", 
    RowBox[{
     SuperscriptBox["L", "3"], " ", 
     SubscriptBox["\[Kappa]", "t"], " ", 
     SubsuperscriptBox["\[Kappa]", "x", "3"]}]}]], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SubscriptBox["T", "0"]}], "+", 
         SubscriptBox["T", "1"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["T", "1"], " ", 
          SubscriptBox["\[Kappa]", "t"]}], "+", 
         RowBox[{"L", " ", 
          SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}], 
      SubscriptBox["T", "1"]]}]], " ", 
   SubscriptBox["T", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         SubscriptBox["T", "1"], " ", 
         SubscriptBox["\[Kappa]", "t"]}], "+", 
        RowBox[{"L", " ", 
         SubscriptBox["\[Kappa]", "x"]}], "+", 
        RowBox[{
         SubscriptBox["T", "0"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SubscriptBox["\[Kappa]", "t"]}], "+", 
           FractionBox[
            RowBox[{"2", " ", "L", " ", 
             SubscriptBox["\[Kappa]", "x"]}], 
            SubscriptBox["T", "1"]]}], ")"}]}]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         FractionBox[
          RowBox[{"L", " ", 
           SubscriptBox["T", "0"], " ", 
           SubscriptBox["\[Kappa]", "x"]}], 
          SubscriptBox["T", "1"]]]}], ")"}], " ", 
      SubsuperscriptBox["T", "1", "2"], " ", 
      SubsuperscriptBox["\[Kappa]", "t", "2"]}], "-", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        SubscriptBox["T", "0"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SubscriptBox["\[Kappa]", "t"]}], "+", 
          FractionBox[
           RowBox[{"3", " ", "L", " ", 
            SubscriptBox["\[Kappa]", "x"]}], 
           SubscriptBox["T", "1"]]}], ")"}]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          SubscriptBox["T", "0"], " ", 
          SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          SubscriptBox["T", "0"], " ", 
          SubscriptBox["\[Kappa]", "t"]}]], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SubscriptBox["T", "1"], " ", 
           SubscriptBox["\[Kappa]", "t"]}], "+", 
          RowBox[{"L", " ", 
           SubscriptBox["\[Kappa]", "x"]}]}]]}], ")"}], " ", "L", " ", 
      SubscriptBox["T", "1"], " ", 
      SubscriptBox["\[Kappa]", "t"], " ", 
      SubscriptBox["\[Kappa]", "x"]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        SubscriptBox["T", "0"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SubscriptBox["\[Kappa]", "t"]}], "+", 
          FractionBox[
           RowBox[{"3", " ", "L", " ", 
            SubscriptBox["\[Kappa]", "x"]}], 
           SubscriptBox["T", "1"]]}], ")"}]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          SubscriptBox["T", "0"], " ", 
          SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          SubscriptBox["T", "0"], " ", 
          SubscriptBox["\[Kappa]", "t"]}]], "-", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SubscriptBox["T", "1"], " ", 
           SubscriptBox["\[Kappa]", "t"]}], "+", 
          RowBox[{"L", " ", 
           SubscriptBox["\[Kappa]", "x"]}]}]]}], ")"}], " ", 
      SuperscriptBox["L", "2"], " ", 
      SubsuperscriptBox["\[Kappa]", "x", "2"]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.902482611625225*^9, {3.902810012988928*^9, 3.902810034746716*^9}, 
   3.902827686916069*^9, 3.9028906784934216`*^9, 3.902978318343511*^9, 
   3.9034171807205777`*^9, 3.9034351139485717`*^9, 3.9039667807884007`*^9, 
   3.905056632107417*^9},
 CellLabel->"Out[30]=",ExpressionUUID->"cb8a08c8-7aa0-461d-9d0a-142fa5b0e192"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C2", "'"}], "==", 
   RowBox[{
    RowBox[{"C21", "'"}], "+", 
    RowBox[{"C22", "'"}], "+", 
    RowBox[{"C23", "'"}]}]}], " ", "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.9024826140460043`*^9, 3.902482637219186*^9}, {
  3.902810032796208*^9, 3.902810039315009*^9}, {3.902827664169395*^9, 
  3.902827673797372*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"074756c4-0a0f-4aa5-9c16-844249028206"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.902482634208811*^9, 3.902482638190651*^9}, 
   3.902810040298931*^9, 3.902827687649088*^9, 3.9028909335998755`*^9, 
   3.9034171821388655`*^9, 3.9034351153818817`*^9, 3.905056632898713*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"47f1a27b-4ee3-4ba1-a573-f7a4ffafe56b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"C2", "'"}], "==", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
        "\"\<\\\\frac{\\\\beta}{\\\\kappa \
_t^2}(\\\\frac{e^{-\\\\tau*\\\\gamma/\\\\beta} \
-e^{\\\\tau-\\\\beta-\\\\gamma}+e^{-\\\\beta-\\\\gamma}-1}{\\\\beta+\\\\gamma}\
 +\\\\frac{2-e^{-\\\\frac{\\\\gamma*\\\\tau}{\\\\beta}}}{\\\\gamma}\n\
+\\\\frac{ \\\\gamma e^{-\\\\tau}-\\\\beta e^{-\\\\frac{\\\\gamma*\\\\tau}{\\\
\\beta}}}{\\\\gamma *(\\\\beta-\\\\gamma)} )\>\"", ",", "TeXForm"}], "]"}]}], 
      "/.", 
      RowBox[{"e", "->", "\[ExponentialE]"}]}], "/.", "rule0"}], "/.", 
    "rule0"}], ",", "conds2"}], "]"}]], "Input",
 CellChangeTimes->{{3.90289067330938*^9, 3.902890824522649*^9}, {
  3.902891360942681*^9, 3.9028913612443075`*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"495f8559-5b48-482c-a814-9920ca54dad9"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.902890697176396*^9, 3.902890756055503*^9}, {
   3.9028907868692474`*^9, 3.902890829842786*^9}, 3.9028913654277153`*^9, 
   3.9034171879041147`*^9, 3.9034351212216606`*^9, 3.9050566357508717`*^9},
 CellLabel->"Out[32]=",ExpressionUUID->"015dc176-c933-49ee-895d-d34937a79895"]
}, Open  ]],

Cell[TextData[StyleBox["Yellow", "Subsubsection"]], "Text",
 CellChangeTimes->{{3.902452246474814*^9, 3.902452247063238*^9}, {
  3.9024523219168577`*^9, 
  3.902452326625146*^9}},ExpressionUUID->"991017f2-bbdc-4acd-8584-\
9af1704fb570"],

Cell["I", "Text",
 CellChangeTimes->{
  3.9028100801735067`*^9},ExpressionUUID->"1bc47a79-1a70-41e9-aecf-\
1aadd0d6753d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"C3", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SubscriptBox["\[Kappa]", "t"]}], 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["t", "2"], "-", 
         SubscriptBox["t", "1"]}], ")"}]}], "-", 
      RowBox[{
       SubscriptBox["\[Kappa]", "x"], 
       FractionBox["L", 
        SubscriptBox["T", "1"]], 
       RowBox[{"Abs", "[", 
        RowBox[{
         SubscriptBox["t", "1"], "-", 
         SubscriptBox["t", "2"], "+", 
         SubscriptBox["T", "0"]}], "]"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["t", "1"], ",", "0", ",", 
      SubscriptBox["T", "1"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["t", "2"], ",", 
      SubscriptBox["T", "0"], ",", 
      RowBox[{
       SubscriptBox["T", "0"], "+", 
       SubscriptBox["T", "1"]}]}], "}"}], ",", 
    RowBox[{"Assumptions", "->", "conds1"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.902827446451418*^9, 3.902827475038775*^9}, 
   3.9028891462460985`*^9},
 CellLabel->"In[33]:=",ExpressionUUID->"59446b82-0553-4223-80c6-41a9d1dde86c"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SubscriptBox["T", "1"], " ", 
         SubscriptBox["\[Kappa]", "t"]}], "-", 
        RowBox[{"L", " ", 
         SubscriptBox["\[Kappa]", "x"]}]}], ")"}], "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SubscriptBox["T", "1"], " ", 
         SubscriptBox["\[Kappa]", "t"]}], "+", 
        RowBox[{"L", " ", 
         SubscriptBox["\[Kappa]", "x"]}]}], ")"}], "2"]}]], 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SubscriptBox["T", "0"]}], " ", 
       SubscriptBox["\[Kappa]", "t"]}], "-", 
      RowBox[{
       SubscriptBox["T", "1"], " ", 
       SubscriptBox["\[Kappa]", "t"]}], "-", 
      RowBox[{"L", " ", 
       SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
    SubsuperscriptBox["T", "1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SubsuperscriptBox["T", "1", "2"]}], " ", 
       SubsuperscriptBox["\[Kappa]", "t", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", 
         SubscriptBox["T", "1"], " ", 
         SubscriptBox["\[Kappa]", "t"]}]], " ", 
       SubsuperscriptBox["T", "1", "2"], " ", 
       SubsuperscriptBox["\[Kappa]", "t", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SubscriptBox["T", "1"], " ", 
          SubscriptBox["\[Kappa]", "t"]}], "+", 
         RowBox[{"L", " ", 
          SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
       SubsuperscriptBox["T", "1", "2"], " ", 
       SubsuperscriptBox["\[Kappa]", "t", "2"]}], "+", 
      RowBox[{"2", " ", "L", " ", 
       SubscriptBox["T", "1"], " ", 
       SubscriptBox["\[Kappa]", "t"], " ", 
       SubscriptBox["\[Kappa]", "x"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", 
         SubscriptBox["T", "1"], " ", 
         SubscriptBox["\[Kappa]", "t"]}]], " ", "L", " ", 
       SubscriptBox["T", "1"], " ", 
       SubscriptBox["\[Kappa]", "t"], " ", 
       SubscriptBox["\[Kappa]", "x"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SubscriptBox["T", "1"], " ", 
          SubscriptBox["\[Kappa]", "t"]}], "+", 
         RowBox[{"L", " ", 
          SubscriptBox["\[Kappa]", "x"]}]}]], " ", "L", " ", 
       SubsuperscriptBox["T", "1", "2"], " ", 
       SubsuperscriptBox["\[Kappa]", "t", "2"], " ", 
       SubscriptBox["\[Kappa]", "x"]}], "-", 
      RowBox[{
       SuperscriptBox["L", "2"], " ", 
       SubsuperscriptBox["\[Kappa]", "x", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", 
         SubscriptBox["T", "1"], " ", 
         SubscriptBox["\[Kappa]", "t"]}]], " ", 
       SuperscriptBox["L", "2"], " ", 
       SubsuperscriptBox["\[Kappa]", "x", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SubscriptBox["T", "1"], " ", 
          SubscriptBox["\[Kappa]", "t"]}], "+", 
         RowBox[{"L", " ", 
          SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
       SuperscriptBox["L", "2"], " ", 
       SubsuperscriptBox["\[Kappa]", "x", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SubscriptBox["T", "1"], " ", 
          SubscriptBox["\[Kappa]", "t"]}], "+", 
         RowBox[{"L", " ", 
          SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
       SuperscriptBox["L", "3"], " ", 
       SubsuperscriptBox["\[Kappa]", "x", "3"]}]}], ")"}]}]}]}]], "Output",
 CellChangeTimes->{3.9028274791845837`*^9, 3.9028914595157814`*^9, 
  3.903417194092191*^9, 3.9034351272475843`*^9, 3.904640917113906*^9, 
  3.905056638961314*^9},
 CellLabel->"Out[33]=",ExpressionUUID->"216ae1f0-7342-4737-969f-f6c55c33dde4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"C31", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["t", "2"], "-", 
          SubscriptBox["t", "1"]}], ")"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], 
        FractionBox["L", 
         SubscriptBox["T", "1"]], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["t", "1"], "-", 
          SubscriptBox["t", "2"], "+", 
          SubscriptBox["T", "0"]}], ")"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", "0", ",", 
       SubscriptBox["T", "1"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", 
       SubscriptBox["T", "0"], ",", 
       RowBox[{
        SubscriptBox["T", "0"], "+", 
        SubscriptBox["t", "1"]}]}], "}"}], ",", 
     RowBox[{"Assumptions", "->", "conds1"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.90239265858636*^9, 3.902392794652018*^9}, {
   3.902392831062742*^9, 3.902392846473455*^9}, {3.902392909047925*^9, 
   3.9023929466664343`*^9}, {3.9023941140483627`*^9, 3.902394117544795*^9}, {
   3.902460946685173*^9, 3.902460981866023*^9}, {3.902484728336247*^9, 
   3.902484802075279*^9}, {3.902484842325776*^9, 3.902484859331828*^9}, {
   3.902827409220709*^9, 3.902827422471696*^9}, 3.9028891391843863`*^9},
 CellLabel->"In[34]:=",ExpressionUUID->"7c2bfd3b-e112-4a28-bd4b-e3fcc8bfd04a"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["T", "0"]}], " ", 
     SubscriptBox["\[Kappa]", "t"]}]], " ", 
   SubsuperscriptBox["T", "1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{
        SubscriptBox["T", "1"], " ", 
        SubscriptBox["\[Kappa]", "t"]}], "-", 
       RowBox[{"L", " ", 
        SubscriptBox["\[Kappa]", "x"]}]}]], "-", 
     RowBox[{
      SubscriptBox["T", "1"], " ", 
      SubscriptBox["\[Kappa]", "t"]}], "+", 
     RowBox[{"L", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["T", "1"], " ", 
      SubscriptBox["\[Kappa]", "t"]}], "-", 
     RowBox[{"L", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}], ")"}], "2"]]], "Output",
 CellChangeTimes->{{3.9023928263105392`*^9, 3.902392834362196*^9}, 
   3.9023929181411457`*^9, 3.902392948588251*^9, 3.902394119613283*^9, 
   3.902460987274321*^9, {3.902484733705234*^9, 3.90248480741212*^9}, 
   3.902484860786729*^9, 3.9028274803470907`*^9, 3.9034171965714407`*^9, 
   3.9034351298679624`*^9, 3.9050566402878227`*^9},
 CellLabel->"Out[34]=",ExpressionUUID->"35b7d333-f16b-467a-87c3-2d0a3a434ca4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"C32", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["t", "2"], "-", 
          SubscriptBox["t", "1"]}], ")"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], 
        FractionBox["L", 
         SubscriptBox["T", "1"]], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["t", "1"]}], "+", 
          SubscriptBox["t", "2"], "-", 
          SubscriptBox["T", "0"]}], ")"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", "0", ",", 
       SubscriptBox["T", "1"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", 
       RowBox[{
        SubscriptBox["T", "0"], "+", 
        SubscriptBox["t", "1"]}], ",", 
       RowBox[{
        SubscriptBox["T", "0"], "+", 
        SubscriptBox["T", "1"]}]}], "}"}], ",", 
     RowBox[{"Assumptions", "->", "conds1"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.902392988286139*^9, 3.9023930013883953`*^9}, {
   3.9023941243744392`*^9, 3.902394127943926*^9}, {3.902484724504574*^9, 
   3.902484725319875*^9}, {3.902827425858214*^9, 3.902827428114647*^9}, 
   3.9028891391843863`*^9},
 CellLabel->"In[35]:=",ExpressionUUID->"067d730d-7707-4444-8e0c-c439ed8ea337"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["T", "0"]}], " ", 
     SubscriptBox["\[Kappa]", "t"]}]], " ", 
   SubsuperscriptBox["T", "1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["T", "1"]}], " ", 
        SubscriptBox["\[Kappa]", "t"]}], "-", 
       RowBox[{"L", " ", 
        SubscriptBox["\[Kappa]", "x"]}]}]], "+", 
     RowBox[{
      SubscriptBox["T", "1"], " ", 
      SubscriptBox["\[Kappa]", "t"]}], "+", 
     RowBox[{"L", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["T", "1"], " ", 
      SubscriptBox["\[Kappa]", "t"]}], "+", 
     RowBox[{"L", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}], ")"}], "2"]]], "Output",
 CellChangeTimes->{3.902393003089308*^9, 3.902394130002397*^9, 
  3.902484727263698*^9, 3.902827481607849*^9, 3.9034171992929106`*^9, 
  3.903435132605447*^9, 3.905056641745097*^9},
 CellLabel->"Out[35]=",ExpressionUUID->"020b9355-25d4-4164-b9ae-6e84a7c6e618"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"C3", "==", 
   RowBox[{"C31", "+", "C32"}]}], " ", "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.902484892630548*^9, 3.902484902991699*^9}, {
  3.9028274351866817`*^9, 3.902827440333858*^9}, {3.9028274813514223`*^9, 
  3.9028274816479063`*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"d4a50e2f-3c60-4c36-b2eb-3e1e1de7db46"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.9024848997634478`*^9, 3.9024849033118353`*^9}, 
   3.902827482094561*^9, 3.903417199517114*^9, 3.9034351328396597`*^9, 
   3.90505664192028*^9},
 CellLabel->"Out[36]=",ExpressionUUID->"2e99774e-5827-49d4-8808-fa8755936c71"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"C3", "==", 
      RowBox[{"ToExpression", "[", 
       RowBox[{
       "\"\<\\\\frac{\\\\beta^2 e^{-\\\\tau} \
}{\\\\kappa_t^2}\\\\left(\\\\frac{e^{-\\\\beta-\\\\gamma}+\\\\beta+\\\\gamma-\
1}{(\\\\beta+\\\\gamma)^2}\n\
+\\\\frac{e^{-(\\\\gamma-\\\\beta)}+\\\\gamma-\\\\beta-1}{(\\\\gamma-\\\\beta)\
^2}\\\\right)\>\"", ",", "TeXForm"}], "]"}]}], "/.", 
     RowBox[{"e", "->", "\[ExponentialE]"}]}], "/.", "rule0"}], ",", 
   "conds1"}], "]"}]], "Input",
 CellChangeTimes->{{3.9028914643682833`*^9, 3.9028914994491863`*^9}},
 CellLabel->"In[37]:=",ExpressionUUID->"a964eb68-d651-4b26-8583-3c51c40ce455"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.902891482022827*^9, 3.90289150022126*^9}, 
   3.9034171995531464`*^9, 3.903435132876693*^9, 3.905056641976259*^9},
 CellLabel->"Out[37]=",ExpressionUUID->"cda055eb-866b-465c-bef3-24aaa31a08dc"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.9029027873255887`*^9, 3.9029027954858136`*^9}},
 CellLabel->"In[38]:=",ExpressionUUID->"42382481-e315-42ca-b4c9-c354e44070c7"],

Cell["II", "Text",
 CellChangeTimes->{{3.902810084704501*^9, 
  3.902810085527814*^9}},ExpressionUUID->"c814c651-6cd2-4e9d-9d65-\
37d50228d415"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"C3", "'"}], "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"Abs", "[", 
         RowBox[{
          SubscriptBox["t", "2"], "-", 
          SubscriptBox["t", "1"]}], "]"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], 
        FractionBox["L", 
         SubscriptBox["T", "1"]], 
        RowBox[{"Abs", "[", 
         RowBox[{
          SubscriptBox["t", "1"], "-", 
          SubscriptBox["t", "2"], "+", 
          SubscriptBox["T", "0"]}], "]"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", "0", ",", 
       SubscriptBox["T", "1"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", 
       SubscriptBox["T", "0"], ",", 
       RowBox[{
        SubscriptBox["T", "0"], "+", 
        SubscriptBox["T", "1"]}]}], "}"}], ",", 
     RowBox[{"Assumptions", "->", "conds2"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.902483921918222*^9, 3.9024839656604023`*^9}, {
   3.902484718064118*^9, 3.9024847190611877`*^9}, {3.90281008810301*^9, 
   3.902810089657696*^9}, {3.902827491178446*^9, 3.902827492792034*^9}, 
   3.902889164287569*^9, {3.902978858943397*^9, 3.9029788628402452`*^9}},
 CellLabel->"In[39]:=",ExpressionUUID->"901de504-192f-454a-bddd-4d330203bdbe"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubsuperscriptBox["T", "1", "2"], " ", 
       SubsuperscriptBox["\[Kappa]", "t", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["L", "2"], " ", 
       SubsuperscriptBox["\[Kappa]", "x", "2"]}]}], ")"}], "2"]], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["T", "0"], "+", 
         SubscriptBox["T", "1"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["T", "1"], " ", 
          SubscriptBox["\[Kappa]", "t"]}], "+", 
         RowBox[{"L", " ", 
          SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}], 
      SubscriptBox["T", "1"]]}]], " ", 
   SubsuperscriptBox["T", "1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         SubscriptBox["T", "0"], " ", 
         SubscriptBox["\[Kappa]", "t"]}], "+", 
        RowBox[{
         SubscriptBox["T", "1"], " ", 
         SubscriptBox["\[Kappa]", "t"]}], "+", 
        RowBox[{"L", " ", 
         SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
      SubsuperscriptBox["T", "1", "3"], " ", 
      SubsuperscriptBox["\[Kappa]", "t", "3"]}], "-", 
     RowBox[{"2", " ", "L", " ", 
      SubscriptBox["T", "1"], " ", 
      SubscriptBox["\[Kappa]", "t"], " ", 
      SubscriptBox["\[Kappa]", "x"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         FractionBox[
          RowBox[{"L", " ", 
           SubscriptBox["T", "0"], " ", 
           SubscriptBox["\[Kappa]", "x"]}], 
          SubscriptBox["T", "1"]]], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SubscriptBox["T", "0"], " ", 
            SubscriptBox["\[Kappa]", "t"]}], "+", 
           RowBox[{
            SubscriptBox["T", "1"], " ", 
            SubscriptBox["\[Kappa]", "t"]}], "+", 
           RowBox[{"L", " ", 
            SubscriptBox["\[Kappa]", "x"]}]}]]}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          SubscriptBox["T", "0"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SubscriptBox["\[Kappa]", "t"]}], "+", 
            FractionBox[
             RowBox[{"L", " ", 
              SubscriptBox["\[Kappa]", "x"]}], 
             SubscriptBox["T", "1"]]}], ")"}]}]], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SubscriptBox["T", "0"], " ", 
            SubscriptBox["\[Kappa]", "t"]}], "+", 
           RowBox[{
            SubscriptBox["T", "1"], " ", 
            SubscriptBox["\[Kappa]", "t"]}], "+", 
           RowBox[{"L", " ", 
            SubscriptBox["\[Kappa]", "x"]}]}]], " ", "L", " ", 
         SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}], "+", 
     RowBox[{
      SubsuperscriptBox["T", "1", "2"], " ", 
      SubsuperscriptBox["\[Kappa]", "t", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SubscriptBox["T", "0"], " ", 
            SubscriptBox["\[Kappa]", "t"]}], "+", 
           RowBox[{
            SubscriptBox["T", "1"], " ", 
            SubscriptBox["\[Kappa]", "t"]}], "+", 
           RowBox[{"L", " ", 
            SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
         SubscriptBox["T", "0"], " ", 
         SubscriptBox["\[Kappa]", "t"]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          FractionBox[
           RowBox[{"L", " ", 
            SubscriptBox["T", "0"], " ", 
            SubscriptBox["\[Kappa]", "x"]}], 
           SubscriptBox["T", "1"]]], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"2", " ", 
             SubscriptBox["T", "0"], " ", 
             SubscriptBox["\[Kappa]", "t"]}]], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SubscriptBox["T", "1"], " ", 
               SubscriptBox["\[Kappa]", "t"]}], "+", 
              RowBox[{"L", " ", 
               SubscriptBox["\[Kappa]", "x"]}]}]]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SubscriptBox["T", "1"], " ", 
               SubscriptBox["\[Kappa]", "t"]}], "+", 
              RowBox[{"L", " ", 
               SubscriptBox["\[Kappa]", "x"]}]}]], " ", "L", " ", 
            SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["L", "2"], " ", 
      SubsuperscriptBox["\[Kappa]", "x", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SubscriptBox["T", "0"], " ", 
            SubscriptBox["\[Kappa]", "t"]}], "+", 
           RowBox[{
            SubscriptBox["T", "1"], " ", 
            SubscriptBox["\[Kappa]", "t"]}], "+", 
           RowBox[{"L", " ", 
            SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
         SubscriptBox["T", "0"], " ", 
         SubscriptBox["\[Kappa]", "t"]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          FractionBox[
           RowBox[{"L", " ", 
            SubscriptBox["T", "0"], " ", 
            SubscriptBox["\[Kappa]", "x"]}], 
           SubscriptBox["T", "1"]]], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"2", " ", 
             SubscriptBox["T", "0"], " ", 
             SubscriptBox["\[Kappa]", "t"]}]], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SubscriptBox["T", "1"], " ", 
               SubscriptBox["\[Kappa]", "t"]}], "+", 
              RowBox[{"L", " ", 
               SubscriptBox["\[Kappa]", "x"]}]}]]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SubscriptBox["T", "1"], " ", 
               SubscriptBox["\[Kappa]", "t"]}], "+", 
              RowBox[{"L", " ", 
               SubscriptBox["\[Kappa]", "x"]}]}]], " ", "L", " ", 
            SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{3.9024839730980883`*^9, 3.902484725324242*^9, 
  3.9028101319611387`*^9, 3.902827499186317*^9, 3.9029031300481167`*^9, 
  3.902978870057184*^9, 3.903417213544845*^9, 3.9034351475630217`*^9, 
  3.9039667934720373`*^9, 3.9046409531986685`*^9, 3.905056649190721*^9},
 CellLabel->"Out[39]=",ExpressionUUID->"bd2fa1c8-1d63-4c89-aadd-7521b4a46893"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"C31", "'"}], "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["t", "2"], "-", 
          SubscriptBox["t", "1"]}], ")"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], 
        FractionBox["L", 
         SubscriptBox["T", "1"]], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["t", "2"], "-", 
            SubscriptBox["T", "0"]}], ")"}], "-", 
          SubscriptBox["t", "1"]}], ")"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", "0", ",", 
       SubscriptBox["T", "1"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", 
       RowBox[{
        SubscriptBox["T", "0"], "+", 
        SubscriptBox["t", "1"]}], ",", 
       RowBox[{
        SubscriptBox["T", "0"], "+", 
        SubscriptBox["T", "1"]}]}], "}"}], ",", 
     RowBox[{"Assumptions", "->", "conds2"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.902484880217452*^9, 3.902484886119914*^9}, {
   3.902485021155587*^9, 3.902485073221388*^9}, {3.902485381966523*^9, 
   3.902485383975874*^9}, {3.9028100981286182`*^9, 3.902810098700159*^9}, 
   3.902827495375299*^9, 3.902889161816012*^9},
 CellLabel->"In[40]:=",ExpressionUUID->"c432cfee-ea98-48fb-ba75-db154aac04da"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["T", "0"]}], " ", 
     SubscriptBox["\[Kappa]", "t"]}]], " ", 
   SubsuperscriptBox["T", "1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["T", "1"]}], " ", 
        SubscriptBox["\[Kappa]", "t"]}], "-", 
       RowBox[{"L", " ", 
        SubscriptBox["\[Kappa]", "x"]}]}]], "+", 
     RowBox[{
      SubscriptBox["T", "1"], " ", 
      SubscriptBox["\[Kappa]", "t"]}], "+", 
     RowBox[{"L", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["T", "1"], " ", 
      SubscriptBox["\[Kappa]", "t"]}], "+", 
     RowBox[{"L", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}], ")"}], "2"]]], "Output",
 CellChangeTimes->{3.902484889423286*^9, 3.9024850802172737`*^9, 
  3.90248531025041*^9, 3.902485385711135*^9, 3.902810133319593*^9, 
  3.9028275004046783`*^9, 3.902978872562683*^9, 3.903417216434468*^9, 
  3.9034351505397234`*^9, 3.9046410025337906`*^9, 3.905056650709234*^9},
 CellLabel->"Out[40]=",ExpressionUUID->"c74e7687-6de7-4bae-89a5-996f7bfc50fa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"C32", "'"}], "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["t", "2"], "-", 
          SubscriptBox["t", "1"]}], ")"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], 
        FractionBox["L", 
         SubscriptBox["T", "1"]], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["t", "1"], "-", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["t", "2"], "-", 
            SubscriptBox["T", "0"]}], ")"}]}], ")"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", "0", ",", 
       SubscriptBox["T", "0"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", 
       SubscriptBox["T", "0"], ",", 
       RowBox[{
        SubscriptBox["T", "0"], "+", 
        SubscriptBox["t", "1"]}]}], "}"}], ",", 
     RowBox[{"Assumptions", "->", "conds2"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.902485114031539*^9, 3.902485151170458*^9}, {
   3.902485387738604*^9, 3.902485429966296*^9}, {3.902810100997066*^9, 
   3.902810102124114*^9}, 3.9028274986592503`*^9, 3.902889161816012*^9},
 CellLabel->"In[41]:=",ExpressionUUID->"751aeec6-75f5-4fb3-a236-c25564882d0c"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["T", "0"]}], " ", 
     SubscriptBox["\[Kappa]", "t"]}]], " ", 
   SubscriptBox["T", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["T", "1"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          SubscriptBox["T", "0"], " ", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["\[Kappa]", "t"], "-", 
            FractionBox[
             RowBox[{"L", " ", 
              SubscriptBox["\[Kappa]", "x"]}], 
             SubscriptBox["T", "1"]]}], ")"}]}]], "-", 
        RowBox[{
         SubscriptBox["T", "0"], " ", 
         SubscriptBox["\[Kappa]", "t"]}]}], ")"}]}], "+", 
     RowBox[{"L", " ", 
      SubscriptBox["T", "0"], " ", 
      SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["T", "1"], " ", 
      SubscriptBox["\[Kappa]", "t"]}], "-", 
     RowBox[{"L", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}], ")"}], "2"]]], "Output",
 CellChangeTimes->{{3.902485128260597*^9, 3.902485153073234*^9}, 
   3.902485311360325*^9, {3.902485395343309*^9, 3.9024854315230923`*^9}, 
   3.9028101345686274`*^9, 3.902827505329163*^9, 3.9029788738000393`*^9, 
   3.9034172188166447`*^9, 3.9034351530449977`*^9, 3.9046410051371574`*^9, 
   3.905056652004952*^9},
 CellLabel->"Out[41]=",ExpressionUUID->"29e4afaf-dd12-4c47-b539-fca785224382"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"C33", "'"}], "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["t", "2"], "-", 
          SubscriptBox["t", "1"]}], ")"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], 
        FractionBox["L", 
         SubscriptBox["T", "1"]], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["t", "1"], "-", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["t", "2"], "-", 
            SubscriptBox["T", "0"]}], ")"}]}], ")"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", 
       SubscriptBox["T", "0"], ",", 
       SubscriptBox["T", "1"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", 
       SubscriptBox["t", "1"], ",", 
       RowBox[{
        SubscriptBox["T", "0"], "+", 
        SubscriptBox["t", "1"]}]}], "}"}], ",", 
     RowBox[{"Assumptions", "->", "conds2"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.902485434958852*^9, 3.9024854882944937`*^9}, {
   3.902810103838334*^9, 3.902810104636529*^9}, 3.902827505695675*^9, 
   3.902889161816012*^9},
 CellLabel->"In[42]:=",ExpressionUUID->"4397fd29-efa7-4831-b77b-4794ea958dba"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["T", "0"]}], " ", 
        SubscriptBox["\[Kappa]", "t"]}]]}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"L", " ", 
         SubscriptBox["T", "0"], " ", 
         SubscriptBox["\[Kappa]", "x"]}], 
        SubscriptBox["T", "1"]]}]]}], ")"}], " ", 
   SubscriptBox["T", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["T", "0"]}], "+", 
     SubscriptBox["T", "1"]}], ")"}]}], 
  RowBox[{
   RowBox[{
    SubscriptBox["T", "1"], " ", 
    SubscriptBox["\[Kappa]", "t"]}], "-", 
   RowBox[{"L", " ", 
    SubscriptBox["\[Kappa]", "x"]}]}]]], "Output",
 CellChangeTimes->{3.902485647182909*^9, 3.902810135213456*^9, 
  3.902827506869623*^9, 3.902978874573798*^9, 3.9034172202989984`*^9, 
  3.903435154589399*^9, 3.9046410067105885`*^9, 3.9050566528526697`*^9},
 CellLabel->"Out[42]=",ExpressionUUID->"d2a376a3-9f04-4055-aa2b-308bdc00fdd4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"C34", "'"}], "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["t", "1"], "-", 
          SubscriptBox["t", "2"]}], ")"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], 
        FractionBox["L", 
         SubscriptBox["T", "1"]], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["t", "1"], "-", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["t", "2"], "-", 
            SubscriptBox["T", "0"]}], ")"}]}], ")"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", 
       SubscriptBox["T", "0"], ",", 
       SubscriptBox["T", "1"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", 
       SubscriptBox["T", "0"], ",", 
       SubscriptBox["t", "1"]}], "}"}], ",", 
     RowBox[{"Assumptions", "->", "conds2"}]}], "]"}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.902485660222436*^9, 3.90248566173587*^9}, {
   3.902485694092297*^9, 3.902485700479783*^9}, {3.90248609073724*^9, 
   3.902486105119277*^9}, {3.902810110165358*^9, 3.9028101113570833`*^9}, 
   3.9028275078271646`*^9, 3.902889161816012*^9},
 CellLabel->"In[43]:=",ExpressionUUID->"43b3ea7d-442b-4255-9e62-28697721acff"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SubscriptBox["T", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["T", "0"], "-", 
           SubscriptBox["T", "1"]}], ")"}], " ", 
         SubscriptBox["\[Kappa]", "t"]}], "-", 
        RowBox[{"L", " ", 
         SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
      SubscriptBox["T", "1"]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"L", " ", 
          SubscriptBox["T", "0"], " ", 
          SubscriptBox["\[Kappa]", "x"]}], 
         SubscriptBox["T", "1"]]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SubscriptBox["T", "1"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               SubscriptBox["T", "0"]}], "+", 
              SubscriptBox["T", "1"]}], ")"}], " ", 
            SubscriptBox["\[Kappa]", "t"]}]}], ")"}]}], "+", 
        RowBox[{"L", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SubscriptBox["T", "0"]}], "+", 
           SubscriptBox["T", "1"]}], ")"}], " ", 
         SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["T", "1"], " ", 
      SubscriptBox["\[Kappa]", "t"]}], "+", 
     RowBox[{"L", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}], ")"}], "2"]]], "Output",
 CellChangeTimes->{3.902485703954125*^9, 3.902486109361862*^9, 
  3.9028101387320766`*^9, 3.902827530918551*^9, 3.90297887811052*^9, 
  3.903417227116185*^9, 3.9034351617248755`*^9, 3.904641013767003*^9, 
  3.905056656324575*^9},
 CellLabel->"Out[43]=",ExpressionUUID->"0b6a3d12-5e64-42ae-9159-8d31c504eaea"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C3", "'"}], "==", 
   RowBox[{
    RowBox[{"C31", "'"}], "+", 
    RowBox[{"C32", "'"}], "+", 
    RowBox[{"C33", "'"}], "+", 
    RowBox[{"C34", "'"}]}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.9024853270958843`*^9, 3.902485337080895*^9}, {
  3.902485713983952*^9, 3.902485723692648*^9}, {3.902810112965027*^9, 
  3.9028101196712933`*^9}, {3.902827511081419*^9, 3.902827515259775*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"205dd1dd-d59e-459c-92d0-d151b351a17c"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.902485338174164*^9, 3.902485724767865*^9, 3.902810139310788*^9, {
   3.902827516558631*^9, 3.902827531998741*^9}, 3.9034351627578125`*^9, 
   3.904641014903037*^9, 3.9050566569019737`*^9},
 CellLabel->"Out[44]=",ExpressionUUID->"9665eea4-887d-4f5f-97fc-55ab3cc532fa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"C31", "'"}], "+", 
     RowBox[{"C34", "'"}]}], ")"}], "/", 
   SuperscriptBox[
    SubscriptBox["T", "1"], "2"]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.902485747137376*^9, 3.9024857630658283`*^9}, {
  3.90248590035077*^9, 3.9024859113421593`*^9}, {3.902810149834889*^9, 
  3.902810151486435*^9}, {3.9028101939941797`*^9, 3.902810194107147*^9}, {
  3.9028107194564943`*^9, 3.902810737220491*^9}, {3.902827534314185*^9, 
  3.9028275352849703`*^9}},
 CellLabel->"In[45]:=",ExpressionUUID->"4089f9c0-1213-4130-b43b-ed0e264bb8f1"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["T", "0"], "-", 
        SubscriptBox["T", "1"]}], ")"}], " ", 
      SubscriptBox["\[Kappa]", "t"]}], "-", 
     RowBox[{"L", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}]], "+", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", 
       SubscriptBox["T", "0"]}], " ", 
      SubscriptBox["\[Kappa]", "t"]}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SubscriptBox["T", "1"]}], " ", 
         SubscriptBox["\[Kappa]", "t"]}], "-", 
        RowBox[{"L", " ", 
         SubscriptBox["\[Kappa]", "x"]}]}]], "+", 
      RowBox[{
       SubscriptBox["T", "1"], " ", 
       SubscriptBox["\[Kappa]", "t"]}], "+", 
      RowBox[{"L", " ", 
       SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}], "+", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"L", " ", 
         SubscriptBox["T", "0"], " ", 
         SubscriptBox["\[Kappa]", "x"]}], 
        SubscriptBox["T", "1"]]}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["T", "1"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SubscriptBox["T", "0"]}], "+", 
             SubscriptBox["T", "1"]}], ")"}], " ", 
           SubscriptBox["\[Kappa]", "t"]}]}], ")"}]}], "+", 
       RowBox[{"L", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["T", "0"]}], "+", 
          SubscriptBox["T", "1"]}], ")"}], " ", 
        SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}], 
    SubscriptBox["T", "1"]]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["T", "1"], " ", 
      SubscriptBox["\[Kappa]", "t"]}], "+", 
     RowBox[{"L", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}], ")"}], "2"]]], "Output",
 CellChangeTimes->{3.9028275358050137`*^9, 3.903417228261239*^9, 
  3.9034351629680033`*^9, 3.9046410630455823`*^9, 3.905056657016102*^9},
 CellLabel->"Out[45]=",ExpressionUUID->"cf0b0a51-dfc0-4791-8605-1fc0f96f7667"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"C32", "'"}], "+", 
     RowBox[{"C33", "'"}]}], ")"}], "/", 
   SuperscriptBox[
    SubscriptBox["T", "1"], "2"]}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.9028102029564342`*^9, 3.902810226010705*^9}, 
   3.902810742742712*^9, {3.902811457988143*^9, 3.902811459465289*^9}, {
   3.902827545150544*^9, 3.902827546161648*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"13943eab-9cc9-4448-b121-aaa82e55275f"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["T", "0"]}], " ", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[Kappa]", "t"], "+", 
       FractionBox[
        RowBox[{"L", " ", 
         SubscriptBox["\[Kappa]", "x"]}], 
        SubscriptBox["T", "1"]]}], ")"}]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"L", " ", 
          SubscriptBox["T", "0"], " ", 
          SubscriptBox["\[Kappa]", "x"]}], 
         SubscriptBox["T", "1"]]]}], " ", 
      SubscriptBox["T", "1"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SubscriptBox["T", "1"], " ", 
         SubscriptBox["\[Kappa]", "t"]}], "-", 
        RowBox[{"L", " ", 
         SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        SubscriptBox["T", "0"], " ", 
        SubscriptBox["\[Kappa]", "t"]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SubscriptBox["T", "1"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               SubscriptBox["T", "0"]}], "+", 
              SubscriptBox["T", "1"]}], ")"}], " ", 
            SubscriptBox["\[Kappa]", "t"]}]}], ")"}]}], "+", 
        RowBox[{"L", " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["T", "0"], "-", 
           SubscriptBox["T", "1"]}], ")"}], " ", 
         SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]}], ")"}]}], 
  RowBox[{
   SubscriptBox["T", "1"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubscriptBox["T", "1"], " ", 
       SubscriptBox["\[Kappa]", "t"]}], "-", 
      RowBox[{"L", " ", 
       SubscriptBox["\[Kappa]", "x"]}]}], ")"}], "2"]}]]], "Output",
 CellChangeTimes->{3.9028275466086206`*^9, 3.9034172287757063`*^9, 
  3.903435163496997*^9, 3.9046410639836855`*^9, 3.9050566572787743`*^9},
 CellLabel->"Out[46]=",ExpressionUUID->"aac53142-86a5-4b2b-bb77-0ca2dd543052"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"ToExpression", "[", 
         RowBox[{
         "\"\<\\\\frac{\\\\beta^2 }{\\\\kappa_t^2}\n\\\\biggl(\\\\frac{e^{-\\\
\\tau*\\\\gamma/\\\\beta}*(\\\\beta-\\\\gamma - \\\\tau \
*(1-\\\\gamma/\\\\beta)+1)-e^{-\\\\tau} \
*\\\\left(\\\\beta-\\\\gamma+1\\\\right)}{(\\\\beta-\\\\gamma)^2}\\\\\\\\\n\
+\\\\frac{e^{-\\\\tau} *\\\\left(e^{-\\\\gamma-\\\\beta}+\\\\gamma+\\\\beta-1\
\\\\right)+e^{\\\\tau-\\\\beta-\\\\gamma}+e^{-\\\\frac{\\\\tau *\\\\gamma}{\\\
\\beta}} * \\\\left(\\\\beta+\\\\gamma-\\\\tau*(1+ \
\\\\gamma/\\\\beta)-1\\\\right)}{(\\\\beta+\\\\gamma)^2}\n\\\\biggr)\>\"", 
          ",", "TeXForm"}], "]"}], "/.", 
        RowBox[{"e", "->", "\[ExponentialE]"}]}], "/.", "rule0"}], ",", 
      "conds2"}], "]"}], "==", 
    RowBox[{"C3", "'"}]}], ",", "conds2"}], "]"}]], "Input",
 CellChangeTimes->{{3.9029027995463605`*^9, 3.9029030128492794`*^9}, {
  3.9029030519723697`*^9, 3.9029031001175995`*^9}},
 CellLabel->"In[47]:=",ExpressionUUID->"5c68a438-6e51-429f-aa79-3fc41f2221d5"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.902903101275328*^9, 3.902903133014064*^9, 
  3.9034172324644794`*^9, 3.9034351672634153`*^9, 3.905056659106023*^9},
 CellLabel->"Out[47]=",ExpressionUUID->"b6373a3a-73ce-4a79-a5ee-ba017525e9b3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"C31", "'"}], ")"}], "/.", "rule1"}], "//", "Simplify"}]], "Input",\

 CellChangeTimes->{{3.9046410780245247`*^9, 3.904641138008936*^9}, 
   3.9046413218811703`*^9},
 CellLabel->"In[48]:=",ExpressionUUID->"228c02cb-4e01-4eac-8630-9b5d062a01a6"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "\[Tau]"}]], " ", 
   SuperscriptBox["\[Beta]", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]"}]], "+", "\[Beta]", "+", 
     "\[Gamma]"}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}], "2"]]], "Output",
 CellChangeTimes->{{3.9046410795452423`*^9, 3.904641138502931*^9}, 
   3.9046413223809233`*^9, 3.9050566591736307`*^9},
 CellLabel->"Out[48]=",ExpressionUUID->"1982e6d5-0bff-4be6-bfa1-c0a649fdd3b1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"C34", "'"}], ")"}], "/.", "rule1"}], "//", "Simplify"}]], "Input",\

 CellChangeTimes->{{3.9046411432809134`*^9, 3.9046411714561434`*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"1cfb1823-a073-48e1-b294-11ba7804a993"],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[Beta]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]", "+", "\[Tau]"}]], " ", 
      "\[Beta]"}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["\[Beta]", "2"], "+", 
        RowBox[{"\[Beta]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "\[Gamma]", "-", "\[Tau]"}], ")"}]}], "-", 
        RowBox[{"\[Gamma]", " ", "\[Tau]"}]}], ")"}]}]}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}], "2"]]], "Output",
 CellChangeTimes->{{3.904641143681304*^9, 3.9046411716978493`*^9}, 
   3.9046413236011734`*^9, 3.905056659231722*^9},
 CellLabel->"Out[49]=",ExpressionUUID->"44d54222-96f9-492e-a7c6-98c9fb23a95d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"C31", "'"}], "+", 
    RowBox[{"C34", "'"}]}], "/.", "rule1"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.904646017784944*^9, 3.904646047080889*^9}, {
  3.904646083096836*^9, 3.9046461379288874`*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"41334679-63ab-47a1-b6fd-2f8bda4cafa1"],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[Beta]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]", "+", "\[Tau]"}]], " ", 
      "\[Beta]"}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "\[Tau]"}]], " ", "\[Beta]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]"}]], "+", "\[Beta]", "+", 
        "\[Gamma]"}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["\[Beta]", "2"], "+", 
        RowBox[{"\[Beta]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "\[Gamma]", "-", "\[Tau]"}], ")"}]}], "-", 
        RowBox[{"\[Gamma]", " ", "\[Tau]"}]}], ")"}]}]}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}], "2"]]], "Output",
 CellChangeTimes->{{3.904646019569645*^9, 3.9046460473451385`*^9}, {
   3.904646084392271*^9, 3.904646152170246*^9}, 3.905056659305459*^9},
 CellLabel->"Out[50]=",ExpressionUUID->"c0260ff3-467d-46b9-a006-5e87837536bb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"C32", "'"}], "+", 
     RowBox[{"C33", "'"}]}], "/.", "rule1"}], "//", "Expand"}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.904641201578909*^9, 3.9046412340809717`*^9}, {
  3.9046412683129063`*^9, 3.9046412746889105`*^9}, {3.904646053192917*^9, 
  3.904646099848816*^9}, {3.9046461424577627`*^9, 3.904646145232889*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"98e3e65e-b11a-4d14-8beb-ba8fbb1dff81"],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[Beta]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "\[Tau]"}]], " ", "\[Beta]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", "\[Beta]", "+", "\[Gamma]"}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["\[Beta]", "2"], "+", 
        RowBox[{"\[Gamma]", " ", "\[Tau]"}], "-", 
        RowBox[{"\[Beta]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "\[Gamma]", "+", "\[Tau]"}], ")"}]}]}], 
       ")"}]}]}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}], "2"]]], "Output",
 CellChangeTimes->{
  3.904641588031947*^9, {3.904646036986107*^9, 3.9046460577949047`*^9}, {
   3.9046460878738737`*^9, 3.904646102825922*^9}, 3.9046461527779055`*^9, 
   3.905056659494711*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"e28169ed-f8c3-4086-94ee-9422ad099851"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"\[Beta]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"\[Beta]", "-", "\[Gamma]", "-", "\[Tau]"}]]}], " ", 
         "\[Beta]"}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", 
           FractionBox[
            RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]}]], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["\[Beta]", "2"], "+", 
           RowBox[{"\[Gamma]", " ", "\[Tau]"}], "-", 
           RowBox[{"\[Beta]", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Gamma]", "+", "\[Tau]"}], ")"}]}]}],
           ")"}]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}], "2"]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "\[Tau]"}]], " ", 
      SuperscriptBox["\[Beta]", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", "\[Beta]", "+", "\[Gamma]", "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"\[Beta]", "-", "\[Gamma]"}]]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}], "2"]]}], "==", "%113"}], "//",
   "Simplify"}]], "Input",
 CellChangeTimes->{{3.9046413902239237`*^9, 3.9046413969608345`*^9}, {
   3.9046414317446456`*^9, 3.904641432312834*^9}, 3.9046414688009143`*^9, {
   3.9046417235211535`*^9, 3.904641758672908*^9}, {3.9046425133699627`*^9, 
   3.9046425428734217`*^9}, {3.904646063145011*^9, 3.90464606409708*^9}},
 CellLabel->"In[52]:=",ExpressionUUID->"29ae48db-fa51-4972-b909-261b04f4191d"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"\[Beta]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "\[Tau]"}]]}], " ", "\[Beta]", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]", "-", "\[Gamma]"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["\[Beta]", "2"], "+", 
         RowBox[{"\[Gamma]", " ", "\[Tau]"}], "-", 
         RowBox[{"\[Beta]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Gamma]", "+", "\[Tau]"}], ")"}]}]}], 
        ")"}]}]}], ")"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}], "2"]], "\[Equal]", 
  "%113"}]], "Output",
 CellChangeTimes->{
  3.9046414697289305`*^9, {3.9046417250922565`*^9, 3.9046417589399705`*^9}, 
   3.904642543265944*^9, 3.904646064554905*^9, 3.905056659563603*^9},
 CellLabel->"Out[52]=",ExpressionUUID->"f188d879-b5cf-404e-be63-c23ba5ea2623"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Beta]", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"\[Beta]", "-", "\[Gamma]", "-", "\[Tau]"}]]}], " ", 
       "\[Beta]"}], "+", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["\[Beta]", "2"], "+", 
         RowBox[{"\[Gamma]", " ", "\[Tau]"}], "-", 
         RowBox[{"\[Beta]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Gamma]", "+", "\[Tau]"}], ")"}]}]}], 
        ")"}]}]}], ")"}], "/", 
    SuperscriptBox["\[Beta]", "2"]}], 
   SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.9046418453609147`*^9, 3.904641852640834*^9}, 
   3.9046418905469227`*^9, {3.904641930016907*^9, 3.9046419856331453`*^9}, {
   3.904707958408804*^9, 3.9047079585516696`*^9}, 3.904708460112544*^9},
 CellLabel->"In[53]:=",ExpressionUUID->"69665346-4a9c-4000-9a40-e6b0619e0624"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[Beta]", "-", "\[Gamma]"}]]}], "+", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[Tau]", "-", 
     FractionBox[
      RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]}]], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "\[Beta]", "-", "\[Gamma]", "-", "\[Tau]", "+", 
     FractionBox[
      RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]}], ")"}]}]}]], "Output",\

 CellChangeTimes->{{3.904641958495013*^9, 3.904641986460333*^9}, 
   3.905056659719198*^9},
 CellLabel->"Out[53]=",ExpressionUUID->"93cebd92-1bd2-4db1-8049-6dbb38eb7875"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", 
   RowBox[{"x_", ",", "\[Lambda]_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", "x"}], "]"}], 
   FractionBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{"\[Lambda]", " ", "x"}], "]"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"\[Lambda]", " ", "x"}], " ", "-", "1"}], ")"}]}]}], ")"}], 
    SuperscriptBox["x", "2"]]}]}]], "Input",
 CellChangeTimes->{{3.904708068675256*^9, 3.9047081220577393`*^9}, {
  3.9047091926968017`*^9, 3.9047091945207253`*^9}},
 CellLabel->"In[54]:=",ExpressionUUID->"4c287521-34ce-497c-9b02-6ff2dba9d601"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["\[Beta]", "2"]}], 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "\[Tau]"}]], 
    RowBox[{"g", "[", 
     RowBox[{
      RowBox[{"\[Gamma]", "-", "\[Beta]"}], ",", 
      RowBox[{"1", "-", 
       RowBox[{"\[Tau]", "/", "\[Beta]"}]}]}], "]"}]}], "==", 
   FractionBox[
    RowBox[{"\[Beta]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"\[Beta]", "-", "\[Gamma]", "-", "\[Tau]"}]]}], " ", 
        "\[Beta]"}], "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", 
          FractionBox[
           RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["\[Beta]", "2"], "+", 
          RowBox[{"\[Gamma]", " ", "\[Tau]"}], "-", 
          RowBox[{"\[Beta]", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "\[Gamma]", "+", "\[Tau]"}], ")"}]}]}], 
         ")"}]}]}], ")"}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}], "2"]]}], "//", 
  "Simplify"}]], "Input",
 CellChangeTimes->{{3.904708107762015*^9, 3.904708164512693*^9}, {
  3.9047082062898335`*^9, 3.9047082277697783`*^9}, {3.9047092402571526`*^9, 
  3.904709256424703*^9}},
 CellLabel->"In[55]:=",ExpressionUUID->"dde54be6-4255-4101-944e-314f8abccc4b"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.904708115058337*^9, 3.9047081649826603`*^9}, {
   3.904708206546933*^9, 3.9047082281911516`*^9}, 3.904709257001917*^9, 
   3.905056659792324*^9},
 CellLabel->"Out[55]=",ExpressionUUID->"4717fd9b-41db-499a-a349-417d82a93f03"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SuperscriptBox["\[Beta]", "2"], 
    SuperscriptBox["\[ExponentialE]", "\[Tau]"], 
    RowBox[{"g", "[", 
     RowBox[{
      RowBox[{"\[Gamma]", "+", "\[Beta]"}], ",", 
      RowBox[{"1", "-", 
       RowBox[{"\[Tau]", "/", "\[Beta]"}]}]}], "]"}]}], "==", 
   FractionBox[
    RowBox[{"\[Beta]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]", "+", "\[Tau]"}]], " ", 
        "\[Beta]"}], "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", 
          FractionBox[
           RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["\[Beta]", "2"], "+", 
          RowBox[{"\[Beta]", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "\[Gamma]", "-", "\[Tau]"}], ")"}]}], 
          "-", 
          RowBox[{"\[Gamma]", " ", "\[Tau]"}]}], ")"}]}]}], ")"}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}], "2"]]}], "//", 
  "Simplify"}]], "Input",
 CellChangeTimes->{{3.904709264704481*^9, 3.9047092739447756`*^9}},
 CellLabel->"In[56]:=",ExpressionUUID->"43e42e88-4bc7-4e16-8277-431e81bf2dc1"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9047092745697336`*^9, 3.905056659842345*^9},
 CellLabel->"Out[56]=",ExpressionUUID->"7b0a5f8f-7e60-4711-8d7e-5617a61865d7"]
}, Open  ]],

Cell[TextData[StyleBox["Red", "Subsubsection"]], "Text",
 CellChangeTimes->{{3.902397994261709*^9, 3.9023979962810507`*^9}, {
  3.902809884601377*^9, 
  3.9028098860185843`*^9}},ExpressionUUID->"d14a4d31-b333-4815-a081-\
a32e783f41b6"],

Cell["I", "Text",
 CellChangeTimes->{{3.902809887034811*^9, 
  3.902809889062539*^9}},ExpressionUUID->"66975603-c2df-4e45-81c4-\
9a2feddb5da3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"C41", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["t", "2"], "-", 
          SubscriptBox["t", "1"]}], ")"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], 
        RowBox[{"(", 
         RowBox[{"L", "-", 
          RowBox[{
           FractionBox["L", 
            SubscriptBox["T", "1"]], 
           RowBox[{"(", 
            RowBox[{
             SubscriptBox["t", "2"], "-", 
             SubscriptBox["T", "0"]}], ")"}]}]}], ")"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", 
       SubscriptBox["T", "1"], ",", 
       SubscriptBox["T", "0"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", 
       SubscriptBox["T", "0"], ",", 
       RowBox[{
        SubscriptBox["T", "1"], "+", 
        SubscriptBox["T", "0"]}]}], "}"}], ",", 
     RowBox[{"Assumptions", "->", "conds1"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.902398099512137*^9, 3.90239811695784*^9}, {
   3.902826583224903*^9, 3.90282658570017*^9}, 3.9028890159236064`*^9},
 CellLabel->"In[57]:=",ExpressionUUID->"d4f6219f-0113-4543-8901-0aee2cb42333"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["T", "0"], "+", 
          SubscriptBox["T", "1"]}], ")"}], " ", 
        SubscriptBox["\[Kappa]", "t"]}], ")"}]}], "-", 
     RowBox[{"L", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        SubscriptBox["T", "0"], " ", 
        SubscriptBox["\[Kappa]", "t"]}]]}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       SubscriptBox["T", "1"], " ", 
       SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        SubscriptBox["T", "1"], " ", 
        SubscriptBox["\[Kappa]", "t"]}]]}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"L", " ", 
       SubscriptBox["\[Kappa]", "x"]}]]}], ")"}], " ", 
   SubscriptBox["T", "1"]}], 
  RowBox[{
   SubscriptBox["\[Kappa]", "t"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["T", "1"], " ", 
      SubscriptBox["\[Kappa]", "t"]}], "-", 
     RowBox[{"L", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]]], "Output",
 CellChangeTimes->{3.902398119528367*^9, 3.9028265173311243`*^9, 
  3.902826607906724*^9, 3.902891604767927*^9, 3.9034172360787597`*^9, 
  3.9034351711509438`*^9, 3.905056661986932*^9},
 CellLabel->"Out[57]=",ExpressionUUID->"e44524c2-cf5c-413e-9391-a1cb5e248cce"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"C42", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["t", "2"], "-", 
          SubscriptBox["t", "1"]}], ")"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], 
        RowBox[{"(", 
         RowBox[{"L", "-", 
          RowBox[{
           FractionBox["L", 
            SubscriptBox["T", "1"]], 
           RowBox[{"(", 
            RowBox[{
             SubscriptBox["t", "2"], "-", 
             SubscriptBox["T", "0"]}], ")"}]}]}], ")"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", 
       SubscriptBox["T", "0"], ",", 
       RowBox[{
        SubscriptBox["T", "1"], "+", 
        SubscriptBox["T", "0"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", 
       SubscriptBox["t", "1"], ",", 
       RowBox[{
        SubscriptBox["T", "1"], "+", 
        SubscriptBox["T", "0"]}]}], "}"}], ",", 
     RowBox[{"Assumptions", "->", "conds1"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.902398001095145*^9, 3.90239808307376*^9}, {
   3.902398150180665*^9, 3.9023981635317373`*^9}, {3.902826589484226*^9, 
   3.9028265908649883`*^9}, 3.9028890159236064`*^9},
 CellLabel->"In[58]:=",ExpressionUUID->"bc83c5e4-1f90-491a-9ea5-8617c57183f7"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SubscriptBox["T", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", 
          SubscriptBox["T", "1"]}], " ", 
         SubscriptBox["\[Kappa]", "t"]}]]}], 
      SubscriptBox["\[Kappa]", "t"]], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "L"}], " ", 
           SubscriptBox["\[Kappa]", "x"]}]]}], ")"}], " ", 
       SubscriptBox["T", "1"]}], 
      RowBox[{"L", " ", 
       SubscriptBox["\[Kappa]", "x"]}]]}], ")"}]}], 
  RowBox[{
   RowBox[{
    SubscriptBox["T", "1"], " ", 
    SubscriptBox["\[Kappa]", "t"]}], "-", 
   RowBox[{"L", " ", 
    SubscriptBox["\[Kappa]", "x"]}]}]]], "Output",
 CellChangeTimes->{{3.9023980692109737`*^9, 3.902398087517271*^9}, 
   3.902398167102788*^9, 3.902826521497471*^9, 3.9028266092535467`*^9, 
   3.902891607800439*^9, 3.9034172400597253`*^9, 3.9034351753287354`*^9, 
   3.905056664199976*^9},
 CellLabel->"Out[58]=",ExpressionUUID->"fbc49398-12f7-4f5c-8ef1-f4469525e5a7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"C43", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["t", "1"], "-", 
          SubscriptBox["t", "2"]}], ")"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], 
        RowBox[{"(", 
         RowBox[{"L", "-", 
          RowBox[{
           FractionBox["L", 
            SubscriptBox["T", "1"]], 
           RowBox[{"(", 
            RowBox[{
             SubscriptBox["t", "2"], "-", 
             SubscriptBox["T", "0"]}], ")"}]}]}], ")"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", 
       SubscriptBox["T", "0"], ",", 
       RowBox[{
        SubscriptBox["T", "1"], "+", 
        SubscriptBox["T", "0"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", 
       SubscriptBox["T", "0"], ",", 
       SubscriptBox["t", "1"]}], "}"}], ",", 
     RowBox[{"Assumptions", "->", "conds1"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.9023981732863283`*^9, 3.902398188929283*^9}, {
   3.9028265942919817`*^9, 3.902826596670617*^9}, 3.9028890159236064`*^9},
 CellLabel->"In[59]:=",ExpressionUUID->"6e725282-33cb-4576-98ba-5525947250ed"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SubscriptBox["T", "1"]}], " ", 
      SubscriptBox["\[Kappa]", "t"]}], "-", 
     RowBox[{"L", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
   SubscriptBox["T", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"L", " ", 
      SubscriptBox["\[Kappa]", "x"]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        SubscriptBox["T", "1"], " ", 
        SubscriptBox["\[Kappa]", "t"]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"L", " ", 
             SubscriptBox["\[Kappa]", "x"]}]]}], ")"}], " ", 
         SubscriptBox["T", "1"], " ", 
         SubscriptBox["\[Kappa]", "t"]}], "-", 
        RowBox[{"L", " ", 
         SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]}], ")"}]}], 
  RowBox[{"L", " ", 
   SubscriptBox["\[Kappa]", "t"], " ", 
   SubscriptBox["\[Kappa]", "x"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["T", "1"], " ", 
      SubscriptBox["\[Kappa]", "t"]}], "+", 
     RowBox[{"L", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]]], "Output",
 CellChangeTimes->{3.9023981917422743`*^9, 3.9028265232233562`*^9, 
  3.9028266106593227`*^9, 3.902891610522051*^9, 3.903417243483833*^9, 
  3.903435178910593*^9, 3.9050566661150723`*^9},
 CellLabel->"Out[59]=",ExpressionUUID->"0685b9ae-edd9-4542-9d10-501ad2d4b21e"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"C4", "=", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"Abs", "[", 
         RowBox[{
          SubscriptBox["t", "2"], "-", 
          SubscriptBox["t", "1"]}], "]"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], 
        RowBox[{"(", 
         RowBox[{"L", "-", 
          RowBox[{
           FractionBox["L", 
            SubscriptBox["T", "1"]], 
           RowBox[{"(", 
            RowBox[{
             SubscriptBox["t", "2"], "-", 
             SubscriptBox["T", "0"]}], ")"}]}]}], ")"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", 
       SubscriptBox["T", "1"], ",", 
       RowBox[{
        SubscriptBox["T", "1"], "+", 
        SubscriptBox["T", "0"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", 
       SubscriptBox["T", "0"], ",", 
       RowBox[{
        SubscriptBox["T", "0"], "+", 
        SubscriptBox["T", "1"]}]}], "}"}], ",", 
     RowBox[{"Assumptions", "->", "conds1"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.902826666176236*^9, 3.902826687942541*^9}, {
   3.902826722842865*^9, 3.9028267684125557`*^9}, 3.9028890159392433`*^9},
 CellLabel->"In[60]:=",ExpressionUUID->"cf9b427e-2b4f-4566-bf16-bbbdd62e081f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C41", "+", "C42", "+", "C43"}], "==", "C4"}], "//", 
  "Simplify"}]], "Input",
 CellChangeTimes->{{3.902826747029689*^9, 3.90282675395065*^9}},
 CellLabel->"In[61]:=",ExpressionUUID->"fc57158d-71ac-4664-a48f-83b3ed90be9d"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.902826754545969*^9, 3.902891610991247*^9, 
  3.903417254840149*^9, 3.9034351908614407`*^9, 3.905056672263563*^9},
 CellLabel->"Out[61]=",ExpressionUUID->"8d26ff7e-e25f-4d54-953e-2135a65d8223"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SubscriptBox["T", "1"], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["T", "1"]}], " ", 
          SubscriptBox["\[Kappa]", "t"]}]]}], 
       SubscriptBox["\[Kappa]", "t"]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "L"}], " ", 
            SubscriptBox["\[Kappa]", "x"]}]]}], ")"}], " ", 
        SubscriptBox["T", "1"]}], 
       RowBox[{"L", " ", 
        SubscriptBox["\[Kappa]", "x"]}]]}], ")"}]}], 
   RowBox[{
    RowBox[{
     SubscriptBox["T", "1"], " ", 
     SubscriptBox["\[Kappa]", "t"]}], "-", 
    RowBox[{"L", " ", 
     SubscriptBox["\[Kappa]", "x"]}]}]], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.9028965530903683`*^9, 3.902896556594564*^9}},
 CellLabel->"In[62]:=",ExpressionUUID->"b557c0f4-f796-445d-a82a-9f691e4878b1"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SubscriptBox["T", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", 
          SubscriptBox["T", "1"]}], " ", 
         SubscriptBox["\[Kappa]", "t"]}]]}], 
      SubscriptBox["\[Kappa]", "t"]], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "L"}], " ", 
           SubscriptBox["\[Kappa]", "x"]}]]}], ")"}], " ", 
       SubscriptBox["T", "1"]}], 
      RowBox[{"L", " ", 
       SubscriptBox["\[Kappa]", "x"]}]]}], ")"}]}], 
  RowBox[{
   RowBox[{
    SubscriptBox["T", "1"], " ", 
    SubscriptBox["\[Kappa]", "t"]}], "-", 
   RowBox[{"L", " ", 
    SubscriptBox["\[Kappa]", "x"]}]}]]], "Output",
 CellChangeTimes->{3.903417255249565*^9, 3.90343519129183*^9, 
  3.905056672473736*^9},
 CellLabel->"Out[62]=",ExpressionUUID->"ca75b161-7d09-4a46-aa3c-03bfb207c07d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FractionBox[
  RowBox[{
   SubscriptBox["T", "1"], " ", 
   RowBox[{"(", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "L"}], " ", 
          SubscriptBox["\[Kappa]", "x"]}]]}], ")"}], " ", 
      SubscriptBox["T", "1"]}], 
     RowBox[{"L", " ", 
      SubscriptBox["\[Kappa]", "x"]}]], ")"}]}], 
  RowBox[{
   RowBox[{
    SubscriptBox["T", "1"], " ", 
    SubscriptBox["\[Kappa]", "t"]}], "-", 
   RowBox[{"L", " ", 
    SubscriptBox["\[Kappa]", "x"]}]}]]], "Input",
 CellChangeTimes->{{3.902896562106203*^9, 3.9028965628764834`*^9}},
 CellLabel->"In[63]:=",ExpressionUUID->"34fe2868-847a-41bc-ad19-ef2d17c77530"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "L"}], " ", 
       SubscriptBox["\[Kappa]", "x"]}]]}], ")"}], " ", 
   SubsuperscriptBox["T", "1", "2"]}], 
  RowBox[{"L", " ", 
   SubscriptBox["\[Kappa]", "x"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["T", "1"], " ", 
      SubscriptBox["\[Kappa]", "t"]}], "-", 
     RowBox[{"L", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]]], "Output",
 CellChangeTimes->{3.902896563145974*^9, 3.903417255265581*^9, 
  3.9034351913148513`*^9, 3.905056672497016*^9},
 CellLabel->"Out[63]=",ExpressionUUID->"185a13cd-6fbc-4be3-9214-5c38a57baa27"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"C41", "+", "C42", "+", "C43"}]], "Input",
 CellLabel->"In[64]:=",ExpressionUUID->"15e87f4d-b091-4d1b-b20f-4c9fe7c1310f"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["T", "0"], "+", 
           SubscriptBox["T", "1"]}], ")"}], " ", 
         SubscriptBox["\[Kappa]", "t"]}], ")"}]}], "-", 
      RowBox[{"L", " ", 
       SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         SubscriptBox["T", "0"], " ", 
         SubscriptBox["\[Kappa]", "t"]}]]}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        SubscriptBox["T", "1"], " ", 
        SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         SubscriptBox["T", "1"], " ", 
         SubscriptBox["\[Kappa]", "t"]}]]}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"L", " ", 
        SubscriptBox["\[Kappa]", "x"]}]]}], ")"}], " ", 
    SubscriptBox["T", "1"]}], 
   RowBox[{
    SubscriptBox["\[Kappa]", "t"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubscriptBox["T", "1"], " ", 
       SubscriptBox["\[Kappa]", "t"]}], "-", 
      RowBox[{"L", " ", 
       SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]], "+", 
  FractionBox[
   RowBox[{
    SubscriptBox["T", "1"], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["T", "1"]}], " ", 
          SubscriptBox["\[Kappa]", "t"]}]]}], 
       SubscriptBox["\[Kappa]", "t"]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "L"}], " ", 
            SubscriptBox["\[Kappa]", "x"]}]]}], ")"}], " ", 
        SubscriptBox["T", "1"]}], 
       RowBox[{"L", " ", 
        SubscriptBox["\[Kappa]", "x"]}]]}], ")"}]}], 
   RowBox[{
    RowBox[{
     SubscriptBox["T", "1"], " ", 
     SubscriptBox["\[Kappa]", "t"]}], "-", 
    RowBox[{"L", " ", 
     SubscriptBox["\[Kappa]", "x"]}]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SubscriptBox["T", "1"]}], " ", 
       SubscriptBox["\[Kappa]", "t"]}], "-", 
      RowBox[{"L", " ", 
       SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
    SubscriptBox["T", "1"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"L", " ", 
       SubscriptBox["\[Kappa]", "x"]}], "+", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         SubscriptBox["T", "1"], " ", 
         SubscriptBox["\[Kappa]", "t"]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"L", " ", 
              SubscriptBox["\[Kappa]", "x"]}]]}], ")"}], " ", 
          SubscriptBox["T", "1"], " ", 
          SubscriptBox["\[Kappa]", "t"]}], "-", 
         RowBox[{"L", " ", 
          SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]}], ")"}]}], 
   RowBox[{"L", " ", 
    SubscriptBox["\[Kappa]", "t"], " ", 
    SubscriptBox["\[Kappa]", "x"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubscriptBox["T", "1"], " ", 
       SubscriptBox["\[Kappa]", "t"]}], "+", 
      RowBox[{"L", " ", 
       SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]]}]], "Output",
 CellChangeTimes->{3.9028965296328683`*^9, 3.903417255278592*^9, 
  3.903435191338874*^9, 3.9050566725370407`*^9},
 CellLabel->"Out[64]=",ExpressionUUID->"efa72cfe-00bf-489a-ab41-0eaa0b416877"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C41", "+", "C42", "+", "C43"}], "/.", "rule1"}], "/.", 
  "rule1"}]], "Input",
 CellChangeTimes->{{3.902891610469039*^9, 3.902891643847536*^9}},
 CellLabel->"In[65]:=",ExpressionUUID->"93c804e2-adfd-479c-b26a-f4609030f374"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]", "-", "\[Tau]"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["\[ExponentialE]", "\[Beta]"]}], "+", 
      SuperscriptBox["\[ExponentialE]", "\[Gamma]"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "\[Beta]"], "-", 
      SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}], " ", "\[Beta]"}], 
   
   RowBox[{"\[Beta]", "-", "\[Gamma]"}]], "+", 
  FractionBox[
   RowBox[{"\[Beta]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "\[Beta]"}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", "\[Gamma]"}]]}], ")"}], " ", "\[Beta]"}], 
       "\[Gamma]"]}], ")"}]}], 
   RowBox[{"\[Beta]", "-", "\[Gamma]"}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]"}]], " ", "\[Beta]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "\[Beta]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[ExponentialE]", "\[Gamma]"]}], ")"}], " ", 
          "\[Beta]"}], "-", "\[Gamma]"}], ")"}]}], "+", "\[Gamma]"}], ")"}]}], 
   RowBox[{"\[Gamma]", " ", 
    RowBox[{"(", 
     RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}]}]]}]], "Output",
 CellChangeTimes->{{3.90289161789287*^9, 3.902891644111092*^9}, 
   3.9034172552875996`*^9, 3.90343519134688*^9, 3.905056672559071*^9},
 CellLabel->"Out[65]=",ExpressionUUID->"6a0777d7-5c02-4f20-a26a-b3aa7d98df41"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"C4", "==", "\[IndentingNewLine]", 
      RowBox[{"ToExpression", "[", "\[IndentingNewLine]", 
       RowBox[{
       "\"\<\\\\frac{\\\\beta}{\\\\kappa_t^2 \
}\\\\biggl(\\\\frac{e^{-\\\\beta-\\\\gamma-\\\\tau}*(e^\\\\beta-e^\\\\tau)*(e^\
\\\\gamma-e^\\\\beta)}{\\\\beta-\\\\gamma}+\\\\frac{\\\\gamma \
e^{-\\\\beta}-\\\\beta  e^{-\\\\gamma}}{\\\\gamma *(\\\\beta-\\\\gamma)}\n+\\\
\\frac{\\\\beta +\\\\gamma \
e^{-\\\\beta-\\\\gamma}}{\\\\gamma*(\\\\beta+\\\\gamma)}+\\\\frac{1-e^{-\\\\\
gamma}}{\\\\gamma}\n\\\\biggr)\>\"", ",", "TeXForm"}], "]"}]}], "/.", 
     RowBox[{"e", "->", "\[ExponentialE]"}]}], "/.", "rule0"}], ",", 
   "conds1"}], "]"}]], "Input",
 CellChangeTimes->{{3.9028915243756094`*^9, 3.902891582402037*^9}, {
  3.9028960723285885`*^9, 3.902896111677546*^9}, {3.90289617263067*^9, 
  3.9028962179413548`*^9}, {3.9028962924374704`*^9, 3.9028963980097017`*^9}},
 CellLabel->"In[66]:=",ExpressionUUID->"b1cbeafb-7424-420a-b265-509628e93901"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.9028915436426973`*^9, 3.9028915844656053`*^9}, {
   3.9028960855362797`*^9, 3.90289611245544*^9}, {3.9028961622839327`*^9, 
   3.9028962182741566`*^9}, {3.9028963342978153`*^9, 3.902896399954689*^9}, 
   3.9034172570081778`*^9, 3.9034351931555223`*^9, 3.9050566734385643`*^9},
 CellLabel->"Out[66]=",ExpressionUUID->"6868772a-36c8-4df7-a481-a063436ac5fa"]
}, Open  ]],

Cell["II", "Text",
 CellChangeTimes->{{3.9028099019757833`*^9, 
  3.902809902101021*^9}},ExpressionUUID->"47ce811c-239b-447f-a094-\
ebeba6c19607"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"C4", "'"}], "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"Abs", "[", 
         RowBox[{
          SubscriptBox["t", "2"], "-", 
          SubscriptBox["t", "1"]}], "]"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], 
        RowBox[{"(", 
         RowBox[{"L", "-", 
          RowBox[{
           FractionBox["L", 
            SubscriptBox["T", "1"]], 
           RowBox[{"(", 
            RowBox[{
             SubscriptBox["t", "2"], "-", 
             SubscriptBox["T", "0"]}], ")"}]}]}], ")"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", 
       SubscriptBox["T", "1"], ",", 
       RowBox[{
        SubscriptBox["T", "0"], "+", 
        SubscriptBox["T", "1"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", 
       SubscriptBox["T", "0"], ",", 
       RowBox[{
        SubscriptBox["T", "1"], "+", 
        SubscriptBox["T", "0"]}]}], "}"}], ",", 
     RowBox[{"Assumptions", "->", "conds2"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.902483384338048*^9, 3.902483426923411*^9}, {
   3.90280993998452*^9, 3.902809942040917*^9}, 3.902827762410592*^9, 
   3.9028891083523207`*^9, 3.9028893749109335`*^9},
 CellLabel->"In[67]:=",ExpressionUUID->"9311b939-2737-45a8-b932-5471a8b8b6e6"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["T", "0"], "+", 
         SubscriptBox["T", "1"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["T", "1"], " ", 
          SubscriptBox["\[Kappa]", "t"]}], "+", 
         RowBox[{"L", " ", 
          SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}], 
      SubscriptBox["T", "1"]]}]], " ", 
   SubscriptBox["T", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         SubscriptBox["T", "0"], " ", 
         SubscriptBox["\[Kappa]", "t"]}], "+", 
        RowBox[{
         SubscriptBox["T", "1"], " ", 
         SubscriptBox["\[Kappa]", "t"]}], "+", 
        RowBox[{"L", " ", 
         SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         FractionBox[
          RowBox[{"L", " ", 
           SubscriptBox["T", "0"], " ", 
           SubscriptBox["\[Kappa]", "x"]}], 
          SubscriptBox["T", "1"]]]}], ")"}], " ", 
      SubsuperscriptBox["T", "1", "2"], " ", 
      SubsuperscriptBox["\[Kappa]", "t", "2"]}], "-", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       FractionBox[
        RowBox[{"L", " ", 
         SubscriptBox["T", "0"], " ", 
         SubscriptBox["\[Kappa]", "x"]}], 
        SubscriptBox["T", "1"]]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          SubscriptBox["T", "0"], " ", 
          SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          SubscriptBox["T", "0"], " ", 
          SubscriptBox["\[Kappa]", "t"]}]], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SubscriptBox["T", "1"], " ", 
           SubscriptBox["\[Kappa]", "t"]}], "+", 
          RowBox[{"L", " ", 
           SubscriptBox["\[Kappa]", "x"]}]}]]}], ")"}], " ", "L", " ", 
      SubscriptBox["T", "1"], " ", 
      SubscriptBox["\[Kappa]", "t"], " ", 
      SubscriptBox["\[Kappa]", "x"]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       FractionBox[
        RowBox[{"L", " ", 
         SubscriptBox["T", "0"], " ", 
         SubscriptBox["\[Kappa]", "x"]}], 
        SubscriptBox["T", "1"]]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          SubscriptBox["T", "0"], " ", 
          SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          SubscriptBox["T", "0"], " ", 
          SubscriptBox["\[Kappa]", "t"]}]], "-", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SubscriptBox["T", "1"], " ", 
           SubscriptBox["\[Kappa]", "t"]}], "+", 
          RowBox[{"L", " ", 
           SubscriptBox["\[Kappa]", "x"]}]}]]}], ")"}], " ", 
      SuperscriptBox["L", "2"], " ", 
      SubsuperscriptBox["\[Kappa]", "x", "2"]}]}], ")"}]}], 
  RowBox[{
   RowBox[{"L", " ", 
    SubsuperscriptBox["T", "1", "2"], " ", 
    SubsuperscriptBox["\[Kappa]", "t", "3"], " ", 
    SubscriptBox["\[Kappa]", "x"]}], "-", 
   RowBox[{
    SuperscriptBox["L", "3"], " ", 
    SubscriptBox["\[Kappa]", "t"], " ", 
    SubsuperscriptBox["\[Kappa]", "x", "3"]}]}]]], "Output",
 CellChangeTimes->{3.902483446249311*^9, 3.902809911722842*^9, 
  3.902809959219097*^9, 3.902827765648634*^9, 3.9029031619490623`*^9, 
  3.903417265350788*^9, 3.903435201798366*^9, 3.9039667986878433`*^9, 
  3.904640961876584*^9, 3.905056677993862*^9},
 CellLabel->"Out[67]=",ExpressionUUID->"23364a3b-37d3-4b04-a298-8ffd9ff446f1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"C41", "'"}], "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["t", "1"], "-", 
          SubscriptBox["t", "2"]}], ")"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], 
        RowBox[{"(", 
         RowBox[{"L", "-", 
          RowBox[{
           FractionBox["L", 
            SubscriptBox["T", "1"]], 
           RowBox[{"(", 
            RowBox[{
             SubscriptBox["t", "2"], "-", 
             SubscriptBox["T", "0"]}], ")"}]}]}], ")"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", 
       SubscriptBox["T", "1"], ",", 
       RowBox[{
        SubscriptBox["T", "0"], "+", 
        SubscriptBox["T", "1"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", 
       SubscriptBox["T", "0"], ",", 
       SubscriptBox["T", "1"]}], "}"}], ",", 
     RowBox[{"Assumptions", "->", "conds2"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.902483464900085*^9, 3.902483485316801*^9}, {
   3.902809944810306*^9, 3.902809946191236*^9}, 3.90282776445525*^9, 
   3.9028891094716597`*^9, 3.9028893749109335`*^9},
 CellLabel->"In[68]:=",ExpressionUUID->"aebac2fa-eabc-461d-bcc9-a127cf3569b6"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["T", "0"], "+", 
         SubscriptBox["T", "1"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["T", "1"], " ", 
          SubscriptBox["\[Kappa]", "t"]}], "+", 
         RowBox[{"L", " ", 
          SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}], 
      SubscriptBox["T", "1"]]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       SubscriptBox["T", "0"], " ", 
       SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{
        SubscriptBox["T", "1"], " ", 
        SubscriptBox["\[Kappa]", "t"]}], "+", 
       RowBox[{"L", " ", 
        SubscriptBox["\[Kappa]", "x"]}]}]], "-", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       SubscriptBox["T", "0"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[Kappa]", "t"], "+", 
         FractionBox[
          RowBox[{"L", " ", 
           SubscriptBox["\[Kappa]", "x"]}], 
          SubscriptBox["T", "1"]]}], ")"}]}]]}], ")"}], " ", 
   SubscriptBox["T", "1"]}], 
  RowBox[{
   SubscriptBox["\[Kappa]", "t"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["T", "1"], " ", 
      SubscriptBox["\[Kappa]", "t"]}], "+", 
     RowBox[{"L", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]]], "Output",
 CellChangeTimes->{{3.9024834673216467`*^9, 3.902483488514895*^9}, 
   3.902809914985497*^9, 3.9028099606432457`*^9, 3.9028277673677797`*^9, 
   3.9034172695814285`*^9, 3.903435206370449*^9, 3.904640966317622*^9, 
   3.905056680252239*^9},
 CellLabel->"Out[68]=",ExpressionUUID->"5d713620-f94b-4c89-855e-74036486d6d5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"C42", "'"}], "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["t", "2"], "-", 
          SubscriptBox["t", "1"]}], ")"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], 
        RowBox[{"(", 
         RowBox[{"L", "-", 
          RowBox[{
           FractionBox["L", 
            SubscriptBox["T", "1"]], 
           RowBox[{"(", 
            RowBox[{
             SubscriptBox["t", "2"], "-", 
             SubscriptBox["T", "0"]}], ")"}]}]}], ")"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", 
       SubscriptBox["T", "1"], ",", 
       RowBox[{
        SubscriptBox["T", "0"], "+", 
        SubscriptBox["T", "1"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", 
       SubscriptBox["t", "1"], ",", 
       RowBox[{
        SubscriptBox["T", "1"], "+", 
        SubscriptBox["T", "0"]}]}], "}"}], ",", 
     RowBox[{"Assumptions", "->", "conds2"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.902483496509699*^9, 3.902483500111046*^9}, {
   3.9024835522035913`*^9, 3.9024835540455437`*^9}, {3.9024836601264257`*^9, 
   3.902483661791028*^9}, {3.902809948207728*^9, 3.902809949381687*^9}, 
   3.902827767460478*^9, 3.902889110936735*^9, 3.9028893749109335`*^9},
 CellLabel->"In[69]:=",ExpressionUUID->"41d46639-4c95-4465-b93e-86b750e821dc"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SubscriptBox["T", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", 
          SubscriptBox["T", "0"]}], " ", 
         SubscriptBox["\[Kappa]", "t"]}]]}], 
      SubscriptBox["\[Kappa]", "t"]], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", 
           FractionBox[
            RowBox[{"L", " ", 
             SubscriptBox["T", "0"], " ", 
             SubscriptBox["\[Kappa]", "x"]}], 
            SubscriptBox["T", "1"]]}]]}], ")"}], " ", 
       SubscriptBox["T", "1"]}], 
      RowBox[{"L", " ", 
       SubscriptBox["\[Kappa]", "x"]}]]}], ")"}]}], 
  RowBox[{
   RowBox[{
    SubscriptBox["T", "1"], " ", 
    SubscriptBox["\[Kappa]", "t"]}], "-", 
   RowBox[{"L", " ", 
    SubscriptBox["\[Kappa]", "x"]}]}]]], "Output",
 CellChangeTimes->{3.902483556843995*^9, 3.902483664676635*^9, 
  3.902809916623022*^9, 3.902809961830976*^9, 3.9028277693115997`*^9, 
  3.9034172729745083`*^9, 3.9034352101318636`*^9, 3.9046409697317266`*^9, 
  3.9050566821161118`*^9},
 CellLabel->"Out[69]=",ExpressionUUID->"420223ea-7a20-4e72-97d6-666f1ef28ce5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"C43", "'"}], "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["t", "1"], "-", 
          SubscriptBox["t", "2"]}], ")"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], 
        RowBox[{"(", 
         RowBox[{"L", "-", 
          RowBox[{
           FractionBox["L", 
            SubscriptBox["T", "1"]], 
           RowBox[{"(", 
            RowBox[{
             SubscriptBox["t", "2"], "-", 
             SubscriptBox["T", "0"]}], ")"}]}]}], ")"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", 
       SubscriptBox["T", "1"], ",", 
       RowBox[{
        SubscriptBox["T", "0"], "+", 
        SubscriptBox["T", "1"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", 
       SubscriptBox["T", "1"], ",", 
       SubscriptBox["t", "1"]}], "}"}], ",", 
     RowBox[{"Assumptions", "->", "conds2"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.902483496509699*^9, 3.902483500111046*^9}, {
   3.9024835522035913`*^9, 3.902483566307178*^9}, {3.9024836803236856`*^9, 
   3.9024836820182323`*^9}, {3.902809950694092*^9, 3.902809953509659*^9}, 
   3.902827769633645*^9, 3.902889112168646*^9, 3.902889374926446*^9},
 CellLabel->"In[70]:=",ExpressionUUID->"85431a33-1424-4db2-b726-c1f3456df300"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SubscriptBox["T", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["T", "0"]}], " ", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["\[Kappa]", "t"], "+", 
            FractionBox[
             RowBox[{"L", " ", 
              SubscriptBox["\[Kappa]", "x"]}], 
             SubscriptBox["T", "1"]]}], ")"}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            SubscriptBox["T", "0"], " ", 
            SubscriptBox["\[Kappa]", "t"]}]]}], ")"}]}], 
       SubscriptBox["\[Kappa]", "t"]]}], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", 
           FractionBox[
            RowBox[{"L", " ", 
             SubscriptBox["T", "0"], " ", 
             SubscriptBox["\[Kappa]", "x"]}], 
            SubscriptBox["T", "1"]]}]]}], ")"}], " ", 
       SubscriptBox["T", "1"]}], 
      RowBox[{"L", " ", 
       SubscriptBox["\[Kappa]", "x"]}]]}], ")"}]}], 
  RowBox[{
   RowBox[{
    SubscriptBox["T", "1"], " ", 
    SubscriptBox["\[Kappa]", "t"]}], "+", 
   RowBox[{"L", " ", 
    SubscriptBox["\[Kappa]", "x"]}]}]]], "Output",
 CellChangeTimes->{3.902483571127102*^9, 3.902483688809173*^9, 
  3.902809920517645*^9, 3.90280996340679*^9, 3.90282777166605*^9, 
  3.9034172772804165`*^9, 3.903435214587908*^9, 3.9046409739695787`*^9, 
  3.9050566843617477`*^9},
 CellLabel->"Out[70]=",ExpressionUUID->"cf6ceb54-d603-480c-a619-eb307b433a4e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"C41", "'"}], "+", 
    RowBox[{"C42", "'"}], "+", 
    RowBox[{"C43", "'"}]}], "==", 
   RowBox[{"C4", "'"}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.902483574035749*^9, 3.902483591257751*^9}, {
  3.902483692339469*^9, 3.902483695819586*^9}, {3.902809960686236*^9, 
  3.9028099667875433`*^9}, {3.902827772971795*^9, 3.9028277756193132`*^9}},
 CellLabel->"In[71]:=",ExpressionUUID->"7c1bece4-11da-4ab8-87bf-9ccaa4a4d101"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9024835921022053`*^9, 3.902483696287539*^9, 
  3.9028099672582893`*^9, 3.902827776050268*^9, 3.902904834854526*^9, 
  3.9034172776277313`*^9, 3.9034352149472337`*^9, 3.90464097429988*^9, 
  3.905056684585531*^9},
 CellLabel->"Out[71]=",ExpressionUUID->"0e9e34bc-ba06-422e-89fd-d0f8902266d4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"C41", "'"}], "+", 
    RowBox[{"C42", "'"}], "+", 
    RowBox[{"C43", "'"}]}], "/.", "rule1"}], "/.", "rule1"}]], "Input",
 CellChangeTimes->{{3.9029046770480366`*^9, 3.9029046797865925`*^9}},
 CellLabel->"In[72]:=",ExpressionUUID->"20c8fbf5-5154-478c-a4cb-95dd63f8a45a"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"\[Beta]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "\[Tau]"}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            FractionBox[
             RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]}]]}], ")"}], " ",
         "\[Beta]"}], "\[Gamma]"]}], ")"}]}], 
   RowBox[{"\[Beta]", "-", "\[Gamma]"}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "+", "\[Tau]"}], ")"}]}], "\[Beta]"]}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[Beta]", "+", "\[Gamma]"}]], "-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          FractionBox["\[Gamma]", "\[Beta]"]}], ")"}], " ", "\[Tau]"}]]}], 
     ")"}], " ", "\[Beta]"}], 
   RowBox[{"\[Beta]", "+", "\[Gamma]"}]], "+", 
  FractionBox[
   RowBox[{"\[Beta]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              FractionBox["\[Gamma]", "\[Beta]"]}], ")"}], " ", "\[Tau]"}], 
           ")"}]}]]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}]}], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            FractionBox[
             RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]}]]}], ")"}], " ",
         "\[Beta]"}], "\[Gamma]"]}], ")"}]}], 
   RowBox[{"\[Beta]", "+", "\[Gamma]"}]]}]], "Output",
 CellChangeTimes->{3.902904680124761*^9, 3.90341727763774*^9, 
  3.9034352149692535`*^9, 3.904640974323901*^9, 3.9050566846033583`*^9},
 CellLabel->"Out[72]=",ExpressionUUID->"e3376da7-a1ad-4f18-897c-2a59957841c3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"C4", "'"}], "==", 
     RowBox[{
      FractionBox["\[Beta]", 
       SuperscriptBox[
        SubscriptBox["\[Kappa]", "t"], "2"]], 
      RowBox[{"(", 
       RowBox[{
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]"}]], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}]}], 
         RowBox[{"\[Beta]", "+", "\[Gamma]"}]], "+", 
        RowBox[{
         FractionBox["1", 
          RowBox[{"\[Beta]", "+", "\[Gamma]"}]], 
         FractionBox["\[Beta]", "\[Gamma]"], 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "\[Gamma]"}], " ", 
             RowBox[{"\[Tau]", "/", "\[Beta]"}]}]]}], ")"}]}], "+", 
        RowBox[{
         FractionBox["1", 
          RowBox[{"\[Beta]", "-", "\[Gamma]"}]], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            FractionBox["\[Beta]", "\[Gamma]"], 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{"-", "\[Gamma]"}], " ", 
                RowBox[{"\[Tau]", "/", "\[Beta]"}]}]]}], ")"}]}], "+", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"-", "\[Tau]"}]], "-", "1"}], ")"}]}]}], ")"}]}]}], "/.", 
    "rule0"}], ",", "conds2"}], "]"}]], "Input",
 CellChangeTimes->{{3.9029031740096035`*^9, 3.9029035527863054`*^9}, {
   3.902903687220317*^9, 3.902903692883765*^9}, {3.902903760839326*^9, 
   3.9029039714540806`*^9}, {3.9029040784806643`*^9, 
   3.9029040835946465`*^9}, {3.9029046545695004`*^9, 
   3.9029046652562923`*^9}, {3.9029047152934604`*^9, 3.9029047341491427`*^9}, 
   3.9029048617431746`*^9, {3.9029048949204826`*^9, 3.9029049113725595`*^9}, {
   3.902904984971311*^9, 3.9029050167725744`*^9}, {3.9029050886197157`*^9, 
   3.9029050996690254`*^9}},
 CellLabel->"In[73]:=",ExpressionUUID->"b12655a6-5649-4c7f-8789-17f86e9ccd13"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9029031795983753`*^9, {3.902903231925889*^9, 3.9029032831529093`*^9}, {
   3.9029033202464576`*^9, 3.9029033383748083`*^9}, {3.902903375741289*^9, 
   3.902903396515336*^9}, 3.9029034294828205`*^9, {3.902903492914365*^9, 
   3.9029035531821175`*^9}, {3.902903688082494*^9, 3.9029037071360345`*^9}, {
   3.902903746226612*^9, 3.902903796862175*^9}, 3.902904671041933*^9, 
   3.9029047374912004`*^9, 3.9029048636212273`*^9, 3.9029049153069973`*^9, 
   3.902905018106054*^9, 3.902905109004673*^9, 3.9034172797776823`*^9, 
   3.903435217162244*^9, 3.9046409765279045`*^9, 3.905056685644864*^9},
 CellLabel->"Out[73]=",ExpressionUUID->"3a780fc7-df2d-4579-b367-63307908b694"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}]}], 
     RowBox[{"\[Beta]", "+", "\[Gamma]"}]], "+", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"\[Beta]", "+", "\[Gamma]"}]], 
     FractionBox["\[Beta]", "\[Gamma]"], 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "\[Gamma]"}], " ", 
         RowBox[{"\[Tau]", "/", "\[Beta]"}]}]]}], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"\[Beta]", "-", "\[Gamma]"}]], 
     FractionBox["\[Beta]", "\[Gamma]"], 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "\[Gamma]"}], " ", 
         RowBox[{"\[Tau]", "/", "\[Beta]"}]}]]}], ")"}]}], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "\[Tau]"}]], "-", "1"}], 
     RowBox[{"\[Beta]", "-", "\[Gamma]"}]]}], ")"}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.9047100994969807`*^9, 3.9047101292643456`*^9}, {
  3.9047101613935256`*^9, 3.9047101993857784`*^9}, {3.904710230665625*^9, 
  3.904710232736974*^9}},
 CellLabel->"In[74]:=",ExpressionUUID->"38d522ce-ed3a-4b3f-bf28-f4c11687a005"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "\[Tau]"}]], 
   RowBox[{"\[Beta]", "-", "\[Gamma]"}]], "+", 
  FractionBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]"}]], 
   RowBox[{"\[Beta]", "+", "\[Gamma]"}]], "-", 
  FractionBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]", "+", "\[Tau]"}]], 
   RowBox[{"\[Beta]", "+", "\[Gamma]"}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"2", " ", "\[Beta]"}], "+", "\[Gamma]"}], 
   RowBox[{
    RowBox[{"\[Beta]", " ", "\[Gamma]"}], "+", 
    SuperscriptBox["\[Gamma]", "2"]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]}]], " ", 
    SuperscriptBox["\[Beta]", "2"]}], 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Beta]", "2"], " ", "\[Gamma]"}], "-", 
    SuperscriptBox["\[Gamma]", "3"]}]]}]], "Output",
 CellChangeTimes->{{3.9047101067665663`*^9, 3.904710111074794*^9}, 
   3.904710200316165*^9, 3.9047102329882946`*^9, 3.9050566860567303`*^9},
 CellLabel->"Out[74]=",ExpressionUUID->"42497412-9657-41eb-a204-ebd995226126"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    FractionBox["1", 
     RowBox[{"\[Beta]", "+", "\[Gamma]"}]], 
    FractionBox["\[Beta]", "\[Gamma]"], 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[Gamma]"}], " ", 
        RowBox[{"\[Tau]", "/", "\[Beta]"}]}]]}], ")"}]}], "+", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"\[Beta]", "-", "\[Gamma]"}]], 
    FractionBox["\[Beta]", "\[Gamma]"], 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[Gamma]"}], " ", 
        RowBox[{"\[Tau]", "/", "\[Beta]"}]}]]}], ")"}]}]}], "//", 
  "Simplify"}]], "Input",
 CellChangeTimes->{{3.9047102167768135`*^9, 3.904710237944967*^9}},
 CellLabel->"In[75]:=",ExpressionUUID->"8f08c3e4-e943-46ac-b91d-97b4818cfda0"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]}]]}], ")"}], " ", 
   SuperscriptBox["\[Beta]", "2"]}], 
  RowBox[{"\[Gamma]", " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["\[Beta]", "2"], "-", 
     SuperscriptBox["\[Gamma]", "2"]}], ")"}]}]]], "Output",
 CellChangeTimes->{{3.904710217888271*^9, 3.904710238272732*^9}, 
   3.905056686073998*^9},
 CellLabel->"Out[75]=",ExpressionUUID->"13fbcf59-5ce1-48a1-9795-dbc9e19187f3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}]}], 
     RowBox[{"\[Beta]", "+", "\[Gamma]"}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "\[Tau]"}]], "-", "1"}], 
     RowBox[{"\[Beta]", "-", "\[Gamma]"}]]}], "==", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "\[Tau]"}]]}], 
     RowBox[{"\[Beta]", "-", "\[Gamma]"}]], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[Tau]", "-", "\[Beta]", "-", "\[Gamma]"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "\[Tau]"}]]}], "+", "1"}], ")"}]}], 
     RowBox[{"\[Beta]", "+", "\[Gamma]"}]]}]}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.9047104151922827`*^9, 3.904710419472704*^9}, {
  3.904711312632924*^9, 3.9047113405767307`*^9}},
 CellLabel->"In[76]:=",ExpressionUUID->"4cd448d1-47fe-4a9a-a1e9-5fe20b945421"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9047113411597238`*^9, 3.905056686107329*^9},
 CellLabel->"Out[76]=",ExpressionUUID->"b18a5b1b-d892-4576-893f-09331fff1210"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", "\[Tau]"}]]}], 
    RowBox[{"\[Beta]", "-", "\[Gamma]"}]], "-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[Tau]", "-", "\[Beta]", "-", "\[Gamma]"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "\[Tau]"}]]}], "+", "1"}], ")"}]}], 
    RowBox[{"\[Beta]", "+", "\[Gamma]"}]]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.904711314440262*^9, 3.9047113144412622`*^9}, {
  3.9047113455935864`*^9, 3.90471134749436*^9}},
 CellLabel->"In[77]:=",ExpressionUUID->"c6eab110-697c-4834-b529-8d96cf70fedc"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "\[Tau]"}]]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"\[Beta]", "+", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]", "+", "\[Tau]"}]], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}]}], "+", "\[Gamma]"}], 
     ")"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}]}]]}]], "Output",
 CellChangeTimes->{3.905056686140915*^9},
 CellLabel->"Out[77]=",ExpressionUUID->"2b45fef7-604c-40bf-b124-2e42511eff64"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]"}]], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}]}], 
    RowBox[{"\[Beta]", "+", "\[Gamma]"}]], "+", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"\[Beta]", "+", "\[Gamma]"}]], 
    FractionBox["\[Beta]", "\[Gamma]"], 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[Gamma]"}], " ", 
        RowBox[{"\[Tau]", "/", "\[Beta]"}]}]]}], ")"}]}]}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.9047105511288166`*^9, 3.9047105594807563`*^9}},
 CellLabel->"In[78]:=",ExpressionUUID->"6e2e5162-b82b-492f-b998-2fd71473c796"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]"}]]}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}]}], "+", 
   FractionBox[
    RowBox[{"\[Beta]", "-", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]}]], " ", 
      "\[Beta]"}]}], "\[Gamma]"]}], 
  RowBox[{"\[Beta]", "+", "\[Gamma]"}]]], "Output",
 CellChangeTimes->{{3.904710552293101*^9, 3.904710559761836*^9}, 
   3.905056686277657*^9},
 CellLabel->"Out[78]=",ExpressionUUID->"f29e9fc0-6c7f-4b14-bd48-de190234b216"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    FractionBox["1", 
     RowBox[{"\[Beta]", "-", "\[Gamma]"}]], 
    FractionBox["\[Beta]", "\[Gamma]"], 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[Gamma]"}], " ", 
        RowBox[{"\[Tau]", "/", "\[Beta]"}]}]]}], ")"}]}], "+", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", "\[Tau]"}]], "-", "1"}], 
    RowBox[{"\[Beta]", "-", "\[Gamma]"}]]}], "//", "FullSimplify"}]], "Input",\

 CellChangeTimes->{{3.9047105696248055`*^9, 3.904710576081543*^9}},
 CellLabel->"In[79]:=",ExpressionUUID->"d8b32bd0-5ee4-47e6-97b0-5d745a2e28aa"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "\[Tau]"}]], "+", 
   FractionBox[
    RowBox[{"\[Beta]", "-", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]}]], " ", 
      "\[Beta]"}]}], "\[Gamma]"]}], 
  RowBox[{"\[Beta]", "-", "\[Gamma]"}]]], "Output",
 CellChangeTimes->{{3.9047105737030787`*^9, 3.904710576326766*^9}, 
   3.905056686355431*^9},
 CellLabel->"Out[79]=",ExpressionUUID->"eec88ff4-4004-4e3d-8b1d-0f07b10f58df"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Entire Expression", "Section"]], "Section",
 CellChangeTimes->{{3.902896452649519*^9, 
  3.9028964592836285`*^9}},ExpressionUUID->"cfdafad0-aa00-46fb-a31f-\
b2304fe0e8ab"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"F1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"P1", "+", "P2", "+", "P3", "+", "P4"}], ")"}], "-", 
    RowBox[{"(", 
     RowBox[{"C1", "+", "C2", "+", "C3", "+", "C4"}], ")"}]}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.9029067922159925`*^9, 3.902906802558093*^9}, {
   3.902908555240718*^9, 3.902908561985396*^9}, {3.9029086768415174`*^9, 
   3.902908692507507*^9}, 3.9029093283147793`*^9, {3.902996623915039*^9, 
   3.902996644402988*^9}, {3.903426686562041*^9, 3.90342670031314*^9}, {
   3.9034292143651896`*^9, 3.903429215981136*^9}, 3.903435574571885*^9},
 CellLabel->"In[80]:=",ExpressionUUID->"c6b15aef-31e0-4ebe-a0e1-8523571d031a"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["T", "0"]}], " ", 
        SubscriptBox["\[Kappa]", "t"]}]], "+", 
      RowBox[{
       SubscriptBox["T", "0"], " ", 
       SubscriptBox["\[Kappa]", "t"]}]}], ")"}]}], 
   SubsuperscriptBox["\[Kappa]", "t", "2"]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["T", "0"], "+", 
           SubscriptBox["T", "1"]}], ")"}], " ", 
         SubscriptBox["\[Kappa]", "t"]}], ")"}]}], "-", 
      RowBox[{"L", " ", 
       SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         SubscriptBox["T", "0"], " ", 
         SubscriptBox["\[Kappa]", "t"]}]]}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", 
        SubscriptBox["T", "1"], " ", 
        SubscriptBox["\[Kappa]", "t"]}]], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["T", "0"], "+", 
           SubscriptBox["T", "1"]}], ")"}], " ", 
         SubscriptBox["\[Kappa]", "t"]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["T", "0"], "-", 
         SubscriptBox["T", "1"]}], ")"}], " ", 
       SubscriptBox["\[Kappa]", "t"]}]}], ")"}]}], 
   SubsuperscriptBox["\[Kappa]", "t", "2"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    SubsuperscriptBox["T", "1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SubscriptBox["T", "1"]}], " ", 
         SubscriptBox["\[Kappa]", "t"]}], "-", 
        RowBox[{"L", " ", 
         SubscriptBox["\[Kappa]", "x"]}]}]], "-", 
      RowBox[{
       SubscriptBox["T", "1"], " ", 
       SubscriptBox["\[Kappa]", "t"]}], "-", 
      RowBox[{"L", " ", 
       SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubscriptBox["T", "1"], " ", 
       SubscriptBox["\[Kappa]", "t"]}], "+", 
      RowBox[{"L", " ", 
       SubscriptBox["\[Kappa]", "x"]}]}], ")"}], "2"]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["T", "0"], "+", 
           SubscriptBox["T", "1"]}], ")"}], " ", 
         SubscriptBox["\[Kappa]", "t"]}], ")"}]}], "-", 
      RowBox[{"L", " ", 
       SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        SubscriptBox["T", "0"], " ", 
        SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         SubscriptBox["T", "1"], " ", 
         SubscriptBox["\[Kappa]", "t"]}], "+", 
        RowBox[{"L", " ", 
         SubscriptBox["\[Kappa]", "x"]}]}]]}], ")"}], " ", 
    SubscriptBox["T", "1"]}], 
   RowBox[{
    SubscriptBox["\[Kappa]", "t"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubscriptBox["T", "1"], " ", 
       SubscriptBox["\[Kappa]", "t"]}], "+", 
      RowBox[{"L", " ", 
       SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["T", "0"], "+", 
           SubscriptBox["T", "1"]}], ")"}], " ", 
         SubscriptBox["\[Kappa]", "t"]}], ")"}]}], "-", 
      RowBox[{"L", " ", 
       SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
    SubscriptBox["T", "1"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["T", "0"], "+", 
           SubscriptBox["T", "1"]}], ")"}], " ", 
         SubscriptBox["\[Kappa]", "t"]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"L", " ", 
           SubscriptBox["\[Kappa]", "x"]}]]}], ")"}], " ", 
       SubsuperscriptBox["T", "1", "2"], " ", 
       SubsuperscriptBox["\[Kappa]", "t", "2"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            SubscriptBox["T", "0"], " ", 
            SubscriptBox["\[Kappa]", "t"]}]]}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SubscriptBox["T", "1"], " ", 
           SubscriptBox["\[Kappa]", "t"]}]], "+", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SubscriptBox["T", "1"], " ", 
             SubscriptBox["\[Kappa]", "t"]}], "+", 
            RowBox[{"L", " ", 
             SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              SubscriptBox["T", "0"], " ", 
              SubscriptBox["\[Kappa]", "t"]}]]}], ")"}]}]}], ")"}], " ", "L", 
       " ", 
       SubscriptBox["T", "1"], " ", 
       SubscriptBox["\[Kappa]", "t"], " ", 
       SubscriptBox["\[Kappa]", "x"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           SubscriptBox["T", "0"], " ", 
           SubscriptBox["\[Kappa]", "t"]}]], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           SubscriptBox["T", "1"], " ", 
           SubscriptBox["\[Kappa]", "t"]}]], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["T", "0"], "+", 
              SubscriptBox["T", "1"]}], ")"}], " ", 
            SubscriptBox["\[Kappa]", "t"]}]]}], "+", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SubscriptBox["T", "1"], " ", 
             SubscriptBox["\[Kappa]", "t"]}], "+", 
            RowBox[{"L", " ", 
             SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              SubscriptBox["T", "0"], " ", 
              SubscriptBox["\[Kappa]", "t"]}]]}], ")"}]}]}], ")"}], " ", 
       SuperscriptBox["L", "2"], " ", 
       SubsuperscriptBox["\[Kappa]", "x", "2"]}]}], ")"}]}], 
   RowBox[{
    RowBox[{"L", " ", 
     SubsuperscriptBox["T", "1", "2"], " ", 
     SubsuperscriptBox["\[Kappa]", "t", "3"], " ", 
     SubscriptBox["\[Kappa]", "x"]}], "-", 
    RowBox[{
     SuperscriptBox["L", "3"], " ", 
     SubscriptBox["\[Kappa]", "t"], " ", 
     SubsuperscriptBox["\[Kappa]", "x", "3"]}]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["T", "0"], "+", 
           SubscriptBox["T", "1"]}], ")"}], " ", 
         SubscriptBox["\[Kappa]", "t"]}], ")"}]}], "-", 
      RowBox[{"L", " ", 
       SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
    SubsuperscriptBox["T", "1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SubscriptBox["T", "1"], " ", 
           SubscriptBox["\[Kappa]", "t"]}], "-", 
          RowBox[{"L", " ", 
           SubscriptBox["\[Kappa]", "x"]}]}], ")"}], "2"]}], "-", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", 
         SubscriptBox["T", "1"], " ", 
         SubscriptBox["\[Kappa]", "t"]}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SubscriptBox["T", "1"], " ", 
           SubscriptBox["\[Kappa]", "t"]}], "+", 
          RowBox[{"L", " ", 
           SubscriptBox["\[Kappa]", "x"]}]}], ")"}], "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SubscriptBox["T", "1"], " ", 
          SubscriptBox["\[Kappa]", "t"]}], "+", 
         RowBox[{"L", " ", 
          SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["L", "2"], " ", 
          SubsuperscriptBox["\[Kappa]", "x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"L", " ", 
             SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}], "+", 
         RowBox[{
          SubsuperscriptBox["T", "1", "2"], " ", 
          SubsuperscriptBox["\[Kappa]", "t", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"L", " ", 
             SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubsuperscriptBox["T", "1", "2"], " ", 
       SubsuperscriptBox["\[Kappa]", "t", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["L", "2"], " ", 
       SubsuperscriptBox["\[Kappa]", "x", "2"]}]}], ")"}], "2"]]}]], "Output",\

 CellChangeTimes->{{3.9029067958593135`*^9, 3.9029068096569915`*^9}, {
   3.902908678306057*^9, 3.9029087003491335`*^9}, 3.902909336555877*^9, 
   3.9029783980240173`*^9, 3.9029792676090612`*^9, 3.9029796368971453`*^9, 
   3.9034191644218245`*^9, 3.9034192085983124`*^9, 3.9034267467778234`*^9, 
   3.9034292273426795`*^9, 3.9034450800503087`*^9, 3.905056693818016*^9},
 CellLabel->"Out[80]=",ExpressionUUID->"4b523b3c-b093-4349-bae1-2818542fe45a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"F2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"P1", "+", "P2", "+", "P3", "+", "P4"}], ")"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"C1", "'"}], "+", 
      RowBox[{"C2", "'"}], "+", 
      RowBox[{"C3", "'"}], "+", 
      RowBox[{"C4", "'"}]}], ")"}]}], "//", "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.90290934072358*^9, 3.9029093451831937`*^9}, {
  3.903426728562292*^9, 3.903426729505148*^9}, {3.9034292100213847`*^9, 
  3.9034292116774635`*^9}},
 CellLabel->"In[81]:=",ExpressionUUID->"3d7f421f-f3e1-4371-ae21-02240164c860"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"L", " ", 
    SubscriptBox["\[Kappa]", "x"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubsuperscriptBox["T", "1", "2"], " ", 
        SubsuperscriptBox["\[Kappa]", "t", "3"]}], "-", 
       RowBox[{
        SuperscriptBox["L", "2"], " ", 
        SubscriptBox["\[Kappa]", "t"], " ", 
        SubsuperscriptBox["\[Kappa]", "x", "2"]}]}], ")"}], "2"]}]], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["T", "0"], "+", 
         SubscriptBox["T", "1"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["T", "1"], " ", 
          SubscriptBox["\[Kappa]", "t"]}], "+", 
         RowBox[{"L", " ", 
          SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}], 
      SubscriptBox["T", "1"]]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       FractionBox[
        RowBox[{"L", " ", 
         SubscriptBox["T", "0"], " ", 
         SubscriptBox["\[Kappa]", "x"]}], 
        SubscriptBox["T", "1"]]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           SubscriptBox["T", "0"], " ", 
           SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], "2"], " ", 
      SuperscriptBox["L", "4"], " ", 
      SubscriptBox["T", "1"], " ", 
      SubscriptBox["\[Kappa]", "t"], " ", 
      SubsuperscriptBox["\[Kappa]", "x", "4"]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       FractionBox[
        RowBox[{"L", " ", 
         SubscriptBox["T", "0"], " ", 
         SubscriptBox["\[Kappa]", "x"]}], 
        SubscriptBox["T", "1"]]], " ", 
      SuperscriptBox["L", "5"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              SubscriptBox["T", "0"], " ", 
              SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SubscriptBox["T", "1"], " ", 
            SubscriptBox["\[Kappa]", "t"]}], "+", 
           RowBox[{"L", " ", 
            SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              SubscriptBox["T", "0"], " ", 
              SubscriptBox["\[Kappa]", "t"]}]], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{
               SubscriptBox["T", "0"], " ", 
               SubscriptBox["\[Kappa]", "t"]}]}], ")"}]}]}], ")"}]}]}], ")"}],
       " ", 
      SubsuperscriptBox["\[Kappa]", "x", "5"]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["T", "0"], "+", 
           SubscriptBox["T", "1"]}], ")"}], " ", 
         SubscriptBox["\[Kappa]", "t"]}], "+", 
        RowBox[{"L", " ", 
         SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         FractionBox[
          RowBox[{"L", " ", 
           SubscriptBox["T", "0"], " ", 
           SubscriptBox["\[Kappa]", "x"]}], 
          SubscriptBox["T", "1"]]]}], ")"}], " ", 
      SuperscriptBox["L", "2"], " ", 
      SubsuperscriptBox["T", "1", "3"], " ", 
      SubsuperscriptBox["\[Kappa]", "t", "3"], " ", 
      SubsuperscriptBox["\[Kappa]", "x", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "4"}], "+", 
        RowBox[{"L", " ", 
         SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["T", "0"], "+", 
           SubscriptBox["T", "1"]}], ")"}], " ", 
         SubscriptBox["\[Kappa]", "t"]}], "+", 
        RowBox[{"L", " ", 
         SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         FractionBox[
          RowBox[{"L", " ", 
           SubscriptBox["T", "0"], " ", 
           SubscriptBox["\[Kappa]", "x"]}], 
          SubscriptBox["T", "1"]]]}], ")"}], " ", 
      SubsuperscriptBox["T", "1", "5"], " ", 
      SubsuperscriptBox["\[Kappa]", "t", "5"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", 
        RowBox[{"L", " ", 
         SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         SubscriptBox["T", "1"], " ", 
         SubscriptBox["\[Kappa]", "t"]}], "+", 
        RowBox[{"L", " ", 
         SubscriptBox["\[Kappa]", "x"]}]}]], " ", "L", " ", 
      SubsuperscriptBox["T", "1", "4"], " ", 
      SubsuperscriptBox["\[Kappa]", "t", "4"], " ", 
      SubscriptBox["\[Kappa]", "x"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           SubscriptBox["T", "0"], " ", 
           SubscriptBox["\[Kappa]", "t"]}]], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SuperscriptBox["\[ExponentialE]", 
            FractionBox[
             RowBox[{"L", " ", 
              SubscriptBox["T", "0"], " ", 
              SubscriptBox["\[Kappa]", "x"]}], 
             SubscriptBox["T", "1"]]]}], ")"}], " ", 
         SubscriptBox["T", "0"], " ", 
         SubscriptBox["\[Kappa]", "t"]}], "-", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          FractionBox[
           RowBox[{"L", " ", 
            SubscriptBox["T", "0"], " ", 
            SubscriptBox["\[Kappa]", "x"]}], 
           SubscriptBox["T", "1"]]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             SubscriptBox["T", "0"], " ", 
             SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", "L", " ", 
         SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}], "-", 
     RowBox[{
      SuperscriptBox["L", "3"], " ", 
      SubsuperscriptBox["T", "1", "2"], " ", 
      SubsuperscriptBox["\[Kappa]", "t", "2"], " ", 
      SubsuperscriptBox["\[Kappa]", "x", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["T", "0"], "+", 
              SubscriptBox["T", "1"]}], ")"}], " ", 
            SubscriptBox["\[Kappa]", "t"]}], "+", 
           RowBox[{"L", " ", 
            SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["\[ExponentialE]", 
             FractionBox[
              RowBox[{"L", " ", 
               SubscriptBox["T", "0"], " ", 
               SubscriptBox["\[Kappa]", "x"]}], 
              SubscriptBox["T", "1"]]]}]}], ")"}], " ", 
         SubscriptBox["T", "0"], " ", 
         SubscriptBox["\[Kappa]", "t"]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          FractionBox[
           RowBox[{"L", " ", 
            SubscriptBox["T", "0"], " ", 
            SubscriptBox["\[Kappa]", "x"]}], 
           SubscriptBox["T", "1"]]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             SubscriptBox["T", "0"], " ", 
             SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             SubscriptBox["T", "0"], " ", 
             SubscriptBox["\[Kappa]", "t"]}]], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SubscriptBox["T", "1"], " ", 
               SubscriptBox["\[Kappa]", "t"]}], "+", 
              RowBox[{"L", " ", 
               SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"L", " ", 
               SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.9029093610578794`*^9, 3.9029792742505198`*^9, 
  3.9029795821854277`*^9, 3.9029796455451813`*^9, 3.90341922116772*^9, 
  3.903426949491131*^9, 3.903429235206781*^9, 3.903445088038559*^9, 
  3.9050566977414083`*^9},
 CellLabel->"Out[81]=",ExpressionUUID->"89ec0eb6-3806-41fe-af2a-d50d3054609a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"F1", "/.", "rule1"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.902979367725462*^9, 3.9029793731185093`*^9}},
 CellLabel->"In[82]:=",ExpressionUUID->"4101df01-74f0-4956-a0ed-4ef93363c5c9"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}], "2"], " ", "\[Gamma]", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}], "2"]}]], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]", "-", "\[Tau]"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}], "2"]}], " ", 
      SuperscriptBox["\[Gamma]", "3"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", "\[Tau]"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}], "2"], " ", 
      SuperscriptBox["\[Gamma]", "3"]}], "-", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[Beta]"}]], " ", 
      SuperscriptBox["\[Gamma]", "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}], "2"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[Beta]", "+", "\[Gamma]"}]], " ", 
      SuperscriptBox["\[Gamma]", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["\[Beta]", "4"], "-", 
        RowBox[{
         SuperscriptBox["\[Beta]", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "\[Gamma]"}], ")"}], " ", "\[Gamma]"}], 
        "+", 
        SuperscriptBox["\[Gamma]", "3"]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[Beta]", "+", "\[Tau]"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["\[Beta]", "2"], "-", 
         SuperscriptBox["\[Gamma]", "2"]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[Beta]", " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", "\[Gamma]"}], ")"}]}], "-", 
        RowBox[{"\[Gamma]", " ", "\[Tau]"}]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[Beta]", "+", "\[Gamma]", "+", "\[Tau]"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[Beta]", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", "\[Gamma]"}], ")"}]}], "+", 
        RowBox[{"2", " ", "\[Beta]", " ", 
         SuperscriptBox["\[Gamma]", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "\[Tau]"}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["\[Gamma]", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "\[Tau]"}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["\[Beta]", "2"], " ", "\[Gamma]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "4"}], "+", "\[Gamma]", "+", "\[Tau]"}], ")"}]}]}], 
       ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.905056697833716*^9},
 CellLabel->"Out[82]=",ExpressionUUID->"b286e7b0-e802-4c79-b271-da6668c8004a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"F2", "/.", "rule1"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.9029793791509457`*^9, 3.9029793861931*^9}},
 CellLabel->"In[83]:=",ExpressionUUID->"a528e094-4e5b-4b5b-acef-4bbe0daa359c"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"\[Gamma]", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], "-", 
       SuperscriptBox["\[Gamma]", "2"]}], ")"}], "2"]}]], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "+", "\[Tau]"}], ")"}]}], "\[Beta]"]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[Beta]", "+", "\[Gamma]", "+", "\[Tau]"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         FractionBox[
          RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]]}], ")"}], " ", 
      SuperscriptBox["\[Beta]", "5"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "\[Gamma]"}], ")"}]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[Beta]", "+", "\[Gamma]", "+", "\[Tau]"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         FractionBox[
          RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]]}], ")"}], " ", 
      SuperscriptBox["\[Beta]", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "4"}], "+", "\[Gamma]"}], ")"}], " ", 
      SuperscriptBox["\[Gamma]", "2"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       FractionBox[
        RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}], "2"], " ", 
      "\[Beta]", " ", 
      SuperscriptBox["\[Gamma]", "4"]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       FractionBox[
        RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]], " ", 
      SuperscriptBox["\[Gamma]", "5"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}], "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"\[Beta]", "+", "\[Gamma]"}]], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", "\[Tau]"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Tau]"}], ")"}]}]}], ")"}]}]}], 
       ")"}]}], "-", 
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      SuperscriptBox["\[Gamma]", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          FractionBox[
           RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["\[ExponentialE]", "\[Tau]"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"\[Beta]", "+", "\[Gamma]"}]], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Gamma]"}], ")"}]}]}], ")"}]}], "+", 
        
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"\[Beta]", "+", "\[Gamma]", "+", "\[Tau]"}]], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["\[ExponentialE]", 
             FractionBox[
              RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]]}]}], ")"}], 
         " ", "\[Tau]"}]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[Beta]", "+", "\[Gamma]"}]], " ", 
      SuperscriptBox["\[Beta]", "4"], " ", "\[Gamma]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          FractionBox[
           RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]], " ", 
         "\[Gamma]"}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", "\[Tau]"], " ", "\[Tau]"}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"\[Tau]", "+", 
           FractionBox[
            RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "\[Gamma]"}], "+", "\[Tau]"}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{3.905056697902409*^9},
 CellLabel->"Out[83]=",ExpressionUUID->"57b2afc1-4068-4320-a144-1e07c738afe1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"P1", ",", "P2", ",", "P3", ",", "P4", ",", 
     RowBox[{"C1", "'"}], ",", 
     RowBox[{"C2", "'"}], ",", 
     RowBox[{"C3", "'"}], ",", 
     RowBox[{"C4", "'"}]}], "}"}], "/.", 
   RowBox[{
    SubscriptBox["T", "0"], "->", "0"}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.902978563706729*^9, 3.9029785690044537`*^9}, {
  3.90298047482771*^9, 3.902980516916357*^9}, {3.903429228564789*^9, 
  3.903429260693396*^9}},
 CellLabel->"In[84]:=",ExpressionUUID->"d0141039-8549-44da-ab7e-e5d4ec37fde0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      SubsuperscriptBox["T", "1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SubscriptBox["T", "1"]}], " ", 
           SubscriptBox["\[Kappa]", "t"]}], "-", 
          RowBox[{"L", " ", 
           SubscriptBox["\[Kappa]", "x"]}]}]], "-", 
        RowBox[{
         SubscriptBox["T", "1"], " ", 
         SubscriptBox["\[Kappa]", "t"]}], "-", 
        RowBox[{"L", " ", 
         SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SubscriptBox["T", "1"], " ", 
         SubscriptBox["\[Kappa]", "t"]}], "+", 
        RowBox[{"L", " ", 
         SubscriptBox["\[Kappa]", "x"]}]}], ")"}], "2"]]}], ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      SubsuperscriptBox["T", "1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SubscriptBox["T", "1"]}], " ", 
           SubscriptBox["\[Kappa]", "t"]}], "-", 
          RowBox[{"L", " ", 
           SubscriptBox["\[Kappa]", "x"]}]}]], "-", 
        RowBox[{
         SubscriptBox["T", "1"], " ", 
         SubscriptBox["\[Kappa]", "t"]}], "-", 
        RowBox[{"L", " ", 
         SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SubscriptBox["T", "1"], " ", 
         SubscriptBox["\[Kappa]", "t"]}], "+", 
        RowBox[{"L", " ", 
         SubscriptBox["\[Kappa]", "x"]}]}], ")"}], "2"]]}], ",", "0"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.902978569318769*^9, 3.902979280758643*^9, 3.902979652350972*^9, {
   3.902980491524047*^9, 3.9029805172468033`*^9}, {3.9034292417457933`*^9, 
   3.9034292609540596`*^9}, 3.905056697932103*^9},
 CellLabel->"Out[84]=",ExpressionUUID->"adc32ac3-1e49-4aaa-98e2-c19a7a9e991b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "P1", ",", "P2", ",", "P3", ",", "P4", ",", "C1", ",", "C2", ",", "C3", 
     ",", "C4"}], "}"}], "/.", 
   RowBox[{
    SubscriptBox["T", "1"], "->", "0"}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.902980502716878*^9, 3.902980533644367*^9}, {
  3.90342924011679*^9, 3.9034292676301117`*^9}},
 CellLabel->"In[85]:=",ExpressionUUID->"0fb4257a-3e37-400c-bdd2-558872a5cbd7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", 
          SubscriptBox["T", "0"]}], " ", 
         SubscriptBox["\[Kappa]", "t"]}]], "+", 
       RowBox[{
        SubscriptBox["T", "0"], " ", 
        SubscriptBox["\[Kappa]", "t"]}]}], ")"}]}], 
    SubsuperscriptBox["\[Kappa]", "t", "2"]], ",", "0", ",", "0", ",", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["T", "0"]}], " ", 
        SubscriptBox["\[Kappa]", "t"]}], "-", 
       RowBox[{"L", " ", 
        SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         SubscriptBox["T", "0"], " ", 
         SubscriptBox["\[Kappa]", "t"]}]], "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          SubscriptBox["T", "0"], " ", 
          SubscriptBox["\[Kappa]", "t"]}]], " ", 
        SubscriptBox["T", "0"], " ", 
        SubscriptBox["\[Kappa]", "t"]}]}], ")"}]}], 
    SubsuperscriptBox["\[Kappa]", "t", "2"]], ",", "0", ",", "0", ",", "0"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.902980527242468*^9, 3.9029805339304857`*^9}, {
   3.903429242632124*^9, 3.9034292682201033`*^9}, 3.90505669794709*^9},
 CellLabel->"Out[85]=",ExpressionUUID->"318457b1-e3c1-42b6-8ea8-a9d3a3a65be5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"F2", "/.", 
    RowBox[{
     SubscriptBox["T", "0"], "->", "0"}]}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellChangeTimes->{{3.902980245614594*^9, 3.902980271045856*^9}},
 CellLabel->"In[86]:=",ExpressionUUID->"3704631b-3991-464f-ace4-c07713ec0c8d"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.902980249271674*^9, 3.9029802713713703`*^9}, 
   3.9034355621230335`*^9, 3.905056697975204*^9},
 CellLabel->"Out[86]=",ExpressionUUID->"16ea9730-dcf3-4be8-9e9b-078e785326c6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"P1", "==", 
     RowBox[{"C3", "'"}]}], ")"}], "/.", 
   RowBox[{
    SubscriptBox["T", "0"], "->", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.902978326982562*^9, 3.902978382445828*^9}, {
  3.9029784170495777`*^9, 3.902978417893565*^9}, {3.902978936403459*^9, 
  3.902978978055092*^9}, {3.902979663035881*^9, 3.902979667885976*^9}},
 CellLabel->"In[87]:=",ExpressionUUID->"d8895f1d-c0aa-4d33-b61a-9eaa5f7cf37b"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.902978344489253*^9, 3.902978418156744*^9}, 
   3.902978933610105*^9, 3.902978978414792*^9, 3.902979015168021*^9, 
   3.902979285373143*^9, {3.902979656672183*^9, 3.9029796681876497`*^9}, 
   3.905056697986642*^9},
 CellLabel->"Out[87]=",ExpressionUUID->"3b629a16-8eed-4d61-9986-65965e61e529"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numerical Integration Verification", "Section",
 CellChangeTimes->{{3.9034171583282595`*^9, 3.90341716754362*^9}, {
  3.905056592433509*^9, 
  3.905056593931197*^9}},ExpressionUUID->"a43bc5d9-4068-4c5e-a210-\
01162bc20220"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x1", "[", "t_", "]"}], ":=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"t", "<=", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         FractionBox["L", 
          SubscriptBox["T", "1"]], "t"}], ",", 
        RowBox[{"0", "<", "t", "<=", 
         SubscriptBox["T", "1"]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"L", ",", 
        RowBox[{"t", ">", 
         SubscriptBox["T", "1"]}]}], "}"}]}], "}"}], "]"}]}], ";"}]], "Input",\

 CellChangeTimes->{{3.9034171687477117`*^9, 3.903417282336215*^9}, {
   3.9034176664561996`*^9, 3.9034176716314583`*^9}, 3.9034179428076897`*^9, {
   3.903417980383122*^9, 3.9034179804311085`*^9}},
 CellLabel->"In[88]:=",ExpressionUUID->"5f3a8e0b-aae1-4a3a-9e4b-806a58a02f93"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x2", "[", "t_", "]"}], ":=", 
  RowBox[{"Piecewise", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"t", "<=", 
        SubscriptBox["T", "0"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        FractionBox["L", 
         SubscriptBox["T", "1"]], 
        RowBox[{"(", 
         RowBox[{"t", "-", 
          SubscriptBox["T", "0"]}], ")"}]}], ",", 
       RowBox[{
        SubscriptBox["T", "0"], "<", "t", "<=", 
        RowBox[{
         SubscriptBox["T", "1"], "+", 
         SubscriptBox["T", "0"]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"L", ",", 
       RowBox[{"t", ">", 
        RowBox[{
         SubscriptBox["T", "1"], "+", 
         SubscriptBox["T", "0"]}]}]}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellChangeTimes->{3.90341789440843*^9, 3.903417939344181*^9},
 CellLabel->"In[89]:=",ExpressionUUID->"5c55761c-ba9e-4032-862f-f5339cfdc601"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x3", "[", "t_", "]"}], ":=", 
   RowBox[{"x1", "[", 
    RowBox[{"t", "-", 
     SubscriptBox["T", "0"]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.903417284401464*^9, 3.9034173149603577`*^9}, {
  3.9034176636398106`*^9, 3.903417686472376*^9}, {3.903417870751296*^9, 
  3.90341789953535*^9}},
 CellLabel->"In[90]:=",ExpressionUUID->"66b50f2d-e065-47c4-9d35-6926912184ed"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x2", "[", "t", "]"}], "==", 
   RowBox[{"x3", "[", "t", "]"}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.903417951736164*^9, 3.903417959484564*^9}},
 CellLabel->"In[91]:=",ExpressionUUID->"682028e7-e151-4614-97d7-a57c04dfad82"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.9034179568335676`*^9, 3.9034179843631086`*^9}, 
   3.903427949910159*^9, 3.9035151728262167`*^9, 3.905057552199201*^9},
 CellLabel->"Out[91]=",ExpressionUUID->"94892163-78c9-4269-bf5e-638cad973b56"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"range", "=", 
   RowBox[{"Range", "[", 
    RowBox[{"1", ",", "5", ",", "0.2"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.903418277344653*^9, 3.9034182839755306`*^9}},
 CellLabel->"In[92]:=",ExpressionUUID->"1ed3711f-9fb1-4ca7-833a-24deef73fb86"],

Cell[BoxData[
 RowBox[{
  RowBox[{"param", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Kappa]", "t"], "->", "1"}], ",", 
     RowBox[{
      SubscriptBox["\[Kappa]", "x"], "->", "1"}], ",", 
     RowBox[{
      SubscriptBox["T", "1"], "->", "1.2"}], ",", 
     RowBox[{
      SubscriptBox["T", "0"], "->", "5"}], ",", 
     RowBox[{"L", "->", "l"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.903418407574685*^9, {3.9034186993262253`*^9, 3.9034186996859484`*^9}},
 CellLabel->"In[93]:=",ExpressionUUID->"65c0ce6a-2934-417e-a1f1-bab50ab2e273"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["\[Kappa]", "t"]}], 
          RowBox[{"Abs", "[", 
           RowBox[{"t1", "-", "t2"}], "]"}]}], "-", 
         RowBox[{
          SubscriptBox["\[Kappa]", "x"], 
          RowBox[{"Abs", "[", 
           RowBox[{
            RowBox[{"x1", "[", "t1", "]"}], "-", 
            RowBox[{"x2", "[", "t2", "]"}]}], "]"}]}]}], "]"}], "/.", 
       "param"}], ",", 
      RowBox[{"{", 
       RowBox[{"t1", ",", "0", ",", 
        RowBox[{
         RowBox[{
          SubscriptBox["T", "1"], "+", 
          SubscriptBox["T", "0"]}], "/.", "param"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t2", ",", "0", ",", 
        RowBox[{
         RowBox[{
          SubscriptBox["T", "1"], "+", 
          SubscriptBox["T", "0"]}], "/.", "param"}]}], "}"}]}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"l", ",", "range"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9034174620018663`*^9, 3.9034175436569557`*^9}, {
  3.9034175795525455`*^9, 3.9034175806962123`*^9}, {3.9034176569756346`*^9, 
  3.903417659919609*^9}, {3.9034177233355255`*^9, 3.90341773041562*^9}, {
  3.9034178045356274`*^9, 3.9034178163914824`*^9}, {3.903418121311185*^9, 
  3.9034181219830446`*^9}, {3.903418238766989*^9, 3.9034183178305387`*^9}, {
  3.903418403887656*^9, 3.9034184053264284`*^9}, {3.903418495471188*^9, 
  3.903418521447481*^9}},
 CellLabel->"In[94]:=",ExpressionUUID->"484addf5-fd69-4484-8639-b590b1ffac43"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4.637317261570835`", ",", "3.9921217596711425`", ",", 
   "3.4524761587973907`", ",", "3.000249253559689`", ",", 
   "2.6204902514820674`", ",", "2.300864848687227`", ",", 
   "2.031191906604482`", ",", "1.8030627420767953`", ",", 
   "1.6095282126452217`", ",", "1.444841514111502`", ",", 
   "1.304246596354825`", ",", "1.1838043465976436`", ",", 
   "1.0802493528526942`", ",", "0.990872206409106`", ",", 
   "0.9134225544219685`", ",", "0.8460292809970659`", ",", 
   "0.7871347627086763`", ",", "0.7354406936491652`", ",", 
   "0.6898634257126977`", ",", "0.6494971515634405`", ",", 
   "0.6135834560145454`"}], "}"}]], "Output",
 CellChangeTimes->{{3.903418269152032*^9, 3.9034183200372405`*^9}, 
   3.903418410804765*^9, 3.9034185235738945`*^9, 3.903418706187391*^9, 
   3.9034272137197504`*^9, 3.903515227362362*^9, 3.905057553084709*^9},
 CellLabel->"Out[94]=",ExpressionUUID->"3a3056fa-580d-4333-88ef-79fa3afa94dc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"range", ",", "f"}], "}"}], "\[Transpose]"}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"C1", "+", "C2", "+", "C3", "+", "C4"}], ")"}], "/.", 
       "param"}], "//", "N"}], ",", 
     RowBox[{"{", 
      RowBox[{"l", ",", "1", ",", "5"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9034182979846115`*^9, 3.9034184144065886`*^9}},
 CellLabel->"In[95]:=",ExpressionUUID->"a4770e8f-b5f7-46e5-aebf-015647d6f039"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQBWIQDQEf7L/X5j2d0yPkYAwGn+35G6o77r7nd0gDg2/2
ppxMl1bP43aYNRMEftqrSNqva2LgcDh7BgT+2DdcPDP98DcWB6iBDkmsuVe0
M5ig6hkdeBSvdT20Z3AwAZvP7HBjY2xgxM0/9hD9LA6S57csX3Dgpz3EPjYH
B8MNSkJy3+0hxnE45JhdWWt474s9xDxOB8F/0y/f+fDJHmIet8PUggXdmz0+
Qs3jcXgXrbjQcut7+3SweXwOHyqvvj9o9RZqnoDD0eer/q8Weg1VL+DQK/PG
1tTgJdR8QYf3d16/3tXxHOoeIYd7/S1lMcLPoPYJO8x6I+mw7sQTqHkiDg7x
845WLnpsDwBwipIn
      "]]}, {{}, {}}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwVk3k4lAkcx4cJY5zzviE2LB3bYTKK3Wfp8ftRTSqEiGzmcXSQNmX3adpo
HZOjg5RjbYemlEplkqNiiC4dGkm7jtS2vdMYR+YlRo6ys398n+8/n+fzPN8/
vnaRcQFbtRkMho8m//fLhl4zBoMGT9m11tNHCTyu2y3U1aFhy6tFfY6ZBPp5
yzoN2TTstd+84oGIQFn7zTOWM2nIbw+tpvcT+GQwYd6yBTRkPhDkhcQQ2DDb
2GWbHw0jETlvovgElu1bGtgspsGdP05s0yLwEC/hRKHHECRap3TOSOCgw+IR
M/eiYVA6x0bv3G6KFOT0P6Y+QY+0bUEdbYzr8twmaPtROJCxX3rPzQjFv8hM
5h9Qw2zzpFc3Ug2Q9fNBITaMQZTSVruWycawITvFdptxsBKfaDqbwsItVbIs
h70T0DxXh1Fsp4e/5xZl/F09CdzU4u/LVTqYNhWUmUV8Aa8SNTerZgaeTeK9
Xhj8Ff7wB/XF60yM9bTaHpU/DenLk7iLbmkj5/HoVKCQgYUl+haH6rRwbDJO
tWOWFvq8axTYyRm4YTRsq16TFl7r/al+PouBmdltwvh4bdzV7XFDduArNFWG
LvMjmJjROjD51OYLJIqD4ivvMvFwv9+/tTWT4GYZGXokYgZOMYQfe0QTsDv4
/UOlqQ6KOYkB7V7j8LtL3/OZdTr4UVql6v/uMxSImUkVYbpYw3cY8V08BnNb
cyo6DPQwkIxceGyRGqTZjsd3l+lhfIlNcsuaUeAOBBm0+7CQVcRyz9w/AjNN
aNaDCRauMHcq5V/6BDp3T0nmnNbHmOjza1mDw7DTubZTfx0bN9qv/zPAaRiu
rYkU16vZWBG56li0aAjU/VamigIDrN/hv0/cR0P1htXMvJWGuNR747k0XxqS
vdLOVioMcVsSDoQfVoH9m7UdxWlGqKuOEj07MghuPxzMs1xqjOEiThyV/hHC
bFrGtdqM0d1KUqsUD4D6adb73SkmaHzlSDS/qh+8tR1dFxKmWHYn+6b7hz5g
q0L9tSJN0eq2AGRz+kBUj6Wnb5viEsrj+dTmXkgJlATv0eegVOFQPeu6Elyf
t/P1Izho8mI6IuhzD/xjtvIg6xYHa7Z4c7h+PaA/70dzDz0CfROEsRa1Chg0
V/YuFxCYfKh8SYSdAkJabIl4CYEKv0cP3xR+AEnwqUzjac1PjFx9HC0/QOO9
F7griEQuL+6ZTb4cQkayffRKSCwj2m0LbOXwSObJi7tE4kh63Zp8azk4X1ET
7ZdJHC4/3pX3jRxMBIKOkqskHlXn8vItNHwTN4pfTqLTubHSkyZycDnVvC9N
qvHlEo23pykgPNkXmG0kFn7LrsB3FCTPrk+PfUUiro9J835LwaB6T0zbXyRe
POldG9JNwZOrnUuKO0isTHH2j+/Q8GZX7ni+JTHcqci+9AUFKuXqlpReEh++
LVzp0EjB5vuT5b19JHoZNni636Xg6RlJnv8Aid2qe+f96igoCbAItVORSHcN
Z+y9Q4FAqpA3jJCYamQjf1ROQXPByaYFahLnJq8afC2hwHWPb2nOGIm/Jgo3
DV2nwGx+dVz4hGYPmRtgXUpBKmNHwONJEp3ve71bdpkCusvahfeFxNJ552Rr
SzT+qlaLwq8k8jalWkde0PiPpU1MT5PYJXrZ/Nt5Cv4Dv6w/bQ==
        "]]},
      Annotation[#, "Charting`Private`Tag$626421#1"]& ]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.916666666666669, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0.916666666666669, 5.}, {0, 4.637317261570835}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.9034183204836187`*^9, 3.903418335629572*^9}, 
   3.90341841519289*^9, 3.903418524295212*^9, 3.903418707006283*^9, 
   3.9034272138135543`*^9, 3.905057553169504*^9},
 CellLabel->"Out[95]=",ExpressionUUID->"b38c5b6e-ed64-4f0e-8e70-f3ad424631ea"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"param", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Kappa]", "t"], "->", "1"}], ",", 
     RowBox[{
      SubscriptBox["\[Kappa]", "x"], "->", "1"}], ",", 
     RowBox[{
      SubscriptBox["T", "1"], "->", "5"}], ",", 
     RowBox[{
      SubscriptBox["T", "0"], "->", "1"}], ",", 
     RowBox[{"L", "->", "l"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.903418146446859*^9, 3.9034181467990303`*^9}, {
  3.9034185519502106`*^9, 3.9034185520857053`*^9}, {3.9034186292940536`*^9, 
  3.9034186392141724`*^9}},
 CellLabel->"In[96]:=",ExpressionUUID->"6c551852-e8be-4f7d-8d98-797a6635cbd0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SubscriptBox["\[Kappa]", "t"]}], 
           RowBox[{"Abs", "[", 
            RowBox[{"t1", "-", "t2"}], "]"}]}], "-", 
          RowBox[{
           SubscriptBox["\[Kappa]", "x"], 
           RowBox[{"Abs", "[", 
            RowBox[{
             RowBox[{"x1", "[", "t1", "]"}], "-", 
             RowBox[{"x2", "[", "t2", "]"}]}], "]"}]}]}], "]"}], "/.", 
        "param"}], ",", 
       RowBox[{"{", 
        RowBox[{"t1", ",", "0", ",", 
         RowBox[{
          RowBox[{
           SubscriptBox["T", "1"], "+", 
           SubscriptBox["T", "0"]}], "/.", "param"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t2", ",", "0", ",", 
         RowBox[{
          RowBox[{
           SubscriptBox["T", "1"], "+", 
           SubscriptBox["T", "0"]}], "/.", "param"}]}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"l", ",", "range"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9034174620018663`*^9, 3.9034175436569557`*^9}, {
   3.9034175795525455`*^9, 3.9034175806962123`*^9}, {3.9034176569756346`*^9, 
   3.903417659919609*^9}, {3.9034177233355255`*^9, 3.90341773041562*^9}, {
   3.9034178045356274`*^9, 3.9034178163914824`*^9}, {3.903418121311185*^9, 
   3.9034181219830446`*^9}, {3.903418238766989*^9, 3.9034183178305387`*^9}, {
   3.903418403887656*^9, 3.9034184053264284`*^9}, {3.903418484086316*^9, 
   3.903418488334557*^9}, 3.9034185294559965`*^9, 3.903427285185275*^9},
 CellLabel->"In[97]:=",ExpressionUUID->"54e7c521-e2f9-4464-a0be-d0bc90c8f830"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"range", ",", "f"}], "}"}], "\[Transpose]"}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"C1", "'"}], "+", 
         RowBox[{"C2", "'"}], "+", 
         RowBox[{"C3", "'"}], "+", 
         RowBox[{"C4", "'"}]}], ")"}], "/.", "param"}], "//", "N"}], ",", 
     RowBox[{"{", 
      RowBox[{"l", ",", "1", ",", "5.1"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9034182979846115`*^9, 3.9034184144065886`*^9}, {
  3.90341854434998*^9, 3.903418565223068*^9}, {3.9034186784466066`*^9, 
  3.903418683333892*^9}},
 CellLabel->"In[98]:=",ExpressionUUID->"9eed5a6b-8e7f-418c-b312-cb75311d5d59"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQBWIQDQEf7PdPONvR5KLgYAwGn+3frTY/VOYr75AGBt/s
7/Cfls9QkXOYNRMEftpPeDVzYT6PrMPZMyDwx17q0j9rVxYZB6iBDtJTPc/u
45KGqmd0YAwL/nhGTsrBBGw+s0ONXrFlhb0kVD+Lw0FnsW33siWg9rE59LFN
PW64WBxqHofDxapY0y1PxKDmcTr81/9RuENfDGoet8OdY+mi85tFoebxOOzb
/Lb96n0Rh3SweXwOis8aTl5xFoGaJ+DAXCYfo7BeGKpewGGKgnCAq6Iw1HxB
h/vC3qk3ZwpB3SPkUO2437VKQghqn7BD9u2Jl87MEYSaJ+IwI72+pUZN0AEA
aECAxg==
      "]]}, {{}, {}}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwV0ns0lHkcBvBBQ8btfWd+gzDNOyWJSi5JyPtI0mVdW5ec9tCNOEpb62BX
cUjXo91Od9nSuNVKumBD2qFal1UiKwchmyktGkTudvaP73nO57/nPOcr2RXt
t1eVw+F4Ku//dJmL0edwFOyMvD8leQOD8uOuN824CtZOcuhpghsDB12d5Z48
BSu/+skkdj0DW1G2azpRsPuz80RRYGDu1BRlt0zB/ls/7B/ozICOXfl0n5+C
9S1svm5jx+D9oDy6MVvBepwT/Ti9mMGZzsBa6eYh1rbf9VqHGgOteM+subvD
7J6Ew52GiWLw2w8PFUyPsOMP8yueqIphla+f/sptlBX5GJXIzixEov2LiILc
MXZw5OrTFp2FCDhVVNA+9JX1/RCvYXdNhNDLhYbPgibYiPuzsZxFIiQKlnYy
pZNsG6e7aLLABGaBDQYNKtNsbZgN47fBBHP+Z+LWhM2w5jc2/hrTbIxQkzjP
oQezbNnmPK/EA8Zo8XmXIJ6YY+MDt9vXaBsDTGFfSgEHKv3CYuscI7ROcRsy
/VTgkd7xUbbRCJrF8up0rio+N/VcLO1ZAPcc7qBXsSpeZFG3m5KVnnB+abld
DekH09JCLBeg02K2spc3D7zJe3E3XxrCSfYmuubePNg+j8mYjjeEta2T9ck9
XFxS6B75hjGEzdsOsapQHZ0p1B/OdQb4+ulSTXapOi5OPXtd8JMB/FvajplG
acCh9JYkwNwAsUvWTNXz5yO4aFOadYc+svMbr1uVzAcZCT5Pn9dHpN6Yf3S4
JtriOGf3uutjpMWm+o02D7FEy2//rBD6CRNbRTIeHLs2dZk8FGJD0OyMyUEt
JHiNesgihVh9xTjSnWhjgWlhaaa5ELLiqr4tf2qj6tU6WUgPge6a5MXxUTr4
1kx9pVhKEP458fROPV1csAhRBO0hCE7V4C6V6cL5yr1DWYsIqMS8tcK9etCn
JTgtF2BV/kcotCgIqk+F3MkVoKxGc31kCIUcl1T56igBalXqtrvep3C8Kmnf
V1sBcpZ5T6nzaPRWWo4w43zsTume6N5Bo73T1iO4ko/Bv+yTb5fQoEPXHZOc
4GPWarmkQZcP8wttBw28+VA8XyHS3MnHP46t9XXGfBRu+SK1LuND18HiiV0v
DW+V6tQDOgKwIbIZ64c0Yl47JM4PESCqdyJJM4VG+IVo1XO/C7CsvXL8sTcN
pxMPelbwCGYsTyZUMDQedf/27LoWgY3UPnlATMPeMStXT4fA0p+9IlJ61cD5
yCE9Ao7Ud/SIiIbZtpjhIiEBjxtwmDWiwRc7qDpLCLbuDDjyXECjr6RCssWB
wG6le8VbdRphVIla+VqCk0cr6vSUfh9xt9fSiaCRDvroyqXRaXLjto4LgTEz
sC1XjUZzcpJ1oxvBvEfh/dEcGjIvN9cgbwKvrUsk6pMUXG45La71ISBfxqzW
TlAoV7HjOvoRlPc1eEWNUygpMq019ifImPjlcdMYhTtG6r5dwQTu9UxQ5ggF
ix9mbXx2ELxrmZG/HqaQ92KMVH5HsKKmOVVDaWnSh1ZpKMHfdyJGDigoiNu6
ygS7CNI3mVZJP1PIsG3NOLZbuceipsyWQQpGaa+Ojir/5lrq9z/zlL4srwkN
C1P2qeWcdRmg8B85TQOU
        "]]},
      Annotation[#, "Charting`Private`Tag$631171#1"]& ]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.916666666666669, 4.0739052592465},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0.916666666666669, 5.}, {4.0739052592465, 8.133808398335871}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.9034183204836187`*^9, 3.903418335629572*^9}, 
   3.90341841519289*^9, {3.9034185475332575`*^9, 3.9034185684859033`*^9}, {
   3.9034186001153965`*^9, 3.90341864444951*^9}, {3.9034186813392997`*^9, 
   3.903418683726962*^9}, 3.9034272180234303`*^9, 3.905057554142255*^9},
 CellLabel->"Out[98]=",ExpressionUUID->"3d0781d6-ba38-4243-a7f9-e1314802c79c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"param", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Kappa]", "t"], "->", "1"}], ",", 
     RowBox[{
      SubscriptBox["\[Kappa]", "x"], "->", "1"}], ",", 
     RowBox[{
      SubscriptBox["T", "1"], "->", "5"}], ",", 
     RowBox[{
      SubscriptBox["T", "0"], "->", "1"}], ",", 
     RowBox[{"L", "->", "l"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[99]:=",ExpressionUUID->"f6c5b51c-b33c-4203-833a-1f37b63700fc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"NIntegrate", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SubscriptBox["\[Kappa]", "t"]}], 
           RowBox[{"Abs", "[", 
            RowBox[{"t1", "-", "t2"}], "]"}]}], "-", 
          RowBox[{
           SubscriptBox["\[Kappa]", "x"], 
           RowBox[{"Abs", "[", 
            RowBox[{
             RowBox[{"x1", "[", "t1", "]"}], "-", 
             RowBox[{"x1", "[", "t2", "]"}]}], "]"}]}]}], "]"}], 
        "\[IndentingNewLine]", "/.", "param"}], ",", 
       RowBox[{"{", 
        RowBox[{"t1", ",", "0", ",", 
         RowBox[{
          RowBox[{
           SubscriptBox["T", "1"], "+", 
           SubscriptBox["T", "0"]}], "/.", "param"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t2", ",", "0", ",", 
         RowBox[{
          RowBox[{
           SubscriptBox["T", "1"], "+", 
           SubscriptBox["T", "0"]}], "/.", "param"}]}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"l", ",", "range"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.903418847189885*^9, 3.9034189511987276`*^9}, {
   3.903419000759691*^9, 3.903419026271442*^9}, 3.9034192417921467`*^9, {
   3.9034270022909284`*^9, 3.9034270052576513`*^9}, 3.90342704268262*^9, {
   3.9034271079304724`*^9, 3.9034271217050395`*^9}},
 CellLabel->
  "In[100]:=",ExpressionUUID->"32c6f5ea-a416-4072-a7f4-20ce3f6b4b5c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"range", ",", "f"}], "}"}], "\[Transpose]"}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"P1", "+", "P2", "+", "P3", "+", "P4"}], ")"}], "/.", 
      "param"}], ",", 
     RowBox[{"{", 
      RowBox[{"l", ",", "1", ",", "5"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9034190576625614`*^9, 3.9034190851833897`*^9}, {
   3.9034191184454455`*^9, 3.9034191375414543`*^9}, {3.903419248389983*^9, 
   3.903419263765048*^9}, {3.9034193022136526`*^9, 3.9034193044371786`*^9}, 
   3.903426757433627*^9, {3.9034269644168406`*^9, 3.9034269653527126`*^9}, {
   3.903427059968589*^9, 3.903427062288601*^9}, {3.9034272394242744`*^9, 
   3.9034272597925124`*^9}, 3.903428888046674*^9},
 CellLabel->
  "In[101]:=",ExpressionUUID->"15f5dfea-e348-488d-b014-670a219ab6bd"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQBWIQDQEf7OOzT2ZIVig6GIPBZ3uOh867BbkUHdLA4Ju9
+w+13FkLFRxmzQSBn/b1lRFhfnYKDmfPgMAfe/fUu5WL9ss7QA10mBZWcnUu
tzxUPaPDvAMRu77EyzmYgM1ndphzWERGao8sVD+Lw7uFyXN65GWh9rE5mHyf
kn21UwZqHofD/7YDDu2/pKHmcTr0XNhbaVsoDTWP2+H4oiT32W+loObxODSd
KPvolS/lkA42j8/hSd5Hi79fJaHmCTjsT9c+mNEoCVUv4HBrbWenp6Ak1HxB
B8FVk0sTlkpA3SPkcGK69aMiWwmofcIOZ4JKXLxuikPNE3E4UN99YXOFuAMA
+n+GKQ==
      "]]}, {{}, {}}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwVzHs0lAkABfAx8phhDfPhmxnMGNHJ2R4ejVra/a5JlKgUKzY209pRaT1q
o9KDzKaWkpX0UFNJaLdZK6pdSeWdRqKwPVfI62S8xjaSnf3jnnt+59xzhZKY
dZF0Go3mr83//aSq34JGU1HqFzmR3EQhTui/SNDXU1GBV6JMohKEWOun7DRm
qqjMi7Ta8l1CKNv/yOOaq6h/5yVFBP4oRMP7vQ6uc1VUUkTsysx4IaqsTUTf
r1VRl36rfs7cLsT1RJfAJrmK6hntmWZKhDjitDcr13OEWuK8oN3NT4h5n49b
fHV+lCrWFCcW2AjxlsocrH87Rvnk9zhxxmyxKttDo7KboF6tLoxza7SFfIeS
NWefmtqy9J1V3XlbGG5PTUDVJMUcc8xnJ9gibETYK+V/oOg7u32H/GzxXZky
Y94uDZW+PKJNam+L/b+cP/ysfIrKC/WPvfVJANnHoLQM9jS13mPTlkmFABcO
OD13DP5E9USWKLulAmwT86SbT85QJ6YU5HE7AczqJz4GJtDQ0lKTW93Bx+RU
zPBWjg4CjDTu7if5WD8RFmlQp4PkELOvo/z5SDvWmhAfT0fYvUa35YZ81N0I
dV3L1gWDmAyaqrdBkjwo/sZdXRx5xFGdltnAgysJ/TliFhz+6fN56WOD2OCu
mj5TPSgjnUXO+jbYLxp4ZH5HD00vZo8O1lojR657oDRMHzvpavVIujXsWzJL
O4wMkMOSh7uusUbFsYUnYq8bIKTt1DdZltaYPxRk1O5viOjeI1kfX1vBnKUy
rNYYou1efErDFSvo3T2rmH2OAY87fi5RsVaIXvRXJ2MVE9dEln1HF1vh15US
eaWaCWnv1Q0lNCuoB3mmvTlGePBmxwKJkofy9T662V7GcOn1nvkzl4eDK2QX
bvQaQ1ahuLVbyoPdS9+Oy7LPYM+pZo0t5sFjcWo218UExx0MD4n0eAjjN3/Q
aTWBpDPtlfwZF+rGjK7YZBbauQGeI/lc+NEXujuyTQHnlBW+CVwwh0MDdCSm
8DZ/+LvbKi4OVaL43C1TNIeUGs2x5iI5UBEcxzDDy1HjwXcqDtwftXszIsxw
+krKQM19Dl5beKUa3jSDrDLkW9ccDhgOX1h6GrAxLA1gYDsH7y37+peGs9Gw
J1+a6snBhmYBO17BxhC/pdSfy4Ei+GyayQwblLirOW6UxL37j/FDEAExJ8ju
XT2JDePH/A0KCAgvFdHLLpGoVYqdYq4S2JiVqTDSelGRmt1eSKAiwFEquUiC
FR7eUXCNAAPRapZcu6+bv9m7hMAZldXJbXkkRGebEmUVWpcte2KfS4ItZubr
thJwffjA60IGiYPWlT9tayOgMza5fDKdxHt13JbWpwQEbpUBa7RuuNa54HIH
gdeC6bSZo9q9RdFt8SsCS3Qdd21KIzHc59Oc3E9gVlKYr/0hEhsfTJX0DxAo
vPrleFIKicY8RXbAEIFasbzwaTKJgnVkqHCYwO03fU6HD5IIr+jtrhonEBcf
fXdgH4mmnDN1c9UEfB573VmmtXvc6uLMSQK81lM155JIWMwpj9mkIXCzu2hi
9V4SKbSt6+qnCKykS20K95BQ/W0jcpomEN11Zo2O1uFlLWTuJwIt6V7pobu1
/8dlmpkZAisYm1tLE0n8B82AFt4=
        "]]},
      Annotation[#, "Charting`Private`Tag$634539#1"]& ]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.916666666666669, 5.7086125817397155`},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{338., Automatic},
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0.916666666666669, 5.}, {5.7086125817397155`, 
   8.734568857753116}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.903419137782301*^9, {3.9034192213678923`*^9, 3.9034192643441133`*^9}, {
   3.9034193026230125`*^9, 3.903419304793615*^9}, {3.9034269495678005`*^9, 
   3.9034269658296423`*^9}, {3.9034270604169555`*^9, 
   3.9034270626576195`*^9}, {3.9034272601383147`*^9, 3.903427268898287*^9}, 
   3.903428888645564*^9, 3.905057554885303*^9},
 CellLabel->
  "Out[101]=",ExpressionUUID->"93d67e53-c490-407e-a6bb-7771cf79ab15"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"NIntegrate", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SubscriptBox["\[Kappa]", "t"]}], 
           RowBox[{"Abs", "[", 
            RowBox[{"t1", "-", "t2"}], "]"}]}], "-", 
          RowBox[{
           SubscriptBox["\[Kappa]", "x"], 
           RowBox[{"Abs", "[", 
            RowBox[{
             RowBox[{"x2", "[", "t1", "]"}], "-", 
             RowBox[{"x2", "[", "t2", "]"}]}], "]"}]}]}], "]"}], 
        "\[IndentingNewLine]", "/.", "param"}], ",", 
       RowBox[{"{", 
        RowBox[{"t1", ",", "0", ",", 
         RowBox[{
          RowBox[{
           SubscriptBox["T", "1"], "+", 
           SubscriptBox["T", "0"]}], "/.", "param"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t2", ",", "0", ",", 
         RowBox[{
          RowBox[{
           SubscriptBox["T", "1"], "+", 
           SubscriptBox["T", "0"]}], "/.", "param"}]}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"l", ",", "range"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.903418847189885*^9, 3.9034189511987276`*^9}, {
   3.903419000759691*^9, 3.903419026271442*^9}, 3.9034192417921467`*^9, {
   3.9034270022909284`*^9, 3.9034270052576513`*^9}, 3.90342704268262*^9, {
   3.9034271079304724`*^9, 3.9034271217050395`*^9}, {3.903427314865018*^9, 
   3.903427316712405*^9}, {3.903427801544067*^9, 3.9034278070155535`*^9}},
 CellLabel->
  "In[102]:=",ExpressionUUID->"fd518bd4-2095-420b-ac7e-75b27c35190a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"range", ",", "f"}], "}"}], "\[Transpose]"}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"P1", "+", "P2", "+", "P3", "+", "P4"}], ")"}], "/.", 
      "param"}], ",", 
     RowBox[{"{", 
      RowBox[{"l", ",", "1", ",", "5"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9034190576625614`*^9, 3.9034190851833897`*^9}, {
   3.9034191184454455`*^9, 3.9034191375414543`*^9}, {3.903419248389983*^9, 
   3.903419263765048*^9}, {3.9034193022136526`*^9, 3.9034193044371786`*^9}, 
   3.903426757433627*^9, {3.9034269644168406`*^9, 3.9034269653527126`*^9}, {
   3.903427059968589*^9, 3.903427062288601*^9}, {3.9034272394242744`*^9, 
   3.9034272765683885`*^9}, {3.903427972543141*^9, 3.9034279874793625`*^9}, {
   3.9034288792298584`*^9, 3.9034288823656893`*^9}},
 CellLabel->
  "In[103]:=",ExpressionUUID->"aa8c3989-6420-48bf-88ba-2831b597296b"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQBWIQDQEf7COzT2ZIVig6GIPBZ3vWh867BbkUHdLA4Ju9
8w+13FkLFRxmzQSBn/aNlRFhfnYKDmfPgMAfe5/Uu5WL9ss7QA10mBZWcnUu
tzxUPaPDkgMRu77EyzmYgM1ndph3WERGao8sVD+Lw9eFyXN65GWh9rE52Hyf
kn21UwZqHofDj7YDDu2/pKHmcTp0XthbaVsoDTWP2+H8oiT32W+loObxODSd
KPvolS/lkA42j8/hXt5Hi79fJaHmCTjsTdc+mNEoCVUv4HBrbWenp6Ak1HxB
B8FVk0sTlkpA3SPkcHS69aMiWwmofcIO54NKXLxuikPNE3HYV999YXOFuAMA
/reGLg==
      "]]}, {{}, {}}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwVzHs0lAkABfAx8phhDfPhmxnMGNHJ2R4ejVra/a5JlKgUKzY209pRaT1q
o9KDzKaWkpX0UFNJaLdZK6pdSeWdRqKwPVfI62S8xjaSnf3jnnt+59xzhZKY
dZF0Go3mr83//aSq34JGU1HqFzmR3EQhTui/SNDXU1GBV6JMohKEWOun7DRm
qqjMi7Ta8l1CKNv/yOOaq6h/5yVFBP4oRMP7vQ6uc1VUUkTsysx4IaqsTUTf
r1VRl36rfs7cLsT1RJfAJrmK6hntmWZKhDjitDcr13OEWuK8oN3NT4h5n49b
fHV+lCrWFCcW2AjxlsocrH87Rvnk9zhxxmyxKttDo7KboF6tLoxza7SFfIeS
NWefmtqy9J1V3XlbGG5PTUDVJMUcc8xnJ9gibETYK+V/oOg7u32H/GzxXZky
Y94uDZW+PKJNam+L/b+cP/ysfIrKC/WPvfVJANnHoLQM9jS13mPTlkmFABcO
OD13DP5E9USWKLulAmwT86SbT85QJ6YU5HE7AczqJz4GJtDQ0lKTW93Bx+RU
zPBWjg4CjDTu7if5WD8RFmlQp4PkELOvo/z5SDvWmhAfT0fYvUa35YZ81N0I
dV3L1gWDmAyaqrdBkjwo/sZdXRx5xFGdltnAgysJ/TliFhz+6fN56WOD2OCu
mj5TPSgjnUXO+jbYLxp4ZH5HD00vZo8O1lojR657oDRMHzvpavVIujXsWzJL
O4wMkMOSh7uusUbFsYUnYq8bIKTt1DdZltaYPxRk1O5viOjeI1kfX1vBnKUy
rNYYou1efErDFSvo3T2rmH2OAY87fi5RsVaIXvRXJ2MVE9dEln1HF1vh15US
eaWaCWnv1Q0lNCuoB3mmvTlGePBmxwKJkofy9T662V7GcOn1nvkzl4eDK2QX
bvQaQ1ahuLVbyoPdS9+Oy7LPYM+pZo0t5sFjcWo218UExx0MD4n0eAjjN3/Q
aTWBpDPtlfwZF+rGjK7YZBbauQGeI/lc+NEXujuyTQHnlBW+CVwwh0MDdCSm
8DZ/+LvbKi4OVaL43C1TNIeUGs2x5iI5UBEcxzDDy1HjwXcqDtwftXszIsxw
+krKQM19Dl5beKUa3jSDrDLkW9ccDhgOX1h6GrAxLA1gYDsH7y37+peGs9Gw
J1+a6snBhmYBO17BxhC/pdSfy4Ei+GyayQwblLirOW6UxL37j/FDEAExJ8ju
XT2JDePH/A0KCAgvFdHLLpGoVYqdYq4S2JiVqTDSelGRmt1eSKAiwFEquUiC
FR7eUXCNAAPRapZcu6+bv9m7hMAZldXJbXkkRGebEmUVWpcte2KfS4ItZubr
thJwffjA60IGiYPWlT9tayOgMza5fDKdxHt13JbWpwQEbpUBa7RuuNa54HIH
gdeC6bSZo9q9RdFt8SsCS3Qdd21KIzHc59Oc3E9gVlKYr/0hEhsfTJX0DxAo
vPrleFIKicY8RXbAEIFasbzwaTKJgnVkqHCYwO03fU6HD5IIr+jtrhonEBcf
fXdgH4mmnDN1c9UEfB573VmmtXvc6uLMSQK81lM155JIWMwpj9mkIXCzu2hi
9V4SKbSt6+qnCKykS20K95BQ/W0jcpomEN11Zo2O1uFlLWTuJwIt6V7pobu1
/8dlmpkZAisYm1tLE0n8B82AFt4=
        "]]},
      Annotation[#, "Charting`Private`Tag$637542#1"]& ]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.916666666666669, 5.708612581739714},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{338., Automatic},
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0.916666666666669, 5.}, {5.708612581739714, 8.734568857753105}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.903419137782301*^9, {3.9034192213678923`*^9, 3.9034192643441133`*^9}, {
   3.9034193026230125`*^9, 3.903419304793615*^9}, {3.9034269495678005`*^9, 
   3.9034269658296423`*^9}, {3.9034270604169555`*^9, 
   3.9034270626576195`*^9}, {3.9034272601383147`*^9, 3.903427268898287*^9}, {
   3.903427320272977*^9, 3.9034273242608943`*^9}, 3.903427752249259*^9, {
   3.9034278032983913`*^9, 3.9034278086626873`*^9}, {3.9034279616723266`*^9, 
   3.903427993179208*^9}, 3.9034288828053694`*^9, 3.9050575555520887`*^9},
 CellLabel->
  "Out[103]=",ExpressionUUID->"49d3e221-3de8-4052-8786-9464bb9d2ed0"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"param", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Kappa]", "t"], "->", "1"}], ",", 
     RowBox[{
      SubscriptBox["\[Kappa]", "x"], "->", "1"}], ",", 
     RowBox[{
      SubscriptBox["T", "1"], "->", "5"}], ",", 
     RowBox[{
      SubscriptBox["T", "0"], "->", "1"}], ",", 
     RowBox[{"L", "->", "l"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->
  "In[104]:=",ExpressionUUID->"88f42f28-0732-479a-a1df-53f4f1b57969"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"NIntegrate", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SubscriptBox["\[Kappa]", "t"]}], 
            RowBox[{"Abs", "[", 
             RowBox[{"t1", "-", "t2"}], "]"}]}], "-", 
           RowBox[{
            SubscriptBox["\[Kappa]", "x"], 
            RowBox[{"Abs", "[", 
             RowBox[{
              RowBox[{"x1", "[", "t1", "]"}], "-", 
              RowBox[{"x1", "[", "t2", "]"}]}], "]"}]}]}], "]"}], "+", 
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SubscriptBox["\[Kappa]", "t"]}], 
            RowBox[{"Abs", "[", 
             RowBox[{"t1", "-", "t2"}], "]"}]}], "-", 
           RowBox[{
            SubscriptBox["\[Kappa]", "x"], 
            RowBox[{"Abs", "[", 
             RowBox[{
              RowBox[{"x2", "[", "t1", "]"}], "-", 
              RowBox[{"x2", "[", "t2", "]"}]}], "]"}]}]}], "]"}], "-", 
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SubscriptBox["\[Kappa]", "t"]}], 
            RowBox[{"Abs", "[", 
             RowBox[{"t1", "-", "t2"}], "]"}]}], "-", 
           RowBox[{
            SubscriptBox["\[Kappa]", "x"], 
            RowBox[{"Abs", "[", 
             RowBox[{
              RowBox[{"x1", "[", "t1", "]"}], "-", 
              RowBox[{"x2", "[", "t2", "]"}]}], "]"}]}]}], "]"}], "-", 
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SubscriptBox["\[Kappa]", "t"]}], 
            RowBox[{"Abs", "[", 
             RowBox[{"t1", "-", "t2"}], "]"}]}], "-", 
           RowBox[{
            SubscriptBox["\[Kappa]", "x"], 
            RowBox[{"Abs", "[", 
             RowBox[{
              RowBox[{"x2", "[", "t1", "]"}], "-", 
              RowBox[{"x1", "[", "t2", "]"}]}], "]"}]}]}], "]"}]}], 
        "\[IndentingNewLine]", "/.", "param"}], ",", 
       RowBox[{"{", 
        RowBox[{"t1", ",", "0", ",", 
         RowBox[{
          RowBox[{
           SubscriptBox["T", "1"], "+", 
           SubscriptBox["T", "0"]}], "/.", "param"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t2", ",", "0", ",", 
         RowBox[{
          RowBox[{
           SubscriptBox["T", "1"], "+", 
           SubscriptBox["T", "0"]}], "/.", "param"}]}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"l", ",", "range"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9035152654741373`*^9, 3.9035153007199497`*^9}},
 CellLabel->
  "In[105]:=",ExpressionUUID->"540ab55e-10bf-49a2-b16b-deeac919936b"],

Cell[BoxData[
 TemplateBox[{
  "NIntegrate", "slwcon", 
   "\"Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration is 0, highly oscillatory \
integrand, or WorkingPrecision too small.\"", 2, 19, 3, 24207634239168008180, 
   "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.903515597570002*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"915a5bd3-7567-49ed-bc55-afdfe5352fc8"],

Cell[BoxData[
 TemplateBox[{
  "NIntegrate", "eincr", 
   "\"The global error of the strategy GlobalAdaptive has increased more than \
\\!\\(\\*RowBox[{\\\"2000\\\"}]\\) times. The global error is expected to \
decrease monotonically after a number of integrand evaluations. Suspect one \
of the following: the working precision is insufficient for the specified \
precision goal; the integrand is highly oscillatory or it is not a \
(piecewise) smooth function; or the true value of the integral is 0. \
Increasing the value of the GlobalAdaptive option MaxErrorIncreases might \
lead to a convergent numerical integration. NIntegrate obtained \
\\!\\(\\*RowBox[{\\\"1.2015235371572228`\\\"}]\\) and \
\\!\\(\\*RowBox[{\\\"0.000014423395264300637`\\\"}]\\) for the integral and \
error estimates.\"", 2, 19, 4, 24207634239168008180, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.903515597762644*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"2b9d5aa1-4c9f-4d4a-8747-8ac0ca8b90ed"],

Cell[BoxData[
 TemplateBox[{
  "NIntegrate", "slwcon", 
   "\"Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration is 0, highly oscillatory \
integrand, or WorkingPrecision too small.\"", 2, 19, 5, 24207634239168008180, 
   "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.903515602870977*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"d1d359f0-2b03-4882-b17e-1223ffb2e276"],

Cell[BoxData[
 TemplateBox[{
  "NIntegrate", "eincr", 
   "\"The global error of the strategy GlobalAdaptive has increased more than \
\\!\\(\\*RowBox[{\\\"2000\\\"}]\\) times. The global error is expected to \
decrease monotonically after a number of integrand evaluations. Suspect one \
of the following: the working precision is insufficient for the specified \
precision goal; the integrand is highly oscillatory or it is not a \
(piecewise) smooth function; or the true value of the integral is 0. \
Increasing the value of the GlobalAdaptive option MaxErrorIncreases might \
lead to a convergent numerical integration. NIntegrate obtained \
\\!\\(\\*RowBox[{\\\"1.3880394362473145`\\\"}]\\) and \
\\!\\(\\*RowBox[{\\\"0.000017326321614577028`\\\"}]\\) for the integral and \
error estimates.\"", 2, 19, 6, 24207634239168008180, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.903515603036808*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"904add7c-405f-4fd2-a3ca-612c14489aa5"],

Cell[BoxData[
 TemplateBox[{
  "NIntegrate", "slwcon", 
   "\"Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration is 0, highly oscillatory \
integrand, or WorkingPrecision too small.\"", 2, 19, 7, 24207634239168008180, 
   "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.9035156081443996`*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"925872e1-f023-491c-9adf-18499b347322"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"NIntegrate\\\", \
\\\"::\\\", \\\"slwcon\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 19, 8, 24207634239168008180, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.903515608149469*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"ae9005e5-f88a-4884-83ef-be301440737e"],

Cell[BoxData[
 TemplateBox[{
  "NIntegrate", "eincr", 
   "\"The global error of the strategy GlobalAdaptive has increased more than \
\\!\\(\\*RowBox[{\\\"2000\\\"}]\\) times. The global error is expected to \
decrease monotonically after a number of integrand evaluations. Suspect one \
of the following: the working precision is insufficient for the specified \
precision goal; the integrand is highly oscillatory or it is not a \
(piecewise) smooth function; or the true value of the integral is 0. \
Increasing the value of the GlobalAdaptive option MaxErrorIncreases might \
lead to a convergent numerical integration. NIntegrate obtained \
\\!\\(\\*RowBox[{\\\"1.5601592557307713`\\\"}]\\) and \
\\!\\(\\*RowBox[{\\\"0.00002024869903862996`\\\"}]\\) for the integral and \
error estimates.\"", 2, 19, 9, 24207634239168008180, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.903515608313343*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"d6a0fb96-6885-4777-9b1c-a87be1ab5e77"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"NIntegrate\\\", \
\\\"::\\\", \\\"eincr\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 19, 10, 24207634239168008180, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.903515608320822*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"10119b88-eb1c-475a-b7c2-e17f94b2278f"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"range", ",", "f"}], "}"}], "\[Transpose]"}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "F2"}], "/.", "param"}], ",", 
     RowBox[{"{", 
      RowBox[{"l", ",", "1", ",", "5"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9035152785797*^9, 3.903515285219041*^9}, {
   3.90351575419084*^9, 3.903515756666244*^9}, {3.903515849617772*^9, 
   3.903515851163969*^9}, 3.9035158839361353`*^9},
 CellLabel->"In[32]:=",ExpressionUUID->"f7c67ca6-fe46-42e5-a73a-485906c5e2d8"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQBWIQDQEf7JfmTd9XYPnZ3hgMPtvz32S+nmH6zT4NDL7Z
hyy168389sN+1kwQ+Gkf0Tnrfk7jb/uzZ0Dgj72Vp5zo+1t/7aEGOhycNI+t
npnBAaKe0UFxblrEIhZGBxOw+cwOHHNvM3Z/YnSA6GdxWMIcGLb7HJMDxD42
h6X7C1omzWJ2gBjH4WC5jyE+IJwFah6nw58je+ZIsLFCzeN26OVb0fx1OSvU
PB6HN/N3HLply+aQDjaPz+Ee22Pl5SfYoOYJOHCq7XZQ92SHqhdwWP2L94bY
AXao+YIOUzjnVCvpcUDdI+QwLf3CpxeTOaD2CTssmXdS8utHDqh5Ig4CwXpF
dzw4HQDrmYR6
      "]]}, {{}, {}}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwV0Xs411keB/Dfxe9yyO13qFSrITzuiYxK47xdBimNEaNVlB+NlbaLWctO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        "]]},
      Annotation[#, "Charting`Private`Tag$56141#1"]& ]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.916666666666669, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0.916666666666669, 5.}, {0, 3.160576717413626}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.9035157152131157`*^9, 3.903515758413288*^9, 
  3.9035158090817623`*^9, 3.903515851570511*^9, 3.903515884838072*^9},
 CellLabel->"Out[32]=",ExpressionUUID->"d3d06c67-d111-4f12-a93a-4456c7009563"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.90351610160008*^9, 
  3.903516104284484*^9}},ExpressionUUID->"75f4136a-fac5-4dde-800d-\
6e811ce857e6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Analytics", "Section",
 CellChangeTimes->{{3.903436128777051*^9, 
  3.903436130585472*^9}},ExpressionUUID->"f5dc355d-249f-4dd6-a8ce-\
b4d956ac5a0b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"C1", "/.", "rule1"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.9034650131819468`*^9, 3.9034650242610035`*^9}, 
   3.9034654369243793`*^9},
 CellLabel->
  "In[125]:=",ExpressionUUID->"c56ff23a-7d74-40fa-b93e-a5d1a28eb054"],

Cell[BoxData[
 RowBox[{
  RowBox[{"C1", "=", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]", "-", "\[Tau]"}]], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[Beta]"}]], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"\[Beta]", "+", "\[Tau]"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "\[Beta]"}], "+", "\[Tau]"}], ")"}]}]}], ")"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.904457040727522*^9, 3.904457042963883*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"67aa2ef0-6792-49b7-8e54-84038f1d7e39"],

Cell[BoxData[
 RowBox[{
  RowBox[{"C2", "/.", "rule1"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.9034654403242736`*^9, 3.9034654637238035`*^9}},
 CellLabel->
  "In[131]:=",ExpressionUUID->"a3a3a713-3a3d-4615-8138-a0f988f34bcd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"C2", "=", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "\[Gamma]"}]], " ", "\[Beta]", " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "\[Tau]"}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["\[ExponentialE]", "\[Beta]"]}], "+", 
          SuperscriptBox["\[ExponentialE]", "\[Gamma]"]}], ")"}]}], 
       RowBox[{"\[Beta]", "-", "\[Gamma]"}]], "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "\[Beta]"}]], " ", 
        RowBox[{"(", 
         RowBox[{"\[Gamma]", "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["\[ExponentialE]", "\[Beta]"], " ", 
           RowBox[{"(", 
            RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"\[Beta]", "+", "\[Gamma]"}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "\[Beta]"}], "+", "\[Gamma]"}], ")"}]}]}], 
         ")"}]}], 
       RowBox[{"\[Gamma]", " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}]}]]}], ")"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.9044570445971746`*^9, 3.90445704717325*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"f35c2e4c-2e15-4748-af27-e6527eaf4006"],

Cell[BoxData[
 RowBox[{
  RowBox[{"C3", "/.", "rule1"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.9034654447800565`*^9, 3.903465460363754*^9}},
 CellLabel->
  "In[130]:=",ExpressionUUID->"c5856256-bfea-48f7-9c66-6186a853f3e9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"C3", "=", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]", "-", "\[Tau]"}]], " ", 
     SuperscriptBox["\[Beta]", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", "\[Beta]"}]]}], ")"}], " ", "\[Beta]", " ", 
        "\[Gamma]"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", "\[Beta]"}]], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"\[Beta]", "+", "\[Gamma]"}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "\[Gamma]"}], ")"}]}]}], ")"}], " ", 
        SuperscriptBox["\[Gamma]", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["\[Beta]", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", "\[Beta]"}]], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"\[Beta]", "+", "\[Gamma]"}]], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Gamma]"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["\[Beta]", "2"], "-", 
       SuperscriptBox["\[Gamma]", "2"]}], ")"}], "2"]]}], ";"}]], "Input",
 CellChangeTimes->{{3.904457049952876*^9, 3.904457051994865*^9}},
 CellLabel->"In[43]:=",ExpressionUUID->"1f1f8776-8112-4eba-a0ca-b701686019a7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"C4", "/.", "rule1"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.903465449372367*^9, 3.903465454796244*^9}},
 CellLabel->
  "In[129]:=",ExpressionUUID->"ccda7993-9ee5-4a06-840e-f08742bdc46b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"C4", "=", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "\[Gamma]"}]], " ", "\[Beta]", " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "\[Tau]"}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["\[ExponentialE]", "\[Beta]"]}], "+", 
          SuperscriptBox["\[ExponentialE]", "\[Gamma]"]}], ")"}]}], 
       RowBox[{"\[Beta]", "-", "\[Gamma]"}]], "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "\[Beta]"}]], " ", 
        RowBox[{"(", 
         RowBox[{"\[Gamma]", "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["\[ExponentialE]", "\[Beta]"], " ", 
           RowBox[{"(", 
            RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"\[Beta]", "+", "\[Gamma]"}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "\[Beta]"}], "+", "\[Gamma]"}], ")"}]}]}], 
         ")"}]}], 
       RowBox[{"\[Gamma]", " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}]}]]}], ")"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.904457055003365*^9, 3.904457057069181*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"00bf0cc3-eb14-47ec-ac26-9004e91d1723"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C1", "'"}], "/.", "rule1"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{
  3.903966816115232*^9, {3.906371079008856*^9, 
   3.906371079824009*^9}},ExpressionUUID->"6ad89f0c-09aa-4383-92dd-\
2903a2b481a4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"C1", "'"}], "=", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]", "-", "\[Tau]"}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}], "2"]}]}]], "Input",
 CellChangeTimes->{{3.906371080744247*^9, 3.906371083755293*^9}},
 CellLabel->"In[45]:=",ExpressionUUID->"4c20d5c1-359e-42ac-8862-29cb3c61d809"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]", "-", "\[Tau]"}]], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}], "2"]}]], "Output",
 CellChangeTimes->{3.9063710846447573`*^9},
 CellLabel->"Out[45]=",ExpressionUUID->"8830496a-280d-453e-b84a-eaaa29466023"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C2", "'"}], "/.", "rule1"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.903966818520349*^9, 3.903966824273891*^9}},
 CellLabel->"In[95]:=",ExpressionUUID->"06c64049-650c-4639-9602-e670150e8658"],

Cell[BoxData[
 RowBox[{
  RowBox[{"C2", "'"}], "=", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "+", 
          RowBox[{"3", " ", "\[Tau]"}]}], ")"}]}], "\[Beta]"]}]], " ", 
    "\[Beta]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"\[Beta]", "+", "\[Gamma]", "+", 
         RowBox[{"3", " ", "\[Tau]"}], "+", 
         FractionBox[
          RowBox[{"2", " ", "\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          FractionBox[
           RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]]}], ")"}], " ", 
       SuperscriptBox["\[Beta]", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"2", "+", 
           FractionBox[
            RowBox[{"3", " ", "\[Gamma]"}], "\[Beta]"]}], ")"}], " ", 
         "\[Tau]"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}], " ", 
       "\[Gamma]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[ExponentialE]", "\[Tau]"], " ", 
          RowBox[{"(", 
           RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"\[Beta]", "+", "\[Gamma]"}]], " ", 
          RowBox[{"(", 
           RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}]}]}], ")"}]}]}], 
     ")"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}], " ", "\[Gamma]", " ", 
    RowBox[{"(", 
     RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}]}]]}]], "Input",
 CellChangeTimes->{{3.906371085984887*^9, 3.9063710871251*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"77ec103c-f9c5-4c02-b31d-fbd18a24575e"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "+", 
         RowBox[{"3", " ", "\[Tau]"}]}], ")"}]}], "\[Beta]"]}]], " ", 
   "\[Beta]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[Beta]", "+", "\[Gamma]", "+", 
        RowBox[{"3", " ", "\[Tau]"}], "+", 
        FractionBox[
         RowBox[{"2", " ", "\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         FractionBox[
          RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]]}], ")"}], " ", 
      SuperscriptBox["\[Beta]", "2"]}], "-", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", "+", 
          FractionBox[
           RowBox[{"3", " ", "\[Gamma]"}], "\[Beta]"]}], ")"}], " ", 
        "\[Tau]"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}], " ", "\[Gamma]",
       " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[ExponentialE]", "\[Tau]"], " ", 
         RowBox[{"(", 
          RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"\[Beta]", "+", "\[Gamma]"}]], " ", 
         RowBox[{"(", 
          RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}], " ", "\[Gamma]", " ", 
   RowBox[{"(", 
    RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}]}]]], "Output",
 CellChangeTimes->{3.906371087608378*^9},
 CellLabel->"Out[46]=",ExpressionUUID->"7d391aae-faf0-4be1-bac9-5af798b1b693"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C3", "'"}], "/.", "rule1"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.903966821620349*^9, 3.90396683397956*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"d61bca64-6b5c-4f43-90e3-43d1a25822d9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"C3", "'"}], "=", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "+", "\[Tau]"}], ")"}]}], "\[Beta]"]}]], " ", 
    SuperscriptBox["\[Beta]", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"2", "+", 
           FractionBox["\[Gamma]", "\[Beta]"]}], ")"}], " ", "\[Tau]"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}], "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"\[Beta]", "+", "\[Gamma]", "+", 
         FractionBox[
          RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Gamma]"}], ")"}], " ", 
            SuperscriptBox["\[Gamma]", "2"]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Beta]", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "\[Gamma]"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"\[Beta]", "+", "\[Gamma]", "+", "\[Tau]"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["\[Beta]", "3"], "-", 
         RowBox[{"\[Beta]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", "\[Gamma]"}], ")"}], " ", "\[Gamma]"}], 
         "-", 
         RowBox[{
          SuperscriptBox["\[Beta]", "2"], " ", "\[Tau]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Gamma]", "2"], " ", "\[Tau]"}]}], ")"}]}]}], 
     ")"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], "-", 
      SuperscriptBox["\[Gamma]", "2"]}], ")"}], "2"]]}]], "Input",
 CellChangeTimes->{{3.9063710893957253`*^9, 3.9063710905254602`*^9}},
 CellLabel->"In[47]:=",ExpressionUUID->"47e9321c-414b-402b-985f-d0fc76328896"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "+", "\[Tau]"}], ")"}]}], "\[Beta]"]}]], " ", 
   SuperscriptBox["\[Beta]", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       FractionBox[
        RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}], "2"]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", "+", 
          FractionBox["\[Gamma]", "\[Beta]"]}], ")"}], " ", "\[Tau]"}]], " ", 
      
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}], "2"]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[Beta]", "+", "\[Gamma]", "+", 
        FractionBox[
         RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "\[Gamma]"}], ")"}], " ", 
           SuperscriptBox["\[Gamma]", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["\[Beta]", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "\[Gamma]"}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[Beta]", "+", "\[Gamma]", "+", "\[Tau]"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["\[Beta]", "3"], "-", 
        RowBox[{"\[Beta]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", "\[Gamma]"}], ")"}], " ", "\[Gamma]"}], 
        "-", 
        RowBox[{
         SuperscriptBox["\[Beta]", "2"], " ", "\[Tau]"}], "+", 
        RowBox[{
         SuperscriptBox["\[Gamma]", "2"], " ", "\[Tau]"}]}], ")"}]}]}], 
    ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["\[Beta]", "2"], "-", 
     SuperscriptBox["\[Gamma]", "2"]}], ")"}], "2"]]], "Output",
 CellChangeTimes->{3.906371091072748*^9},
 CellLabel->"Out[47]=",ExpressionUUID->"a619aa82-570f-4567-95ed-6dd62435a1b6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C4", "'"}], "/.", "rule1"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.903966838321266*^9, 3.903966838453545*^9}},
 CellLabel->"In[97]:=",ExpressionUUID->"fedefe62-c57e-46a2-a309-1fb688d1b12b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"C4", "'"}], "=", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "+", "\[Tau]"}], ")"}]}], "\[Beta]"]}]], " ", 
    "\[Beta]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"\[Beta]", "+", "\[Gamma]", "+", "\[Tau]"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          FractionBox[
           RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]]}], ")"}], " ", 
       SuperscriptBox["\[Beta]", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"\[Beta]", "+", "\[Gamma]"}]], "+", 
         SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}], " ", "\[Beta]",
        " ", "\[Gamma]"}], "+", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"\[Beta]", "+", "\[Gamma]"}]]}], "+", 
         SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}], " ", 
       SuperscriptBox["\[Gamma]", "2"]}]}], ")"}]}], 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Beta]", "2"], " ", "\[Gamma]"}], "-", 
    SuperscriptBox["\[Gamma]", "3"]}]]}]], "Input",
 CellChangeTimes->{{3.906371093156372*^9, 3.906371094215114*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"2cacbd12-cac8-4afb-a23b-7d0989e8cf26"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "+", "\[Tau]"}], ")"}]}], "\[Beta]"]}]], " ", 
   "\[Beta]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[Beta]", "+", "\[Gamma]", "+", "\[Tau]"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         FractionBox[
          RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]]}], ")"}], " ", 
      SuperscriptBox["\[Beta]", "2"]}], "-", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       FractionBox[
        RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"\[Beta]", "+", "\[Gamma]"}]], "+", 
        SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}], " ", "\[Beta]", 
      " ", "\[Gamma]"}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       FractionBox[
        RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"\[Beta]", "+", "\[Gamma]"}]]}], "+", 
        SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}], " ", 
      SuperscriptBox["\[Gamma]", "2"]}]}], ")"}]}], 
  RowBox[{
   RowBox[{
    SuperscriptBox["\[Beta]", "2"], " ", "\[Gamma]"}], "-", 
   SuperscriptBox["\[Gamma]", "3"]}]]], "Output",
 CellChangeTimes->{3.90637109459067*^9},
 CellLabel->"Out[48]=",ExpressionUUID->"1892c205-d16d-4372-a30c-ba8888927454"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"C1", "+", "C2", "+", "C3", "+", "C4"}], "//", 
  "Simplify"}]], "Input",
 CellChangeTimes->{{3.9063711000081253`*^9, 3.90637112139314*^9}},
 CellLabel->"In[52]:=",ExpressionUUID->"ee7ea875-287e-41b9-86c0-b375ef04db37"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}], "2"], " ", "\[Gamma]", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}], "2"]}]], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]", "-", "\[Tau]"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["\[ExponentialE]", "\[Tau]"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}], "2"], " ", 
      SuperscriptBox["\[Gamma]", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[Beta]"}]], " ", 
      SuperscriptBox["\[Gamma]", "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}], "2"]}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}], "2"], " ", "\[Gamma]", 
      " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["\[Beta]", "2"]}], "+", 
        RowBox[{"2", " ", "\[Beta]", " ", "\[Gamma]"}], "+", 
        SuperscriptBox["\[Gamma]", "2"]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[Beta]", "+", "\[Gamma]", "+", "\[Tau]"}]], " ", "\[Beta]", 
      " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["\[Beta]", "2"]}], "+", 
        RowBox[{"3", " ", "\[Beta]", " ", "\[Gamma]"}], "+", 
        SuperscriptBox["\[Gamma]", "2"]}], ")"}]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[Beta]", "+", "\[Gamma]"}]], " ", "\[Beta]", " ", 
      SuperscriptBox["\[Gamma]", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["\[Beta]", "2"]}], "+", 
        SuperscriptBox["\[Beta]", "3"], "-", 
        RowBox[{"\[Beta]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", "\[Gamma]"}], ")"}], " ", "\[Gamma]"}], 
        "+", 
        SuperscriptBox["\[Gamma]", "2"]}], ")"}]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[Beta]", "+", "\[Tau]"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["\[Beta]", "2"], "-", 
         SuperscriptBox["\[Gamma]", "2"]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[Beta]", " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", "\[Gamma]"}], ")"}]}], "-", 
        RowBox[{"\[Gamma]", " ", "\[Tau]"}]}], ")"}]}]}], ")"}]}]}]], "Output",\

 CellChangeTimes->{{3.9063711070597258`*^9, 3.906371121667851*^9}},
 CellLabel->"Out[52]=",ExpressionUUID->"a1b679cb-3495-41af-91ff-2b21991d265f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C1", "'"}], "+", 
   RowBox[{"C2", "'"}], "+", 
   RowBox[{"C3", "'"}], "+", 
   RowBox[{"C4", "'"}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.906371112952259*^9, 3.906371118908918*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"57cee8ea-249c-4662-9438-d516814b13d8"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]", "-", "\[Tau]"}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}], "2"]}], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "+", "\[Tau]"}], ")"}]}], "\[Beta]"]}]], " ", 
    "\[Beta]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"\[Beta]", "+", "\[Gamma]", "+", "\[Tau]"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          FractionBox[
           RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]]}], ")"}], " ", 
       SuperscriptBox["\[Beta]", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"\[Beta]", "+", "\[Gamma]"}]], "+", 
         SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}], " ", "\[Beta]",
        " ", "\[Gamma]"}], "+", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"\[Beta]", "+", "\[Gamma]"}]]}], "+", 
         SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}], " ", 
       SuperscriptBox["\[Gamma]", "2"]}]}], ")"}]}], 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Beta]", "2"], " ", "\[Gamma]"}], "-", 
    SuperscriptBox["\[Gamma]", "3"]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "+", "\[Tau]"}], ")"}]}], "\[Beta]"]}]], " ", 
    SuperscriptBox["\[Beta]", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"2", "+", 
           FractionBox["\[Gamma]", "\[Beta]"]}], ")"}], " ", "\[Tau]"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}], "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"\[Beta]", "+", "\[Gamma]", "+", 
         FractionBox[
          RowBox[{"\[Gamma]", " ", "\[Tau]"}], "\[Beta]"]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Gamma]"}], ")"}], " ", 
            SuperscriptBox["\[Gamma]", "2"]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[Beta]", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "\[Gamma]"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"\[Beta]", "+", "\[Gamma]", "+", "\[Tau]"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["\[Beta]", "3"], "-", 
         RowBox[{"\[Beta]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", "\[Gamma]"}], ")"}], " ", "\[Gamma]"}], 
         "-", 
         RowBox[{
          SuperscriptBox["\[Beta]", "2"], " ", "\[Tau]"}], "+", 
         RowBox[{
          SuperscriptBox["\[Gamma]", "2"], " ", "\[Tau]"}]}], ")"}]}]}], 
     ")"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], "-", 
      SuperscriptBox["\[Gamma]", "2"]}], ")"}], "2"]]}]], "Output",
 CellChangeTimes->{{3.906371115372889*^9, 3.9063711192674093`*^9}},
 CellLabel->"Out[51]=",ExpressionUUID->"ed11dbbf-ef99-4f86-b8f5-42e7ea5cfe38"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"P1", "+", "P2", "+", "P3", "+", "P4"}], "/.", "rule1"}]], "Input",
 CellChangeTimes->{{3.9034638815991645`*^9, 3.903463883927277*^9}},
 CellLabel->
  "In[122]:=",ExpressionUUID->"d21c35ab-3c60-4901-9058-e753aba55d48"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["\[Beta]", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]"}]], "-", "\[Beta]", "-", 
       "\[Gamma]"}], ")"}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}], "2"]]}], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]", "-", "\[Tau]"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[Beta]", "+", "\[Gamma]"}]]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", "\[Tau]"]}], ")"}], " ", "\[Beta]"}], 
   
   RowBox[{"\[Beta]", "+", "\[Gamma]"}]], "+", 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", "\[Tau]"}]], "+", "\[Tau]"}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.9034638842876043`*^9},
 CellLabel->
  "Out[122]=",ExpressionUUID->"bfec3d76-c66f-4824-a0a4-c8d92a49ecaa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["rule1"], "Input",
 CellChangeTimes->{{3.9034636975530343`*^9, 3.9034636982551246`*^9}},
 CellLabel->
  "In[120]:=",ExpressionUUID->"883ecdb6-f2bd-4243-bf33-665e673f27ef"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["\[Kappa]", "t"], "\[Rule]", "1"}], ",", 
   RowBox[{
    SubscriptBox["\[Kappa]", "x"], "\[Rule]", "1"}], ",", 
   RowBox[{
    SubscriptBox["T", "1"], "\[Rule]", "\[Beta]"}], ",", 
   RowBox[{"L", "\[Rule]", "\[Gamma]"}], ",", 
   RowBox[{
    SubscriptBox["T", "0"], "\[Rule]", "\[Tau]"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9034636985598917`*^9},
 CellLabel->
  "Out[120]=",ExpressionUUID->"ba7123cd-eff4-4943-825f-71b111f09616"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.903612050560587*^9, 
  3.903612051497946*^9}},ExpressionUUID->"c96e53f4-3289-4d4a-b7d9-\
e3cbca910133"]
}, Open  ]]
},
WindowSize->{1269, 647},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"13.3 for Microsoft Windows (64-bit) (June 3, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"a3a34c7d-1664-41c3-8bfe-c4bae67bcad8"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 158, 3, 67, "Section",ExpressionUUID->"1211c674-d148-40ea-a798-41a3349fcb82"],
Cell[741, 27, 471, 12, 28, "Input",ExpressionUUID->"1d26f30c-808c-41e9-a8e9-5f2b5860020a"],
Cell[CellGroupData[{
Cell[1237, 43, 669, 17, 28, "Input",ExpressionUUID->"09b94106-a6f6-4538-a6ae-bafcb322b9f7"],
Cell[1909, 62, 640, 17, 53, "Output",ExpressionUUID->"6823cd8b-84e5-4dd2-8872-e6fc8d01676a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2586, 84, 739, 19, 28, "Input",ExpressionUUID->"c08ffb49-bb39-4c0e-a763-7056087490b1"],
Cell[3328, 105, 556, 15, 53, "Output",ExpressionUUID->"71ec24fb-8d23-4a24-934f-a1acfd0aaca8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3921, 125, 325, 6, 28, "Input",ExpressionUUID->"c0c47fbd-811f-4414-b585-049583e3ddd9"],
Cell[4249, 133, 608, 15, 51, "Output",ExpressionUUID->"924016f5-7971-4676-aec4-5cedd84aa415"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4894, 153, 741, 21, 48, "Input",ExpressionUUID->"1b8d2bd7-fd7b-4221-a2d5-ffa1661b7a8d"],
Cell[5638, 176, 696, 20, 53, "Output",ExpressionUUID->"86cf128a-9599-4773-9f1a-895d79777a6d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6371, 201, 1656, 43, 50, "Input",ExpressionUUID->"a2d0737a-7260-4017-aff3-50fa100585cd"],
Cell[8030, 246, 47322, 835, 236, "Output",ExpressionUUID->"694bbecb-a20f-4799-8caf-eae14d954b34"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[55401, 1087, 175, 3, 67, "Section",ExpressionUUID->"01752563-49dc-4898-b6e5-1e0e445c72d3"],
Cell[55579, 1092, 815, 19, 28, "Input",ExpressionUUID->"3b3fc3e0-645e-460c-a798-a13a1f658bfb"],
Cell[56397, 1113, 617, 17, 28, "Input",ExpressionUUID->"6ddc5d11-113a-4d92-9410-ccd08235144a"],
Cell[57017, 1132, 478, 14, 28, "Input",ExpressionUUID->"3ffa81d4-f351-45b3-b203-6921adda819b"],
Cell[57498, 1148, 713, 19, 28, "Input",ExpressionUUID->"cd4ea6e4-e07f-41e1-8d44-d2c8bd6f1144"],
Cell[58214, 1169, 682, 18, 28, "Input",ExpressionUUID->"61632bc0-0e15-42b7-abf1-2f9388d58a49"],
Cell[CellGroupData[{
Cell[58921, 1191, 1217, 34, 47, "Input",ExpressionUUID->"ca189b91-643d-4bf0-8aef-1f0da9c06025"],
Cell[60141, 1227, 1275, 33, 55, "Output",ExpressionUUID->"b2d625fa-0aae-457c-9d18-fdd234c415d2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[61453, 1265, 956, 27, 28, "Input",ExpressionUUID->"d18824b1-4be6-49c4-9aac-5db0ab5d6f95"],
Cell[62412, 1294, 823, 20, 56, "Output",ExpressionUUID->"2f548710-5f85-4f20-a34b-e262c00345d7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[63272, 1319, 1201, 36, 47, "Input",ExpressionUUID->"55f11a6e-63fb-424f-9399-fa909cfe9deb"],
Cell[64476, 1357, 1496, 45, 55, "Output",ExpressionUUID->"1374a7a6-246a-4faa-b967-8279903c16df"]
}, Open  ]],
Cell[CellGroupData[{
Cell[66009, 1407, 1431, 40, 47, "Input",ExpressionUUID->"abdc7f38-3b3c-4f19-9a43-8843a5e0293e"],
Cell[67443, 1449, 1693, 48, 55, "Output",ExpressionUUID->"6186de8a-393b-4b86-b457-5e6873b9a007"]
}, Open  ]],
Cell[CellGroupData[{
Cell[69173, 1502, 232, 4, 28, "Input",ExpressionUUID->"76972250-327d-4ac2-be76-6e75f2c14de2"],
Cell[69408, 1508, 202, 3, 32, "Output",ExpressionUUID->"10c4c713-f572-4d2e-b69c-1565c4ae7993"]
}, Open  ]],
Cell[CellGroupData[{
Cell[69647, 1516, 858, 23, 28, "Input",ExpressionUUID->"bc723f35-7c50-4618-b15c-bff6fe992119"],
Cell[70508, 1541, 7712, 146, 225, "Output",ExpressionUUID->"ed62ed51-5f04-4555-9f2a-0b65e46482b9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[78257, 1692, 202, 3, 28, "Input",ExpressionUUID->"2d1066ce-4528-486b-b7b8-05dd1cf2dfaa"],
Cell[78462, 1697, 561, 15, 55, "Output",ExpressionUUID->"cec5ab23-1a08-49a2-a2c1-2fb1bc984286"]
}, Open  ]],
Cell[CellGroupData[{
Cell[79060, 1717, 202, 3, 28, "Input",ExpressionUUID->"269cc34e-e983-4cc2-af98-e7e554464f3a"],
Cell[79265, 1722, 341, 8, 32, "Output",ExpressionUUID->"d7b57341-91f7-4b20-98f2-290577a6a64a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[79643, 1735, 202, 3, 28, "Input",ExpressionUUID->"6c05800c-9336-4ad9-a372-c77cabd6f290"],
Cell[79848, 1740, 658, 17, 54, "Output",ExpressionUUID->"3fba1778-90a7-43f0-b35e-b6635eabbdee"]
}, Open  ]],
Cell[CellGroupData[{
Cell[80543, 1762, 1304, 40, 53, "Input",ExpressionUUID->"0b0b99b0-c26e-4a54-a25b-9cabbc740138"],
Cell[81850, 1804, 178, 2, 32, "Output",ExpressionUUID->"ec24ee2f-c6e4-478e-97d6-cd3f305c9bc4"]
}, Open  ]],
Cell[82043, 1809, 665, 18, 53, "Input",ExpressionUUID->"38a9adb7-8316-40b7-a8e8-10ca226ed46e"],
Cell[82711, 1829, 839, 23, 47, "Input",ExpressionUUID->"b98779dc-0fa6-4612-8986-9fbaef7f407b"],
Cell[CellGroupData[{
Cell[83575, 1856, 350, 8, 37, "Input",ExpressionUUID->"5939bc8f-6d52-4dd2-8c40-de8638e7ab0d"],
Cell[83928, 1866, 220, 3, 32, "Output",ExpressionUUID->"ba3f725f-59f2-495b-9fec-7075bfd93cb7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[84185, 1874, 491, 13, 37, "Input",ExpressionUUID->"37200038-0c12-439b-b7d7-b41acfe6d957"],
Cell[84679, 1889, 193, 2, 32, "Output",ExpressionUUID->"95249c31-40f7-42e3-87bd-ab4f8679ad23"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[84921, 1897, 254, 4, 67, "Section",ExpressionUUID->"917b1e0d-4f02-4372-9bfd-856df324e2c2"],
Cell[85178, 1903, 188, 3, 40, "Text",ExpressionUUID->"36afa668-52c3-4996-b512-fb9700cd3944"],
Cell[CellGroupData[{
Cell[85391, 1910, 1746, 40, 28, "Input",ExpressionUUID->"e17d5f64-cf99-4b49-9d80-343fbed40db1"],
Cell[87140, 1952, 1968, 49, 56, "Output",ExpressionUUID->"08cbad2a-1a43-4771-877d-c55ae623d597"]
}, Open  ]],
Cell[CellGroupData[{
Cell[89145, 2006, 1275, 35, 28, "Input",ExpressionUUID->"85a1b555-fa5e-47bb-af6c-e194da86d697"],
Cell[90423, 2043, 1108, 30, 57, "Output",ExpressionUUID->"3eec85c9-a98f-4c81-bbde-32b160754c12"]
}, Open  ]],
Cell[CellGroupData[{
Cell[91568, 2078, 930, 21, 105, "Input",ExpressionUUID->"cbbac6c0-5933-47b6-bff3-abe8c058ac62"],
Cell[92501, 2101, 373, 5, 32, "Output",ExpressionUUID->"a207c550-a7a3-40ff-ba83-8754a8f2419c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[92911, 2111, 1162, 27, 54, "Input",ExpressionUUID->"3374ad54-9ffd-4587-aa3a-8e5489aa88cf"],
Cell[94076, 2140, 579, 8, 32, "Output",ExpressionUUID->"035ff678-8335-4580-ad13-79d2b96d3c6f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[94692, 2153, 597, 15, 28, "Input",ExpressionUUID->"1154fa2a-f18a-4d7c-9cbd-bb002245098f"],
Cell[95292, 2170, 250, 3, 32, "Output",ExpressionUUID->"dc3dc997-09da-4c2e-a1af-df08e446efb8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[95579, 2178, 383, 9, 31, "Input",ExpressionUUID->"ecad9e5e-8129-4a4d-825f-d59587bc7eed"],
Cell[95965, 2189, 4934, 100, 236, "Output",ExpressionUUID->"f2f1ce3a-1966-463d-9212-9a66cb48d694"]
}, Open  ]],
Cell[100914, 2292, 187, 3, 40, "Text",ExpressionUUID->"9cfd9054-8d2e-4287-a351-f7771ec283fa"],
Cell[101104, 2297, 121, 3, 35, "Text",ExpressionUUID->"14822b5a-9f14-47a2-bfc3-0caa9726fc95"],
Cell[CellGroupData[{
Cell[101250, 2304, 1065, 32, 47, "Input",ExpressionUUID->"0289b4d7-f63a-42b9-a79f-2adf966b64f1"],
Cell[102318, 2338, 4284, 118, 75, "Output",ExpressionUUID->"a742ffca-55a6-4942-9e15-fc9560d29967"]
}, Open  ]],
Cell[CellGroupData[{
Cell[106639, 2461, 1174, 33, 47, "Input",ExpressionUUID->"24a28f21-025c-4891-a4a7-8276dcb3cec2"],
Cell[107816, 2496, 1276, 36, 63, "Output",ExpressionUUID->"6b6187f0-1526-4b23-983e-c7f44a2e513c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[109129, 2537, 1099, 32, 47, "Input",ExpressionUUID->"91ea8874-5527-4143-8de8-112b1f185b9f"],
Cell[110231, 2571, 1183, 35, 63, "Output",ExpressionUUID->"0172c988-0692-4f77-b694-2e572d6cfa49"]
}, Open  ]],
Cell[CellGroupData[{
Cell[111451, 2611, 1101, 32, 47, "Input",ExpressionUUID->"2d8b2c76-f5f2-44d7-a10f-da687c8b7ed3"],
Cell[112555, 2645, 1590, 49, 55, "Output",ExpressionUUID->"fda84951-a4b1-4a77-ad94-fcc17d1d0522"]
}, Open  ]],
Cell[CellGroupData[{
Cell[114182, 2699, 321, 7, 28, "Input",ExpressionUUID->"cabbde91-8f63-40b4-a7a9-d307fec4b66d"],
Cell[114506, 2708, 243, 3, 32, "Output",ExpressionUUID->"4ccffb39-369e-418e-b58f-f698dcc2b591"]
}, Open  ]],
Cell[CellGroupData[{
Cell[114786, 2716, 891, 18, 124, "Input",ExpressionUUID->"0169a95c-5460-4a44-8d22-e1ef4388b531"],
Cell[115680, 2736, 152, 2, 34, "Output",ExpressionUUID->"484befbc-4257-4794-b648-a8e3308fa272"]
}, Open  ]],
Cell[115847, 2741, 144, 3, 35, "Text",ExpressionUUID->"2088c8d6-ed5f-48ff-8426-ae87a4657567"],
Cell[CellGroupData[{
Cell[116016, 2748, 1269, 35, 50, "Input",ExpressionUUID->"1791ebdd-dca2-4a49-899d-27e5337ca2f8"],
Cell[117288, 2785, 1911, 59, 81, "Output",ExpressionUUID->"73bb92bc-d809-4194-a3e2-e30acd9d25fe"]
}, Open  ]],
Cell[CellGroupData[{
Cell[119236, 2849, 1360, 36, 50, "Input",ExpressionUUID->"cac04fa0-13a0-463d-8070-85a2fcbb2cc8"],
Cell[120599, 2887, 1431, 42, 93, "Output",ExpressionUUID->"810c913f-f1b1-4c95-bb89-e98de5f2b658"]
}, Open  ]],
Cell[CellGroupData[{
Cell[122067, 2934, 1251, 35, 50, "Input",ExpressionUUID->"c7a912ae-6125-4ae3-8d84-852ed44a3086"],
Cell[123321, 2971, 1489, 42, 81, "Output",ExpressionUUID->"7a974953-4384-452e-be73-4be2f6d826a3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[124847, 3018, 1228, 34, 50, "Input",ExpressionUUID->"1c84807b-e564-419c-9395-c59c02186905"],
Cell[126078, 3054, 4689, 136, 112, "Output",ExpressionUUID->"cb8a08c8-7aa0-461d-9d0a-142fa5b0e192"]
}, Open  ]],
Cell[CellGroupData[{
Cell[130804, 3195, 451, 11, 30, "Input",ExpressionUUID->"074756c4-0a0f-4aa5-9c16-844249028206"],
Cell[131258, 3208, 322, 4, 34, "Output",ExpressionUUID->"47f1a27b-4ee3-4ba1-a573-f7a4ffafe56b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[131617, 3217, 925, 21, 157, "Input",ExpressionUUID->"495f8559-5b48-482c-a814-9920ca54dad9"],
Cell[132545, 3240, 328, 4, 34, "Output",ExpressionUUID->"015dc176-c933-49ee-895d-d34937a79895"]
}, Open  ]],
Cell[132888, 3247, 236, 4, 40, "Text",ExpressionUUID->"991017f2-bbdc-4acd-8584-9af1704fb570"],
Cell[133127, 3253, 121, 3, 35, "Text",ExpressionUUID->"1bc47a79-1a70-41e9-aecf-1aadd0d6753d"],
Cell[CellGroupData[{
Cell[133273, 3260, 1180, 36, 50, "Input",ExpressionUUID->"59446b82-0553-4223-80c6-41a9d1dde86c"],
Cell[134456, 3298, 4080, 113, 80, "Output",ExpressionUUID->"216ae1f0-7342-4737-969f-f6c55c33dde4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[138573, 3416, 1582, 42, 50, "Input",ExpressionUUID->"7c2bfd3b-e112-4a28-bd4b-e3fcc8bfd04a"],
Cell[140158, 3460, 1346, 37, 59, "Output",ExpressionUUID->"35b7d333-f16b-467a-87c3-2d0a3a434ca4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[141541, 3502, 1475, 43, 50, "Input",ExpressionUUID->"067d730d-7707-4444-8e0c-c439ed8ea337"],
Cell[143019, 3547, 1216, 36, 59, "Output",ExpressionUUID->"020b9355-25d4-4164-b9ae-6e84a7c6e618"]
}, Open  ]],
Cell[CellGroupData[{
Cell[144272, 3588, 364, 7, 30, "Input",ExpressionUUID->"d4a50e2f-3c60-4c36-b2eb-3e1e1de7db46"],
Cell[144639, 3597, 277, 4, 34, "Output",ExpressionUUID->"2e99774e-5827-49d4-8808-fa8755936c71"]
}, Open  ]],
Cell[CellGroupData[{
Cell[144953, 3606, 699, 16, 52, "Input",ExpressionUUID->"a964eb68-d651-4b26-8583-3c51c40ce455"],
Cell[145655, 3624, 247, 3, 34, "Output",ExpressionUUID->"cda055eb-866b-465c-bef3-24aaa31a08dc"]
}, Open  ]],
Cell[145917, 3630, 175, 2, 30, "Input",ExpressionUUID->"42382481-e315-42ca-b4c9-c354e44070c7"],
Cell[146095, 3634, 144, 3, 35, "Text",ExpressionUUID->"c814c651-6cd2-4e9d-9d65-37d50228d415"],
Cell[CellGroupData[{
Cell[146264, 3641, 1467, 41, 50, "Input",ExpressionUUID->"901de504-192f-454a-bddd-4d330203bdbe"],
Cell[147734, 3684, 7059, 193, 114, "Output",ExpressionUUID->"bd2fa1c8-1d63-4c89-aadd-7521b4a46893"]
}, Open  ]],
Cell[CellGroupData[{
Cell[154830, 3882, 1541, 45, 50, "Input",ExpressionUUID->"c432cfee-ea98-48fb-ba75-db154aac04da"],
Cell[156374, 3929, 1312, 37, 59, "Output",ExpressionUUID->"c74e7687-6de7-4bae-89a5-996f7bfc50fa"]
}, Open  ]],
Cell[CellGroupData[{
Cell[157723, 3971, 1434, 42, 50, "Input",ExpressionUUID->"751aeec6-75f5-4fb3-a236-c25564882d0c"],
Cell[159160, 4015, 1583, 45, 83, "Output",ExpressionUUID->"29e4afaf-dd12-4c47-b539-fca785224382"]
}, Open  ]],
Cell[CellGroupData[{
Cell[160780, 4065, 1415, 43, 50, "Input",ExpressionUUID->"4397fd29-efa7-4831-b77b-4794ea958dba"],
Cell[162198, 4110, 1118, 33, 81, "Output",ExpressionUUID->"d2a376a3-9f04-4055-aa2b-308bdc00fdd4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[163353, 4148, 1458, 42, 50, "Input",ExpressionUUID->"43b3ea7d-442b-4255-9e62-28697721acff"],
Cell[164814, 4192, 1962, 59, 83, "Output",ExpressionUUID->"0b6a3d12-5e64-42ae-9159-8d31c504eaea"]
}, Open  ]],
Cell[CellGroupData[{
Cell[166813, 4256, 526, 12, 30, "Input",ExpressionUUID->"205dd1dd-d59e-459c-92d0-d151b351a17c"],
Cell[167342, 4270, 323, 5, 34, "Output",ExpressionUUID->"9665eea4-887d-4f5f-97fc-55ab3cc532fa"]
}, Open  ]],
Cell[CellGroupData[{
Cell[167702, 4280, 620, 14, 33, "Input",ExpressionUUID->"4089f9c0-1213-4130-b43b-ed0e264bb8f1"],
Cell[168325, 4296, 2413, 76, 85, "Output",ExpressionUUID->"cf0b0a51-dfc0-4791-8605-1fc0f96f7667"]
}, Open  ]],
Cell[CellGroupData[{
Cell[170775, 4377, 497, 12, 33, "Input",ExpressionUUID->"13943eab-9cc9-4448-b121-aaa82e55275f"],
Cell[171275, 4391, 2210, 68, 83, "Output",ExpressionUUID->"aac53142-86a5-4b2b-bb77-0ca2dd543052"]
}, Open  ]],
Cell[CellGroupData[{
Cell[173522, 4464, 1147, 24, 136, "Input",ExpressionUUID->"5c68a438-6e51-429f-aa79-3fc41f2221d5"],
Cell[174672, 4490, 247, 3, 34, "Output",ExpressionUUID->"b6373a3a-73ce-4a79-a5ee-ba017525e9b3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[174956, 4498, 308, 8, 30, "Input",ExpressionUUID->"228c02cb-4e01-4eac-8630-9b5d062a01a6"],
Cell[175267, 4508, 674, 18, 59, "Output",ExpressionUUID->"1982e6d5-0bff-4be6-bfa1-c0a649fdd3b1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[175978, 4531, 282, 7, 30, "Input",ExpressionUUID->"1cfb1823-a073-48e1-b294-11ba7804a993"],
Cell[176263, 4540, 1023, 28, 73, "Output",ExpressionUUID->"44d54222-96f9-492e-a7c6-98c9fb23a95d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[177323, 4573, 349, 8, 30, "Input",ExpressionUUID->"41334679-63ab-47a1-b6fd-2f8bda4cafa1"],
Cell[177675, 4583, 1401, 38, 73, "Output",ExpressionUUID->"c0260ff3-467d-46b9-a006-5e87837536bb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[179113, 4626, 490, 11, 30, "Input",ExpressionUUID->"98e3e65e-b11a-4d14-8beb-ba8fbb1dff81"],
Cell[179606, 4639, 1161, 32, 73, "Output",ExpressionUUID->"e28169ed-f8c3-4086-94ee-9422ad099851"]
}, Open  ]],
Cell[CellGroupData[{
Cell[180804, 4676, 1828, 48, 75, "Input",ExpressionUUID->"29ae48db-fa51-4972-b909-261b04f4191d"],
Cell[182635, 4726, 1195, 33, 73, "Output",ExpressionUUID->"f188d879-b5cf-404e-be63-c23ba5ea2623"]
}, Open  ]],
Cell[CellGroupData[{
Cell[183867, 4764, 1187, 31, 51, "Input",ExpressionUUID->"69665346-4a9c-4000-9a40-e6b0619e0624"],
Cell[185057, 4797, 645, 17, 52, "Output",ExpressionUUID->"93cebd92-1bd2-4db1-8049-6dbb38eb7875"]
}, Open  ]],
Cell[185717, 4817, 674, 19, 49, "Input",ExpressionUUID->"4c287521-34ce-497c-9b02-6ff2dba9d601"],
Cell[CellGroupData[{
Cell[186416, 4840, 1496, 43, 75, "Input",ExpressionUUID->"dde54be6-4255-4101-944e-314f8abccc4b"],
Cell[187915, 4885, 278, 4, 34, "Output",ExpressionUUID->"4717fd9b-41db-499a-a349-417d82a93f03"]
}, Open  ]],
Cell[CellGroupData[{
Cell[188230, 4894, 1353, 39, 75, "Input",ExpressionUUID->"43e42e88-4bc7-4e16-8277-431e81bf2dc1"],
Cell[189586, 4935, 176, 2, 34, "Output",ExpressionUUID->"7b0a5f8f-7e60-4711-8d7e-5617a61865d7"]
}, Open  ]],
Cell[189777, 4940, 235, 4, 40, "Text",ExpressionUUID->"d14a4d31-b333-4815-a081-a32e783f41b6"],
Cell[190015, 4946, 143, 3, 35, "Text",ExpressionUUID->"66975603-c2df-4e45-81c4-9a2feddb5da3"],
Cell[CellGroupData[{
Cell[190183, 4953, 1370, 41, 50, "Input",ExpressionUUID->"d4f6219f-0113-4543-8901-0aee2cb42333"],
Cell[191556, 4996, 1615, 49, 57, "Output",ExpressionUUID->"e44524c2-cf5c-413e-9391-a1cb5e248cce"]
}, Open  ]],
Cell[CellGroupData[{
Cell[193208, 5050, 1482, 44, 50, "Input",ExpressionUUID->"bc83c5e4-1f90-491a-9ea5-8617c57183f7"],
Cell[194693, 5096, 1226, 36, 77, "Output",ExpressionUUID->"fbc49398-12f7-4f5c-8ef1-f4469525e5a7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[195956, 5137, 1376, 41, 50, "Input",ExpressionUUID->"6e725282-33cb-4576-98ba-5525947250ed"],
Cell[197335, 5180, 1597, 47, 57, "Output",ExpressionUUID->"0685b9ae-edd9-4542-9d10-501ad2d4b21e"]
}, Open  ]],
Cell[198947, 5230, 1420, 42, 50, "Input",ExpressionUUID->"cf9b427e-2b4f-4566-bf16-bbbdd62e081f"],
Cell[CellGroupData[{
Cell[200392, 5276, 269, 6, 30, "Input",ExpressionUUID->"fc57158d-71ac-4664-a48f-83b3ed90be9d"],
Cell[200664, 5284, 245, 3, 34, "Output",ExpressionUUID->"8d26ff7e-e25f-4d54-953e-2135a65d8223"]
}, Open  ]],
Cell[CellGroupData[{
Cell[200946, 5292, 1118, 34, 74, "Input",ExpressionUUID->"b557c0f4-f796-445d-a82a-9f691e4878b1"],
Cell[202067, 5328, 1074, 34, 77, "Output",ExpressionUUID->"ca75b161-7d09-4a46-aa3c-03bfb207c07d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[203178, 5367, 747, 23, 74, "Input",ExpressionUUID->"34fe2868-847a-41bc-ad19-ef2d17c77530"],
Cell[203928, 5392, 726, 21, 57, "Output",ExpressionUUID->"185a13cd-6fbc-4be3-9214-5c38a57baa27"]
}, Open  ]],
Cell[CellGroupData[{
Cell[204691, 5418, 144, 2, 30, "Input",ExpressionUUID->"15e87f4d-b091-4d1b-b20f-4c9fe7c1310f"],
Cell[204838, 5422, 3876, 123, 77, "Output",ExpressionUUID->"efa72cfe-00bf-489a-ab41-0eaa0b416877"]
}, Open  ]],
Cell[CellGroupData[{
Cell[208751, 5550, 270, 6, 30, "Input",ExpressionUUID->"93c804e2-adfd-479c-b26a-f4609030f374"],
Cell[209024, 5558, 1923, 55, 67, "Output",ExpressionUUID->"6a0777d7-5c02-4f20-a26a-b3aa7d98df41"]
}, Open  ]],
Cell[CellGroupData[{
Cell[210984, 5618, 1071, 20, 178, "Input",ExpressionUUID->"b1cbeafb-7424-420a-b265-509628e93901"],
Cell[212058, 5640, 409, 5, 34, "Output",ExpressionUUID->"6868772a-36c8-4df7-a481-a063436ac5fa"]
}, Open  ]],
Cell[212482, 5648, 146, 3, 35, "Text",ExpressionUUID->"47ce811c-239b-447f-a094-ebeba6c19607"],
Cell[CellGroupData[{
Cell[212653, 5655, 1502, 45, 50, "Input",ExpressionUUID->"9311b939-2737-45a8-b932-5471a8b8b6e6"],
Cell[214158, 5702, 4044, 116, 84, "Output",ExpressionUUID->"23364a3b-37d3-4b04-a298-8ffd9ff446f1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[218239, 5823, 1439, 43, 50, "Input",ExpressionUUID->"aebac2fa-eabc-461d-bcc9-a127cf3569b6"],
Cell[219681, 5868, 1936, 59, 81, "Output",ExpressionUUID->"5d713620-f94b-4c89-855e-74036486d6d5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[221654, 5932, 1597, 46, 50, "Input",ExpressionUUID->"41d46639-4c95-4465-b93e-86b750e821dc"],
Cell[223254, 5980, 1331, 39, 129, "Output",ExpressionUUID->"420223ea-7a20-4e72-97d6-666f1ef28ce5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[224622, 6024, 1538, 44, 50, "Input",ExpressionUUID->"85431a33-1424-4db2-b726-c1f3456df300"],
Cell[226163, 6070, 1769, 52, 129, "Output",ExpressionUUID->"cf6ceb54-d603-480c-a619-eb307b433a4e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[227969, 6127, 494, 11, 30, "Input",ExpressionUUID->"7c1bece4-11da-4ab8-87bf-9ccaa4a4d101"],
Cell[228466, 6140, 344, 5, 34, "Output",ExpressionUUID->"0e9e34bc-ba06-422e-89fd-d0f8902266d4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[228847, 6150, 331, 8, 30, "Input",ExpressionUUID->"20c8fbf5-5154-478c-a4cb-95dd63f8a45a"],
Cell[229181, 6160, 2485, 74, 112, "Output",ExpressionUUID->"e3376da7-a1ad-4f18-897c-2a59957841c3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[231703, 6239, 2225, 55, 86, "Input",ExpressionUUID->"b12655a6-5649-4c7f-8789-17f86e9ccd13"],
Cell[233931, 6296, 725, 10, 34, "Output",ExpressionUUID->"3a780fc7-df2d-4579-b367-63307908b694"]
}, Open  ]],
Cell[CellGroupData[{
Cell[234693, 6311, 1487, 42, 54, "Input",ExpressionUUID->"38d522ce-ed3a-4b3f-bf28-f4c11687a005"],
Cell[236183, 6355, 1269, 35, 64, "Output",ExpressionUUID->"42497412-9657-41eb-a204-ebd995226126"]
}, Open  ]],
Cell[CellGroupData[{
Cell[237489, 6395, 858, 25, 49, "Input",ExpressionUUID->"8f08c3e4-e943-46ac-b91d-97b4818cfda0"],
Cell[238350, 6422, 614, 17, 75, "Output",ExpressionUUID->"13fbcf59-5ce1-48a1-9795-dbc9e19187f3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[239001, 6444, 1312, 38, 52, "Input",ExpressionUUID->"4cd448d1-47fe-4a9a-a1e9-5fe20b945421"],
Cell[240316, 6484, 176, 2, 34, "Output",ExpressionUUID->"b18a5b1b-d892-4576-893f-09331fff1210"]
}, Open  ]],
Cell[CellGroupData[{
Cell[240529, 6491, 782, 21, 52, "Input",ExpressionUUID->"c6eab110-697c-4834-b529-8d96cf70fedc"],
Cell[241314, 6514, 786, 23, 57, "Output",ExpressionUUID->"2b45fef7-604c-40bf-b124-2e42511eff64"]
}, Open  ]],
Cell[CellGroupData[{
Cell[242137, 6542, 840, 24, 52, "Input",ExpressionUUID->"6e2e5162-b82b-492f-b998-2fd71473c796"],
Cell[242980, 6568, 785, 23, 76, "Output",ExpressionUUID->"f29e9fc0-6c7f-4b14-bd48-de190234b216"]
}, Open  ]],
Cell[CellGroupData[{
Cell[243802, 6596, 700, 20, 50, "Input",ExpressionUUID->"d8b32bd0-5ee4-47e6-97b0-5d745a2e28aa"],
Cell[244505, 6618, 612, 17, 76, "Output",ExpressionUUID->"eec88ff4-4004-4e3d-8b1d-0f07b10f58df"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[245166, 6641, 195, 3, 67, "Section",ExpressionUUID->"cfdafad0-aa00-46fb-a31f-b2304fe0e8ab"],
Cell[CellGroupData[{
Cell[245386, 6648, 705, 14, 30, "Input",ExpressionUUID->"c6b15aef-31e0-4ebe-a0e1-8523571d031a"],
Cell[246094, 6664, 10395, 310, 217, "Output",ExpressionUUID->"4b523b3c-b093-4349-bae1-2818542fe45a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[256526, 6979, 595, 15, 30, "Input",ExpressionUUID->"3d7f421f-f3e1-4371-ae21-02240164c860"],
Cell[257124, 6996, 9233, 262, 218, "Output",ExpressionUUID->"89ec0eb6-3806-41fe-af2a-d50d3054609a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[266394, 7263, 233, 4, 30, "Input",ExpressionUUID->"4101df01-74f0-4956-a0ed-4ef93363c5c9"],
Cell[266630, 7269, 3292, 93, 80, "Output",ExpressionUUID->"b286e7b0-e802-4c79-b271-da6668c8004a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[269959, 7367, 231, 4, 30, "Input",ExpressionUUID->"a528e094-4e5b-4b5b-acef-4bbe0daa359c"],
Cell[270193, 7373, 4982, 139, 100, "Output",ExpressionUUID->"57b2afc1-4068-4320-a144-1e07c738afe1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[275212, 7517, 575, 14, 30, "Input",ExpressionUUID->"d0141039-8549-44da-ab7e-e5d4ec37fde0"],
Cell[275790, 7533, 2156, 63, 59, "Output",ExpressionUUID->"adc32ac3-1e49-4aaa-98e2-c19a7a9e991b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[277983, 7601, 453, 11, 30, "Input",ExpressionUUID->"0fb4257a-3e37-400c-bdd2-558872a5cbd7"],
Cell[278439, 7614, 1571, 44, 60, "Output",ExpressionUUID->"318457b1-e3c1-42b6-8ea8-a9d3a3a65be5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[280047, 7663, 317, 8, 30, "Input",ExpressionUUID->"3704631b-3991-464f-ace4-c07713ec0c8d"],
Cell[280367, 7673, 225, 3, 34, "Output",ExpressionUUID->"16ea9730-dcf3-4be8-9e9b-078e785326c6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[280629, 7681, 498, 11, 30, "Input",ExpressionUUID->"d8895f1d-c0aa-4d33-b61a-9eaa5f7cf37b"],
Cell[281130, 7694, 346, 5, 34, "Output",ExpressionUUID->"3b629a16-8eed-4d61-9986-65965e61e529"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[281525, 7705, 229, 4, 67, "Section",ExpressionUUID->"a43bc5d9-4068-4c5e-a210-01162bc20220"],
Cell[281757, 7711, 880, 25, 50, "Input",ExpressionUUID->"5f3a8e0b-aae1-4a3a-9e4b-806a58a02f93"],
Cell[282640, 7738, 970, 30, 50, "Input",ExpressionUUID->"5c55761c-ba9e-4032-862f-f5339cfdc601"],
Cell[283613, 7770, 425, 10, 30, "Input",ExpressionUUID->"66b50f2d-e065-47c4-9d35-6926912184ed"],
Cell[CellGroupData[{
Cell[284063, 7784, 286, 6, 30, "Input",ExpressionUUID->"682028e7-e151-4614-97d7-a57c04dfad82"],
Cell[284352, 7792, 252, 3, 34, "Output",ExpressionUUID->"94892163-78c9-4269-bf5e-638cad973b56"]
}, Open  ]],
Cell[284619, 7798, 288, 6, 30, "Input",ExpressionUUID->"1ed3711f-9fb1-4ca7-833a-24deef73fb86"],
Cell[284910, 7806, 579, 16, 30, "Input",ExpressionUUID->"65c0ce6a-2934-417e-a1f1-bab50ab2e273"],
Cell[CellGroupData[{
Cell[285514, 7826, 1672, 43, 52, "Input",ExpressionUUID->"484addf5-fd69-4484-8639-b590b1ffac43"],
Cell[287189, 7871, 968, 17, 56, "Output",ExpressionUUID->"3a3056fa-580d-4333-88ef-79fa3afa94dc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[288194, 7893, 621, 17, 30, "Input",ExpressionUUID->"a4770e8f-b5f7-46e5-aebf-015647d6f039"],
Cell[288818, 7912, 3750, 78, 251, "Output",ExpressionUUID->"b38c5b6e-ed64-4f0e-8e70-f3ad424631ea"]
}, Open  ]],
Cell[292583, 7993, 656, 17, 30, "Input",ExpressionUUID->"6c551852-e8be-4f7d-8d98-797a6635cbd0"],
Cell[293242, 8012, 1776, 44, 52, "Input",ExpressionUUID->"54e7c521-e2f9-4464-a0be-d0bc90c8f830"],
Cell[CellGroupData[{
Cell[295043, 8060, 814, 22, 30, "Input",ExpressionUUID->"9eed5a6b-8e7f-418c-b312-cb75311d5d59"],
Cell[295860, 8084, 3843, 79, 244, "Output",ExpressionUUID->"3d0781d6-ba38-4243-a7f9-e1314802c79c"]
}, Open  ]],
Cell[299718, 8166, 482, 14, 30, "Input",ExpressionUUID->"f6c5b51c-b33c-4203-833a-1f37b63700fc"],
Cell[300203, 8182, 1572, 42, 94, "Input",ExpressionUUID->"32c6f5ea-a416-4072-a7f4-20ce3f6b4b5c"],
Cell[CellGroupData[{
Cell[301800, 8228, 950, 22, 30, "Input",ExpressionUUID->"15f5dfea-e348-488d-b014-670a219ab6bd"],
Cell[302753, 8252, 3958, 84, 226, "Output",ExpressionUUID->"93d67e53-c490-407e-a6bb-7771cf79ab15"]
}, Open  ]],
Cell[306726, 8339, 1670, 43, 94, "Input",ExpressionUUID->"fd518bd4-2095-420b-ac7e-75b27c35190a"],
Cell[CellGroupData[{
Cell[308421, 8386, 1030, 23, 30, "Input",ExpressionUUID->"aa8c3989-6420-48bf-88ba-2831b597296b"],
Cell[309454, 8411, 4130, 85, 226, "Output",ExpressionUUID->"49d3e221-3de8-4052-8786-9464bb9d2ed0"]
}, Open  ]],
Cell[313599, 8499, 486, 15, 30, "Input",ExpressionUUID->"88f42f28-0732-479a-a1df-53f4f1b57969"],
Cell[CellGroupData[{
Cell[314110, 8518, 2822, 79, 115, "Input",ExpressionUUID->"540ab55e-10bf-49a2-b16b-deeac919936b"],
Cell[316935, 8599, 483, 11, 46, "Message",ExpressionUUID->"915a5bd3-7567-49ed-bc55-afdfe5352fc8"],
Cell[317421, 8612, 1031, 18, 97, "Message",ExpressionUUID->"2b9d5aa1-4c9f-4d4a-8747-8ac0ca8b90ed"],
Cell[318455, 8632, 483, 11, 46, "Message",ExpressionUUID->"d1d359f0-2b03-4882-b17e-1223ffb2e276"],
Cell[318941, 8645, 1031, 18, 97, "Message",ExpressionUUID->"904add7c-405f-4fd2-a3ca-612c14489aa5"],
Cell[319975, 8665, 485, 11, 46, "Message",ExpressionUUID->"925872e1-f023-491c-9adf-18499b347322"],
Cell[320463, 8678, 456, 10, 28, "Message",ExpressionUUID->"ae9005e5-f88a-4884-83ef-be301440737e"],
Cell[320922, 8690, 1030, 18, 97, "Message",ExpressionUUID->"d6a0fb96-6885-4777-9b1c-a87be1ab5e77"],
Cell[321955, 8710, 456, 10, 28, "Message",ExpressionUUID->"10119b88-eb1c-475a-b7c2-e17f94b2278f"]
}, Closed]],
Cell[CellGroupData[{
Cell[322448, 8725, 644, 16, 26, "Input",ExpressionUUID->"f7c67ca6-fe46-42e5-a73a-485906c5e2d8"],
Cell[323095, 8743, 4090, 84, 246, "Output",ExpressionUUID->"d3d06c67-d111-4f12-a93a-4456c7009563"]
}, Open  ]],
Cell[327200, 8830, 151, 3, 30, "Input",ExpressionUUID->"75f4136a-fac5-4dde-800d-6e811ce857e6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[327388, 8838, 154, 3, 67, "Section",ExpressionUUID->"f5dc355d-249f-4dd6-a8ce-b4d956ac5a0b"],
Cell[327545, 8843, 267, 6, 30, "Input",ExpressionUUID->"c56ff23a-7d74-40fa-b93e-a5d1a28eb054"],
Cell[327815, 8851, 791, 21, 33, "Input",ExpressionUUID->"67aa2ef0-6792-49b7-8e54-84038f1d7e39"],
Cell[328609, 8874, 243, 5, 30, "Input",ExpressionUUID->"a3a3a713-3a3d-4615-8138-a0f988f34bcd"],
Cell[328855, 8881, 1464, 40, 58, "Input",ExpressionUUID->"f35c2e4c-2e15-4748-af27-e6527eaf4006"],
Cell[330322, 8923, 241, 5, 30, "Input",ExpressionUUID->"c5856256-bfea-48f7-9c66-6186a853f3e9"],
Cell[330566, 8930, 1750, 47, 60, "Input",ExpressionUUID->"1f1f8776-8112-4eba-a0ca-b701686019a7"],
Cell[332319, 8979, 239, 5, 30, "Input",ExpressionUUID->"ccda7993-9ee5-4a06-840e-f08742bdc46b"],
Cell[332561, 8986, 1463, 40, 58, "Input",ExpressionUUID->"00bf0cc3-eb14-47ec-ac26-9004e91d1723"],
Cell[334027, 9028, 257, 7, 30, "Input",ExpressionUUID->"6ad89f0c-09aa-4383-92dd-2903a2b481a4"],
Cell[334287, 9037, 494, 13, 30, InheritFromParent,ExpressionUUID->"4c20d5c1-359e-42ac-8862-29cb3c61d809"],
Cell[334784, 9052, 423, 11, 34, "Output",ExpressionUUID->"8830496a-280d-453e-b84a-eaaa29466023"],
Cell[335210, 9065, 254, 5, 30, "Input",ExpressionUUID->"06c64049-650c-4639-9602-e670150e8658"],
Cell[335467, 9072, 2140, 61, 73, InheritFromParent,ExpressionUUID->"77ec103c-f9c5-4c02-b31d-fbd18a24575e"],
Cell[337610, 9135, 2016, 58, 77, "Output",ExpressionUUID->"7d391aae-faf0-4be1-bac9-5af798b1b693"],
Cell[339629, 9195, 253, 5, 30, "Input",ExpressionUUID->"d61bca64-6b5c-4f43-90e3-43d1a25822d9"],
Cell[339885, 9202, 2539, 72, 79, InheritFromParent,ExpressionUUID->"47e9321c-414b-402b-985f-d0fc76328896"],
Cell[342427, 9276, 2410, 71, 82, "Output",ExpressionUUID->"a619aa82-570f-4567-95ed-6dd62435a1b6"],
Cell[344840, 9349, 254, 5, 30, "Input",ExpressionUUID->"fedefe62-c57e-46a2-a309-1fb688d1b12b"],
Cell[345097, 9356, 2192, 60, 75, InheritFromParent,ExpressionUUID->"2cacbd12-cac8-4afb-a23b-7d0989e8cf26"],
Cell[347292, 9418, 2071, 58, 74, "Output",ExpressionUUID->"1892c205-d16d-4372-a30c-ba8888927454"],
Cell[CellGroupData[{
Cell[349388, 9480, 253, 5, 30, "Input",ExpressionUUID->"ee7ea875-287e-41b9-86c0-b375ef04db37"],
Cell[349644, 9487, 3120, 87, 103, "Output",ExpressionUUID->"a1b679cb-3495-41af-91ff-2b21991d265f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[352801, 9579, 325, 8, 30, "Input",ExpressionUUID->"57cee8ea-249c-4662-9438-d516814b13d8"],
Cell[353129, 9589, 4799, 136, 152, "Output",ExpressionUUID->"ed11dbbf-ef99-4f86-b8f5-42e7ea5cfe38"]
}, Open  ]],
Cell[CellGroupData[{
Cell[357965, 9730, 252, 5, 30, "Input",ExpressionUUID->"d21c35ab-3c60-4901-9058-e753aba55d48"],
Cell[358220, 9737, 1281, 39, 59, "Output",ExpressionUUID->"bfec3d76-c66f-4824-a0a4-c8d92a49ecaa"]
}, Open  ]],
Cell[CellGroupData[{
Cell[359538, 9781, 184, 3, 30, "Input",ExpressionUUID->"883ecdb6-f2bd-4243-bf33-665e673f27ef"],
Cell[359725, 9786, 508, 14, 34, "Output",ExpressionUUID->"ba7123cd-eff4-4943-825f-71b111f09616"]
}, Open  ]],
Cell[360248, 9803, 152, 3, 30, "Input",ExpressionUUID->"c96e53f4-3289-4d4a-b7d9-e3cbca910133"]
}, Open  ]]
}
]
*)

