(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    731800,      15080]
NotebookOptionsPosition[    718730,      14847]
NotebookOutlinePosition[    719223,      14865]
CellTagsIndexPosition[    719180,      14862]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Single Qubit  Forth-back", "Subsection",
 CellChangeTimes->{{3.9122401150591784`*^9, 3.912240116242973*^9}, {
  3.9122416660906863`*^9, 3.9122416702664504`*^9}, {3.9122417339545045`*^9, 
  3.912241737380411*^9}},ExpressionUUID->"922f0fc0-da37-406e-b485-\
26a77a06fb07"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rule", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Kappa]", "t"], "->", "1"}], ",", 
     RowBox[{
      SubscriptBox["\[Kappa]", "x"], "->", "1"}], ",", 
     RowBox[{"T", "->", "\[Beta]"}], ",", 
     RowBox[{"v", "->", 
      RowBox[{"\[Gamma]", "/", "\[Beta]"}]}], ",", 
     RowBox[{"d", "->", "\[Epsilon]"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9121497911816845`*^9, 3.912149797404353*^9}, {
  3.912659924226326*^9, 3.912659932630414*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"f1daed48-919e-4e87-9806-f1e9977bed14"],

Cell[BoxData[
 RowBox[{
  RowBox[{"inverserule", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Beta]", "->", 
      RowBox[{"T", " ", 
       SubscriptBox["\[Kappa]", "t"]}]}], ",", 
     RowBox[{"\[Gamma]", "->", 
      RowBox[{"L", " ", 
       SubscriptBox["\[Kappa]", "x"]}]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.913902021277198*^9, 3.9139020552077413`*^9}, {
  3.9139022532956934`*^9, 3.913902258871632*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"313348a7-4e6a-409b-b778-4f47af644f48"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"I1", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["\[Kappa]", "t"], "+", 
          RowBox[{
           SubscriptBox["\[Kappa]", "x"], "v"}]}], ")"}]}], 
       RowBox[{"Abs", "[", 
        RowBox[{
         SubscriptBox["t", "1"], "-", 
         SubscriptBox["t", "2"]}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", "0", ",", "T"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", "0", ",", "T"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"T", ">", "0"}], ",", 
        RowBox[{"v", ">", "0"}], ",", 
        RowBox[{
         SubscriptBox["\[Kappa]", "t"], ">", "0"}], ",", 
        RowBox[{
         SubscriptBox["\[Kappa]", "x"], ">", "0"}]}], "}"}]}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.9116406794949894`*^9, 3.9116407486061687`*^9}, {
  3.912149758467888*^9, 3.9121497601564255`*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"d57ba805-1bd4-4ae2-a288-96f3e5bd946a"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "T"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[Kappa]", "t"], "+", 
         RowBox[{"v", " ", 
          SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]], "+", 
     RowBox[{"T", " ", 
      SubscriptBox["\[Kappa]", "t"]}], "+", 
     RowBox[{"T", " ", "v", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Kappa]", "t"], "+", 
     RowBox[{"v", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}], ")"}], "2"]]], "Output",
 CellChangeTimes->{{3.9116407400347443`*^9, 3.91164075039948*^9}, 
   3.9121482249153247`*^9, 3.9121497638177605`*^9, 3.91224206140009*^9, 
   3.9125060491754074`*^9, 3.9139002579992356`*^9, 3.917923191010621*^9},
 CellLabel->"Out[3]=",ExpressionUUID->"3488e04e-fb42-4134-9bc3-0143e472e3b1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"I1", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["\[Kappa]", "t"], "+", 
          RowBox[{
           SubscriptBox["\[Kappa]", "x"], "v"}]}], ")"}]}], 
       RowBox[{"Abs", "[", 
        RowBox[{
         SubscriptBox["t", "1"], "-", 
         SubscriptBox["t", "2"]}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", "T", ",", 
       RowBox[{"2", "T"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", "T", ",", 
       RowBox[{"2", "T"}]}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"T", ">", "0"}], ",", 
        RowBox[{"v", ">", "0"}], ",", 
        RowBox[{
         SubscriptBox["\[Kappa]", "t"], ">", "0"}], ",", 
        RowBox[{
         SubscriptBox["\[Kappa]", "x"], ">", "0"}]}], "}"}]}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.9116407899069796`*^9, 3.9116407924180374`*^9}, {
  3.912149762819853*^9, 3.9121497661959257`*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"857dbaf2-42a5-4e36-8a88-c0a50de71a9a"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "T"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[Kappa]", "t"], "+", 
         RowBox[{"v", " ", 
          SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]], "+", 
     RowBox[{"T", " ", 
      SubscriptBox["\[Kappa]", "t"]}], "+", 
     RowBox[{"T", " ", "v", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Kappa]", "t"], "+", 
     RowBox[{"v", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}], ")"}], "2"]]], "Output",
 CellChangeTimes->{3.9116407960204897`*^9, 3.9121482286056867`*^9, 
  3.9121497706199565`*^9, 3.9125060527676663`*^9, 3.9139002603639297`*^9, 
  3.917923192664557*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"370f0ff6-0117-4a46-a2c9-6cb9c1f793e4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"I2", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", " ", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["t", "2"], "-", 
          SubscriptBox["t", "1"]}], ")"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], "v", " ", 
        RowBox[{"Abs", "[", 
         RowBox[{
          SubscriptBox["t", "1"], "+", 
          SubscriptBox["t", "2"], "-", 
          RowBox[{"2", "T"}]}], "]"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", "0", ",", "T"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", "T", ",", 
       RowBox[{"2", "T"}]}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"T", ">", "0"}], ",", 
        RowBox[{"v", ">", "0"}], ",", 
        RowBox[{
         SubscriptBox["\[Kappa]", "t"], ">", "0"}], ",", 
        RowBox[{
         SubscriptBox["\[Kappa]", "x"], ">", "0"}]}], "}"}]}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.9116408135514393`*^9, 3.91164088740675*^9}, {
  3.9121497701004825`*^9, 3.9121497710753703`*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"bab6a323-3fb6-4ac8-abec-afcbecfb47ce"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", "T", " ", 
        SubscriptBox["\[Kappa]", "t"]}]], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "T"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Kappa]", "t"], "+", 
           RowBox[{"v", " ", 
            SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]]}]}], ")"}], " ", 
    SubscriptBox["\[Kappa]", "t"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", "T", " ", 
        SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", "v", " ", 
    SubscriptBox["\[Kappa]", "x"]}]}], 
  RowBox[{
   SubsuperscriptBox["\[Kappa]", "t", "3"], "-", 
   RowBox[{
    SuperscriptBox["v", "2"], " ", 
    SubscriptBox["\[Kappa]", "t"], " ", 
    SubsuperscriptBox["\[Kappa]", "x", "2"]}]}]]], "Output",
 CellChangeTimes->{{3.9116408615970526`*^9, 3.9116408893245573`*^9}, 
   3.912148233705331*^9, 3.9121497771659184`*^9, 3.912242066694014*^9, 
   3.912506057782217*^9, 3.913900263729351*^9, 3.9179231951495743`*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"6f60de64-2d34-4621-a274-d24d02f554e4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"I2", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", " ", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["t", "1"], "-", 
          SubscriptBox["t", "2"]}], ")"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], "v", " ", 
        RowBox[{"Abs", "[", 
         RowBox[{
          SubscriptBox["t", "1"], "+", 
          SubscriptBox["t", "2"], "-", 
          RowBox[{"2", "T"}]}], "]"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", "T", ",", 
       RowBox[{"2", "T"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", "0", ",", "T"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"T", ">", "0"}], ",", 
        RowBox[{"v", ">", "0"}], ",", 
        RowBox[{
         SubscriptBox["\[Kappa]", "t"], ">", "0"}], ",", 
        RowBox[{
         SubscriptBox["\[Kappa]", "x"], ">", "0"}]}], "}"}]}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.9116408940772734`*^9, 3.9116409055379105`*^9}, 
   3.9121497748207827`*^9},
 CellLabel->"In[6]:=",ExpressionUUID->"29ef21da-1a85-4895-a409-67687107c986"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", "T", " ", 
        SubscriptBox["\[Kappa]", "t"]}]], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "T"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Kappa]", "t"], "+", 
           RowBox[{"v", " ", 
            SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]]}]}], ")"}], " ", 
    SubscriptBox["\[Kappa]", "t"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", "T", " ", 
        SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", "v", " ", 
    SubscriptBox["\[Kappa]", "x"]}]}], 
  RowBox[{
   SubsuperscriptBox["\[Kappa]", "t", "3"], "-", 
   RowBox[{
    SuperscriptBox["v", "2"], " ", 
    SubscriptBox["\[Kappa]", "t"], " ", 
    SubsuperscriptBox["\[Kappa]", "x", "2"]}]}]]], "Output",
 CellChangeTimes->{3.911640909550102*^9, 3.9121482393704915`*^9, 
  3.9121497829201603`*^9, 3.9125060633502684`*^9, 3.913900267373919*^9, 
  3.917923197926798*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"ef8f1701-18eb-426e-8607-e33f53a52a00"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"I1", "/.", "rule"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.9116409199074764`*^9, 3.911640946385668*^9}, {
  3.9116409872429543`*^9, 3.911640991892671*^9}, {3.912148493554014*^9, 
  3.912148512020835*^9}, {3.9121497803638325`*^9, 3.912149817411576*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"4543d6e5-524e-4f58-8fdc-c4464f4698c2"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SuperscriptBox["\[Beta]", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]"}]], "+", "\[Beta]", "+", 
     "\[Gamma]"}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}], "2"]]], "Output",
 CellChangeTimes->{{3.911640921166565*^9, 3.911640948446685*^9}, 
   3.911640992696441*^9, {3.912148495277584*^9, 3.9121485122830734`*^9}, {
   3.912149782967202*^9, 3.9121498077147436`*^9}, 3.9125060634163284`*^9, 
   3.913900267433772*^9, 3.9179231979757357`*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"4a9ce4e0-390c-4c21-861c-8c1ef13b12ce"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"I2", "/.", "rule"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.912148519169346*^9, 3.9121485612696934`*^9}, {
  3.91214978314036*^9, 3.9121498055077333`*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"037de661-c086-4034-a5af-afee974da963"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[Beta]"}], "-", "\[Gamma]"}]], " ", 
   "\[Beta]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["\[ExponentialE]", "\[Beta]"], " ", "\[Beta]"}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"2", " ", "\[Beta]"}], "+", "\[Gamma]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "\[Gamma]"], " ", 
      RowBox[{"(", 
       RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}]}]}], ")"}]}], 
  RowBox[{
   SuperscriptBox["\[Beta]", "2"], "-", 
   SuperscriptBox["\[Gamma]", "2"]}]]], "Output",
 CellChangeTimes->{{3.912148542264383*^9, 3.9121485614678745`*^9}, {
   3.912149783836994*^9, 3.9121498060722475`*^9}, 3.9125060634513597`*^9, 
   3.917923197997555*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"fe5a1ddd-7e0b-44e0-b046-73c28c05eff6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "+", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "2"}], " ", "T", " ", 
     SubscriptBox["\[Kappa]", "t"]}]], "-", 
   RowBox[{"2", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "T"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["\[Kappa]", "t"], "+", 
        RowBox[{"v", " ", 
         SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", "T", " ", 
        SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", "v", " ", 
    RowBox[{
     SubscriptBox["\[Kappa]", "x"], "/", 
     SubscriptBox["\[Kappa]", "t"]}]}]}], "/.", "rule"}]], "Input",
 CellChangeTimes->{{3.9139010212673435`*^9, 3.913901044536482*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"701bebb8-6033-4b35-9fb1-6c7ffa0d81ac"],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[Beta]"}]], "-", 
  RowBox[{"2", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[Beta]"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       FractionBox["\[Gamma]", "\[Beta]"]}], ")"}]}]]}], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", "\[Beta]"}]]}], ")"}], " ", "\[Gamma]"}], 
   "\[Beta]"]}]], "Output",
 CellChangeTimes->{{3.9139010229878197`*^9, 3.913901045943165*^9}, 
   3.917923198006421*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"dbc512df-8dc8-4ee1-864f-9e91bae54c02"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubsuperscriptBox["\[Kappa]", "t", "2"], "-", 
   RowBox[{
    SuperscriptBox["v", "2"], " ", 
    SubsuperscriptBox["\[Kappa]", "x", "2"]}]}], "/.", "rule"}]], "Input",
 CellChangeTimes->{{3.913901327317073*^9, 3.913901333364462*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"55854080-ed13-45e6-afed-591556c108a7"],

Cell[BoxData[
 RowBox[{"1", "-", 
  FractionBox[
   SuperscriptBox["\[Gamma]", "2"], 
   SuperscriptBox["\[Beta]", "2"]]}]], "Output",
 CellChangeTimes->{3.91390133420286*^9, 3.9179231980262327`*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"5604f655-500f-4a24-bb4d-dd308c7a5e3e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ReplaceAll", "[", 
    RowBox[{
     RowBox[{
      FractionBox["1", 
       SuperscriptBox[
        SubscriptBox["\[Kappa]", "t"], "2"]], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "2"}], " ", "\[Beta]"}]], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "\[Beta]"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              FractionBox["\[Gamma]", "\[Beta]"]}], ")"}]}]]}], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"-", "2"}], " ", "\[Beta]"}]]}], ")"}], " ", 
           "\[Gamma]"}], "\[Beta]"]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         FractionBox[
          SuperscriptBox["\[Gamma]", "2"], 
          SuperscriptBox["\[Beta]", "2"]]}], ")"}]}]}], ",", "inverserule"}], 
    "]"}], "==", 
   RowBox[{"ReplaceAll", "[", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", "T", " ", 
            SubscriptBox["\[Kappa]", "t"]}]], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "T"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SubscriptBox["\[Kappa]", "t"], "+", 
               RowBox[{"v", " ", 
                SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]]}]}], ")"}], " ", 
        SubscriptBox["\[Kappa]", "t"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", "T", " ", 
            SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", "v", " ", 
        SubscriptBox["\[Kappa]", "x"]}]}], 
      RowBox[{
       SubsuperscriptBox["\[Kappa]", "t", "3"], "-", 
       RowBox[{
        SuperscriptBox["v", "2"], " ", 
        SubscriptBox["\[Kappa]", "t"], " ", 
        SubsuperscriptBox["\[Kappa]", "x", "2"]}]}]], ",", 
     RowBox[{"v", "->", 
      RowBox[{"L", "/", "T"}]}]}], "]"}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.913902063350836*^9, 3.9139020684284863`*^9}, {
  3.9139024160167003`*^9, 3.913902469943485*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"17b27775-08c4-4026-8c2e-9cff28f9ff2c"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.913902428328005*^9, 3.913902470250913*^9}, 
   3.917923198087132*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"04c0f7c7-4a62-4ae4-bebe-a174176de029"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Forth-back with Spin Echo", "Subsubsection",
 CellChangeTimes->{{3.9223393094197617`*^9, 
  3.9223393246589837`*^9}},ExpressionUUID->"59afaaa5-33a6-4b6f-b2cf-\
ef9fc694b114"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"I1", "+", "I2"}]], "Input",
 CellChangeTimes->{{3.9121498429428315`*^9, 3.912149843931732*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"9a4e9320-8ef5-4f4b-8fb6-876b57e7314e"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "T"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["\[Kappa]", "t"], "+", 
          RowBox[{"v", " ", 
           SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]], "+", 
      RowBox[{"T", " ", 
       SubscriptBox["\[Kappa]", "t"]}], "+", 
      RowBox[{"T", " ", "v", " ", 
       SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["\[Kappa]", "t"], "+", 
      RowBox[{"v", " ", 
       SubscriptBox["\[Kappa]", "x"]}]}], ")"}], "2"]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "2"}], " ", "T", " ", 
         SubscriptBox["\[Kappa]", "t"]}]], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "T"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["\[Kappa]", "t"], "+", 
            RowBox[{"v", " ", 
             SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]]}]}], ")"}], " ", 
     SubscriptBox["\[Kappa]", "t"]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "2"}], " ", "T", " ", 
         SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", "v", " ", 
     SubscriptBox["\[Kappa]", "x"]}]}], 
   RowBox[{
    SubsuperscriptBox["\[Kappa]", "t", "3"], "-", 
    RowBox[{
     SuperscriptBox["v", "2"], " ", 
     SubscriptBox["\[Kappa]", "t"], " ", 
     SubsuperscriptBox["\[Kappa]", "x", "2"]}]}]]}]], "Output",
 CellChangeTimes->{3.912149844324089*^9, 3.9125060633863015`*^9, 
  3.9139002673993225`*^9, 3.91792319809438*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"822adb37-303b-4f22-9dd2-cda65219fed2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"I1", "-", "I2"}]], "Input",
 CellChangeTimes->{{3.9139003039741592`*^9, 3.9139003049900103`*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"1440caa6-b348-4c24-a77f-2038b2c03259"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "T"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["\[Kappa]", "t"], "+", 
          RowBox[{"v", " ", 
           SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]], "+", 
      RowBox[{"T", " ", 
       SubscriptBox["\[Kappa]", "t"]}], "+", 
      RowBox[{"T", " ", "v", " ", 
       SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["\[Kappa]", "t"], "+", 
      RowBox[{"v", " ", 
       SubscriptBox["\[Kappa]", "x"]}]}], ")"}], "2"]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "2"}], " ", "T", " ", 
         SubscriptBox["\[Kappa]", "t"]}]], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "T"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["\[Kappa]", "t"], "+", 
            RowBox[{"v", " ", 
             SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]]}]}], ")"}], " ", 
     SubscriptBox["\[Kappa]", "t"]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "2"}], " ", "T", " ", 
         SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", "v", " ", 
     SubscriptBox["\[Kappa]", "x"]}]}], 
   RowBox[{
    SubsuperscriptBox["\[Kappa]", "t", "3"], "-", 
    RowBox[{
     SuperscriptBox["v", "2"], " ", 
     SubscriptBox["\[Kappa]", "t"], " ", 
     SubsuperscriptBox["\[Kappa]", "x", "2"]}]}]]}]], "Output",
 CellChangeTimes->{3.9139003068022947`*^9, 3.917923198111854*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"e1139607-7a61-4b39-9cbf-70a53b8f645f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Analytical solution with dimensionless units", "Subsubsection",
 CellChangeTimes->{{3.9223393288999257`*^9, 
  3.9223393416752214`*^9}},ExpressionUUID->"6a97360d-7a5a-4755-9d2d-\
77d66b5f4674"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CurlyPhi]", "[", 
   RowBox[{"\[Beta]_", ",", "\[Gamma]_"}], "]"}], ":=", " ", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["\[Beta]", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]"}]], "+", "\[Beta]", "+", 
       "\[Gamma]"}], ")"}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}], "2"]], "+", 
   FractionBox[
    RowBox[{" ", 
     RowBox[{"\[Beta]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]"}]], " ", "\[Beta]"}], 
        "+", " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}], "+", " ", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "2"}], "\[Beta]"}]], 
         RowBox[{"(", 
          RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}]}]}], ")"}]}]}], 
    RowBox[{
     SuperscriptBox["\[Beta]", "2"], "-", 
     SuperscriptBox["\[Gamma]", "2"]}]]}]}]], "Input",
 CellChangeTimes->{{3.9121485759530673`*^9, 3.9121485983955126`*^9}, {
   3.912148903618559*^9, 3.912148925003037*^9}, {3.912149091386588*^9, 
   3.912149094107066*^9}, {3.912150064892379*^9, 3.9121500889522924`*^9}, {
   3.91215011934898*^9, 3.912150142013624*^9}, {3.912150229132977*^9, 
   3.912150270702841*^9}, 3.913900361213545*^9},
 CellLabel->"In[2]:=",ExpressionUUID->"1612c542-715d-4057-aea4-5460a2a8edce"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Phi]", "[", 
   RowBox[{"\[Beta]_", ",", "\[Gamma]_"}], "]"}], ":=", " ", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["\[Beta]", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]"}]], "+", "\[Beta]", "+", 
       "\[Gamma]"}], ")"}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}], "2"]], "-", 
   FractionBox[
    RowBox[{" ", 
     RowBox[{"\[Beta]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]"}]], " ", "\[Beta]"}], 
        "+", " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}], "+", " ", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "2"}], "\[Beta]"}]], 
         RowBox[{"(", 
          RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}]}]}], ")"}]}]}], 
    RowBox[{
     SuperscriptBox["\[Beta]", "2"], "-", 
     SuperscriptBox["\[Gamma]", "2"]}]]}]}]], "Input",
 CellChangeTimes->{{3.912149098346927*^9, 3.9121491045225525`*^9}, {
   3.9139003317623844`*^9, 3.91390033192836*^9}, 3.9139003706617537`*^9},
 CellLabel->"In[1]:=",ExpressionUUID->"e2472a10-2dff-45a1-9c6c-c1701e52bce4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{" ", 
     RowBox[{"\[Beta]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]"}]], " ", "\[Beta]"}], 
        "+", " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}], "+", " ", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "2"}], "\[Beta]"}]], 
         RowBox[{"(", 
          RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}]}]}], ")"}]}]}], 
    RowBox[{
     SuperscriptBox["\[Beta]", "2"], "-", 
     SuperscriptBox["\[Gamma]", "2"]}]], ",", 
   RowBox[{"\[Gamma]", "->", "\[Infinity]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9239844984207473`*^9, 3.92398451035986*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"525c957c-e32d-4258-88c1-57b69bee0dce"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.9239845111456423`*^9},
 CellLabel->"Out[1]=",ExpressionUUID->"02b36850-32e8-43ed-a3d4-8a2ad0a676e7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{" ", 
      RowBox[{"\[Beta]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]"}]], " ", "\[Beta]"}], 
         "+", " ", 
         RowBox[{"(", 
          RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}], "+", " ", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], "\[Beta]"}]], 
          RowBox[{"(", 
           RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}]}]}], ")"}]}]}], 
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], "-", 
      SuperscriptBox["\[Gamma]", "2"]}]], "/.", 
    RowBox[{"\[Beta]", "->", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Gamma]", ",", "0", ",", "1000"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.923984515118929*^9, 3.9239845914437404`*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"ee662530-05fb-4b5e-bc70-d24aceeb3a02"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2], 
         Opacity[1.], LineBox[CompressedData["
1:eJwVjnk81Akfx4Vsk9ZRlAgxkiQ8SLFN329bq9Iv5BjNYBjjXjHDYIzJOeMq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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
      Slot["HighlightElements"], 
      Slot["LayoutOptions"], 
      Slot["Meta"], 
      Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
          Annotation[{
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]], 
            Line[CompressedData["
1:eJwVjnk81Akfx4Vsk9ZRlAgxkiQ8SLFN329bq9Iv5BjNYBjjXjHDYIzJOeMq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             "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{0, 1000}, {0.0008635302626103274, 
            0.010513469553891337`}}, 
          "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {0, 0.0008635302626103294}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>]]& )[<|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0, 1000}, {0.0008635302626103274, 
           0.010513469553891337`}}, 
         "Frame" -> {{False, False}, {False, False}}, 
         "AxesOrigin" -> {0, 0.0008635302626103294}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>],
     ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
      4.503599627370496*^15, -4.503599627370496*^15}}]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]], 
         Line[CompressedData["
1:eJwVjnk81Akfx4Vsk9ZRlAgxkiQ8SLFN329bq9Iv5BjNYBjjXjHDYIzJOeMq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          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PlotRange" -> {{0, 1000}, {0.0008635302626103274, 
         0.010513469553891337`}}, "Frame" -> {{False, False}, {False, False}},
        "AxesOrigin" -> {0, 0.0008635302626103294}, 
       "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
       "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0.0008635302626103294},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1000}, {0.0008635302626103274, 0.010513469553891337`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.9239845155920963`*^9, 3.9239845917449365`*^9}},
 CellLabel->"Out[11]=",ExpressionUUID->"9318c9d2-0e9a-4d0b-a62a-434d576f53ed"]
}, Open  ]],

Cell["Difference between one-way and forth-back", "Text",
 CellChangeTimes->{{3.922449159587438*^9, 
  3.9224491733154335`*^9}},ExpressionUUID->"d46228a6-0e75-4e6d-ac79-\
17ae7b226b1f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[CurlyPhi]", "[", 
    RowBox[{"\[Beta]", ",", "\[Gamma]"}], "]"}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[CurlyPhi]", "[", 
       RowBox[{
        RowBox[{"2", "\[Beta]"}], ",", 
        RowBox[{"2", "\[Gamma]"}]}], "]"}], "+", 
      RowBox[{"\[Phi]", "[", 
       RowBox[{
        RowBox[{"2", "\[Beta]"}], ",", 
        RowBox[{"2", "\[Gamma]"}]}], "]"}]}], ")"}], "/", "4"}]}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.917924075433548*^9, 3.917924140714086*^9}, {
  3.9179241862653522`*^9, 3.917924186592766*^9}},
 CellLabel->"In[54]:=",ExpressionUUID->"89cec52f-2509-4520-b364-456935cf9dc5"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     RowBox[{"(", 
      RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}]}]], " ", "\[Beta]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[Beta]", "+", "\[Gamma]"}]], " ", "\[Beta]", " ", 
      "\[Gamma]"}], "+", 
     RowBox[{"\[Beta]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "\[Beta]"}], "+", "\[Gamma]"}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[Gamma]"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "\[Beta]"}]], " ", 
         RowBox[{"(", 
          RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}], " ", "\[Gamma]"}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}], "2"]}], ")"}]}]}], 
    ")"}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}], "2"]}]]], "Output",
 CellChangeTimes->{{3.917924077027104*^9, 3.9179241414238234`*^9}, 
   3.9179241897771187`*^9},
 CellLabel->"Out[54]=",ExpressionUUID->"e59ad4bd-d077-4cbf-841a-a264d3754ef1"]
}, Open  ]],

Cell["Asymptotics at large velocity ", "Text",
 CellChangeTimes->{{3.922449178155566*^9, 
  3.9224491867394485`*^9}},ExpressionUUID->"000073d1-73d1-4fcc-9ee6-\
4fd86af5a2f5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Asymptotic", "[", 
     RowBox[{
      RowBox[{"\[CurlyPhi]", "[", 
       RowBox[{"\[Beta]", ",", "\[Gamma]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Gamma]", ",", "\[Infinity]", ",", "1"}], "}"}]}], "]"}], 
    ",", 
    RowBox[{"\[Beta]", ">", "0"}]}], "]"}], 
  RowBox[{"(*", " ", 
   RowBox[{"fix", " ", "u"}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.9224492081714664`*^9, 3.922449219148527*^9}, {
  3.9224492702285433`*^9, 3.9224492952675705`*^9}, {3.9224495322608557`*^9, 
  3.9224495566758623`*^9}, {3.922449602540619*^9, 3.9224496040685635`*^9}, {
  3.9224496437889814`*^9, 3.9224496491635838`*^9}, {3.9224497245005455`*^9, 
  3.9224497598122115`*^9}, {3.922449815389152*^9, 3.922449831820191*^9}, {
  3.9224500203493814`*^9, 
  3.9224500321264243`*^9}},ExpressionUUID->"0dcc53df-3541-4a01-a81f-\
e9fc7c62f2ff"],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[Beta]", " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[Beta]"}]], "+", 
     RowBox[{"2", " ", "\[Beta]"}]}], ")"}]}], "\[Gamma]"]], "Output",
 CellChangeTimes->{
  3.9224492195545406`*^9, {3.922449273147645*^9, 3.9224492959214067`*^9}, {
   3.9224495350100965`*^9, 3.9224495569599223`*^9}, 3.9224496499430776`*^9, {
   3.922449727196108*^9, 3.922449760209337*^9}},
 CellLabel->"Out[63]=",ExpressionUUID->"4dd6b15a-41d6-41e2-8fd1-f8e1378679b6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Asymptotic", "[", 
   RowBox[{
    RowBox[{"\[CurlyPhi]", "[", 
     RowBox[{
      RowBox[{"\[Gamma]", "/", "u"}], ",", "\[Gamma]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"u", ",", "\[Infinity]", ",", "2"}], "}"}]}], "]"}], " ", 
  RowBox[{"(*", 
   RowBox[{"fix", " ", "gamma"}], "*)"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.9224492403242474`*^9, 3.92244924185153*^9}, {
   3.922449433892746*^9, 3.9224494539878697`*^9}, 3.9224495707329693`*^9, {
   3.9224496163729506`*^9, 3.9224496207640467`*^9}, {3.9224496650289783`*^9, 
   3.922449698452041*^9}, {3.9224497735650997`*^9, 3.922449802332158*^9}, {
   3.922449839284943*^9, 3.9224498651962533`*^9}, {3.922449917500738*^9, 
   3.9224499177562876`*^9}, {3.922449991493149*^9, 3.92245008408346*^9}, {
   3.922451684903465*^9, 3.922451684966463*^9}},
 CellLabel->"In[81]:=",ExpressionUUID->"ba0b5043-063b-419c-b694-4ecaad116f48"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"4", "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", "\[Gamma]"}]]}], "-", 
    RowBox[{"4", " ", "\[Gamma]"}]}], 
   SuperscriptBox["u", "2"]]}]], "Output",
 CellChangeTimes->{{3.922449992683443*^9, 3.9224499961194725`*^9}, {
   3.9224500460430117`*^9, 3.9224500843327312`*^9}, 3.9224516918325233`*^9},
 CellLabel->"Out[81]=",ExpressionUUID->"3cd2f743-d412-460c-a364-d4103f175853"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Asymptotic", "[", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"3", "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "u"}], ")"}], " ", "\[Beta]"}], ")"}]}]]}], 
       "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "2"}], " ", "\[Beta]"}]], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "u"}], ")"}]}], "+", 
       RowBox[{"2", " ", "\[Beta]"}], "-", 
       RowBox[{"u", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"2", " ", "\[Beta]"}]}], ")"}]}]}], 
      SuperscriptBox["u", "2"]]}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Beta]", ",", "\[Infinity]", ",", "2"}], "}"}]}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellChangeTimes->{{3.922449484283775*^9, 3.922449509643072*^9}},
 CellLabel->"In[52]:=",ExpressionUUID->"02b1e68a-bcef-4dc7-9aa3-ae323482e21d"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"3", "+", "u"}], ")"}], " ", "\[Beta]"}], ")"}]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"4", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[Beta]"}]]}], "-", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "u"}], ")"}], " ", "\[Beta]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "u"}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"3", "+", "u"}], ")"}], " ", "\[Beta]"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "+", "u", "-", 
        RowBox[{"2", " ", "\[Beta]"}], "+", 
        RowBox[{"2", " ", "u", " ", "\[Beta]"}]}], ")"}]}]}], ")"}]}], 
  SuperscriptBox["u", "2"]]], "Output",
 CellChangeTimes->{{3.922449507072554*^9, 3.9224495099268684`*^9}},
 CellLabel->"Out[52]=",ExpressionUUID->"2821ea5a-58e1-42d4-836c-c9ec8c5246ee"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Asymptotic", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{"Exp", "[", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            RowBox[{"(", 
             RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}]}]], " ", "\[Beta]", 
          " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"\[Beta]", "+", "\[Gamma]"}]], " ", "\[Beta]", " ", 
             "\[Gamma]"}], "+", 
            RowBox[{"\[Beta]", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "\[Beta]"}], "+", "\[Gamma]"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"2", " ", "\[Gamma]"}]], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{"2", " ", "\[Beta]"}]], " ", 
                RowBox[{"(", 
                 RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}], " ", 
                "\[Gamma]"}], "+", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}], "2"]}], 
              ")"}]}]}], ")"}]}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"\[Beta]", "-", "\[Gamma]"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"\[Beta]", "+", "\[Gamma]"}], ")"}], "2"]}]]}], "]"}]}], "/.", 
     RowBox[{"\[Beta]", "->", 
      RowBox[{"\[Gamma]", "/", "u"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"u", ",", "\[Infinity]", ",", "2"}], "}"}]}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellChangeTimes->{{3.917947486061458*^9, 3.9179475378764057`*^9}, {
  3.9179475812814207`*^9, 3.917947604996591*^9}, {3.917947930254979*^9, 
  3.917947935560205*^9}, {3.9224491202920856`*^9, 3.9224491223553753`*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"f06a1b76-abf7-4295-9e1c-c5ac76cb1e22"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"3", "+", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[Gamma]"}]], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", "\[Gamma]"}]]}], "-", 
    RowBox[{"2", " ", "\[Gamma]"}]}], 
   SuperscriptBox["u", "2"]]}]], "Output",
 CellChangeTimes->{{3.917947492575419*^9, 3.917947538394116*^9}, {
   3.917947582688531*^9, 3.917947605334087*^9}, 3.917947937427857*^9, 
   3.9224491233034797`*^9},
 CellLabel->"Out[44]=",ExpressionUUID->"ba2f6e9f-89fa-44c1-b0a5-839721589718"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{"-", 
         RowBox[{"\[CurlyPhi]", "[", 
          RowBox[{"\[Beta]", ",", 
           RowBox[{"\[Beta]", "*", "v"}]}], "]"}]}], "]"}], ",", 
       RowBox[{"Exp", "[", 
        RowBox[{"-", 
         RowBox[{"\[Phi]", "[", 
          RowBox[{"\[Beta]", ",", 
           RowBox[{"\[Beta]", "*", "v"}]}], "]"}]}], "]"}], ",", 
       RowBox[{"Exp", "[", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[CurlyPhi]", "[", 
             RowBox[{
              RowBox[{"2", "\[Beta]"}], ",", 
              RowBox[{"2", "\[Beta]", "*", "v"}]}], "]"}], "+", 
            RowBox[{"\[Phi]", "[", 
             RowBox[{
              RowBox[{"2", "\[Beta]"}], ",", 
              RowBox[{"2", "\[Beta]", "*", "v"}]}], "]"}]}], ")"}]}], "/", 
         "4"}], "]"}]}], "}"}], "/.", 
     RowBox[{"\[Beta]", "->", "1"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", "40"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"Placed", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "\"\<Forth-Back\>\"", ",", "\"\<Spin-Echo\>\"", ",", 
        "\"\<One-Way\>\""}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Right", ",", "Bottom"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"Ticks", "->", "Automatic"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<v\>\"", ",", "\"\<F\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9234595704079885`*^9, 3.923459605584942*^9}, {
  3.923459668504835*^9, 3.923459675983768*^9}, {3.9234597777446876`*^9, 
  3.9234598115281467`*^9}},
 CellLabel->"In[77]:=",ExpressionUUID->"85cd0b36-0e98-4b69-a4aa-1f89b4604279"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{
    InterpretationBox[{
      TagBox[{{{}, {}, 
         TagBox[
          {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2], 
           Opacity[1.], 
           LineBox[{{8.163265306122449*^-7, 0.3213144601293238}, {
            0.012268716822385069`, 0.3226385816659822}, {
            0.024536617318239525`, 0.3239605710858329}, {0.04907241830994844, 
            0.3265980840233664}, {0.09814402029336627, 
            0.33184677653192185`}, {0.19628722426020193`, 
            0.342235319863226}, {0.39257363219387326`, 
            0.36255276245011936`}, {0.7851464480612159, 0.4012088622690268}, {
            0.7984462579886711, 0.4024703285633402}, {0.8117460679161261, 
            0.4037285835863214}, {0.8383456877710365, 0.40623544652174925`}, {
            0.8915449274808571, 0.41121050287797145`}, {0.9872448979591859, 
            0.4200299358570377}}], LineBox[CompressedData["
1:eJwVz2s01AkYBvDJ0AVtozsxITUioivFvK/5p1zKKRp12C7I5aCbQ1tuRQoV
TRITa6cZaWtbakqd1KKUxCAihWkyF8rM/He3NDSTtLMfnvOc36fnPDbhBwMj
DSgUym59/u9iDV/IXPUvKOu6LLum9EPVrdz+eGcduMsj8oX7JaCcqTznF6aD
BHpjen+aBBhH/Jj2hTooG/Ow0OVJ4IqHCV+u1YG1V23knCoJFDSfiwpp/AYe
Y7G9z0gJHJGf/7Tp5+8wWnz2nknce+CZiE6aeVNQcHXe51vOAxANnZfVCVQs
v5juv95MChTB6MP+s1SUG/vs6ZsnBa6hpbjlKhWDAoWPEulSeNEcRb/RQ8Vz
P3mGljpKwX77uCBynSEuORRx/ra3FD7GMP6UTDJCA+jkfT8qhdiCtLoOzmTM
/uP+fHexFA4MLpVXV03DN9AhUV6SwcDu3qlPmqdhy6ddArJUBkFvc5zbFNOw
pvOdSMWXgZvow7FBC2N8FXttb1+lDKjCCtrcbGPcnHyBktEoA26qDfOXPSbo
xp+cNzYigyezzC+706Zjo2ivQcUWORjbZDHeu9HQPvX18KsvcnjhcWF5ujcN
i4Zj4ahWDqd3/rbWKpCG8T6BYRYTcjDgPNgUGkfD5960OewpCtBNqKPflNGw
PrMi56q5AlRi9vWXBmbYfMVpvNJTAa1cxtLHrWbY6cQ9lXZSAfk0kQN/7yxU
+rnWl04ehPD+7fXU1rkoo7e08yhDcLgxK/wgwwJdS9LdAzuGQHjINGi+rxX2
xKqTPx/5APyUOKXLDmu0YkxyEMz6CJm88W1f1DZ4If/2i/CLH4HSNYB/JS/C
rkGe0s1gGJYkRh3d7rAYZTkdbWPxw6DQFAeb1C5Bv/pudl/jMPgNxqYVHLZH
xryEAX9LJQQoOI50ugOK1x804sYoQfk0/MSLSkc8dv2BwOGGEpzNeqyIPU7o
3Bp7TftRCcagCROPOKPnFfnOuIUq2ESGjNmyXbBmg+OqHLYK3jbsmxSyzBVX
MewUAadVcC/n2W5rjStSWUtrd99WQZRR0kB7+wo0jz+0VdCngoiElHumJSsx
kJo43/eHCpZHO7ZvDluFa5n0X3ut1fBy5jKTJPfVOPVRQ4OEpYZHVZmly6hr
ELsLgy/tVUPKJIetre/W4Jynd62b0tVgLE72OVC9FsW60zUFJWoYvGZTyEt1
Q+XDx/sn7qih0N7csIbtjiOL+95rRWrglEQ1hVmvQxWlkkeRqSGkcFe76Yd1
mGXx5VjyqBq+bqjQ8urWY+n8TaNnTEiQD7KONmR74JM0wwZXOgkCT9cFbWGe
KHw2PTjalYTKU0lm0U5M9P172z9JLBKy2RH+VA0TT0ZkXo4NJGG1mH8juw0w
Jr0pVx1OAndpaWWbP2L1wpQd/MMkHH+cx/WvQTwzlCHrO0HClgXsihY7L2R+
87WxOU+C14GmULNcL9zBqtNKS0ngWYbbtWq8cLbCccj2Bgl2T38vCghlIaej
topyjwSOU4PDqzoWXkn7ienymISoEcPOZgcCF2RuhD4RCeHCz9a55wlcO3M9
d1sPCfGZQeN+FwjMNspJOK53UlD1G9OLBEZGgHel3jmapHxOEYFs2ZeuqW9I
qHLXfisuI9A24lZRvd7aJz96rt0k0N/S8K5jr37/lWnesyYCN4rMt0/0k1BS
vj/mdDOBfqs3g6OYhPLEdsJHRGDR+KJFO/W+P5ejE7UTuLK3pVuotzhkVkzX
awLb7ewH9r0jgSE3J2RyAqvUQm6zhASX6mT61UECZweYzRjVe92pfm3kBwIr
+SvSbd+TsJlRdntYSeB+l4aNKXonxFnTP30iUMjamLFsgIRUjwztnRECfTlD
tTv1PjVd1p2oIdBCHjySpTf3VvnZr18JpBdX+bzTW3DCMPqhjkDPI5djpklJ
uLktkpU6TmBCcGjGar2rbZ9bMSf0/zWagjC960aWaH/8ILBxRlxZnt7/ATop
4xM=
            "]]},
          Annotation[#, "Charting`Private`Tag#1"]& ], 
         TagBox[
          {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[2], 
           Opacity[1.], 
           LineBox[{{8.163265306122449*^-7, 0.7144927579641763}, {
            0.012268716822385069`, 0.715178424955423}, {0.024536617318239525`,
             0.7158615418799785}, {0.04907241830994844, 0.7172201672493552}, {
            0.09814402029336627, 0.7199072743424542}, {0.19628722426020193`, 
            0.7251632092644729}, {0.39257363219387326`, 0.7352198863134695}, {
            0.40484153268972767`, 0.7358289683652308}, {0.41710943318558213`, 
            0.736435818243077}, {0.44164523417729107`, 0.7376428589821411}, {
            0.49071683616070894`, 0.7400305650349263}, {0.5888600401275446, 
            0.7447025321188347}, {0.7851464480612159, 0.7536486846025977}, {
            0.7984462579886711, 0.7542363369146975}, {0.8117460679161261, 
            0.7548216998076002}, {0.8383456877710365, 0.755985599598967}, {
            0.8915449274808571, 0.7582863884781607}, {0.9872448979591859, 
            0.7623364338256854}}], LineBox[CompressedData["
1:eJwVz3s0lAkfB/Bx6d3c1sxq7ZuJpTBIRkmKmt+PZztISxlTVqXchii13ii3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            "]]},
          Annotation[#, "Charting`Private`Tag#2"]& ], 
         TagBox[
          {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[2], 
           Opacity[1.], 
           LineBox[{{8.163265306122449*^-7, 0.32131451394190363`}, {
            0.012268716822385069`, 0.3234449336048871}, {
            0.024536617318239525`, 0.3255683816166049}, {0.04907241830994844, 
            0.3297941449062273}, {0.09814402029336627, 0.3381597416554822}, {
            0.19628722426020193`, 0.35453779393804935`}, {
            0.39257363219387326`, 0.3858309124446634}, {0.40484153268972767`, 
            0.3877208048114411}, {0.41710943318558213`, 
            0.38960289776585655`}, {0.44164523417729107`, 
            0.3933436811814922}, {0.49071683616070894`, 0.4007316689774714}, {
            0.5888600401275446, 0.41513441337186346`}, {0.7851464480612159, 
            0.44246698407940954`}, {0.7984462579886711, 0.4442491797948904}, {
            0.8117460679161261, 0.44602266207336494`}, {0.8383456877710365, 
            0.449543601045221}, {0.8915449274808571, 0.45648221061560923`}, {
            0.9872448979591859, 0.4686230072416641}}], LineBox[CompressedData["
1:eJwVzXk41Isex/FhHGS5jeaEyJqQLUrZfb/8TqdIbsXEkaNLGV2VLWQrHSXS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            "]]},
          Annotation[#, "Charting`Private`Tag#3"]& ], {}}, {}},
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
            Annotation[{
              Directive[
               Opacity[1.], 
               RGBColor[0.368417, 0.506779, 0.709798], 
               AbsoluteThickness[2]], 
              
              Line[{{8.163265306122449*^-7, 0.3213144601293238}, {
               0.012268716822385069`, 0.3226385816659822}, {
               0.024536617318239525`, 0.3239605710858329}, {
               0.04907241830994844, 0.3265980840233664}, {0.09814402029336627,
                0.33184677653192185`}, {0.19628722426020193`, 
               0.342235319863226}, {0.39257363219387326`, 
               0.36255276245011936`}, {0.7851464480612159, 
               0.4012088622690268}, {0.7984462579886711, 
               0.4024703285633402}, {0.8117460679161261, 
               0.4037285835863214}, {0.8383456877710365, 
               0.40623544652174925`}, {0.8915449274808571, 
               0.41121050287797145`}, {0.9872448979591859, 
               0.4200299358570377}}], 
              Line[CompressedData["
1:eJwVz2s01AkYBvDJ0AVtozsxITUioivFvK/5p1zKKRp12C7I5aCbQ1tuRQoV
TRITa6cZaWtbakqd1KKUxCAihWkyF8rM/He3NDSTtLMfnvOc36fnPDbhBwMj
DSgUym59/u9iDV/IXPUvKOu6LLum9EPVrdz+eGcduMsj8oX7JaCcqTznF6aD
BHpjen+aBBhH/Jj2hTooG/Ow0OVJ4IqHCV+u1YG1V23knCoJFDSfiwpp/AYe
Y7G9z0gJHJGf/7Tp5+8wWnz2nknce+CZiE6aeVNQcHXe51vOAxANnZfVCVQs
v5juv95MChTB6MP+s1SUG/vs6ZsnBa6hpbjlKhWDAoWPEulSeNEcRb/RQ8Vz
P3mGljpKwX77uCBynSEuORRx/ra3FD7GMP6UTDJCA+jkfT8qhdiCtLoOzmTM
/uP+fHexFA4MLpVXV03DN9AhUV6SwcDu3qlPmqdhy6ddArJUBkFvc5zbFNOw
pvOdSMWXgZvow7FBC2N8FXttb1+lDKjCCtrcbGPcnHyBktEoA26qDfOXPSbo
xp+cNzYigyezzC+706Zjo2ivQcUWORjbZDHeu9HQPvX18KsvcnjhcWF5ujcN
i4Zj4ahWDqd3/rbWKpCG8T6BYRYTcjDgPNgUGkfD5960OewpCtBNqKPflNGw
PrMi56q5AlRi9vWXBmbYfMVpvNJTAa1cxtLHrWbY6cQ9lXZSAfk0kQN/7yxU
+rnWl04ehPD+7fXU1rkoo7e08yhDcLgxK/wgwwJdS9LdAzuGQHjINGi+rxX2
xKqTPx/5APyUOKXLDmu0YkxyEMz6CJm88W1f1DZ4If/2i/CLH4HSNYB/JS/C
rkGe0s1gGJYkRh3d7rAYZTkdbWPxw6DQFAeb1C5Bv/pudl/jMPgNxqYVHLZH
xryEAX9LJQQoOI50ugOK1x804sYoQfk0/MSLSkc8dv2BwOGGEpzNeqyIPU7o
3Bp7TftRCcagCROPOKPnFfnOuIUq2ESGjNmyXbBmg+OqHLYK3jbsmxSyzBVX
MewUAadVcC/n2W5rjStSWUtrd99WQZRR0kB7+wo0jz+0VdCngoiElHumJSsx
kJo43/eHCpZHO7ZvDluFa5n0X3ut1fBy5jKTJPfVOPVRQ4OEpYZHVZmly6hr
ELsLgy/tVUPKJIetre/W4Jynd62b0tVgLE72OVC9FsW60zUFJWoYvGZTyEt1
Q+XDx/sn7qih0N7csIbtjiOL+95rRWrglEQ1hVmvQxWlkkeRqSGkcFe76Yd1
mGXx5VjyqBq+bqjQ8urWY+n8TaNnTEiQD7KONmR74JM0wwZXOgkCT9cFbWGe
KHw2PTjalYTKU0lm0U5M9P172z9JLBKy2RH+VA0TT0ZkXo4NJGG1mH8juw0w
Jr0pVx1OAndpaWWbP2L1wpQd/MMkHH+cx/WvQTwzlCHrO0HClgXsihY7L2R+
87WxOU+C14GmULNcL9zBqtNKS0ngWYbbtWq8cLbCccj2Bgl2T38vCghlIaej
topyjwSOU4PDqzoWXkn7ienymISoEcPOZgcCF2RuhD4RCeHCz9a55wlcO3M9
d1sPCfGZQeN+FwjMNspJOK53UlD1G9OLBEZGgHel3jmapHxOEYFs2ZeuqW9I
qHLXfisuI9A24lZRvd7aJz96rt0k0N/S8K5jr37/lWnesyYCN4rMt0/0k1BS
vj/mdDOBfqs3g6OYhPLEdsJHRGDR+KJFO/W+P5ejE7UTuLK3pVuotzhkVkzX
awLb7ewH9r0jgSE3J2RyAqvUQm6zhASX6mT61UECZweYzRjVe92pfm3kBwIr
+SvSbd+TsJlRdntYSeB+l4aNKXonxFnTP30iUMjamLFsgIRUjwztnRECfTlD
tTv1PjVd1p2oIdBCHjySpTf3VvnZr18JpBdX+bzTW3DCMPqhjkDPI5djpklJ
uLktkpU6TmBCcGjGar2rbZ9bMSf0/zWagjC960aWaH/8ILBxRlxZnt7/ATop
4xM=
               "]]}, "Charting`Private`Tag#1"], 
            Annotation[{
              Directive[
               Opacity[1.], 
               RGBColor[0.880722, 0.611041, 0.142051], 
               AbsoluteThickness[2]], 
              
              Line[{{8.163265306122449*^-7, 0.7144927579641763}, {
               0.012268716822385069`, 0.715178424955423}, {
               0.024536617318239525`, 0.7158615418799785}, {
               0.04907241830994844, 0.7172201672493552}, {0.09814402029336627,
                0.7199072743424542}, {0.19628722426020193`, 
               0.7251632092644729}, {0.39257363219387326`, 
               0.7352198863134695}, {0.40484153268972767`, 
               0.7358289683652308}, {0.41710943318558213`, 
               0.736435818243077}, {0.44164523417729107`, 
               0.7376428589821411}, {0.49071683616070894`, 
               0.7400305650349263}, {0.5888600401275446, 
               0.7447025321188347}, {0.7851464480612159, 
               0.7536486846025977}, {0.7984462579886711, 
               0.7542363369146975}, {0.8117460679161261, 
               0.7548216998076002}, {0.8383456877710365, 0.755985599598967}, {
               0.8915449274808571, 0.7582863884781607}, {0.9872448979591859, 
               0.7623364338256854}}], 
              Line[CompressedData["
1:eJwVz3s0lAkfB/Bx6d3c1sxq7ZuJpTBIRkmKmt+PZztISxlTVqXchii13ii3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               "]]}, "Charting`Private`Tag#2"], 
            Annotation[{
              Directive[
               Opacity[1.], 
               RGBColor[0.560181, 0.691569, 0.194885], 
               AbsoluteThickness[2]], 
              
              Line[{{8.163265306122449*^-7, 0.32131451394190363`}, {
               0.012268716822385069`, 0.3234449336048871}, {
               0.024536617318239525`, 0.3255683816166049}, {
               0.04907241830994844, 0.3297941449062273}, {0.09814402029336627,
                0.3381597416554822}, {0.19628722426020193`, 
               0.35453779393804935`}, {0.39257363219387326`, 
               0.3858309124446634}, {0.40484153268972767`, 
               0.3877208048114411}, {0.41710943318558213`, 
               0.38960289776585655`}, {0.44164523417729107`, 
               0.3933436811814922}, {0.49071683616070894`, 
               0.4007316689774714}, {0.5888600401275446, 
               0.41513441337186346`}, {0.7851464480612159, 
               0.44246698407940954`}, {0.7984462579886711, 
               0.4442491797948904}, {0.8117460679161261, 
               0.44602266207336494`}, {0.8383456877710365, 
               0.449543601045221}, {0.8915449274808571, 
               0.45648221061560923`}, {0.9872448979591859, 
               0.4686230072416641}}], 
              Line[CompressedData["
1:eJwVzXk41Isex/FhHGS5jeaEyJqQLUrZfb/8TqdIbsXEkaNLGV2VLWQrHSXS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               "]]}, "Charting`Private`Tag#3"], {}}}, {}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}},
             "AxesOrigin" -> {0, 0.3213144601293245}, 
            "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
            "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               RGBColor[0.560181, 0.691569, 0.194885], 
               AbsoluteThickness[2]], 
              Directive[
               Opacity[1.], 
               RGBColor[0.880722, 0.611041, 0.142051], 
               AbsoluteThickness[2]], 
              Directive[
               Opacity[1.], 
               RGBColor[0.368417, 0.506779, 0.709798], 
               AbsoluteThickness[2]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            Plot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {0, 0.3213144601293245}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              RGBColor[0.560181, 0.691569, 0.194885], 
              AbsoluteThickness[2]], 
             Directive[
              Opacity[1.], 
              RGBColor[0.880722, 0.611041, 0.142051], 
              AbsoluteThickness[2]], 
             Directive[
              Opacity[1.], 
              RGBColor[0.368417, 0.506779, 0.709798], 
              AbsoluteThickness[2]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{{{}, {}, 
         Annotation[{
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]], 
           
           Line[{{8.163265306122449*^-7, 0.3213144601293238}, {
            0.012268716822385069`, 0.3226385816659822}, {
            0.024536617318239525`, 0.3239605710858329}, {0.04907241830994844, 
            0.3265980840233664}, {0.09814402029336627, 
            0.33184677653192185`}, {0.19628722426020193`, 
            0.342235319863226}, {0.39257363219387326`, 
            0.36255276245011936`}, {0.7851464480612159, 0.4012088622690268}, {
            0.7984462579886711, 0.4024703285633402}, {0.8117460679161261, 
            0.4037285835863214}, {0.8383456877710365, 0.40623544652174925`}, {
            0.8915449274808571, 0.41121050287797145`}, {0.9872448979591859, 
            0.4200299358570377}}], 
           Line[CompressedData["
1:eJwVz2s01AkYBvDJ0AVtozsxITUioivFvK/5p1zKKRp12C7I5aCbQ1tuRQoV
TRITa6cZaWtbakqd1KKUxCAihWkyF8rM/He3NDSTtLMfnvOc36fnPDbhBwMj
DSgUym59/u9iDV/IXPUvKOu6LLum9EPVrdz+eGcduMsj8oX7JaCcqTznF6aD
BHpjen+aBBhH/Jj2hTooG/Ow0OVJ4IqHCV+u1YG1V23knCoJFDSfiwpp/AYe
Y7G9z0gJHJGf/7Tp5+8wWnz2nknce+CZiE6aeVNQcHXe51vOAxANnZfVCVQs
v5juv95MChTB6MP+s1SUG/vs6ZsnBa6hpbjlKhWDAoWPEulSeNEcRb/RQ8Vz
P3mGljpKwX77uCBynSEuORRx/ra3FD7GMP6UTDJCA+jkfT8qhdiCtLoOzmTM
/uP+fHexFA4MLpVXV03DN9AhUV6SwcDu3qlPmqdhy6ddArJUBkFvc5zbFNOw
pvOdSMWXgZvow7FBC2N8FXttb1+lDKjCCtrcbGPcnHyBktEoA26qDfOXPSbo
xp+cNzYigyezzC+706Zjo2ivQcUWORjbZDHeu9HQPvX18KsvcnjhcWF5ujcN
i4Zj4ahWDqd3/rbWKpCG8T6BYRYTcjDgPNgUGkfD5960OewpCtBNqKPflNGw
PrMi56q5AlRi9vWXBmbYfMVpvNJTAa1cxtLHrWbY6cQ9lXZSAfk0kQN/7yxU
+rnWl04ehPD+7fXU1rkoo7e08yhDcLgxK/wgwwJdS9LdAzuGQHjINGi+rxX2
xKqTPx/5APyUOKXLDmu0YkxyEMz6CJm88W1f1DZ4If/2i/CLH4HSNYB/JS/C
rkGe0s1gGJYkRh3d7rAYZTkdbWPxw6DQFAeb1C5Bv/pudl/jMPgNxqYVHLZH
xryEAX9LJQQoOI50ugOK1x804sYoQfk0/MSLSkc8dv2BwOGGEpzNeqyIPU7o
3Bp7TftRCcagCROPOKPnFfnOuIUq2ESGjNmyXbBmg+OqHLYK3jbsmxSyzBVX
MewUAadVcC/n2W5rjStSWUtrd99WQZRR0kB7+wo0jz+0VdCngoiElHumJSsx
kJo43/eHCpZHO7ZvDluFa5n0X3ut1fBy5jKTJPfVOPVRQ4OEpYZHVZmly6hr
ELsLgy/tVUPKJIetre/W4Jynd62b0tVgLE72OVC9FsW60zUFJWoYvGZTyEt1
Q+XDx/sn7qih0N7csIbtjiOL+95rRWrglEQ1hVmvQxWlkkeRqSGkcFe76Yd1
mGXx5VjyqBq+bqjQ8urWY+n8TaNnTEiQD7KONmR74JM0wwZXOgkCT9cFbWGe
KHw2PTjalYTKU0lm0U5M9P172z9JLBKy2RH+VA0TT0ZkXo4NJGG1mH8juw0w
Jr0pVx1OAndpaWWbP2L1wpQd/MMkHH+cx/WvQTwzlCHrO0HClgXsihY7L2R+
87WxOU+C14GmULNcL9zBqtNKS0ngWYbbtWq8cLbCccj2Bgl2T38vCghlIaej
topyjwSOU4PDqzoWXkn7ienymISoEcPOZgcCF2RuhD4RCeHCz9a55wlcO3M9
d1sPCfGZQeN+FwjMNspJOK53UlD1G9OLBEZGgHel3jmapHxOEYFs2ZeuqW9I
qHLXfisuI9A24lZRvd7aJz96rt0k0N/S8K5jr37/lWnesyYCN4rMt0/0k1BS
vj/mdDOBfqs3g6OYhPLEdsJHRGDR+KJFO/W+P5ejE7UTuLK3pVuotzhkVkzX
awLb7ewH9r0jgSE3J2RyAqvUQm6zhASX6mT61UECZweYzRjVe92pfm3kBwIr
+SvSbd+TsJlRdntYSeB+l4aNKXonxFnTP30iUMjamLFsgIRUjwztnRECfTlD
tTv1PjVd1p2oIdBCHjySpTf3VvnZr18JpBdX+bzTW3DCMPqhjkDPI5djpklJ
uLktkpU6TmBCcGjGar2rbZ9bMSf0/zWagjC960aWaH/8ILBxRlxZnt7/ATop
4xM=
            "]]}, "Charting`Private`Tag#1"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            RGBColor[0.880722, 0.611041, 0.142051], 
            AbsoluteThickness[2]], 
           
           Line[{{8.163265306122449*^-7, 0.7144927579641763}, {
            0.012268716822385069`, 0.715178424955423}, {0.024536617318239525`,
             0.7158615418799785}, {0.04907241830994844, 0.7172201672493552}, {
            0.09814402029336627, 0.7199072743424542}, {0.19628722426020193`, 
            0.7251632092644729}, {0.39257363219387326`, 0.7352198863134695}, {
            0.40484153268972767`, 0.7358289683652308}, {0.41710943318558213`, 
            0.736435818243077}, {0.44164523417729107`, 0.7376428589821411}, {
            0.49071683616070894`, 0.7400305650349263}, {0.5888600401275446, 
            0.7447025321188347}, {0.7851464480612159, 0.7536486846025977}, {
            0.7984462579886711, 0.7542363369146975}, {0.8117460679161261, 
            0.7548216998076002}, {0.8383456877710365, 0.755985599598967}, {
            0.8915449274808571, 0.7582863884781607}, {0.9872448979591859, 
            0.7623364338256854}}], 
           Line[CompressedData["
1:eJwVz3s0lAkfB/Bx6d3c1sxq7ZuJpTBIRkmKmt+PZztISxlTVqXchii13ii3
bFm3Le2QENUspa0TSgcnXWySdR9au2ylVjFpnpl5Zq13ijF4n/eP7/mez1/f
87WJPBIco8tgMKLp/L/L1FUNvPV/Q1J2+8gvh99D/e2Cl4dcNPAg1TLsHFcG
5Gfk2W0RGhBJ7wuXucmAk7KN51CigcRp7a6yDTL4abNR1fisBk4ccPz7/BYZ
FHefFYZ1zMHGyX3RcQEySBn/ccp37zwIXtl5nxLKQGzUm83aysDmEV58QYUM
YuHZRUWSHqYUlSZc0siAUf3h/sszevj8oV1vzLwMyvVXjPZc08Mf8usnnBkk
dHULrW4O6+GWef+gxiUkOIRoq2M89XHISbD1BpOE93Gc2tc6SzCln9Fmb09C
fHFm66DoX9juK+4pDCIhUeo43lhvgKn6QeFpl0gYC3++tK3bALnvanXVV0jg
/5nv0j9hgPw7hWWHq0jY2DuZKrUwxJGDHypDr5Og11DDNM8zxNzc0kDzOySU
Z9jwju83wiwtL2BdOwltZssvbmKaoLWuQ/HcJAmGNt9z/trIxAnuqiAfZzl0
bS7intzKxB2P/2m1d5FDbugVD8tgJipr4wYNXOWgK7rnuyeBiZ/uqH3V6yYH
zYIiduQyE29Hzf0KXnKQjwpuDOiykFj5TjPpL4e+co7j4z4WZmUG9/gI5XCO
2etUdcAM/xNnmxxdKYcWD8umwEQz3F8kmF9xWQ4T4UdAm26GYx57fX6/Igev
OrOQ3WVm2NtmtBSq5fDef2+micQMc5ryapbclAORrRxI9VqGSafSMLRZDjNq
0+Rg88/Rz/ROFHtQDpEvQ37R6zPHeOLwmlCGAr7t+D7yCMcCeS8yjk7zFdBw
1Jj/b39LnKiR75CVKqAqPYF03W2N8dycfYN/KOC0WLvzvwobnOsc3soyUAJj
aAwfpq1CbtF6MttdCfbHhCdCnOwwasPIaOABJUyoy3YZPbLH6uc/u1LZStgm
jc8s/tYBF4qVD0TXlRA4IVptZeWEuw0+Vlp3KIFsj/yuq241uk8F/6R9rQQX
1rAlsX8NBpexJfkzSjAEdcTotAvGpEjH+J9S4KsM+7hS4IoXzne2zq2i4M8n
0Tphzmtx+uE3j7I8KGjKfxpurV6Lhy7yl/P9KBAuSR6TSNYhu2QXeH5DQVRS
epNxhRsuZNkw3sZSwI1dLdkesR7jv6pgf51MwcBnzkbJm9xRHRjv8u40BQ/q
T1c6621AC1OJtuMcBek6Tjv6Xm1AzZVTqcMVFBiOpvklNnqgcCzBaKqGAul1
mxJxxka88cUn5ndvU1DisFy/RbAJ3zQkW9e2UCCqEHZGWHtisUAsPv6EgrCS
fRLjSU/cv7Jh17UeCma+qpkVt3ohsZPxxniIgnGpz4kneZvxmlvRhZMvKKje
spbdH7EFa/0/6Di+paAuJ5kVu4aHN+89DP74noI8QVSAnpqHEZLCqRAVBe6j
VTfz+gGvhrvdI9UUlDtW1vUHIOo/Y+/rmqMg63FheUALYp5FU8cLHRV8zRbU
9Nh6o7R26dyZT1Tgndi5h1XgjQu5BU+rjFUgXhFp26f2RucAYTrJUoFt+8+l
gXt8cFnmo/QacxWI1jxx+q3VB/UYcQoLtgqE0/rPup0IfFPANm37UgWRDf9Y
F/xIIPM1+y/FKhUcOs3XbisisHlA326RdjK/ccT4PIEH17+LZdmqIF+dfE5U
SuBo6IUJd9r1m2bnyi4T6Gdyv+Uk7dm2xeHrtwg8G/R0yNSO3v/NuPBpJ4G6
j5f2ce1VUHH1cFxuN4GcsKN3vWlfPSYh/HoJdFicvMCn3Wwu0vRKCBRvNww5
Tns0zCxu6A8C/Vdw61ppc8aXE2/HCVQwKoa2c1Tg2phmdU1K4KXI0DPhtD1z
Xs7GTBKYDuvwKO3tnMt3ZCT9h+dVdZ52UoK11dQUgRSrGV/Qzth8avbuNIHH
TaLfyGnnmLz9/ZiawC/t3bLmaZffvnpmZobAhHSPu9YOKqj+Tj/2vobAActE
33W0b+2M8cnQEjh4o+s5Qbtx5a+WvAUCH0l8Dwpot07bzy4uEnjLW6EW0v4f
Mur9Fg==
            "]]}, "Charting`Private`Tag#2"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            RGBColor[0.560181, 0.691569, 0.194885], 
            AbsoluteThickness[2]], 
           
           Line[{{8.163265306122449*^-7, 0.32131451394190363`}, {
            0.012268716822385069`, 0.3234449336048871}, {
            0.024536617318239525`, 0.3255683816166049}, {0.04907241830994844, 
            0.3297941449062273}, {0.09814402029336627, 0.3381597416554822}, {
            0.19628722426020193`, 0.35453779393804935`}, {
            0.39257363219387326`, 0.3858309124446634}, {0.40484153268972767`, 
            0.3877208048114411}, {0.41710943318558213`, 
            0.38960289776585655`}, {0.44164523417729107`, 
            0.3933436811814922}, {0.49071683616070894`, 0.4007316689774714}, {
            0.5888600401275446, 0.41513441337186346`}, {0.7851464480612159, 
            0.44246698407940954`}, {0.7984462579886711, 0.4442491797948904}, {
            0.8117460679161261, 0.44602266207336494`}, {0.8383456877710365, 
            0.449543601045221}, {0.8915449274808571, 0.45648221061560923`}, {
            0.9872448979591859, 0.4686230072416641}}], 
           Line[CompressedData["
1:eJwVzXk41Isex/FhHGS5jeaEyJqQLUrZfb/8TqdIbsXEkaNLGV2VLWQrHSXS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            "]]}, "Charting`Private`Tag#3"], {}}}, {}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {0, 0.3213144601293245}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            RGBColor[0.560181, 0.691569, 0.194885], 
            AbsoluteThickness[2]], 
           Directive[
            Opacity[1.], 
            RGBColor[0.880722, 0.611041, 0.142051], 
            AbsoluteThickness[2]], 
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], InsetBox[
     TemplateBox[{"\"Forth-Back\"", "\"Spin-Echo\"", "\"One-Way\""},
      "LineLegend",
      DisplayFunction->(FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& )], 
     Scaled[{0.99, 0.01}], ImageScaled[{1, 0}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{0, 0.3213144601293245},
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox[
       TagBox["\"F\"", HoldForm], TraditionalForm], None}, {
      FormBox[
       TagBox["\"v\"", HoldForm], TraditionalForm], None}},
   FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
   GridLines->{None, None},
   GridLinesStyle->Directive[
     GrayLevel[0.5, 0.4]],
   ImagePadding->All,
   ImageSize->Medium,
   Method->{
    "DefaultBoundaryStyle" -> Automatic, 
     "DefaultGraphicsInteraction" -> {
      "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
       "Effects" -> {
        "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
         "Droplines" -> {
          "freeformCursorMode" -> True, 
           "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
     "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
     "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& )}},
   PlotRange->{All, All},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.05], 
      Scaled[0.05]}},
   Ticks->{Automatic, Automatic}],
  InterpretTemplate[Legended[
    Graphics[
     Annotation[{{{{}, {}, 
         Annotation[{
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]], 
           
           Line[{{8.163265306122449*^-7, 0.3213144601293238}, {
            0.012268716822385069`, 0.3226385816659822}, {
            0.024536617318239525`, 0.3239605710858329}, {0.04907241830994844, 
            0.3265980840233664}, {0.09814402029336627, 
            0.33184677653192185`}, {0.19628722426020193`, 
            0.342235319863226}, {0.39257363219387326`, 
            0.36255276245011936`}, {0.7851464480612159, 0.4012088622690268}, {
            0.7984462579886711, 0.4024703285633402}, {0.8117460679161261, 
            0.4037285835863214}, {0.8383456877710365, 0.40623544652174925`}, {
            0.8915449274808571, 0.41121050287797145`}, {0.9872448979591859, 
            0.4200299358570377}}], 
           Line[CompressedData["
1:eJwVz2s01AkYBvDJ0AVtozsxITUioivFvK/5p1zKKRp12C7I5aCbQ1tuRQoV
TRITa6cZaWtbakqd1KKUxCAihWkyF8rM/He3NDSTtLMfnvOc36fnPDbhBwMj
DSgUym59/u9iDV/IXPUvKOu6LLum9EPVrdz+eGcduMsj8oX7JaCcqTznF6aD
BHpjen+aBBhH/Jj2hTooG/Ow0OVJ4IqHCV+u1YG1V23knCoJFDSfiwpp/AYe
Y7G9z0gJHJGf/7Tp5+8wWnz2nknce+CZiE6aeVNQcHXe51vOAxANnZfVCVQs
v5juv95MChTB6MP+s1SUG/vs6ZsnBa6hpbjlKhWDAoWPEulSeNEcRb/RQ8Vz
P3mGljpKwX77uCBynSEuORRx/ra3FD7GMP6UTDJCA+jkfT8qhdiCtLoOzmTM
/uP+fHexFA4MLpVXV03DN9AhUV6SwcDu3qlPmqdhy6ddArJUBkFvc5zbFNOw
pvOdSMWXgZvow7FBC2N8FXttb1+lDKjCCtrcbGPcnHyBktEoA26qDfOXPSbo
xp+cNzYigyezzC+706Zjo2ivQcUWORjbZDHeu9HQPvX18KsvcnjhcWF5ujcN
i4Zj4ahWDqd3/rbWKpCG8T6BYRYTcjDgPNgUGkfD5960OewpCtBNqKPflNGw
PrMi56q5AlRi9vWXBmbYfMVpvNJTAa1cxtLHrWbY6cQ9lXZSAfk0kQN/7yxU
+rnWl04ehPD+7fXU1rkoo7e08yhDcLgxK/wgwwJdS9LdAzuGQHjINGi+rxX2
xKqTPx/5APyUOKXLDmu0YkxyEMz6CJm88W1f1DZ4If/2i/CLH4HSNYB/JS/C
rkGe0s1gGJYkRh3d7rAYZTkdbWPxw6DQFAeb1C5Bv/pudl/jMPgNxqYVHLZH
xryEAX9LJQQoOI50ugOK1x804sYoQfk0/MSLSkc8dv2BwOGGEpzNeqyIPU7o
3Bp7TftRCcagCROPOKPnFfnOuIUq2ESGjNmyXbBmg+OqHLYK3jbsmxSyzBVX
MewUAadVcC/n2W5rjStSWUtrd99WQZRR0kB7+wo0jz+0VdCngoiElHumJSsx
kJo43/eHCpZHO7ZvDluFa5n0X3ut1fBy5jKTJPfVOPVRQ4OEpYZHVZmly6hr
ELsLgy/tVUPKJIetre/W4Jynd62b0tVgLE72OVC9FsW60zUFJWoYvGZTyEt1
Q+XDx/sn7qih0N7csIbtjiOL+95rRWrglEQ1hVmvQxWlkkeRqSGkcFe76Yd1
mGXx5VjyqBq+bqjQ8urWY+n8TaNnTEiQD7KONmR74JM0wwZXOgkCT9cFbWGe
KHw2PTjalYTKU0lm0U5M9P172z9JLBKy2RH+VA0TT0ZkXo4NJGG1mH8juw0w
Jr0pVx1OAndpaWWbP2L1wpQd/MMkHH+cx/WvQTwzlCHrO0HClgXsihY7L2R+
87WxOU+C14GmULNcL9zBqtNKS0ngWYbbtWq8cLbCccj2Bgl2T38vCghlIaej
topyjwSOU4PDqzoWXkn7ienymISoEcPOZgcCF2RuhD4RCeHCz9a55wlcO3M9
d1sPCfGZQeN+FwjMNspJOK53UlD1G9OLBEZGgHel3jmapHxOEYFs2ZeuqW9I
qHLXfisuI9A24lZRvd7aJz96rt0k0N/S8K5jr37/lWnesyYCN4rMt0/0k1BS
vj/mdDOBfqs3g6OYhPLEdsJHRGDR+KJFO/W+P5ejE7UTuLK3pVuotzhkVkzX
awLb7ewH9r0jgSE3J2RyAqvUQm6zhASX6mT61UECZweYzRjVe92pfm3kBwIr
+SvSbd+TsJlRdntYSeB+l4aNKXonxFnTP30iUMjamLFsgIRUjwztnRECfTlD
tTv1PjVd1p2oIdBCHjySpTf3VvnZr18JpBdX+bzTW3DCMPqhjkDPI5djpklJ
uLktkpU6TmBCcGjGar2rbZ9bMSf0/zWagjC960aWaH/8ILBxRlxZnt7/ATop
4xM=
            "]]}, "Charting`Private`Tag#1"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            RGBColor[0.880722, 0.611041, 0.142051], 
            AbsoluteThickness[2]], 
           
           Line[{{8.163265306122449*^-7, 0.7144927579641763}, {
            0.012268716822385069`, 0.715178424955423}, {0.024536617318239525`,
             0.7158615418799785}, {0.04907241830994844, 0.7172201672493552}, {
            0.09814402029336627, 0.7199072743424542}, {0.19628722426020193`, 
            0.7251632092644729}, {0.39257363219387326`, 0.7352198863134695}, {
            0.40484153268972767`, 0.7358289683652308}, {0.41710943318558213`, 
            0.736435818243077}, {0.44164523417729107`, 0.7376428589821411}, {
            0.49071683616070894`, 0.7400305650349263}, {0.5888600401275446, 
            0.7447025321188347}, {0.7851464480612159, 0.7536486846025977}, {
            0.7984462579886711, 0.7542363369146975}, {0.8117460679161261, 
            0.7548216998076002}, {0.8383456877710365, 0.755985599598967}, {
            0.8915449274808571, 0.7582863884781607}, {0.9872448979591859, 
            0.7623364338256854}}], 
           Line[CompressedData["
1:eJwVz3s0lAkfB/Bx6d3c1sxq7ZuJpTBIRkmKmt+PZztISxlTVqXchii13ii3
bFm3Le2QENUspa0TSgcnXWySdR9au2ylVjFpnpl5Zq13ijF4n/eP7/mez1/f
87WJPBIco8tgMKLp/L/L1FUNvPV/Q1J2+8gvh99D/e2Cl4dcNPAg1TLsHFcG
5Gfk2W0RGhBJ7wuXucmAk7KN51CigcRp7a6yDTL4abNR1fisBk4ccPz7/BYZ
FHefFYZ1zMHGyX3RcQEySBn/ccp37zwIXtl5nxLKQGzUm83aysDmEV58QYUM
YuHZRUWSHqYUlSZc0siAUf3h/sszevj8oV1vzLwMyvVXjPZc08Mf8usnnBkk
dHULrW4O6+GWef+gxiUkOIRoq2M89XHISbD1BpOE93Gc2tc6SzCln9Fmb09C
fHFm66DoX9juK+4pDCIhUeo43lhvgKn6QeFpl0gYC3++tK3bALnvanXVV0jg
/5nv0j9hgPw7hWWHq0jY2DuZKrUwxJGDHypDr5Og11DDNM8zxNzc0kDzOySU
Z9jwju83wiwtL2BdOwltZssvbmKaoLWuQ/HcJAmGNt9z/trIxAnuqiAfZzl0
bS7intzKxB2P/2m1d5FDbugVD8tgJipr4wYNXOWgK7rnuyeBiZ/uqH3V6yYH
zYIiduQyE29Hzf0KXnKQjwpuDOiykFj5TjPpL4e+co7j4z4WZmUG9/gI5XCO
2etUdcAM/xNnmxxdKYcWD8umwEQz3F8kmF9xWQ4T4UdAm26GYx57fX6/Igev
OrOQ3WVm2NtmtBSq5fDef2+micQMc5ryapbclAORrRxI9VqGSafSMLRZDjNq
0+Rg88/Rz/ROFHtQDpEvQ37R6zPHeOLwmlCGAr7t+D7yCMcCeS8yjk7zFdBw
1Jj/b39LnKiR75CVKqAqPYF03W2N8dycfYN/KOC0WLvzvwobnOsc3soyUAJj
aAwfpq1CbtF6MttdCfbHhCdCnOwwasPIaOABJUyoy3YZPbLH6uc/u1LZStgm
jc8s/tYBF4qVD0TXlRA4IVptZeWEuw0+Vlp3KIFsj/yuq241uk8F/6R9rQQX
1rAlsX8NBpexJfkzSjAEdcTotAvGpEjH+J9S4KsM+7hS4IoXzne2zq2i4M8n
0Tphzmtx+uE3j7I8KGjKfxpurV6Lhy7yl/P9KBAuSR6TSNYhu2QXeH5DQVRS
epNxhRsuZNkw3sZSwI1dLdkesR7jv6pgf51MwcBnzkbJm9xRHRjv8u40BQ/q
T1c6621AC1OJtuMcBek6Tjv6Xm1AzZVTqcMVFBiOpvklNnqgcCzBaKqGAul1
mxJxxka88cUn5ndvU1DisFy/RbAJ3zQkW9e2UCCqEHZGWHtisUAsPv6EgrCS
fRLjSU/cv7Jh17UeCma+qpkVt3ohsZPxxniIgnGpz4kneZvxmlvRhZMvKKje
spbdH7EFa/0/6Di+paAuJ5kVu4aHN+89DP74noI8QVSAnpqHEZLCqRAVBe6j
VTfz+gGvhrvdI9UUlDtW1vUHIOo/Y+/rmqMg63FheUALYp5FU8cLHRV8zRbU
9Nh6o7R26dyZT1Tgndi5h1XgjQu5BU+rjFUgXhFp26f2RucAYTrJUoFt+8+l
gXt8cFnmo/QacxWI1jxx+q3VB/UYcQoLtgqE0/rPup0IfFPANm37UgWRDf9Y
F/xIIPM1+y/FKhUcOs3XbisisHlA326RdjK/ccT4PIEH17+LZdmqIF+dfE5U
SuBo6IUJd9r1m2bnyi4T6Gdyv+Uk7dm2xeHrtwg8G/R0yNSO3v/NuPBpJ4G6
j5f2ce1VUHH1cFxuN4GcsKN3vWlfPSYh/HoJdFicvMCn3Wwu0vRKCBRvNww5
Tns0zCxu6A8C/Vdw61ppc8aXE2/HCVQwKoa2c1Tg2phmdU1K4KXI0DPhtD1z
Xs7GTBKYDuvwKO3tnMt3ZCT9h+dVdZ52UoK11dQUgRSrGV/Qzth8avbuNIHH
TaLfyGnnmLz9/ZiawC/t3bLmaZffvnpmZobAhHSPu9YOKqj+Tj/2vobAActE
33W0b+2M8cnQEjh4o+s5Qbtx5a+WvAUCH0l8Dwpot07bzy4uEnjLW6EW0v4f
Mur9Fg==
            "]]}, "Charting`Private`Tag#2"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            RGBColor[0.560181, 0.691569, 0.194885], 
            AbsoluteThickness[2]], 
           
           Line[{{8.163265306122449*^-7, 0.32131451394190363`}, {
            0.012268716822385069`, 0.3234449336048871}, {
            0.024536617318239525`, 0.3255683816166049}, {0.04907241830994844, 
            0.3297941449062273}, {0.09814402029336627, 0.3381597416554822}, {
            0.19628722426020193`, 0.35453779393804935`}, {
            0.39257363219387326`, 0.3858309124446634}, {0.40484153268972767`, 
            0.3877208048114411}, {0.41710943318558213`, 
            0.38960289776585655`}, {0.44164523417729107`, 
            0.3933436811814922}, {0.49071683616070894`, 0.4007316689774714}, {
            0.5888600401275446, 0.41513441337186346`}, {0.7851464480612159, 
            0.44246698407940954`}, {0.7984462579886711, 0.4442491797948904}, {
            0.8117460679161261, 0.44602266207336494`}, {0.8383456877710365, 
            0.449543601045221}, {0.8915449274808571, 0.45648221061560923`}, {
            0.9872448979591859, 0.4686230072416641}}], 
           Line[CompressedData["
1:eJwVzXk41Isex/FhHGS5jeaEyJqQLUrZfb/8TqdIbsXEkaNLGV2VLWQrHSXS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            "]]}, "Charting`Private`Tag#3"], {}}}, {}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {0, 0.3213144601293245}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            RGBColor[0.560181, 0.691569, 0.194885], 
            AbsoluteThickness[2]], 
           Directive[
            Opacity[1.], 
            RGBColor[0.880722, 0.611041, 0.142051], 
            AbsoluteThickness[2]], 
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"], {
     DisplayFunction -> Identity, DisplayFunction -> Identity, 
      Ticks -> {Automatic, Automatic}, AxesOrigin -> {0, 0.3213144601293245}, 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLines -> {None, None}, DisplayFunction -> Identity, 
      PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
      DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
      Axes -> {True, True}, AxesLabel -> {None, None}, 
      AxesOrigin -> {0, 0.3213144601293238}, DisplayFunction :> Identity, 
      Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
         HoldForm["F"], None}, {
         HoldForm["v"], None}}, 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLines -> {None, None}, GridLinesStyle -> Directive[
        GrayLevel[0.5, 0.4]], ImageSize -> Medium, 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}}, PlotRange -> {All, All}, PlotRangeClipping -> 
      True, PlotRangePadding -> {{Automatic, Automatic}, {
        Automatic, Automatic}}, Ticks -> {Automatic, Automatic}}], 
    Placed[
     Unevaluated[
      LineLegend[{
        Directive[
         Opacity[1.], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[2]], 
        Directive[
         Opacity[1.], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[2]], 
        Directive[
         Opacity[1.], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[2]]}, {"Forth-Back", "Spin-Echo", "One-Way"}, 
       LegendMarkers -> None, LabelStyle -> {}, LegendLayout -> "Column"]], {
     Right, Bottom}, Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{{3.9234595857129717`*^9, 3.923459605871155*^9}, {
  3.9234596694479065`*^9, 3.923459676304741*^9}, {3.9234597886468887`*^9, 
  3.9234598119317436`*^9}},
 CellLabel->"Out[77]=",ExpressionUUID->"b1cdd7a6-bbcb-4aa1-b103-0b7f1a163aca"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{"-", 
         RowBox[{"\[CurlyPhi]", "[", 
          RowBox[{"\[Beta]", ",", 
           RowBox[{"\[Beta]", "*", "v"}]}], "]"}]}], "]"}], ",", 
       RowBox[{"Exp", "[", 
        RowBox[{"-", 
         RowBox[{"\[Phi]", "[", 
          RowBox[{"\[Beta]", ",", 
           RowBox[{"\[Beta]", "*", "v"}]}], "]"}]}], "]"}], ",", 
       RowBox[{"Exp", "[", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[CurlyPhi]", "[", 
             RowBox[{
              RowBox[{"2", "\[Beta]"}], ",", 
              RowBox[{"2", "\[Beta]", "*", "v"}]}], "]"}], "+", 
            RowBox[{"\[Phi]", "[", 
             RowBox[{
              RowBox[{"2", "\[Beta]"}], ",", 
              RowBox[{"2", "\[Beta]", "*", "v"}]}], "]"}]}], ")"}]}], "/", 
         "4"}], "]"}]}], "}"}], "/.", 
     RowBox[{"v", "->", "10"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Beta]", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"Placed", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "\"\<Forth-Back\>\"", ",", "\"\<Spin-Echo\>\"", ",", 
        "\"\<One-Way\>\""}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Right", ",", "Top"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"Ticks", "->", "Automatic"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<\[Beta]\>\"", ",", "\"\<F\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.918330910984131*^9, 3.9183311226080465`*^9}, {
  3.9234581851461105`*^9, 3.9234582232660413`*^9}, {3.9234598431845975`*^9, 
  3.9234598483755884`*^9}},
 CellLabel->"In[78]:=",ExpressionUUID->"a9cc2c01-16a7-40b4-9355-927424f20b37"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{
    InterpretationBox[{
      TagBox[{{{}, {}, 
         TagBox[
          {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2], 
           Opacity[1.], LineBox[CompressedData["
1:eJwV0nk81XkXB3BryfZLmzCSLGNLikyKPt/STJaYyBRPpWVEUaipUD08tyzN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            "]]},
          Annotation[#, "Charting`Private`Tag#1"]& ], 
         TagBox[
          {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[2], 
           Opacity[1.], LineBox[CompressedData["
1:eJwd1Hk0lV0bBnChEuWJRjLkNTRx8lZmup8iR6gvkaEQmUoqNMgQKScUUe8J
n5BZCBkOmSJjCOHIlOHhmIdHvYbM3/bttfba6/fnva97XWLX7ly0YWdjY8tB
d/3VthlpKh29f5Lt/2caONUFHXsFDMDdxWhtbY2E4+/CIrIFrMFU8cviullC
Et4uUrfhiIr51Lp16tuyIgXugY7C1R/rlggQTlgTdYX7Nzkz1r2sbRVqKeUJ
i7aR99Y95sOssAzxhtwWP/F1G1nPF78W8IEf+IlPq8gV6oJ55RHPgDq17+i6
ZcXVPs6I+sN4WK3PCnIEu0WyZNwL8KB2MJaRufqfxBpKvQSpveTnJeSCvub6
coNgaOX9ErGI7HjBWts05BUcZvHpLiBLlc5WzbS9BrHWzJp55O6jvuqBAnSw
uuvJP4dMf7e3VPLKG5B7cE18BlkbS1H9HBECQgGXFn4hs3mp5Bv2hAKfjOkr
Ejl36pscKfpfsLnlOzKB7GBunuVrGQ4KTTNLo8h/NZCU/XFv4fX+hq9DyC/T
+A/qSUWByu+kp73IZ4Tj40ft3sGZVgWHLmTPqvDtXwyiIZTvIkcbsonnwPnA
2Wio1Lii2Yx8Ql460CQkBsQulR+rR8am7tVJKsQC8+zGqur1/00o3vK7LRb8
xZNWviBH7/rPs+cC8dDlZXyBgexeH1phWBAPaX7JtunIhrQ+dvErCTCu0L0n
CXnrrJNXYUQi7DlBnApFHv5QUOyrlgS+pEbuS+Qya45l/Z4ksB3OLKIhP2TS
H06IJoNMr5KLM7J+QHfup9JkMK2UO3AdmaIhNetjmQLaTssWZuv7k53nJByX
CrJ+fPaayHr/dNqfl0qH/XaWkfzI0jriyYLV6SCq6WrLuZ4vh8PwkF0GEEkv
U2ZXSbiav5pZYvARggvGI34g6+4Sb5JM+AillixqFbKyE3X6xexHEAJVOwby
rkPBFOOQTFB1+bL8CpmdlnPu81Am7C3ovuOFPN3X7iChkAVQL6/ngFwXJpY6
3ZYFH5wbjDWQvbmyD/gL5IBnxk2DyRUSDlNf+WU55sCzIwK7mcjNtDujXdU5
QDV4LFqALMEhnUp5wACvBAqHD3LVSjyF2ZwLkdA5wIt8R/Vp0MqhPOjAWJ/I
ZRL2ultOS3nnwTuxyZpG5Bt/hLNcj36CmrSi8EDkrf+GyIkG5IPBTZy5tkQC
4+/7IVoD+VAcu2jTiWzuqD/vpFwA+48sHMpBzpjE8itGCkDc1lHDBvniiJ+q
/ZkiMJZ7mli8SEJYt5s6Y/Uz/HZxOa+5QMIpIZP4nkslUEm1D96BPHZZYSNX
WgmEqqvP9f4hQWTC1SpNphT0VfoOP0C+c0Neku1nKeSIe0iGzZPAb53xPkGx
DDS3BPdkzpJg+1TERNm6DBhrkrudkAtjA7c0BpWBgnTd9aPI1sRN+z9DZcAt
nmGWPIPmMT8orfOmHA7x57u//pcEY5OYjOlfFbD3daiG0i8SyC4D7ljBSjia
GX6OnCbhmTmXjb56JXTM876IR862uiOYS6+EuJSy2K3IvLfVaO4KVcBdKHG6
ZYqEyicdlzc9qgZXy16K8gQJphsDGXkJ1ZDP13Z3YJyE37749hsN1TBJOTTx
Anl/YFJlnehXCMeIB51jJHiE3pd9VfYV9PQOzt4aJeHYB75NQly1cNtI693t
IRJqKJUW9bK1EFF9TIQH2SLzYaGnSS10xxg3JQ6SEJjb60ik1AJF/yuzi0XC
SGlaV+K5OrDclaivOkBCVOvZzL//+Qblfyz02npJ4FnzNqWKNIJT6r6gB+0o
rxtG5tKajeD8y8tkuQ3tF1Pagu92IxQkVtl4I59MbrPqKm4EdZXfGv4/SMhP
DmHkUb6DxlSaRDCThEn9iSKdhu8A3D5xbt9JuPQ+tO7utmZIfFgXVFGN+tTs
ia6tWDNcO6+97zhyP/+temO5Zngm8f5XdBXK+9HpRjWzZhAZ1XjsVkmC/8XJ
5s1pzdCyfV5GspyE4uXTnW91W8Dr3uGdJp9JkNSbGil/wQTtNSUbtRwSBL2o
ynYxTNhMnsrzzSZhe1r0C+48JkTX9ONNWSQsculT9PqZwL+3ZNkyk4TvpXl3
exRbQTrunbhbOglust6rfwZbgTsmk057T0IDtnMnBW8D38R76lsjSHBpUIKw
mQ5Qoscd+Pcxyp/CGKzh6gS5M2NaIsjxgbIBS0KdYOfyqVXLi4Qm3QMd5mc6
oVDH+XjEIxKO1O28KxnSCVkpXNyqbiT0VpOJWQpdYDc++dDiLgnULwm89W4/
YfDNV3awIWFPDl/Phg29MCfx/K0dFfV/v/q3RtV+aEkRS1VjQ/1oH7nPZIIF
8g2L/HzZUzArpYal3RoG2sp13m82U8C+kLp9n+QYvFELiL++bQrk1yxy9dMn
wK9kB4dH3iR88znRUHWYBOG0GaVqi0kQDR5fSJ6aBvKal0wk2ySMz/f2tMr+
Bp5XLOcHCRMQP1ZYy/vyXxCOslKNPDUBvMJJJIs1Az3P7PbM9YxDwA2GbbTE
HKRwqHxnPBmHOTyVdd1rHtJ1v9NTRcbh3rGKnN3lfyDa7MN+3y9j0Jte8aJJ
bBE83WlWvGZjsGTPfHvIbQn0S3Y4ci+NwpFTm1dtC5fhQ9BpV63oUaDGitll
7lkF2dDHbwpPjoKL8NW/CNM16DvtT/qyRkB64hJP2zk2PPokR+hSwAjswKa5
KhbZ8PE1ejvP0RHgLHmbIR6xAd+Tle9q2z4MN08UdmzRYccDLXW+xbgPQ+rZ
a9Gf59hxn/BWjSKxYZgdF9w+FMKB+3vVWsw0DAFDn8pB1+DEfyhIfr3yYAi8
tGjvcoY48VhpklUuMQRi3drtcbSNuLpglVxz6yAoK/jQBY5twgOqHfT0vQfB
VKRxYUPLJvx+j0sH/fggzNYG9jt6b8bHNtjme/SxIIzT/N5FCS68kU3zNhud
BTt6GLHsFVz4SNSGCzzaLNj4yNtAyWkL/iG8vXFucQDYks0z+vm5cQlDYTnF
rAFwDs8I5C/jxsv9l+h+1gNQfMSPi+82D94dqhJ2XWAA+LSdpZ/wbsVZhVYC
Rsx++CnzvcW1aCt+lo9e7/+8Hz5GgQTLfBsuHrU7JkGzH8wy5PmEV7fhKxWD
1zZt7IfHtBjvnym8+PKOcP+fnwlIGxF+y6uL4VdplDpjTwL8ImkWPecxXNbd
oF75EQHWFycl0/UwPOdnPCHkQYBQUdHHc0YY/vfrUpxwJeB50JWqgGsYHvy6
st3+PgHX5f/7i9sVwxt0dt7xdiDgL5+dWpsTMfyApKJM0WUCVhU9trW9x/An
sXTnaBMCOiYHmhNTMVyEe6HGx5iAYKNsM81MDP9HqzX9nCEBa4cv3qUVYfhj
w+ILfXoE/GwKiuJowfAyy8szXGcJ+PRs3qqlFcONFHNMpqgE0FWuHoprx/Cw
Is6mFk0CdBIoOad7MPy+F202SoOAgof1Nd6jGF74dXiXPE5AiIxckN4EhpcM
tXMLAQFO/REGYiSGe+z6xMd+koCDug69pTMY/ttQ9VKDCgGcG5jxwfMYHnW6
91WOMgF9DBV7i0UMH5m+2ReuRECRfdxR2RUMv3SewL0VCQgV5ZldW8Pwm9ST
2XYKBPwPtIrK5g==
            "]]},
          Annotation[#, "Charting`Private`Tag#2"]& ], 
         TagBox[
          {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[2], 
           Opacity[1.], LineBox[CompressedData["
1:eJwV0Xs81PkeBvAhocQPLUUhG1MkOS2OVnq+m1M6Q0VJW1RK2diOaG2pbEXu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            "]]},
          Annotation[#, "Charting`Private`Tag#3"]& ]}, {}},
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
            Annotation[{
              Directive[
               Opacity[1.], 
               RGBColor[0.368417, 0.506779, 0.709798], 
               AbsoluteThickness[2]], 
              Line[CompressedData["
1:eJwV0nk81XkXB3BryfZLmzCSLGNLikyKPt/STJaYyBRPpWVEUaipUD08tyzN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               "]]}, "Charting`Private`Tag#1"], 
            Annotation[{
              Directive[
               Opacity[1.], 
               RGBColor[0.880722, 0.611041, 0.142051], 
               AbsoluteThickness[2]], 
              Line[CompressedData["
1:eJwd1Hk0lV0bBnChEuWJRjLkNTRx8lZmup8iR6gvkaEQmUoqNMgQKScUUe8J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               "]]}, "Charting`Private`Tag#2"], 
            Annotation[{
              Directive[
               Opacity[1.], 
               RGBColor[0.560181, 0.691569, 0.194885], 
               AbsoluteThickness[2]], 
              Line[CompressedData["
1:eJwV0Xs81PkeBvAhocQPLUUhG1MkOS2OVnq+m1M6Q0VJW1RK2diOaG2pbEXu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               "]]}, "Charting`Private`Tag#3"]}}, {}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}},
             "AxesOrigin" -> {0, 0.4486036125041049}, 
            "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
            "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               RGBColor[0.560181, 0.691569, 0.194885], 
               AbsoluteThickness[2]], 
              Directive[
               Opacity[1.], 
               RGBColor[0.880722, 0.611041, 0.142051], 
               AbsoluteThickness[2]], 
              Directive[
               Opacity[1.], 
               RGBColor[0.368417, 0.506779, 0.709798], 
               AbsoluteThickness[2]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            Plot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {0, 0.4486036125041049}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              RGBColor[0.560181, 0.691569, 0.194885], 
              AbsoluteThickness[2]], 
             Directive[
              Opacity[1.], 
              RGBColor[0.880722, 0.611041, 0.142051], 
              AbsoluteThickness[2]], 
             Directive[
              Opacity[1.], 
              RGBColor[0.368417, 0.506779, 0.709798], 
              AbsoluteThickness[2]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{{{}, {}, 
         Annotation[{
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]], 
           Line[CompressedData["
1:eJwV0nk81XkXB3BryfZLmzCSLGNLikyKPt/STJaYyBRPpWVEUaipUD08tyzN
2GeEEEJ6kCVcZU1I8xTlosX4Xct1s179lG1Q7nPnvF7ndV7v1/nnvM45mif9
nE9JiImJ+Ynyn2p3aphTP3Jp503hP8FAylrVv1fFBRy50kdzIptmJKeVqXgg
aCZrcVBk/jfarABdX3gYhkn+KbJ967vSOyoXMW92eSpNZO0o9XtCjSAIdooJ
T4n8xe7npBO6wfBNUtuvJfJoaGfTiUQWXhmbrHqzyOCQx2zt7yqhOLpaOeCq
yE3Wqo8a08IRP6uWs0ZkEy2rkimNX+GSvPgs9yuDNInjeTrZkbhgO7XESGQZ
3vWsg7oxUDyZF5f7hUFVX3tro0sc1pbtjlojsv9+D7sjifEom3PfcG2BAXdT
hHW0SgLuJ0vX6c0zSMhYW69z+BbGmB0r/OcY2FH5lnVpidBdvj+98G8GFR9b
tjIat3Ffc2xabpbBWXf30ogTKZAluvIbZxhseMUYr89OReSefGbPNIOYwhV6
TrrpsOksK3KbZPC9ek7OiFcGTIc1OQc/MwhuTln+1CUTbVkPHO0/MTAzN4p2
S7yLwDHegCrDIHP1j+G/qeSgZEO0musog6utSU0Hq3LQpd5Wt3KEwcGwPgmt
w/dgaeDZ+HyIgfz0+ZDqtFzkWST7qHxgENiZECjQyIPPrbZgz14GTn/85e2o
WwQbDiejvp2Bkb1WnurzIrSY1k9SHNH+JM8ODXoVo8/Q+7TbawbHKhcfPnEp
QcE7deXulwxW68cZuyY+xOb1KRvTmhiwZMq+/VWlHIoSFY76bAYGe+NvlvqX
wzGqXmG+lEF7mN9I9/NyLPgMxjwrEf2DpFGB8WU27tx/YOnwgEHz1xzjzvYK
8FdZTmtmi+afTNyqEVUJoV+qznQsg2TuFWv2Yh0cnNfHdHgycHW7WzzxqQkj
6VWgFBjICVlH9q57DX/tmYzmf32EjtPH4cbITjw22992pHAcAa8skDzVJfqz
uJnb8wIolyv1iIv3wiVkzsbKXYAKnnXLa0seTgi22T5/MoYG7ztqbgI+ktof
tBoZj2Fa14oqPDcEZ3rLgmbRKCTmCpar6Yyi83ycR7bBKMyFxysOFAlQZjG+
0MseQUuo2atmA9FdeMOPHGxGoBE3Npf3cQKmZyr3bHs7jLHZ3p43Jp9xq/L3
ylq/YeSMVr9QjJkEz0qedVVqGIrq9xk+fwrrpCS6M9OHEHWG7ZmpPYM25bUp
HruHMEMK+KdDZhHbiO1K/YO4uKWpfE3j37CSvtoceXMQvUVNkRzNeYTuKrk0
YTCIBe/OVP0rC6Ce7iabOR9guGvpomf1F8SEjhSTkA/Ym6Xp9VB5EVqb/lDY
ofcBAerHNvQfEeLhvLtU4ns+jAQ/yb1zECOt+2i78Ug+VlITMk3zYsS6VcLr
h+18SD1JLdZKEyePb2nG+jID8DGr7lpmL0Ei/8zwrMoYQIHtycy6GQmStVJ9
/V/OA5geU10+mChJNBzFnF3kB8A+sFcyYY8U8ZP+rnrtUx5CbMIyygelyC7x
8Hixazxocu3eZ4dJk6BIY1sHCx62fxeaoLJlCYlYkuuj8LkfR9a9nhPvWELG
AzXCU0v6Mf0imufPWkrepjglNHj3I1nK/aKztgzJl76kG2XQj5U97CyJJhni
ttlWKUzQB+l/s1wszi8jZtww/V35fRDLcy/mrZAlF7710XM914cLKcXRKxpk
SYCbXfFBoz7UGt6UUfKVI7IW5R3S3b1QsrtgdF1Rnvz4osUk2qsX9Ma2jqAa
eeJ7QDhpLuhBSTq0+e4K5HO0vtbLKz04WmyupL6oQG58fzRos0IP/hN2l0Xn
KxJeW7zFsmQuCofVUxX3UeTs2r32PxlxcfNO2PEeR4qorijgBxhw4eE8rlPk
RJFu1Kal6HHxTU1NicMhitR2Dpzu0+bit9jDzVEnKWJjJfQ/p87FafPbn2SD
KMKkpOyMVuRiQ+gqm6W5FDns2VI/MEFjcds1hXf/pUjXL2OGsgyNrvGB9twC
iqgpXWabjNOIO1R29IeHoj77mVbwCA2hgfMvYTUUucFZdU6VR4PmxKZLdlBk
l1tOiWsHjcfhsz93vKEI3RAqzuLQSNhxTD/7PUXWNxT7572mYX/PuHx3D0UW
7Lh58y9pVAW2/o81QpHglUcj0ptoJG7cGuskoIh/heuL5w00zvPSXDQZipyJ
iDH8VE9Db9/Z3vopiry6kWmzp5aGlHhnTtwsRWaSAqV8q2n0sXd4H5+nyO2C
6z1JlTRqvLM3mXylSFZZzdunj2gkachNC4UUMb2nPT7GpvF/ZxFzYQ==
            "]]}, "Charting`Private`Tag#1"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            RGBColor[0.880722, 0.611041, 0.142051], 
            AbsoluteThickness[2]], 
           Line[CompressedData["
1:eJwd1Hk0lV0bBnChEuWJRjLkNTRx8lZmup8iR6gvkaEQmUoqNMgQKScUUe8J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            "]]}, "Charting`Private`Tag#2"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            RGBColor[0.560181, 0.691569, 0.194885], 
            AbsoluteThickness[2]], 
           Line[CompressedData["
1:eJwV0Xs81PkeBvAhocQPLUUhG1MkOS2OVnq+m1M6Q0VJW1RK2diOaG2pbEXu
l6hckgm5JuuSSyWXijnqOOG4LOnEjzFhmPErl1yS2dnP6/W8ntf7r+ePj/6J
s/tOybJYLC9p/mrOqeHWF8Jft0VI/joGcrbavrSWM14rb62dlfq79DvcMq2T
4C7z2DwktWC1QdAFtg/0zjuWvJbavqmr9J6WP6Z0HkWmSW0Qo5Mj0bsIrq2a
ipfU8xyP5OPsK3BzHIlaL/VISAfveFIQftteYt+zwODgyemaW1ohOPaqNyVc
ap6t9pN6bhhU5eVr1kltttamZFIvEuJVXXM1XxlwZd3zDbOiMeFglsyRWpEf
nOnCvoFtwvUdTfMMnvW1NdU7x8NOuHrcTmpfx5Mct6Sb+Hn7002VXxj0bAq3
jdVKwHyn53zQHIOE9JUvDF0TobmSx3o3y4BDPdxay02CT4QfZSz147E3Foxe
Cuo21hiWTTO4Uai+3omdht0qe3t8Jhns0MnOFv6UjkE3yYeYCQZXGu6qvnTO
APEIjMweZ2BuaRJ7KOk+XHqHHF9+ZJChsTcsSisbXcFTfhUiBpebknkuz7Jx
m6cxkj3KwCW0T3ataw4K5x1J3AiDZVN+V6u4uSCXDTUODDMI6EgIEOnl41Dm
J5X8AQZOt99572EX4TrXiYnpZhCkWLYuUqscFl7cxok6BsZ2NyNKfcvB2zD0
0Pklg7bQs8L/vypH52SlRtlz6b8WmRSYnq+AzQ5J5+lqBg1fs0072h6jzHr1
QmWFdH8iyUIvphLkjGic9YDBnZ5LthULtdjF9QkIjGbw46H7xR8/8dAY7ROl
5MhASRLkZqfbgqTq1rnrvWMwdBobro/uQJfVxZyUs2O40LwFdya7MREmY9E2
I8aKcrVeGRkaR8T1nJvRYjzm275p2cqH0/WkwhFNMeq87606JBLg8My1awa5
IkyxbajCfw2BXhveE7hNBNnZAtVVhiN4as11rW0ZhaXE/fH+IhE+B9vmD3iN
4k2IeXODMYPIUdkl/gqj0Isfnc0f+wjTU5XjFmkjGJ2me/8wG8fNyAUPf5sR
ZI9UNarcmMDydYuM1nQKoaKTxwgEkzjmfCLA+pwQMV4VnhkGn+Fzy8LFR1OI
z6RAcPrqNKxE8uz95cPw38wr16yfQZ1mZOiqw8Ogi3jRrfpzeG6pG9g0O4Qv
3h2pRpe+QKKbwi/lDmHDDwoLnlXzmFFUSNSxG4Jdpv5Pj1YsoP2Kfsmj0UFc
0Dn2bb+bBGPiusi7yYMwER1Q6trNIsKq9MwDOwexnPqoyJtjEaNLtT2/Mh8g
9zy1eC1Xhqifnw5LTP+An82rupfYy5LFv+jn2HM+oOCfJzJqP8uSzkuRmV3T
AkyNaqsOJi0i7NTwB9TvAlTst1uU8A85kvnvNVWargJc3RWaXj4oR9isuIE0
VQH0ezhvs0IXE8/bvuO5rwfw/d9DErQ2y5P27P/KlV0egJtuy6xMuzxRMV5R
Mmk+gKnGWL5vkALJq0nU9hTycUfuqP8+A0Vy9vbxKUEWH8t7KzJleYqkoGeS
+9Sdj8W/BTlv8VtCXMPdXMQr+WDlHy3mqy8lEpOQ8eHOfpy7WxyrXreUrLmx
4OYT34+aDRGKaj5KRD8rONTeoR9qnHMmwSrLSGmEY+pD5X683/i/9ovVy4jV
vYYtdY19KEmDgeCoMqmqd/3BKrYPR4ot1XQWlEkzSsZqnfpwLfR+0PuHKkQj
oIM2Uu9D4bBOqooDRfhc9QyvYhoR90Lde/dQ5LQo7ahHIY2T+8SGRU4UUVLY
te1IAY3V1dUluw9S5NS6YXenPBpRca4NMScootVn8J11Oo3Tlimfll6kSBDr
yRKNOBrfhnyzSyGXIjsiL/v2+9BYsApU7npAkddXo/bQZ2h0iwfacgsoot56
bnePN434g2VHdj6iiFj3VWG3Jw2J8b5fQqspsux325n2ozTet8alLWqnSJ7u
k9LmPTSehk17tP9Bkai/ud9rdqCRYH3MKOstRVK0Xz5o5tCwzzEt395LkVfq
mfotO2k8C2j6T5CQIsmrclNbt9FI2mgR5ySiCPtYe3TbVhp+fK6zPkORM/V5
3Pbvaax3OEO/mKTIcKLNmk5LGnIyHdnx0xQ5/HbuVpc5jb4Ka2/3OYrMDbiw
uzfTqPbO2mT2lSLWWXvfvTOjkaynNCWRUKScNVD03pTGn2d4UE4=
            "]]}, "Charting`Private`Tag#3"]}}, {}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {0, 0.4486036125041049}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            RGBColor[0.560181, 0.691569, 0.194885], 
            AbsoluteThickness[2]], 
           Directive[
            Opacity[1.], 
            RGBColor[0.880722, 0.611041, 0.142051], 
            AbsoluteThickness[2]], 
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], InsetBox[
     TemplateBox[{"\"Forth-Back\"", "\"Spin-Echo\"", "\"One-Way\""},
      "LineLegend",
      DisplayFunction->(FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& )], 
     Scaled[{0.99, 0.99}], ImageScaled[{1, 1}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{0, 0.4486036125041049},
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox[
       TagBox["\"F\"", HoldForm], TraditionalForm], None}, {
      FormBox[
       TagBox["\"\[Beta]\"", HoldForm], TraditionalForm], None}},
   FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
   GridLines->{None, None},
   GridLinesStyle->Directive[
     GrayLevel[0.5, 0.4]],
   ImagePadding->All,
   ImageSize->Medium,
   Method->{
    "DefaultBoundaryStyle" -> Automatic, 
     "DefaultGraphicsInteraction" -> {
      "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
       "Effects" -> {
        "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
         "Droplines" -> {
          "freeformCursorMode" -> True, 
           "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
     "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
     "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& )}},
   PlotRange->{All, All},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.05], 
      Scaled[0.05]}},
   Ticks->{Automatic, Automatic}],
  InterpretTemplate[Legended[
    Graphics[
     Annotation[{{{{}, {}, 
         Annotation[{
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]], 
           Line[CompressedData["
1:eJwV0nk81XkXB3BryfZLmzCSLGNLikyKPt/STJaYyBRPpWVEUaipUD08tyzN
2GeEEEJ6kCVcZU1I8xTlosX4Xct1s179lG1Q7nPnvF7ndV7v1/nnvM45mif9
nE9JiImJ+Ynyn2p3aphTP3Jp503hP8FAylrVv1fFBRy50kdzIptmJKeVqXgg
aCZrcVBk/jfarABdX3gYhkn+KbJ967vSOyoXMW92eSpNZO0o9XtCjSAIdooJ
T4n8xe7npBO6wfBNUtuvJfJoaGfTiUQWXhmbrHqzyOCQx2zt7yqhOLpaOeCq
yE3Wqo8a08IRP6uWs0ZkEy2rkimNX+GSvPgs9yuDNInjeTrZkbhgO7XESGQZ
3vWsg7oxUDyZF5f7hUFVX3tro0sc1pbtjlojsv9+D7sjifEom3PfcG2BAXdT
hHW0SgLuJ0vX6c0zSMhYW69z+BbGmB0r/OcY2FH5lnVpidBdvj+98G8GFR9b
tjIat3Ffc2xabpbBWXf30ogTKZAluvIbZxhseMUYr89OReSefGbPNIOYwhV6
TrrpsOksK3KbZPC9ek7OiFcGTIc1OQc/MwhuTln+1CUTbVkPHO0/MTAzN4p2
S7yLwDHegCrDIHP1j+G/qeSgZEO0musog6utSU0Hq3LQpd5Wt3KEwcGwPgmt
w/dgaeDZ+HyIgfz0+ZDqtFzkWST7qHxgENiZECjQyIPPrbZgz14GTn/85e2o
WwQbDiejvp2Bkb1WnurzIrSY1k9SHNH+JM8ODXoVo8/Q+7TbawbHKhcfPnEp
QcE7deXulwxW68cZuyY+xOb1KRvTmhiwZMq+/VWlHIoSFY76bAYGe+NvlvqX
wzGqXmG+lEF7mN9I9/NyLPgMxjwrEf2DpFGB8WU27tx/YOnwgEHz1xzjzvYK
8FdZTmtmi+afTNyqEVUJoV+qznQsg2TuFWv2Yh0cnNfHdHgycHW7WzzxqQkj
6VWgFBjICVlH9q57DX/tmYzmf32EjtPH4cbITjw22992pHAcAa8skDzVJfqz
uJnb8wIolyv1iIv3wiVkzsbKXYAKnnXLa0seTgi22T5/MoYG7ztqbgI+ktof
tBoZj2Fa14oqPDcEZ3rLgmbRKCTmCpar6Yyi83ycR7bBKMyFxysOFAlQZjG+
0MseQUuo2atmA9FdeMOPHGxGoBE3Npf3cQKmZyr3bHs7jLHZ3p43Jp9xq/L3
ylq/YeSMVr9QjJkEz0qedVVqGIrq9xk+fwrrpCS6M9OHEHWG7ZmpPYM25bUp
HruHMEMK+KdDZhHbiO1K/YO4uKWpfE3j37CSvtoceXMQvUVNkRzNeYTuKrk0
YTCIBe/OVP0rC6Ce7iabOR9guGvpomf1F8SEjhSTkA/Ym6Xp9VB5EVqb/lDY
ofcBAerHNvQfEeLhvLtU4ns+jAQ/yb1zECOt+2i78Ug+VlITMk3zYsS6VcLr
h+18SD1JLdZKEyePb2nG+jID8DGr7lpmL0Ei/8zwrMoYQIHtycy6GQmStVJ9
/V/OA5geU10+mChJNBzFnF3kB8A+sFcyYY8U8ZP+rnrtUx5CbMIyygelyC7x
8Hixazxocu3eZ4dJk6BIY1sHCx62fxeaoLJlCYlYkuuj8LkfR9a9nhPvWELG
AzXCU0v6Mf0imufPWkrepjglNHj3I1nK/aKztgzJl76kG2XQj5U97CyJJhni
ttlWKUzQB+l/s1wszi8jZtww/V35fRDLcy/mrZAlF7710XM914cLKcXRKxpk
SYCbXfFBoz7UGt6UUfKVI7IW5R3S3b1QsrtgdF1Rnvz4osUk2qsX9Ma2jqAa
eeJ7QDhpLuhBSTq0+e4K5HO0vtbLKz04WmyupL6oQG58fzRos0IP/hN2l0Xn
KxJeW7zFsmQuCofVUxX3UeTs2r32PxlxcfNO2PEeR4qorijgBxhw4eE8rlPk
RJFu1Kal6HHxTU1NicMhitR2Dpzu0+bit9jDzVEnKWJjJfQ/p87FafPbn2SD
KMKkpOyMVuRiQ+gqm6W5FDns2VI/MEFjcds1hXf/pUjXL2OGsgyNrvGB9twC
iqgpXWabjNOIO1R29IeHoj77mVbwCA2hgfMvYTUUucFZdU6VR4PmxKZLdlBk
l1tOiWsHjcfhsz93vKEI3RAqzuLQSNhxTD/7PUXWNxT7572mYX/PuHx3D0UW
7Lh58y9pVAW2/o81QpHglUcj0ptoJG7cGuskoIh/heuL5w00zvPSXDQZipyJ
iDH8VE9Db9/Z3vopiry6kWmzp5aGlHhnTtwsRWaSAqV8q2n0sXd4H5+nyO2C
6z1JlTRqvLM3mXylSFZZzdunj2gkachNC4UUMb2nPT7GpvF/ZxFzYQ==
            "]]}, "Charting`Private`Tag#1"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            RGBColor[0.880722, 0.611041, 0.142051], 
            AbsoluteThickness[2]], 
           Line[CompressedData["
1:eJwd1Hk0lV0bBnChEuWJRjLkNTRx8lZmup8iR6gvkaEQmUoqNMgQKScUUe8J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            "]]}, "Charting`Private`Tag#2"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            RGBColor[0.560181, 0.691569, 0.194885], 
            AbsoluteThickness[2]], 
           Line[CompressedData["
1:eJwV0Xs81PkeBvAhocQPLUUhG1MkOS2OVnq+m1M6Q0VJW1RK2diOaG2pbEXu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            "]]}, "Charting`Private`Tag#3"]}}, {}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {0, 0.4486036125041049}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            RGBColor[0.560181, 0.691569, 0.194885], 
            AbsoluteThickness[2]], 
           Directive[
            Opacity[1.], 
            RGBColor[0.880722, 0.611041, 0.142051], 
            AbsoluteThickness[2]], 
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"], {
     DisplayFunction -> Identity, DisplayFunction -> Identity, 
      Ticks -> {Automatic, Automatic}, AxesOrigin -> {0, 0.4486036125041049}, 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLines -> {None, None}, DisplayFunction -> Identity, 
      PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
      DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
      Axes -> {True, True}, AxesLabel -> {None, None}, 
      AxesOrigin -> {0, 0.4486036125041039}, DisplayFunction :> Identity, 
      Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
         HoldForm["F"], None}, {
         HoldForm["\[Beta]"], None}}, 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLines -> {None, None}, GridLinesStyle -> Directive[
        GrayLevel[0.5, 0.4]], ImageSize -> Medium, 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}}, PlotRange -> {All, All}, PlotRangeClipping -> 
      True, PlotRangePadding -> {{Automatic, Automatic}, {
        Automatic, Automatic}}, Ticks -> {Automatic, Automatic}}], 
    Placed[
     Unevaluated[
      LineLegend[{
        Directive[
         Opacity[1.], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[2]], 
        Directive[
         Opacity[1.], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[2]], 
        Directive[
         Opacity[1.], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[2]]}, {"Forth-Back", "Spin-Echo", "One-Way"}, 
       LegendMarkers -> None, LabelStyle -> {}, LegendLayout -> "Column"]], {
     Right, Top}, Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{{3.918330936141267*^9, 3.9183311229759026`*^9}, {
   3.9234581858559027`*^9, 3.9234582236325564`*^9}, 3.9234598494536877`*^9},
 CellLabel->"Out[78]=",ExpressionUUID->"e7ecbee2-5724-4d6b-8cd7-435adab2d847"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{"-", 
         RowBox[{"\[CurlyPhi]", "[", 
          RowBox[{"\[Beta]", ",", 
           RowBox[{"\[Beta]", "*", "v"}]}], "]"}]}], "]"}], ",", 
       RowBox[{"Exp", "[", 
        RowBox[{"-", 
         RowBox[{"\[Phi]", "[", 
          RowBox[{"\[Beta]", ",", 
           RowBox[{"\[Beta]", "*", "v"}]}], "]"}]}], "]"}], ",", 
       RowBox[{"Exp", "[", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[CurlyPhi]", "[", 
             RowBox[{
              RowBox[{"2", "\[Beta]"}], ",", 
              RowBox[{"2", "\[Beta]", "*", "v"}]}], "]"}], "+", 
            RowBox[{"\[Phi]", "[", 
             RowBox[{
              RowBox[{"2", "\[Beta]"}], ",", 
              RowBox[{"2", "\[Beta]", "*", "v"}]}], "]"}]}], ")"}]}], "/", 
         "4"}], "]"}]}], "}"}], "/.", 
     RowBox[{"v", "->", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Beta]", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"Placed", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "\"\<Forth-Back\>\"", ",", "\"\<Spin-Echo\>\"", ",", 
        "\"\<One-Way\>\""}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Right", ",", "Top"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"Ticks", "->", "Automatic"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<\[Beta]\>\"", ",", "\"\<F\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.91833113347233*^9, 3.918331264104656*^9}, {
  3.923458158770909*^9, 3.923458159170043*^9}, {3.9234598628085732`*^9, 
  3.9234598847755613`*^9}},
 CellLabel->"In[82]:=",ExpressionUUID->"4fd55633-c290-458e-bbb4-c51076dc6409"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{
    InterpretationBox[{
      TagBox[{{{}, {}, 
         TagBox[
          {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2], 
           Opacity[1.], LineBox[CompressedData["
1:eJwV0nk41PsXB3BbGku+lpZrIgmThCSUtvenH9KPyqWhtCgmKZVoUVq4ukYL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            "]]},
          Annotation[#, "Charting`Private`Tag#1"]& ], 
         TagBox[
          {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[2], 
           Opacity[1.], LineBox[CompressedData["
1:eJwd1Xk0lVsbAHBTdZS8hMp4kqGUJBWV9Lw3lam6ZgkHIYVEpUSRsTJcuglF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            "]]},
          Annotation[#, "Charting`Private`Tag#2"]& ], 
         TagBox[
          {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[2], 
           Opacity[1.], LineBox[CompressedData["
1:eJwV1Hk41fkXB3BbkvANNZYyIldId9RIi3h/jKaiZX6klVAotFNC4sdQKiQh
WbKmkK17r7KTixLJNqlsiYjb/SpbIubOeZ7zfJ7Xf+d8znmO2tEzlk4iQkJC
lwX532vuNNhU8fmCcfDcf0FDzFT5bLeSFcY+lLOmBP49MSaepeSIF62buj8J
3LdMw/+i5mnE6MrE1gq8o+HN4wSl87hpXjgdJ7BGiMr9OVUvBEclLHUUeMbc
4c4RTV9Mu88uWi7wUGAr90i0P/q3Co82ztLY7zhZGqEUiAin7HZ3gbmmyk+q
4q/ATJnXvlBgvRVGeWOq1/A+MVgy5ieNeBH7DEbqDYgt1wtUFFiiNyBln2YY
ch6fswmdoVHU09xQZRWO6cNlGRPTNM7+z9HcJvoWtBRcAqwE7vztqmmoUiSY
xmFM/hSNyETFCoZ1FLKtFJk6AptTmZvL4qPh0aQqa/2dRgG/fh2tehdMhk97
3ASNk7a2j68eiUV60shA1jgN9Vc0c3lqHHa3q63JH6MRli2nZaF5D0XJedVx
32j8qZKW9vl4IjhJxob+X2n41sQuqrRKwvHtQ8Y2IzT0DXRDD0Yng8tlmY5+
oZG05K8r15XSMPnNJODBII1LDXe4+4rSsNWt4qHhAI19QT0iK6zvg98eIlTT
T0Nq/JxfcXw6gv68eLu0l4Zna6QnTzUD4jOiJzd10NgT0lnwtCIDDJ01pgHv
aDC3aI4HHsnES5+ggYp2wTxZT86ppGahfr3LR/U2Gha337nu1szBmi1G7EsN
NHR3rMhQrs1Bn02YsM9LwX+Lnhz4dDwXChMZee4vaNgVzuaXW+Whv9DDx6ya
xhLtcOaB6HxEtZWWhpfQ8JdgrbymxMbPnHjNhAwaOttuBT8+y0ZDek5AfzqN
5qAzn9/XsnFVTE2MkSbYH1HdLKYHB/rD++uu3aNR8zON2dpcgMRjR1N4EYJ+
R6PXqYYUIrRS5KeWN42YTm9TzmwZfq/WXCBsSsNk2cG0rr3lsAsOK9kDwb4d
Wj9PIrscc4c6hxMNafzK83LIXl0BZsQWIYY+jTMuBgyhjgrosfi1HzVoyDnm
Pry/4RliFdyyTObROHAwOXfkKxcXg4vcBir5oN9bSaYoV+Mvp6jnTaV8XLGV
cNpjWo0vUv9IPi3kg+VwRrkgshqlNQ98PfP5kDltFHRpfQ3cExS31iXxUR3w
9pD45VqsGdisXeTLx9pHsuLLJOog6X5WSWYDHwvn/G22/dqIoHLmhGPKFzAs
+INVN1qx85mfh74zDxdfbUTM2FtI5Ciu1BEfhgJbtktYuBvOKYo2vOLPKOg1
rW/c3It44YpGTdtBPHNNWHqQ14eqoVnrNfIDGNc0orJPDSBFyvqy63A/RKay
Fi1lDOHVvMUTtwr7YDBnX7AnhwfD4wcWL838iPpA/Vc1OjSmCjauGn7UC9Xw
4akM/ggeua+zN3z4AcOT3V1tet+wqsdyZ1JlD9KGiutkwkZxt78gIzajGzIq
D+i+vjEk+w5XD33tRIgL51iSxgR0lrv57T7VgQmS1efsNwmP3CVmIl3vcH4t
l/1L1XcYEvu8xZffojuHe6NJ7QcWq4nOScu3Y9q1NU7bexpLTE57aFX9g1Um
82ePFc9Ajx7jW8S2YVuK2vF8hVn4frObvO7SiosqduofbOaQ6Ct2W9umBbq8
vQvf7BIizOkDe8OONEOeGpHg/hAiXooM71m7JoiVx+WuiBcm2benntv6vMYJ
/eK3C3aIEIl+XdU4RiOyzI4mlU2IENcI3SVa5xswPqy86FO0KMls6pZTH38J
zp5topFbxAhrZXHa0xN18NselMj+JEaiEh6tEFv0Amqd5u2pQfOI0M/DVX/X
12LT+sBIpbXipAE5qYN+NbD5tXFKuEWcSM/tmp06WI3xutDes/7zyeEX6zNN
dLmIEbM9b6khQcKW/90foVYF+S5OighXgjDqv6r4aj/DvMv+VhvPLSDqt0S1
onUqIZRhm9srJ0nKDj3+vsusAm6xuaFyzyQJ72i6pQO3DKWrgiVkTy8kU2pG
rlcUSiFr7qYbICNFxI2dbW7EF6Nj9esWrxIpMvKcv9leoQh596DRZytNQu17
nriUP8XhXANZlVlpYuvw0tnF7wn+H5Ts35EpQx4YVzpfMihA9qBKnMxOitTk
XQiuk+cgOCHIvms3Rfr2fe9+J8OBo+UXRo4FRXazTtjxFnCwrKQkb9d+ijxw
pNrkhDi4ftO6JuQoRb5LFd0+xWPD2eDuV0kviojc26l+qJoN9cDF2+enU8SG
oX9f2pON2Q0+0m8eUoR3t/TCH+5svP3ysTk9iyLeStlOnqfZCN/POrw1nyIG
VH7KgCMbczqW7kElFBlVGbvWYsFGR9PNe6ItgnqjWpt7VrHx9MqkQ0sbRbLM
rLxXrmQj0tBOO7WdIjsuSRmdUWdjx30m+48uisz8oiIvIrhzRZ4NL/w/U0T2
tf8PfXE2olevu2nBo0h92tXzgcJsnOuNt1KjKfJOgjO/bYYFrZ0nuyvGKJK2
2s/Ta5QFMeHWtPBJimw4GbO3gc9CD8fQ1f4HRVrWNZurD7FQ4pr6m95PinTR
Q/s9+1m4o7pwfG6OIipUsk9jDwv/AiMK16s=
            "]]},
          Annotation[#, "Charting`Private`Tag#3"]& ]}, {}},
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
            Annotation[{
              Directive[
               Opacity[1.], 
               RGBColor[0.368417, 0.506779, 0.709798], 
               AbsoluteThickness[2]], 
              Line[CompressedData["
1:eJwV0nk41PsXB3BbGku+lpZrIgmThCSUtvenH9KPyqWhtCgmKZVoUVq4ukYL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               "]]}, "Charting`Private`Tag#1"], 
            Annotation[{
              Directive[
               Opacity[1.], 
               RGBColor[0.880722, 0.611041, 0.142051], 
               AbsoluteThickness[2]], 
              Line[CompressedData["
1:eJwd1Xk0lVsbAHBTdZS8hMp4kqGUJBWV9Lw3lam6ZgkHIYVEpUSRsTJcuglF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               "]]}, "Charting`Private`Tag#2"], 
            Annotation[{
              Directive[
               Opacity[1.], 
               RGBColor[0.560181, 0.691569, 0.194885], 
               AbsoluteThickness[2]], 
              Line[CompressedData["
1:eJwV1Hk41fkXB3BbkvANNZYyIldId9RIi3h/jKaiZX6klVAotFNC4sdQKiQh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               "]]}, "Charting`Private`Tag#3"]}}, {}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}},
             "AxesOrigin" -> {0, 0.06219704911790275}, 
            "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
            "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               RGBColor[0.560181, 0.691569, 0.194885], 
               AbsoluteThickness[2]], 
              Directive[
               Opacity[1.], 
               RGBColor[0.880722, 0.611041, 0.142051], 
               AbsoluteThickness[2]], 
              Directive[
               Opacity[1.], 
               RGBColor[0.368417, 0.506779, 0.709798], 
               AbsoluteThickness[2]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            Plot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {0, 0.06219704911790275}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              RGBColor[0.560181, 0.691569, 0.194885], 
              AbsoluteThickness[2]], 
             Directive[
              Opacity[1.], 
              RGBColor[0.880722, 0.611041, 0.142051], 
              AbsoluteThickness[2]], 
             Directive[
              Opacity[1.], 
              RGBColor[0.368417, 0.506779, 0.709798], 
              AbsoluteThickness[2]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{{{}, {}, 
         Annotation[{
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]], 
           Line[CompressedData["
1:eJwV0nk41PsXB3BbGku+lpZrIgmThCSUtvenH9KPyqWhtCgmKZVoUVq4ukYL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            "]]}, "Charting`Private`Tag#1"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            RGBColor[0.880722, 0.611041, 0.142051], 
            AbsoluteThickness[2]], 
           Line[CompressedData["
1:eJwd1Xk0lVsbAHBTdZS8hMp4kqGUJBWV9Lw3lam6ZgkHIYVEpUSRsTJcuglF
mY4pmTKP5+CgSDJdGUInRDivDJn5tm+vtddev7X/2vuZJK/c1LfjYGNjq0N7
/dS2G2mhj7qdYvv/mgQudRGXfmFDiNlqsra2RsDhuOjYPGFbUE8oXVz3oJi0
zz1ZZ1hcO8lat05T5/vXwndg7OWfjnVLh4gnr5HvAx/nxqx1L2vbRFnLesHG
8bBb6/7l386wjvSBMhEaed0mtnMV/wr7g6UNI3cVmaEuUlQTGwiKCf9Jr1tR
Si1nhvwUPLOV3FaQYzms0mWSgiHkimjcMjKJ6ZtoLPsPVDzqerOEXDrQ2lRj
GA6eZWUui8guurba5pHP4Gbadv4FZFn6bN1M57+QWHrmwRzyt4OP1UOFIyBX
NSVrFjkibiddxuwF8JxNoE4ja2NvT1bGRsKZkoTLv5HZvFVLjPuiwFxNuImF
XMj6dJQgvwRZJe/5MWQnCuX9Y+tXkJep2zWCvPszobArKQY+3uFzGkL+quaT
UTwYC5SZc5nfkf/J3LZXT/YN7FL1ffkN+aw4lTpqHwe800YHupC96l7xVRnG
g5CZmV07sqnXj4uhs/FQih861Yx8RFk+1DQyAWoXPPM/ImOsO40yKonAQRli
1Kz/d3IF91RnInBXiTlVIMcL/R0YJEyF6B2fXbORPZuiGMalVMgZqvqYimwc
MMAhZZYMnmb3MuKQeWZdvctiU2BCwngtFPnnu9KKx2qpMKoo7eiPXG3LuWzQ
lwqO9isGHsju7RHu4+R02E8YhtsiG4R8Kyymp8PMwcRvl5AVzsjO+lu/hZxr
0THn1/Mpr8hVPCkDnjKMLZSQ9Z53O1yUzQLtJlHqn1UC5HWk0kXqsyBqS+ju
YWQSp9PPYfts2CzVvdCObFmymkszzIHecz6pOcjnhaRaZJJzwOuetPtr5BOu
GpPBszkwX3k08imykFy4wqXIXKCIO2ZbInME5F+oHM4Fs7w1qhby5MBXJ2mV
9xBr8KNXCbkxWjJjsvM9GJOySJzIPqS8PU+F8yGOvMj1aoWAfRrPnrx3yQdu
SQsTT+TWgJujPfX58CnzXq4ZsjSnfIbC3QJQe5ZzUxi5boWq0N5aCP0NSSVP
lgm4edIvbEWuCC5jJMIaeaen9aSsTxGIxvltO4F8fV78/f2DxRA4Yb/j5xKK
x3TkUXJICbgzWmoOIxcccovU/FECvuRcQS5kiovBnOuJUtg9/EK1bZGA7Ams
hDFSCjGTXWs3kPVHnpx0OFsOUe8ebXuxQMCSrP3r57HlkPjjRY0ZMtXu7Gr5
dDmod0gckUSeZbLTscQKOCv1XjNtnoDobx7qBauVkKW/fzZljoC/xEypfUY0
EHvOYWKD/OuyygZSJg0UHBVsJJAlxu/bZB6gw6KbpUv4H/Te68oybL102PLb
YqftLKr3J8kdEZuqYHfKaKAQ8s40wUC5w1XAps4XUjtDAH14alg/qAoyi4t1
JZG32WanJR+rhldKjr71UwRc9ZMwPWFbDdTBWNsbyGWJodzNYdVgkEhq5Ee2
/e7oMD9cDb1PqkSNf6P/ouyV13lRA2QnPPwTQcAl04Tsyd8MyM83nnIeJ4Do
MdycKFILRjalNZzIgRSSnYF6LWQkOB+IGiMgz+amSGFELfC6J9SU/CKA11kt
wFOlDnZdGf0yMUJArW/X5Y0P64HfLnIv3xAB5htCC4qS60G3tL8pdJCAqcc4
3/XP9bD93oMZbuRdoam1jeQPUBnnSF9hEvAgyk3xWfUH4KpYU2gbIEDpHf9G
MVIDNBut6h7pJeCjQq1Vk2IDXJRyvfOyhwCrXPcyL9MGCGV/u2Glm4DQwn6X
728bgAdfcaJ1ETBCz+xJudAIHNz1ioc6CXjToZV76PknsLstRq1vIWDLmo+5
hkQznBEqf15Si+J73YQif64ZquiVUSwGyt92eSt+52b4Uha/LIl8Kr3Tpqei
Gf7iUh32qyagJD2yoEjhC0S7M2WO0AiYMBgv1/n8BWY+bP5wtpgAo7Soxttb
W8EqOi1eLh31bwvf81clW8HtS2WkXBoBzG03mi4dbQXqPqnePakoPx6eblaz
aIWtYbgBOZmAp/oTrZsyW+Fc1qGRhXgCKpZPd8ecb4OLPPKWFtEEyOixRmqC
28GQoufbE0CAiLfGCfuEdnj0y98syJ8Avsz44M1F7fBwyuqAih8BiyQDBT1m
Oyzfo5QGPSLgC73odt+xDhAZEXIT9iTAQ9FndX6oAxKyRAw6bhLwGRMUVMA7
Ye6ShHWdCQE1ajfsWow6gceOteeIMQHFjnWFdxw7wWs6YDjOkICkenfTsshO
6IgP0XHVQ/3Q+9sbzYlOWB5eKF7SRvOASJGzefUVnK0cNbPVCLj3+ThEz3QB
Lex337+SKJ8UCoY+krqhoSL/ZD8Z1WOoYsiSWDd42ej0ykkQ0HJ+TxflLLrP
3c8sESFgf6PgbZnIbsjf+Iy/VoCA/noi5b1KD+hr7dR+soEAjapk3iaPXhAk
89MYP1mwI5+/j529H2TZKEEKqSwwD1kyHNzeD7fsrYgBKgsSbYca6+T7wczN
w+FZIgvkhUpKgi/1Q1D5dPL4axacvmv1QiinHyJED2uERLBAOdYkJeLgAFSv
hA+4+LDAmpJikdY3AJbi2Ts6TFlQyFT/1HySCcwxfeUTG1hQ7fBa1HR8EC60
tuq36EzArKwalnnjJ4yYzZfQg8aBYyGDT1TmFwTfrDfwSh0D5TWrQoOscThs
dtX5WN0v+OR/5HPdPhQH9zeXrQdGgRw+tpDOmoRckWs55wdGYGyuv69DcQqO
U1s9mRM/gfqrrIH3n2k4pRp4csfwMPCKpxKDgzOwxyNI3nVwCEKuF1yNl/4D
Rc2Be4XmBuEPnjF4zXsOrvHLnrZc/AF3lBj522vmQeHIzGE+wR/Qn8UIbpFc
hDID70vBkkxYcmiPkfNYAm19P34t1e+w/69Nq1fLlqGwV3mRcBwAjURJ+9wd
q3CyO69t355+uCduufu7+Ro8ddV5aJH0DeTHjbZ0XmDD9+ZLy7or94IANkli
LLLhd8cK374t6wYuWky2VCw7fo1doHf5ehc4Hinr4tbhwCvtO8XGeL5ChtaV
+Mo/HPiQsJbKSN1/MDsmwjccyYmf/uR3QDu5AwoMNDgjznDhwTZtznc92sFb
MyAuf5gL35Rr767n2gaS37S/JgVswNfUTxh33m+FEyr+EcJKG/FtKe9uZ3m0
gLlE8wJ720bcgGIZSI3+ArMNoUwXn024ea7YuTNWzRDNRbmjL03CxXhMlvwY
TSDQV5DIwSDhmt3xgRNnPsGGhz6Gx1258XghOTfN0gZgS6dkM7dtxpecXl+W
sPgIt15lh26r3oxPybeHv/hTDxX7n5D4nbfgghWPmlPS64Bf+5a8Ly8PrqIs
vRP8aqH3wJe2++XIT3mlqwwZkPMGpAcpW3H518erz2jVgEW2Mr/46la84Ybm
aT3dangUkODT+5YXN1e7G2qoi+bIiHgM73kMJ/DhLJIzHZ68DrDqu4jhj8lu
rYoOdLDVn5DJ0sPwramXekyv0kGsvDznggmG60xox2ZR6BAUZlYXcgXDazxF
O678TYdryi9/b76P4c+kgmdmFemw219Qc1MKhh9kdi4FjdJg9diDrZ1pGL7Z
K65JgEmDrokfrSkZGN7nhFm86aZBuEmexblcDB8mXcwrbqTB2j792wHlGO7k
J6DEkUWD3pawN5xtGI4t3SKP3KJBceCcTVsHhkeK9MSEONIgQtVSLukrhleW
hzQr2dJAJ1kh/3Qfhrv3qZj5o7lc6t700WcUwyMYCfOqx2gQeeBomN44hssE
a0mzFGngyow1lCQwfKZCgCtRjgZ7zzv102cw3OjRwz5eURpwsbdTw+cwfEjf
8Gu9AA0GClQdrBYxvGJHub8vDw3KHZIOKq5guHqq7o9TG2gQRd4yu7aG4X+I
zOnllUr4H/8YWmQ=
            "]]}, "Charting`Private`Tag#2"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            RGBColor[0.560181, 0.691569, 0.194885], 
            AbsoluteThickness[2]], 
           Line[CompressedData["
1:eJwV1Hk41fkXB3BbkvANNZYyIldId9RIi3h/jKaiZX6klVAotFNC4sdQKiQh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            "]]}, "Charting`Private`Tag#3"]}}, {}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {0, 0.06219704911790275}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            RGBColor[0.560181, 0.691569, 0.194885], 
            AbsoluteThickness[2]], 
           Directive[
            Opacity[1.], 
            RGBColor[0.880722, 0.611041, 0.142051], 
            AbsoluteThickness[2]], 
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], InsetBox[
     TemplateBox[{"\"Forth-Back\"", "\"Spin-Echo\"", "\"One-Way\""},
      "LineLegend",
      DisplayFunction->(FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& )], 
     Scaled[{0.99, 0.99}], ImageScaled[{1, 1}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{0, 0.06219704911790275},
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox[
       TagBox["\"F\"", HoldForm], TraditionalForm], None}, {
      FormBox[
       TagBox["\"\[Beta]\"", HoldForm], TraditionalForm], None}},
   FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
   GridLines->{None, None},
   GridLinesStyle->Directive[
     GrayLevel[0.5, 0.4]],
   ImagePadding->All,
   ImageSize->Medium,
   Method->{
    "DefaultBoundaryStyle" -> Automatic, 
     "DefaultGraphicsInteraction" -> {
      "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
       "Effects" -> {
        "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
         "Droplines" -> {
          "freeformCursorMode" -> True, 
           "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
     "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
     "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& )}},
   PlotRange->{All, All},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.05], 
      Scaled[0.05]}},
   Ticks->{Automatic, Automatic}],
  InterpretTemplate[Legended[
    Graphics[
     Annotation[{{{{}, {}, 
         Annotation[{
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]], 
           Line[CompressedData["
1:eJwV0nk41PsXB3BbGku+lpZrIgmThCSUtvenH9KPyqWhtCgmKZVoUVq4ukYL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            "]]}, "Charting`Private`Tag#1"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            RGBColor[0.880722, 0.611041, 0.142051], 
            AbsoluteThickness[2]], 
           Line[CompressedData["
1:eJwd1Xk0lVsbAHBTdZS8hMp4kqGUJBWV9Lw3lam6ZgkHIYVEpUSRsTJcuglF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            "]]}, "Charting`Private`Tag#2"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            RGBColor[0.560181, 0.691569, 0.194885], 
            AbsoluteThickness[2]], 
           Line[CompressedData["
1:eJwV1Hk41fkXB3BbkvANNZYyIldId9RIi3h/jKaiZX6klVAotFNC4sdQKiQh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            "]]}, "Charting`Private`Tag#3"]}}, {}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {0, 0.06219704911790275}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            RGBColor[0.560181, 0.691569, 0.194885], 
            AbsoluteThickness[2]], 
           Directive[
            Opacity[1.], 
            RGBColor[0.880722, 0.611041, 0.142051], 
            AbsoluteThickness[2]], 
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"], {
     DisplayFunction -> Identity, DisplayFunction -> Identity, 
      Ticks -> {Automatic, Automatic}, AxesOrigin -> {0, 0.06219704911790275},
       FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLines -> {None, None}, DisplayFunction -> Identity, 
      PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
      DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
      Axes -> {True, True}, AxesLabel -> {None, None}, 
      AxesOrigin -> {0, 0.06219704911790261}, DisplayFunction :> Identity, 
      Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
         HoldForm["F"], None}, {
         HoldForm["\[Beta]"], None}}, 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLines -> {None, None}, GridLinesStyle -> Directive[
        GrayLevel[0.5, 0.4]], ImageSize -> Medium, 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}}, PlotRange -> {All, All}, PlotRangeClipping -> 
      True, PlotRangePadding -> {{Automatic, Automatic}, {
        Automatic, Automatic}}, Ticks -> {Automatic, Automatic}}], 
    Placed[
     Unevaluated[
      LineLegend[{
        Directive[
         Opacity[1.], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[2]], 
        Directive[
         Opacity[1.], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[2]], 
        Directive[
         Opacity[1.], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[2]]}, {"Forth-Back", "Spin-Echo", "One-Way"}, 
       LegendMarkers -> None, LabelStyle -> {}, LegendLayout -> "Column"]], {
     Right, Top}, Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{{3.918331136676109*^9, 3.9183312645150566`*^9}, 
   3.9234581600004296`*^9, {3.9234598733096447`*^9, 3.9234598852131495`*^9}},
 CellLabel->"Out[82]=",ExpressionUUID->"9a82c7f7-5f13-4394-b2c1-2f3620bca022"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogLogPlot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{"-", 
          RowBox[{"\[CurlyPhi]", "[", 
           RowBox[{
            RowBox[{"\[Gamma]", "/", "v"}], ",", "\[Gamma]"}], "]"}]}], "]"}],
         ",", 
        RowBox[{"Exp", "[", 
         RowBox[{"-", 
          RowBox[{"\[Phi]", "[", 
           RowBox[{
            RowBox[{"\[Gamma]", "/", "v"}], ",", "\[Gamma]"}], "]"}]}], "]"}],
         ",", 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"\[CurlyPhi]", "[", 
              RowBox[{
               RowBox[{"2", 
                RowBox[{"\[Gamma]", "/", "v"}]}], ",", 
               RowBox[{"2", "\[Gamma]"}]}], "]"}], "+", 
             RowBox[{"\[Phi]", "[", 
              RowBox[{
               RowBox[{"2", 
                RowBox[{"\[Gamma]", "/", "v"}]}], ",", 
               RowBox[{"2", "\[Gamma]"}]}], "]"}]}], ")"}]}], "/", "4"}], 
         "]"}]}], "}"}]}], "/.", 
     RowBox[{"\[Gamma]", "->", "100"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "2", ",", "2000"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"Placed", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "\"\<Forth-Back\>\"", ",", "\"\<Spin Echo\>\"", ",", 
        "\"\<One-Way\>\""}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Right", ",", "Top"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"Ticks", "->", "Automatic"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<v[\!\(\*SubscriptBox[\(l\), \(c\)]\)/\!\(\*SubscriptBox[\(t\), \
\(c\)]\)]\>\"", ",", "\"\<\[Delta]C\>\""}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9121487913703165`*^9, 3.912148872954629*^9}, {
   3.912149003283339*^9, 3.9121490480200877`*^9}, {3.912149113955144*^9, 
   3.91214912169019*^9}, {3.912149153443112*^9, 3.91214919107539*^9}, {
   3.912149229883738*^9, 3.912149530308386*^9}, {3.9121504453419113`*^9, 
   3.912150495029168*^9}, {3.9126600508721237`*^9, 3.9126600684130945`*^9}, {
   3.9139003897078753`*^9, 3.9139004055567245`*^9}, {3.913900442536319*^9, 
   3.913900464208683*^9}, {3.915954246905867*^9, 3.9159544041138372`*^9}, {
   3.915954459689826*^9, 3.915954459872744*^9}, {3.915954498311854*^9, 
   3.915954498421893*^9}, {3.915989249807095*^9, 3.915989250169559*^9}, {
   3.9159892902434177`*^9, 3.91598944055687*^9}, {3.9179232947549887`*^9, 
   3.91792329485262*^9}, {3.917923345213814*^9, 3.9179233522628098`*^9}, {
   3.917923398473607*^9, 3.9179234751287727`*^9}, {3.917923558524783*^9, 
   3.917923646302877*^9}, {3.9179240576210957`*^9, 3.917924064973256*^9}, {
   3.917924123695636*^9, 3.917924124448052*^9}, {3.917924211091757*^9, 
   3.917924258010625*^9}, {3.917947807779028*^9, 3.9179478449056873`*^9}, 
   3.918330883840578*^9},
 CellLabel->"In[85]:=",ExpressionUUID->"64b4ffda-fbca-44a9-85a2-e900e164232a"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJw1lnc41f//xo9VyMzKzK60jAZSz3cZUZSdGSqSTciOklFGVEgZDSUtpGG8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         "]]},
       Annotation[#, "Charting`Private`Tag$219681#1"]& ], 
      TagBox[
       {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwt13k0lN8fB/CxZC1LZCcSNSpriySfJ1tIkqUismVJ9n1JIYoiabOECJFK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         "]]},
       Annotation[#, "Charting`Private`Tag$219681#2"]& ], 
      TagBox[
       {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJw1lnk8VG/UwMeSyE7ZTTRRJFlapPqdayuECBVRUiiyJkupKIlSiJAtyp6E
tJB7nylEspUsRaWy7zPG2HlH7/vef+7n+znf5znn89xz7r3yjp6HndhJJNIw
G4m0cs9IzzPWU+0DHtLKRavoWIWbpEEf8P7jyQoBt2azWfM+EPjHUxUGzX/N
rRz7QOQfz1QE7Zg+/PxCH4j/4/mKF0lrrNfc7AOZf7xUMbQse9Qp/v98KgmX
d1K3oeb8v8+BH6vTPy5d9n8+tgqP2nbM3q+uDyj//NX4hzi3k587+2DrP16D
L8xePaUy2ge7/jE/rnny/ulbS//vC+GuVVlOfwT7QeUfi+DpSmUu++T7/9cn
rcPb79WfS9ToB/0VdBDHBRi/3Cb1+sF6heWkcAObSXcz635w+1ePLB5EcHnl
OfeD3j9fDi+hSPlwBvSD5b/4BnwwfKvvyYh+OPsvvhGXG8P8ypP6IeRffkX8
iKVVwLqCfsj4F1fC775xueSF90PtCpur4FWyl4M+NfbD7ApHb8Pnr9+7qtjd
D8krnKiOawxkBIfQ+oH6jzXxs6Yvr3exD8DYCjfvwB+V1IbuWjsAm1jPk2So
hbeJd4XdVxgA9xXm3oPzXRkPH905AFUrLPQfrveH/Y6h4QBIrPAbDL90QOzu
E5sBsF3hRF28uEApasl1AJ6ucK4+PiC8L8YmaAAEV5qFsR8n+5vHlt4dgIgV
DjLCrbtOPxB8NADyHCw2McEjdfwTXIsG4NsKnzmEv8++/bD63QCcWPFdLfBZ
3rRkuZYBGFphc0tczbs49XLPADxY8V2tcZe2qkdtUwPgwsniiqN42p6ODPXV
g+C8isXGtnhr+vCTSIlBSOdiMdke5+NazupXGgShFX+9A67nJpKru2cQZle4
/RR+qVkhP9VkEMRWfPw0XrRjd8GM/SBcWM3iVie8P8mk0NJzEKRWBoByFieT
HIoKgwdh/coAFLriVk4XSnjuD0IcP4svu+N36sJKzzwZBCPulfP2wt9vS3qF
SgdBcg2L57zx2bhnb6Q+DIIZH4s7LuBqc9Tyi+2DsMAaoODei7jLya8VzQOD
sIc1EMGbAvC0qn5iy9wgqIix/CeX8FaleWoY7xBMSrHi9ldwviiByt8yQ2Av
xGo31WBclyFfvVd1CLpEWfGWEDzQZkdNAgyBuASr3TJu4EWE4Ue6+RBoyrLi
qTfxPordJ1PHITjJGhCs7hYuG+HZkHthCFqUWfm23satxq43cdwcgiZNll8X
ia9pPXH7a8IQZAHLH4zCqW+1DbLyh0B4E4mU/iwG93ssRvLDh2BkG6ud42Jx
lQh6+f7mISC0WeufPcD/eDZeFP/Lqv8AidS9mIAnHslXG5hirT/GyncnCTfb
Fzb8hnsYXrEGjGqbiq/a6JgdIT0MX3RY/u50vGLNf6dsVYfhjDkr31gG7kOT
lNmiMwwyjqx8TU/wzR1TbfOWw5DtTyJ5dWfhP4nPMfXOw9AcwxofxVw8LuuZ
SWrgMNwvJpGKsvNx48iI1R6RwyDewVrv/AwnXXB6/98j1v43WPl2FOGvbHSu
CJYMQ/4jVrv/LMbPY7Ja3VXD8Pcd63VQ/ALfsGmWXtQ+DAeGSSSt4pd4B3/r
s5ChYTCTZSOp/X2N32MUnT28OAzlNmyk3IPluH5nJIUiNAI5j9lIReMV+Ny7
sz8nN4xAyhwbifoV4UW5+g+rdozAIQ02klfwO9w5Ss7qgeEIbPJhI+nvq8Rl
/BYEnI+PwBLBRjqzsRr/YtfxcafHCJyVZidl7q7Bw/VKQ1eHjMCV2+yk7SEf
8f+Uo6EjdgQGBTlIicufcIbQ+bnc7BEQKOIgvSlrxPOnD7wMLBsBES12kt/3
ZtzhJ8XLuH4ENJ+yk65e/oKLVy8rS/8aAakdHCQxva9449PO3mHaCGz9zkF6
vL0ND73/Or2CcxSyH3GSvlp24NqBscfvio/C6zurSNmZ3/GJk55iJ5RHoSKL
i3R+yw88e//Bz6r7RsGNuZrUPPILt9u6KXL50CjwV3GSaH6/8dq5n2wZF0eh
pZmL9OJPD371d3mFd/goRG7kJol+7cO318b76yaPwqc3PKQntAF8qNBHQ7Rw
FIIf8pLWwzCe/sBs9C91FKq+8pPuUUfxI0HKuaUto5C0j5uksG8C5zvNdfpm
3yhoNvOQbryh4QFqRIci3xi8/ssfLLpuClcVT4qdJo/BtutCwZPzTLxn8aJZ
rfoY/EkWDX7FN4sn9VjwPNQfg1/7xYNrjOdx809bq84dHQPeVGlSW9kizlXC
c03bdQxOnxCijqiSiIrE3t28V8ag44xo8J1UNkLJOfV5weMxiFORDl78xkl0
mwS6Xnk5Br0b5DBaARcRr2mtYFY7BlvmFah12dyEiZR6N7lzDK51qQQn160h
2Nn4k8dHxyCKsR0rkuYn3vQPWFNJ45Af8B8WmypIeDRWCcWIjsPNlo0OPMrC
xPfkoDCN3eNwREIzuHLXWiIrhluwyngcbgTtIT1qXkd43YpLsLYbh61aBt3q
4eLEnitycv3u41AebJ6e7yBJcF0oyA24Ng6Zsfbd9nbSxOezWuprYsYh9fV5
uZorskTKiaqy5MfjMLnvanpkzXpC3birjqgeh8dzVnItnhuIBThrad4+DnZh
jsES3ynEhx2Mzt8D4/Bri09w9QkFImZL8JkLc+OwfW9o8NNlRaJQKMyPnWsC
9q592FxGbCbieOu1PwlMgC252Gs5VZkI5BJZjhWfgFNf6x2ePVIh9BdSbyko
TQD9ffjmHxFqhPL034Nj6hMQM5wql1ytTgjSlYRea09Ar+6rgAJxTYIx4vn1
mt4E/IUvcvdCthPf+18mGppMgJUr/c1Xzp0E+jNvJ2w9AQr24sKqT3YRmT90
5L/bTwDnR51AxxO7Cc+Whjw3zwnwMM3/xqu5j7BqFPXYHjABSeZDNpnmrNfc
RxuNxeAJEGyV3Ff8ESPWVz1iVkdMgFibXm/rkg7BiXrL792fgIzhC06rjPSI
obIt144mT4DqRH5gYp4+0VTqrSeXOQH9nYPeC/L7iaT8xU/FLyega+qGmK2D
ERGcpRd9iZgA38bfJY+UDhJO6RFWejUTcGHU5Lm5sClhnNwkwdc8ASUba05a
Sh4i1OLX/fjawdpPR0m1NcOcEIs5npH6ewK4igIWtD9aEPN3Mpych1j1qLYw
5zgsiQ8hW8em5yeg8dZzsHtjTRQEXSihctIgYm67eez2o0SMf5lfBD8N7N7W
j1h8PEb4+SxrHxajQZJWYIJogC1h526wLLWeBh5q+8TO6doROmfvVP7dRAOi
XDpqVukEoXj6860CNRrIKvN905FwIGjH7IX+06XBtal92kvmjkSb5ZOvXAdp
sH4zM8w3/DRRYTaY2GRJg+zvH2acW84QGUbb7BPtaDCm+UJrVsOZCNO/KH/K
iQarEFF2IteFOA9ve5U8WPv7j17q3H6OsNBmy6f70WDkq15n1TdXQkbtrkZo
OA24NYNG7vl4EOxbWpgmMTQ4J7rjRsV2L6JfQfLtuiQaKPYf1PYBb6JEOksv
5ykNzvsNxpHDLhCJYsOrvUppYJsWyE2v9CWuCKvXa+E0yI3f20Nd60cYrsat
6hppIP2Y0ZMwGUDUyZxccG6ngZz4cEnL5UvEQQ22TI5uVv2E6oM8qSDCzN5g
ci+NBs1qldG8GdeIZp/+pG+zNGgr/7r/YXUwYREeoevHTgcOodAzD2pDCKsX
DTHPRelgK8dIhvkbRFut524TGTqwma36E6xykzj6U/j3wEY6fKBqjn/2CCNs
eY6obdhJhwMn46y0lCOILvJMO/EfHUgxv25pZt0mTmxPunb8AB2eHbm0mXdH
JHHq5M/GuGN0cJXPUEtLiCL++Ab7qZ+iAyPoY6z5q2jizO0N5MZzdIjdpeYQ
/iyGOPvS2X31ZTrIK5SFP6+KJYbquNdl3qCDOVV8x0JvHOHWnV+BRdIhXmef
T7lYPOHBO857KZUOoc01Fel5icSEXMwLsWw6nND3zzjHn0R479Q8/qKQDrmf
/wT13UgmfE/5548gOpT7/SjKKUgjmH6ShyNq6aBUNjXurpZO+Ee+nVX4TAd3
mpLul3UZxKXXy4Yn/9ChSktmRw7nE2KhPmNifogOnY+1mvYJZhJX/uglJk7S
YcFZUMBtUxYRzB/e/5lzElQTOfVlb+QQ7BTlKA/+SThLE3u7WJNL3NCq38kr
NgnZInwnVGTzibDTQmH6mybBLN/M/ep8AcEdWLL197ZJOCDgeXxPWCERcc+q
9YrWJGj46vPsEykiIssSN742moQiSs+a8KZiQqBJu97yMMsPdYZMooSI6um6
MGE7CRJe+CfHshfEfUH5SqXzk3Bz7o3Xr5aXxFqFStcPvpPQ8TzS7DXjFfFA
20nk9JVJqB0e9nSivCESnfJOpdybBJ6fI5mvC8oJqcsHeXYnTMIaWcePmdwV
RHL0aFHro0nYJcxLnfPFibS36iTB4kmYUKha8xOjEnKfW3Kelk2Cr46eeYvw
OyKj7+Ihw/eT4DLS6BI08o7IFC5PC2mZhBsxAlX3qZWE4ia7/eSuSfgu+jTw
Z3kVkbt3abS8h3U+uoRiMrWaeOqiu48xNQnkoJQ7lhM1xAhu+O7g8iSMH773
SH/HR0J17SGDJ9wMmDUcvilxu44ooh43PSzNAL+8zjBd5waCJub4OW8jg/W9
6LovPt5IaLiftWZTZUCs6osBZ4NmolTyon0RxoDllHhrieXPxJTn5d+rjRmQ
NbX8uGH4C7HzQ4jTSUsGCIZ8aiz+20KU+dxzF3BmQN+FFNEpZisxVxtHc/Jk
QHxpBN9R0XZi7/rki3gAAwqyIyZG93YQxKecK+fvMOBV1Uv+6bLvxLJ8IVtV
HAOyu/Na4wS6CCyg9KZ0GgNI9sw5wucHUbnx3d26Igagqym44s5ugvNyjfCG
cgYQOg3Pb7L9JvZ/bngQWMkAT+WIcM6230Ttle+pm9sYYOi57Pwz+S/B87Vb
PvgXq/7Su2Kkez2EsXJ/VvsAA1TOkTWbbvcSDW2Tz8LmGbA228BAObuf+LKN
n+iRmwJTaQ7ZZK8RQjRMVHev8hTUdNcPtVWNElZdkh9iNafgccqXhOhN40R7
uGKj7v4poKY33DvOTyMkfqkcTjo0Bb/uV2KKbTTCdodmG+3YFMjxjt49lkMn
un7Dz3S3KQiNNfu46wyDkNXa7zjjOwXe2hWb7ppPESfumfQdujoF3ecKNibv
ZxLd2jZjS9FToOVYt87cYobojfVZsns1Bc7fNvHXDy8QikMB10vRFKhIJySG
qC0RZ7FrXHwfpyA1YjpW5voyMTRyR+Bt5xQM1U+ZDiuyoS169++L9E6Bm53C
Zt8eNnT+YaKY69gU2Igc93fMY0djBllkSTYmJD5MsfQz5kTbUp4+9lrDhJ4x
MbmNm1YhL3qxYq0oE/TcZpkH+LjQZBqh6q/IhB+xzWckaKvRzHT7f60HmWCu
ySHsuJUPVVm/UrprxYRtGXcPiOjyo6gXcWsN7JmwUWk03sxBACl6WgyVejCh
+mquv7G9EKLXb2s9788Erz09GinzQghXFqBuDGaCw+Bub9NHwsiqr+5BXAwT
dMI6s3ymRZCcfl6wSRIT1hnp7NtTIIqGM265cT5hwp7uqCd8LmvRdXt9Hd9S
JojSjpRcHV+Hir/iI5btTGh49dynyVwSBWmktPN2M2G/mFU91x4pZBh96X3l
ABN6P/D1NKhIo+6DuxI155gw6rpdpXeTLCrIW3djmH0adqwJOp+lTkb+qxnu
T3in4XyQxINWvfVIoLJIT1R2Gr638s3tfieHvstFqX5SmIan2xysC4/Ko6yr
7pI3VKfh595w5Va6PNqrrTxOh2lwJ+VYVuyiINfiJ0lfHKfBhnl4e86yAtop
eP3mbbdpuLHzzOZTSBGxuTt46fqy1uv75/eEbkKJm2X3l9ycBj7SjOEfeSX0
4VE8LSZ3Gpz7NUKkclXQ/UXfLqPiaTAUqha5mrQV2R+3rGErnwZu/RATRqwq
YogJpXp/mgaexbICZzM1RLkXYWgxNg0R+emy+Tc10NiwiybP9DTIxVi/KpXV
ROVG+8nvlqfBGN/Gw1OuiQ6v4mCoCc/AFvtZ+vTydhQcFPRIaPsMaEiXDAxW
7kIm321v1+6dgZGXaSLaIVpIXGv3xWCDGfgcukrghd5uVDg5ZTxxZAaS2p7h
iR3aqMvVk9kUOAOlaR01GQb/IReeElz3xgxUDgeqXNcDRM9hhL6MnAHT2VI9
i40Y4ukNFE1+NAPihv7k/O06aOfJUDXn6hlQLc5cRKF66N3ih+mOxhlQYOZc
3UbRRyYpPOhgxwzMl6+6M1etj05/u2eqPjwDFn+Nu7kl96Noy4euC0Kz4Fnm
E9s7bYik6Z3qnlKzsN/oWzJ/hRHKjibP/qbMgk2exH2Xm8YIb3hyq2bnLLxN
Nm3cuNkEDR0ozLxvNwvuprcvcBUfQhf7JtxWOc8CWiw8uWRujkg3NTUDPGeh
Y8utoTv15kjs/Zt39tdn4XehjuH6Bgukt7fy5+bcWXiy7RLPwpQlavy+Kju5
eBb+O1ac/CPcCtkGGroLvJ2FNzL64zbrrZHXq4b5yYZZED+yNsHt6BGUotYh
gSZnof2qf+ni1DG0qUmqW31xFo4p7TxP5NigEnf7nEyuObj358ObYntb9DH/
z47bknNwIIwjJ7jtOGJuHD1sDXPw6FBqF9vSCRRSuU2q1nAO1uZmhSa0nER8
jj6/tQ/PwVxtUgnHUQdEeTTtKec0B4kF06r9WqeQuST73eHbc+AssepmmfRp
lM8vXhPSNgftxUYvOl1c0JcPL71rf81BV1eIwoYFFzR7zUpGcHAO8v32PPGP
PYsM6THeKfNz4KfyQj7k0znU28Yn81puHr54vBL3cDyP+KKfflhUmgezl4dW
Rwq5o+1Gxt76mvMwYy7wlPzeHV1/e+vDZ4N5qPIQX2jb5onk0tm9R1zn4Vz2
F4UwaW90wCZDWtN3HhYUrZsoId7IQwT7EHhlHlTc8jaWDHgjPPSK9OpoVvz5
w/kK3AfZnpupln85D4XPrC0tg33RA40xqaPL8xBxXU9wxD0AVQxHVqdyL8DI
CcXC+akA1JO5xatHeAHejp+18AkORBri56q9Ny4A+wSt80XKJdQ8/9cz0mgB
RD969Z6ZDELTpdelWg4vgD9Px56IqCuI7CFfLWm3ACXaX6StVK8i9+4TUjke
C3D9/vTS4oVraE31t6p3sQtgFB7Opy8UgjSuBnhypy6AkJ8I+fS5EGSzS1zq
UPYCuBdyXmRWhqDcPCvPrjcL8H1eoPb2levI4F6T5PSPBeARefOmmz0UBR+t
9lDZvAi6OtxUDttbSENib3CL2iJs3hK9Nr/qFurpKIm5tHsRXH1EJJvVwtEB
2/TSWuNFYNgxIvL4I5CA/eW5M+6L0Bjz8xvz222U4qgellqyCEopV/4qUu8h
M0pugv7bRfAvFqUH6kchUg85b7hyETik7leG1UWh00589btbF8Ghp3jrmHs0
Uj7bL9w2vQhcRl2S4xEx6LV7aqrAviWwUquX1x6LRWdV1z5/abAEw1/v7BWA
OCQ1fptqZ7YEpyrG0rui49BVr4C/+SeXgDNzMdVz1wOkf8FS6cD1JRATO1KW
ER2PvgTwvLxWswS97FtdmnwfotDdwR8Um5eg9NSYO6XtIdo5x2xv6FgCXXnS
n3taSejh5Z456SFWPpPDui9IycjhKsLe8C2DrofT8um0FDR242L9hMUyRAR5
nQjkTkcON83LDx9fBrZdkmLqB9LR57AtuaVnliEjmFqTGpaOSiN+3wjwXwbO
VZ5BSaszUGCU6R5S6jIINmXmgMhjxJmskC84wOLEMBWlg5nIL4WU6E1bBi7x
+o7iB5moP7XzZsvcMug38d4i/c5ETs21RZ+4SJi2zJ+lycAsZNhyNTJKkoRJ
r1J+fOhlNuL/NqQnDiTsxAWdNa8P56EPNh3atXokrL2y1VQ8Pw9d/V6tHmjI
8pXu7zFlz0cTnenrOy1ImIVJQ82+l/noy88j82lnSJgOx3PKQYUClNjzvkTx
NgnbG9ir9EP1OaJMJMnvbCVhnkePcHcwS1C6L+NgwjcSZqNeOPhd5QUiz5r6
zfwgYe9n3GH/6RdIip3tU3kfCcs6p+Jy9PMLJLLWxRdmSFhssZe1W0kpYtPS
rDGUZsOoAsV34sJfoV/XPp0/fooN8yz5MvwwrBzZcSokVDixYflnGNGb6srR
9/Cr72Rd2bBCv9cbFATeorYYdbFuHzbMY/90tVfCW9T4JAGdCWXD2K3rJs2e
VyC85rSIRw4bJpNqmniQQaBkwYXXwaNsmLRBpYL80DvknMHx9RONDQuQ2f9q
n8h7pKHJOyHGZMOeJX6Rv6/9HtUdkdr8bIkNw9/yvfhz5z2aS9VK/CbIjgUt
CNVR1CuRrcrFAA0NdkzHY1Bwa1gVkjQa0+rxY8dshOwHQm1rUM/3Kattl9kx
6/U7vPMjalDR+UWvS9fYMe/w3iDushrW/wdfnlA4O8a3+5OMh0QtCmhXltz3
kB3z2S7g8etbLepwcpl98JYde7wz7ecxlzqUcL277ACJA3PP8EyILGhA77dL
6U9wcmB3hY0nbPsb0FifZWMiDwc2VfVe1W1DI9p/sObPoAgHtu6mpZrFw0bE
FC3kjVTgwGJyPi+q325CVlmX7ZuNObBzPJfLZCuakVCtGJvNAw6sJNYqM+T9
FxTOb2roqsyJTRxV1khQbUeBlfRVlaqcmGCExVc/i3bkGphYKa3JiQ0GnWbz
9m1HJr1//2vYw4kRot7NpeXtSAi/tEPNlBN7nlfPG2jYgRLO525genJiTgsh
wkNnv6HsTxyLIS85sevYzF4ZvBNVR5QXP8RWYR79wvGcx7rRtGxRzkYPLmzv
0OnDoxZ96NkqJR6V+NXYTWuPrMs9I+j5z8cGWD43trSeNqleTUNZTZkCRa08
mGb04eaMpCnUX5xTojK6BrMfj69Ls51F5AKNv5wyfJij6A/NG9GL6Nssds3G
gB9j3AgA4wEStVvLnFluK4BFPV7MVhljp3ZF9c/63xLE9lNtPnhsXkUVHoER
OXMh7DxXKb+B3moqs8xUuOqbEFbWo5CkcYyH2hb7aGGtpzDmlGNX7JbGS7Xr
87Y+PyeMNXt62r+l8lO79MN9vWNEsLBhv+kCHiEq2dThY6mCKPaKRjGJVBWm
cjW+ubP0XBTT67QpcsFEqAO21muZBmux9fnfNs+dE6V6OfisYXxeiw1If+pX
C15LLRe02Kl2fB3mvmjjAjHrqMt1FzZLTazDDBQ+k76WiVGHlsTC11wWw+64
ffj4rlGc2vTf0rNcYXGsX/riacV5CarttJOOaZo4di7ji2SdqBQ1xyZqjdpm
Cezo/J4i7k3S1LGahYdUXALbVZMmW2QhQ+0sHIo/aiSJXQyv87l2VpZamSFj
m9ItiT1uLdN6EU+muv8nZLn+ohQm/uPlgA9aT8UtQ8tyl6Wwho5b2ze5ylFX
X9zb9+uBNLZWhMFpQJKnTgtcDJbdIINdWeaP9oiUp+Yd9jR/+FQGGx9Pify2
bgP1yONnfe8xWWzXocW7k/kbqHmu54fon2Qx/O+8gvhOCtU57bqrQ6MsZnQK
+YRqUagbvyQONTTLYkgjC9G0KdS03dVDua2y2JRHu009UKhx3OThE79ksaHo
lqgQIwo1OLtpuI4ui6k7rmMfsaNQj/3RGH0sScakDkguU29QqGJiRu5CMmRs
snbmkGoYhdpidHL0CpmMbS6cTk8Op1DNiu+MHqOQsR+Glnp+dylU/eCeUYGt
ZGzXnmsRWxIoVDVy/NgljIzFMeOl4/Mp1DGLAo8BXTJWoevowfGMQn168/2Y
tQEZk4g/+M7rOYWqODo2pmZMxnhH/V0OllKoMhUHxvssyVj51h0vSQSF+n3c
3tPqCBlzMhzj9qBSqAkU3/F3x8jY1Psqu873FKrInfTxFHsyRvf6yPmqhkJt
Jl55rnEgY/PB08codRTqXXr9uL8jGRtJ0n0WXU+hGiv+9ew9Q8bCs/LZlhop
VG7b2fHDLmTMKn7bEbfPFOr/AO8RF3I=
         "]]},
       Annotation[#, "Charting`Private`Tag$219681#3"]& ]}, {}}, InsetBox[
     TemplateBox[{"\"Forth-Back\"", "\"Spin Echo\"", "\"One-Way\""},
      "LineLegend",
      DisplayFunction->(FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& )], 
     Scaled[{0.99, 0.99}], ImageScaled[{1, 1}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{0.6931473215345444, -13.672024974034363`},
   CoordinatesToolOptions:>{"DisplayFunction" -> ({
       Exp[
        Part[#, 1]], 
       Exp[
        Part[#, 2]]}& ), "CopiedValueFunction" -> ({
       Exp[
        Part[#, 1]], 
       Exp[
        Part[#, 2]]}& )},
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox[
       TagBox["\"\[Delta]C\"", HoldForm], TraditionalForm], None}, {
      FormBox[
       TagBox[
       "\"v[\\!\\(\\*SubscriptBox[\\(l\\), \\(c\\)]\\)/\\!\\(\\*SubscriptBox[\
\\(t\\), \\(c\\)]\\)]\"", HoldForm], TraditionalForm], None}},
   FrameTicks->FrontEndValueCache[{{
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        MachinePrecision, RotateLabel -> 0], 
       Charting`ScaledFrameTicks[{Log, Exp}]}, {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        MachinePrecision, RotateLabel -> 0], 
       Charting`ScaledFrameTicks[{Log, Exp}]}}, {{{{-13.815510557964274`, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}}, {-11.512925464970229`, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}}, {-9.210340371976182, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}}, {-6.907755278982137, 
         FormBox[
          TagBox[
           InterpretationBox[
            StyleBox["\"0.001\"", ShowStringCharacters -> False], 0.001, 
            AutoDelete -> True], NumberForm[#, {
             DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
         0.}}, {-4.605170185988091, 
         FormBox[
          TagBox[
           InterpretationBox[
            StyleBox["\"0.010\"", ShowStringCharacters -> False], 0.01, 
            AutoDelete -> True], NumberForm[#, {
             DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
         0.}}, {-2.3025850929940455`, 
         FormBox[
          TagBox[
           InterpretationBox[
            StyleBox["\"0.100\"", ShowStringCharacters -> False], 0.1, 
            AutoDelete -> True], NumberForm[#, {
             DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 0.}}, {0., 
         FormBox["1", TraditionalForm], {0.01, 0.}}, {-16.474770594897052`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-16.34123920227253, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-16.223456166616145`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-16.11809565095832, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-15.424948470398375`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-15.01948336229021, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-14.73180128983843, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-14.508657738524219`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-14.326336181730264`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-14.172185501903007`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-14.038654109278484`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-13.9208710736221, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-13.122363377404328`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-12.716898269296165`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-12.429216196844383`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-12.206072645530174`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-12.02375108873622, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-11.86960040890896, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-11.736069016284437`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-11.618285980628055`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-10.819778284410283`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-10.41431317630212, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-10.126631103850338`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.903487552536127, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.721165995742174, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.567015315914915, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.433483923290392, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.315700887634009, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-8.517193191416238, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-8.111728083308073, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.824046010856292, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.600902459542082, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.418580902748128, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.264430222920869, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.1308988302963465`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.013115794639964, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-6.214608098422191, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.809142990314028, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.521460917862246, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.298317366548036, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.115995809754082, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-4.961845129926823, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-4.8283137373023015`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-4.710530701645918, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-3.912023005428146, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-3.506557897319982, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-3.2188758248682006`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.995732273553991, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.8134107167600364`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.659260036932778, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.5257286443082556`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.4079456086518722`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-1.6094379124341003`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-1.2039728043259361`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.916290731874155, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.6931471805599453, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.5108256237659907, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.35667494393873245`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.2231435513142097, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.10536051565782628`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        0.6931471805599453, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.0986122886681098`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.3862943611198906`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.6094379124341003`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.791759469228055, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.9459101490553132`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.0794415416798357`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.1972245773362196`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.302585092994046, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.70805020110221, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.995732273553991, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}}, {{-13.815510557964274`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
         0.}}, {-11.512925464970229`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
         0.}}, {-9.210340371976182, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
         0.}}, {-6.907755278982137, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
         0.}}, {-4.605170185988091, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
         0.}}, {-2.3025850929940455`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {0., 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 
         0.}}, {-16.474770594897052`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-16.34123920227253, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-16.223456166616145`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-16.11809565095832, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-15.424948470398375`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-15.01948336229021, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-14.73180128983843, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-14.508657738524219`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-14.326336181730264`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-14.172185501903007`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-14.038654109278484`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-13.9208710736221, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-13.122363377404328`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-12.716898269296165`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-12.429216196844383`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-12.206072645530174`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-12.02375108873622, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-11.86960040890896, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-11.736069016284437`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-11.618285980628055`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-10.819778284410283`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-10.41431317630212, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-10.126631103850338`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.903487552536127, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.721165995742174, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.567015315914915, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.433483923290392, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.315700887634009, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-8.517193191416238, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-8.111728083308073, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.824046010856292, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.600902459542082, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.418580902748128, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.264430222920869, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.1308988302963465`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.013115794639964, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-6.214608098422191, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.809142990314028, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.521460917862246, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.298317366548036, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.115995809754082, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-4.961845129926823, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-4.8283137373023015`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-4.710530701645918, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-3.912023005428146, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-3.506557897319982, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-3.2188758248682006`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.995732273553991, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.8134107167600364`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.659260036932778, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.5257286443082556`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.4079456086518722`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-1.6094379124341003`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-1.2039728043259361`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.916290731874155, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.6931471805599453, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.5108256237659907, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.35667494393873245`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.2231435513142097, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.10536051565782628`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        0.6931471805599453, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.0986122886681098`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.3862943611198906`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.6094379124341003`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.791759469228055, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.9459101490553132`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.0794415416798357`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.1972245773362196`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.302585092994046, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.70805020110221, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.995732273553991, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}}}, {{{1.6094379124341003`, 
         FormBox["5", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
         FormBox["10", TraditionalForm], {0.01, 0.}}, {3.912023005428146, 
         FormBox["50", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
         FormBox["100", TraditionalForm], {0.01, 0.}}, {6.214608098422191, 
         FormBox["500", TraditionalForm], {0.01, 0.}}, {6.907755278982137, 
         FormBox["1000", TraditionalForm], {0.01, 0.}}, {0., 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        0.6931471805599453, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.0986122886681098`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.3862943611198906`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.791759469228055, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.9459101490553132`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.0794415416798357`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.1972245773362196`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.995732273553991, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        3.4011973816621555`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        3.6888794541139363`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.0943445622221, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.248495242049359, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.382026634673881, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.499809670330265, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        5.298317366548036, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        5.703782474656201, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        5.991464547107982, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        6.396929655216146, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        6.551080335043404, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        6.684611727667927, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        6.802394763324311, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        7.600902459542082, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        8.006367567650246, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        8.294049640102028, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        8.517193191416238, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        8.699514748210191, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        8.85366542803745, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        8.987196820661973, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        9.104979856318357, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        9.210340371976184, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        9.305650551780507, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        9.392661928770137, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        9.472704636443673, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        9.546812608597396, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        9.615805480084347, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        9.680344001221918, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}, {{
        1.6094379124341003`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
        2.302585092994046, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
        3.912023005428146, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
        4.605170185988092, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
        6.214608098422191, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
        6.907755278982137, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {0., 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        0.6931471805599453, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.0986122886681098`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.3862943611198906`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.791759469228055, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.9459101490553132`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.0794415416798357`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.1972245773362196`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.995732273553991, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        3.4011973816621555`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        3.6888794541139363`, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.0943445622221, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.248495242049359, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.382026634673881, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.499809670330265, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        5.298317366548036, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        5.703782474656201, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        5.991464547107982, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        6.396929655216146, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        6.551080335043404, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        6.684611727667927, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        6.802394763324311, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        7.600902459542082, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        8.006367567650246, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        8.294049640102028, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        8.517193191416238, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        8.699514748210191, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        8.85366542803745, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        8.987196820661973, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        9.104979856318357, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        9.210340371976184, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        9.305650551780507, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        9.392661928770137, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        9.472704636443673, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        9.546812608597396, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        9.615805480084347, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        9.680344001221918, 
         FormBox[
          TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}}],
   GridLines->{None, None},
   GridLinesStyle->Directive[
     GrayLevel[0.5, 0.4]],
   ImagePadding->All,
   ImageSize->Medium,
   Method->{
    "DefaultBoundaryStyle" -> Automatic, 
     "DefaultGraphicsInteraction" -> {
      "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
       "Effects" -> {
        "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
         "Droplines" -> {
          "freeformCursorMode" -> True, 
           "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
     "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None},
   PlotRange->{All, All},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.05], 
      Scaled[0.05]}},
   Ticks->{
     Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
      MachinePrecision, RotateLabel -> 0], 
     Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
      MachinePrecision, RotateLabel -> 0]}],
  InterpretTemplate[Legended[
    Graphics[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6]], 
          Line[CompressedData["
1:eJw1lnc41f//xo9VyMzKzK60jAZSz3cZUZSdGSqSTciOklFGVEgZDSUtpGG8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           "]]}, "Charting`Private`Tag$219681#1"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[1.6]], 
          Line[CompressedData["
1:eJwt13k0lN8fB/CxZC1LZCcSNSpriySfJ1tIkqUismVJ9n1JIYoiabOECJFK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           "]]}, "Charting`Private`Tag$219681#2"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.560181, 0.691569, 0.194885], 
           AbsoluteThickness[1.6]], 
          Line[CompressedData["
1:eJw1lnk8VG/UwMeSyE7ZTTRRJFlapPqdayuECBVRUiiyJkupKIlSiJAtyp6E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           "]]}, "Charting`Private`Tag$219681#3"]}}, {}}, {
     DisplayFunction -> Identity, 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None}, DisplayFunction -> Identity, DisplayFunction -> Identity, 
      Ticks -> {
        Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
         MachinePrecision, RotateLabel -> 0], 
        Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
         MachinePrecision, RotateLabel -> 0]}, 
      AxesOrigin -> {0.6931473215345444, -13.672024974034363`}, 
      FrameTicks -> {{
         Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", 
          WorkingPrecision -> MachinePrecision, RotateLabel -> 0], 
         Charting`ScaledFrameTicks[{Log, Exp}]}, {
         Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", 
          WorkingPrecision -> MachinePrecision, RotateLabel -> 0], 
         Charting`ScaledFrameTicks[{Log, Exp}]}}, GridLines -> {None, None}, 
      DisplayFunction -> Identity, PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
      DisplayFunction -> Identity, 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "ClippingRange" -> {{{0.6931473215345428, 
         7.600902318567485}, {-12.952444712243109`, \
-2.997602166487927*^-15}}, {{0.6931473215345428, 
         7.600902318567485}, {-12.952444712243109`, \
-2.997602166487927*^-15}}}}, DisplayFunction -> Identity, AspectRatio -> 
      GoldenRatio^(-1), Axes -> {True, True}, AxesLabel -> {None, None}, 
      AxesOrigin -> {0.6931473215345428, 0}, 
      CoordinatesToolOptions -> {"DisplayFunction" -> ({
          Exp[
           Part[#, 1]], 
          Exp[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          Exp[
           Part[#, 1]], 
          Exp[
           Part[#, 2]]}& )}, DisplayFunction :> Identity, 
      Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
         HoldForm["\[Delta]C"], None}, {
         HoldForm[
         "v[\!\(\*SubscriptBox[\(l\), \(c\)]\)/\!\(\*SubscriptBox[\(t\), \
\(c\)]\)]"], None}}, 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLines -> {None, None}, GridLinesStyle -> Directive[
        GrayLevel[0.5, 0.4]], ImageSize -> Medium, 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None}, PlotRange -> {All, All}, PlotRangeClipping -> True, 
      PlotRangePadding -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      Ticks -> {Automatic, Automatic}}], 
    Placed[
     Unevaluated[
      LineLegend[{
        Directive[
         Opacity[1.], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        Directive[
         Opacity[1.], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        Directive[
         Opacity[1.], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]]}, {"Forth-Back", "Spin Echo", "One-Way"}, 
       LegendMarkers -> None, LabelStyle -> {}, LegendLayout -> "Column"]], {
     Right, Top}, Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{
  3.917923646898654*^9, {3.917924058309989*^9, 3.917924065638274*^9}, 
   3.917924125304071*^9, {3.917924211545278*^9, 3.917924258528502*^9}, {
   3.917947808449007*^9, 3.917947845391918*^9}},
 CellLabel->"Out[85]=",ExpressionUUID->"45249040-2a82-4ae2-b1fb-77a94bf8d791"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"\[CurlyPhi]", "[", 
    RowBox[{
     RowBox[{"\[Gamma]", "/", "v"}], ",", "\[Gamma]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "20", ",", "1000"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Gamma]", ",", "100", ",", "1000"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.912148661450947*^9, 3.9121486992413673`*^9}, {
  3.9121487464183407`*^9, 3.9121487804023256`*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"96c0a4bb-5b28-4a16-aa8a-e2d826aa8aac"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxd1m9olVUAx/EVW6w/yArsRa6YaPQHSWdWmBWn8kWzxr2Nuqvm1u6fRdrW
8kFcpKzttJ61Z11lM6EX+acxiukLDZZtIK4osqK1wopyYYkvxIKWSURJ2O+Z
nqPfR5C7z3bO4Xw59577zM+117VcWlJS8rv+x6+z/7oy5twPT55/LdAftiYc
0FUddNdG+peXE+Mtne5JzA/pfa8l1ovoiiJttiTWy5jBhTWDC/tcV4FWHx3Q
6oPVB6uP4y2tPs4PafVxvYhWH6w+rpcxMWsG3TkVaPXRAa0+WH2w+jje0urj
/JBWH9eLaPXB6kv2TO9vm95fG/geOqDVA6sHVg/HW1o9nB/S6uF6Ea0eWD2w
O5+6DTwf74B25+PszsfZnY8fb2l3Pn5+SLvz8etFtDsfZ3c+zuppiwMzL/ke
OqDVA6sHVg/HW1o9nB/S6uF6Ea0eWD2weuLjamvo9D10QKsHVg+sHo63tHo4
P6TVw/UiWj2wemB3ny/p9j10QLv73Nnd587uPvfjLe3ucz8/pN197teLaHef
O7v73Fk9N8bvv6Wv+B46oNUDqwdWD8dbWj2cH9Lq4XoRrR5YPbB6VsXX3bJX
fQ8d0OqB1QOrh+MtrR7OD2n1cL2IVg+sHlg97fHn6c5e30MHtHpg9cDq4XhL
q4fzQ1o9XC+i1QOrB1bPG/GFt7zP99ABrR5YPbB6ON7S6uH8kFYP14to9cDq
gdUzHt8PK/p9Dx3Q6oHVA6uH4y2tHs4PafVwvYhWD6ye5P6PxhfevUW/f1j7
h7V/WPvneEtr/5wf0to/14to7R/W/rnfC889bv+wu4+d3X3s7O5jP97S7j72
80Pa3cd+vYiuKNLJ15s3m9nHtZ5m/3tYf5/9PN232Ts5f/b1oud3jB89v35p
o/dYfP4TF/6enI+/u/1cNN/9fs1/p0u3HH3cP08vfl/brk08T+v5+srPX1z8
5RPrzBXXzu//abzeP8+Nznnn5KGvGvzz0KJLjvWeGWvyzxPd2+qvn7e+2X8f
t0/bidba7Ll19X02U/fnvNvOZP33Qe/xf3oe6sv5+7SwKNW0+2zO30cHG4/s
ncrn/ef54ze3tw6N5/l5iJ+X99TcdWtV0fy45/vDDRUF/367feDkqYHrWnx/
sGR47YJvHzVzd6S/LivkzOWlJ7betDxjBmZ2VX+0rtVsuvuqA58cqTd/Ha5+
6rHtgdnxQlVH9oHV5o/vVu78YrjDpBf0r/839bRZaY6NTq3eZG7oPD5n8tNm
kxurtFHQZd4+WFVphrJmw9rKE3e8a81z5SMTW1M58+DSwppV3/SYjY0jy05N
58yzn63YNnk6NAcuy18zk8qbVHGmeqyiz9xT91ZZy3t5s3NvcTh7S78Zen3y
1+evLpipv0e6P7i/aNJnf/7t4R/SpqyzvDysbjK9mWcO7Rt5xL8f/gcUIi2O

    "], {
     {GrayLevel[0.8], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwBZASb+yFib1JiAgAAAHEBAAADAAAAEyIhGwwNIBESIhMUIRITJBUWy8bF
JRYXIxQVHg8QHxARPS8wYVNUXlBRZVdYGgsMYFJTYlRVY1VWPzEycWNkW01O
GAkKEQIDNCYnMyUmNykqOiwtOSssNScoOy0uPC4vNigpKBkaJhcYEwQFGQoL
EAECEgMEFQYHFwgJFAUGPjAxFgcIJxgZXE5PZFZXVEZHU0VGVkhJVUdIV0lK
UUNESjw9TD4/TT9ATkBBT0FClqSjk6GglKKhQzU2laOiloiJo5WWUEJDESAf
XU9QQjQ1Sz0+a11ebmBhbV9gcGJjb2FiZ1laZlhZWUtMaFpbaVtcalxdRjg5
Rzk6RDY3QTM0STs8QDIzSDo7WkxNWEpLMiQlMCIj0h3ThHZ3g3V2gnR1gXN0
hXd4pZeYh3l6iHp7p5mac2VmAxIRwbS1wrW2w7a3inx9BhUUAhEQyse4BBMS
ARAPBRQTiXt8gHJzjoCBnpCRnY+QnI6Pm42OjH5/opSVn5GSppiZfG5vfW9w
dmhpd2lqfnBxi31+dWdoeGprf3Fyemxte21uBxYVv7KzDx4dtaiptKeos6an
t6qruq2utqmqvK+wuKusdGZncmRlEiEgMSMkKRobKhscu66vKx0eLB4fLR8g
LiAhLyEivbCxsqWmsKOkCRgXChkYCxoZwLO0CBcW4h3SDBsaEB8exRsN66Dd
vrGyrqGiqZucqpydq52eqJqbsaSlraChrJ6fr6Kj3aDeoZOUmKalkJ6dIS8u
Hy0sFyYlFiUkFSQjKzk4GCcmIC4tKTc24zjVJzU0JTMyQ1FQRVNSGikoJDIx
IjAvIzEwKDY1JjQzc4GAGSgnGyopLTs6OUdG5EXWMT8+MD49QU9OOEZFLz08
QlBPP01MQE5NLjw7LDo55VLXHiwrPUtKO0lIPEpJPkxLOkhHMkA/ZXNyY3Fw
SVdWSFZVR1VUUF5dSlhXT11cS1lYTFpZ5l/YW2loWWdmU2FgVGJhVWNiTlxb
UmBfWGZlVmRjWmhnV2VkZnRzTVtaXGppZ3V0YW9uYG5tX21saHZ1aXd2ZHJx
YnBvXWtqcX9+coB/bHp5bXt652zZRlRT6Hnabnx7anh3b318cH59NEJBM0FA
NkRDipiXiZeWi5mYgY+Of42Mh5WU6YbbeYeGiJaVhpSTgpCPdYOCzM7Ey8/G
d4WEp7Sz6pPcpbKxg5GQhJKR0MzEgI6NfIqJoa6tpLGwo7CvjZuamaemoq+u
kZ+el6Wknqyrmqinm6mofYuKfoyLe4mIeoiHprOyjpybjJqZnKqpnauqy80O
yszHjX+AxcYczMjHs8C/sb69q7i3uMe3qba1qre2ycUNG8Uc4Q/RdIKBFCMi
NUNCsr++doSDtsPCx8O3tMHAtcLB7Lngrru6rbq57gHtmIqLkYOEkIKDmoyN
ycvFzNDIzszKz8sOj52cj4GCkoSFqLW0r7y7sL28mYuMx8jDl4mKzcvJlYeI
lIaHpJaXBq7Nng==
         "]], 
        PolygonBox[{{237, 1, 15, 225}, {211, 29, 43, 212}, {212, 43, 56, 
         227}, {213, 56, 69, 228}, {214, 69, 82, 229}, {209, 15, 29, 226}, {
         220, 147, 160, 235}, {215, 82, 95, 230}, {216, 95, 108, 231}, {222, 
         160, 173, 223}, {218, 121, 134, 233}, {219, 134, 147, 234}, {217, 
         108, 121, 232}, {223, 173, 185, 236}}]}]}, {}, {}, {}, {}},
    VertexColors->CompressedData["
1:eJztV/kzVfHfR0SFVBQpWUpp0UqbekmypqSSpJSKQohsIaVIWbIUISVbaUNZ
0+q6XPu13MV2c8699r1VkZ4z33lmnr/hmfmemc8P5zNnzpzz/rxWFTtXi7Mi
QkJCw9SaRq25z2I9jxn1Ya+Rk0Z8IgmZ2PUzxV+zkW5tq5wUxkZQEaPY0KYN
A0GDJg73+JjN2C/yTLQeWsaX6Yd8uTjE+9l8XFEA1eJbt6OFq/A94IBTvywH
PteNo34MU+97pyoq6lEBl6xMN3lbNvwVeN/yD5PQOTXNVPCLDnOO5Q3GDxbe
nvkY93WSQLq8+KtkCToaLpRYHXjDQlqt6vahMgJut+n8focyLNiS1fMyhIXS
6UU3zR4RUNlEHy7/SYOH5xUbXQcWrq41NGbeINB2VHTFonQalkd+qzc2Z6FC
9niQ50UCOdP0j385S0NE9bkZQmBhUt5Dm29HQIbZu4qrRUNYTFze0/UsGJ29
GZt+hEDs/VUXhWVo6L105euy5SwYcKoyGfsIhDn3TGSNlWJJ8MCBIiXqeeKy
7CtDAqnibrrVo0MYKAg9MT23G32Mvh9Fj1ugmrrjaMAWHowzNfyY0jxYNIWm
dxwkYO5qddBYuQliIrzhpytaceduWHx2nAB325+IuWjWIfZ3yqHGHVxYjPTY
avXxEZn5z2DYsgqeas8fpazmQMx3onNMhI/1JdYabxcwkEpX0GsJZ0N8xsm1
Bv4kVG4xVmZnlWN1c9KtVcvZ8DOyaYlRJ2E4IrdZ5TUd4W4+WQ4kC/Ypk6bJ
gwQGq8t21ovQMVun0D0vl4WMYtfN0TQCSnLJNnOCymB0S9hvLIIFbt0U6ZxB
YMQ47VWxchk4zG6rHncW7ow53UiNJCCoLG86yKJBaklE0Y/j1HyE0l0m/Alk
6n4OK0mg4b6aa4eDGQt9zPMh4q4EaIXXlevP0+BVEDq+QJc6d3LrivrTBHSN
bS+tjhnBz9YTJ33L+qEfZy3ynkfA/ZP5kYD7JJaF/KP91u0E7fjKtjeRPDw5
9XvFq1o2Nuw5s++qRxvu3tngNXGNj68RhszrP5kocnG9qGDUgsU6K66nVwpw
sYQT+/NrDfwKq9TXd3NwLJF57ugjPl715D0NnF6F8PwBYeP5HExqbZ29eJRE
1oPbugPLGUhokX9hFc3GxvmPs2Sukig7piDFIMshesaXIb6ZDYs2K+mxjSRO
8MK17kzQ0TKQf7D2Jwsi1xY61v0lMCu22VP1AB15Rt3bvCpYmPcAH3tYBLZL
2Lzj1pfBz3vEMTyNhZtFW16mFhJ4np/qdM6pDNphjxQzb7Jw+mLzW6UUAuze
Uvt6xTJM+K9ounWRBcnz3gN+EQSsXHpXZrbRcH1nqF6hLTVnl/2HvK4Q2Lvn
XNXRwS7kWGhIWTsTyPgasHt5RivCiugcOZ1WbJnmnrvpaTsWli6eqgok8fWr
dmLh70ZUR+mMLFRsRZ0Kgy6WKsCUglWmtk09zPJ3X8uM5iLJ206nY60AHrwj
jmnMakxuWN4cdo+Dxm+i1ieP8SGipykhF1YJp09kkdB3NpoLk3o2N5FYd5Fr
/32qAiG115/+CmajU8/tnK8XCbGRe+/9BeWQODQmd42a5z6lSdMjm0jMPS3J
+zCvHAVRDtuD/7Ige9JX0mcaibhcIuHfJTrO204Pd25gIaSgbK8ZhROHK783
nvldhn3yzQXzs1lYL/u32OYzgWPeUa1b48sQs5Q+uzGWhTybBxKnnhGYsIzj
jhmWIVZxkVFNAAvnHBjrGuIJMIuO3lbR7EOG79Y022gSmU43itqZbPztI0J9
QzrAtSSadJkdMKkOjVgXSoDUvD3DdhoL3+PrVVwbWzE0lnI6V0KAF5Pme6uZ
TFzaZlWwdGMLHCRD6v8UCrDG/8ejC4G1yF6QWK4lxQXT5vYZnU98/Jaoq9/U
UgXR2q1ZTHMOZA9EqLmr8JGdeyehaGYlFGdKNllR35HwW/rMynwSlWLiNJdP
FchZ+zIj4RIb7kcMpNkOJITs90iOVpej3d7bMnsdG8Jul4h4TRK04arEl3PK
8bNpTPvrJIWrJ+aqkyIkRLQmRRyu0lH3LuJKfDOlAwMzmeOdBFjVIwocSQq3
9g3vA/IofH6jOfXTCdiH6587nl2GcamcxJBEFszNfFjiOQReCI53MR0G4bVU
tDf8DR92/QtL5k9vgvOoWbHqiU4ER2boyYzx8LB8V0ZaXCdW923cL/+HjZMn
ozctut4GMxOe69AlPuTjHf94/W3AHBstg0ulLbBZ0l66clCA+fbFdjUK9dj8
7sSTjYFcOITOCjdXFuBP4z/6n/k1sJ535otcFgehJmtsuE58dCUw3h2ZUQWD
H3a68xZwwMt6E1xB8Xpnkfe74mgG1BPnvX73ig3Xui5LNqUv5SyzdY5+FVCR
rc+/cIoN3+Nvjr88QqKZwQhc8aQczpWHer3V2ZDdfcR9YhmJlJGYgnPC5fiz
h9x7YZyFZWG7xdb8I2BBW9lnH0DHHXdJ1dImFtg3Sv/oU/NUvhzpGjiXjheX
A6RlClgo+fHl+o4KApzBpL5JDGHMwytY5JcAdaprPEOOsnDomeztZd8I5LFX
afKmdyLJ1NxD4cAXcHNkEv0FXKTQp9V4rG3H2+otjpUCEqMb2MefmjZh37mm
H92bW/HFS0p29JYAkmH5Kl4WTByaYJz9MchFf9nx4UZ/Adq5vk9nGdXCwjHV
o+kvB+pJxV/1qXNLj83nufytwm2P+spOaw6ULDe7D2nw4SPzVtbQuhJ/xdU1
3bvZSC5jllRVkFA9MbI0UY2BqOTM18ui2KiZf3BIitKTjO82i4K1K9BwOjHY
ZB8bjPMcyXBDEpGh+LwzoBzKiqbOTQvZMBYdtVi1iMSvVo5xVB8dvY6eKbVj
lL832tTH/yaw5Zjs0faLdKQfrnWKYLJgkXZXJ7qDgPZMYRtJ2hBO7PBQy9rZ
DUXJlAsKIVwknNuWVHWDD3cfzVNidzvhpZPF6PTpQHjHZXNueSsMvf+kjHPb
YeX4jxCmztd6XP7zVHQzlLpTe+KetaKKJRIgulIAdWsVhcNzGxCoZV0QcaQF
t2eLyj1nC2B57aiNjmsdorRmlTbu58KvhPfw1DgfDySMxef3VWNpm+xhywcc
uK1xyVI4xcfUum8nnypWYXp0Z6bGIg6uP/TXm/ODxFaV3Qtz6Qz8IXbMW/2e
DavJLaLCGSSqhufmvKJ4/asp2OE5xetFcuViXRSvR+1zx1K+l2O75s2Bye2U
frawPittIdEuZPpScKAcCilpjxjSlE4Fdf8UnUuixP7hvd5aOs7qcGYu6afy
T1qKnhKFJ5UbovJTe4ahMeznKxbSgzP2QZrfc9vA9xf+GiTbBcPa846BygRK
A/QvDKS2YfCDjcl4Wju0WF4pmVc7sNs+Xq2sikCJ3YgHo5GFhL/1UQcV26B3
f7nf22o+Jj0/tMbzGiDGjG5ILGzBsoRjxTt+CHAgo3bnp8h6PJ8+2yjnERfc
j68MXm8XIMZb9Pmf2hq0vt62ZqCNA+l1doU5cXwIycosXc6pQtqbtek7KT0M
kHgp80uZDyI388gru0rYyb//VNHLxo3cPvvSShIzF65edsGAAfP8PfMbEyj+
ah5dpXWT8msnt6g15yqQ7WVSKmfDxjaN3pOrD5K46Hv0PVlQjqH5ZfvYK9ng
V6oqPNMgoXw3/NbM5eUQNm60IUQonGvOvDMpToJf6h5CMoYhHXYnQre2F/OD
Ky75d/DQH0mLUEnrhv6jLre4FwTeB+nv21XXArn420HZATy4K77rUVnOg5th
2mAICITWb7mSOZuDhqM1V7NvtyE0997leBfqf08nt+fQGuE0zdNESaIV3t4V
M3pyBWCAG61+iIkWdbn0riEuHp0QdU4OEEBi9d22Sy9rwUu265pS4GJUz3bl
NGr+I5un3jdEVCPoZ5HuZBAHr0TeeJSY8uH7Ye1Zh4lKPJV6MGvTPA46I0vm
3Rgi4fZV09aRwcCtoubSIQqH8zoW6qdTOPywePOAM7cC0WVGtbv92Di2rlDh
0gUSL3lylePyFWhKn24hZ8CGiXTCjMe6JGT/vt/5gOK13SX/M0MUr63mOGrv
onh90ENR6LPpCNT18987y/ZDIbCk21WUQEyrzrwl63vBt81tvUThmG7ZFXvo
DwemrJ0L4ld24lcjz5ZVw0PKqtTG0bxOOBecD/hozIW+6a1dc3+3IaUll9Sf
y8ee4OeF3IwmtNJL5yUcacV97dbiC64CXHV3eJLEY0Jt5lvrhm0t2P91RbH7
BwGiW7/suh9ah5h2MRmeJRcv1fzCD0zxITBNlQjRrcHYpuhFKXlUDlx72ybG
k4+cMOcvkVFVcCtSik7V4UCqQqLdVYaPrOfn32sbVqJz6Yub6gQbGSztxYdo
JM65mtk172Gg7oPukycUDs3GbR3mUDhctN2eCPGpgHRqhVXKSTZ8ypcZCFH6
czRRiRxsKMc7kwXKRzewMTdHt3RqLYn4J3L1D+pGwCxX3x1zbADKKrR9ClRv
O8NJCvj0oQ87NvV0bSijfMt1QK2Z8qVPFQd2JMsROPFsxavp7l/g411/r4Ka
Y/ierFj+tRbMNLEbL7NvhxDbICS4gIRXcaxeXXAzqva17tyX2QqXLe9zE9YI
oFeYd3+3QwNeBDM634W04MOpjgVuU5SP9AoV7TpZD5r/qunlMVy4StXF1K8T
oN9so9SfkRrMTrjKsOniwDij5nzmQz5mRlmseataDXm2c4POWQ5+XPV6+3QD
H+r9UqN7aZWIDjP1fTiNg7FITbdTnSR0N52eUZnDwH0d/unjhWzMZMp+V0wh
8dmvNruTVYGYBZYpkZfZcKnaeLbNmUTRrtXz9JZW4LlcUvdmY2qfvB64ZzeV
f/5zjUIt7sj9krZBBG1Nf/9PsQteuX93rNk7APtyCVfefj5SasYfRh9shrPE
jE8rhUjk5WXcvzirE0FTSqFVu75A2iS5KqOoFT6iMywmmtoR8/fQGs1jJLad
JMeXnKF6UXIyz/V7K9qWrpfZNciHGO1D9UzxRgx98B5poLdAjHFCwbpPgPsa
XguiFzLR5mo+3FPLRbLzvWeZdlSuTvPXoD2oxfg6tdJjclzc1fsTu7CCD+5c
BUP719XY5Kx7fVkEB61uemOmh6i5CUa3yu2oQnReQ4T7Mg7eHpXKFEySkLed
6H+sUImxM+XrAprZ2JlBV35aRMLhtJPM/vUMvDbmnP0ey0a10VvP3UHU84VC
s1ouVWCl6/PiRKqn6919TVOzJMEmaq421Q3Chev2b2E7H3d5d5QGkxqhJq/8
4nw/ieCb9O1lxztxWszHxE6Th60S4SIuw21IjRNltuh2oLQtYb8yNcd62+Lt
W3axERxec1hNrw3KN+9F6T+n/NEwcCr7ZSN4Kw/n2Am1wu53TN6JIgFE6W/z
+NeZKM3aoeEk0YJ5jy+LjscK4LOWNXjMsA7627myH/W5GNjHD581wscoRz5/
AjUw9hHP8aV4Wmfx4fdFiqdCjXO0evOqsO9xzakSAw4+dZsEfJWn/PfmqYms
q5Vw3Pzvi+IYpefEmG8Fk8oh+pLec8IYUP7sacx/wUZBFcvCMJ6EgTztUQ+t
AituP42I8mSDR8RoZJ6jcFjm4mkkPYTiO2KnP14WYM9KOa71smYULV9h79nM
R1LtcKdoDtVPLdp2aCt2oPlUXXKwWgeEJaN0Lr/sQDZ78zEDqkez3xR62y+m
cuoZqcgbd9qgxIloDXfkI9dJytLoYBPuNRd/v7utFcvaVC1f3xTAsNAn4MAg
E1V7XXa76rVAL6h+M69MgLMnC3pWjNbBrKsjO9WDi9xXwp1R8ym/mHW2p6G6
BjsdIx8foPx0g+vjvWspPzWIz189Z1U1tJdc/hLhwEHJTVrcg01U3ps8XK7S
XQk/EX9bUykOmr12LbrVS2K+lZK6LZ+Bf+TndEc6G4If9wa/PSdxcm7NiuQ5
DHyIk76lHsaGjfyDcs5lEpJ6poEbdtGg9TpNlLmJhdtLw6abWRMwX7PoSqwm
DYs56S1pa1mIbxkeHT1MoDYt1kF4LwPiPnZNJ5LYKI3aFnU9lAQxabxAy5OB
KSW598xMqneHFc7WiCHx7M63y+JCNIRtLePmq7Kg3ECTnWVK4MCru9X9/RVg
bwwss79K5UnOuwuMi1SvIe23npKn4Wb81ou+GlQvLkuK/mBO5XArKR09TQa2
jWleVaR4YdV4MyP8GgnOuosfn46XolRE+XOWMgtJ6g+sDhgT0KmM+WxG9dbS
IxonKqneejnO6IwF1Vv9lj/RtpShQUMo+8qO5SzcGcoNbN9HwG6FRN4aPQZS
peeIpd+n9Fy4M1o75P90yf4/1/D/3vf+d/+/+/8v9/8HRWGuEw==
     "]], {}},
  AspectRatio->1,
  AxesLabel->{None, None},
  AxesOrigin->{20.000000000000043`, 100.00000000000023`},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultPlotStyle" -> 
    Automatic, "GridLinesInFront" -> True},
  PlotRange->{{20, 1000}, {100, 1000}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.9121486779800014`*^9, {3.9121487567617636`*^9, 3.912148780895775*^9}, 
   3.912506064393134*^9, 3.917923198607943*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"3a52cfc8-2ae6-470c-a0a1-7b023a369666"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Two Qubit Forth-back", "Subsection",
 CellChangeTimes->{{3.912240119915799*^9, 3.912240122314786*^9}, {
  3.9122417417456093`*^9, 
  3.912241741937609*^9}},ExpressionUUID->"6294c122-336d-4ca8-b2b8-\
57ed800ae431"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"I11", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", " ", 
       SubscriptBox["\[Kappa]", "t"]}], 
      RowBox[{"Abs", "[", 
       RowBox[{
        SubscriptBox["t", "1"], "-", 
        SubscriptBox["t", "2"]}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["t", "1"], ",", "0", ",", 
      RowBox[{"2", "T"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["t", "2"], ",", "0", ",", 
      RowBox[{"2", "T"}]}], "}"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"T", ">", "0"}], ",", 
       RowBox[{"v", ">", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Kappa]", "t"], ">", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], ">", "0"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.9122415844692307`*^9, 3.9122415857791004`*^9}, {
  3.9122418933705235`*^9, 3.912241921178483*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"2b230a0a-b8cb-4a34-9ddb-f27bab275676"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "2"}], " ", "T", " ", 
     SubscriptBox["\[Kappa]", "t"]}]], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", " ", "T", " ", 
       SubscriptBox["\[Kappa]", "t"]}]], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "T", " ", 
        SubscriptBox["\[Kappa]", "t"]}]], " ", "T", " ", 
      SubscriptBox["\[Kappa]", "t"]}]}], ")"}]}], 
  SubsuperscriptBox["\[Kappa]", "t", "2"]]], "Output",
 CellChangeTimes->{3.912241923432835*^9, 3.912506066513058*^9, 
  3.9126598389482403`*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"68f867fe-45f1-4964-8021-a4117b306490"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Asymptotic", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "2"}], " ", "T", " ", 
       SubscriptBox["\[Kappa]", "t"]}]], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "T", " ", 
         SubscriptBox["\[Kappa]", "t"]}]], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "T", " ", 
          SubscriptBox["\[Kappa]", "t"]}]], " ", "T", " ", 
        SubscriptBox["\[Kappa]", "t"]}]}], ")"}]}], 
    SubsuperscriptBox["\[Kappa]", "t", "2"]], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9122419469081664`*^9, 3.912241954594181*^9}, {
  3.9122420080432873`*^9, 3.912242010722411*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"91792cbd-d158-4725-97dc-6e7e957196e4"],

Cell[BoxData[
 RowBox[{"4", " ", 
  SuperscriptBox["T", "2"]}]], "Output",
 CellChangeTimes->{
  3.912241954881192*^9, {3.9122420084996023`*^9, 3.9122420166411257`*^9}, 
   3.91250606669322*^9},
 CellLabel->"Out[15]=",ExpressionUUID->"7595470b-3727-4b20-a21c-14b475005717"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"I22", "=", 
  RowBox[{"2", 
   RowBox[{"(", 
    RowBox[{"I1", "+", "I2"}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.9122415871640615`*^9, 3.9122415883867426`*^9}, {
  3.9122418956665215`*^9, 3.912241895762521*^9}, {3.912242043050395*^9, 
  3.9122420513704104`*^9}, {3.91224208449817*^9, 3.912242087586213*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"9989b4cc-de43-4d1e-b3d4-b49ecb1261f3"],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"(", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "T"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["\[Kappa]", "t"], "+", 
            RowBox[{"v", " ", 
             SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]], "+", 
        RowBox[{"T", " ", 
         SubscriptBox["\[Kappa]", "t"]}], "+", 
        RowBox[{"T", " ", "v", " ", 
         SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["\[Kappa]", "t"], "+", 
        RowBox[{"v", " ", 
         SubscriptBox["\[Kappa]", "x"]}]}], ")"}], "2"]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "2"}], " ", "T", " ", 
           SubscriptBox["\[Kappa]", "t"]}]], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["\[Kappa]", "t"], "+", 
              RowBox[{"v", " ", 
               SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]]}]}], ")"}], " ", 
       SubscriptBox["\[Kappa]", "t"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "2"}], " ", "T", " ", 
           SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", "v", " ", 
       SubscriptBox["\[Kappa]", "x"]}]}], 
     RowBox[{
      SubsuperscriptBox["\[Kappa]", "t", "3"], "-", 
      RowBox[{
       SuperscriptBox["v", "2"], " ", 
       SubscriptBox["\[Kappa]", "t"], " ", 
       SubsuperscriptBox["\[Kappa]", "x", "2"]}]}]]}], ")"}]}]], "Output",
 CellChangeTimes->{3.912659847875467*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"7c056ddf-9d31-4f2f-97db-f1b77b956d22"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ix11", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", " ", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"Abs", "[", 
         RowBox[{
          SubscriptBox["t", "1"], "-", 
          SubscriptBox["t", "2"]}], "]"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], 
        RowBox[{"(", 
         RowBox[{"d", "+", 
          RowBox[{"v", " ", 
           SubscriptBox["t", "2"]}]}], ")"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", "0", ",", "T"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", "0", ",", "T"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"T", ">", "0"}], ",", 
        RowBox[{"v", ">", "0"}], ",", 
        RowBox[{
         SubscriptBox["\[Kappa]", "t"], ">", "0"}], ",", 
        RowBox[{
         SubscriptBox["\[Kappa]", "x"], ">", "0"}]}], "}"}]}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.9116406794949894`*^9, 3.9116407486061687`*^9}, {
   3.912149758467888*^9, 3.9121497601564255`*^9}, 3.9122401094276915`*^9, {
   3.912240156747752*^9, 3.912240175555228*^9}, {3.9122416126837263`*^9, 
   3.912241624970691*^9}, 3.91224211306734*^9, {3.9126591934633975`*^9, 
   3.9126591966294847`*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"a33c7141-63d4-4027-b337-a90c6560aae8"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "T"}], " ", 
      SubscriptBox["\[Kappa]", "t"]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"T", " ", "v"}]}], ")"}], " ", 
      SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"T", " ", 
        SubscriptBox["\[Kappa]", "t"]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"T", " ", "v", " ", 
          SubscriptBox["\[Kappa]", "x"]}]]}], ")"}], " ", 
      SubsuperscriptBox["\[Kappa]", "t", "2"]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"T", " ", 
          SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"T", " ", "v", " ", 
          SubscriptBox["\[Kappa]", "x"]}]]}], ")"}], " ", "v", " ", 
      SubscriptBox["\[Kappa]", "t"], " ", 
      SubscriptBox["\[Kappa]", "x"]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"T", " ", 
          SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"T", " ", "v", " ", 
          SubscriptBox["\[Kappa]", "x"]}]]}], ")"}], " ", 
      SuperscriptBox["v", "2"], " ", 
      SubsuperscriptBox["\[Kappa]", "x", "2"]}]}], ")"}]}], 
  RowBox[{
   RowBox[{"v", " ", 
    SubsuperscriptBox["\[Kappa]", "t", "3"], " ", 
    SubscriptBox["\[Kappa]", "x"]}], "-", 
   RowBox[{
    SuperscriptBox["v", "3"], " ", 
    SubscriptBox["\[Kappa]", "t"], " ", 
    SubsuperscriptBox["\[Kappa]", "x", "3"]}]}]]], "Output",
 CellChangeTimes->{{3.9116407400347443`*^9, 3.91164075039948*^9}, 
   3.9121482249153247`*^9, 3.9121497638177605`*^9, 3.9122401831602325`*^9, 
   3.912241640799116*^9, 3.91224212527903*^9, 3.9125060707639146`*^9, 
   3.912659686665518*^9},
 CellLabel->"Out[2]=",ExpressionUUID->"054912a3-7368-4cf5-be25-0db4c07fc4a5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ix22", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", " ", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"Abs", "[", 
         RowBox[{
          SubscriptBox["t", "1"], "-", 
          SubscriptBox["t", "2"]}], "]"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], "v", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"d", "/", "v"}], "+", 
          RowBox[{"2", "T"}], "-", 
          SubscriptBox["t", "2"]}], ")"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", "T", ",", 
       RowBox[{"2", "T"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", "T", ",", 
       RowBox[{"2", "T"}]}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"T", ">", "0"}], ",", 
        RowBox[{"v", ">", "0"}], ",", 
        RowBox[{
         SubscriptBox["\[Kappa]", "t"], ">", "0"}], ",", 
        RowBox[{
         SubscriptBox["\[Kappa]", "x"], ">", "0"}]}], "}"}]}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.9116407899069796`*^9, 3.9116407924180374`*^9}, {
   3.912149762819853*^9, 3.9121497661959257`*^9}, 3.9122401100678096`*^9, {
   3.9122401832763386`*^9, 3.912240223020705*^9}, {3.9122416162997236`*^9, 
   3.9122416339147096`*^9}, 3.9122421140193434`*^9, {3.9126592015414867`*^9, 
   3.912659201961481*^9}, {3.912659785379548*^9, 3.9126598076666145`*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"7bd3c15e-862f-46de-88fd-3b7d7730645e"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "T"}], " ", 
      SubscriptBox["\[Kappa]", "t"]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"T", " ", "v"}]}], ")"}], " ", 
      SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"T", " ", 
        SubscriptBox["\[Kappa]", "t"]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"T", " ", "v", " ", 
          SubscriptBox["\[Kappa]", "x"]}]]}], ")"}], " ", 
      SubsuperscriptBox["\[Kappa]", "t", "2"]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"T", " ", 
          SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"T", " ", "v", " ", 
          SubscriptBox["\[Kappa]", "x"]}]]}], ")"}], " ", "v", " ", 
      SubscriptBox["\[Kappa]", "t"], " ", 
      SubscriptBox["\[Kappa]", "x"]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"T", " ", 
          SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"T", " ", "v", " ", 
          SubscriptBox["\[Kappa]", "x"]}]]}], ")"}], " ", 
      SuperscriptBox["v", "2"], " ", 
      SubsuperscriptBox["\[Kappa]", "x", "2"]}]}], ")"}]}], 
  RowBox[{
   RowBox[{"v", " ", 
    SubsuperscriptBox["\[Kappa]", "t", "3"], " ", 
    SubscriptBox["\[Kappa]", "x"]}], "-", 
   RowBox[{
    SuperscriptBox["v", "3"], " ", 
    SubscriptBox["\[Kappa]", "t"], " ", 
    SubsuperscriptBox["\[Kappa]", "x", "3"]}]}]]], "Output",
 CellChangeTimes->{
  3.9116407960204897`*^9, 3.9121482286056867`*^9, 3.9121497706199565`*^9, {
   3.912240218907854*^9, 3.9122402293384542`*^9}, 3.9122416456104217`*^9, 
   3.912242130274567*^9, 3.9125060756053066`*^9, 3.9126596991226263`*^9, 
   3.912659818799509*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"fead920e-d9bd-486f-bd41-d240c0320454"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ix21", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", " ", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["t", "2"], "-", 
          SubscriptBox["t", "1"]}], ")"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], "v", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"d", "/", "v"}], "+", 
          RowBox[{"2", "T"}], "-", 
          SubscriptBox["t", "2"]}], ")"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", "0", ",", "T"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", "T", ",", 
       RowBox[{"2", "T"}]}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"T", ">", "0"}], ",", 
        RowBox[{"v", ">", "0"}], ",", 
        RowBox[{
         SubscriptBox["\[Kappa]", "t"], ">", "0"}], ",", 
        RowBox[{
         SubscriptBox["\[Kappa]", "x"], ">", "0"}]}], "}"}]}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.9116408135514393`*^9, 3.91164088740675*^9}, {
   3.9121497701004825`*^9, 3.9121497710753703`*^9}, 3.9122401107797966`*^9, {
   3.9122402479963713`*^9, 3.9122402680437675`*^9}, {3.912241628291688*^9, 
   3.9122416321475306`*^9}, {3.9122421166834183`*^9, 
   3.9122421171365466`*^9}, {3.9126592049854555`*^9, 
   3.9126592054044757`*^9}, {3.9126598114626837`*^9, 3.9126598116098537`*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"265fb03b-8cd2-4b41-9426-50318dd5fec6"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", "T", " ", 
      SubscriptBox["\[Kappa]", "t"]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"T", " ", "v"}]}], ")"}], " ", 
      SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"T", " ", 
       SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"T", " ", 
       SubscriptBox["\[Kappa]", "t"]}]], "-", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"T", " ", "v", " ", 
       SubscriptBox["\[Kappa]", "x"]}]]}], ")"}]}], 
  RowBox[{
   SubscriptBox["\[Kappa]", "t"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Kappa]", "t"], "-", 
     RowBox[{"v", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]]], "Output",
 CellChangeTimes->{{3.9116408615970526`*^9, 3.9116408893245573`*^9}, 
   3.912148233705331*^9, 3.9121497771659184`*^9, 3.912240271968871*^9, 
   3.9122416475962257`*^9, 3.912242132274384*^9, 3.9125060775460677`*^9, 
   3.9126597027137547`*^9, 3.912659820591135*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"e849cc15-c263-479b-8001-36ce535ac38d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ix12", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", " ", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["t", "1"], "-", 
          SubscriptBox["t", "2"]}], ")"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], 
        RowBox[{"(", 
         RowBox[{"d", "+", 
          RowBox[{"v", " ", 
           SubscriptBox["t", "2"]}]}], ")"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", "T", ",", 
       RowBox[{"2", "T"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", "0", ",", "T"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"T", ">", "0"}], ",", 
        RowBox[{"v", ">", "0"}], ",", 
        RowBox[{
         SubscriptBox["\[Kappa]", "t"], ">", "0"}], ",", 
        RowBox[{
         SubscriptBox["\[Kappa]", "x"], ">", "0"}]}], "}"}]}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.9116408940772734`*^9, 3.9116409055379105`*^9}, 
   3.9121497748207827`*^9, 3.9122401113157797`*^9, {3.912240217140229*^9, 
   3.9122402172673454`*^9}, {3.9122402507554483`*^9, 
   3.9122402857158413`*^9}, {3.912241629683098*^9, 3.912241630619713*^9}, {
   3.9122421187705493`*^9, 3.9122421188890634`*^9}, {3.912659211829465*^9, 
   3.9126592151834593`*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"2b7e6c99-3d31-40ac-a5db-7fc703d05b78"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", "T", " ", 
      SubscriptBox["\[Kappa]", "t"]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"T", " ", "v"}]}], ")"}], " ", 
      SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"T", " ", 
       SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"T", " ", 
       SubscriptBox["\[Kappa]", "t"]}]], "-", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"T", " ", "v", " ", 
       SubscriptBox["\[Kappa]", "x"]}]]}], ")"}]}], 
  RowBox[{
   SubscriptBox["\[Kappa]", "t"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Kappa]", "t"], "-", 
     RowBox[{"v", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]]], "Output",
 CellChangeTimes->{3.911640909550102*^9, 3.9121482393704915`*^9, 
  3.9121497829201603`*^9, 3.912240288909694*^9, 3.9122416494162016`*^9, 
  3.912242134129069*^9, 3.912506079373727*^9, 3.912659705966525*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"0b65a751-445b-482d-bece-af1e310b864a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Ix11", "==", "Ix22"}], ",", 
    RowBox[{"Ix21", "==", "Ix12"}]}], "}"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.9122402902848043`*^9, 3.912240291851816*^9}, {
  3.9122411632348022`*^9, 3.912241166147046*^9}, {3.912242099090376*^9, 
  3.9122421342822084`*^9}, {3.9126597222676497`*^9, 3.9126597231375675`*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"a6dcc39c-3bf1-4031-9e5a-4168e931161a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{
  3.9122402931092663`*^9, 3.912241166395054*^9, {3.9122421068376713`*^9, 
   3.912242135621434*^9}, 3.9125060793997507`*^9, {3.912659706892695*^9, 
   3.912659723749853*^9}, 3.9126598238805*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"0b936c47-d0a3-4d77-9751-acc4bc87e65d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]", "[", 
    RowBox[{"\[Beta]_", ",", "\[Gamma]_", ",", "\[Epsilon]_"}], "]"}], ":=", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", "\[Beta]"}]], "+", 
      RowBox[{"2", " ", "\[Beta]"}], "-", 
      FractionBox[
       RowBox[{"2", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", "\[Beta]"}], "-", "\[Gamma]", "-", 
          "\[Epsilon]"}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["\[ExponentialE]", "\[Beta]"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", "\[Beta]"], "-", 
          SuperscriptBox["\[ExponentialE]", "\[Gamma]"]}], ")"}]}], 
       RowBox[{"1", "-", 
        FractionBox["\[Gamma]", "\[Beta]"]}]], "+", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "\[Beta]"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              FractionBox["\[Gamma]", "\[Beta]"]}], ")"}]}]], "+", "\[Beta]", 
          "+", "\[Gamma]"}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          FractionBox["\[Gamma]", "\[Beta]"]}], ")"}], "2"]], "+", 
      FractionBox[
       RowBox[{"1", "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "2"}], " ", "\[Beta]"}]], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "\[Beta]"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             FractionBox["\[Gamma]", "\[Beta]"]}], ")"}]}]]}], "+", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"-", "2"}], " ", "\[Beta]"}]]}], ")"}], " ", 
          "\[Gamma]"}], "\[Beta]"]}], 
       RowBox[{"1", "-", 
        FractionBox[
         SuperscriptBox["\[Gamma]", "2"], 
         SuperscriptBox["\[Beta]", "2"]]}]], "-", 
      FractionBox[
       RowBox[{"2", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]", "-", "\[Epsilon]"}]], 
        " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["\[ExponentialE]", "\[Beta]"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["\[ExponentialE]", "\[Gamma]"]}], ")"}]}], "-", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["\[ExponentialE]", "\[Beta]"]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              SuperscriptBox["\[ExponentialE]", "\[Gamma]"]}], ")"}], " ", 
            "\[Gamma]"}], "\[Beta]"], "-", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["\[ExponentialE]", "\[Beta]"]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["\[ExponentialE]", "\[Gamma]"]}], ")"}], " ", 
            SuperscriptBox["\[Gamma]", "2"]}], 
           SuperscriptBox["\[Beta]", "2"]]}], ")"}]}], 
       RowBox[{
        FractionBox["\[Gamma]", "\[Beta]"], "-", 
        FractionBox[
         SuperscriptBox["\[Gamma]", "3"], 
         SuperscriptBox["\[Beta]", "3"]]}]]}], ")"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.912241121670081*^9, 3.9122411482120605`*^9}, {
  3.9122421617711*^9, 3.912242219978795*^9}, {3.9125062796727405`*^9, 
  3.9125062797815638`*^9}, {3.912506512925725*^9, 3.912506531741057*^9}, {
  3.9125066515557165`*^9, 3.912506667329025*^9}, {3.9126599640322638`*^9, 
  3.9126599730703497`*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"37f5fe05-a4f7-45b6-b520-7c7c027741ee"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"I11", "+", "I22", "-", 
    RowBox[{"2", 
     RowBox[{"(", 
      RowBox[{"Ix11", "+", "Ix22", "+", "Ix21", "+", "Ix12"}], ")"}]}]}], 
   "]"}], "/.", "rule"}]], "Input",
 CellChangeTimes->{{3.912242194346307*^9, 3.9122421957278323`*^9}, {
   3.9125062698986855`*^9, 3.912506270034809*^9}, 3.9125063150777025`*^9, {
   3.9125065341413107`*^9, 3.9125066653011847`*^9}, 3.912659911655346*^9},
 CellLabel->"In[19]:=",ExpressionUUID->"0bb2ebf2-97d0-412d-b5a8-aa93c748a549"],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[Beta]"}]], "+", 
    RowBox[{"2", " ", "\[Beta]"}], "-", 
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "\[Beta]"}], "-", "\[Gamma]", "-", 
        "\[Epsilon]"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", "\[Beta]"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", "\[Beta]"], "-", 
        SuperscriptBox["\[ExponentialE]", "\[Gamma]"]}], ")"}]}], 
     RowBox[{"1", "-", 
      FractionBox["\[Gamma]", "\[Beta]"]}]], "+", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "\[Beta]"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            FractionBox["\[Gamma]", "\[Beta]"]}], ")"}]}]], "+", "\[Beta]", 
        "+", "\[Gamma]"}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        FractionBox["\[Gamma]", "\[Beta]"]}], ")"}], "2"]], "+", 
    FractionBox[
     RowBox[{"1", "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", "\[Beta]"}]], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "\[Beta]"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["\[Gamma]", "\[Beta]"]}], ")"}]}]]}], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", "\[Beta]"}]]}], ")"}], " ", "\[Gamma]"}],
        "\[Beta]"]}], 
     RowBox[{"1", "-", 
      FractionBox[
       SuperscriptBox["\[Gamma]", "2"], 
       SuperscriptBox["\[Beta]", "2"]]}]], "-", 
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]", "-", "\[Epsilon]"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", "\[Beta]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["\[ExponentialE]", "\[Gamma]"]}], ")"}]}], "-", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[ExponentialE]", "\[Beta]"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            SuperscriptBox["\[ExponentialE]", "\[Gamma]"]}], ")"}], " ", 
          "\[Gamma]"}], "\[Beta]"], "-", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[ExponentialE]", "\[Beta]"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[ExponentialE]", "\[Gamma]"]}], ")"}], " ", 
          SuperscriptBox["\[Gamma]", "2"]}], 
         SuperscriptBox["\[Beta]", "2"]]}], ")"}]}], 
     RowBox[{
      FractionBox["\[Gamma]", "\[Beta]"], "-", 
      FractionBox[
       SuperscriptBox["\[Gamma]", "3"], 
       SuperscriptBox["\[Beta]", "3"]]}]]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.912242192645177*^9, 3.912242198565595*^9}, 
   3.9125060865981674`*^9, 3.9125062760592747`*^9, 3.912506315368206*^9, {
   3.91250653647607*^9, 3.91250667486723*^9}, 3.9126598300032043`*^9, {
   3.912659887772953*^9, 3.912659939509426*^9}},
 CellLabel->"Out[19]=",ExpressionUUID->"4e5b28a3-0a92-4890-b8f2-9e267df65b5b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Chi]", "[", 
   RowBox[{
   "\[Sigma]_", ",", "\[Delta]_", ",", "\[Kappa]_", ",", "\[Beta]_", ",", 
    "\[Gamma]_", ",", "\[Epsilon]_"}], "]"}], ":=", 
  RowBox[{"Exp", "[", 
   RowBox[{
    RowBox[{"\[ImaginaryI]", " ", "\[Delta]", " ", 
     RowBox[{"\[Beta]", "/", "\[Kappa]"}]}], "+", 
    RowBox[{
     FractionBox[
      RowBox[{"-", "1"}], "2"], 
     FractionBox[
      SuperscriptBox[
       RowBox[{"\[Sigma]", " "}], "2"], 
      SuperscriptBox["\[Kappa]", "2"]], 
     RowBox[{"\[Phi]", "[", 
      RowBox[{"\[Beta]", ",", "\[Gamma]", ",", "\[Epsilon]"}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.9125064969740257`*^9, 3.9125064977639246`*^9}, {
   3.9125066939781866`*^9, 3.912506872268737*^9}, {3.912509278275997*^9, 
   3.9125092840037537`*^9}, {3.9125093462758007`*^9, 
   3.9125093610387616`*^9}, {3.9126599486094046`*^9, 
   3.9126599834092293`*^9}, {3.912757323300344*^9, 3.9127573416540794`*^9}, {
   3.9127574293333087`*^9, 3.9127574602909718`*^9}, 3.9127575338238697`*^9},
 CellLabel->"In[24]:=",ExpressionUUID->"f4fbbacc-ba24-485a-87f3-fe1a090c568d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Asymptotic", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"2", 
         RowBox[{"\[Beta]", "/", "\[Kappa]"}]}], ")"}], "2"]}], "/", 
     SuperscriptBox[
      RowBox[{"Log", "[", 
       RowBox[{"\[Chi]", "[", 
        RowBox[{
        "\[Sigma]", ",", "0", ",", "\[Kappa]", ",", "\[Beta]", ",", 
         "\[Gamma]", ",", "\[Epsilon]"}], "]"}], "]"}], 
      RowBox[{"-", "1"}]]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Gamma]", ",", "\[Infinity]", ",", "1"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.9132746443836565`*^9, 3.9132746504163733`*^9}, {
  3.913274705715022*^9, 3.9132747114200077`*^9}, {3.9133758850968623`*^9, 
  3.9133758857233157`*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"b61e3190-8875-40c5-a05d-c7c64b8d140f"],

Cell[BoxData[
 RowBox[{"2", " ", 
  SqrtBox[
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["\[Beta]", "2"], " ", 
      RowBox[{"Log", "[", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"-", "2"}], " ", "\[Beta]"}]], "-", 
             RowBox[{"2", " ", "\[Beta]"}]}], ")"}], " ", 
           SuperscriptBox["\[Sigma]", "2"]}], 
          SuperscriptBox["\[Kappa]", "2"]], "-", 
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]", "-", "\[Epsilon]"}]], 
           " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["\[ExponentialE]", "\[Beta]"]}], ")"}], " ", 
           "\[Beta]", " ", 
           SuperscriptBox["\[Sigma]", "2"]}], 
          RowBox[{"\[Gamma]", " ", 
           SuperscriptBox["\[Kappa]", "2"]}]], "-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "\[Beta]"}], "-", "\[Epsilon]"}]], " ",
            "\[Beta]", " ", 
           RowBox[{"(", 
            RowBox[{"2", "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"2", " ", "\[Beta]"}]]}], "-", 
             SuperscriptBox["\[ExponentialE]", "\[Epsilon]"], "+", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"2", " ", "\[Beta]"}], "+", "\[Epsilon]"}]], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{"2", " ", "\[Beta]"}], "+", "\[Epsilon]"}]], " ", 
              "\[Beta]"}]}], ")"}], " ", 
           SuperscriptBox["\[Sigma]", "2"]}], 
          RowBox[{"\[Gamma]", " ", 
           SuperscriptBox["\[Kappa]", "2"]}]]}]], "]"}]}], 
     SuperscriptBox["\[Kappa]", "2"]]}]]}]], "Output",
 CellChangeTimes->{{3.913274701540353*^9, 3.9132747175562997`*^9}, 
   3.9133757839900084`*^9, 3.9133758921468935`*^9},
 CellLabel->"Out[30]=",ExpressionUUID->"fe2c85c9-e70e-44d9-8f18-8e35dbdcc553"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.913274763820758*^9, 
  3.913274824688017*^9}},ExpressionUUID->"04ad9717-bced-4d9f-aa5e-\
dbfd64ecdda5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Asymptotic", "[", 
  RowBox[{
   SqrtBox[
    RowBox[{"-", 
     RowBox[{"Log", "[", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"-", "2"}], " ", "\[Beta]"}]], "-", 
            RowBox[{"2", " ", "\[Beta]"}]}], ")"}], " ", 
          SuperscriptBox["\[Sigma]", "2"]}], 
         SuperscriptBox["\[Kappa]", "2"]], "-", 
        FractionBox[
         RowBox[{"4", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]", "-", "\[Epsilon]"}]], 
          " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[ExponentialE]", "\[Beta]"]}], ")"}], " ", 
          "\[Beta]", " ", 
          SuperscriptBox["\[Sigma]", "2"]}], 
         RowBox[{"\[Gamma]", " ", 
          SuperscriptBox["\[Kappa]", "2"]}]], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "\[Beta]"}], "-", "\[Epsilon]"}]], " ", 
          "\[Beta]", " ", 
          RowBox[{"(", 
           RowBox[{"2", "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"2", " ", "\[Beta]"}]]}], "-", 
            SuperscriptBox["\[ExponentialE]", "\[Epsilon]"], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"2", " ", "\[Beta]"}], "+", "\[Epsilon]"}]], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"2", " ", "\[Beta]"}], "+", "\[Epsilon]"}]], " ", 
             "\[Beta]"}]}], ")"}], " ", 
          SuperscriptBox["\[Sigma]", "2"]}], 
         RowBox[{"\[Gamma]", " ", 
          SuperscriptBox["\[Kappa]", "2"]}]]}]], "]"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"\[Epsilon]", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9132749137767253`*^9, 3.9132749172742786`*^9}, {
  3.913274988500348*^9, 3.9132749886631913`*^9}, {3.9133757992921734`*^9, 
  3.9133758134998264`*^9}, {3.913375899952651*^9, 3.9133759139566617`*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"751c7646-4119-4b54-ac94-74d0bdf49ecd"],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"-", 
    RowBox[{"Log", "[", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "2"}], " ", "\[Beta]"}]], "-", 
           RowBox[{"2", " ", "\[Beta]"}]}], ")"}], " ", 
         SuperscriptBox["\[Sigma]", "2"]}], 
        SuperscriptBox["\[Kappa]", "2"]], "-", 
       FractionBox[
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]"}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["\[ExponentialE]", "\[Beta]"]}], ")"}], " ", 
         "\[Beta]", " ", 
         SuperscriptBox["\[Sigma]", "2"]}], 
        RowBox[{"\[Gamma]", " ", 
         SuperscriptBox["\[Kappa]", "2"]}]], "-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "2"}], " ", "\[Beta]"}]], " ", "\[Beta]", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"2", " ", "\[Beta]"}]], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "\[Beta]"}]], " ", "\[Beta]"}]}], ")"}], " ", 
         SuperscriptBox["\[Sigma]", "2"]}], 
        RowBox[{"\[Gamma]", " ", 
         SuperscriptBox["\[Kappa]", "2"]}]]}]], "]"}]}]], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox["\[Epsilon]", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", "\[Beta]"}], "-", 
          RowBox[{"2", " ", "\[Gamma]"}]}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["\[ExponentialE]", "\[Beta]"]}], ")"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["\[ExponentialE]", "\[Beta]"]}], "+", 
           SuperscriptBox["\[ExponentialE]", "\[Gamma]"], "+", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"\[Beta]", "+", "\[Gamma]"}]]}], ")"}], "2"], " ", 
        SuperscriptBox["\[Beta]", "2"], " ", 
        SuperscriptBox["\[Sigma]", "4"]}], 
       RowBox[{
        SuperscriptBox["\[Gamma]", "2"], " ", 
        SuperscriptBox["\[Kappa]", "4"], " ", 
        SuperscriptBox[
         RowBox[{"Log", "[", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            FractionBox[
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{"-", "2"}], " ", "\[Beta]"}]], "-", 
                RowBox[{"2", " ", "\[Beta]"}]}], ")"}], " ", 
              SuperscriptBox["\[Sigma]", "2"]}], 
             SuperscriptBox["\[Kappa]", "2"]], "-", 
            FractionBox[
             RowBox[{"4", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]"}]], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["\[ExponentialE]", "\[Beta]"]}], ")"}], " ", 
              "\[Beta]", " ", 
              SuperscriptBox["\[Sigma]", "2"]}], 
             RowBox[{"\[Gamma]", " ", 
              SuperscriptBox["\[Kappa]", "2"]}]], "-", 
            FractionBox[
             RowBox[{
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{"-", "2"}], " ", "\[Beta]"}]], " ", "\[Beta]", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{"2", " ", "\[Beta]"}]], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{"2", " ", "\[Beta]"}]], " ", "\[Beta]"}]}], ")"}], 
              " ", 
              SuperscriptBox["\[Sigma]", "2"]}], 
             RowBox[{"\[Gamma]", " ", 
              SuperscriptBox["\[Kappa]", "2"]}]]}]], "]"}], "2"]}]]}], "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "\[Beta]"}], "-", "\[Gamma]"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", "\[Beta]"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["\[ExponentialE]", "\[Beta]"]}], "+", 
         SuperscriptBox["\[ExponentialE]", "\[Gamma]"], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"\[Beta]", "+", "\[Gamma]"}]]}], ")"}], " ", "\[Beta]", " ", 
       SuperscriptBox["\[Sigma]", "2"]}], 
      RowBox[{"\[Gamma]", " ", 
       SuperscriptBox["\[Kappa]", "2"], " ", 
       RowBox[{"Log", "[", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{"-", "2"}], " ", "\[Beta]"}]], "-", 
              RowBox[{"2", " ", "\[Beta]"}]}], ")"}], " ", 
            SuperscriptBox["\[Sigma]", "2"]}], 
           SuperscriptBox["\[Kappa]", "2"]], "-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]"}]], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["\[ExponentialE]", "\[Beta]"]}], ")"}], " ", 
            "\[Beta]", " ", 
            SuperscriptBox["\[Sigma]", "2"]}], 
           RowBox[{"\[Gamma]", " ", 
            SuperscriptBox["\[Kappa]", "2"]}]], "-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"-", "2"}], " ", "\[Beta]"}]], " ", "\[Beta]", " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"2", " ", "\[Beta]"}]], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"2", " ", "\[Beta]"}]], " ", "\[Beta]"}]}], ")"}], 
            " ", 
            SuperscriptBox["\[Sigma]", "2"]}], 
           RowBox[{"\[Gamma]", " ", 
            SuperscriptBox["\[Kappa]", "2"]}]]}]], "]"}]}]]}], ")"}], " ", 
   SqrtBox[
    RowBox[{"-", 
     RowBox[{"Log", "[", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"-", "2"}], " ", "\[Beta]"}]], "-", 
            RowBox[{"2", " ", "\[Beta]"}]}], ")"}], " ", 
          SuperscriptBox["\[Sigma]", "2"]}], 
         SuperscriptBox["\[Kappa]", "2"]], "-", 
        FractionBox[
         RowBox[{"4", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]"}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[ExponentialE]", "\[Beta]"]}], ")"}], " ", 
          "\[Beta]", " ", 
          SuperscriptBox["\[Sigma]", "2"]}], 
         RowBox[{"\[Gamma]", " ", 
          SuperscriptBox["\[Kappa]", "2"]}]], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", "\[Beta]"}]], " ", "\[Beta]", " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "\[Beta]"}]], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"2", " ", "\[Beta]"}]], " ", "\[Beta]"}]}], ")"}], " ", 
          SuperscriptBox["\[Sigma]", "2"]}], 
         RowBox[{"\[Gamma]", " ", 
          SuperscriptBox["\[Kappa]", "2"]}]]}]], "]"}]}]]}], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[Beta]"}], "-", "\[Gamma]"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", "\[Beta]"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["\[ExponentialE]", "\[Beta]"]}], "+", 
      SuperscriptBox["\[ExponentialE]", "\[Gamma]"], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[Beta]", "+", "\[Gamma]"}]]}], ")"}], " ", "\[Beta]", " ", 
    "\[Epsilon]", " ", 
    SuperscriptBox["\[Sigma]", "2"], " ", 
    SqrtBox[
     RowBox[{"-", 
      RowBox[{"Log", "[", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"-", "2"}], " ", "\[Beta]"}]], "-", 
             RowBox[{"2", " ", "\[Beta]"}]}], ")"}], " ", 
           SuperscriptBox["\[Sigma]", "2"]}], 
          SuperscriptBox["\[Kappa]", "2"]], "-", 
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]"}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["\[ExponentialE]", "\[Beta]"]}], ")"}], " ", 
           "\[Beta]", " ", 
           SuperscriptBox["\[Sigma]", "2"]}], 
          RowBox[{"\[Gamma]", " ", 
           SuperscriptBox["\[Kappa]", "2"]}]], "-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "2"}], " ", "\[Beta]"}]], " ", "\[Beta]", " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"2", " ", "\[Beta]"}]], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"2", " ", "\[Beta]"}]], " ", "\[Beta]"}]}], ")"}], " ", 
           SuperscriptBox["\[Sigma]", "2"]}], 
          RowBox[{"\[Gamma]", " ", 
           SuperscriptBox["\[Kappa]", "2"]}]]}]], "]"}]}]]}], 
   RowBox[{"\[Gamma]", " ", 
    SuperscriptBox["\[Kappa]", "2"], " ", 
    RowBox[{"Log", "[", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "2"}], " ", "\[Beta]"}]], "-", 
           RowBox[{"2", " ", "\[Beta]"}]}], ")"}], " ", 
         SuperscriptBox["\[Sigma]", "2"]}], 
        SuperscriptBox["\[Kappa]", "2"]], "-", 
       FractionBox[
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "\[Beta]"}], "-", "\[Gamma]"}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["\[ExponentialE]", "\[Beta]"]}], ")"}], " ", 
         "\[Beta]", " ", 
         SuperscriptBox["\[Sigma]", "2"]}], 
        RowBox[{"\[Gamma]", " ", 
         SuperscriptBox["\[Kappa]", "2"]}]], "-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "2"}], " ", "\[Beta]"}]], " ", "\[Beta]", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"2", " ", "\[Beta]"}]], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", "\[Beta]"}]], " ", "\[Beta]"}]}], ")"}], " ", 
         SuperscriptBox["\[Sigma]", "2"]}], 
        RowBox[{"\[Gamma]", " ", 
         SuperscriptBox["\[Kappa]", "2"]}]]}]], "]"}]}]]}]], "Output",
 CellChangeTimes->{
  3.913274917892191*^9, 3.9132749891336365`*^9, {3.9133757960128207`*^9, 
   3.9133758138322144`*^9}, {3.9133759015748367`*^9, 3.913375914226287*^9}},
 CellLabel->"Out[33]=",ExpressionUUID->"315fd86e-d97b-4e02-98a0-2c33c3761624"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{
     RowBox[{"1", "/", "2"}], "+", 
     RowBox[{
      RowBox[{"1", "/", "2"}], "*", 
      RowBox[{"\[Chi]", "[", 
       RowBox[{
        FractionBox[
         SqrtBox["2"], "1.1"], ",", "100", ",", "0.05", ",", 
        RowBox[{"0.05", "*", "t"}], ",", 
        RowBox[{"t", "*", 
         RowBox[{"2.8", "/", "0.013"}]}], ",", 
        RowBox[{"t", "*", 
         RowBox[{
          RowBox[{"2.8", "/", "4"}], "/", "0.013"}]}]}], "]"}]}]}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0.01", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"Frame", "->", "True"}], ",", 
   RowBox[{"FrameLabel", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<Shuttling Time t (ms)\>\"", ",", "\"\<F\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.912757574284254*^9, 3.912757634886689*^9}, {
  3.9127576894101515`*^9, 3.912757735238739*^9}, {3.9127578870620656`*^9, 
  3.9127579935694*^9}},
 CellLabel->"In[59]:=",ExpressionUUID->"8eaa3f2a-4fb7-4ede-a2b5-9524782bdbc4"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2], 
         Opacity[1.], LineBox[CompressedData["
1:eJwUV3c81d8bl5ZQSSpECiFRKiSjt0pSoTJKgxARFQolkiQkWdHXLCsys5Ps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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
      Slot["HighlightElements"], 
      Slot["LayoutOptions"], 
      Slot["Meta"], 
      Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
          Annotation[{
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]], 
            Line[CompressedData["
1:eJwUV3c81d8bl5ZQSSpECiFRKiSjt0pSoTJKgxARFQolkiQkWdHXLCsys5Ps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             "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
          "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
          "Axes" -> {True, True}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>]]& )[<|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
         "Axes" -> {True, True}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>],
     ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
      4.503599627370496*^15, -4.503599627370496*^15}}]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]], 
         Line[CompressedData["
1:eJwUV3c81d8bl5ZQSSpECiFRKiSjt0pSoTJKgxARFQolkiQkWdHXLCsys5Ps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          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
       "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
       "Axes" -> {True, True}, "AspectRatio" -> GoldenRatio^(-1), 
       "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"F\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox["\"Shuttling Time t (ms)\"", HoldForm], TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.9127576406859503`*^9, {3.9127577073345165`*^9, 3.9127577356716537`*^9}, {
   3.912757891306644*^9, 3.9127579943570867`*^9}},
 CellLabel->"Out[59]=",ExpressionUUID->"b8995ff0-973f-4324-979b-29821fdc3656"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Re", "@", 
    RowBox[{"\[Chi]", "[", 
     RowBox[{
      FractionBox[
       SqrtBox["2"], "1.1"], ",", "0.5", ",", "0.05", ",", 
      RowBox[{"0.05", "*", 
       RowBox[{"d", "/", "2.8"}]}], ",", 
      RowBox[{"d", "/", "0.013"}], ",", 
      RowBox[{
       RowBox[{"d", "/", "4"}], "/", "0.013"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "0.1", ",", "0.5"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"Frame", "->", "True"}], ",", 
   RowBox[{"FrameLabel", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<Shuttling Distance d (nm)\>\"", ",", "\"\<F\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQB2IQPdUkfAWj2lvHoi1+60C0ivmTryB6i//ubyB68rrD
v0G0gccJML3Bja+uGUg/uiHYD6Jf9W1ZDqIdbgivANHvV3/bD6K7rTgOgWg7
j8gTIPrE/DQw/cW4/kYLkPb7eOoeiM7Ua/kEoicVC3wG0Z9PPv0NosUyNjO0
AmkJnROsIPrKzdPsIPpiGr8oiF5j1wWmnTdukwXR/c8ny4Ho43MqPUH0gzPv
gkC07NM9WSD6SJZwIYj2eeQ3FUSbR20F05zb1jSdA9Jtvt7NIPqhTP8cEH1X
5O5iED2/4M5yEH3q0o8VIFovUu/kVSB949iNSyD6X++nXX+BtNHstj0g2lrh
/iEQ/UvQ9iiIDlp2XPofkO44u0oORAMA3ny95w==
  "],
 CellLabel->"In[24]:=",ExpressionUUID->"b23afc85-1883-4ee8-8ae8-70426a0b05ea"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2], 
         Opacity[1.], LineBox[CompressedData["
1:eJwV0Hs0lHkAxnHExpRdSrtIrVZYS0n3FM+6xEmlJGrS1BbSlkPDtigKk5xq
GUqXSZQSY3dRWBm3qKbEuo1xG5pXNVrxzvsrOuS2dvaP53zP599nyeHQXYEa
ampq21X7v7zVeZUCgQiCunv2Te0Extnjw/eyRLAfWZhfonLRfA+rgjwROM9u
G6ar/GZ48OoTkQiu7AZZkMpOD21Ch7pFSHYVzVFXeWbZgyUOxuWIP2NpulJK
cNry0fm+m+UIFU8Z8CUE4cbinZa3KpC53H/j6mYCub6STL2sguJSzBH+C4I1
R2Ln9Ugeo+xN2OjYYwJpnm1dzUANfInC3biMwMPq/tyy6VoM/1Bob1RIsHZP
y+VVak9x06VynVMOQV9S3GJvw2cISPvK0e4WgWFqV6evtRibzopfS1MJnjv3
S+TWz+FW/kinKpHAbjqijeX8Auk6WZPe0QTzj9QsqNhch89uxaccuAS89IKE
Ha4v8TmgMH80kOBB93eTiXvr8VQg93FjE+x6vq3IdV8Dbtssb9DYrvqrYirk
PvdvfBzKb3QCwZ2YXexBXiPevkjjedgRaDKchGJeExJo2zKZGYF5ECk1FTRj
d2T2iXYDgoPuCxfoeLYg983SsMAvCC5Qca3eshas6thRsm2UwQSnIlsvoBVs
3ygu6x2DnOLmG3xFKz6+NZ2I6GDwUDeX3xcqQWDOeL65mMGYIzt35KMEq7xN
36WUMDjnK2+P5LbBixvDYu4xOBFmMbtlsg1PP/8ceTKVwfXALez30VKMpPzb
1HaWgQnHtkCq3Y6OxIarHsEMBuwHjFZebseyqpzxgr0MCDmd4zWvAyuMcwdm
uTHwyZOsccnogG6Q66L9dgxGN2i+G13cCZlPoHnRIgbyB9r5JpmdcFxf5qfH
YmBu0/Krwfdd+EsaqeB8UiL3TNihJmEX/C5UptRSSiS2d3ruW92NgeAhd82X
StydZcgRlnYjnv7D4lixEpqG1vFH18rwoc5FoshQQrxC/feJGhlea10TW59X
ota0aNjTuQfszRsv5ocqYbLAwvFkUw/m+NW70b5KVJPgO7p7e3HcK2m5g6MS
6VnJZke7ehHlsYnfZ6FEx57wvDT/V4g4EG5oq6vEtv6VO3n9r5B4zcC/9xMN
HbZYVxEgxylZyPGSXhrmrcZNXxM5+J7+GpZPaESbbi2cc4LCyIam8C/zaBxU
HIvdGkZhrv7G4gwhDWfhRa9Lv1Bo4F6nbVTWXlE/woqiMGFmun1rLo2r2LKe
FU/h/cgpceJ9GgUH3Gu10yjcKLp7ZSaLxutbLm1aZRT0278VDt6k8ewn/+zN
5RSM3CwtolQWLuWdTKikYGlnlTlb5ZA/n3yjVUshrmtR9FIBjYkKp/2a9RTW
6UoJ5zoNgx70a/RSSBqtKW2+QmMs82Cps5wC10sg5agsO3w2Mb6PAk/IpYcu
07gzWG2l0U9BR2jG0lZ52YRDiDpDIfT8tWmk0NCr5sDpAwXXfZFDjXwan+Ji
9OKGKUz+s7/NT+VynaoitTEKMwLb1IhkGhmNvbwfxykcCl4cpKVybOrU7thJ
Co5++uuuJNHw9zGxqJmmkFytrb5EZTejTWMzMxQKGE1xwW80/gO1Z4Sk
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
      Slot["HighlightElements"], 
      Slot["LayoutOptions"], 
      Slot["Meta"], 
      Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
          Annotation[{
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]], 
            Line[CompressedData["
1:eJwV0Hs0lHkAxnHExpRdSrtIrVZYS0n3FM+6xEmlJGrS1BbSlkPDtigKk5xq
GUqXSZQSY3dRWBm3qKbEuo1xG5pXNVrxzvsrOuS2dvaP53zP599nyeHQXYEa
ampq21X7v7zVeZUCgQiCunv2Te0Extnjw/eyRLAfWZhfonLRfA+rgjwROM9u
G6ar/GZ48OoTkQiu7AZZkMpOD21Ch7pFSHYVzVFXeWbZgyUOxuWIP2NpulJK
cNry0fm+m+UIFU8Z8CUE4cbinZa3KpC53H/j6mYCub6STL2sguJSzBH+C4I1
R2Ln9Ugeo+xN2OjYYwJpnm1dzUANfInC3biMwMPq/tyy6VoM/1Bob1RIsHZP
y+VVak9x06VynVMOQV9S3GJvw2cISPvK0e4WgWFqV6evtRibzopfS1MJnjv3
S+TWz+FW/kinKpHAbjqijeX8Auk6WZPe0QTzj9QsqNhch89uxaccuAS89IKE
Ha4v8TmgMH80kOBB93eTiXvr8VQg93FjE+x6vq3IdV8Dbtssb9DYrvqrYirk
PvdvfBzKb3QCwZ2YXexBXiPevkjjedgRaDKchGJeExJo2zKZGYF5ECk1FTRj
d2T2iXYDgoPuCxfoeLYg983SsMAvCC5Qca3eshas6thRsm2UwQSnIlsvoBVs
3ygu6x2DnOLmG3xFKz6+NZ2I6GDwUDeX3xcqQWDOeL65mMGYIzt35KMEq7xN
36WUMDjnK2+P5LbBixvDYu4xOBFmMbtlsg1PP/8ceTKVwfXALez30VKMpPzb
1HaWgQnHtkCq3Y6OxIarHsEMBuwHjFZebseyqpzxgr0MCDmd4zWvAyuMcwdm
uTHwyZOsccnogG6Q66L9dgxGN2i+G13cCZlPoHnRIgbyB9r5JpmdcFxf5qfH
YmBu0/Krwfdd+EsaqeB8UiL3TNihJmEX/C5UptRSSiS2d3ruW92NgeAhd82X
StydZcgRlnYjnv7D4lixEpqG1vFH18rwoc5FoshQQrxC/feJGhlea10TW59X
ota0aNjTuQfszRsv5ocqYbLAwvFkUw/m+NW70b5KVJPgO7p7e3HcK2m5g6MS
6VnJZke7ehHlsYnfZ6FEx57wvDT/V4g4EG5oq6vEtv6VO3n9r5B4zcC/9xMN
HbZYVxEgxylZyPGSXhrmrcZNXxM5+J7+GpZPaESbbi2cc4LCyIam8C/zaBxU
HIvdGkZhrv7G4gwhDWfhRa9Lv1Bo4F6nbVTWXlE/woqiMGFmun1rLo2r2LKe
FU/h/cgpceJ9GgUH3Gu10yjcKLp7ZSaLxutbLm1aZRT0278VDt6k8ewn/+zN
5RSM3CwtolQWLuWdTKikYGlnlTlb5ZA/n3yjVUshrmtR9FIBjYkKp/2a9RTW
6UoJ5zoNgx70a/RSSBqtKW2+QmMs82Cps5wC10sg5agsO3w2Mb6PAk/IpYcu
07gzWG2l0U9BR2jG0lZ52YRDiDpDIfT8tWmk0NCr5sDpAwXXfZFDjXwan+Ji
9OKGKUz+s7/NT+VynaoitTEKMwLb1IhkGhmNvbwfxykcCl4cpKVybOrU7thJ
Co5++uuuJNHw9zGxqJmmkFytrb5EZTejTWMzMxQKGE1xwW80/gO1Z4Sk
             "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
          "AxesOrigin" -> {0.10000000816326553`, 0.8921731803925113}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>]]& )[<|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {0.10000000816326553`, 0.8921731803925113}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>],
     ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
      4.503599627370496*^15, -4.503599627370496*^15}}]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]], 
         Line[CompressedData["
1:eJwV0Hs0lHkAxnHExpRdSrtIrVZYS0n3FM+6xEmlJGrS1BbSlkPDtigKk5xq
GUqXSZQSY3dRWBm3qKbEuo1xG5pXNVrxzvsrOuS2dvaP53zP599nyeHQXYEa
ampq21X7v7zVeZUCgQiCunv2Te0Extnjw/eyRLAfWZhfonLRfA+rgjwROM9u
G6ar/GZ48OoTkQiu7AZZkMpOD21Ch7pFSHYVzVFXeWbZgyUOxuWIP2NpulJK
cNry0fm+m+UIFU8Z8CUE4cbinZa3KpC53H/j6mYCub6STL2sguJSzBH+C4I1
R2Ln9Ugeo+xN2OjYYwJpnm1dzUANfInC3biMwMPq/tyy6VoM/1Bob1RIsHZP
y+VVak9x06VynVMOQV9S3GJvw2cISPvK0e4WgWFqV6evtRibzopfS1MJnjv3
S+TWz+FW/kinKpHAbjqijeX8Auk6WZPe0QTzj9QsqNhch89uxaccuAS89IKE
Ha4v8TmgMH80kOBB93eTiXvr8VQg93FjE+x6vq3IdV8Dbtssb9DYrvqrYirk
PvdvfBzKb3QCwZ2YXexBXiPevkjjedgRaDKchGJeExJo2zKZGYF5ECk1FTRj
d2T2iXYDgoPuCxfoeLYg983SsMAvCC5Qca3eshas6thRsm2UwQSnIlsvoBVs
3ygu6x2DnOLmG3xFKz6+NZ2I6GDwUDeX3xcqQWDOeL65mMGYIzt35KMEq7xN
36WUMDjnK2+P5LbBixvDYu4xOBFmMbtlsg1PP/8ceTKVwfXALez30VKMpPzb
1HaWgQnHtkCq3Y6OxIarHsEMBuwHjFZebseyqpzxgr0MCDmd4zWvAyuMcwdm
uTHwyZOsccnogG6Q66L9dgxGN2i+G13cCZlPoHnRIgbyB9r5JpmdcFxf5qfH
YmBu0/Krwfdd+EsaqeB8UiL3TNihJmEX/C5UptRSSiS2d3ruW92NgeAhd82X
StydZcgRlnYjnv7D4lixEpqG1vFH18rwoc5FoshQQrxC/feJGhlea10TW59X
ota0aNjTuQfszRsv5ocqYbLAwvFkUw/m+NW70b5KVJPgO7p7e3HcK2m5g6MS
6VnJZke7ehHlsYnfZ6FEx57wvDT/V4g4EG5oq6vEtv6VO3n9r5B4zcC/9xMN
HbZYVxEgxylZyPGSXhrmrcZNXxM5+J7+GpZPaESbbi2cc4LCyIam8C/zaBxU
HIvdGkZhrv7G4gwhDWfhRa9Lv1Bo4F6nbVTWXlE/woqiMGFmun1rLo2r2LKe
FU/h/cgpceJ9GgUH3Gu10yjcKLp7ZSaLxutbLm1aZRT0278VDt6k8ewn/+zN
5RSM3CwtolQWLuWdTKikYGlnlTlb5ZA/n3yjVUshrmtR9FIBjYkKp/2a9RTW
6UoJ5zoNgx70a/RSSBqtKW2+QmMs82Cps5wC10sg5agsO3w2Mb6PAk/IpYcu
07gzWG2l0U9BR2jG0lZ52YRDiDpDIfT8tWmk0NCr5sDpAwXXfZFDjXwan+Ji
9OKGKUz+s7/NT+VynaoitTEKMwLb1IhkGhmNvbwfxykcCl4cpKVybOrU7thJ
Co5++uuuJNHw9zGxqJmmkFytrb5EZTejTWMzMxQKGE1xwW80/gO1Z4Sk
          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
       "AxesOrigin" -> {0.10000000816326553`, 0.8921731803925113}, 
       "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
       "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.10000000816326553`, 0.8921731803925113},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"F\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox["\"Shuttling Distance d (nm)\"", HoldForm], TraditionalForm], 
     None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->{398.25, Automatic},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.912240476873539*^9, 3.9122405010727367`*^9}, 
   3.9125060866342*^9, {3.9125064403815393`*^9, 3.912506488877015*^9}, 
   3.9125091788274345`*^9, {3.912509334042737*^9, 3.9125093374958115`*^9}, {
   3.912509407793459*^9, 3.9125094239145374`*^9}, {3.9125094867514105`*^9, 
   3.912509502718193*^9}, 3.912509612685178*^9, {3.9125096793835*^9, 
   3.912509684938563*^9}, {3.9125100789973545`*^9, 3.9125101037612877`*^9}, {
   3.9125102960309134`*^9, 3.91251034487484*^9}, 3.912510637980397*^9, {
   3.912659995040224*^9, 3.9126599998822355`*^9}, 3.912660115815051*^9, {
   3.9126602169420977`*^9, 3.9126602552803507`*^9}, {3.912660291352595*^9, 
   3.9126602962397747`*^9}, {3.9126748900802083`*^9, 3.912674967040304*^9}, 
   3.9127564575301175`*^9, {3.9127567031244836`*^9, 3.912756708607563*^9}, {
   3.912756771347145*^9, 3.912756779344982*^9}, {3.9127574721103454`*^9, 
   3.9127574937229576`*^9}, 3.912757535064291*^9},
 CellLabel->"Out[24]=",ExpressionUUID->"fbb94f54-792e-4c89-baff-d440ecb48f86"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"2", 
            RowBox[{"d", "/", "2.8"}]}], ")"}], "2"]}], "/", 
        RowBox[{"Log", "[", 
         RowBox[{"\[Chi]", "[", 
          RowBox[{
           FractionBox[
            SqrtBox["2"], "1.1"], ",", "0", ",", "0.05", ",", 
           RowBox[{"0.05", "*", 
            RowBox[{"d", "/", "2.8"}]}], ",", 
           RowBox[{"d", "/", "0.013"}], ",", 
           RowBox[{
            RowBox[{"d", "/", "0.013"}], "/", "n"}]}], "]"}], "]"}]}], "]"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "4"}], "}"}]}], "]"}], "//", "Evaluate"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "0.01", ",", "0.5"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"PlotLegends", "->", "Automatic"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Frame", "->", "True"}], ",", 
   RowBox[{"FrameLabel", "->", 
    RowBox[{"{", 
     RowBox[{
     "\"\<Shuttling Distance d (um)\>\"", ",", 
      "\"\<Fitting \!\(\*SuperscriptBox[SubscriptBox[\(T\), \(2\)], \
\(*\)]\)\>\""}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.912509856439701*^9, 3.9125099843794456`*^9}, 
   3.912510123283248*^9, {3.9125103056148734`*^9, 3.9125103469507985`*^9}, {
   3.9125105943833447`*^9, 3.912510647608246*^9}, {3.912660123503008*^9, 
   3.9126601686889334`*^9}, {3.912660262828615*^9, 3.9126602769427605`*^9}, {
   3.9126603184302816`*^9, 3.912660387603594*^9}, {3.912660443100497*^9, 
   3.912660449941486*^9}, {3.912660487019426*^9, 3.9126605675522966`*^9}, {
   3.9126749740551715`*^9, 3.912674984661742*^9}, {3.912756472586941*^9, 
   3.9127565251227303`*^9}, {3.912756786554139*^9, 3.9127568074212265`*^9}, {
   3.912758009767456*^9, 3.9127580296413083`*^9}, {3.912758119369923*^9, 
   3.912758129779572*^9}, {3.9132744599668036`*^9, 3.9132744601670885`*^9}, {
   3.913274953044479*^9, 3.9132749533834605`*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"bade904b-2709-448f-b62e-3215d76812f6"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[
    InterpretationBox[{
      TagBox[{{{}, {}, 
         TagBox[{
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[2], 
           Opacity[1.], 
           LineBox[CompressedData["
1:eJwV1Wk4VWsfBnBDiso5DcZSCleD0JEhVO5CKURpUCrRJDIWCqE6hraEjNss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            "]]}, Annotation[#, "Charting`Private`Tag#1"]& ], 
         TagBox[{
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[2], 
           Opacity[1.], 
           LineBox[CompressedData["
1:eJwV13k0VW8XB3BKJZVGoZTQoElJafY1FUlIAz9NKjQQKqUIqSjUjUKIMtzB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            "]]}, Annotation[#, "Charting`Private`Tag#2"]& ], 
         TagBox[{
           RGBColor[0.560181, 0.691569, 0.194885], 
           AbsoluteThickness[2], 
           Opacity[1.], 
           LineBox[CompressedData["
1:eJwV1nk4VesXB3Bjt1SapSihAblKJCq+NHFRJKUbDYo0oIgGpPplrlDmeTrH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            "]]}, Annotation[#, "Charting`Private`Tag#3"]& ], 
         TagBox[{
           RGBColor[0.922526, 0.385626, 0.209179], 
           AbsoluteThickness[2], 
           Opacity[1.], 
           LineBox[CompressedData["
1:eJwV13k4VV0bBnBjqaQUkZRQ5vQqc3EnfIRMDTSSaJAhTRqlt0yZKhkiZBYO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            "]]}, Annotation[#, "Charting`Private`Tag#4"]& ]}, {}}, {
       "WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
      DynamicBox[
       (Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
            Annotation[{
              Directive[
               Opacity[1.], 
               RGBColor[0.368417, 0.506779, 0.709798], 
               AbsoluteThickness[2]], 
              Line[CompressedData["
1:eJwV1Wk4VWsfBnBDiso5DcZSCleD0JEhVO5CKURpUCrRJDIWCqE6hraEjNss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               "]]}, "Charting`Private`Tag#1"], 
            Annotation[{
              Directive[
               Opacity[1.], 
               RGBColor[0.880722, 0.611041, 0.142051], 
               AbsoluteThickness[2]], 
              Line[CompressedData["
1:eJwV13k0VW8XB3BKJZVGoZTQoElJafY1FUlIAz9NKjQQKqUIqSjUjUKIMtzB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               "]]}, "Charting`Private`Tag#2"], 
            Annotation[{
              Directive[
               Opacity[1.], 
               RGBColor[0.560181, 0.691569, 0.194885], 
               AbsoluteThickness[2]], 
              Line[CompressedData["
1:eJwV1nk4VesXB3Bjt1SapSihAblKJCq+NHFRJKUbDYo0oIgGpPplrlDmeTrH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               "]]}, "Charting`Private`Tag#3"], 
            Annotation[{
              Directive[
               Opacity[1.], 
               RGBColor[0.922526, 0.385626, 0.209179], 
               AbsoluteThickness[2]], 
              Line[CompressedData["
1:eJwV13k4VV0bBnBjqaQUkZRQ5vQqc3EnfIRMDTSSaJAhTRqlt0yZKhkiZBYO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               "]]}, "Charting`Private`Tag#4"]}}, {}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}},
             "AxesOrigin" -> {0, 0.9129449987924138}, 
            "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
            "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               RGBColor[0.922526, 0.385626, 0.209179], 
               AbsoluteThickness[2]], 
              Directive[
               Opacity[1.], 
               RGBColor[0.560181, 0.691569, 0.194885], 
               AbsoluteThickness[2]], 
              Directive[
               Opacity[1.], 
               RGBColor[0.880722, 0.611041, 0.142051], 
               AbsoluteThickness[2]], 
              Directive[
               Opacity[1.], 
               RGBColor[0.368417, 0.506779, 0.709798], 
               AbsoluteThickness[2]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            Plot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {0, 0.9129449987924138}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              RGBColor[0.922526, 0.385626, 0.209179], 
              AbsoluteThickness[2]], 
             Directive[
              Opacity[1.], 
              RGBColor[0.560181, 0.691569, 0.194885], 
              AbsoluteThickness[2]], 
             Directive[
              Opacity[1.], 
              RGBColor[0.880722, 0.611041, 0.142051], 
              AbsoluteThickness[2]], 
             Directive[
              Opacity[1.], 
              RGBColor[0.368417, 0.506779, 0.709798], 
              AbsoluteThickness[2]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>], 
       ImageSizeCache -> {{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]}, 
     Annotation[{{{{}, {}, 
         Annotation[{
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]], 
           Line[CompressedData["
1:eJwV1Wk4VWsfBnBDiso5DcZSCleD0JEhVO5CKURpUCrRJDIWCqE6hraEjNss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            "]]}, "Charting`Private`Tag#1"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            RGBColor[0.880722, 0.611041, 0.142051], 
            AbsoluteThickness[2]], 
           Line[CompressedData["
1:eJwV13k0VW8XB3BKJZVGoZTQoElJafY1FUlIAz9NKjQQKqUIqSjUjUKIMtzB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            "]]}, "Charting`Private`Tag#2"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            RGBColor[0.560181, 0.691569, 0.194885], 
            AbsoluteThickness[2]], 
           Line[CompressedData["
1:eJwV1nk4VesXB3Bjt1SapSihAblKJCq+NHFRJKUbDYo0oIgGpPplrlDmeTrH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            "]]}, "Charting`Private`Tag#3"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            RGBColor[0.922526, 0.385626, 0.209179], 
            AbsoluteThickness[2]], 
           Line[CompressedData["
1:eJwV13k4VV0bBnBjqaQUkZRQ5vQqc3EnfIRMDTSSaJAhTRqlt0yZKhkiZBYO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            "]]}, "Charting`Private`Tag#4"]}}, {}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {0, 0.9129449987924138}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            RGBColor[0.922526, 0.385626, 0.209179], 
            AbsoluteThickness[2]], 
           Directive[
            Opacity[1.], 
            RGBColor[0.560181, 0.691569, 0.194885], 
            AbsoluteThickness[2]], 
           Directive[
            Opacity[1.], 
            RGBColor[0.880722, 0.611041, 0.142051], 
            AbsoluteThickness[2]], 
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], 
    AspectRatio -> NCache[GoldenRatio^(-1), 0.6180339887498948], 
    Axes -> {True, True}, AxesLabel -> {None, None}, 
    AxesOrigin -> {0, 0.9129449987924138}, DisplayFunction -> Identity, 
    Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
       FormBox[
        TagBox[
        "\"Fitting \\!\\(\\*SuperscriptBox[SubscriptBox[\\(T\\), \\(2\\)], \
\\(*\\)]\\)\"", HoldForm], TraditionalForm], None}, {
       FormBox[
        TagBox["\"Shuttling Distance d (um)\"", HoldForm], TraditionalForm], 
       None}}, FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}},
     GridLines -> {None, None}, GridLinesStyle -> Directive[
      GrayLevel[0.5, 0.4]], ImagePadding -> All, 
    Method -> {
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}}, PlotRange -> {All, All}, PlotRangeClipping -> 
    True, PlotRangePadding -> {{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}}, Ticks -> {Automatic, Automatic}], 
   FormBox[
    FormBox[
     TemplateBox[{
       TagBox[
        FrameBox[
         StyleBox["1", Smaller, StripOnInput -> False]], "Placeholder"], 
       TagBox[
        FrameBox[
         StyleBox["2", Smaller, StripOnInput -> False]], "Placeholder"], 
       TagBox[
        FrameBox[
         StyleBox["3", Smaller, StripOnInput -> False]], "Placeholder"], 
       TagBox[
        FrameBox[
         StyleBox["4", Smaller, StripOnInput -> False]], "Placeholder"]}, 
      "LineLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #4}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.922526, 0.385626, 0.209179]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               TagBox[#, HoldForm], ",", 
               TagBox[#2, HoldForm], ",", 
               TagBox[#3, HoldForm], ",", 
               TagBox[#4, HoldForm]}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.9125099015302267`*^9, {3.912509934293622*^9, 3.912509985116108*^9}, 
   3.912510124245969*^9, {3.9125103070961075`*^9, 3.912510347246186*^9}, {
   3.912510595200388*^9, 3.9125106478973036`*^9}, {3.9126601193570433`*^9, 
   3.9126601559076624`*^9}, 3.912660277431285*^9, {3.9126603229215574`*^9, 
   3.912660388333664*^9}, {3.912660446923273*^9, 3.9126604529523144`*^9}, {
   3.9126605233472643`*^9, 3.9126605681973066`*^9}, {3.9126749750656595`*^9, 
   3.912674985835315*^9}, {3.9127564602981167`*^9, 3.9127565259560747`*^9}, {
   3.912756788460722*^9, 3.912756807891276*^9}, {3.912758014083749*^9, 
   3.9127580301741695`*^9}, {3.912758120141775*^9, 3.912758130582637*^9}, {
   3.9132744578461533`*^9, 3.913274460906178*^9}, 3.913274957227135*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"f29b37b8-847b-44df-b1cb-a028f72848ef"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"2", 
            RowBox[{"d", "/", "2.8"}]}], ")"}], "2"]}], "/", 
        RowBox[{"Log", "[", 
         RowBox[{"\[Chi]", "[", 
          RowBox[{
           FractionBox[
            SqrtBox["2"], "1.1"], ",", "0", ",", "\[Kappa]", ",", 
           RowBox[{"\[Kappa]", "*", 
            RowBox[{"d", "/", "2.8"}]}], ",", 
           RowBox[{"d", "/", "0.013"}], ",", 
           RowBox[{
            RowBox[{"d", "/", "0.013"}], "/", "4"}]}], "]"}], "]"}]}], "]"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"\[Kappa]", ",", "0.01", ",", "0.5", ",", "0.1"}], "}"}]}], 
     "]"}], "//", "Evaluate"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "0.1", ",", "0.5"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"PlotLegends", "->", "Automatic"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Frame", "->", "True"}], ",", 
   RowBox[{"FrameLabel", "->", 
    RowBox[{"{", 
     RowBox[{
     "\"\<Shuttling Distance d (um)\>\"", ",", 
      "\"\<Fitting \!\(\*SuperscriptBox[SubscriptBox[\(T\), \(2\)], \
\(*\)]\)\>\""}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.912509856439701*^9, 3.9125099843794456`*^9}, 
   3.912510123283248*^9, {3.9125103056148734`*^9, 3.9125103469507985`*^9}, {
   3.9125105943833447`*^9, 3.912510647608246*^9}, {3.912660123503008*^9, 
   3.9126601686889334`*^9}, {3.912660262828615*^9, 3.9126602769427605`*^9}, {
   3.9126603184302816`*^9, 3.912660387603594*^9}, {3.912660443100497*^9, 
   3.912660449941486*^9}, {3.912660487019426*^9, 3.9126605675522966`*^9}, {
   3.9126749740551715`*^9, 3.912674984661742*^9}, {3.912756472586941*^9, 
   3.9127565251227303`*^9}, {3.912756786554139*^9, 3.9127568074212265`*^9}, {
   3.912758009767456*^9, 3.912758110799849*^9}, {3.913274970673935*^9, 
   3.913274976610937*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"85aaeab0-63e6-49de-8918-9253eaca3d2a"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[
    InterpretationBox[{
      TagBox[{{{}, {}, 
         TagBox[{
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[2], 
           Opacity[1.], 
           LineBox[CompressedData["
1:eJwV0H081HcAB/BLbBSvlchDEoVLtMTxqrZ8Ij2I6lAhuxDKq5WHmpoiD0em
TeZeWRFSKWQZWuahLiwVIk447txXW9dKy31/spSH2W9/fF6f1/vPz8d8f6R3
mBqHw9nO5v8W8krv5uTU4lZoRWuXJYVx0cfRa1dqwYv6RPQv66oF26zLS2uR
/UYSbGNF8cfocHZTbS2if6owTmXtUmkb+aa/FrKtPW/XcClmVlaYrzeuwxHB
COfqcopT3N/ODOXW4UyPs0msDcUx42Y+N68eDmd9Wx1XUyjmv1VNtdyDblNP
pXg9heOBRF2Z5D4KLeMDA9wpnpWuetzwqgEx+SVBCbsotllf166ZbsTeluPE
IYjCybdT5MD5HaEDf+pUH6IYykgy9TF8gK3bFlbnxVAYZkn79tg0w85+VN6R
QPHQVSlR2DxEU3qmhuI7itXTJ7rnuD5CXXSYh6OIYsGBBv36TY9R+YH4x+dS
CC+Vp+50awHXhpfndJWion/pZJpfK44o84dtblJ4P/SsctvbBvmUbeaaSvav
+qmI69FPcPHOy6jYGorCeG//YWE7PGvUrq29T6E+Iki9LezAOG+40bGZwvKg
qtos5ymWmWdLg9soArcs0tfa0Qk3ftuP8k6KdJLU5TPQCVPpnfbkXooJQX3R
vNAuZJXFNT6WUdy4/fRi5osuBIjSUmOHKCp1ijOHIiUwItqRPkqKcWf/4neM
BItrvHRuvKZI2aPo+Ta6G+Il5t6/vqWIOmr1aedkNwoeiXJeMxQXwtz9X8c9
QzaX/0PZPxQmglXlzzR74NbvXJn1keLVuldG9qIeHLOu3fXFNIVKdeqGl24v
xg75+yVzGOwulThuzO+FMmmk4s1sBu/Xqr98b9oHXt268xOfMFBUaN4yKeiD
OHQwdFCLgaVt53G95VK42T6/N6TNoPj00eCOEinS6xeczP6MQVpP3469vH5I
MzTLwnUZXJ1tKCip7scJ4aKN7/QYqBvaJIc7DUDN3YIbYMCg2W7WzYmGAcxv
OfiSGDFoNKsa3eEqw8yAUmFhwsBE38o5pkOGfWLueIopA7HqcKGOnxxmmzP2
NJsxuHTl3LJwqRwqxuBU+1IGvb7HSs+HDMJwcMxTZcHAU2nPFyoHUbA1s0Bu
xUDLv1nnRagCD74Or65czu7pMu5YqFJANvep+eUVDOLMPH6ZG0Xwwa2mSGDL
IPDFoUSPowQLecP8MNauJWe9vv+GQGS3eOowa0271ndzYgkCzqXsjGOdDfc1
c5IJ4g4ED+eyLt+3pVHzPMHl3ATax/p53sZujRoC/ocyeK1k8CAopGhTHYGa
cPsTP9YlFsKY1LsEvtz3vkGsI35uMtBoJKjODzgcyXqi3uUr9VaCKOZ0egZr
PRmUanIC4yU+2S2sxwsCq10VBPM3H9ftYj2wPyEteYjgyMlr56SsC4fF1mpK
gtGzi1L+Yr1yYn3ErBGCNpf0EI3PGcwTC+BCCQ4acPq1WY8lxc9LGiWIkCRt
12Ndp3WvijNO4MQvdljGOr9dLtzwkeDvSI/rK1gnZk3tSpwkmGyb1LdnHbLb
xKphmuCCqCZ1LevNRl+Oz8wQYHfS2AbW/wGIk3f1
            "]]}, Annotation[#, "Charting`Private`Tag#1"]& ], 
         TagBox[{
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[2], 
           Opacity[1.], 
           LineBox[CompressedData["
1:eJwV0Hs01HkABXBZzhpL20s7ebTkkQnLpqyE29BUYhVKVJM8a/eEZHsd2YZJ
TttR6LVWiSjstpT2KEaiMZLCGO/X/GSNk9m2+f6Q92N/+8c993z+vNckJNo3
XF1NTe17Jv+3cENhRUZGGWLVbo4nryPQz5sayc0pA+2dvaeUccnynZyiwjIc
HOeKBhkPjChvvCwrw+TDlhyuFQH3sXX0P11lkEqmpTOMF2wembjol6P/vldW
jA1B3NqnF/t/K4fMrNghxI4gVl+ye+1tEUwlRxd8HAjkS/9Vzb5+DsFCw+ad
7gQbIwTLemQvMDUzH7lrF0FroW1d1fsq/FBcEti9n2An577Os7lqBB/SUc5H
EDjsk6bbq4mBxTwtZQxBf0rCaj92DYKuzVe4xROw0zo7/K0kMNILNlckE9S6
KWRyq1p4c+Jd+GkE386dbtF2e4Vi1pjQIpNgeUSVnohXh5otWTZduQTCzKKk
XVtfI0cVxp75g+BR15qZ5IB6JL0a1Q/5i8C31qtk6/43cBpaOdkpYv4SzUbd
j3kLus7cKEVMkB3vG6gUNsDjWeu1ynoCjY/8pCfCRjh3nT1m1kxgfkRVapzR
hE18BU/cQRC03UCP5S1F9IKfbWEfwSUqodmvW4rUCykPxH8TTPNFeUvCmqEl
tXsdN0zw4EnTr1cHmzGa1mJy6yPBY938q/3RMgz4ZBUMjhJMuAbmj9IyrH0x
zMudJLjgL287E9OCubObTxnMERw/YfG5dKYF94x6HosX0bgV7hE4fK4VUWuc
PhFNGoZ826JWrTaEz3+I9dSm8d7p/ar16W2weuF/4MhiGipV3AOfZe1IcrSe
YS+jsbdQttH9TjsGPvhNfdKjMb5JY2h8dQfGlsZ1Hl9FQ/5I60/DrA4kWppc
fm5Iw9xaemqFZSdqktua7I1p5P98IrixoBOpfPs3fqY0kts6vPdv6MI3XtG8
TAsa9z5j8wtKu3CqovdMOoeGBtsq8ahDN4pdbHvDrGlI7Bb9Pl3VDcU7jjnf
lka1ccmIt1sPuCmRE7rrmT16Fq4nG3vQb+A+NrCBRqXqWLZuQC9Svj5tcPM7
Gpk5V0yPdvYi+LylP8uJRvu+2MLroX1Y17HD464zDS/F+t1CRR9M9uSzplxp
sAIluoNhcoQeaIxx5DJ7mvUbV6rkiCBKxwx3GueMPYu/OE6hQVAXKubRCBr8
UeB5goJQrZS8ZexW8IvP5Z8o9NjknWtnrGVXP6p9lgInQJg2zPgGPBy1Eynk
nPQt/nIbjaJD26u1rlOwkwSJDjB+d9u9RfMZhXDZtZWjjGsOh+bxyil4KiaE
s4wLzIQnkyoo1FMhRHM7jaiHL7/SrKZwd5t3LZvxtIh7UKOego6zIMKV8Yoe
KNR7KQQcjjtzifFEVlCpm5zC09yw9nTG3SHnkxP7KUS27bO/zThbWclRV1Cw
lBxUFjG2mXaJWvSRQpPRkFcr4yWVfHAJhRp9s9w+xmMJ8UsSRpg/LkRODjEu
Zz0vUZugkBphmj3F+E5Dr3DLFAVd19QR9R00BGmzewQzFPq2sLbqMA7da2hR
NUeh6t6V63qMt61ynlhYoCBONR5czfg/jON/Jg==
            "]]}, Annotation[#, "Charting`Private`Tag#2"]& ], 
         TagBox[{
           RGBColor[0.560181, 0.691569, 0.194885], 
           AbsoluteThickness[2], 
           Opacity[1.], 
           LineBox[CompressedData["
1:eJwV0ntUjHkcBvBUjorOJiS5X5p0YsdlsrJbj6ZomTa6GYORFItFVMhRNE1x
IuvakqQkmrGVZMU0GRNqizXdzDTd5k2alaF634p00/72j+95zufP5znf2dvD
/HYYGxkZ/ULu/xRzpMUpKTKEas++dWXTsMvq7751UwZlyFLNPuKCCWsd86Qy
5M6Jrk0jbu02JD+TyZDdc+L9MLH7/QVhH+tlqDo2JVyxiMbIwvzZrnZFEDSL
vq5cQuOYw6OTLdeKwM9PH8tzphFhV7re4bocLic3Gvb9SEM3vqNrqOIJ0lau
OKj+mYbzzljrxpqnmL77w3SPQBpvpOxyZbsS8/2+feAE01jreHvc4+EStJ9P
jq3YR2MZv+riUqPnuCrWiKcfpdFyVjTD3/YFdq21d2mPp2F7QVu3wakUjVEz
6wbO0Sjj6mt0TmWoGQmqbUyhsXj4SK0F92+cvzRiOTmLxoSdyknyVeU43mHi
xcmlIU7NS1jnWQFBUoxK8ZBGfv2cwVMbXyL5Di/qioKGX5l3geemV3DUVoui
yshe8qH9tw/+g44YbVO6ikZGjJ/AIH4NSan6NFdDw7RTmPBArIL3DLmVdTMN
+1+7CmelVEIwxEmf20YjyGvqJHOfKnyK+JwTaaCRSImq/RuqkBC0bb0JQ2NA
KM+yCq0Gp7b10sI+GnceVF4911aNzOe9EQ+GaNy3zD7XElaDjrz0xEhjBn1u
guwepgaRJiG26WMYxG/QqaMO1uIsq5olGsfgQDhrTNVgLdj8Pq/r4xlc2bFG
8CH6DQZPsFUcGwbThOy8N2Zq+DxJvmIylUH7ivYpSy6q4fh49F8XZjLo6jp2
x9dag2iFRWvuXAaB0hpnjzQNsozDD39zYPDFxfTfLzPq0Do0xkPvxECXb5Y7
7UYdMr6GV6SyGdgvqDo8cb4Wzyw9DfFLGWQfDw9WSbTwpFg2Vj8wOKWu89nE
qYfzzeyKVysYZJrYCiWF9bgXujWR7cbA1NYpbteyBkyebyvc686gdNGouwPK
BpxMjZ+p9WRQMqug24fbiMwCt+JeL9JnEsvtkKoRacLOJDceA0XX3gzLjU3w
+Lj9t1AfBqk3f5+7S9uE3QHSHK4vAw0/Qno5pBnvrc3zvQMYeOuXrBfrm6Ee
5VBpzWdgLii1bAvVYWtS+ZFiAelTbaey6dIh+qp34vktDKJn8e6NPUAh3kfD
YwUxCGrbE8sLp3BozjLZYmKu5LTvmUgKlfV/2LsSmy162WNxlEJm8eZBf+Jk
rFluEUfhqfrrNRFx3lavErPLFJI8cu42Eb+97lE7+jGFA1UBlhe3MXixLSRr
VRGFMGbx5jRiyTzxoYRiCu8W2EgkxPtznk0eXUIh7lGv21PiAbn7FtOXFJRh
3wV/Ip7YCL1xE4Xefv3h1cHkf24EFXJ1FOqSeQ99iRu2nzgV10LBMVDevYU4
w6BwNNZTODos2xNBvHDAdf+oTgoWy13WZRBbKYRwpyl0fv854U/iXlGMlaib
Qmp5sbyQuMj8SYFRH4Vvt8LmvSZOe90kXtlPYfyqzXwtceyFoYDYQQpSL//E
d8QhgdNYymEKfo38ok7i1VN+6hsZodDD3m3oJ/4Pj4eBig==
            "]]}, Annotation[#, "Charting`Private`Tag#3"]& ], 
         TagBox[{
           RGBColor[0.922526, 0.385626, 0.209179], 
           AbsoluteThickness[2], 
           Opacity[1.], 
           LineBox[CompressedData["
1:eJwV0ns01GkcBnCFQmsXUZpsm92lpGKFtSoPU9huVipiQ7nXdpBbSZdhitWF
rusSndFOmqlN0YYZ1Gjpom1yZwzz02X2SG3ze2nZSPbdP97zns/5fv94nve8
lmFxfpFTtbS0NtDz/813FNcWFEjwKtXk+PAyFhzh+6FfSyTYFbZ0lpUji4qZ
a23KxBIIE96L/amfDw2evyeRQJ5r9VpC7VG+OO61QgLP0uJmnhOLySU3LVdy
pBCIhz81+pZF2oKqzP5CKTzmpRQuc2WRyGn0XVBUg3Uhscey3VmojP/WfHhU
B76x/cbtPiycongmyta7qOozj3X+kUW72O6hbEAG7d6lRrnRLNbaXP6keqIe
7S7xJWeTWDgHNJ9ZpvUHPCyFh3x5LPpPps/bZN4AnUUrFp48wcL8dHeXv20j
5PJkzWf5LO5z1a0q2/uQ6lo0BF5i8c3E3jYD7gNEVw+qp11nMTNKZlbj+RAc
139KcipZ8C+UHf1h9SO8HlFI0u+yuKn4cjxraxP2O4ZMPH7Iwu/++orVQY9h
fDvJenYLfa+aD7GX9/yJ0PEAcbmCheCgX+Ag/wkUc37hNT5jofM2+Ogtvhyb
0xJKPw6wsIrWVM4veIrNbKgyg2UR6j3XTN+nGSFOlybdRllkM+ktm3qakV5k
KvP4yGIsuEZoFNECP5vtZiodgtJbT/NzX7Yg540gVm5AUG54Jbc/rhWpTZna
2sYEo26BV4ZJKzTC0aSCWQRH/FUd+/a0IXJap596LkF8gvX05vE2aH0etSbR
kiAvck3gqwPtmHSA9l5rAotgu7J2vQ7MdimdJrUlGHAdmONwpgPZvRneUnsC
jSatdKNJJ+o0M965OxFsEbc6rSruhO61w4a6rgQj3+n8NTKvC3yz1VUBbgSq
m3rXLS52wfrFlin7uARWi5tTTBd2Q5l26k2bF8GVQwk75KJuLHT3cGlaS5DV
0eUT5KiAPPCGyZgPwSVt82BRpQK3X2zd0ORHoGNumxHj3INPDbx5e/wJGu2n
XB2T9WCT0yqxbxBB/fyKIR+uEvo5RR+7g2kfM2u3ZLkS2tKzuXk7CO5odgsM
t/YiOq/V2D6S4EJJzlcx3b1I3rnBOzWGoDMgUXwuvA9GkHmN/kSwXu3gy1f3
gbvoRLlNHIF+YKPhywgVRkR1WSsTaJ8WjnyWRgW7hOfyI8kEB+avuzEjnoGy
aK9Z5j6C0Je7eOsSGPybR8LOUnNFxzYeT2IQKtp9Q0CtZ980bJDKILE1yrOG
+jzWuBhkMAh4Eh/JUpeFeNfrnWOwnDs9JSiV4FnRqjbdagbC/MKeJfsJGraH
Cz2lDPS08/WWU4u+5icfrWWQXV3k9D117G/3ZuvWM/j9Qe2JMOqxGo9tOk0M
XjzeZpdHbaqEemovnQ96eWml0f9zMbSSq6L5mp9GGFL3hB3OyuhnUKQXnsGh
FgzesZmqpnkcxFJH6iVjK2OnvGUgEEm+2EltdCcYHiyD5xGFzinU79IPGqUP
MeAMZ67nU0v16yq0Rhk4eh5JLqYuftLLd3/PwD/m/M9XqXmnP2zmjdN9i1uF
VdThWyysZRMM5p7qu9ZA7TVnxejkJM0/bFrbQv0fdqdzOw==
            "]]}, Annotation[#, "Charting`Private`Tag#4"]& ], 
         TagBox[{
           RGBColor[0.528488, 0.470624, 0.701351], 
           AbsoluteThickness[2], 
           Opacity[1.], 
           LineBox[CompressedData["
1:eJwV0n881HccB/DLrnX6sUysS4a2TnnoF4uV4jUnXT/MxPqhuoiK1UJh1vQD
dzprjyShzI+phGtmUsm5Ei26VPLr/O6+MteuE/f9nHILZd/98X68Hs8/X6/H
e15QuO9eIxaL9TVz/6doufR2ZqYM6TfP6YtW0LDIf6u/fFGGsAyWWQ/jslkb
7EqkMhjEC91mrqTRp9em35PJsJPjWBzN2P3aovCBThm8UvQDfBcaE4tL57la
VOKSlPNctYpG7IJbJ3t/rcTJlDN9c0Ej0qLWZ0G2HE6rhlX5njRUHw/qxh/e
Qa71gy6tHw2nfXGm3c13UaoIF9rtptEqXaqo1lSD5ThQrzlIY4PdlekV72qw
d8noBmEsDeetjalfsP5CxGDVSIKERu/peCs/7n24LzZIHNJocM92tG+xr8Us
ftmB+Xk06vjqZpV9HQTFGdPbr9JweBfTMpX/AEOmVpyRmzRm7as2l3sqEGm3
w0Vzl4YoqyTxmzUPoY3pVno8pFHa+dmYZFs9fvv7Vf5EMw3fOq+yNdsfgXfF
uvdGN7OXfDzsyqHHCFVMOXqvn0beMV9/regJPDOvHRQM0mAPCROvixpgLIji
aV/T4IXoym0yn0Ju4Ud6x2kECOaaG3s3Qh0d+CmHTfAzFd/k19WICG6B9vg0
glGhPN9kTxNSTJPdT5sSFFx/euFMfxPcC6RsDZfg2ozCM73hzfC9oZmSYk1g
cPMvHCbNENiyvVJ5BOItKuWPh1pw50nwS4E9QcRh2ymNYy0QWzdeXudAcH7v
ev+XR1sREFMYd8uZwFK4tKSVo8StC3d/D1tNoHHRzHFMVWKS6v77XncCnS62
YJNpGwJPJ3Kb1xJsljY7eeS04R/e28vGXgQjK9kvRqzaoTB7xlX4EKhKOX9Y
5rYjKSPXzHczAW9R4w9mCztgVB1TbrOdoPD44d0NRR0YmeM8M2EXgUTZ7r19
eSdo9uAYL5jg0gdcYVF5Jyq63+QEhRCwufYJoc5dUOpyLKMOENQum3R1tLoL
JxpuZtSFE9TYlOm9+d3I2umfUhnJ9DG3dYtu6AZkXz4ajCGo0n2fN2NbDwYU
Q13/xhJkXUz+PLSjB53qI7riEwRtWyOlacHP4KGuaMkVEXipHX1E6me4vmZe
lKuEwNi/dkb/HhW+Wzq0W36K6dNk0fCJTgWJWFwXnUxw1Gbjn9MiKAy7rPqp
7yxBQP/+uI2HKRxbF1pIGPOLTm36JYrCsoyMFlYqAWdZ/fDUIxRa5YaF1ozT
sX7F1AQKjqVND3YwLtklqOGkUQgyN2lrZfw826NlcgWFjCFT57pzBPcDg/M9
KylE3FB4KBkXzRdFJ96m8GIo0aefcVjxvdmTayh8KJ4dYpTG/JPcfSe7nkKm
ODvJjbFZN9RGPRTguy2nnLEhN6Ccr6LwmJedVcu4K+iEJKGXwkSU9kIr4zxt
lZ2RmkLo2sIUPePFo65hk4Yo+A8XRC1JJzCpEsKdphDV53HAlfHr+GMm8XoK
To9fBXoxrjS+U8YyUJjrHbx+P+OcJz2ir95SOO7psPoI47iz49/GjVGoejNt
SRLj4M2WttXvKIQkD1udZ7x2zmrDxASF926ajwoY/wdUx4c/
            "]]}, Annotation[#, "Charting`Private`Tag#5"]& ]}, {}}, {
       "WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
      DynamicBox[
       (Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
            Annotation[{
              Directive[
               Opacity[1.], 
               RGBColor[0.368417, 0.506779, 0.709798], 
               AbsoluteThickness[2]], 
              Line[CompressedData["
1:eJwV0H081HcAB/BLbBSvlchDEoVLtMTxqrZ8Ij2I6lAhuxDKq5WHmpoiD0em
TeZeWRFSKWQZWuahLiwVIk447txXW9dKy31/spSH2W9/fF6f1/vPz8d8f6R3
mBqHw9nO5v8W8krv5uTU4lZoRWuXJYVx0cfRa1dqwYv6RPQv66oF26zLS2uR
/UYSbGNF8cfocHZTbS2if6owTmXtUmkb+aa/FrKtPW/XcClmVlaYrzeuwxHB
COfqcopT3N/ODOXW4UyPs0msDcUx42Y+N68eDmd9Wx1XUyjmv1VNtdyDblNP
pXg9heOBRF2Z5D4KLeMDA9wpnpWuetzwqgEx+SVBCbsotllf166ZbsTeluPE
IYjCybdT5MD5HaEDf+pUH6IYykgy9TF8gK3bFlbnxVAYZkn79tg0w85+VN6R
QPHQVSlR2DxEU3qmhuI7itXTJ7rnuD5CXXSYh6OIYsGBBv36TY9R+YH4x+dS
CC+Vp+50awHXhpfndJWion/pZJpfK44o84dtblJ4P/SsctvbBvmUbeaaSvav
+qmI69FPcPHOy6jYGorCeG//YWE7PGvUrq29T6E+Iki9LezAOG+40bGZwvKg
qtos5ymWmWdLg9soArcs0tfa0Qk3ftuP8k6KdJLU5TPQCVPpnfbkXooJQX3R
vNAuZJXFNT6WUdy4/fRi5osuBIjSUmOHKCp1ijOHIiUwItqRPkqKcWf/4neM
BItrvHRuvKZI2aPo+Ta6G+Il5t6/vqWIOmr1aedkNwoeiXJeMxQXwtz9X8c9
QzaX/0PZPxQmglXlzzR74NbvXJn1keLVuldG9qIeHLOu3fXFNIVKdeqGl24v
xg75+yVzGOwulThuzO+FMmmk4s1sBu/Xqr98b9oHXt268xOfMFBUaN4yKeiD
OHQwdFCLgaVt53G95VK42T6/N6TNoPj00eCOEinS6xeczP6MQVpP3469vH5I
MzTLwnUZXJ1tKCip7scJ4aKN7/QYqBvaJIc7DUDN3YIbYMCg2W7WzYmGAcxv
OfiSGDFoNKsa3eEqw8yAUmFhwsBE38o5pkOGfWLueIopA7HqcKGOnxxmmzP2
NJsxuHTl3LJwqRwqxuBU+1IGvb7HSs+HDMJwcMxTZcHAU2nPFyoHUbA1s0Bu
xUDLv1nnRagCD74Or65czu7pMu5YqFJANvep+eUVDOLMPH6ZG0Xwwa2mSGDL
IPDFoUSPowQLecP8MNauJWe9vv+GQGS3eOowa0271ndzYgkCzqXsjGOdDfc1
c5IJ4g4ED+eyLt+3pVHzPMHl3ATax/p53sZujRoC/ocyeK1k8CAopGhTHYGa
cPsTP9YlFsKY1LsEvtz3vkGsI35uMtBoJKjODzgcyXqi3uUr9VaCKOZ0egZr
PRmUanIC4yU+2S2sxwsCq10VBPM3H9ftYj2wPyEteYjgyMlr56SsC4fF1mpK
gtGzi1L+Yr1yYn3ErBGCNpf0EI3PGcwTC+BCCQ4acPq1WY8lxc9LGiWIkCRt
12Ndp3WvijNO4MQvdljGOr9dLtzwkeDvSI/rK1gnZk3tSpwkmGyb1LdnHbLb
xKphmuCCqCZ1LevNRl+Oz8wQYHfS2AbW/wGIk3f1
               "]]}, "Charting`Private`Tag#1"], 
            Annotation[{
              Directive[
               Opacity[1.], 
               RGBColor[0.880722, 0.611041, 0.142051], 
               AbsoluteThickness[2]], 
              Line[CompressedData["
1:eJwV0Hs01HkABXBZzhpL20s7ebTkkQnLpqyE29BUYhVKVJM8a/eEZHsd2YZJ
TttR6LVWiSjstpT2KEaiMZLCGO/X/GSNk9m2+f6Q92N/+8c993z+vNckJNo3
XF1NTe17Jv+3cENhRUZGGWLVbo4nryPQz5sayc0pA+2dvaeUccnynZyiwjIc
HOeKBhkPjChvvCwrw+TDlhyuFQH3sXX0P11lkEqmpTOMF2wembjol6P/vldW
jA1B3NqnF/t/K4fMrNghxI4gVl+ye+1tEUwlRxd8HAjkS/9Vzb5+DsFCw+ad
7gQbIwTLemQvMDUzH7lrF0FroW1d1fsq/FBcEti9n2An577Os7lqBB/SUc5H
EDjsk6bbq4mBxTwtZQxBf0rCaj92DYKuzVe4xROw0zo7/K0kMNILNlckE9S6
KWRyq1p4c+Jd+GkE386dbtF2e4Vi1pjQIpNgeUSVnohXh5otWTZduQTCzKKk
XVtfI0cVxp75g+BR15qZ5IB6JL0a1Q/5i8C31qtk6/43cBpaOdkpYv4SzUbd
j3kLus7cKEVMkB3vG6gUNsDjWeu1ynoCjY/8pCfCRjh3nT1m1kxgfkRVapzR
hE18BU/cQRC03UCP5S1F9IKfbWEfwSUqodmvW4rUCykPxH8TTPNFeUvCmqEl
tXsdN0zw4EnTr1cHmzGa1mJy6yPBY938q/3RMgz4ZBUMjhJMuAbmj9IyrH0x
zMudJLjgL287E9OCubObTxnMERw/YfG5dKYF94x6HosX0bgV7hE4fK4VUWuc
PhFNGoZ826JWrTaEz3+I9dSm8d7p/ar16W2weuF/4MhiGipV3AOfZe1IcrSe
YS+jsbdQttH9TjsGPvhNfdKjMb5JY2h8dQfGlsZ1Hl9FQ/5I60/DrA4kWppc
fm5Iw9xaemqFZSdqktua7I1p5P98IrixoBOpfPs3fqY0kts6vPdv6MI3XtG8
TAsa9z5j8wtKu3CqovdMOoeGBtsq8ahDN4pdbHvDrGlI7Bb9Pl3VDcU7jjnf
lka1ccmIt1sPuCmRE7rrmT16Fq4nG3vQb+A+NrCBRqXqWLZuQC9Svj5tcPM7
Gpk5V0yPdvYi+LylP8uJRvu+2MLroX1Y17HD464zDS/F+t1CRR9M9uSzplxp
sAIluoNhcoQeaIxx5DJ7mvUbV6rkiCBKxwx3GueMPYu/OE6hQVAXKubRCBr8
UeB5goJQrZS8ZexW8IvP5Z8o9NjknWtnrGVXP6p9lgInQJg2zPgGPBy1Eynk
nPQt/nIbjaJD26u1rlOwkwSJDjB+d9u9RfMZhXDZtZWjjGsOh+bxyil4KiaE
s4wLzIQnkyoo1FMhRHM7jaiHL7/SrKZwd5t3LZvxtIh7UKOego6zIMKV8Yoe
KNR7KQQcjjtzifFEVlCpm5zC09yw9nTG3SHnkxP7KUS27bO/zThbWclRV1Cw
lBxUFjG2mXaJWvSRQpPRkFcr4yWVfHAJhRp9s9w+xmMJ8UsSRpg/LkRODjEu
Zz0vUZugkBphmj3F+E5Dr3DLFAVd19QR9R00BGmzewQzFPq2sLbqMA7da2hR
NUeh6t6V63qMt61ynlhYoCBONR5czfg/jON/Jg==
               "]]}, "Charting`Private`Tag#2"], 
            Annotation[{
              Directive[
               Opacity[1.], 
               RGBColor[0.560181, 0.691569, 0.194885], 
               AbsoluteThickness[2]], 
              Line[CompressedData["
1:eJwV0ntUjHkcBvBUjorOJiS5X5p0YsdlsrJbj6ZomTa6GYORFItFVMhRNE1x
IuvakqQkmrGVZMU0GRNqizXdzDTd5k2alaF634p00/72j+95zufP5znf2dvD
/HYYGxkZ/ULu/xRzpMUpKTKEas++dWXTsMvq7751UwZlyFLNPuKCCWsd86Qy
5M6Jrk0jbu02JD+TyZDdc+L9MLH7/QVhH+tlqDo2JVyxiMbIwvzZrnZFEDSL
vq5cQuOYw6OTLdeKwM9PH8tzphFhV7re4bocLic3Gvb9SEM3vqNrqOIJ0lau
OKj+mYbzzljrxpqnmL77w3SPQBpvpOxyZbsS8/2+feAE01jreHvc4+EStJ9P
jq3YR2MZv+riUqPnuCrWiKcfpdFyVjTD3/YFdq21d2mPp2F7QVu3wakUjVEz
6wbO0Sjj6mt0TmWoGQmqbUyhsXj4SK0F92+cvzRiOTmLxoSdyknyVeU43mHi
xcmlIU7NS1jnWQFBUoxK8ZBGfv2cwVMbXyL5Di/qioKGX5l3geemV3DUVoui
yshe8qH9tw/+g44YbVO6ikZGjJ/AIH4NSan6NFdDw7RTmPBArIL3DLmVdTMN
+1+7CmelVEIwxEmf20YjyGvqJHOfKnyK+JwTaaCRSImq/RuqkBC0bb0JQ2NA
KM+yCq0Gp7b10sI+GnceVF4911aNzOe9EQ+GaNy3zD7XElaDjrz0xEhjBn1u
guwepgaRJiG26WMYxG/QqaMO1uIsq5olGsfgQDhrTNVgLdj8Pq/r4xlc2bFG
8CH6DQZPsFUcGwbThOy8N2Zq+DxJvmIylUH7ivYpSy6q4fh49F8XZjLo6jp2
x9dag2iFRWvuXAaB0hpnjzQNsozDD39zYPDFxfTfLzPq0Do0xkPvxECXb5Y7
7UYdMr6GV6SyGdgvqDo8cb4Wzyw9DfFLGWQfDw9WSbTwpFg2Vj8wOKWu89nE
qYfzzeyKVysYZJrYCiWF9bgXujWR7cbA1NYpbteyBkyebyvc686gdNGouwPK
BpxMjZ+p9WRQMqug24fbiMwCt+JeL9JnEsvtkKoRacLOJDceA0XX3gzLjU3w
+Lj9t1AfBqk3f5+7S9uE3QHSHK4vAw0/Qno5pBnvrc3zvQMYeOuXrBfrm6Ee
5VBpzWdgLii1bAvVYWtS+ZFiAelTbaey6dIh+qp34vktDKJn8e6NPUAh3kfD
YwUxCGrbE8sLp3BozjLZYmKu5LTvmUgKlfV/2LsSmy162WNxlEJm8eZBf+Jk
rFluEUfhqfrrNRFx3lavErPLFJI8cu42Eb+97lE7+jGFA1UBlhe3MXixLSRr
VRGFMGbx5jRiyTzxoYRiCu8W2EgkxPtznk0eXUIh7lGv21PiAbn7FtOXFJRh
3wV/Ip7YCL1xE4Xefv3h1cHkf24EFXJ1FOqSeQ99iRu2nzgV10LBMVDevYU4
w6BwNNZTODos2xNBvHDAdf+oTgoWy13WZRBbKYRwpyl0fv854U/iXlGMlaib
Qmp5sbyQuMj8SYFRH4Vvt8LmvSZOe90kXtlPYfyqzXwtceyFoYDYQQpSL//E
d8QhgdNYymEKfo38ok7i1VN+6hsZodDD3m3oJ/4Pj4eBig==
               "]]}, "Charting`Private`Tag#3"], 
            Annotation[{
              Directive[
               Opacity[1.], 
               RGBColor[0.922526, 0.385626, 0.209179], 
               AbsoluteThickness[2]], 
              Line[CompressedData["
1:eJwV0ns01GkcBnCFQmsXUZpsm92lpGKFtSoPU9huVipiQ7nXdpBbSZdhitWF
rusSndFOmqlN0YYZ1Gjpom1yZwzz02X2SG3ze2nZSPbdP97zns/5fv94nve8
lmFxfpFTtbS0NtDz/813FNcWFEjwKtXk+PAyFhzh+6FfSyTYFbZ0lpUji4qZ
a23KxBIIE96L/amfDw2evyeRQJ5r9VpC7VG+OO61QgLP0uJmnhOLySU3LVdy
pBCIhz81+pZF2oKqzP5CKTzmpRQuc2WRyGn0XVBUg3Uhscey3VmojP/WfHhU
B76x/cbtPiycongmyta7qOozj3X+kUW72O6hbEAG7d6lRrnRLNbaXP6keqIe
7S7xJWeTWDgHNJ9ZpvUHPCyFh3x5LPpPps/bZN4AnUUrFp48wcL8dHeXv20j
5PJkzWf5LO5z1a0q2/uQ6lo0BF5i8c3E3jYD7gNEVw+qp11nMTNKZlbj+RAc
139KcipZ8C+UHf1h9SO8HlFI0u+yuKn4cjxraxP2O4ZMPH7Iwu/++orVQY9h
fDvJenYLfa+aD7GX9/yJ0PEAcbmCheCgX+Ag/wkUc37hNT5jofM2+Ogtvhyb
0xJKPw6wsIrWVM4veIrNbKgyg2UR6j3XTN+nGSFOlybdRllkM+ktm3qakV5k
KvP4yGIsuEZoFNECP5vtZiodgtJbT/NzX7Yg540gVm5AUG54Jbc/rhWpTZna
2sYEo26BV4ZJKzTC0aSCWQRH/FUd+/a0IXJap596LkF8gvX05vE2aH0etSbR
kiAvck3gqwPtmHSA9l5rAotgu7J2vQ7MdimdJrUlGHAdmONwpgPZvRneUnsC
jSatdKNJJ+o0M965OxFsEbc6rSruhO61w4a6rgQj3+n8NTKvC3yz1VUBbgSq
m3rXLS52wfrFlin7uARWi5tTTBd2Q5l26k2bF8GVQwk75KJuLHT3cGlaS5DV
0eUT5KiAPPCGyZgPwSVt82BRpQK3X2zd0ORHoGNumxHj3INPDbx5e/wJGu2n
XB2T9WCT0yqxbxBB/fyKIR+uEvo5RR+7g2kfM2u3ZLkS2tKzuXk7CO5odgsM
t/YiOq/V2D6S4EJJzlcx3b1I3rnBOzWGoDMgUXwuvA9GkHmN/kSwXu3gy1f3
gbvoRLlNHIF+YKPhywgVRkR1WSsTaJ8WjnyWRgW7hOfyI8kEB+avuzEjnoGy
aK9Z5j6C0Je7eOsSGPybR8LOUnNFxzYeT2IQKtp9Q0CtZ980bJDKILE1yrOG
+jzWuBhkMAh4Eh/JUpeFeNfrnWOwnDs9JSiV4FnRqjbdagbC/MKeJfsJGraH
Cz2lDPS08/WWU4u+5icfrWWQXV3k9D117G/3ZuvWM/j9Qe2JMOqxGo9tOk0M
XjzeZpdHbaqEemovnQ96eWml0f9zMbSSq6L5mp9GGFL3hB3OyuhnUKQXnsGh
FgzesZmqpnkcxFJH6iVjK2OnvGUgEEm+2EltdCcYHiyD5xGFzinU79IPGqUP
MeAMZ67nU0v16yq0Rhk4eh5JLqYuftLLd3/PwD/m/M9XqXmnP2zmjdN9i1uF
VdThWyysZRMM5p7qu9ZA7TVnxejkJM0/bFrbQv0fdqdzOw==
               "]]}, "Charting`Private`Tag#4"], 
            Annotation[{
              Directive[
               Opacity[1.], 
               RGBColor[0.528488, 0.470624, 0.701351], 
               AbsoluteThickness[2]], 
              Line[CompressedData["
1:eJwV0n881HccB/DLrnX6sUysS4a2TnnoF4uV4jUnXT/MxPqhuoiK1UJh1vQD
dzprjyShzI+phGtmUsm5Ei26VPLr/O6+MteuE/f9nHILZd/98X68Hs8/X6/H
e15QuO9eIxaL9TVz/6doufR2ZqYM6TfP6YtW0LDIf6u/fFGGsAyWWQ/jslkb
7EqkMhjEC91mrqTRp9em35PJsJPjWBzN2P3aovCBThm8UvQDfBcaE4tL57la
VOKSlPNctYpG7IJbJ3t/rcTJlDN9c0Ej0qLWZ0G2HE6rhlX5njRUHw/qxh/e
Qa71gy6tHw2nfXGm3c13UaoIF9rtptEqXaqo1lSD5ThQrzlIY4PdlekV72qw
d8noBmEsDeetjalfsP5CxGDVSIKERu/peCs/7n24LzZIHNJocM92tG+xr8Us
ftmB+Xk06vjqZpV9HQTFGdPbr9JweBfTMpX/AEOmVpyRmzRm7as2l3sqEGm3
w0Vzl4YoqyTxmzUPoY3pVno8pFHa+dmYZFs9fvv7Vf5EMw3fOq+yNdsfgXfF
uvdGN7OXfDzsyqHHCFVMOXqvn0beMV9/regJPDOvHRQM0mAPCROvixpgLIji
aV/T4IXoym0yn0Ju4Ud6x2kECOaaG3s3Qh0d+CmHTfAzFd/k19WICG6B9vg0
glGhPN9kTxNSTJPdT5sSFFx/euFMfxPcC6RsDZfg2ozCM73hzfC9oZmSYk1g
cPMvHCbNENiyvVJ5BOItKuWPh1pw50nwS4E9QcRh2ymNYy0QWzdeXudAcH7v
ev+XR1sREFMYd8uZwFK4tKSVo8StC3d/D1tNoHHRzHFMVWKS6v77XncCnS62
YJNpGwJPJ3Kb1xJsljY7eeS04R/e28vGXgQjK9kvRqzaoTB7xlX4EKhKOX9Y
5rYjKSPXzHczAW9R4w9mCztgVB1TbrOdoPD44d0NRR0YmeM8M2EXgUTZ7r19
eSdo9uAYL5jg0gdcYVF5Jyq63+QEhRCwufYJoc5dUOpyLKMOENQum3R1tLoL
JxpuZtSFE9TYlOm9+d3I2umfUhnJ9DG3dYtu6AZkXz4ajCGo0n2fN2NbDwYU
Q13/xhJkXUz+PLSjB53qI7riEwRtWyOlacHP4KGuaMkVEXipHX1E6me4vmZe
lKuEwNi/dkb/HhW+Wzq0W36K6dNk0fCJTgWJWFwXnUxw1Gbjn9MiKAy7rPqp
7yxBQP/+uI2HKRxbF1pIGPOLTm36JYrCsoyMFlYqAWdZ/fDUIxRa5YaF1ozT
sX7F1AQKjqVND3YwLtklqOGkUQgyN2lrZfw826NlcgWFjCFT57pzBPcDg/M9
KylE3FB4KBkXzRdFJ96m8GIo0aefcVjxvdmTayh8KJ4dYpTG/JPcfSe7nkKm
ODvJjbFZN9RGPRTguy2nnLEhN6Ccr6LwmJedVcu4K+iEJKGXwkSU9kIr4zxt
lZ2RmkLo2sIUPePFo65hk4Yo+A8XRC1JJzCpEsKdphDV53HAlfHr+GMm8XoK
To9fBXoxrjS+U8YyUJjrHbx+P+OcJz2ir95SOO7psPoI47iz49/GjVGoejNt
SRLj4M2WttXvKIQkD1udZ7x2zmrDxASF926ajwoY/wdUx4c/
               "]]}, "Charting`Private`Tag#5"]}}, {}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}},
             "AxesOrigin" -> {0.10000000816326553`, 1.0092332761326313`}, 
            "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
            "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               RGBColor[0.528488, 0.470624, 0.701351], 
               AbsoluteThickness[2]], 
              Directive[
               Opacity[1.], 
               RGBColor[0.922526, 0.385626, 0.209179], 
               AbsoluteThickness[2]], 
              Directive[
               Opacity[1.], 
               RGBColor[0.560181, 0.691569, 0.194885], 
               AbsoluteThickness[2]], 
              Directive[
               Opacity[1.], 
               RGBColor[0.880722, 0.611041, 0.142051], 
               AbsoluteThickness[2]], 
              Directive[
               Opacity[1.], 
               RGBColor[0.368417, 0.506779, 0.709798], 
               AbsoluteThickness[2]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            Plot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {0.10000000816326553`, 1.0092332761326313`}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              RGBColor[0.528488, 0.470624, 0.701351], 
              AbsoluteThickness[2]], 
             Directive[
              Opacity[1.], 
              RGBColor[0.922526, 0.385626, 0.209179], 
              AbsoluteThickness[2]], 
             Directive[
              Opacity[1.], 
              RGBColor[0.560181, 0.691569, 0.194885], 
              AbsoluteThickness[2]], 
             Directive[
              Opacity[1.], 
              RGBColor[0.880722, 0.611041, 0.142051], 
              AbsoluteThickness[2]], 
             Directive[
              Opacity[1.], 
              RGBColor[0.368417, 0.506779, 0.709798], 
              AbsoluteThickness[2]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>], 
       ImageSizeCache -> {{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]}, 
     Annotation[{{{{}, {}, 
         Annotation[{
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]], 
           Line[CompressedData["
1:eJwV0H081HcAB/BLbBSvlchDEoVLtMTxqrZ8Ij2I6lAhuxDKq5WHmpoiD0em
TeZeWRFSKWQZWuahLiwVIk447txXW9dKy31/spSH2W9/fF6f1/vPz8d8f6R3
mBqHw9nO5v8W8krv5uTU4lZoRWuXJYVx0cfRa1dqwYv6RPQv66oF26zLS2uR
/UYSbGNF8cfocHZTbS2if6owTmXtUmkb+aa/FrKtPW/XcClmVlaYrzeuwxHB
COfqcopT3N/ODOXW4UyPs0msDcUx42Y+N68eDmd9Wx1XUyjmv1VNtdyDblNP
pXg9heOBRF2Z5D4KLeMDA9wpnpWuetzwqgEx+SVBCbsotllf166ZbsTeluPE
IYjCybdT5MD5HaEDf+pUH6IYykgy9TF8gK3bFlbnxVAYZkn79tg0w85+VN6R
QPHQVSlR2DxEU3qmhuI7itXTJ7rnuD5CXXSYh6OIYsGBBv36TY9R+YH4x+dS
CC+Vp+50awHXhpfndJWion/pZJpfK44o84dtblJ4P/SsctvbBvmUbeaaSvav
+qmI69FPcPHOy6jYGorCeG//YWE7PGvUrq29T6E+Iki9LezAOG+40bGZwvKg
qtos5ymWmWdLg9soArcs0tfa0Qk3ftuP8k6KdJLU5TPQCVPpnfbkXooJQX3R
vNAuZJXFNT6WUdy4/fRi5osuBIjSUmOHKCp1ijOHIiUwItqRPkqKcWf/4neM
BItrvHRuvKZI2aPo+Ta6G+Il5t6/vqWIOmr1aedkNwoeiXJeMxQXwtz9X8c9
QzaX/0PZPxQmglXlzzR74NbvXJn1keLVuldG9qIeHLOu3fXFNIVKdeqGl24v
xg75+yVzGOwulThuzO+FMmmk4s1sBu/Xqr98b9oHXt268xOfMFBUaN4yKeiD
OHQwdFCLgaVt53G95VK42T6/N6TNoPj00eCOEinS6xeczP6MQVpP3469vH5I
MzTLwnUZXJ1tKCip7scJ4aKN7/QYqBvaJIc7DUDN3YIbYMCg2W7WzYmGAcxv
OfiSGDFoNKsa3eEqw8yAUmFhwsBE38o5pkOGfWLueIopA7HqcKGOnxxmmzP2
NJsxuHTl3LJwqRwqxuBU+1IGvb7HSs+HDMJwcMxTZcHAU2nPFyoHUbA1s0Bu
xUDLv1nnRagCD74Or65czu7pMu5YqFJANvep+eUVDOLMPH6ZG0Xwwa2mSGDL
IPDFoUSPowQLecP8MNauJWe9vv+GQGS3eOowa0271ndzYgkCzqXsjGOdDfc1
c5IJ4g4ED+eyLt+3pVHzPMHl3ATax/p53sZujRoC/ocyeK1k8CAopGhTHYGa
cPsTP9YlFsKY1LsEvtz3vkGsI35uMtBoJKjODzgcyXqi3uUr9VaCKOZ0egZr
PRmUanIC4yU+2S2sxwsCq10VBPM3H9ftYj2wPyEteYjgyMlr56SsC4fF1mpK
gtGzi1L+Yr1yYn3ErBGCNpf0EI3PGcwTC+BCCQ4acPq1WY8lxc9LGiWIkCRt
12Ndp3WvijNO4MQvdljGOr9dLtzwkeDvSI/rK1gnZk3tSpwkmGyb1LdnHbLb
xKphmuCCqCZ1LevNRl+Oz8wQYHfS2AbW/wGIk3f1
            "]]}, "Charting`Private`Tag#1"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            RGBColor[0.880722, 0.611041, 0.142051], 
            AbsoluteThickness[2]], 
           Line[CompressedData["
1:eJwV0Hs01HkABXBZzhpL20s7ebTkkQnLpqyE29BUYhVKVJM8a/eEZHsd2YZJ
TttR6LVWiSjstpT2KEaiMZLCGO/X/GSNk9m2+f6Q92N/+8c993z+vNckJNo3
XF1NTe17Jv+3cENhRUZGGWLVbo4nryPQz5sayc0pA+2dvaeUccnynZyiwjIc
HOeKBhkPjChvvCwrw+TDlhyuFQH3sXX0P11lkEqmpTOMF2wembjol6P/vldW
jA1B3NqnF/t/K4fMrNghxI4gVl+ye+1tEUwlRxd8HAjkS/9Vzb5+DsFCw+ad
7gQbIwTLemQvMDUzH7lrF0FroW1d1fsq/FBcEti9n2An577Os7lqBB/SUc5H
EDjsk6bbq4mBxTwtZQxBf0rCaj92DYKuzVe4xROw0zo7/K0kMNILNlckE9S6
KWRyq1p4c+Jd+GkE386dbtF2e4Vi1pjQIpNgeUSVnohXh5otWTZduQTCzKKk
XVtfI0cVxp75g+BR15qZ5IB6JL0a1Q/5i8C31qtk6/43cBpaOdkpYv4SzUbd
j3kLus7cKEVMkB3vG6gUNsDjWeu1ynoCjY/8pCfCRjh3nT1m1kxgfkRVapzR
hE18BU/cQRC03UCP5S1F9IKfbWEfwSUqodmvW4rUCykPxH8TTPNFeUvCmqEl
tXsdN0zw4EnTr1cHmzGa1mJy6yPBY938q/3RMgz4ZBUMjhJMuAbmj9IyrH0x
zMudJLjgL287E9OCubObTxnMERw/YfG5dKYF94x6HosX0bgV7hE4fK4VUWuc
PhFNGoZ826JWrTaEz3+I9dSm8d7p/ar16W2weuF/4MhiGipV3AOfZe1IcrSe
YS+jsbdQttH9TjsGPvhNfdKjMb5JY2h8dQfGlsZ1Hl9FQ/5I60/DrA4kWppc
fm5Iw9xaemqFZSdqktua7I1p5P98IrixoBOpfPs3fqY0kts6vPdv6MI3XtG8
TAsa9z5j8wtKu3CqovdMOoeGBtsq8ahDN4pdbHvDrGlI7Bb9Pl3VDcU7jjnf
lka1ccmIt1sPuCmRE7rrmT16Fq4nG3vQb+A+NrCBRqXqWLZuQC9Svj5tcPM7
Gpk5V0yPdvYi+LylP8uJRvu+2MLroX1Y17HD464zDS/F+t1CRR9M9uSzplxp
sAIluoNhcoQeaIxx5DJ7mvUbV6rkiCBKxwx3GueMPYu/OE6hQVAXKubRCBr8
UeB5goJQrZS8ZexW8IvP5Z8o9NjknWtnrGVXP6p9lgInQJg2zPgGPBy1Eynk
nPQt/nIbjaJD26u1rlOwkwSJDjB+d9u9RfMZhXDZtZWjjGsOh+bxyil4KiaE
s4wLzIQnkyoo1FMhRHM7jaiHL7/SrKZwd5t3LZvxtIh7UKOego6zIMKV8Yoe
KNR7KQQcjjtzifFEVlCpm5zC09yw9nTG3SHnkxP7KUS27bO/zThbWclRV1Cw
lBxUFjG2mXaJWvSRQpPRkFcr4yWVfHAJhRp9s9w+xmMJ8UsSRpg/LkRODjEu
Zz0vUZugkBphmj3F+E5Dr3DLFAVd19QR9R00BGmzewQzFPq2sLbqMA7da2hR
NUeh6t6V63qMt61ynlhYoCBONR5czfg/jON/Jg==
            "]]}, "Charting`Private`Tag#2"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            RGBColor[0.560181, 0.691569, 0.194885], 
            AbsoluteThickness[2]], 
           Line[CompressedData["
1:eJwV0ntUjHkcBvBUjorOJiS5X5p0YsdlsrJbj6ZomTa6GYORFItFVMhRNE1x
IuvakqQkmrGVZMU0GRNqizXdzDTd5k2alaF634p00/72j+95zufP5znf2dvD
/HYYGxkZ/ULu/xRzpMUpKTKEas++dWXTsMvq7751UwZlyFLNPuKCCWsd86Qy
5M6Jrk0jbu02JD+TyZDdc+L9MLH7/QVhH+tlqDo2JVyxiMbIwvzZrnZFEDSL
vq5cQuOYw6OTLdeKwM9PH8tzphFhV7re4bocLic3Gvb9SEM3vqNrqOIJ0lau
OKj+mYbzzljrxpqnmL77w3SPQBpvpOxyZbsS8/2+feAE01jreHvc4+EStJ9P
jq3YR2MZv+riUqPnuCrWiKcfpdFyVjTD3/YFdq21d2mPp2F7QVu3wakUjVEz
6wbO0Sjj6mt0TmWoGQmqbUyhsXj4SK0F92+cvzRiOTmLxoSdyknyVeU43mHi
xcmlIU7NS1jnWQFBUoxK8ZBGfv2cwVMbXyL5Di/qioKGX5l3geemV3DUVoui
yshe8qH9tw/+g44YbVO6ikZGjJ/AIH4NSan6NFdDw7RTmPBArIL3DLmVdTMN
+1+7CmelVEIwxEmf20YjyGvqJHOfKnyK+JwTaaCRSImq/RuqkBC0bb0JQ2NA
KM+yCq0Gp7b10sI+GnceVF4911aNzOe9EQ+GaNy3zD7XElaDjrz0xEhjBn1u
guwepgaRJiG26WMYxG/QqaMO1uIsq5olGsfgQDhrTNVgLdj8Pq/r4xlc2bFG
8CH6DQZPsFUcGwbThOy8N2Zq+DxJvmIylUH7ivYpSy6q4fh49F8XZjLo6jp2
x9dag2iFRWvuXAaB0hpnjzQNsozDD39zYPDFxfTfLzPq0Do0xkPvxECXb5Y7
7UYdMr6GV6SyGdgvqDo8cb4Wzyw9DfFLGWQfDw9WSbTwpFg2Vj8wOKWu89nE
qYfzzeyKVysYZJrYCiWF9bgXujWR7cbA1NYpbteyBkyebyvc686gdNGouwPK
BpxMjZ+p9WRQMqug24fbiMwCt+JeL9JnEsvtkKoRacLOJDceA0XX3gzLjU3w
+Lj9t1AfBqk3f5+7S9uE3QHSHK4vAw0/Qno5pBnvrc3zvQMYeOuXrBfrm6Ee
5VBpzWdgLii1bAvVYWtS+ZFiAelTbaey6dIh+qp34vktDKJn8e6NPUAh3kfD
YwUxCGrbE8sLp3BozjLZYmKu5LTvmUgKlfV/2LsSmy162WNxlEJm8eZBf+Jk
rFluEUfhqfrrNRFx3lavErPLFJI8cu42Eb+97lE7+jGFA1UBlhe3MXixLSRr
VRGFMGbx5jRiyTzxoYRiCu8W2EgkxPtznk0eXUIh7lGv21PiAbn7FtOXFJRh
3wV/Ip7YCL1xE4Xefv3h1cHkf24EFXJ1FOqSeQ99iRu2nzgV10LBMVDevYU4
w6BwNNZTODos2xNBvHDAdf+oTgoWy13WZRBbKYRwpyl0fv854U/iXlGMlaib
Qmp5sbyQuMj8SYFRH4Vvt8LmvSZOe90kXtlPYfyqzXwtceyFoYDYQQpSL//E
d8QhgdNYymEKfo38ok7i1VN+6hsZodDD3m3oJ/4Pj4eBig==
            "]]}, "Charting`Private`Tag#3"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            RGBColor[0.922526, 0.385626, 0.209179], 
            AbsoluteThickness[2]], 
           Line[CompressedData["
1:eJwV0ns01GkcBnCFQmsXUZpsm92lpGKFtSoPU9huVipiQ7nXdpBbSZdhitWF
rusSndFOmqlN0YYZ1Gjpom1yZwzz02X2SG3ze2nZSPbdP97zns/5fv94nve8
lmFxfpFTtbS0NtDz/813FNcWFEjwKtXk+PAyFhzh+6FfSyTYFbZ0lpUji4qZ
a23KxBIIE96L/amfDw2evyeRQJ5r9VpC7VG+OO61QgLP0uJmnhOLySU3LVdy
pBCIhz81+pZF2oKqzP5CKTzmpRQuc2WRyGn0XVBUg3Uhscey3VmojP/WfHhU
B76x/cbtPiycongmyta7qOozj3X+kUW72O6hbEAG7d6lRrnRLNbaXP6keqIe
7S7xJWeTWDgHNJ9ZpvUHPCyFh3x5LPpPps/bZN4AnUUrFp48wcL8dHeXv20j
5PJkzWf5LO5z1a0q2/uQ6lo0BF5i8c3E3jYD7gNEVw+qp11nMTNKZlbj+RAc
139KcipZ8C+UHf1h9SO8HlFI0u+yuKn4cjxraxP2O4ZMPH7Iwu/++orVQY9h
fDvJenYLfa+aD7GX9/yJ0PEAcbmCheCgX+Ag/wkUc37hNT5jofM2+Ogtvhyb
0xJKPw6wsIrWVM4veIrNbKgyg2UR6j3XTN+nGSFOlybdRllkM+ktm3qakV5k
KvP4yGIsuEZoFNECP5vtZiodgtJbT/NzX7Yg540gVm5AUG54Jbc/rhWpTZna
2sYEo26BV4ZJKzTC0aSCWQRH/FUd+/a0IXJap596LkF8gvX05vE2aH0etSbR
kiAvck3gqwPtmHSA9l5rAotgu7J2vQ7MdimdJrUlGHAdmONwpgPZvRneUnsC
jSatdKNJJ+o0M965OxFsEbc6rSruhO61w4a6rgQj3+n8NTKvC3yz1VUBbgSq
m3rXLS52wfrFlin7uARWi5tTTBd2Q5l26k2bF8GVQwk75KJuLHT3cGlaS5DV
0eUT5KiAPPCGyZgPwSVt82BRpQK3X2zd0ORHoGNumxHj3INPDbx5e/wJGu2n
XB2T9WCT0yqxbxBB/fyKIR+uEvo5RR+7g2kfM2u3ZLkS2tKzuXk7CO5odgsM
t/YiOq/V2D6S4EJJzlcx3b1I3rnBOzWGoDMgUXwuvA9GkHmN/kSwXu3gy1f3
gbvoRLlNHIF+YKPhywgVRkR1WSsTaJ8WjnyWRgW7hOfyI8kEB+avuzEjnoGy
aK9Z5j6C0Je7eOsSGPybR8LOUnNFxzYeT2IQKtp9Q0CtZ980bJDKILE1yrOG
+jzWuBhkMAh4Eh/JUpeFeNfrnWOwnDs9JSiV4FnRqjbdagbC/MKeJfsJGraH
Cz2lDPS08/WWU4u+5icfrWWQXV3k9D117G/3ZuvWM/j9Qe2JMOqxGo9tOk0M
XjzeZpdHbaqEemovnQ96eWml0f9zMbSSq6L5mp9GGFL3hB3OyuhnUKQXnsGh
FgzesZmqpnkcxFJH6iVjK2OnvGUgEEm+2EltdCcYHiyD5xGFzinU79IPGqUP
MeAMZ67nU0v16yq0Rhk4eh5JLqYuftLLd3/PwD/m/M9XqXmnP2zmjdN9i1uF
VdThWyysZRMM5p7qu9ZA7TVnxejkJM0/bFrbQv0fdqdzOw==
            "]]}, "Charting`Private`Tag#4"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            RGBColor[0.528488, 0.470624, 0.701351], 
            AbsoluteThickness[2]], 
           Line[CompressedData["
1:eJwV0n881HccB/DLrnX6sUysS4a2TnnoF4uV4jUnXT/MxPqhuoiK1UJh1vQD
dzprjyShzI+phGtmUsm5Ei26VPLr/O6+MteuE/f9nHILZd/98X68Hs8/X6/H
e15QuO9eIxaL9TVz/6doufR2ZqYM6TfP6YtW0LDIf6u/fFGGsAyWWQ/jslkb
7EqkMhjEC91mrqTRp9em35PJsJPjWBzN2P3aovCBThm8UvQDfBcaE4tL57la
VOKSlPNctYpG7IJbJ3t/rcTJlDN9c0Ej0qLWZ0G2HE6rhlX5njRUHw/qxh/e
Qa71gy6tHw2nfXGm3c13UaoIF9rtptEqXaqo1lSD5ThQrzlIY4PdlekV72qw
d8noBmEsDeetjalfsP5CxGDVSIKERu/peCs/7n24LzZIHNJocM92tG+xr8Us
ftmB+Xk06vjqZpV9HQTFGdPbr9JweBfTMpX/AEOmVpyRmzRm7as2l3sqEGm3
w0Vzl4YoqyTxmzUPoY3pVno8pFHa+dmYZFs9fvv7Vf5EMw3fOq+yNdsfgXfF
uvdGN7OXfDzsyqHHCFVMOXqvn0beMV9/regJPDOvHRQM0mAPCROvixpgLIji
aV/T4IXoym0yn0Ju4Ud6x2kECOaaG3s3Qh0d+CmHTfAzFd/k19WICG6B9vg0
glGhPN9kTxNSTJPdT5sSFFx/euFMfxPcC6RsDZfg2ozCM73hzfC9oZmSYk1g
cPMvHCbNENiyvVJ5BOItKuWPh1pw50nwS4E9QcRh2ymNYy0QWzdeXudAcH7v
ev+XR1sREFMYd8uZwFK4tKSVo8StC3d/D1tNoHHRzHFMVWKS6v77XncCnS62
YJNpGwJPJ3Kb1xJsljY7eeS04R/e28vGXgQjK9kvRqzaoTB7xlX4EKhKOX9Y
5rYjKSPXzHczAW9R4w9mCztgVB1TbrOdoPD44d0NRR0YmeM8M2EXgUTZ7r19
eSdo9uAYL5jg0gdcYVF5Jyq63+QEhRCwufYJoc5dUOpyLKMOENQum3R1tLoL
JxpuZtSFE9TYlOm9+d3I2umfUhnJ9DG3dYtu6AZkXz4ajCGo0n2fN2NbDwYU
Q13/xhJkXUz+PLSjB53qI7riEwRtWyOlacHP4KGuaMkVEXipHX1E6me4vmZe
lKuEwNi/dkb/HhW+Wzq0W36K6dNk0fCJTgWJWFwXnUxw1Gbjn9MiKAy7rPqp
7yxBQP/+uI2HKRxbF1pIGPOLTm36JYrCsoyMFlYqAWdZ/fDUIxRa5YaF1ozT
sX7F1AQKjqVND3YwLtklqOGkUQgyN2lrZfw826NlcgWFjCFT57pzBPcDg/M9
KylE3FB4KBkXzRdFJ96m8GIo0aefcVjxvdmTayh8KJ4dYpTG/JPcfSe7nkKm
ODvJjbFZN9RGPRTguy2nnLEhN6Ccr6LwmJedVcu4K+iEJKGXwkSU9kIr4zxt
lZ2RmkLo2sIUPePFo65hk4Yo+A8XRC1JJzCpEsKdphDV53HAlfHr+GMm8XoK
To9fBXoxrjS+U8YyUJjrHbx+P+OcJz2ir95SOO7psPoI47iz49/GjVGoejNt
SRLj4M2WttXvKIQkD1udZ7x2zmrDxASF926ajwoY/wdUx4c/
            "]]}, "Charting`Private`Tag#5"]}}, {}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {All, All}, "Frame" -> {{True, True}, {True, True}}, 
         "AxesOrigin" -> {0.10000000816326553`, 1.0092332761326313`}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            RGBColor[0.528488, 0.470624, 0.701351], 
            AbsoluteThickness[2]], 
           Directive[
            Opacity[1.], 
            RGBColor[0.922526, 0.385626, 0.209179], 
            AbsoluteThickness[2]], 
           Directive[
            Opacity[1.], 
            RGBColor[0.560181, 0.691569, 0.194885], 
            AbsoluteThickness[2]], 
           Directive[
            Opacity[1.], 
            RGBColor[0.880722, 0.611041, 0.142051], 
            AbsoluteThickness[2]], 
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], 
    AspectRatio -> NCache[GoldenRatio^(-1), 0.6180339887498948], 
    Axes -> {True, True}, AxesLabel -> {None, None}, 
    AxesOrigin -> {0.10000000816326553`, 1.0092332761326313`}, 
    DisplayFunction -> Identity, Frame -> {{True, True}, {True, True}}, 
    FrameLabel -> {{
       FormBox[
        TagBox[
        "\"Fitting \\!\\(\\*SuperscriptBox[SubscriptBox[\\(T\\), \\(2\\)], \
\\(*\\)]\\)\"", HoldForm], TraditionalForm], None}, {
       FormBox[
        TagBox["\"Shuttling Distance d (um)\"", HoldForm], TraditionalForm], 
       None}}, FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}},
     GridLines -> {None, None}, GridLinesStyle -> Directive[
      GrayLevel[0.5, 0.4]], ImagePadding -> All, 
    Method -> {
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}}, PlotRange -> {All, All}, PlotRangeClipping -> 
    True, PlotRangePadding -> {{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}}, Ticks -> {Automatic, Automatic}], 
   FormBox[
    FormBox[
     TemplateBox[{
       TagBox[
        FrameBox[
         StyleBox["1", Smaller, StripOnInput -> False]], "Placeholder"], 
       TagBox[
        FrameBox[
         StyleBox["2", Smaller, StripOnInput -> False]], "Placeholder"], 
       TagBox[
        FrameBox[
         StyleBox["3", Smaller, StripOnInput -> False]], "Placeholder"], 
       TagBox[
        FrameBox[
         StyleBox["4", Smaller, StripOnInput -> False]], "Placeholder"], 
       TagBox[
        FrameBox[
         StyleBox["5", Smaller, StripOnInput -> False]], "Placeholder"]}, 
      "LineLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #5}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.922526, 0.385626, 0.209179]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.528488, 0.470624, 0.701351]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               TagBox[#, HoldForm], ",", 
               TagBox[#2, HoldForm], ",", 
               TagBox[#3, HoldForm], ",", 
               TagBox[#4, HoldForm], ",", 
               TagBox[#5, HoldForm]}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.9127580647877674`*^9, 3.9127581115247746`*^9}, {
  3.913274971328182*^9, 3.9132749772274437`*^9}},
 CellLabel->"Out[21]=",ExpressionUUID->"6b891707-40cf-4d62-8eea-2944fba08003"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"\[Chi]", "==", 
    RowBox[{"Exp", "[", 
     FractionBox[
      RowBox[{"-", 
       SuperscriptBox["t", "2"]}], 
      SuperscriptBox["T", "2"]], "]"}]}], ",", "T", ",", "Reals"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.9125097257729235`*^9, 3.912509843079837*^9}},
 CellLabel->
  "In[117]:=",ExpressionUUID->"26576f16-d088-4dda-be0a-07f95981dd39"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"T", "\[Rule]", 
     TemplateBox[{
       RowBox[{"-", 
         SqrtBox[
          FractionBox[
           SuperscriptBox["t", "2"], 
           RowBox[{"Log", "[", 
             FractionBox["1", "\[Chi]"], "]"}]]]}], 
       RowBox[{"0", "<", "\[Chi]", "<", "1"}]},
      "ConditionalExpression"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", "\[Rule]", 
     TemplateBox[{
       SqrtBox[
        FractionBox[
         SuperscriptBox["t", "2"], 
         RowBox[{"Log", "[", 
           FractionBox["1", "\[Chi]"], "]"}]]], 
       RowBox[{"0", "<", "\[Chi]", "<", "1"}]},
      "ConditionalExpression"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.912509768417899*^9, 3.912509812517861*^9}, 
   3.912509843352057*^9},
 CellLabel->
  "Out[117]=",ExpressionUUID->"7ab19c42-0b87-441b-be07-c13726ff9bf0"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Forth-Back Shuttling with Spin Echo", "Subsubsection",
 CellChangeTimes->{{3.913737777019*^9, 
  3.913737788114335*^9}},ExpressionUUID->"73cc8b1a-1540-457f-838d-\
d2b8bc0c42db"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"I11", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", " ", 
       SubscriptBox["\[Kappa]", "t"]}], 
      RowBox[{"Abs", "[", 
       RowBox[{
        SubscriptBox["t", "1"], "-", 
        SubscriptBox["t", "2"]}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["t", "1"], ",", "0", ",", 
      RowBox[{"2", "T"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["t", "2"], ",", "0", ",", 
      RowBox[{"2", "T"}]}], "}"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"T", ">", "0"}], ",", 
       RowBox[{"v", ">", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Kappa]", "t"], ">", "0"}], ",", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], ">", "0"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.9122415844692307`*^9, 3.9122415857791004`*^9}, {
  3.9122418933705235`*^9, 3.912241921178483*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"3d3c8b29-320b-45da-8312-f4190be711a3"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "2"}], " ", "T", " ", 
     SubscriptBox["\[Kappa]", "t"]}]], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", " ", "T", " ", 
       SubscriptBox["\[Kappa]", "t"]}]], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "T", " ", 
        SubscriptBox["\[Kappa]", "t"]}]], " ", "T", " ", 
      SubscriptBox["\[Kappa]", "t"]}]}], ")"}]}], 
  SubsuperscriptBox["\[Kappa]", "t", "2"]]], "Output",
 CellChangeTimes->{3.912241923432835*^9, 3.912506066513058*^9, 
  3.9126598389482403`*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"4de3e6d4-3e3a-4da3-a4cc-88b4d5c70583"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Asymptotic", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "2"}], " ", "T", " ", 
       SubscriptBox["\[Kappa]", "t"]}]], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "T", " ", 
         SubscriptBox["\[Kappa]", "t"]}]], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "T", " ", 
          SubscriptBox["\[Kappa]", "t"]}]], " ", "T", " ", 
        SubscriptBox["\[Kappa]", "t"]}]}], ")"}]}], 
    SubsuperscriptBox["\[Kappa]", "t", "2"]], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9122419469081664`*^9, 3.912241954594181*^9}, {
  3.9122420080432873`*^9, 3.912242010722411*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"c9f19b02-b237-435d-82c1-30c4a52335e9"],

Cell[BoxData[
 RowBox[{"4", " ", 
  SuperscriptBox["T", "2"]}]], "Output",
 CellChangeTimes->{
  3.912241954881192*^9, {3.9122420084996023`*^9, 3.9122420166411257`*^9}, 
   3.91250606669322*^9},
 CellLabel->"Out[15]=",ExpressionUUID->"4bdfb689-9ca6-400e-a1bf-e74e1d1b6f30"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"I22", "=", 
  RowBox[{"2", 
   RowBox[{"(", 
    RowBox[{"I1", "+", "I2"}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.9122415871640615`*^9, 3.9122415883867426`*^9}, {
  3.9122418956665215`*^9, 3.912241895762521*^9}, {3.912242043050395*^9, 
  3.9122420513704104`*^9}, {3.91224208449817*^9, 3.912242087586213*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"b0aa74ce-c859-4ed8-9404-6519f26f7c80"],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"(", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "T"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["\[Kappa]", "t"], "+", 
            RowBox[{"v", " ", 
             SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]], "+", 
        RowBox[{"T", " ", 
         SubscriptBox["\[Kappa]", "t"]}], "+", 
        RowBox[{"T", " ", "v", " ", 
         SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["\[Kappa]", "t"], "+", 
        RowBox[{"v", " ", 
         SubscriptBox["\[Kappa]", "x"]}]}], ")"}], "2"]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "2"}], " ", "T", " ", 
           SubscriptBox["\[Kappa]", "t"]}]], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "T"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["\[Kappa]", "t"], "+", 
              RowBox[{"v", " ", 
               SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]]}]}], ")"}], " ", 
       SubscriptBox["\[Kappa]", "t"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "2"}], " ", "T", " ", 
           SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", "v", " ", 
       SubscriptBox["\[Kappa]", "x"]}]}], 
     RowBox[{
      SubsuperscriptBox["\[Kappa]", "t", "3"], "-", 
      RowBox[{
       SuperscriptBox["v", "2"], " ", 
       SubscriptBox["\[Kappa]", "t"], " ", 
       SubsuperscriptBox["\[Kappa]", "x", "2"]}]}]]}], ")"}]}]], "Output",
 CellChangeTimes->{3.912659847875467*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"7ce745fb-2861-42c2-872d-da8b3773e307"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ix11", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", " ", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"Abs", "[", 
         RowBox[{
          SubscriptBox["t", "1"], "-", 
          SubscriptBox["t", "2"]}], "]"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], 
        RowBox[{"(", 
         RowBox[{"d", "+", 
          RowBox[{"v", " ", 
           SubscriptBox["t", "2"]}]}], ")"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", "0", ",", "T"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", "0", ",", "T"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"T", ">", "0"}], ",", 
        RowBox[{"v", ">", "0"}], ",", 
        RowBox[{
         SubscriptBox["\[Kappa]", "t"], ">", "0"}], ",", 
        RowBox[{
         SubscriptBox["\[Kappa]", "x"], ">", "0"}]}], "}"}]}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.9116406794949894`*^9, 3.9116407486061687`*^9}, {
   3.912149758467888*^9, 3.9121497601564255`*^9}, 3.9122401094276915`*^9, {
   3.912240156747752*^9, 3.912240175555228*^9}, {3.9122416126837263`*^9, 
   3.912241624970691*^9}, 3.91224211306734*^9, {3.9126591934633975`*^9, 
   3.9126591966294847`*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"2c6e36e6-b129-46c2-bc6b-560ba698f9d3"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "T"}], " ", 
      SubscriptBox["\[Kappa]", "t"]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"T", " ", "v"}]}], ")"}], " ", 
      SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"T", " ", 
        SubscriptBox["\[Kappa]", "t"]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"T", " ", "v", " ", 
          SubscriptBox["\[Kappa]", "x"]}]]}], ")"}], " ", 
      SubsuperscriptBox["\[Kappa]", "t", "2"]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"T", " ", 
          SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"T", " ", "v", " ", 
          SubscriptBox["\[Kappa]", "x"]}]]}], ")"}], " ", "v", " ", 
      SubscriptBox["\[Kappa]", "t"], " ", 
      SubscriptBox["\[Kappa]", "x"]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"T", " ", 
          SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"T", " ", "v", " ", 
          SubscriptBox["\[Kappa]", "x"]}]]}], ")"}], " ", 
      SuperscriptBox["v", "2"], " ", 
      SubsuperscriptBox["\[Kappa]", "x", "2"]}]}], ")"}]}], 
  RowBox[{
   RowBox[{"v", " ", 
    SubsuperscriptBox["\[Kappa]", "t", "3"], " ", 
    SubscriptBox["\[Kappa]", "x"]}], "-", 
   RowBox[{
    SuperscriptBox["v", "3"], " ", 
    SubscriptBox["\[Kappa]", "t"], " ", 
    SubsuperscriptBox["\[Kappa]", "x", "3"]}]}]]], "Output",
 CellChangeTimes->{{3.9116407400347443`*^9, 3.91164075039948*^9}, 
   3.9121482249153247`*^9, 3.9121497638177605`*^9, 3.9122401831602325`*^9, 
   3.912241640799116*^9, 3.91224212527903*^9, 3.9125060707639146`*^9, 
   3.912659686665518*^9},
 CellLabel->"Out[2]=",ExpressionUUID->"0337adcd-7b8b-4d33-a0ff-a1a058fd3f56"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ix22", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", " ", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"Abs", "[", 
         RowBox[{
          SubscriptBox["t", "1"], "-", 
          SubscriptBox["t", "2"]}], "]"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], "v", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"d", "/", "v"}], "+", 
          RowBox[{"2", "T"}], "-", 
          SubscriptBox["t", "2"]}], ")"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", "T", ",", 
       RowBox[{"2", "T"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", "T", ",", 
       RowBox[{"2", "T"}]}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"T", ">", "0"}], ",", 
        RowBox[{"v", ">", "0"}], ",", 
        RowBox[{
         SubscriptBox["\[Kappa]", "t"], ">", "0"}], ",", 
        RowBox[{
         SubscriptBox["\[Kappa]", "x"], ">", "0"}]}], "}"}]}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.9116407899069796`*^9, 3.9116407924180374`*^9}, {
   3.912149762819853*^9, 3.9121497661959257`*^9}, 3.9122401100678096`*^9, {
   3.9122401832763386`*^9, 3.912240223020705*^9}, {3.9122416162997236`*^9, 
   3.9122416339147096`*^9}, 3.9122421140193434`*^9, {3.9126592015414867`*^9, 
   3.912659201961481*^9}, {3.912659785379548*^9, 3.9126598076666145`*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"1e34becc-9fee-4cb5-a073-08fda48b1028"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "T"}], " ", 
      SubscriptBox["\[Kappa]", "t"]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"T", " ", "v"}]}], ")"}], " ", 
      SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"T", " ", 
        SubscriptBox["\[Kappa]", "t"]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"T", " ", "v", " ", 
          SubscriptBox["\[Kappa]", "x"]}]]}], ")"}], " ", 
      SubsuperscriptBox["\[Kappa]", "t", "2"]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"T", " ", 
          SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"T", " ", "v", " ", 
          SubscriptBox["\[Kappa]", "x"]}]]}], ")"}], " ", "v", " ", 
      SubscriptBox["\[Kappa]", "t"], " ", 
      SubscriptBox["\[Kappa]", "x"]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"T", " ", 
          SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"T", " ", "v", " ", 
          SubscriptBox["\[Kappa]", "x"]}]]}], ")"}], " ", 
      SuperscriptBox["v", "2"], " ", 
      SubsuperscriptBox["\[Kappa]", "x", "2"]}]}], ")"}]}], 
  RowBox[{
   RowBox[{"v", " ", 
    SubsuperscriptBox["\[Kappa]", "t", "3"], " ", 
    SubscriptBox["\[Kappa]", "x"]}], "-", 
   RowBox[{
    SuperscriptBox["v", "3"], " ", 
    SubscriptBox["\[Kappa]", "t"], " ", 
    SubsuperscriptBox["\[Kappa]", "x", "3"]}]}]]], "Output",
 CellChangeTimes->{
  3.9116407960204897`*^9, 3.9121482286056867`*^9, 3.9121497706199565`*^9, {
   3.912240218907854*^9, 3.9122402293384542`*^9}, 3.9122416456104217`*^9, 
   3.912242130274567*^9, 3.9125060756053066`*^9, 3.9126596991226263`*^9, 
   3.912659818799509*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"245c2d9d-e7bb-470d-9253-8ee4937e2e98"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ix21", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", " ", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["t", "2"], "-", 
          SubscriptBox["t", "1"]}], ")"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], "v", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"d", "/", "v"}], "+", 
          RowBox[{"2", "T"}], "-", 
          SubscriptBox["t", "2"]}], ")"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", "0", ",", "T"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", "T", ",", 
       RowBox[{"2", "T"}]}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"T", ">", "0"}], ",", 
        RowBox[{"v", ">", "0"}], ",", 
        RowBox[{
         SubscriptBox["\[Kappa]", "t"], ">", "0"}], ",", 
        RowBox[{
         SubscriptBox["\[Kappa]", "x"], ">", "0"}]}], "}"}]}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.9116408135514393`*^9, 3.91164088740675*^9}, {
   3.9121497701004825`*^9, 3.9121497710753703`*^9}, 3.9122401107797966`*^9, {
   3.9122402479963713`*^9, 3.9122402680437675`*^9}, {3.912241628291688*^9, 
   3.9122416321475306`*^9}, {3.9122421166834183`*^9, 
   3.9122421171365466`*^9}, {3.9126592049854555`*^9, 
   3.9126592054044757`*^9}, {3.9126598114626837`*^9, 3.9126598116098537`*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"7ac853b7-3343-4b0e-9c95-4b6bad6cdc8b"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", "T", " ", 
      SubscriptBox["\[Kappa]", "t"]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"T", " ", "v"}]}], ")"}], " ", 
      SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"T", " ", 
       SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"T", " ", 
       SubscriptBox["\[Kappa]", "t"]}]], "-", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"T", " ", "v", " ", 
       SubscriptBox["\[Kappa]", "x"]}]]}], ")"}]}], 
  RowBox[{
   SubscriptBox["\[Kappa]", "t"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Kappa]", "t"], "-", 
     RowBox[{"v", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]]], "Output",
 CellChangeTimes->{{3.9116408615970526`*^9, 3.9116408893245573`*^9}, 
   3.912148233705331*^9, 3.9121497771659184`*^9, 3.912240271968871*^9, 
   3.9122416475962257`*^9, 3.912242132274384*^9, 3.9125060775460677`*^9, 
   3.9126597027137547`*^9, 3.912659820591135*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"8b8365c2-9a8e-44aa-b892-013adc28e30d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ix12", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", " ", 
         SubscriptBox["\[Kappa]", "t"]}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["t", "1"], "-", 
          SubscriptBox["t", "2"]}], ")"}]}], "-", 
       RowBox[{
        SubscriptBox["\[Kappa]", "x"], 
        RowBox[{"(", 
         RowBox[{"d", "+", 
          RowBox[{"v", " ", 
           SubscriptBox["t", "2"]}]}], ")"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "1"], ",", "T", ",", 
       RowBox[{"2", "T"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["t", "2"], ",", "0", ",", "T"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"T", ">", "0"}], ",", 
        RowBox[{"v", ">", "0"}], ",", 
        RowBox[{
         SubscriptBox["\[Kappa]", "t"], ">", "0"}], ",", 
        RowBox[{
         SubscriptBox["\[Kappa]", "x"], ">", "0"}]}], "}"}]}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.9116408940772734`*^9, 3.9116409055379105`*^9}, 
   3.9121497748207827`*^9, 3.9122401113157797`*^9, {3.912240217140229*^9, 
   3.9122402172673454`*^9}, {3.9122402507554483`*^9, 
   3.9122402857158413`*^9}, {3.912241629683098*^9, 3.912241630619713*^9}, {
   3.9122421187705493`*^9, 3.9122421188890634`*^9}, {3.912659211829465*^9, 
   3.9126592151834593`*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"0beee895-6989-4b51-a423-2002224c888e"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", "T", " ", 
      SubscriptBox["\[Kappa]", "t"]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"T", " ", "v"}]}], ")"}], " ", 
      SubscriptBox["\[Kappa]", "x"]}]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"T", " ", 
       SubscriptBox["\[Kappa]", "t"]}]]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"T", " ", 
       SubscriptBox["\[Kappa]", "t"]}]], "-", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"T", " ", "v", " ", 
       SubscriptBox["\[Kappa]", "x"]}]]}], ")"}]}], 
  RowBox[{
   SubscriptBox["\[Kappa]", "t"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Kappa]", "t"], "-", 
     RowBox[{"v", " ", 
      SubscriptBox["\[Kappa]", "x"]}]}], ")"}]}]]], "Output",
 CellChangeTimes->{3.911640909550102*^9, 3.9121482393704915`*^9, 
  3.9121497829201603`*^9, 3.912240288909694*^9, 3.9122416494162016`*^9, 
  3.912242134129069*^9, 3.912506079373727*^9, 3.912659705966525*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"e48aebba-ec51-4c1a-a682-3f183fa5f7b9"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.9139715267376347`*^9, 3.9139715288019023`*^9}, 
   3.913971611631205*^9, {3.9219180860523105`*^9, 3.92191809004958*^9}},
 CellLabel->"",ExpressionUUID->"9ade96d1-7ea7-47a5-82c6-1f6f22c0be6c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[CurlyPhi]", "[", 
      RowBox[{
       RowBox[{"\[Gamma]", "/", "u"}], ",", "\[Gamma]"}], "]"}], "==", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Gamma]", "/", "u"}], ")"}], "2"], "/", 
      SuperscriptBox["T", "2"]}]}], "//", "FullSimplify"}], ",", "T", ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"u", ">", "0"}], ",", 
      RowBox[{"\[Gamma]", ">", "0"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.921917535217268*^9, 3.9219175528705707`*^9}, {
  3.9219175895919313`*^9, 3.9219176013661394`*^9}, {3.9219176452944036`*^9, 
  3.921917682601008*^9}, {3.9219178301912737`*^9, 3.921917850541241*^9}, {
  3.9219179565862823`*^9, 3.9219179583927555`*^9}, {3.9219180653941765`*^9, 
  3.921918077413509*^9}, {3.921918108776563*^9, 3.921918114445861*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"74c4e3a0-d526-4c55-99bd-03febbb14a50"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"T", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{"2", " ", "\[Gamma]"}], "u"], "+", 
            FractionBox[
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]}], 
           ")"}]}]], " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", "u"}]], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], 
       SqrtBox[
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["\[ExponentialE]", 
            FractionBox[
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]]}], 
          " ", 
          SuperscriptBox["u", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            FractionBox[
             RowBox[{"2", " ", "\[Gamma]"}], "u"], "+", 
            FractionBox[
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]}]], 
          " ", 
          SuperscriptBox["u", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["\[ExponentialE]", 
           FractionBox[
            RowBox[{"2", " ", "\[Gamma]"}], "u"]], " ", 
          SuperscriptBox["u", "3"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           FractionBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]], " ", 
          SuperscriptBox["u", "3"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            FractionBox[
             RowBox[{"2", " ", "\[Gamma]"}], "u"], "+", 
            FractionBox[
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]}]], 
          " ", 
          SuperscriptBox["u", "3"]}], "-", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           FractionBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]], " ", 
          SuperscriptBox["u", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            FractionBox[
             RowBox[{"2", " ", "\[Gamma]"}], "u"], "+", 
            FractionBox[
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]}]], 
          " ", 
          SuperscriptBox["u", "4"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            FractionBox[
             RowBox[{"2", " ", "\[Gamma]"}], "u"], "+", 
            FractionBox[
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]}]], 
          " ", "u", " ", "\[Gamma]"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            FractionBox[
             RowBox[{"2", " ", "\[Gamma]"}], "u"], "+", 
            FractionBox[
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]}]], 
          " ", 
          SuperscriptBox["u", "3"], " ", "\[Gamma]"}]}]]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", "\[Rule]", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{"2", " ", "\[Gamma]"}], "u"], "+", 
           FractionBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]}], 
          ")"}]}]], " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"-", "1"}], "+", "u"}]], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], 
      SqrtBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["\[ExponentialE]", 
           FractionBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]]}], " ", 
         SuperscriptBox["u", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           FractionBox[
            RowBox[{"2", " ", "\[Gamma]"}], "u"], "+", 
           FractionBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]}]], " ", 
         SuperscriptBox["u", "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          FractionBox[
           RowBox[{"2", " ", "\[Gamma]"}], "u"]], " ", 
         SuperscriptBox["u", "3"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]], " ", 
         SuperscriptBox["u", "3"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           FractionBox[
            RowBox[{"2", " ", "\[Gamma]"}], "u"], "+", 
           FractionBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]}]], " ", 
         SuperscriptBox["u", "3"]}], "-", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]], " ", 
         SuperscriptBox["u", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           FractionBox[
            RowBox[{"2", " ", "\[Gamma]"}], "u"], "+", 
           FractionBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]}]], " ", 
         SuperscriptBox["u", "4"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           FractionBox[
            RowBox[{"2", " ", "\[Gamma]"}], "u"], "+", 
           FractionBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]}]], " ",
          "u", " ", "\[Gamma]"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           FractionBox[
            RowBox[{"2", " ", "\[Gamma]"}], "u"], "+", 
           FractionBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]}]], " ", 
         SuperscriptBox["u", "3"], " ", "\[Gamma]"}]}]]]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.9219175943610163`*^9, 3.9219176016001663`*^9}, {
   3.9219176534887395`*^9, 3.9219176834161544`*^9}, 3.921917859072177*^9, 
   3.921917959757902*^9, {3.9219180674680514`*^9, 3.92191807850317*^9}, {
   3.921918109894828*^9, 3.9219181330149703`*^9}},
 CellLabel->"Out[44]=",ExpressionUUID->"49c0ad67-2fc4-4b2e-b38d-280274e39b1b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           RowBox[{"2", " ", "\[Gamma]"}], "u"], "+", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]}], 
         ")"}]}]], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", "u"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], 
     SqrtBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["\[ExponentialE]", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]]}], " ", 
        SuperscriptBox["u", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          FractionBox[
           RowBox[{"2", " ", "\[Gamma]"}], "u"], "+", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]}]], " ", 
        SuperscriptBox["u", "2"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         FractionBox[
          RowBox[{"2", " ", "\[Gamma]"}], "u"]], " ", 
        SuperscriptBox["u", "3"]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["\[ExponentialE]", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]], " ", 
        SuperscriptBox["u", "3"]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          FractionBox[
           RowBox[{"2", " ", "\[Gamma]"}], "u"], "+", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]}]], " ", 
        SuperscriptBox["u", "3"]}], "-", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]], " ", 
        SuperscriptBox["u", "4"]}], "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          FractionBox[
           RowBox[{"2", " ", "\[Gamma]"}], "u"], "+", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]}]], " ", 
        SuperscriptBox["u", "4"]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          FractionBox[
           RowBox[{"2", " ", "\[Gamma]"}], "u"], "+", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]}]], " ", 
        "u", " ", "\[Gamma]"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          FractionBox[
           RowBox[{"2", " ", "\[Gamma]"}], "u"], "+", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]}]], " ", 
        SuperscriptBox["u", "3"], " ", "\[Gamma]"}]}]]], "/.", 
    RowBox[{"{", 
     RowBox[{"u", "->", "10000"}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Gamma]", ",", "0.0001", ",", "10000"}], "}"}], ",", 
   RowBox[{"PlotRange", "->", "All"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9219176667952766`*^9, 3.9219177870796824`*^9}, {
  3.9219178780990553`*^9, 3.9219180457941904`*^9}, {3.9219181232481947`*^9, 
  3.9219181632303295`*^9}, {3.921918341568859*^9, 3.9219183550824738`*^9}},
 CellLabel->"In[55]:=",ExpressionUUID->"1b6a896f-525d-4f7a-81ec-2f7bae8bb427"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2], 
         Opacity[1.], LineBox[CompressedData["
1:eJwVy3881IcDx3HzKwxlfpZfaYi6RkR+39vpOM7nzDHzu4cfOzSi/MjPDIVj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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
      Slot["HighlightElements"], 
      Slot["LayoutOptions"], 
      Slot["Meta"], 
      Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
          Annotation[{
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]], 
            Line[CompressedData["
1:eJwVy3881IcDx3HzKwxlfpZfaYi6RkR+39vpOM7nzDHzu4cfOzSi/MjPDIVj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             "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {All, All}, 
          "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0},
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>]]& )[<|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {All, All}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>],
     ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
      4.503599627370496*^15, -4.503599627370496*^15}}]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]], 
         Line[CompressedData["
1:eJwVy3881IcDx3HzKwxlfpZfaYi6RkR+39vpOM7nzDHzu4cfOzSi/MjPDIVj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          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PlotRange" -> {All, All}, "Frame" -> {{False, False}, {False, False}}, 
       "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
       "Axes" -> {True, True}, "AspectRatio" -> GoldenRatio^(-1), 
       "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.921917708536676*^9, 3.9219177265772543`*^9}, {
  3.921917761052721*^9, 3.9219177736478586`*^9}, {3.9219179142749443`*^9, 
  3.921917925657875*^9}, {3.9219179688527*^9, 3.9219180471463194`*^9}, {
  3.921918116953267*^9, 3.9219181635311995`*^9}, {3.921918341828191*^9, 
  3.921918355360876*^9}},
 CellLabel->"Out[55]=",ExpressionUUID->"ad8e3bec-a98f-4515-83af-55cc8380fb48"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           RowBox[{"2", " ", "\[Gamma]"}], "u"], "+", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]}], 
         ")"}]}]], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", "u"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], 
     SqrtBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["\[ExponentialE]", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]]}], " ", 
        SuperscriptBox["u", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          FractionBox[
           RowBox[{"2", " ", "\[Gamma]"}], "u"], "+", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]}]], " ", 
        SuperscriptBox["u", "2"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         FractionBox[
          RowBox[{"2", " ", "\[Gamma]"}], "u"]], " ", 
        SuperscriptBox["u", "3"]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["\[ExponentialE]", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]], " ", 
        SuperscriptBox["u", "3"]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          FractionBox[
           RowBox[{"2", " ", "\[Gamma]"}], "u"], "+", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]}]], " ", 
        SuperscriptBox["u", "3"]}], "-", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]], " ", 
        SuperscriptBox["u", "4"]}], "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          FractionBox[
           RowBox[{"2", " ", "\[Gamma]"}], "u"], "+", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]}]], " ", 
        SuperscriptBox["u", "4"]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          FractionBox[
           RowBox[{"2", " ", "\[Gamma]"}], "u"], "+", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]}]], " ", 
        "u", " ", "\[Gamma]"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          FractionBox[
           RowBox[{"2", " ", "\[Gamma]"}], "u"], "+", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "u"}], ")"}], " ", "\[Gamma]"}], "u"]}]], " ", 
        SuperscriptBox["u", "3"], " ", "\[Gamma]"}]}]]], "/.", 
    RowBox[{"{", 
     RowBox[{"u", "->", "10000"}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Gamma]", ",", "0.0001", ",", "10000"}], "}"}], ",", 
   RowBox[{"PlotRange", "->", "All"}]}], "]"}]], "Input",ExpressionUUID->\
"0d764c0d-d53b-4d16-80ff-2c101448f9cf"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1152, 585.6},
WindowMargins->{{954.6, Automatic}, {Automatic, -5.3999999999999995`}},
TaggingRules-><|"TryRealOnly" -> False|>,
Magnification:>0.9 Inherited,
FrontEndVersion->"13.3 for Microsoft Windows (64-bit) (June 3, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"76ebc1eb-060c-49c2-87db-1e72f8d6c005"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 275, 4, 48, "Subsection",ExpressionUUID->"922f0fc0-da37-406e-b485-26a77a06fb07"],
Cell[858, 28, 600, 15, 25, "Input",ExpressionUUID->"f1daed48-919e-4e87-9806-f1e9977bed14"],
Cell[1461, 45, 512, 13, 25, "Input",ExpressionUUID->"313348a7-4e6a-409b-b778-4f47af644f48"],
Cell[CellGroupData[{
Cell[1998, 62, 1216, 35, 25, "Input",ExpressionUUID->"d57ba805-1bd4-4ae2-a288-96f3e5bd946a"],
Cell[3217, 99, 996, 27, 51, "Output",ExpressionUUID->"3488e04e-fb42-4134-9bc3-0143e472e3b1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4250, 131, 1262, 37, 25, "Input",ExpressionUUID->"857dbaf2-42a5-4e36-8a88-c0a50de71a9a"],
Cell[5515, 170, 950, 27, 51, "Output",ExpressionUUID->"370f0ff6-0117-4a46-a2c9-6cb9c1f793e4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6502, 202, 1370, 40, 25, "Input",ExpressionUUID->"bab6a323-3fb6-4ac8-abec-afcbecfb47ce"],
Cell[7875, 244, 1384, 38, 52, "Output",ExpressionUUID->"6f60de64-2d34-4621-a274-d24d02f554e4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9296, 287, 1348, 40, 25, "Input",ExpressionUUID->"29ef21da-1a85-4895-a409-67687107c986"],
Cell[10647, 329, 1334, 38, 52, "Output",ExpressionUUID->"ef8f1701-18eb-426e-8607-e33f53a52a00"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12018, 372, 379, 6, 25, "Input",ExpressionUUID->"4543d6e5-524e-4f58-8fdc-c4464f4698c2"],
Cell[12400, 380, 755, 18, 51, "Output",ExpressionUUID->"4a9ce4e0-390c-4c21-861c-8c1ef13b12ce"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13192, 403, 281, 5, 25, "Input",ExpressionUUID->"037de661-c086-4034-a5af-afee974da963"],
Cell[13476, 410, 1070, 29, 50, "Output",ExpressionUUID->"fe5a1ddd-7e0b-44e0-b046-73c28c05eff6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14583, 444, 971, 28, 28, "Input",ExpressionUUID->"701bebb8-6033-4b35-9fb1-6c7ffa0d81ac"],
Cell[15557, 474, 771, 23, 50, "Output",ExpressionUUID->"dbc512df-8dc8-4ee1-864f-9e91bae54c02"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16365, 502, 352, 8, 26, "Input",ExpressionUUID->"55854080-ed13-45e6-afed-591556c108a7"],
Cell[16720, 512, 278, 6, 48, "Output",ExpressionUUID->"5604f655-500f-4a24-bb4d-dd308c7a5e3e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17035, 523, 2713, 77, 49, "Input",ExpressionUUID->"17b27775-08c4-4026-8c2e-9cff28f9ff2c"],
Cell[19751, 602, 202, 3, 28, "Output",ExpressionUUID->"04c0f7c7-4a62-4ae4-bebe-a174176de029"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19990, 610, 180, 3, 40, "Subsubsection",ExpressionUUID->"59afaaa5-33a6-4b6f-b2cf-ef9fc694b114"],
Cell[CellGroupData[{
Cell[20195, 617, 198, 3, 25, "Input",ExpressionUUID->"9a4e9320-8ef5-4f4b-8fb6-876b57e7314e"],
Cell[20396, 622, 2040, 61, 52, "Output",ExpressionUUID->"822adb37-303b-4f22-9dd2-cda65219fed2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22473, 688, 200, 3, 25, "Input",ExpressionUUID->"1440caa6-b348-4c24-a77f-2038b2c03259"],
Cell[22676, 693, 1992, 60, 52, "Output",ExpressionUUID->"e1139607-7a61-4b39-9cbf-70a53b8f645f"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24717, 759, 199, 3, 40, "Subsubsection",ExpressionUUID->"6a97360d-7a5a-4755-9d2d-77d66b5f4674"],
Cell[24919, 764, 1691, 45, 47, "Input",ExpressionUUID->"1612c542-715d-4057-aea4-5460a2a8edce"],
Cell[26613, 811, 1490, 42, 47, "Input",ExpressionUUID->"e2472a10-2dff-45a1-9c6c-c1701e52bce4"],
Cell[CellGroupData[{
Cell[28128, 857, 978, 27, 47, "Input",ExpressionUUID->"525c957c-e32d-4258-88c1-57b69bee0dce"],
Cell[29109, 886, 150, 2, 28, "Output",ExpressionUUID->"02b36850-32e8-43ed-a3d4-8a2ad0a676e7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29296, 893, 1085, 30, 47, "Input",ExpressionUUID->"ee662530-05fb-4b5e-bc70-d24aceeb3a02"],
Cell[30384, 925, 14200, 276, 205, "Output",ExpressionUUID->"9318c9d2-0e9a-4d0b-a62a-434d576f53ed"]
}, Open  ]],
Cell[44599, 1204, 185, 3, 31, "Text",ExpressionUUID->"d46228a6-0e75-4e6d-ac79-17ae7b226b1f"],
Cell[CellGroupData[{
Cell[44809, 1211, 692, 19, 25, "Input",ExpressionUUID->"89cec52f-2509-4520-b364-456935cf9dc5"],
Cell[45504, 1232, 1410, 41, 51, "Output",ExpressionUUID->"e59ad4bd-d077-4cbf-841a-a264d3754ef1"]
}, Open  ]],
Cell[46929, 1276, 174, 3, 31, "Text",ExpressionUUID->"000073d1-73d1-4fcc-9ee6-4fd86af5a2f5"],
Cell[CellGroupData[{
Cell[47128, 1283, 912, 21, 25, "Input",ExpressionUUID->"0dcc53df-3541-4a01-a81f-e9fc7c62f2ff"],
Cell[48043, 1306, 574, 13, 50, "Output",ExpressionUUID->"4dd6b15a-41d6-41e2-8fd1-f8e1378679b6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[48654, 1324, 936, 18, 25, "Input",ExpressionUUID->"ba0b5043-063b-419c-b694-4ecaad116f48"],
Cell[49593, 1344, 477, 11, 45, "Output",ExpressionUUID->"3cd2f743-d412-460c-a364-d4103f175853"]
}, Open  ]],
Cell[CellGroupData[{
Cell[50107, 1360, 1064, 31, 44, "Input",ExpressionUUID->"02b1e68a-bcef-4dc7-9aa3-ae323482e21d"],
Cell[51174, 1393, 1134, 33, 49, "Output",ExpressionUUID->"2821ea5a-58e1-42d4-836c-c9ec8c5246ee"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52345, 1431, 2169, 56, 47, "Input",ExpressionUUID->"f06a1b76-abf7-4295-9e1c-c5ac76cb1e22"],
Cell[54517, 1489, 602, 15, 47, "Output",ExpressionUUID->"ba2f6e9f-89fa-44c1-b0a5-839721589718"]
}, Open  ]],
Cell[CellGroupData[{
Cell[55156, 1509, 2002, 53, 60, "Input",ExpressionUUID->"85cd0b36-0e98-4b69-a4aa-1f89b4604279"],
Cell[57161, 1564, 57464, 1083, 227, "Output",ExpressionUUID->"b1cdd7a6-bbcb-4aa1-b103-0b7f1a163aca"]
}, Open  ]],
Cell[CellGroupData[{
Cell[114662, 2652, 2009, 53, 60, "Input",ExpressionUUID->"a9cc2c01-16a7-40b4-9355-927424f20b37"],
Cell[116674, 2707, 52667, 1007, 225, "Output",ExpressionUUID->"e7ecbee2-5724-4d6b-8cd7-435adab2d847"]
}, Open  ]],
Cell[CellGroupData[{
Cell[169378, 3719, 2001, 53, 60, "Input",ExpressionUUID->"4fd55633-c290-458e-bbb4-c51076dc6409"],
Cell[171382, 3774, 57246, 1083, 225, "Output",ExpressionUUID->"9a82c7f7-5f13-4394-b2c1-2f3620bca022"]
}, Open  ]],
Cell[CellGroupData[{
Cell[228665, 4862, 3196, 73, 60, "Input",ExpressionUUID->"64b4ffda-fbca-44a9-85a2-e900e164232a"],
Cell[231864, 4937, 106083, 2069, 221, "Output",ExpressionUUID->"45249040-2a82-4ae2-b1fb-77a94bf8d791"]
}, Open  ]],
Cell[CellGroupData[{
Cell[337984, 7011, 535, 12, 25, "Input",ExpressionUUID->"96c0a4bb-5b28-4a16-aa8a-e2d826aa8aac"],
Cell[338522, 7025, 11292, 201, 325, "Output",ExpressionUUID->"3a52cfc8-2ae6-470c-a0a1-7b023a369666"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[349875, 7233, 219, 4, 48, "Subsection",ExpressionUUID->"6294c122-336d-4ca8-b2b8-57ed800ae431"],
Cell[CellGroupData[{
Cell[350119, 7241, 1081, 32, 25, "Input",ExpressionUUID->"2b230a0a-b8cb-4a34-9ddb-f27bab275676"],
Cell[351203, 7275, 782, 20, 52, "Output",ExpressionUUID->"68f867fe-45f1-4964-8021-a4117b306490"]
}, Open  ]],
Cell[CellGroupData[{
Cell[352022, 7300, 961, 24, 48, "Input",ExpressionUUID->"91792cbd-d158-4725-97dc-6e7e957196e4"],
Cell[352986, 7326, 273, 6, 28, "Output",ExpressionUUID->"7595470b-3727-4b20-a21c-14b475005717"]
}, Open  ]],
Cell[CellGroupData[{
Cell[353296, 7337, 416, 8, 25, "Input",ExpressionUUID->"9989b4cc-de43-4d1e-b3d4-b49ecb1261f3"],
Cell[353715, 7347, 2129, 62, 52, "Output",ExpressionUUID->"7c056ddf-9d31-4f2f-97db-f1b77b956d22"]
}, Open  ]],
Cell[CellGroupData[{
Cell[355881, 7414, 1508, 41, 25, "Input",ExpressionUUID->"a33c7141-63d4-4027-b337-a90c6560aae8"],
Cell[357392, 7457, 2386, 67, 52, "Output",ExpressionUUID->"054912a3-7368-4cf5-be25-0db4c07fc4a5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[359815, 7529, 1647, 44, 25, "Input",ExpressionUUID->"7bd3c15e-862f-46de-88fd-3b7d7730645e"],
Cell[361465, 7575, 2417, 68, 52, "Output",ExpressionUUID->"fead920e-d9bd-486f-bd41-d240c0320454"]
}, Open  ]],
Cell[CellGroupData[{
Cell[363919, 7648, 1655, 44, 25, "Input",ExpressionUUID->"265fb03b-8cd2-4b41-9426-50318dd5fec6"],
Cell[365577, 7694, 1351, 38, 50, "Output",ExpressionUUID->"e849cc15-c263-479b-8001-36ce535ac38d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[366965, 7737, 1581, 43, 25, "Input",ExpressionUUID->"2b7e6c99-3d31-40ac-a5db-7fc703d05b78"],
Cell[368549, 7782, 1293, 37, 50, "Output",ExpressionUUID->"0b65a751-445b-482d-bece-af1e310b864a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[369879, 7824, 467, 9, 25, "Input",ExpressionUUID->"a6dcc39c-3bf1-4031-9e5a-4168e931161a"],
Cell[370349, 7835, 373, 7, 28, "Output",ExpressionUUID->"0b936c47-d0a3-4d77-9751-acc4bc87e65d"]
}, Open  ]],
Cell[370737, 7845, 4359, 117, 72, "Input",ExpressionUUID->"37f5fe05-a4f7-45b6-b520-7c7c027741ee"],
Cell[CellGroupData[{
Cell[375121, 7966, 534, 11, 25, "Input",ExpressionUUID->"0bb2ebf2-97d0-412d-b5a8-aa93c748a549"],
Cell[375658, 7979, 3947, 111, 76, "Output",ExpressionUUID->"4e5b28a3-0a92-4890-b8f2-9e267df65b5b"]
}, Open  ]],
Cell[379620, 8093, 1126, 26, 44, "Input",ExpressionUUID->"f4fbbacc-ba24-485a-87f3-fe1a090c568d"],
Cell[CellGroupData[{
Cell[380771, 8123, 864, 23, 28, "Input",ExpressionUUID->"b61e3190-8875-40c5-a05d-c7c64b8d140f"],
Cell[381638, 8148, 2405, 61, 71, "Output",ExpressionUUID->"fe2c85c9-e70e-44d9-8f18-8e35dbdcc553"]
}, Open  ]],
Cell[384058, 8212, 152, 3, 25, "Input",ExpressionUUID->"04ad9717-bced-4d9f-aa5e-dbfd64ecdda5"],
Cell[CellGroupData[{
Cell[384235, 8219, 2445, 61, 55, "Input",ExpressionUUID->"751c7646-4119-4b54-ac94-74d0bdf49ecd"],
Cell[386683, 8282, 12795, 335, 233, "Output",ExpressionUUID->"315fd86e-d97b-4e02-98a0-2c33c3761624"]
}, Open  ]],
Cell[CellGroupData[{
Cell[399515, 8622, 1102, 30, 45, "Input",ExpressionUUID->"8eaa3f2a-4fb7-4ede-a2b5-9524782bdbc4"],
Cell[400620, 8654, 128323, 2149, 225, "Output",ExpressionUUID->"b8995ff0-973f-4324-979b-29821fdc3656"]
}, Open  ]],
Cell[CellGroupData[{
Cell[528980, 10808, 1230, 30, 45, "Input",ExpressionUUID->"b23afc85-1883-4ee8-8ae8-70426a0b05ea"],
Cell[530213, 10840, 11819, 235, 246, "Output",ExpressionUUID->"fbb94f54-792e-4c89-baff-d440ecb48f86"]
}, Open  ]],
Cell[CellGroupData[{
Cell[542069, 11080, 2151, 48, 71, "Input",ExpressionUUID->"bade904b-2709-448f-b62e-3215d76812f6"],
Cell[544223, 11130, 76043, 1383, 229, "Output",ExpressionUUID->"f29b37b8-847b-44df-b1cb-a028f72848ef"]
}, Open  ]],
Cell[CellGroupData[{
Cell[620303, 12518, 2094, 48, 71, "Input",ExpressionUUID->"85aaeab0-63e6-49de-8918-9253eaca3d2a"],
Cell[622400, 12568, 45942, 912, 223, "Output",ExpressionUUID->"6b891707-40cf-4d62-8eea-2944fba08003"]
}, Open  ]],
Cell[CellGroupData[{
Cell[668379, 13485, 414, 12, 44, "Input",ExpressionUUID->"26576f16-d088-4dda-be0a-07f95981dd39"],
Cell[668796, 13499, 885, 27, 74, "Output",ExpressionUUID->"7ab19c42-0b87-441b-be07-c13726ff9bf0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[669718, 13531, 183, 3, 40, "Subsubsection",ExpressionUUID->"73cc8b1a-1540-457f-838d-d2b8bc0c42db"],
Cell[CellGroupData[{
Cell[669926, 13538, 1081, 32, 25, "Input",ExpressionUUID->"3d3c8b29-320b-45da-8312-f4190be711a3"],
Cell[671010, 13572, 782, 20, 52, "Output",ExpressionUUID->"4de3e6d4-3e3a-4da3-a4cc-88b4d5c70583"]
}, Open  ]],
Cell[CellGroupData[{
Cell[671829, 13597, 961, 24, 48, "Input",ExpressionUUID->"c9f19b02-b237-435d-82c1-30c4a52335e9"],
Cell[672793, 13623, 273, 6, 28, "Output",ExpressionUUID->"4bdfb689-9ca6-400e-a1bf-e74e1d1b6f30"]
}, Open  ]],
Cell[CellGroupData[{
Cell[673103, 13634, 416, 8, 25, "Input",ExpressionUUID->"b0aa74ce-c859-4ed8-9404-6519f26f7c80"],
Cell[673522, 13644, 2129, 62, 52, "Output",ExpressionUUID->"7ce745fb-2861-42c2-872d-da8b3773e307"]
}, Open  ]],
Cell[CellGroupData[{
Cell[675688, 13711, 1508, 41, 25, "Input",ExpressionUUID->"2c6e36e6-b129-46c2-bc6b-560ba698f9d3"],
Cell[677199, 13754, 2386, 67, 52, "Output",ExpressionUUID->"0337adcd-7b8b-4d33-a0ff-a1a058fd3f56"]
}, Open  ]],
Cell[CellGroupData[{
Cell[679622, 13826, 1647, 44, 25, "Input",ExpressionUUID->"1e34becc-9fee-4cb5-a073-08fda48b1028"],
Cell[681272, 13872, 2417, 68, 52, "Output",ExpressionUUID->"245c2d9d-e7bb-470d-9253-8ee4937e2e98"]
}, Open  ]],
Cell[CellGroupData[{
Cell[683726, 13945, 1655, 44, 25, "Input",ExpressionUUID->"7ac853b7-3343-4b0e-9c95-4b6bad6cdc8b"],
Cell[685384, 13991, 1351, 38, 50, "Output",ExpressionUUID->"8b8365c2-9a8e-44aa-b892-013adc28e30d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[686772, 14034, 1581, 43, 25, "Input",ExpressionUUID->"0beee895-6989-4b51-a423-2002224c888e"],
Cell[688356, 14079, 1293, 37, 50, "Output",ExpressionUUID->"e48aebba-ec51-4c1a-a682-3f183fa5f7b9"]
}, Open  ]],
Cell[689664, 14119, 240, 3, 25, "Input",ExpressionUUID->"9ade96d1-7ea7-47a5-82c6-1f6f22c0be6c"],
Cell[CellGroupData[{
Cell[689929, 14126, 1005, 23, 28, "Input",ExpressionUUID->"74c4e3a0-d526-4c55-99bd-03febbb14a50"],
Cell[690937, 14151, 7534, 214, 127, "Output",ExpressionUUID->"49c0ad67-2fc4-4b2e-b38d-280274e39b1b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[698508, 14370, 3898, 110, 64, "Input",ExpressionUUID->"1b6a896f-525d-4f7a-81ec-2f7bae8bb427"],
Cell[702409, 14482, 12626, 251, 210, "Output",ExpressionUUID->"ad8e3bec-a98f-4515-83af-55cc8380fb48"]
}, Open  ]],
Cell[715050, 14736, 3652, 107, 64, "Input",ExpressionUUID->"0d764c0d-d53b-4d16-80ff-2c101448f9cf"]
}, Open  ]]
}, Open  ]]
}
]
*)

