var documenterSearchIndex = {"docs":
[{"location":"guide/#Quick-Start","page":"Quick Start","title":"Quick Start","text":"","category":"section"},{"location":"guide/#Basic-model","page":"Quick Start","title":"Basic model","text":"","category":"section"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"H_noise(t)=g mu_B sum_j leftB_0(x^c_j)+tildeB(x^c_jt)right S_j^z","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"We assume the electrons are adiabatically transported in moving-wave potential with their wave-functions well localized at x_j^c. Then the effective magnetic noise tildeB(x_j^c t) can be modeled by a Gaussian random field. ","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"In the case of pure dephasing, the system dynamics cna be explicitly writen out. ","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"U(t)=exp(-fracihbar int_0^t H_noise(tau)mathrmd tau)","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"If we label a realization of the random process by k, then the pure dephasing channel can be expressed as a mixing unitary process.","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"mathcalE(rho)=frac1M sum_k=1^M U_k rho U_k^dagger\n=sum_k E_k rho E_k^dagger quad E_k= U_k sqrtM","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"The pure dephasing of such a system can be analytically solved and efficiently obtained via a matrix of dephasing factors. While more general system dynamics involving other interactions can be numerically solved by Monte-Carlo sampling.","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"mathcalH(t)=H_noise(t)+H_int(t)","category":"page"},{"location":"guide/#Generating-a-noise-series-from-a-stochastic-field","page":"Quick Start","title":"Generating a noise series from a stochastic field","text":"","category":"section"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"Import the package.","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"using SpinShuttling\nusing Plots","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"We first define an 2D Ornstein-Uhlenbeck field, specified by three parameters. ","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"κₜ=1/20; # inverse correlation time\nκₓ=1/0.1; # inverse correlation length\nσ = 1; # noise strength\nB=OrnsteinUhlenbeckField(0,[κₜ,κₓ],σ); # mean is zero\nnothing","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"Specify a trajectory (t,x(t)) on the 2D plane, in this example case it's just a line. ","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"t=range(1,20,200); # time step\nv=2; #velocity\nP=collect(zip(t, v.*t));","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"A Gaussian random process (random function) can be obtained by projecting the Gaussian random field along the time-space array P. Then we can use R() to invoke the process and generating a random time series.","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"R=RandomFunction(P, B) \nplot(t, R(), xlabel=\"t\", ylabel=\"B(t)\", size=(400,300)) ","category":"page"},{"location":"guide/#Shuttling-of-a-single-spin","page":"Quick Start","title":"Shuttling of a single spin","text":"","category":"section"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"We can follow the above approach to define a single spin shuttling model.","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"σ = sqrt(2) / 20; # variance of the process\nκₜ=1/20; # temporal correlation\nκₓ=1/0.1; # spatial correlation\nB=OrnsteinUhlenbeckField(0,[κₜ,κₓ],σ);\n\nnothing","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"Consider the shuttling of a single spin at constant velocity v.  We need to specify the initial state, travelling time T and length L=v*T,  and the stochastic noise expreienced by the spin qubit.","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"T=400; # total time\nL=10; # shuttling length\nv=L/T;","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"The package provided a simple encapsulation for the single spin shuttling, namely by OneSpinModel.  We need to specify the discretization size and monte-carlo size to create a model.","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"M = 10000; # monte carlo sampling size\nN=301; # discretization size\nmodel=OneSpinModel(T,L,N,B)\nprintln(model)","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"The fidelity of the spin state after shuttling can be calculated using numerical integration of the covariance matrix.  ","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"This provides us an overview of the model. It's a single spin shuttling problem with initial state Ψ₀ and an Ornstein-Uhlenbeck noise. The total time of simulation is T, which is discretized into N steps.  ","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"The state fidelity after such a quantum process can be obtained by different numerical methods. ","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"f1=averagefidelity(model); # direct integration\n\nf2, f2_err=sampling(model, fidelity, M); # Monte-Carlo sampling","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"For the single spin shuttling at constant velocity, analytical solution is also available. ","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"f3=1/2*(1+W(T,L,B));","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"We can compare the results form the three methods and check their consistency.","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"@assert isapprox(f1, f3,rtol=1e-2)\n@assert isapprox(f2, f3, rtol=1e-2) \nprintln(\"NI:\", f1)\nprintln(\"MC:\", f2)\nprintln(\"TH:\", f3)","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"The pure dephasing channel is computationaly simple, and can be represented by a dephasing matrix w, such that the final density state after the channel is given by mathcalE(rho)=w odotrho. Here odot is a element-wise Hadmard product. ","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"Ψ= model.Ψ\nρ=Ψ*Ψ'\nw=dephasingmatrix(model)\nρt=w.*ρ","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"We can check that the fidelity between the initial and final state is consistent with results above. ","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"f=(Ψ'*ρt*Ψ)","category":"page"},{"location":"guide/#Dephasing-of-entangled-spin-pairs-during-shuttling.","page":"Quick Start","title":"Dephasing of entangled spin pairs during shuttling.","text":"","category":"section"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"Following the approach above, we can further explore the multi-spin system.  The general abstraction on such a problem is given by the data type ShuttlingModel.  ","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"ShuttlingModel(n, Ψ, T, N, B, X, R)","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"User can freely define a n-qubit system with arbitrary initial state. Here, X=[x1,x2...] is an array of function, containing spin trajectories x_i(t). R is a random function constructed from the specific noise process.  ","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"One more example is the shuttling of two spin pairs. We can define such a two spin system. ","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"L=10; σ =sqrt(2)/20; M=5000; N=501; T1=100; T0=25; κₜ=1/20; κₓ=1/0.1;\nB=OrnsteinUhlenbeckField(0,[κₜ,κₓ],σ)\nmodel=TwoSpinModel(T0, T1, L, N, B)\nprintln(model)","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"The system is initialized in the Bell state ketPsi^-.  The model encapsulated a model of two spin shuttled in a sequential manner, as we can see from the two trajectories x1(t) and x2(t). One spin goes first and then follows another, with waiting time T0. This is modeled by the piece-wise linear trajectories.  We can see some quite interesting covariance from such a system.","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"heatmap(collect(model.R.Σ)*1e3, title=\"covariance matrix, two spin EPR\", \nsize=(400,300), \nxlabel=\"t1\", ylabel=\"t2\", dpi=300,\nright_margin=5Plots.mm)","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"We can check that the dephasing of the system and calculate its fidelity as before. ","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"f1=averagefidelity(model)\nf2, f2_err=sampling(model, fidelity, M)\nf3=1/2*(1+W(T0, T1, L,B))\n\nprintln(\"NI:\", f1)\nprintln(\"MC:\", f2)\nprintln(\"TH:\", f3)","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"The density matrix after the channel can be given by the dephasing matrix.","category":"page"},{"location":"guide/","page":"Quick Start","title":"Quick Start","text":"Ψ= model.Ψ\nρ=Ψ*Ψ'\nw=dephasingmatrix(model)\n\nρt=w.*ρ","category":"page"},{"location":"manual/#APIs","page":"Manual","title":"APIs","text":"","category":"section"},{"location":"manual/","page":"Manual","title":"Manual","text":"CurrentModule = SpinShuttling","category":"page"},{"location":"manual/#Spin-Shuttling-Models","page":"Manual","title":"Spin Shuttling Models","text":"","category":"section"},{"location":"manual/","page":"Manual","title":"Manual","text":"ShuttlingModel","category":"page"},{"location":"manual/#SpinShuttling.ShuttlingModel","page":"Manual","title":"SpinShuttling.ShuttlingModel","text":"Spin shuttling model defined by a stochastic field, the realization of the stochastic field is  specified by the paths of the shuttled spins.\n\nArguments\n\nn::Int: Number of spins\nΨ::Vector{<:Number}: Initial state of the spin system, the length of the vector must be `2^n\nT::Real: Maximum time \nN::Int: Time discretization \nB::GaussianRandomField: Noise field\nX::Vector{Function}: Shuttling paths, the length of the vector must be `n\nR::RandomFunction: Random function of the sampled noises on paths\n\n\n\n\n\n","category":"type"},{"location":"manual/","page":"Manual","title":"Manual","text":"OneSpinModel","category":"page"},{"location":"manual/#SpinShuttling.OneSpinModel","page":"Manual","title":"SpinShuttling.OneSpinModel","text":"General one spin shuttling model initialized at initial state |Ψ₀⟩,  with arbitrary shuttling path x(t). \n\nArguments\n\nΨ::Vector{<:Number}: Initial state of the spin system, the length of the vector must be `2^n\nT::Real: Maximum time\nN::Int: Time discretization\nB::GaussianRandomField: Noise field\nx::Function: Shuttling path\n\n\n\n\n\nOne spin shuttling model initialzied at |Ψ₀⟩=|+⟩. The qubit is shuttled at constant velocity along the path x(t)=L/T*t,  with total time T in μs and length L in μm.\n\n\n\n\n\n","category":"function"},{"location":"manual/","page":"Manual","title":"Manual","text":"OneSpinForthBackModel","category":"page"},{"location":"manual/#SpinShuttling.OneSpinForthBackModel","page":"Manual","title":"SpinShuttling.OneSpinForthBackModel","text":"One spin shuttling model initialzied at |Ψ₀⟩=|+⟩. The qubit is shuttled at constant velocity along a forth-back path  x(t, T, L) = t<T/2 ? 2L/T*t : 2L/T*(T-t),  with total time T in μs and length L in μm.\n\nArguments\n\nT::Real: Maximum time\nL::Real: Length of the path\nN::Int: Time discretization\nB::GaussianRandomField: Noise field\nv::Real: Velocity of the shuttling\n\n\n\n\n\n","category":"function"},{"location":"manual/","page":"Manual","title":"Manual","text":"TwoSpinModel","category":"page"},{"location":"manual/#SpinShuttling.TwoSpinModel","page":"Manual","title":"SpinShuttling.TwoSpinModel","text":"General two spin shuttling model initialized at initial state |Ψ₀⟩, with arbitrary shuttling paths x₁(t), x₂(t).\n\nArguments\n\nΨ::Vector{<:Number}: Initial state of the spin system, the length of the vector must be `2^n\nT::Real: Maximum time\nN::Int: Time discretization\nB::GaussianRandomField: Noise field\nx₁::Function: Shuttling path for the first spin\nx₂::Function: Shuttling path for the second spin\n\n\n\n\n\nTwo spin shuttling model initialized at the singlet state |Ψ₀⟩=1/√2(|↑↓⟩-|↓↑⟩). The qubits are shuttled at constant velocity along the path x₁(t)=L/T₁*t and x₂(t)=L/T₁*(t-T₀).  The delay between the them is T₀ and the total shuttling time is T₁+T₀. It should be noticed that due to the exclusion of fermions, x₁(t) and x₂(t) cannot overlap.\n\n\n\n\n\n","category":"function"},{"location":"manual/","page":"Manual","title":"Manual","text":"TwoSpinParallelModel","category":"page"},{"location":"manual/#SpinShuttling.TwoSpinParallelModel","page":"Manual","title":"SpinShuttling.TwoSpinParallelModel","text":"Two spin shuttling model initialized at the singlet state |Ψ₀⟩=1/√2(|↑↓⟩-|↓↑⟩). The qubits are shuttled at constant velocity along the 2D path  x₁(t)=L/T*t, y₁(t)=0 and x₂(t)=L/T*t, y₂(t)=D. The total shuttling time is T and the length of the path is L in μm.\n\n\n\n\n\n","category":"function"},{"location":"manual/","page":"Manual","title":"Manual","text":"dephasingmatrix","category":"page"},{"location":"manual/#SpinShuttling.dephasingmatrix","page":"Manual","title":"SpinShuttling.dephasingmatrix","text":"Calculate the dephasing matrix of a given spin shuttling model.\n\n\n\n\n\n","category":"function"},{"location":"manual/","page":"Manual","title":"Manual","text":"fidelity","category":"page"},{"location":"manual/#SpinShuttling.fidelity","page":"Manual","title":"SpinShuttling.fidelity","text":"Sample a phase integral of the process.  The integrate of a random function should be obtained  from directly summation without using high-order interpolation  (Simpson or trapezoid). \n\n\n\n\n\n","category":"function"},{"location":"manual/","page":"Manual","title":"Manual","text":"sampling","category":"page"},{"location":"manual/#SpinShuttling.sampling","page":"Manual","title":"SpinShuttling.sampling","text":"Monte-Carlo sampling of any objective function.  The function must return Tuple{Real,Real} or Tuple{Vector{<:Real},Vector{<:Real}}\n\nArguments\n\nsamplingfunction::Function: The function to be sampled\nM::Int: Monte-Carlo sampling size\n\nReturns\n\nTuple{Real,Real}: The mean and variance of the sampled function\nTuple{Vector{<:Real},Vector{<:Real}}: The mean and variance of the sampled function\n\nExample\n\nf(x) = x^2\nsampling(f, 1000)\n\nReference\n\nhttps://en.wikipedia.org/wiki/Standarddeviation#Rapidcalculation_methods\n\n\n\n\n\nSampling an observable that defines on a specific spin shuttling model \n\nArguments\n\nmodel::ShuttlingModel: The spin shuttling model\nobjective::Function: The objective function objective(mode::ShuttlingModel; randseq)`\nM::Int: Monte-Carlo sampling size\n\n\n\n\n\n","category":"function"},{"location":"manual/","page":"Manual","title":"Manual","text":"averagefidelity","category":"page"},{"location":"manual/#SpinShuttling.averagefidelity","page":"Manual","title":"SpinShuttling.averagefidelity","text":"Calculate the average fidelity of a spin shuttling model using numerical integration  of the covariance matrix.\n\nArguments\n\nmodel::ShuttlingModel: The spin shuttling model\n\n\n\n\n\n","category":"function"},{"location":"manual/","page":"Manual","title":"Manual","text":"W","category":"page"},{"location":"manual/#SpinShuttling.W","page":"Manual","title":"SpinShuttling.W","text":"Analytical dephasing factor of a one-spin shuttling model.\n\nArguments\n\nT::Real: Total time\nL::Real: Length of the path\nB<:GaussianRandomField: Noise field, Ornstein-Uhlenbeck or Pink-Brownian\npath::Symbol: Path of the shuttling model, :straight or :forthback\n\n\n\n\n\nAnalytical dephasing factor of a sequenced two-spin EPR pair shuttling model.\n\n\n\n\n\n","category":"function"},{"location":"manual/#Stochastics","page":"Manual","title":"Stochastics","text":"","category":"section"},{"location":"manual/","page":"Manual","title":"Manual","text":"OrnsteinUhlenbeckField","category":"page"},{"location":"manual/#SpinShuttling.OrnsteinUhlenbeckField","page":"Manual","title":"SpinShuttling.OrnsteinUhlenbeckField","text":"Ornstein-Uhlenbeck field, the correlation function of which is  σ^2 * exp(-|t₁ - t₂|/θ_t) * exp(-|x₁-x₂|/θ_x)  where t is time and x is position.\n\n\n\n\n\n","category":"type"},{"location":"manual/","page":"Manual","title":"Manual","text":"PinkBrownianField","category":"page"},{"location":"manual/#SpinShuttling.PinkBrownianField","page":"Manual","title":"SpinShuttling.PinkBrownianField","text":"Pink-Brownian Field, the correlation function of which is σ^2 * (expinti(-γ[2]abs(t₁ - t₂)) - expinti(-γ[1]abs(t₁ - t₂)))/log(γ[2]/γ[1]) * exp(-|x₁-x₂|/θ) where expinti is the exponential integral function.\n\n\n\n\n\n","category":"type"},{"location":"manual/","page":"Manual","title":"Manual","text":"RandomFunction","category":"page"},{"location":"manual/#SpinShuttling.RandomFunction","page":"Manual","title":"SpinShuttling.RandomFunction","text":"Similar type of RandomFunction in Mathematica. Can be used to generate a time series on a given time array subject to  a Gaussian random process traced from a Gaussian random field.\n\nArguments\n\nμ::Vector{<:Real}: mean of the process\nP::Vector{<:Point}: time-position array\nΣ::Symmetric{<:Real}: covariance matrices\nC::Cholesky: Cholesky decomposition of the covariance matrices\n\n\n\n\n\n","category":"type"},{"location":"manual/","page":"Manual","title":"Manual","text":"CompositeRandomFunction","category":"page"},{"location":"manual/#SpinShuttling.CompositeRandomFunction","page":"Manual","title":"SpinShuttling.CompositeRandomFunction","text":"Create a new random function composed by a linear combination of random processes. The input random function represents the direct sum of these processes.  The output random function is a tensor contraction from the input.\n\nArguments\n\nR::RandomFunction: a direct sum of random processes R₁⊕ R₂⊕ ... ⊕ Rₙ\nc::Vector{Int}: a vector of coefficients\n\nReturns\n\nRandomFunction: a new random function composed by a linear combination of random processes\n\n\n\n\n\n","category":"function"},{"location":"manual/","page":"Manual","title":"Manual","text":"characteristicfunction","category":"page"},{"location":"manual/#SpinShuttling.characteristicfunction","page":"Manual","title":"SpinShuttling.characteristicfunction","text":"Compute the characteristic functional of the process from the  numerical quadrature of the covariance matrix. Using Simpson's rule by default.\n\n\n\n\n\n","category":"function"},{"location":"manual/","page":"Manual","title":"Manual","text":"characteristicvalue","category":"page"},{"location":"manual/#SpinShuttling.characteristicvalue","page":"Manual","title":"SpinShuttling.characteristicvalue","text":"Compute the final phase of the characteristic functional of the process from the  numerical quadrature of the covariance matrix. Using Simpson's rule by default.\n\n\n\n\n\n","category":"function"},{"location":"manual/","page":"Manual","title":"Manual","text":"covariancematrix","category":"page"},{"location":"manual/#SpinShuttling.covariancematrix","page":"Manual","title":"SpinShuttling.covariancematrix","text":"Covariance matrix of a Gaussian random field.  When P₁=P₂, it is the auto-covariance matrix of a Gaussian random process.  When P₁!=P₂, it is the cross-covariance matrix between two Gaussian random processes.\n\nArguments\n\nP₁::Vector{<:Point}: time-position array\nP₂::Vector{<:Point}: time-position array\nprocess::GaussianRandomField: a Gaussian random field\n\n\n\n\n\nAuto-Covariance matrix of a Gaussian random process.\n\nArguments\n\nP::Vector{<:Point}: time-position array\nprocess::GaussianRandomField: a Gaussian random field\n\nReturns\n\nSymmetric{Real}: auto-covariance matrix\n\n\n\n\n\n","category":"function"},{"location":"manual/","page":"Manual","title":"Manual","text":"covariance","category":"page"},{"location":"manual/#SpinShuttling.covariance","page":"Manual","title":"SpinShuttling.covariance","text":"Covariance function of Gaussian random field.\n\nArguments\n\np₁::Point: time-position array\np₂::Point: time-position array\nprocess<:GaussianRandomField: a Gaussian random field, e.g. OrnsteinUhlenbeckField or PinkBrownianField\n\n\n\n\n\n","category":"function"},{"location":"#SpinShuttling.jl","page":"Home","title":"SpinShuttling.jl","text":"","category":"section"},{"location":"","page":"Home","title":"Home","text":"Simulate the multiple-spin shuttling problem under correlated stochastic noise.","category":"page"},{"location":"#Installation","page":"Home","title":"Installation","text":"","category":"section"},{"location":"","page":"Home","title":"Home","text":"SpinShuttling.jl can be installed by cloning the repository from github.","category":"page"},{"location":"","page":"Home","title":"Home","text":"git clone https://github.com/EigenSolver/SpinShuttling.jl.git","category":"page"},{"location":"","page":"Home","title":"Home","text":"Go to the directory of the project in terminal. ","category":"page"},{"location":"","page":"Home","title":"Home","text":"cd ./SpinShuttling.jl","category":"page"},{"location":"","page":"Home","title":"Home","text":"From the Julia REPL, type ] to enter the Pkg REPL mode and run","category":"page"},{"location":"","page":"Home","title":"Home","text":"pkg> add .","category":"page"},{"location":"#What-does-this-package-do","page":"Home","title":"What does this package do","text":"","category":"section"},{"location":"","page":"Home","title":"Home","text":"This package provides a set of abstractions and numericals tools to simulating dynamics of multi-spin system under correlated noises, based on the Gaussian random field approach. ","category":"page"},{"location":"","page":"Home","title":"Home","text":"While we provided specially optimized models for spin shuttling problems. This package can also be used to simulate more general correlated open-quantum dynamics.","category":"page"},{"location":"","page":"Home","title":"Home","text":"The following two approaches are supported.","category":"page"},{"location":"","page":"Home","title":"Home","text":"Direct numerical integration for pure dephasing.\nMonte-Carlo sampling for open-system dynamics. ","category":"page"},{"location":"#About-spin-shuttling","page":"Home","title":"About spin shuttling","text":"","category":"section"},{"location":"","page":"Home","title":"Home","text":"Spin shuttling has recently emerged as a pivotal technology for large-scale semiconductor quantum computing. By transporting qubits between quantum dots, spin shuttling enables entanglement between non-neighboring qubits, which is essential for quantum error correction. However, the spin qubit becomes decohered by magnetic noise during the shuttling process. Since the noise varies in time and space in a correlated manner, the associated dephasing in a system of several entangled spins often cannot be treated using the standard theory of random processes and requires more advanced mathematical instruments.  In our latest work, we employ the Gaussian random field (GRF) to model the magnetic noise varying in both space and time. By projecting trajectories of spin qubits onto the random field, the correlated noises experienced by multi-spin system can be effectively captured, enabling further study on spin dynamics, dephasing and quantum information applications. ","category":"page"}]
}
