using ProgressMeter
using DataFrames
using DelimitedFiles
using JSON: JSON
using SpinShuttling
using Dates: today, format
const DATADIR="./data/"
const DATE=format(today(),"yyyymmdd")

function genfileidentifier()::String
    localfn=split(split(basename(PROGRAM_FILE),".")[1],"_")[1]
    prefix=localfn*"_"*DATE*"_"
    return prefix
end

function save(df::DataFrame, fn::String; dir::String=DATADIR, prefix::String="")
    # Get the script name
    if prefix == ""
        prefix=genfileidentifier()
    end
    writedlm(dir*prefix*fn, Iterators.flatten(([names(df)], eachrow(df))), ',')
end

function save(info::Union{NamedTuple, AbstractDict}, fn::String; dir::String=DATADIR, prefix::String="")
    # Get the script name
    if prefix == ""
        prefix=genfileidentifier()
    end
    open(dir*prefix*fn, "w") do file; 
        JSON.print(file, info); 
    end
end

function load(fn::String; dir::String=DATADIR)
    f_ext = split(fn, '.')[end]
    if f_ext == "csv"
        data, header = readdlm(dir*fn, ',', header=true)
        df = DataFrame(data, vec(header))
        return df
    elseif f_ext == "json"
        return JSON.parsefile(dir*fn)
    else
        error("invalid data format, must be csv or json")
    end
end