include("../data_io.jl")
using Statistics: mean, std
save_data = true
data_dir = "data/error_data/"


function objfunc(model::ShuttlingModel, randseq::Vector{<:Real}; isarray::Bool=false)::Number
    # model.R || error("covariance matrix is not initialized")
    N = model.N
    dt = model.T / N
    A = model.R(randseq)
    if model.n == 1
        Z = A
    elseif model.n == 2
        # only valid for two-spin EPR pair, ψ=1/√2(|↑↓⟩-|↓↑⟩)
        Z = A[1:N] - A[N+1:end]
    else
        Z = missing
    end
    ϕ = sum(Z) * dt
    return exp.(im * ϕ)
    # return cos.(ϕ)
end


# function fidelity2phase(f::Real)::Complex
#     a=2*f-1
#     b=sqrt(1 - a^2)
#     return a+sign(rand()-1/2)*b*im
# end

function numericalerror(N_arr::Vector{Int}, M::Int, model_func::Function, f_exp::Float64)::Tuple{DataFrame,DataFrame}
    println("scanning parameter: N= ", minimum(N_arr), " ~ ", maximum(N_arr))
    n = length(N_arr)
    data_mc = Vector{NamedTuple}(undef, n)
    data_ni = Vector{NamedTuple}(undef, n)
    f_exp = 2 * f_exp .- 1
    println("expectation:",f_exp)
    
    @showprogress for i in 1:n
        N = N_arr[i]
        model = model_func(N)
        counting = @timed begin
            sampling(model, objfunc, M)
        end
        data_mc[i] = (N=N,
            epsilon=abs.(counting.value[1] - f_exp) / f_exp, delta=sqrt(counting.value[2] / M) / f_exp,
            cpu_time=counting.time, ram_bytes=counting.bytes)

        counting = @timed begin
            2*statefidelity(model)-1
        end
        data_ni[i] = (N=N,
            epsilon=abs.(counting.value - f_exp) / f_exp,
            cpu_time=counting.time, ram_bytes=counting.bytes)
    end

    df_mc = DataFrame(data_mc)
    df_ni = DataFrame(data_ni)
    return df_mc, df_ni
end


n = 80;
N_min = 10;
N_max = 1000;
N_arr = unique(round.(Int, (1 ./ (range(1 / sqrt(N_max), 1 / sqrt(N_min), n))) .^ 2))
N_arr = unique(N_arr .+ 1 .- N_arr .% 2)

# let T=2, L=10, σ =2, κₜ=1, κₓ=1, M=1000000
#     B=OrnsteinUhlenbeckField(0,[κₜ,κₓ],σ)

#     f_exp=(1+W(T,L,B))/2;
#     meta_info=(description="Numerical Error of One Spin One-way Shuttling", T=T, L=L, M=M, corr_t=κₜ, corr_x=κₓ)

#     df_mc, df_ni = numericalerror(N_arr, M, N->OneSpinModel(T, L, N, B), f_exp)

#     if save_data
#         data_identifer="NumError_S1_OW_OU"
#         save(meta_info, data_identifer*".json", dir=data_dir)
#         save(df_mc, data_identifer*"_MC.csv", dir=data_dir)
#         save(df_ni, data_identifer*"_NI.csv", dir=data_dir)
#     end
# end;

let T=2, L=5, σ =2, κₜ=1, κₓ=1, M=1000000
    B=OrnsteinUhlenbeckField(0,[κₜ,κₓ],σ)

    f_exp=(1+W(T,L,B; path=:forthback))/2;
    meta_info=(description="Numerical Error of One Spin Forth-Back Shuttling", T=T, L=L, M=M, corr_t=κₜ, corr_x=κₓ)

    df_mc, df_ni = numericalerror(N_arr, M, N->OneSpinForthBackModel(T, L, N, B), f_exp)

    if save_data
        data_identifer="NumError_S1_FB_OU"
        save(meta_info, data_identifer*".json", dir=data_dir)
        save(df_mc, data_identifer*"_MC.csv", dir=data_dir)
        save(df_ni, data_identifer*"_NI.csv", dir=data_dir)
    end
end;

let T0=1, T1=1.5, L=10, σ =2, κₜ=1, κₓ=1, M=1000000;
    B=OrnsteinUhlenbeckField(0,[κₜ,κₓ],σ)
    f_exp2=(1+W(T0,T1,L,B))/2;

    meta_info=(description="Numerical Error of Two Spin Sequential Shuttling", 
    sigma=σ, T0=T0, T1=T1, L=L, M=M, corr_t=κₜ, corr_x=κₓ)

    df_mc, df_ni = numericalerror(N_arr, M, N->TwoSpinSequentialModel(T0, T1, L, N, B), f_exp2)

    if save_data
        data_identifer="NumError_S2_SQ_OU"
        save(meta_info, data_identifer*".json", dir=data_dir)
        save(df_mc, data_identifer*"_MC.csv", dir=data_dir)
        save(df_ni, data_identifer*"_NI.csv", dir=data_dir)
    end
end;

# n = 40;
# N_min = 50;
# N_max = 1000;
# N_arr = unique(round.(Int, (1 ./ (range(1 / sqrt(N_max), 1 / sqrt(N_min), n))) .^ 2))
# N_arr = unique(N_arr .+ 1 .- N_arr .% 2)

# let T = 0.2, σ = 10, κₜ = 1, κₓ = 1, M = 50000
#     for k in 1:4
#         L = [0.2, 1, 5, 10][k]
#         B = OrnsteinUhlenbeckField(0, [κₜ, κₓ], σ)

#         f_exp = (1 + W(T, L, B)) / 2
#         meta_info = (description="Numerical Error of One Spin One-Way Shuttling Scan", T=T, L=L, M=M, corr_t=κₜ, corr_x=κₓ)

#         df_mc, df_ni = numericalerror(N_arr, M, N -> OneSpinModel(T, L, N, B), f_exp)

#         if save_data
#             data_identifer = "NumError_S1_OW_OU_2_$k"
#             save(meta_info, data_identifer * ".json", dir=data_dir)
#             save(df_mc, data_identifer * "_MC.csv", dir=data_dir)
#             save(df_ni, data_identifer * "_NI.csv", dir=data_dir)
#         end
#     end
# end;


# let T=2, L=3, σ =2, κₜ=1, κₓ=1
#     M_arr=[100,1000,10000]
#     for i in eachindex(M_arr)
#         M=M_arr[i]
#         B=OrnsteinUhlenbeckField(0,[κₜ,κₓ],σ)
#         N_arr = unique(round.(Int, 1 ./ range(0.001,0.02,30)));
#         N_arr=unique(N_arr .+ 1 .- N_arr .%2)
#         append!(N_arr, [ 43, 39, 35, 31, 29, 27, 25, 23, 21, 19, 17, 15, 13, 11, 9])
#         println("discretization size:",N_arr)
#         n=length(N_arr)

#         f_exp=(1+W(2T,2L,B))/2;
#         # f_exp=(1+W(T,L,B; path=:forthback))/2;

#         meta_info=(description="Numerical Error of One Spin One-Way Shuttling", T=T, L=L, M=M, corr_t=κₜ, corr_x=κₓ)

#         data_mc=Vector{NamedTuple}(undef,n)

#         @showprogress for i in 1:n
#             N=N_arr[i]
#             model=OneSpinModel(2T, 2L, N, B);

#             epsilon_smp =[abs(sampling(model, statefidelity, M)[1]-f_exp)/f_exp for j in 1:10]

#             data_mc[i]=(N=N, 
#             epsilon=mean(epsilon_smp), delta=std(epsilon_smp))
#         end

#         df_mc=DataFrame(data_mc)

#         if save_data
#             data_identifer="NumError_S1_OW_OU"
#             save(meta_info, data_identifer*"_$(i).json", dir=data_dir)
#             save(df_mc, data_identifer*"_MC_$(i).csv", dir=data_dir)
#         end
#     end
# end;
