include("../data_io.jl")
##
let L = 1, σ = sqrt(2) / 20, N0=501, M = 5000, κₜ = 1 / 20, κₓ = 1 / 0.1
    # σ =1/5
    # γ=(1e-9,1e3) # MHz
    for T0 in [0.02, 0.05, 0.1, 0.2, 0.5] ./ κₜ
        # B = OrnsteinUhlenbeckField(0, [κₜ, κₓ], σ)
        B=PinkLorentzianField(0,κₓ,σ, γ)
        n = 30
        v_list = 10 .^ (range(-3, 1, n))

        F = zeros(n, 2)
        N_v_list=zeros(n)
        @showprogress for i in 1:n
            N=N0
            v = v_list[i]
            T1 = L / v
            λ = T1 > T0 ?  T0/(T1+T0) : T1/(T1+T0)
            if 2/λ > N 
                N = round(Int, 2/λ)
                N += (N+1)%2
                println("warning: inaccurate discretization, N renormalized to $N")
            end
            N_v_list[i]=N
            F[i, 1] = v
            model = TwoSpinSequentialModel(T0, T1, L, N, B)
            # F[i, 2], F[i, 3] = sampling(model, statefidelity)
            F[i, 2] = statefidelity(model, method=:simpson)
        end

        df = DataFrame(F, [:v, :chi_ni]) #:chi_mc, :chi_mc_err,
        id = "realistic_tau=$(T0*κₜ)"
        info = (description="Simulation of Two Spin Shuttling",
            T0=T0, T1="L/v", L=L, M=M, N=N_v_list, B=B)
        save(info, "$(id).json",dir=DATADIR*"/two/")
        save(df, "$(id).csv",dir=DATADIR*"/two/")
    end
end

### fix points
# ##
# let L = 10, σ = sqrt(2) / 20, N0=501, M = 5000, κₜ = 1 / 20, κₓ = 1 / 0.1
#     B = OrnsteinUhlenbeckField(0, [κₜ, κₓ], σ)
#     v=0.17433288221999882
#     T0=0.05/ κₜ
#     T1=L/v
#     N=1001
#     model=TwoSpinSequentialModel(T0, T1, L, N, B)
#     println(statefidelity(model))
# end