include("../data_io.jl")
include("styles.jl")

plotoptions= (
    framestyle=:semi,
    grid=:true,
    tickfont=font("Times", 12),
    # legendfont=font("Times", 12),
    # guidefont=font("Times", 14),
    size=(486, 389),
    dpis=300,
);

theme(:dao)


id_list = [
    # "realistic_tau=0.02",
    "realistic_tau=0.05",
    "realistic_tau=0.1",
    "realistic_tau=0.2",
    "realistic_tau=0.5",
    "realistic_tau=1.0",
]

# label="Sim02_20240829_"
label=""

data_list = [load("$(label*id).csv", dir="./data/two/") for id in id_list]
data_info_list = [load("$(label*id).json", dir="./data/two/") for id in id_list]
##
info = data_info_list[1]
vmin = data_list[1].v[1]
vmax = data_list[1].v[end]
L = info["L"];
σ = info["B"]["σ"];
# if σ == sqrt(2)/20
#     σ *=20
# end
κₜ = data_info_list[1]["B"]["θ"][1];
κₓ = data_info_list[1]["B"]["θ"][2];
N = info["N"];

v = 10 .^ range(log10(vmin), log10(vmax), 300)
T = L ./ v

β = T * κₜ
γ = L * κₓ
B = OrnsteinUhlenbeckField(0, [κₜ, κₓ], σ)
χ = exp.(-σ^2 / (4 * κₜ * κₓ) / κₜ^2 / 2 .* map(x -> SpinShuttling.P1(x, γ), β))
χ = (x->W(x,L,B)).(T)

fig = plot(v*κₓ/κₜ, 1 .- χ; dpis=300,
    xlabel=L"u\; \textrm{[\lambda_c/\tau_c]}", ylabel=L"\Delta W=1-W",
    xscale=:log10, yscale=:log10,
    # xlim=(0.01,10),
    ylim=(1e-5, 1.5),
    xlim=(1.5, 0.8*10^4),
    xticks=[10, 100, 1000],
    label="single spin",
    ls=:solid,
    lw=2.5,
    lc=:red,
    legend=:bottomleft,
    plotoptions...)


for i in 1:length(id_list)
    data = data_list[i]
    T0 = data_info_list[i]["T0"]

    scatter!(@. κₓ/κₜ*data.v[1:2:end], @. (1 - data.chi_ni[1:2:end]);
        label=L"\tau=%$(round(T0*κₜ,digits=2))",
        marker=:utriangle,
        mc=i,
        ls=:dash
    )
    T1 = L ./ data.v
    plot!(κₓ/κₜ*v, map(x -> (1 - W(T0, x, L, B)) , T);
        linecolor=i,
        ls=:dash,
        label=:none)
end

display(fig)
# savefig("./figs/Plt01_20240829_fixed_delay.png")

