include("../data_io.jl")

##
let L = 10, σ = sqrt(2) / 20, κₜ = 1 / 20, κₓ = 1 / 0.1
    T0 = 10 .^range(-2, 1, 400) # τ = T0 * κₜ  1ns-1us
    v = 10 .^range(-3, 2, 400)
    T1 = L ./ v # 0.1-1000us v=0.01-100, 
    # T1 = 10 .^range(-1, 3, 400) # 0.1-1000us v=0.01-100, 
    B=OrnsteinUhlenbeckField(0, [κₜ,κₓ], σ)
    χ = [W(t0, t1, L, B) for t0 in T0, t1 in T1]
    F = @. (1+χ)/2

    df=DataFrame("v"=>v, "T0"=>T0)
    save(df, "dephasing_surface_axis.csv", prefix="Sim06_20231019_")
    writedlm("./data/Sim06_20231019_dephasing_surface_vals.csv", F, ',')
end
