using ProgressMeter
include("../data_io.jl")

##
L=40; σ = 40; M = 1000; N=301; κₜ=1;κₓ=1; 
B=OrnsteinUhlenbeckField(0, [κₜ,κₓ], σ) 

time_range=range(0.0001,0.04,100)
f_fb = [statefidelity(OneSpinForthBackModel(2T,L,N,B)) for T in time_range];
f_ow = [statefidelity(OneSpinModel(2T,2*L,N,B)) for T in time_range];

df1 = DataFrame(beta=time_range, f_fb=f_fb, f_ow=f_ow)
save(df1, "S1_OW_vs_FB_OU_1.csv", dir="data/one/", prefix="Sim08_20240405_")

##
v=300; σ = 50; M = 1000; N=301; κₜ=1;κₓ=1; 
B=OrnsteinUhlenbeckField(0, [κₜ,κₓ], σ) 

time_range=range(0.0001,0.01,100)
f_fb = [statefidelity(OneSpinForthBackModel(2T,T*v,N,B)) for T in time_range];
f_ow = [statefidelity(OneSpinModel(2T,2T*v,N,B)) for T in time_range];

df2 = DataFrame(beta=time_range, f_fb=f_fb, f_ow=f_ow)
save(df2, "S1_OW_vs_FB_OU_2.csv", dir="data/one/", prefix="Sim08_20240405_")

## 
v=300; σ = 50; M = 1000; N=301; κₜ=1;κₓ=1; 
B=OrnsteinUhlenbeckField(0, [κₜ,κₓ], σ)

time_range=range(0.0001,1,100)
f_fb = [statefidelity(OneSpinForthBackModel(2T,T*v,N,B)) for T in time_range];
f_ow = [statefidelity(OneSpinModel(2T,2T*v,N,B)) for T in time_range];

df3= DataFrame(beta=time_range, f_fb=f_fb, f_ow=f_ow)
save(df3, "S1_OW_vs_FB_OU_3.csv", dir="data/one/", prefix="Sim08_20240405_")

##
L=40; σ = 40; M = 1000; N=301; κₜ=1;κₓ=1; 
B=OrnsteinUhlenbeckField(0, [κₜ,κₓ], σ)

time_range=range(0.0001,0.5,100)
f_fb = [statefidelity(OneSpinForthBackModel(2T,L,N,B)) for T in time_range];
f_ow = [statefidelity(OneSpinModel(2T,2*L,N,B)) for T in time_range];

df4= DataFrame(beta=time_range, f_fb=f_fb, f_ow=f_ow)
save(df4, "S1_OW_vs_FB_OU_4.csv", dir="data/one/", prefix="Sim08_20240405_")