include("../data_io.jl")
using LinearAlgebra: cholesky!, cholesky
using JLD2: jldsave
using Plots: heatmap, savefig
using Dates
##
# let L = 10, T=20, σ = 1/5, N=61, M = 5000, κₜ = 1 / 20, κₓ = 1 / 0.1, γ=(1e-9,1e3)
#     # B = OrnsteinUhlenbeckField(0, [κₜ, κₓ], σ)
#     B = PinkLorentzianField(0, κₓ, σ, γ)

#     t=range(0,T,N)
#     x=range(0,L,N)
#     P=Vector{Tuple{Real,Real}}(undef, N^2)
#     for i in 1:N
#         for j in 1:N
#             P[(i-1)*N+j]=(t[i], x[j])
#         end
#     end
#     Σ=covariancematrix(P,B)
#     C=cholesky(Σ)
#     A=B.μ .+ C.L*randn(N^2)
#     M=reshape(A,N,N)
#     # heatmap(x,t, M')
#     stochastic_field_info_PL=(description="stochastic field", L=L, T=T, N=N, M=M, B=B)
#     df=DataFrame("x"=>x, "t"=>t)
#     save(df, "stochastic_field_axis_PL.csv")
#     save(info, "stochastic_field_info_PL.json")
#     writedlm("./data/Sim07_20240829_stochastic_field_vals_PL.csv", M, ',')
# end

##

# print current time
println("Current time: $(Dates.now())")

let L = 0.1, T=10, σ = sqrt(2) / 20, M = 5000, κₜ = 1 / 20, κₓ = 1 / 0.1
    B = OrnsteinUhlenbeckField(0, [κₜ, κₓ], σ)
    N1=201; N2=101;
    t=range(0,T,N1)
    x=range(0,L,N2)
    model1=OneSpinForthBackModel(T,L,N1,B)
    model2=OneSpinModel(T,2*L,N1,B)
    df=DataFrame(t=t, corr1=model1.R.Σ[1,:], corr2=model2.R.Σ[1,:])
    save(df, "stochastic_field_corr_3.csv")

    P=Vector{Tuple{Real,Real}}(undef, N1*N2)
    Threads.@threads for i in 1:N1
        for j in 1:N2
            P[(i-1)*N2+j]=(t[i], x[j])
        end
    end
    Σ=covariancematrix(P,B)
    # save the matrix Σ using JLD package
    jldsave("./data/Sim07_20240405_noise_surface_covariance_matrix.jld2"; Σ)
    # IO bottleneck!

    C=cholesky(Σ)
    A=B.μ .+ C.L*randn(N2*N1)

    M=reshape(A,N2,N1)
    # fig=heatmap(x, t, M')
    # savefig(fig, "./noise_surface_heatmap.png")
    df=save((x=x, t=t),"Sim07_20240405_stochastic_field_axis_3.json")
    writedlm("./data/Sim07_20240405_stochastic_field_vals_3.csv", M, ',')
end

println("Current time: $(Dates.now())")

# Current time: 2024-04-04T23:51:31.206
# Current time: 2024-04-05T14:20:56.299