This repository contains code and data developed in the work "Modeling of decoherence during transport of entangled qubits". 

The source code of this project is written in Julia programming language, and encapsulated as a package `SpinShuttling.jl`. 

## File structure
The zip files contains the source code and data used for plots respectively. 

SpinShuttling.jl: reusable source code to generate 2D random field and calculate dephasing of spin systems

The source code is also published on Github: https://github.com/EigenSolver/SpinShuttling.jl 

Documentation for this package is avaiable online: 
https://eigensolver.github.io/SpinShuttling.jl/dev/

DATASET: the data and scripts for simulation visualization. The data and scripts are categorized by different plots, as `/fig03/`, etc.

Symbolics: the mathematica notebooks used in the derivation of analytical results. 

### File format
- Datafile: `.csv` files record data values, `.json` files contain metadata and paramters. 
- Scripts: `.jl` files starting with `Sim` or `Ben`, e.g. `Sim08_ForthBackvsSingle.jl`, are scripts for simulations and benchmarking.
- Notebooks: `.ipynb` files starting with `Plt` are interactive Jupyter notebook usd for data visualization.
- Others: `.nb` files are notebooks of Wolfram Mathematica.

## Usage 
Please install the `SpinShuttling.jl` pacakge and correctly setup the Julia environment with `Project.toml` before reproduce the results. 

```julia
pkg> instantiate
```

If you have problems on installing, please check the documentation of the package:
https://eigensolver.github.io/SpinShuttling.jl/dev/


## File Naming Convention

1. Scripts:
    - *TypeNum_Obj_Description.jl/.ipynb*
    - Sim01_Fidelity_OneSpinDephasing.jl
    - Plt15_Fidelity_TwoSpinCorrelation.ipynb

2. Dataset:
    - *Source_YYYYMMDD_ObjectDescription_param1_param2_etc.csv/.json*
    - Sim01_20240501_RandomFieldCorrFunc_S1_FB_PL.csv
3. Images:
    - *TypeNum_YYYYMMDD_PlotDescription_param1_param2_etc.pdf/.png*
    - Plt15_20240103_DephasingFBvsOW.png
  
4. Code:
    - *MyPackage.jl, ancillaryfuncs.jl*

5. Document(Notes):
    - *ObjDescription.nb*

### File Abbrvs.
#### File Type
- Ben: Benchmark
- Sim: Simulations
- Plt: Plots

#### Params Type
- Qubit number: e.g. S1/S2 single/two qubit
- Noise type: e.g. OU/PL Ornstein-Uhlenbeck or Pink-Brownian
- Shuttling scheme: e.g. FB/OW/SQ/PL forth-back, one-way, sequential, parallel 

