%-------------------------------------------------------------------------%
% Background
% Parameter study on the number of elements, using the eigenfrequency
% analysis

% Created by Lei, TU/e, 2018
%-------------------------------------------------------------------------%

clear,clc

%% Data
M = [2 4 8 16 32 64];          % element number

eigFreq = [120.5 120.1 120.0 120.0 120.0 120.0
                610.6 483.0 480.3 480.2 480.2 480.2
                1339.7 1114.6 1082.3 1080.5 1080.4 1080.4
                6519.7 3008.1 1933.2 1921.3 1920.7 1920.7];                % each column as the first four eigenfrequencies
            
nFreq = size(eigFreq,1);

%% Plot

map = colormap('jet');
close all

nMap = size(map,1);
sizeP =  [5 0 20 15];

figure
set(gcf,'Units','centimeters','Position',sizeP);

box on
hold on
for i = 1:nFreq 
    indexI = round((nMap-1)/(nFreq-1)*(i-1)+1);
    
    plot(M,eigFreq(i,:)/1000,'r:','linewidth',3);
    plot(M,eigFreq(i,:)/1000,'square','linewidth',3,...
    'MarkerEdgeColor','none','MarkerFaceColor',map(indexI,:),'MarkerSize',12);

    
end

xlabel('$m$ [-]', 'FontName','Times New Roman','FontSize',20,'interpreter','latex') 
ylabel('$f_{\rm{res}}$ [kHz]','FontName','Times New Roman','FontSize',20,'interpreter','latex');
set(gca,'FontName','Times New Roman','FontSize',20,'XMinorTick','on','YMinorTick','on')

% colormap('jet');
% caxis([1 4]);
% 
% Sizebar = [0.1 0.8 0.5 0.03];
% hbar = colorbar;
% set(hbar, 'Position', 'Location','north',Sizebar);
% set(hbar, 'ytick', [1 2 3 4], 'yticklabel',[1 2 3 4]);





