%-------------------------------------------------------------------------%
% Background
% Function to get reltaions between dependent and independent nodes 
% Created by Lei, TU/e, 2018
%-------------------------------------------------------------------------%

function [indNodes,depNodes,freeNodes,Tdi] = relationInd(coords, presNodes, boundNodes)

% nodes on the left and right boundaries
leftNodes = boundNodes{1}(2:end-1);
rightNodes = boundNodes{2}(2:end-1);             % exclude the corner nodes
H = max(coords(:,2))-min(coords(:,2));   % height

% default prescribed corner nodes and left boundary nodes as independent          
boundaryNodes = [presNodes,leftNodes];
indNodes = boundaryNodes;
boundaryNodes = [boundaryNodes,rightNodes];  % 1, 2, 3, 4, left, right

% left node numbers
nleft = length(leftNodes);

% dependency relations (just for checking)
Depn =[];
for ileft =1:nleft
    Depn = [Depn;rightNodes(ileft),presNodes(1),presNodes(2),presNodes(3),presNodes(4),leftNodes(ileft)];
end

% independent and dependent nodes (i and d)
nNodes = size(coords,1);
indNodes = [indNodes, setdiff([1:nNodes],boundaryNodes)];
depNodes = rightNodes;

% free nodes
freeNodes = setdiff(indNodes,presNodes);

% dependency matrix Tdi
Tdi = zeros(2*length(depNodes),2*length(indNodes));
Tdc = [1 0;0 1];

for ileft =1:nleft
    bottomTdc = [1/2-coords(leftNodes(ileft),2)/H 0; 0 0];
    Tdi(2*ileft-1:2*ileft,1:2) = -bottomTdc;    % 1
    Tdi(2*ileft-1:2*ileft,3:4) =  bottomTdc;    % 2
    
    topTdc = [1/2+coords(leftNodes(ileft),2)/H 0; 0 0];
    Tdi(2*ileft-1:2*ileft,5:6) = topTdc;        % 3
    Tdi(2*ileft-1:2*ileft,7:8) = -topTdc;       % 4
    
    Tdi(2*ileft-1:2*ileft,2*(ileft+4)-1:2*(ileft+4)) = Tdc;   % left
end

end
