%-------------------------------------------------------------------------%
% Background
% Function to get unit cell mesh information
% Created by Lei, TU/e, 2018
%-------------------------------------------------------------------------%

function [coords,elems,parts,boundNodes,cornerNodes] = readMesh(meshFile)

% open file to read
fidin = fopen(meshFile,'r');

% initilaize
nStrings = 0;                  % mark the names, 1-NNODES, 2-NELEMS (and PARTS)...
coords = [];                   % nodal coordinates
elems = [];                    % connectivity
parts = [];                    % parts
boundNodes = cell(1,2);        % boundary nodes

while ~feof(fidin)

% read one line 
tline = fgetl(fidin);
ltline = length(tline);
numtline =  str2num(tline);

  % get the names
  if isempty(numtline) && ~isempty(tline)
    % read the number of nodes      
    if ltline>=6 && strcmpi(tline(1:6),'NNODES')
       nNodes = tline(8:end);
       nNodes = str2double(nNodes);
       nStrings = nStrings+1;
    end
    
    % read the number of elements
    if ltline>=6 && strcmpi(tline(1:6),'NELEMS')
       nelems = tline(8:end);
       nelems = str2double(nelems);
       nStrings = nStrings+1;
    end
    
    % detect boundary nodes
    if ltline>=4 && strcmpi(tline(1:4),'LEFT')
       nStrings = nStrings+1;
    end
    
    if ltline>=5 && strcmpi(tline(1:5),'RIGHT')
       nStrings = nStrings+1;
    end
    
    % detect the corner nodes (left-bottom, right-bottom, right-top, left-top)
    if ltline>=7 && strcmpi(tline(1:7),'CORNERS')
       nStrings = nStrings+1;
    end
    
  end
  
  % scan the data
  if ~isempty(numtline)  
    % read the nodes
    if nStrings ==1 
       coords = [coords; numtline(2:end)] ;
    end
    
    % read the elems
    if nStrings ==2
       elems = [elems; numtline(2:end-1)] ;
       parts = [parts; numtline(end)];
       
    end
    
    % get left boundary nodes
    if nStrings ==3
       leftNodes = numtline; 
       boundNodes{1} = leftNodes;
    end
    
    % get right boundary nodes
    if nStrings ==4
       rightNodes = numtline; 
       boundNodes{2} = rightNodes;
    end
    
    % read the corner nodes
    if nStrings ==5
       cornerNodes = numtline(1:4);
    end

  end
end

fclose(fidin);