%-------------------------------------------------------------------------%
% Background
% Plot the transient displacement responses of interest by both
% homogenization method and direct numerical simulation
% Created by Lei, TU/e, 2018
%-------------------------------------------------------------------------%

function [TR, TRDNS] = funTRField(TR,namePanel,uAmp,keyTR,selCell,nCell,numL,sampleTR,selPeriod,keyU,sizeU)
% plot the transient displacement response of interest, versus time
selXID = selCell/nCell*numL;         % interested position
nSels = length(selXID);
nSamples = length(TR.T);

TR.TD = zeros(nSels,nSamples);       % transient displacement response by homogenization method 

TRDNS.freq = TR.freq;
TRDNS.T = TR.T;
TRDNS.TD = zeros(nSels,nSamples); % transient displacement response by direct numerical simulation

for iSel = 1:nSels
    
    % compute the selected transient displacement response
    for iSample = 1:nSamples 
    TR.TD(iSel,iSample) = interp1(TR.XID,TR.Ut(keyTR:2:end,iSample),selXID(iSel));
    
    end
    
    % read data from direct numerical simulation 
    dataDNS = textread(['DNS/' namePanel '/trResponseDNS_' num2str(TR.freq) 'Hz_' num2str(selCell(iSel)) '_' namePanel '.txt'], '', 'headerlines', 8);
    TRDNS.TD(iSel,:) = interp1((dataDNS(:,1))',(dataDNS(:,2))',TRDNS.T)/1000;
    
    if keyU~= 0
    figure
    set(gcf,'Units','centimeters','Position',sizeU);
    box on
    hold on
    h1 = plot(TRDNS.T*TRDNS.freq,TRDNS.TD(iSel,:)/uAmp,'b-','linewidth',3);
    h2 = plot(TR.T*TR.freq,TR.TD(iSel,:)/uAmp,'r:','linewidth',3);
    
    xlabel('$t/T$ [-]', 'FontName','Times New Roman','FontSize',20,'interpreter','latex')
    ylabel('$u/U_{\rm{in}}$ [-]','FontName','Times New Roman','FontSize',20,'interpreter','latex');
    set(gca,'FontName','Times New Roman','FontSize',20,'XMinorTick','on','YMinorTick','on')
    
    lg = legend([h1 h2],'DNS','HM');
    set(lg,'FontSize',20,'interpreter','latex')
    legend boxoff 
    
    end
end

% plot the transient displacement fields of interest
selT = selPeriod/TR.freq;

[~,selSample] = ismember(selT,TR.T);
TR.selUt = TR.Ut(keyTR:2:end,selSample);

% read data from direct numerical simulation 
TRDNS.XID = TR.XID;

dataDNS = textread(['DNS/' namePanel '/trFieldDNS_' num2str(TR.freq) 'Hz_' num2str(selPeriod) 'T_' namePanel '.txt'], '', 'headerlines', 8);
TRDNS.selUt = interp1(dataDNS(:,1)/1000,dataDNS(:,2)/1000,TRDNS.XID);

if keyU~= 0
figure
set(gcf,'Units','centimeters','Position',sizeU);

hold on
box on

h1 = plot(TRDNS.XID/numL,TRDNS.selUt/uAmp,'b-','linewidth',3);
h2 = plot(TR.XID(1:sampleTR:end)/numL,TR.selUt(1:sampleTR:end,:)/uAmp,'ro','linewidth',3,...
    'MarkerEdgeColor','none','MarkerFaceColor','r','MarkerSize',9);

xlabel('$\xi^{\rm{d}}/L_{\rm{tot}}$ [-]', 'FontName','Times New Roman','FontSize',20,'interpreter','latex') 
ylabel('$u/U_{\rm{in}}$ [-]','FontName','Times New Roman','FontSize',20,'interpreter','latex');
set(gca,'FontName','Times New Roman','FontSize',20,'XMinorTick','on','YMinorTick','on')

lg = legend([h1 h2],'DNS','HM');
set(lg,'FontSize',20,'interpreter','latex')
legend boxoff

end
    
end