%-------------------------------------------------------------------------%
% Background
% Plot the steay-sate displacement fields of interest by both
% homogenization method and direct numerical simulation
% Created by Lei, TU/e, 2018
%-------------------------------------------------------------------------%

function [FR, FRDNS] = funFRField(namePanel,FR,FRDNS,numL,selFreq,keyFR,uAmp,sampleFR,sizeU)

[~,selSample] = ismember(selFreq,FR.freq);
nSels = length(selSample);
FR.selU = real(FR.U(keyFR:2:end,selSample));    

% initialize
FRDNS.selU = zeros(size(FR.selU));
FRDNS.XID = FR.XID;

figure
sizeU(4) = sizeU(4)*nSels;
set(gcf,'Units','centimeters','Position',sizeU);

for iSel = 1:nSels
    
% read data from direct numerical simulation 
dataDNS = textread(['DNS/' namePanel '/frFieldDNS_' num2str(selFreq(iSel)) 'Hz_' namePanel '.txt'], '', 'headerlines', 8);

FRDNS.selU(:,iSel) = interp1(dataDNS(:,1)/1000,dataDNS(:,2)/1000,FRDNS.XID);

subplot(nSels,1,iSel);
hold on
box on
% plot(FR.XID/numL,FR.selU*0,'k-','linewidth',6);
h1 = plot(FRDNS.XID/numL,FRDNS.selU(:,iSel)/uAmp,'b-','linewidth',3);
h2 = plot(FR.XID(1:sampleFR:end)/numL,FR.selU(1:sampleFR:end,iSel)/uAmp,'ro','linewidth',3,...
    'MarkerEdgeColor','none','MarkerFaceColor','r','MarkerSize',9);

ylabel('$u/U_{\rm{in}}$ [-]','FontName','Times New Roman','FontSize',20,'interpreter','latex');
set(gca,'FontName','Times New Roman','FontSize',20,'XMinorTick','on','YMinorTick','on')

if iSel == 1
lg = legend([h1 h2],'DNS','HM');
set(lg,'FontSize',20,'interpreter','latex')
legend boxoff 

end

if iSel == nSels
   xlabel('$\xi^{\rm{d}}/L_{\rm{tot}}$ [-]', 'FontName','Times New Roman','FontSize',20,'interpreter','latex') 
end
% title([num2str(round(selFreq,4)) 'Hz'],'FontName','Times New Roman','FontSize',20,'interpreter','latex')

end

end