%-------------------------------------------------------------------------%
% Background
% Compute and plot the frequency response functions of interest by both
% homogenization method and direct numerical simulation
% Created by Lei, TU/e, 2018
%-------------------------------------------------------------------------%

function [FR, FRDNS] = funFRF(namePanel,nCell,numL,FR,selCell,keyFR,uAmp,sizeFR)

selXID = selCell/nCell*numL;         % interested position
nSels = length(selXID);
Uin = uAmp;         % input amplitude
nSamples = length(FR.freq);

% initialize
FR.FRF = zeros(nSels,nSamples);  % frequency response function by homogenization method         

FRDNS.freq = FR.freq;
FRDNS.FRF = zeros(nSels,nSamples); % frequency response function by direct numerical simulation

for iSel = 1:nSels

% compute the selected frequency response functions 
for iSample = 1:nSamples 
Uout = interp1(FR.XID,abs(FR.U(keyFR:2:end,iSample)),selXID(iSel));
FR.FRF(iSel,iSample) = Uout/Uin;

end

% read data from direct numerical simulation 
dataInDNS = textread(['DNS/' namePanel '/frResponseDNS_in_' namePanel '.txt'], '', 'headerlines', 8);
dataOutDNS = textread(['DNS/' namePanel '/frResponseDNS_out_' num2str(selCell(iSel)) '_' namePanel '.txt'], '', 'headerlines', 8);

FRDNS.FRF(iSel,:) = interp1((dataInDNS(:,1))',(dataOutDNS(:,2)./dataInDNS(:,2))',FRDNS.freq);

figure
set(gcf,'Units','centimeters','Position',sizeFR);
box on
hold on
h1 = plot(10*log10(FRDNS.FRF(iSel,:)),FRDNS.freq/1000,'b-','linewidth',3);
h2 = plot(10*log10(FR.FRF(iSel,:)),FR.freq/1000,'r:','linewidth',3);

xlabel('$U_{\rm{out}}/U_{\rm{in}}$ [dB]','FontName','Times New Roman','FontSize',20,'interpreter','latex');
ylabel('$f$ [kHz]', 'FontName','Times New Roman','FontSize',20,'interpreter','latex')

set(gca,'FontName','Times New Roman','FontSize',20,'XMinorTick','on','YMinorTick','on')
lg = legend([h1 h2],'DNS','HM');
set(lg,'FontSize',20,'interpreter','latex')
legend boxoff 

end



end
