%-------------------------------------------------------------------------%
% Background
% Compute basis functions recursively
% Plot the basis functions
% Created by Lei, TU/e, 2018
%-------------------------------------------------------------------------%

function [Nd, dNd, dNd2] = funBasis(knot,cpXiD,n,m,p,nxiP,keyN,sizeNp,sizeNd)

% define symbolic variables
syms xiP xiD L

% initialize
originN = eye(n+p);    % between xiP(i) and xiP(i+1)
currentN = originN;
nextN = zeros(n+p,n+p) * xiP;
Nset = cell(p,1);

% construct the basis functions on the parameter domain
for ip = 1:p
    
    % order
    pp = ip;
for i = 1:n
   
    if knot(i+pp) > knot(i)
    B1 = (xiP-knot(i))/(knot(i+pp)-knot(i));
    else
        B1 = 0;
    end
    if knot(i+pp+1) > knot(i+1)
    B2 = (knot(i+pp+1)-xiP)/(knot(i+pp+1)-knot(i+1));
    else
        B2 = 0;
    end
    
    for j = 1:length(currentN)
    nextN(i,j) = B1*currentN(i,j) + B2*currentN(i+1,j);
    end
    
end

currentN = nextN;
Nset{pp} = currentN;

end

% pick up useful pieces
Np = Nset{p}(1:n,(1+p:m+p));    

% construct the basis functions on the physical domain
Nd = subs(Np,{xiP},m/L*xiD);
dNd = diff(Nd,xiD,1);
dNd2 = diff(Nd,xiD,2);


%-------------------------------------------------------------------------%
if keyN ~=0;
XIP = zeros(m,nxiP);
XID = zeros(m,nxiP);
numcpXiD = double(subs(cpXiD,{L},1));

for i = 1:m
    XIP(i,:) = linspace(i-1,i,nxiP);

end

Col = (0.75*[0:n-1]/n)';
Col = repmat(Col,1,3);

figure
set(gcf,'Units','centimeters','Position',sizeNp);

% plot Np
subplot(2,1,1)
box on
hold on

for j = 1:m
    for i = j:n   
        numNp = double(subs(Np(i,j),{xiP},XIP(j,:)));
        plot(XIP(j,:),numNp,'-','color',Col(i,:),'linewidth',3)
        
        XID(j,:) = XID(j,:) + numNp*numcpXiD(i);
    end

end

ylabel('$N_{3}^{\rm{p}}$ [-]', 'FontName','Times New Roman','FontSize',20,'interpreter','latex')
set(gca,'FontName','Times New Roman','FontSize',20,'XMinorTick','on','YMinorTick','on')

% plot the mapping xiD(xiP)
subplot(2,1,2)
box on
hold on
for j = 1:m
    plot(XIP(j,:),XID(j,:),'-','color','r','linewidth',3)
end

for i = 1:n
plot(numcpXiD(i)*m,numcpXiD(i),'o','linewidth',3,...
    'MarkerEdgeColor','none','MarkerFaceColor',Col(i,:),'MarkerSize',9)
end

ylabel('$\xi^{\rm{d}}/L_{\rm{tot}}$ [-]', 'FontName','Times New Roman','FontSize',20,'interpreter','latex')
xlabel('$\xi^{\rm{p}}$ [-]', 'FontName','Times New Roman','FontSize',20,'interpreter','latex')
set(gca,'FontName','Times New Roman','FontSize',20,'XMinorTick','on','YMinorTick','on')

end

if keyN ~=0
% plot Nd
figure
set(gcf,'Units','centimeters','Position',sizeNd);

subplot(3,1,1)
box on
hold on
for j = 1:m
    for i = j:n  
        numNd = double(subs(Nd(i,j),{xiD, L},{XID(j,:),1}));
        plot(XID(j,:),numNd,'-','color',Col(i,:),'linewidth',3)

    end

end
ylabel('$N_{3}^{\rm{d}}$ [-]', 'FontName','Times New Roman','FontSize',20,'interpreter','latex')
set(gca,'FontName','Times New Roman','FontSize',20,'XMinorTick','on','YMinorTick','on')

% plot dNd

subplot(3,1,2)
box on
hold on
for j = 1:m
    for i = j:n  
        numdNd = double(subs(dNd(i,j),{xiD, L},{XID(j,:),1}));
        plot(XID(j,:),numdNd,'-','color',Col(i,:),'linewidth',3)

    end

end
ylabel('$\nabla_{\xi^{\rm{d}}}N_{3}^{\rm{d}}\cdot{L_{\rm{tot}}}$ [-]', 'FontName','Times New Roman','FontSize',20,'interpreter','latex')
set(gca,'FontName','Times New Roman','FontSize',20,'XMinorTick','on','YMinorTick','on')

% plot dNd2
subplot(3,1,3)
box on
hold on
for j = 1:m
    for i = j:n  
        numdNd2 = double(subs(dNd2(i,j),{xiD, L},{XID(j,:),1}));
        plot(XID(j,:),numdNd2,'-','color',Col(i,:),'linewidth',3)

    end

end
ylabel('$\Delta_{\xi^{\rm{d}}}N_{3}^{\rm{d}}\cdot{L^2_{\rm{tot}}}$ [-]', 'FontName','Times New Roman','FontSize',20,'interpreter','latex')
xlabel('$\xi^{\rm{d}}/L_{\rm{tot}}$ [-]', 'FontName','Times New Roman','FontSize',20,'interpreter','latex')
set(gca,'FontName','Times New Roman','FontSize',20,'XMinorTick','on','YMinorTick','on')
end
%-------------------------------------------------------------------------%

end