%-------------------------------------------------------------------------%
% Background
% Compute the steady-state displacement fields at various frequencies
% Created by Lei, TU/e, 2018
%-------------------------------------------------------------------------%

function [FR, numNd] = compFR(FR,Nd,K,M,cpDofs,totDofs,presDofs,freeDofs,aUPres,elemXID,numL)

syms xiD L

nSamples = length(FR.freq);             % sampling number

% remove repeated values
nXID = numel(elemXID);
XID = reshape(elemXID',nXID,1);

[~, uniID] = unique(XID);    
FR.XID = XID(uniID);

% initialize
cpDof = length(cpDofs);
FR.cpaU = zeros(cpDof,nSamples);               % coefficient on each control point
FR.U = zeros(2*length(uniID),nSamples);        % steady-state displacement field

%-------------------------------------------------------------------------%
tfr1 = clock;
for iSample = 1:nSamples
omega = FR.freq(iSample)*2*pi;                 % angular frequency

% compute the dynamic stiffness
Kdyn = K-omega^2*M;

% resultants on the free control points, only on two ends, aU = U, aF = F due to 
% partition of unity of the basis functions
aRFree = zeros(size(freeDofs));     % take both aF and aM into account

KFF = Kdyn(freeDofs,freeDofs);
KFP = Kdyn(freeDofs,presDofs);

% compute the coefficients
aU = zeros(size(totDofs));
aU(presDofs) = aUPres;

aRFreeEff = aRFree-KFP*aUPres;
aAtFree = KFF\aRFreeEff;
aU(freeDofs) = aAtFree;

FR.cpaU(:,iSample) = aU(cpDofs);

end

tfr2 = clock;
FR.dtfr = etime(tfr2,tfr1);                                                 % computation time for the frequency response analysis

%-------------------------------------------------------------------------%

% compute the whole steady-state displacement field (can be complex)
% compute numerical Nd in advance
numNd = cell(size(Nd));
for jN = 1:size(Nd,2)
    for iN = jN:size(Nd,1)
            numNd{iN,jN} = double(subs(Nd(iN,jN),{xiD,L},{elemXID(jN,:),numL}));
 
    end
end

for iSample = 1:nSamples 
cpaUip = FR.cpaU(1:2:end,iSample);
cpaUop = FR.cpaU(2:2:end,iSample);

elemUip = zeros(size(elemXID));
elemUop = zeros(size(elemXID));

for jN = 1:size(numNd,2)
    for iN = jN:size(numNd,1)       
        elemUip(jN,:) = elemUip(jN,:) + numNd{iN,jN}*cpaUip(iN);
        elemUop(jN,:) = elemUop(jN,:) + numNd{iN,jN}*cpaUop(iN);
    end

end

% reassemble as arrays
Uip = reshape(elemUip',nXID,1);
Uop = reshape(elemUop',nXID,1);

% remove the repeated values
FR.U(1:2:end,iSample) = Uip(uniID);
FR.U(2:2:end,iSample) = Uop(uniID);

end


end