%-------------------------------------------------------------------------%
% Background
% Compute the free eigenfrequencies and modes
% Created by Lei, TU/e, 2018
%-------------------------------------------------------------------------%

function EA = compEA(EA,K,M,freeDofs)

% perform eigenfrequency analysis
Kff = K(freeDofs,freeDofs);
Mff = M(freeDofs,freeDofs);

% solve the eigenvalue problem
[~, Omega2] = eigs(Kff,Mff,EA.nMode,'sm'); 
Freq = abs(sqrt(diag(Omega2)))/2/pi;

% sort the frequencies
EA.freq = sort(Freq);

end