%-------------------------------------------------------------------------%
% Background
% Plot the omega-k form dispersion spectrum
% Created by Lei, TU/e, 2018
%-------------------------------------------------------------------------%

function [axesPos1, axesPos2]= funSpectrumOmega(Nset,omegaBA,omegaHDA,sizeOmega,axesPos)

figure
set(gcf,'Units','centimeters','Position',sizeOmega)

% dispersion spectrum
axesPos1 = axesPos;
axesPos1(1) = axesPos(1)*2/3;
axesPos1(3) = axesPos(3)*2/3;
axes('position',axesPos1);
hold on
box on

if Nset.method(1) == 1

% Bloch analysis (omega-k, for reference)
% propagative
for iBA = 1:Nset.nB
    % real wave number
    HomegaBAP = plot(real(omegaBA.Normk(:,iBA)),omegaBA.Freq/1000,'bo','linewidth',3,...
    'MarkerEdgeColor','none','MarkerFaceColor','b','MarkerSize',3);  % body or flexural wave
    % imaginary wave number
    plot(-imag(omegaBA.Normk(:,iBA)),omegaBA.Freq/1000,'bo','linewidth',3,...
    'MarkerEdgeColor','none','MarkerFaceColor','b','MarkerSize',3);  % body or flexural wave
end

% evanescent
for iBA = 1:Nset.nB
    % real wave number
    HomegaBAE =plot(real(omegaBA.Normk(:,Nset.nB+iBA)),omegaBA.Freq/1000,'co','linewidth',3,...
    'MarkerEdgeColor','none','MarkerFaceColor','c','MarkerSize',3);  % body or flexural wave
    % imaginary wave number
    plot(-imag(omegaBA.Normk(:,Nset.nB+iBA)),omegaBA.Freq/1000,'co','linewidth',3,...
    'MarkerEdgeColor','none','MarkerFaceColor','c','MarkerSize',3);  % body or flexural wave
    
end

end

% Homogenization
% propagative
for iHDA = 1:Nset.nB
    % real wave number
    HomegaHDAP = plot(real(omegaHDA.Normk(:,iHDA)),omegaHDA.Freq/1000,'ro','linewidth',3,...
    'MarkerEdgeColor','none','MarkerFaceColor','r','MarkerSize',3);  % body or flexural wave
    % imaginary wave number
    plot(-imag(omegaHDA.Normk(:,iHDA)),omegaHDA.Freq/1000,'ro','linewidth',3,...
    'MarkerEdgeColor','none','MarkerFaceColor','r','MarkerSize',3);  % body or flexural wave
end

% evanescent
for iHDA = 1:Nset.nB
    % real wave number
    HomegaHDAE = plot(real(omegaHDA.Normk(:,Nset.nB+iHDA)),omegaHDA.Freq/1000,'mo','linewidth',3,...
    'MarkerEdgeColor','none','MarkerFaceColor','m','MarkerSize',3);  % body or flexural wave
    % imaginary wave number
    plot(-imag(omegaHDA.Normk(:,Nset.nB+iHDA)),omegaHDA.Freq/1000,'mo','linewidth',3,...
    'MarkerEdgeColor','none','MarkerFaceColor','m','MarkerSize',3);  % body or flexural wave
    
end

xlim([-1 1]);
set(gca,'xtick', [-1 -0.5 0 0.5 1], 'xticklabel', [1 0.5 0 0.5 1]);
xlabel('${\rm{Im}}(k{\lambda^{\rm{lim}}}/{2\pi})$ [-]\quad\qquad${\rm{Re}}(k{\lambda^{\rm{lim}}}/{2\pi})$ [-]','FontName','Times New Roman','FontSize',20,'interpreter','latex');
ylabel('$f$ [kHz]','FontName','Times New Roman','FontSize',20,'interpreter','latex');

set(gca,'FontName','Times New Roman','FontSize',20,'XMinorTick','on','YMinorTick','on');

if Nset.method(1) == 1
lg = legend([HomegaBAP, HomegaBAE, HomegaHDAP, HomegaHDAE],'BA-PROP','BA-EVAN','HM-PROP','HM-EVAN');
set(lg,'FontSize',20,'interpreter','latex')
legend boxoff 
end

% phase 
axesPos2 = axesPos1;
axesPos2(1) = axesPos1(3)+axesPos(1);
axesPos2(3) = axesPos(3)*1/3;
axes('position',axesPos2);

hold on
box on

if Nset.method(1) == 1
% Bloch analysis (omega-k, for reference)
% propagative
for iBA = 1:Nset.nB
    % real wave number
    plot(angle(omegaBA.Normk(:,iBA)),omegaBA.Freq/1000,'bo','linewidth',3,...
    'MarkerEdgeColor','none','MarkerFaceColor','b','MarkerSize',3);  % body or flexural wave
end

% evanescent
for iBA = 1:Nset.nB
    plot(angle(omegaBA.Normk(:,Nset.nB+iBA)),omegaBA.Freq/1000,'co','linewidth',3,...
    'MarkerEdgeColor','none','MarkerFaceColor','c','MarkerSize',3);  % body or flexural wave
    
end

end

% Homogenization
% propagative
for iHDA = 1:Nset.nB
    % real wave number
    plot(angle(omegaHDA.Normk(:,iHDA)),omegaHDA.Freq/1000,'ro','linewidth',3,...
    'MarkerEdgeColor','none','MarkerFaceColor','r','MarkerSize',3);  % body or flexural wave
end

% evanescent
for iHDA = 1:Nset.nB
    plot(angle(omegaHDA.Normk(:,Nset.nB+iHDA)),omegaHDA.Freq/1000,'mo','linewidth',3,...
    'MarkerEdgeColor','none','MarkerFaceColor','m','MarkerSize',3);  % body or flexural wave
    
end

xlim([0 pi/2]);
set(gca,'xtick', [0  pi/2], 'xticklabel', {'0', '\pi/2'});
xlabel('$${\rm{Ang}}(k{\lambda^{\rm{ref}}}/{2\pi})$ [-]','FontName','Times New Roman','FontSize',20,'interpreter','latex');

set(gca,'FontName','Times New Roman','FontSize',20,'XMinorTick','on','YMinorTick','on');



end