%-------------------------------------------------------------------------%
% Background
% Plot the k-omega form dispersion spectrum
% Created by Lei, TU/e, 2018
%-------------------------------------------------------------------------%

function axesPos = funSpectrumK(Nset,kBA,kHDA,sizeK)

figure
set(gcf,'Units','centimeters','Position',sizeK);

hold on
box on

% Bloch analysis (k-omega, for reference)
for iMode = 1:size(kBA.Freq,1)
    HkBA = plot(kBA.Normk,kBA.Freq(iMode,:)/1000,'b-','linewidth',3);
%     patch([kBA.Normk nan],[kBA.Freq(iMode,:) nan],[kBA.Freq(iMode,:) nan],'linewidth',3,'edgecolor','interp')
end

% computational homogenization (complete k-omega)
for iMode = 1:size(kHDA.Freq,1)
    HkHDA = plot(kHDA.Normk,kHDA.Freq(iMode,:)/1000,'r:','linewidth',3);
%     HkHDA = plot(kHDA.Normk,kHDA.Freq(iMode,:)/1000,'ro','linewidth',1,'MarkerEdgeColor','r','MarkerFaceColor','none','MarkerSize',6);
end

xlim([0 1]);
ylim([0 Nset.freqLim/1000])
set(gca,'xtick', [0 0.5 1], 'xticklabel', [0 0.5 1]);

xlabel('$k{\lambda^{\rm{ref}}}/{2\pi}$ [-]','FontName','Times New Roman','FontSize',20,'interpreter','latex');
ylabel('$f$ [kHz]','FontName','Times New Roman','FontSize',20,'interpreter','latex');

lg = legend([HkBA, HkHDA],'BA','HM');
set(lg,'FontSize',20,'interpreter','latex')
legend boxoff 

set(gca,'FontName','Times New Roman','FontSize',20,'XMinorTick','on','YMinorTick','on')

axesHandle = findobj(gcf,'Type','axes');
axesPos = get(axesHandle,'Position');


end