%-------------------------------------------------------------------------%
% Background
% Plot the modes
% Created by Lei, TU/e, 2017
%-------------------------------------------------------------------------%
function funPlotModes(coords,elems,UM,ModeSel,Size,keyArrow,keyAll,matrixNodes)

% preparation
nElems = size(elems,1);
ampDisp = 0.75;          % amplitude of the displacement arrow

% ModeSel = config(3);

Xmin = min(coords(:,1));
Xmax = max(coords(:,1));
Ymin = min(coords(:,2));
Ymax = max(coords(:,2));
fRange = 1.15;

for iMode = ModeSel
    
    % normalization
    Umode = real(UM(:,iMode));
    Unorm = sqrt(Umode(1:2:end).^2 + Umode(2:2:end).^2);
    Uamp = max(Unorm);
    Unorm = Unorm / Uamp;     
    
%     subplot(config(1),config(2),iMode)
    figure
    hold on
                    
    for iElem =1:nElems
         elemNode = elems(iElem,:);

         nodeZone = [elemNode elemNode(1)];
         fill(coords(nodeZone,1),coords(nodeZone,2),Unorm(nodeZone),'EdgeColor','none');
         
    end

    % plot mode direction
    if keyArrow == 1 
        Um = [Umode(1:2:end) Umode(2:2:end)];       % modal displacements
        Um = Um./repmat(Unorm,1,2);
        
        if isequal(keyAll,'Inclusion')
            Um(matrixNodes==1,:) = 0;
        end
        
        quiver(coords(:,1),coords(:,2),Um(:,1),Um(:,2),ampDisp,'k-','linewidth',2);
        
    end
    
    xlim([Xmin Xmax]*fRange);
    ylim([Ymin Ymax]*fRange);
    axis equal
    axis off
    set(gca,'xtick',[])
    set(gca,'ytick',[])
    colormap('jet')
    caxis([0 1]);
    set(gcf,'Units','centimeters','Position',Size);
    
end



% colormap('jet')
% caxis([0 1]);
% hbar = colorbar;
% set(hbar, 'FontSize', 20, 'FontName','Times New Roman','FontSize',20);
% set(hbar, 'Position', [0.94 0.145 0.015 0.725]);
% set(hbar, 'ytick', [0 1], 'yticklabel',[0 1]);

