%-------------------------------------------------------------------------%
% Background
% Plot the dynamic effective properties
% Created by Lei, TU/e, 2018
%-------------------------------------------------------------------------%

function funDynProp(HM,omegaHDA,sizeRho,sizeC,Col)

% mass density
% rhoEll
figure
set(gcf,'Units','centimeters','Position',sizeRho)
hold on
box on

% only 11 and 22 components are interested in
for n = 1:2
    plot(omegaHDA.dynP.rhoEll(:,n)/HM.rhoM.ll(n,n),omegaHDA.Freq/1000,'ko','linewidth',1,'MarkerEdgeColor','none','MarkerFaceColor',Col(n,:),'MarkerSize',3)
    
end

xlabel('${\rho_{\rm{\Omega}}^{\rm{ll}}}/{\rho_{\rm{M}}^{\rm{ll}}}$ [-]','FontName','Times New Roman','FontSize',20,'interpreter','latex');
ylabel('$f$ [kHz]','FontName','Times New Roman','FontSize',20,'interpreter','latex');
xlim([-10 10]);

set(gca,'FontName','Times New Roman','FontSize',20,'XMinorTick','on','YMinorTick','on')

lg = legend('11','22');
set(lg,'FontSize',20,'interpreter','latex')
legend boxoff 

% elasticity
figure
set(gcf,'Units','centimeters','Position',sizeC)

% CEmm
subplot(1,3,1)
box on
plot(omegaHDA.dynP.CEmm/HM.CM.mm,omegaHDA.Freq/1000,'ko','linewidth',1,'MarkerEdgeColor','none','MarkerFaceColor','k','MarkerSize',3)

xlabel('${C_{\rm{\Omega}}^{\rm{mm}}}/{C_{\rm{M}}^{\rm{mm}}}$ [-]','FontName','Times New Roman','FontSize',20,'interpreter','latex');
ylabel('$f$ [kHz]','FontName','Times New Roman','FontSize',20,'interpreter','latex');
xlim([-5 5]);

set(gca,'FontName','Times New Roman','FontSize',20,'XMinorTick','on','YMinorTick','on')

% corrected CEbb, as CEbbC(1)
subplot(1,3,2)
box on
hold on
plot(real(omegaHDA.dynP.CEbbC(:,1))/HM.CM.bb,omegaHDA.Freq/1000,'ko','linewidth',1,'MarkerEdgeColor','none','MarkerFaceColor',Col(1,:),'MarkerSize',3)
plot(imag(omegaHDA.dynP.CEbbC(:,1))/HM.CM.bb,omegaHDA.Freq/1000,'ko','linewidth',1,'MarkerEdgeColor','none','MarkerFaceColor',Col(2,:),'MarkerSize',3)
set(gca,'FontName','Times New Roman','FontSize',20,'XMinorTick','on','YMinorTick','on')
xlabel('${C_{\rm{\Omega}}^{\rm{bb,+}}}/{C_{\rm{M}}^{\rm{bb}}}$ [-]','FontName','Times New Roman','FontSize',20,'interpreter','latex');
xlim([-5 5]);

lg = legend('${\rm{Re}}$','${\rm{Im}}$');
set(lg,'FontSize',20,'interpreter','latex')
legend boxoff 

% corrected CEbb, as CEbbC(2)
subplot(1,3,3)
box on
hold on
plot(real(omegaHDA.dynP.CEbbC(:,2))/HM.CM.bb,omegaHDA.Freq/1000,'ko','linewidth',1,'MarkerEdgeColor','none','MarkerFaceColor',Col(1,:),'MarkerSize',3)
plot(imag(omegaHDA.dynP.CEbbC(:,2))/HM.CM.bb,omegaHDA.Freq/1000,'ko','linewidth',1,'MarkerEdgeColor','none','MarkerFaceColor',Col(2,:),'MarkerSize',3)
set(gca,'FontName','Times New Roman','FontSize',20,'XMinorTick','on','YMinorTick','on')
xlabel('${C_{\rm{\Omega}}^{\rm{bb,-}}}/{C_{\rm{M}}^{\rm{bb}}}$ [-]','FontName','Times New Roman','FontSize',20,'interpreter','latex');
xlim([-5 5]);

lg = legend('${\rm{Re}}$','${\rm{Im}}$');
set(lg,'FontSize',20,'interpreter','latex')
legend boxoff 

end