%-------------------------------------------------------------------------%
% Background
% Plot the characteristic coefficients
% Created by Lei, TU/e, 2018
%-------------------------------------------------------------------------%

function [refDeltabo, refDeltafl] = funCharCoef(HM,omegaHDA,sizeR)

figure
set(gcf,'Units','centimeters','Position',sizeR)

% Rbo
subplot(1,2,1)
box on
refDeltabo =  4*(omegaHDA.Freq*2*pi).^2.*HM.CM.mm*HM.rhoM.ll(1,1); % reference value for nondimensionalization
plot(omegaHDA.Delta.bo./refDeltabo,omegaHDA.Freq/1000,'ko','linewidth',1,'MarkerEdgeColor','none','MarkerFaceColor','k','MarkerSize',3);

xlabel('$\delta^{\rm{bo}}/(4\omega^2{C_{\rm{M}}^{\rm{mm}}}{\rho_{\rm{M,11}}^{\rm{ll}}})$ [-]','FontName','Times New Roman','FontSize',20,'interpreter','latex');
ylabel('$f$ [kHz]','FontName','Times New Roman','FontSize',20,'interpreter','latex');
xlim([-10 10]);

set(gca,'FontName','Times New Roman','FontSize',20,'XMinorTick','on','YMinorTick','on')

% Rfl
subplot(1,2,2)
box on
refDeltafl = 4*(omegaHDA.Freq*2*pi).^2.*HM.CM.bb*HM.rhoM.ll(2,2);
plot(omegaHDA.Delta.fl./refDeltafl,omegaHDA.Freq/1000,'ko','linewidth',1,'MarkerEdgeColor','none','MarkerFaceColor','k','MarkerSize',3);

xlabel('$\delta^{\rm{fl}}/(4\omega^2{C_{\rm{M}}^{\rm{bb}}}{\rho_{\rm{M,22}}^{\rm{ll}}})$ [-]','FontName','Times New Roman','FontSize',20,'interpreter','latex');
ylabel('$f$ [kHz]','FontName','Times New Roman','FontSize',20,'interpreter','latex');
xlim([-10 10]);

set(gca,'FontName','Times New Roman','FontSize',20,'XMinorTick','on','YMinorTick','on')