# Data underlying the publication: Spatial Parameters for Circular Construction Hubs

This dataset contains the results for a journal paper titled "Spatial Parameters for Circular Construction Hubs: Location Criteria for a Circular Built Environment" published in the journal Circular Economy and Sustainability (see paper [here](https://link.springer.com/article/10.1007/s43615-023-00285-y)). For this research, we reviewed policy documents and interviewed exports to identify the spatial parameters (or location requirements) for circular construction hubs, which are facilities that collect, store, and redistribute construction waste as secondary resources. The files included document the research process and results:

## Files included in the repository:

1. `interview transcripts.docx` - Transcripts from expert interviews, including color-coded highlights that categorize different types of spatial requirements.

2. `interview questions.docx` - A comprehensive list of questions asked during the semi-structured interviews. These served as the framework for discussions and eliciting expert opinions.

3. `spatial params and analysis methods.xlsx` - An Excel workbook with research results showcasing the spatial parameters and potential spatial analysis methods that could aid in identifying future locations of circular construction hubs in the Netherlands. The workbook is divided into two sheets:
    - `spatial parameters for circular hubs` - A list of detailed spatial parameters for each type of circular hub.
    - `spatial data and analysis required` - A list of the spatial data and analysis methods needed to identify suitable locations for circular hubs in the Netherlands.

## Usage

To access the data, download the entire repository as a ZIP file. After extracting the files, you will have full access to all documents. Please ensure you have the necessary software (Microsoft Office or equivalent) to view these documents.

## Citation

If you use this data or code in your own work, please cite [our paper](https://link.springer.com/article/10.1007/s43615-023-00285-y).

## Contact

For any questions or issues related to the data, please contact the corresponding author, Tanya Tsui, at t.p.y.tsui@tudelft.nl. 

## License

This work is licensed under a Creative Commons Attribution 4.0 International License. For more details, see the LICENSE file in this repository.