# SHEAROT 4TUResearch
This archive contains the post-processed data of the simulations presented in:  

R. Hartmann, G.S. Yerragolam, R. Verzicco, D. Lohse & R.J.A.M. Stevens, 2023, 
Optimal heat transport in rotating Rayleigh-Bénard convection at large Rayleigh 
numbers, PRF 8, 083501.

https://doi.org/10.1103/PhysRevFluids.8.083501

################################################################################
## LICENCE

Data are published under a CC BY 4.0 licence: 
https://creativecommons.org/licenses/by/4.0/  
Any spreading or reuse of the Data can and must reference the corresponding 
publication (https://doi.org/10.1103/PhysRevFluids.8.083501).

################################################################################


################################################################################
## ARCHIVE FILE STRUCTURE

The archive contains:  

./README.md  

./Averages.h5  
./Averages_YANG20.h5  
./Tgrad_bulk.h5  
./Tgrad_bulk_YANG20.h5  
./BLdata.h5  
./BLdata_YANG20.h5  
./KrtUz.h5
./KrtUz_YANG20.h5
./DissipGL.h5
./DissipGL_YANG20.h5

./NuRe_TimeSeries.tar.gz  

################################################################################


################################################################################
## DATA FILES POST-PROCESSING (Figures 2-4, 7-10, S1,S2,S4)

Averages*.h5 : HDF5 data cubes containing time-averaged Nusselt and Reynolds 
               numbers of new DNSs (Averages.h5) and Yang et al. (PRF,2020) DNSs 
               (Averages_YANG20.h5). Include:

  /Pr_vals  -> Prandtl numbers along 1st axis of the data matrix  
  /Ra_vals  -> Rayleigh numbers along 2nd axis  
  /Ro_vals  -> Rossby numbers along 3rd axis 

  /av_data  -> Data matrix structured as:
               [ Pr_idx , Ra_idx , Ro_idx , q_idx ]  

               Pr_idx     : Prandtl number   of DNS as in Pr_vals
               Ra_idx     : Rayleigh number  of DNS as in Ra_vals
               Ro_idx     : Rossby number    of DNS as in Ro_vals

               q_idx sets the quantity of interest:
               q_idx=0 : Start time of averaging  
               q_idx=1 : Flow time of averaging  
               q_idx=2 : Nusselt number Nu_TB from average over top and bottom
                         plates
               q_idx=3 : Error between Nu_top and Nu_bot: 
                         abs(Nu_top-Nu_bot)/Nu_TB
               q_idx=4 : Nusselt number Nu_TB over the 2nd half of average 
                         interval  
               q_idx=5 : Nusselt number Nu_V from average over the volume
               q_idx=6 : Reynolds number in horizontal X direction
               q_idx=7 : Reynolds number in horizontal Y direction 
               q_idx=8 : Reynolds number in vertical   Z direction
               q_idx=9 : Total Reynolds number
               q_idx=10: Friction Reynolds number Re_tau from average over top 
                         and bottom plate 

               Parameter combinations (Pr,Ra,Ro) without a DNS contain NaN's.

--------------------------------------------------------------------------------

Tgrad_bulk*.h5 : HDF5 data cubes containing the vertical bulk gradient of time- 
                 and horizontally-averaged temperature of new DNSs(Tgrad_bulk.h5)
                 and Yang et al. (PRF,2020) DNSs(Tgrad_bulk_YANG20.h5). Include:

  /Pr_vals  -> Prandtl numbers along 1st axis of the data matrix  
  /Ra_vals  -> Rayleigh numbers along 2nd axis  
  /Ro_vals  -> Rossby numbers along 3rd axis 
  /z_bulk   -> Vertical portion around mid-height considered as the "bulk" 
               along 4th axis  
               ( z_bulk[0]=0.2  : bulk=0.2 <z<0.8  )  
               ( z_bulk[1]=0.45 : bulk=0.45<z<0.55 )  

  /Tgrad_data -> Data matrix of the mean vertical temperature gradient in the 
                 bulk, structured as:
               [ Pr_idx , Ra_idx , Ro_idx , z_bulk_idx ]  

               Pr_idx     : Prandtl number   of DNS as in Pr_vals
               Ra_idx     : Rayleigh number  of DNS as in Ra_vals
               Ro_idx     : Rossby number    of DNS as in Ro_vals
               z_bulk_idx : Bulk portion as in z_bulk

               Parameter combinations (Ro,Gamma,Ra) without a DNS contain NaN's.

--------------------------------------------------------------------------------

BLdata*.h5   : HDF5 data cubes containing the boundary layer thicknesses (based 
               on different quantities) of new DNSs (BLdata.h5) and Yang et al. 
               (PRF,2020) DNSs (BLdata_YANG20.h5). Include:

  /Pr_vals  -> Prandtl numbers along 1st axis of the data matrix  
  /Ra_vals  -> Rayleigh numbers along 2nd axis  
  /Ro_vals  -> Rossby numbers along 3rd axis 

  /BL_data  -> Data matrix of the BL thicknesses, structured as:
               [ Pr_idx, Ra_idx , Ro_idx , q_idx , tb_idx ]  

               Pr_idx     : Prandtl number   of DNS as in Pr_vals
               Ra_idx     : Rayleigh number  of DNS as in Ra_vals
               Ro_idx     : Rossby number    of DNS as in Ro_vals

               q_idx selects between different BL quantities:
               q_idx=0  : Thermal BL thickness estimated via the peak location 
                          (3pt-fit) of the variance profile of time- and 
                          laterally-averaged temperature
               q_idx=1  : Thermal BL thickness estimated via the slope method
                          on time- and horizontally-averaged temperature profile
                          (details in e.g., Stevens et al., PF 22, 2010)
               q_idx=2  : Kinetic BL thickness estimated via the peak location 
                          (3pt-fit) of the RMS profile of time- and 
                          laterally-averaged lateral velocity
               q_idx=3  : Shear BL thickness estimated via the slope method on 
                          time- and horizontally-averaged (RMS) profile of the 
                          horizontal velocity (details in e.g., Wagner et al., 
                          JFM 697, 2012)
               q_idx=4  : Gradient of the horizontal RMS velocity at the plates
                          (dU_H / dz)|_z={0,1}
               q_idx=5  : Peak value U_V of the horizontal RMS velocity (at peak 
                          location of q_idx=2)

               tb_idx sets the BL(s) considered for the calculation:
               tb_idx=0 : Bottom BL only
               tb_idx=1 : Top BL only
               tb_idx=2 : Average from Bottom and Top BL

               Note that U_V/(dU_H/dz) is the shear BL thickness (slope method),
               i.e, (q_idx=5)/(q_idx=4) = (q_idx=3)
               Parameter combinations (Ro,Gamma,Ra) without a DNS contain NaN's.

--------------------------------------------------------------------------------

KrtUz*.h5    : HDF5 data cubes containing the Kurtosis of the vertical velocity 
               of new DNSs (KrtUz.h5) and Yang et al. (PRF,2020) DNSs 
               (KrtUz_YANG20.h5). Include:

  /Pr_vals  -> Prandtl numbers along 1st axis of the data matrix  
  /Ra_vals  -> Rayleigh numbers along 2nd axis  
  /Ro_vals  -> Rossby numbers along 3rd axis 

  /Krt_data -> Data matrix of Kurtosis values of vertical velocity, structured as:
               [ Pr_idx , Ra_idx , Ro_idx , zloc_idx ]  

               Pr_idx     : Prandtl number   of DNS as in Pr_vals
               Ra_idx     : Rayleigh number  of DNS as in Ra_vals
               Ro_idx     : Rossby number    of DNS as in Ro_vals

               zloc_idx defines the vertical position of Kurtosis value
               zloc_idx=0 : at mid-height (z=0.5)
               zloc_idx=1 : at  BL-height (z=\lambda_u, BLdata.h5 q_idx=2)

               Parameter combinations (Ro,Gamma,Ra) without a DNS contain NaN's.

--------------------------------------------------------------------------------

DissipGL*.h5 : HDF5 data cubes containing dissipation rates and BL/bulk 
               fractions of new DNSs(DissipGL.h5)and Yang et al. (PRF,2020) DNSs
               (DissipGL_YANG20.h5). Include:

  /Pr_vals  -> Prandtl numbers along 1st axis of the data matrix  
  /Ra_vals  -> Rayleigh numbers along 2nd axis  
  /Ro_vals  -> Rossby numbers along 3rd axis 

  /DissipGL_data -> Data matrix of the dissipation rates, structured as:
               [ Pr_idx , Ra_idx , Ro_idx , q_idx , f_idx ]  

               Pr_idx     : Prandtl number   of DNS as in Pr_vals
               Ra_idx     : Rayleigh number  of DNS as in Ra_vals
               Ro_idx     : Rossby number    of DNS as in Ro_vals

               q_idx selects between thermal and kinetic dissipation rates:
               q_idx=0  : Kinetic dissipation rates
               q_idx=1  : Thermal dissipation rates

               f_idx selects between the total rates and BL or bulk portions:
               f_idx=0  : Total (kinetic or thermal) dissipation rate (eps_tot)
               f_idx=1  : BL portion   (eps_BL/eps_tot)
               f_idx=2  : bulk portion (eps_bulk/eps_tot)

               Parameter combinations (Ro,Gamma,Ra) without a DNS contain NaN's.

################################################################################


################################################################################
## DATA FILES TEMPORAL RAW DATA

The (sub-)archive NuRe_TimeSeries.tar.gz contains the time series of Nusselt and
Reynolds numbers per conducted DNS. It is structured as follows:  

./PrandtlNumber/RayleighNumber/RossbyNumber/*.out

--------------------------------------------------------------------------------

nu_vol.out   : Nusselt number based on volume average

              -Col1: Flow time
              -Col2: Nu_Vol = 1 + (PrRa)^(1/2)*<u_z*T>_Vol

nu_plate.out : Nusselt number based on horizontal average over bottom plate and 
               top plate

              -Col1: Flow time
              -Col2: Nu_bot = -\partial_z<T>_bot
              -Col3: Nu_top = -\partial_z<T>_top

rms_vel.out  : Reynolds numbers Re(t) based on RMS velocities

              -Col1: Flow time
              -Col2: hor.  Re_x = (Ra/Pr * <(u_x)^2>_Vol)^(1/2)
              -Col3: hor.  Re_y = (Ra/Pr * <(u_y)^2>_Vol)^(1/2)
              -Col4: vert. Re_z = (Ra/Pr * <(u_z)^2>_Vol)^(1/2)
              -Col5: total Re=((Re_x)^2+(Re_y)^2+(Re_z)^2)^(1/2)

################################################################################


Version 1.0.1  
Robert Hartmann (r DOT hartmann AT utwente DOT nl)  
29.08.2023  
