

#read data from CSV and DPT files in a specified directory
import csv
import glob
import os
import aging_classification_config as config

def list_files_in_directory(patterns):
    """
    Lists all files that match the given patterns.
    """
    files = []
    for pattern in patterns:
        files.extend(glob.glob(pattern))
    return files

def get_platform_specific_path(path_str):
    """
    Replaces a generic path string with the correct separator for the current OS.
    """
    if os.name == 'nt':  # Windows
        return path_str.replace('/', '\\')
    return path_str.replace('\\', '/')  # macOS, Linux, etc.

def readdata(directory_name: str):
    """
    Reads data from CSV and DPT files in a specified directory.
    Assumes the script is run from a subfolder two levels deep within the project's root.
    """
    # Navigate up two levels from the current script's directory to the project root, Assuming that the codes are in InfraDCM/src/modeling.
    base_path = os.path.join(os.path.dirname(__file__), '..', '..')

    # Ensure the directory name uses the correct separator for the OS
    directory_name = get_platform_specific_path(directory_name)

    full_path = os.path.join(base_path, directory_name)

    # Patterns to match CSV and DPT files
    patterns = [os.path.join(full_path, pattern) for pattern in config.FILE_PATTERNS]
    lst_of_all_files = list_files_in_directory(patterns)

    lst_x_axis_all = []
    lst_y_axis_all = []
    user_names = []

    for file in lst_of_all_files:
        user_names.append(os.path.basename(file)[:-4])
        lst_x_axis = []
        lst_y_axis = []

        try:
            with open(file, newline='', encoding='utf-8-sig') as f:
                reader = csv.reader(f)
                data = list(reader)

                for row in data:
                    try:
                        if file.endswith('.dpt'):
                            row = row[0].split('\t')

                        lst_x_axis.append(float(row[0]))
                        lst_y_axis.append(float(row[1]))
                    except (ValueError, IndexError):
                        continue
        except FileNotFoundError:
            print(f"File not found: {file}")
            continue

        lst_x_axis_all.append(lst_x_axis)
        lst_y_axis_all.append(lst_y_axis)

    return lst_x_axis_all, lst_y_axis_all, user_names

# Example usage from a script 
# wavenumbers, spectra, user_names = readdata(r'data path')


