#  Dataset - A Comparative Hydrodynamic Characterization of the Flow Through Regular and Stochastically Generated Synthetic Coral Reefs Over Flat Topography 
## Authors: Akshay Patil & Clara García-Sánchez
## 3DGeoinformation Research Group, Deflt University of Technology, The Netherlands

Corresponding Author: Akshay Patil  
Contact Information: a.l.patil@tudelft.nl

___

The `PatilGarciaSanchez-CoastalDynamics2025.zip` zipped folder contains the following files

- `data`: Directory containing the 1-Dimensional profiles for the various cases detailed in the manuscript
- `*.py`: Python scripts to replicate the figures in the manuscript

The vertical profiles for the plot are stored in `zgrid.dat` file located within the `data` directory. Additionally, the naming convention for the cases are detailed in the table below.

| Case Name  | Data Name | Coral Type |
| ------- | ------------ | ---------- |
| *C-Ser* | *serialCylinder_<$\cdot$>* | Cylindrical |
| *C-Stag* | *staggeredCylinder_<$\cdot$>* | Cylindrical |
| *B-Ser* | *serialBranching_<$\cdot$>* | Branching Coral |
| *B-Stag* | *staggeredBranching_<$\cdot$>* | Branching Coral |
| *M-Ser* | *serialMassive_<$\cdot$>* | Massive Coral |
| *M-Stag* | *staggeredMassive_<$\cdot$>* | Massive Coral |
| *Morph-1* | *morph1_<$\cdot$>* | Stochastic Morphology 1 |
| *Morph-2* | *morph2_<$\cdot$>* | Stochastic Morphology 2 |

The <$\cdot$> can be populated for the following parmeters, U, tke, urms, vrms, wrms, and epsilon, corresponding to the wave-phase averaged streamwise velocity, turbulent kinetic energy, streamwise root-mean squared velocity, spanwise root-mean squared velocity, vertical root-mean squared velocity, and turbulent kinetic energy dissipation rate, respectively. The `data` folder also contains vertical slices at the 100th grid point with the naming convention <$\cdot$>_slice_100.npy.

### How to use the data?
Consult the python scripts included in the zipped folder to generate the figures corresponding to the manuscript.
