import numpy as np
import matplotlib.pyplot as plt
from matplotlib import cm
import cblind as cb
from functions import stokesSolution, fixPlot
#
# USER INPUT PARAMETERS
# 
save_Fig = True                        # Save the Figure prompt
show_Fig = True                         # Show the Figure prompt
figname_a = 'figures/figure1_a.pdf'     # Name of panel (a)
figname_b = 'figures/figure1_b.pdf'     # Name of panel (b)
# Flow properties
nphases = 10                            # Number of wave phases
Ub = 0.072360125                        # Wave orbital velocity in m/s
Tw = 6.0                                # Wave Period in s
# 
# LOAD DATA
#
z = np.loadtxt('data/zgrid.dat')
stokes = stokesSolution(z,Ub,2*np.pi/Tw,nphases,kvisc=1e-6,nondimres=True)
serCy = np.loadtxt('data/serialCylinder_U.dat')
staCy = np.loadtxt('data/staggeredCylinder_U.dat')
serMa = np.loadtxt('data/serialMassive_U.dat')
staMa = np.loadtxt('data/staggeredMassive_U.dat')
serBr = np.loadtxt('data/serialBranching_U.dat')
staBr = np.loadtxt('data/staggeredBranching_U.dat')
morph1 = np.loadtxt('data/morph1_U.dat')
morph2 = np.loadtxt('data/morph2_U.dat')
#
# PLOT
#
# color, linestyle = cb.Colorplots().cblind(10)
color = cm.get_cmap('magma_r', nphases)
# color = cm.get_cmap('PuBuGn', nphases)
fixPlot(thickness=1.5, fontsize=20, markersize=4, labelsize=15, texuse=True, tickSize = 15)
plt.figure(1,figsize=(10,9.5))
# Cylinder
plt.subplot(2,2,1)
plt.plot(stokes,z/z[-1],'k',linewidth=2.0)
for ii in range(0,nphases):
    plt.plot((serCy[:,ii] - np.nanmean(serCy,axis=1)[:])/Ub,z/z[-1],'-x',color=color(ii),markevery=10)
    plt.plot((staCy[:,ii] - np.nanmean(staCy,axis=1)[:])/Ub ,z/z[-1],'-o',color=color(ii),markevery=20)
# FORMATTING
plt.title('Cylinder',fontsize=25)
plt.axhline(0.035/z[-1],linestyle=':',color='r',linewidth=2.0)
plt.xticks([-1.0,-0.5,0.0,0.5,1.0],labels=[]);
plt.ylim([0,1.0])
plt.ylabel(r'$x_3/H$',fontsize=20)
plt.grid()
# Massive Corals
plt.subplot(2,2,2)
plt.plot(stokes,z/z[-1],color='k')
for ii in range(0,nphases):
    plt.plot((serMa[:,ii] - np.nanmean(serMa,axis=1)[:])/Ub,z/z[-1],'-x',color=color(ii),markevery=10)
    plt.plot((staMa[:,ii] - np.nanmean(staMa,axis=1)[:])/Ub ,z/z[-1],'-o',color=color(ii),markevery=20)
# Formatting
plt.title('Massive',fontsize=25)
plt.axhline(0.035/z[-1],linestyle=':',color='r',linewidth=2.0)
plt.xticks([-1.0,-0.5,0.0,0.5,1.0],labels=[]); plt.yticks([0.0,0.25,0.5,0.75,1.0],labels=[])
plt.ylim([0,1.0])
plt.grid()
# Branching Corals
plt.subplot(2,2,3)
plt.plot(stokes,z/z[-1],color='k')
for ii in range(0,nphases):
    plt.plot((serBr[:,ii] - np.nanmean(serBr,axis=1)[:])/Ub,z/z[-1],'-x',color=color(ii),markevery=10)
    plt.plot((staBr[:,ii] - np.nanmean(staBr,axis=1)[:])/Ub ,z/z[-1],'-o',color=color(ii),markevery=20)
# Formatting
plt.title('Branching',fontsize=25)
plt.axhline(0.035/z[-1],linestyle=':',color='r',linewidth=2.0)
plt.xticks([-1.0,-0.5,0.0,0.5,1.0])
plt.ylim([0,1.0])
plt.ylabel(r'$x_3/H$',fontsize=20)
plt.xlabel(r'$\langle \widetilde{U}_1 \rangle/U_b$',fontsize=20)
plt.grid()
# Morphology Corals
plt.subplot(2,2,4)
plt.plot(stokes,z/z[-1],color='k')
for ii in range(0,nphases):
    plt.plot((morph1[:,ii] - np.nanmean(morph1,axis=1)[:])/Ub,z/z[-1],'-x',color=color(ii),markevery=10)
    plt.plot((morph2[:,ii] - np.nanmean(morph2,axis=1)[:])/Ub ,z/z[-1],'-o',color=color(ii),markevery=20)
# Formatting
plt.title('Morphology',fontsize=25)
plt.axhline(0.035/z[-1],linestyle=':',color='r',linewidth=2.0)
plt.xticks([-1.0,-0.5,0.0,0.5,1.0]); plt.yticks([0.0,0.25,0.5,0.75,1.0],labels=[])
plt.ylim([0,1.0])
plt.xlabel(r'$\langle \widetilde{U}_1 \rangle/U_b$',fontsize=20)
plt.grid()
## SAVE FIG
if(save_Fig):
    plt.savefig(figname_a,dpi=800)
#
# -------------------------------------------------------------------- #
#
Tw = 2*np.pi
timex = np.linspace(Tw/nphases,Tw,nphases)
timey = np.sin(timex)
finex = np.linspace(Tw/100,Tw,100)
finey = np.sin(finex)
myxtick_labels = [r'$0$',r'$\pi/2$',r'$\pi$',r'$3\pi/2$',r'$2\pi$']
plt.figure(2,figsize=(14,4))
plt.plot(finex,finey,'-',color=color(5),label=r'$U_b$')
plt.plot(finex,np.cos(finex),'--',color=color(2),label=r'$U_b \omega \cos(\omega t)$')
for ii in range(0,nphases):
    plt.plot(timex[ii],timey[ii],'o',color=color(ii),markersize=12,markeredgecolor='k')
# FORMATTING
plt.xticks([0,np.pi/2,np.pi,3*np.pi/2,2*np.pi],labels=myxtick_labels)
plt.xlim([0,2*np.pi]); plt.ylim([-1,1])
plt.xlabel(r'$t^*$',fontsize=20)
plt.legend(frameon=False,fontsize=20)
plt.grid()
plt.tight_layout()
## SAVE FIG
if(save_Fig):
    plt.savefig(figname_b,dpi=800)
if(show_Fig):
    plt.show()
