# Attitudes Toward a Virtual Smoking Cessation Coach: Relationship and Willingness to Continue
## Overview of Steps to Reproduce Analyses


**Author**: Nele Albers
**Date**: February 2023


This is the overall README-file to give you an overview of reproducing our analyses from the paper "Attitudes Toward a Virtual Smoking Cessation Coach: Relationship and Willingness to Continue."

Authored by Nele Albers, Mark A. Neerincx, Nadyne L. Aretz, Mahira Ali, Arsen Ekinci, and Willem-Paul Brinkman.


### Requirements

First, please download our dataset from this repository: https://doi.org/10.4121/19934783.v1. Place the folder "Dataset_Acceptance_Virtual_Coach" into the folder this README-file is in.


### Types of Analyses

Below we describe how you can reproduce our results for the different types of analyses.


#### Data Preprocessing

Run the file "preprocess_data.py" to:
   - re-create the file "preprocessed_data.csv" needed for the analyses.


#### Participant Characteristics

Navigate to the folder "Participant_Characteristics" and follow the instructions in the correspondng README-file to reproduce our results regarding:
   - the participant characteristics reported in the "Participants"-section.
   

#### Qualitative Analysis
Navigate to the folder "Qualitative_Analysis" to:
   - see the codes assigned by the two coders,
   - reproduce our average Cohen's Kappa values from the "Analysis strategies"-section,
   - see the final coding schemes,
   - see the final coding for the two attitude questions, and
   - reproduce the theme frequencies from the "Results"-section.
   
   
Note that the participant numbers in the paper (e.g., P1) refer to the rows in the files with the final assigned codes.
   

#### Mean Attitude Ratings
Navigate to the folder "Mean_Ratings" and follow the instructions in the corresponding README-file to reproduce our results regarding:
   - the mean attitude ratings reported in the "Results"-section.
   

#### Bayesian Analysis of Correlations
Navigate to the folder "Correlations" and follow the instructions in the corresponding README-file to reproduce our results regarding:
   - the correlations between user variables and attitude ratings reported in the "Results"-section.


### Explanation of Files and Folders

This directory contains the following files and folders:
   - Correlations: To reproduce our Bayesian analysis of correlations between user variables and attitude ratings,
   - Mean_Ratings: To reproduce our mean attitude ratings from the "Results"-section,
   - Participant_Characteristics: To reproduce the reported participant characteristics from the "Participants"-section,
   - Qualitative_Analysis: Information on the qualitative analysis (e.g., final coding schemes),
   - preprocess_data.py: To preprocess the gathered data for use in the analyses, and
   - README.md/README.pdf: This README-file.
