# -*- coding: utf-8 -*-
"""
Compute the frequencies of the 8 themes.

Date: February 2023
Author: Nele Albers

Required files:
    - Final_Coding_Relationship.xlsx
    - Final_Coding_Willingness_to_Continue.xlsx
Output file:
    - calculate_theme_frequencies_output.txt
"""

import pandas as pd

if __name__ == "__main__":
    
    output_file_name = "calculate_theme_frequencies_output.txt"

    # Load dataframes with final coding for the 2 questions
    df_rel = pd.read_excel("Final_Coding_Relationship.xlsx")
    df_cont = pd.read_excel("Final_Coding_Willingness_to_Continue.xlsx")

    # Codes per theme for relationship
    codes_rel_relation = ["Good Relation", "A friend", "More than a stranger",
                          "Strictly-Business Relation ", "Not a friend nor a stranger",
                          "Not a friend", "No relation ", "Unimaginable to form a relation with AI"]
    codes_rel_chat = ["Good chat", 'Chat with "A Friend"', "Responds good",
                      "Limited answer choice", "Scripted ", "Monotonous "]
    codes_rel_impersonal = ["Do not know Sam ", 'Does not know "me"', 'Sam has no "face"',
                            "Sam has no emotions", "Sam has no mind"]
    codes_rel_pos_char = ["Friendly", "Guidance", "Trustworthy ", "Warm",
                          "Caring", "Welcoming", "Unprejudiced",
                          "Sympathetic ", "Informal", "Understanding", "Polite", "Patient",
                          "Thoughtful", "Helpful", "Motivates", "Supportive", "Informative"]
    codes_rel_perception = ["Human-Like", "Artificial but Human-Like", 
                            "Clearly Artificial "]

    # Codes per theme for "willingness to continue"
    codes_cont_authen = ["Cannot respect a bot", "Did not feel authentic",
                         "Prefers using other services", "Not interactive enough",
                         "Not the right format", "Stop"]
    codes_cont_char = ["Polite", "Patient", "Friendly", "Unbiased",
                       "Comforting", "Motivating", "Understanding", "Supporting",
                       "Engaging", "Continue"]
    codes_cont_content = ['Informative', 'Guidance', 'Proposes good ideas/activities',
                          'Clear explanations', 'Helpful', 'Interesting']
    # Some other codes for "willingness to continue" that are not part of themes
    other_codes = ["Enjoyable", "Easy to use", "Neutral", "Not helpful",
                   "Not motivating enough", "Prefers using Sam", 
                   "Felt authentic", "Not enjoyable", "Potential", "Good pace",
                   "Serves as a reminder", "Not understanding enough", "Routine",
                   "Right format", "Effective over time", "Not ready to quit smoking",
                   "Unique", "Predictable", "Personal",
                   "Uncertain about helpfulness", "Not interesting", "Structured",
                   "Not personal enough", "Time consuming", "Improves accountability",
                   "Anonymous", "Secure", "Not engaging enough",
                   "Not supportive enough", "Not time consuming", "Practical"]

    # Get theme frequencies for "relationship"
    max_codes_rel = 4
    num_rel_relation = 0
    num_rel_chat = 0
    num_rel_impersonal = 0
    num_rel_pos_char = 0
    num_rel_perception = 0
    for row in range(len(df_rel)):

        num_rel_relation_curr = 0
        num_rel_chat_curr = 0
        num_rel_impersonal_curr = 0
        num_rel_pos_char_curr = 0
        num_rel_perception_curr = 0

        for col_idx in range(1, max_codes_rel + 1):
            code_curr = df_rel.iloc[row]["Code_" + str(col_idx)]

            if code_curr in codes_rel_relation:
                num_rel_relation_curr = 1
            elif code_curr in codes_rel_chat:
                num_rel_chat_curr = 1
            elif code_curr in codes_rel_impersonal:
                num_rel_impersonal_curr = 1
            elif code_curr in codes_rel_pos_char:
                num_rel_pos_char_curr = 1
            elif code_curr in codes_rel_perception:
                num_rel_perception_curr = 1
            elif not pd.isna(code_curr) and not code_curr == " ":
                print(code_curr)

        num_rel_relation += num_rel_relation_curr
        num_rel_chat += num_rel_chat_curr
        num_rel_impersonal += num_rel_impersonal_curr
        num_rel_pos_char += num_rel_pos_char_curr
        num_rel_perception += num_rel_perception_curr


    print("***Relationship***")
    print("Number of responses Relation with Sam:", num_rel_relation)
    print("Number of responses Chat Characteristics:", num_rel_chat)
    print("Number of responses Impersonal:", num_rel_impersonal)
    print("Number of responses Positive Characteristics:", num_rel_pos_char)
    print("Number of responses Perception of Sam as Human vs. Artificial:", num_rel_perception)

    with open(output_file_name, "w") as f:
        f.write("***Relationship***")
        f.write("\nNumber of responses Relation with Sam:" + str(num_rel_relation))
        f.write("\nNumber of responses Chat Characteristics:" + str(num_rel_chat))
        f.write("\nNumber of responses Impersonal:" + str(num_rel_impersonal))
        f.write("\nNumber of responses Positive Characteristics:" + str(num_rel_pos_char))
        f.write("\nNumber of responses Perception of Sam as Human vs. Artificial:" + str(num_rel_perception))


    # Get theme frequencies for "willingness to continue"
    max_codes_cont = 8
    num_cont_authen = 0
    num_cont_char = 0
    num_cont_content = 0
    for row in range(len(df_cont)):

        num_cont_authen_curr = 0
        num_cont_char_curr = 0
        num_cont_content_curr = 0

        for col_idx in range(1, max_codes_cont + 1):
            code_curr = str(df_cont.iloc[row]["Code_" + str(col_idx)]).strip()

            if code_curr in codes_cont_authen:
                num_cont_authen_curr = 1
            elif code_curr in codes_cont_char:
                num_cont_char_curr = 1
            elif code_curr in codes_cont_content:
                num_cont_content_curr = 1
            elif not code_curr in other_codes + ["nan", ""]:
                print(code_curr)

        num_cont_authen += num_cont_authen_curr
        num_cont_char += num_cont_char_curr
        num_cont_content += num_cont_content_curr

    print("\n***Willingness to Continue***")
    print("Number of responses Authenticity:", num_cont_authen)
    print("Number of responses Caring Character:", num_cont_char)
    print("Number of responses Content of Interactions:", num_cont_content)

    with open(output_file_name, "a") as f:
        f.write("\n\n***Willingness to Continue***")
        f.write("\nNumber of responses Authenticity:" + str(num_cont_authen))
        f.write("\nNumber of responses Caring Character:" + str(num_cont_char))
        f.write("\nNumber of responses Content of Interactions:" + str(num_cont_content))
