# Attitudes Toward a Virtual Smoking Cessation Coach: Relationship and Willingness to Continue
## Qualitative Analysis


**Author**: Nele Albers
**Date**: February 2023


This file is meant to give you an overview of the information we provide on our qualitative analysis. Specifically, we provide:
   - the coding schemes, 
   - the codes assigned by the first and second coder,
   - code to reproduce the average Cohen's Kappa scores reported in the "Analysis strategies"-section,
   - the final assigned codes, and
   - code to reproduce the theme frequencies reported in the "Results"-section.

Authored by Nele Albers, Mark A. Neerincx, Nadyne L. Aretz, Mahira Ali, Arsen Ekinci, and Willem-Paul Brinkman.


### Overview of Information

#### Coding Schemes
To see the final coding schemes, refer to the files "Coding_Scheme_Relationship.png" and "Coding_Scheme_Willingness_to_Continue.pdf."


#### Double Coding
Navigate to the folder "Double_Coding" to see:
   - the codes assigned by both coders for each attitude question,
   - Python code to compute the agreement between the two coders for the two attitude questions, and
   - the output of the above code for the two attidude questions (i.e., the average Cohen's Kappa values).
   

#### Final Codes
To see the final codes assigned to the free-text responses, refer to the files "Final_Coding_Relationship.xlsx" and "Final_Coding_Willingness_to_Continue.xlsx."


#### Theme Frequencies
To re-compute the theme frequencies reported in the "Results"-section, run the file "calculate_theme_frequencies.py" The output we obtained is written to the file "calculate_theme_frequencies_output.txt."
   

### Explanation of Files and Folders

This directory contains the following files and folders:
   - Double_Coding: To reproduce the average Cohen's Kappa scores reported in the "Analysis strategies"-section,
   - calculate_theme_frequencies.py: Compute theme frequencies,
   - calculate_theme_frequencies_output.txt: Output of the above Python-file when run by us,
   - Coding_Scheme_Relationship.png: Visualization of initial and final coding scheme for "relationship,"
   - Coding_Scheme_Willingness_to_Continue.pdf: Visualization of coding scheme and mapping of codes to themes for "willingness to continue,"
   - Final_Coding_Relationship.xlsx: Final coding of free-text responses for "relationship,"
   - Final_Coding_Willingness_to_Continue.xlsx: Final coding of free-text responses for "willingness to continue," and
   - README.md/README.pdf: This README-file.


Notably, participant numbers in the paper (e.g., P1) refer to the rows in the files with the final coding.
