"""
Calculate the average Cohen's Kappa for "relationship."

Author: Mahira Ali, Nele Albers

Required files:
    - First_Coder_Relationship.csv
    - Second_Coder_Relationship.csv
    
Output files:
    - calculate_agreement_relationship_output.txt
"""


import numpy as np
from numpy import genfromtxt, transpose
from sklearn.metrics import cohen_kappa_score


if __name__ == '__main__':

    # Code by first coder
    file = open('First_Coder_Relationship.csv', encoding="utf8")
    my_data = genfromtxt(file, delimiter=';')
    my_data_trimmed = []
    # Trim away text codes, only leaving hot-one encodings.
    # Every row is a response
    # First row contains header; first 30 responses were used for training
    # of the second coder
    for response in my_data[31:]:
        my_data_trimmed.append(response[10:])
    my_data_trimmed = transpose(my_data_trimmed)
    file.close()

    file = open('Second_Coder_Relationship.csv', encoding="utf8")
    second_data = genfromtxt(file, delimiter=';')
    second_data_trimmed = []
    # Trim away text codes, only leaving hot-one encodings.
    # Every row is a response
    # First row contains header; first 30 responses were used for training
    # of the second coder
    for response in second_data[31:]:
        second_data_trimmed.append(response[10:])
    second_data_trimmed = transpose(second_data_trimmed)
    file.close()
    
    results = []
    # Compute Cohen's Kappa per code
    for i in range(len(second_data_trimmed)):
        cohen_i = cohen_kappa_score(my_data_trimmed[i], second_data_trimmed[i])
        if not np.isnan(cohen_i):
            results.append(cohen_i)
        # Replace nan with 0
        else:
            results.append(0)
    print("Cohen's Kappa per code:", np.round(np.array(results), 2))

    print("Average Cohen's Kappa:", round(np.mean(results), 2))
    
    # Write average to file
    with open("calculate_agreement_relationship_output.txt", "w") as f:
        f.write("Average Cohen's Kappa: " + str(round(np.mean(results), 2)))
