# Attitudes Toward a Virtual Smoking Cessation Coach: Relationship and Willingness to Continue
## Participant Characteristics


**Author**: Nele Albers
**Date**: Februrary 2023


This file is meant to allow you to reproduce our participant characteristics reported in the "Participants"-section of our paper.

Authored by Nele Albers, Mark A. Neerincx, Nadyne L. Aretz, Mahira Ali, Arsen Ekinci, and Willem-Paul Brinkman.


### Steps to Reproduce Analysis

The reproduction of our code is based on Docker and Jupyter Notebook. Take the following steps:
1. Make sure that you have Docker installed. You can check whether you do by running `docker -v`.
2. Now choose from the following two options:
   - In the directory of this README-file, build the Docker image via `docker build . -t gbna4/attitudes_perstech_python`. 
   - In the directory of this README-file, pull the Docker image from Dockerhub via `docker pull gbna4/attitudes_perstech_python`.
3. Run the Docker container via `docker run -p 8888:8888 -e JUPYTER_ENABLE_LAB=yes -v <this_working_directory>:/home/jovyan/work gbna4/attitudes_perstech_python`, where `<this_working_directory>` is the path to the directory that this README-file is in.
4. Go to one of the links presented in the terminal upon running the Docker container to access Jupyter Notebook.
5. Open the "work"-folder in Jupyter Notebook.
6. Open the "participant_characteristics.ipynb"-workbook in the "work"-folder.

### Explanation of Files

This directory contains the following files and folders:
- Dockerfile: To build the Docker image yourself,
- participant_characteristics.ipynb: Workbook to reproduce the participant characteristics reported in the paper,
- preprocessed_data.csv: Required data, and
- README.md/README.pdf: This README-file.
