# Attitudes Toward a Virtual Smoking Cessation Coach: Relationship and Willingness to Continue
## Bayesian Analysis of Correlations


**Author**: Nele Albers
**Date**: February 2023


This file is meant to guide you through reproducing our Bayesian analysis of the correlations between user variables and attitude ratings reported in the "Results"-section of the paper.

Authored by Nele Albers, Mark A. Neerincx, Nadyne L. Aretz, Mahira Ali, Arsen Ekinci, and Willem-Paul Brinkman.


### Examine Output of Code Run by Us

If you would like to examine the output of the code as run by us, have a look at:
   - the file "Bayesian_analysis_correlations.pdf."


### Run Code Yourself

This section is to explain how you can run the code yourself.


#### Requirements

You need to have Docker installed.


#### Steps to Reproduce Analyses

The reproduction of our results is based on Docker and R Studio. Take the following steps:
1. Make sure you have Docker installed. You can check if you do by running `docker -v`.
2. Navigate to the folder this README-file is in.
3. Now you have 2 options:
      - Build the Docker image via `docker build . -t gbna4/attitudes_perstech_firstaid`, or
      - Pull the Docker image from Dockerhub via `docker pull gbna4/attitudes_perstech_firstaid`.
4. Run the Docker container via `docker run -d -p 8787:8787 -v <path_to_this_directory>:/home/rstudio/analysis -e PASSWORD=<some_password> gbna4/attitudes_perstech_firstaid`.
5. Go to localhost:8787.
6. Login with username 'rstudio' and the password chosen in step 4.
7. Navigate to the "analysis"-folder in R Studio. If the "analysis"-folder is empty, check that you have used the correct path in the command for running the Docker container. Also, sharing the folder content may not work if you use a drive other than the C drive.
8. Now you can reproduce the results via the .Rmd-file in the "analysis"-folder. You can also knit a pdf-file from the Rmd-file via the "Knit"-button in R Studio.


#### Knitting R Markdown

If you just want to knit an analysis file to a pdf-file, take the following steps:
1. Make sure you have Docker installed.
2. Navigate to the folder this README-file is in.
3. Now you have 2 options:
      - Build the Docker image via `docker build . -t gbna4/attitudes_perstech_firstaid`, or
      - Pull the Docker image from Dockerhub via `docker pull gbna4/attitudes_perstech_firstaid`.
4. Run an interactive session with the Docker container via `docker run -it -v <path_to_directory_of_this_README_file>:/home/rstudio/analysis gbna4/attitudes_perstech_firstaid /bin/bash`.
5. In the interactive session, type `cd /home/rstudio/analysis` to navigate to the "analysis"-folder. See the previous section in case your "analysis"-folder is empty.
6. Start an R session via `R`.
7. Import rmarkdown via `library('rmarkdown')`.
8. Knit an R markdown file via `render("<analysis_file>.Rmd", output_file = "<desired_output_file_name>.pdf")`.


### Explanation of Files in this Folder

This directory contains the following files:
- Bayesian_analysis_correlations.pdf: Output of Bayesian analysis when run by us,
- Bayesian_analysis_correlations.Rmd: File for you to reproduce our analysis results,
- Dockerfile: To build the Docker image yourself,
- JAGS-4.3.0.tar.gz: Needed for building the Docker image,
- preprocessed_data.csv: Required data,
- README.md/README.pdf: This README-file, and
- references.bib: References used in the .Rmd-file.
