clc 
close all
clear all


%% Settings
color_order = [0,0.447000000000000,0.741000000000000;
0.850000000000000,0.325000000000000,0.0980000000000000;
0.929000000000000,0.694000000000000,0.125000000000000;
0.494000000000000,0.184000000000000,0.556000000000000;
0.466000000000000,0.674000000000000,0.188000000000000;
0.301000000000000,0.745000000000000,0.933000000000000;
0.635000000000000,0.0780000000000000,0.184000000000000];

% font settings
font = 'Times New Roman';
font_size = 9;
legend_font_size = 9;

% legend settings
x1 = 15; % 30
x2 = 5;


marker_size = 5;
marker_size_scatter = marker_size^2;
%% Load in data



pf = 9.6808; % gram (stationary)
m_s = 6.418; % gram (moving)

mu = pf/m_s;


% SISO AoA = 0
G_omega_PCO = [0.899524;0.891371;3.769347594;3.809360441;3.670450149;3.533749633;0.55998946;0.435353986;0.41832226];
omega_PCO = [20.6445;20.4297;20.13718449;19.79717182;19.94316114;19.89531673;20.59608456;20.61916501;20.82047296];
Velocity_lst = [20; 21; 22; 22.5; 23; 23.5; 24; 24.5; 25];

dpf = pf - 1./(G_omega_PCO/pf);

SISO_AoA_0 = table(Velocity_lst, G_omega_PCO, omega_PCO, dpf, 'VariableNames', {'V', 'G', 'omega', 'dpf'});


% MIMO AoA = 0 
G_omega_PCO = [0.871417;0.897574;3.093423927;3.460137215;3.210591134;3.269572087;0.413520891;0.424348269;0.393046611];
omega_PCO = [20.6953;20.4414;20.16073625;19.80163195;19.94322124;19.88817212;20.69471329;20.61302549;20.821202];
Velocity_lst = [20; 21; 22; 22.5; 23; 23.5; 24; 24.5; 25];

lambda = (1/pf) * G_omega_PCO.*(cos(0) + 1i*sin(0));
dpf = pf - 1./lambda;


MIMO_AoA_0 = table(Velocity_lst, G_omega_PCO, omega_PCO, dpf, 'VariableNames', {'V', 'G', 'omega', 'dpf'});

% Unsmoothed eigenvalues MIMO AoA = 0
G_omega_PCO = [0.915179;0.802736286;3.836348791;3.877911739;3.711003688;3.507819586;0.546172417;0.411082365;0.398865824];
omega_PCO = [20.6172;20.49922992;20.12655883;19.78851821;19.93508911;19.88748037;20.60608779;20.60237251;20.8055021];
Velocity_lst = [20; 21; 22; 22.5; 23; 23.5; 24; 24.5; 25];


lambda = (1/pf) * G_omega_PCO.*(cos(0) + j*sin(0));
dpf = pf - 1./lambda;

MIMO_raw_eig_AoA_0 =  table(Velocity_lst, G_omega_PCO, omega_PCO, dpf, 'VariableNames', {'V', 'G', 'omega', 'dpf'});


% SISO AoA = 2
G_omega_PCO = [0.892097;1.334081372;3.392998714;3.065123942;0.960081567;0.432775374;0.426120301];
omega_PCO = [20.2734;19.92882946;19.62025067;19.40168427;19.63682708;20.18062413;20.16878794];
Velocity_lst = [19;20;21;21.5;22;23;23.5];

dpf = pf - 1./(G_omega_PCO/pf);

SISO_AoA_2 = table(Velocity_lst, G_omega_PCO, omega_PCO, dpf, 'VariableNames', {'V', 'G', 'omega', 'dpf'});



% MIMO AoA = 2
G_omega_PCO = [0.820077;0.934604;2.625871164;2.698139184;0.546160016;0.474584271;0.433083075];
omega_PCO = [20.3333;20.098;19.65012524;19.48113491;20.2078704;20.06764793;20.14912606];
Velocity_lst = [19;20;21;21.5;22;23;23.5];

lambda = (1/pf) * G_omega_PCO.*(cos(0) + j*sin(0));
dpf = pf - 1./lambda;

MIMO_AoA_2 = table(Velocity_lst, G_omega_PCO, omega_PCO, dpf, 'VariableNames', {'V', 'G', 'omega', 'dpf'});



% Unsmoothed eigenvalues MIMO AoA = 2
G_omega_PCO = [0.892316;0.993831528;3.363690172;4.58266867;1.043046858;0.553748503;0.51687035];
omega_PCO = [20.2941;20.01953276;19.61796891;19.45038229;19.63149896;19.95963565;19.97405485];
Velocity_lst = [19;20;21;21.5;22;23;23.5];

lambda = (1/pf) * G_omega_PCO.*(cos(0) + j*sin(0));
dpf = pf - 1./lambda;

MIMO_raw_eig_AoA_2 =  table(Velocity_lst, G_omega_PCO, omega_PCO, dpf, 'VariableNames', {'V', 'G', 'omega', 'dpf'});


% SISO AoA = 4
G_omega_PCO = [1.14832;2.268721081;0.568989918;0.908910963;0.65;0.476168481;0.498946057;0.579869697];
omega_PCO = [19.6094;19.37208624;19.63070602;19.38816356;19.39;19.44597659;19.40574904;19.37057289];
Velocity_lst = [18;18.5;19;20;21;21.5;22;23];

G_omega_PCO = [1.14832;2.268721081;1.37466;0.908910963;0.65;0.476168481;0.498946057;0.579869697];
omega_PCO = [19.6094;19.37208624;19.3945;19.38816356;19.39;19.44597659;19.40574904;19.37057289];
Velocity_lst = [18;18.5;19;20;21;21.5;22;23];


dpf = pf - 1./(G_omega_PCO/pf);

SISO_AoA_4 = table(Velocity_lst, G_omega_PCO, omega_PCO, dpf, 'VariableNames', {'V', 'G', 'omega', 'dpf'});


% MIMO AoA = 4
G_omega_PCO = [1.04646;2.077103725;0.576663729;0.641053699;0.419126338;0.330475848;0.469561969;0.591490992];
omega_PCO = [19.7512;19.37937584;19.61014225;19.53796323;19.54285067;19.3981138;19.42514299;19.35979503];
Velocity_lst = [18;18.5;19;20;21;21.5;22;23];

lambda = (1/pf) * G_omega_PCO.*(cos(0) + j*sin(0));
dpf = pf - 1./lambda;

MIMO_AoA_4 = table(Velocity_lst, G_omega_PCO, omega_PCO, dpf, 'VariableNames', {'V', 'G', 'omega', 'dpf'});

% Unsmoothed eigenvalues MIMO AoA = 4
G_omega_PCO = [1.018439858;0.919206025;1.378320633;0.900525812;0.731769283;0.382880476;0.449146102;0.63377162];
omega_PCO = [19.63903857;19.62393556;19.41336108;19.38816869;19.39426872;19.34366383;19.35994389;19.35075739];
Velocity_lst = [18;18.5;19;20;21;21.5;22;23];



lambda = (1/pf) * G_omega_PCO.*(cos(0) + j*sin(0));
dpf = pf - 1./lambda;

MIMO_raw_eig_AoA_4 =  table(Velocity_lst, G_omega_PCO, omega_PCO, dpf, 'VariableNames', {'V', 'G', 'omega', 'dpf'});


% SISO AoA = 6
G_omega_PCO = [1.21021549;0.859613;0.875145;1.381081351;0.676534637;0.515523329];
omega_PCO = [19.66675274;19.6875;19.3945;18.89308999;18.95495444;18.94440038];
Velocity_lst = [16;17;18;19;20;21];

dpf = pf - 1./(G_omega_PCO/pf);

SISO_AoA_6 = table(Velocity_lst, G_omega_PCO, omega_PCO, dpf, 'VariableNames', {'V', 'G', 'omega', 'dpf'});


% MIMO AoA = 6
G_omega_PCO = [1.08889;0.910831;0.765977;0.772734846;1.069407279;0.088405113];
omega_PCO = [19.6927;19.6927;19.7317;18.90282141;18.6494643;18.75563917];
Velocity_lst = [16;17;18;19;20;21];

lambda = (1/pf) * G_omega_PCO.*(cos(0) + j*sin(0));
dpf = pf - 1./lambda;

MIMO_AoA_6 = table(Velocity_lst, G_omega_PCO, omega_PCO, dpf, 'VariableNames', {'V', 'G', 'omega', 'dpf'});


% Unsmoothed eigenvalues MIMO AoA = 6
G_omega_PCO = [1.287293212;0.94003;0.787276713;0.959971956;2.731315595;0.592155373];
omega_PCO = [19.67070957;19.6732;19.32130805;18.90303439;18.57197513;18.75126356];

Velocity_lst = [16;17;18;19;20;21];

lambda = (1/pf) * G_omega_PCO.*(cos(0) + j*sin(0));
dpf = pf - 1./lambda;

MIMO_raw_eig_AoA_6 =  table(Velocity_lst, G_omega_PCO, omega_PCO, dpf, 'VariableNames', {'V', 'G', 'omega', 'dpf'});


%% Plot V vs. omega, G and Dp_f

%% AoA = 0

fh = figure;
fh.Units = 'inches';
fh.Position(3:4) = [3.25,3.5];

tcl = tiledlayout(2, 1);

nexttile(tcl)
plot(SISO_AoA_0.V(1:3), SISO_AoA_0.G(1:3), '--', 'Marker', 'o','MarkerSize', marker_size,  'color', color_order(1,:), 'HandleVisibility','off','MarkerFaceColor', color_order(1,:))
hold on
line1 = plot(SISO_AoA_0.V(3:end), SISO_AoA_0.G(3:end), '-', 'Marker', 'o','MarkerSize', marker_size,  'color', color_order(1,:), 'DisplayName', 'SISO','MarkerFaceColor', color_order(1,:));

% plot(MIMO_AoA_0.V(1:3), MIMO_AoA_0.G(1:3), 'r--', 'HandleVisibility','off')
% plot(MIMO_AoA_0.V(3:end), MIMO_AoA_0.G(3:end), 'r-')
% plot(MIMO_raw_eig_AoA_0.V(1:2), MIMO_raw_eig_AoA_0.G(1:2), 'g--', 'HandleVisibility','off')
% plot(MIMO_raw_eig_AoA_0.V(2:end), MIMO_raw_eig_AoA_0.G(2:end), 'g-')

plot(MIMO_raw_eig_AoA_0.V(1:2), MIMO_raw_eig_AoA_0.G(1:2), '--', 'Marker', 's','MarkerSize', marker_size,  'color', color_order(2,:), 'HandleVisibility','off','MarkerFaceColor', color_order(2,:))
line2 = plot(MIMO_raw_eig_AoA_0.V(2:end), MIMO_raw_eig_AoA_0.G(2:end), '-', 'Marker', 's','MarkerSize', marker_size,  'color', color_order(2,:), 'DisplayName', 'MIMO','MarkerFaceColor', color_order(2,:));

% grid on
% grid Minor
yline(1,'HandleVisibility','off')

ylabel('Magnitude', 'interpreter', 'latex', 'FontSize', font_size, 'FontName', font)
% xlabel('Velocity [m/s]',  'interpreter', 'latex', 'FontSize', font_size, 'FontName', font)
set(gca,'XTickLabel',[]);

%title('AoA = 0 deg', 'interpreter', 'latex')
% legend('SISO', "MIMO Smoothed Eigenvalues", "MIMO Unsmoothed Eigenvalues", 'interpreter', 'latex', 'Location', 'southoutside')
% leg = legend('SISO', "MIMO", 'interpreter', 'latex', 'Location', 'south', 'FontSize', font_size, 'FontName', font);
% leg.FontName = font;
% leg.FontSize = font_size;
% leg.ItemTokenSize = [x1,x2];


% scatter(24.2, 1, [], 'red', "filled", 'Marker', '>', 'DisplayName', 'Onset', 'FontSize', font_size,'LabelHorizontalAlignment', 'center', 'HandleVisibility','off')
% scatter(21.5, 1, [], 'green',"filled" , 'Marker', '<', 'DisplayName', 'Offset', 'FontSize', font_size,'LabelHorizontalAlignment', 'center', 'HandleVisibility','off')
xline(24.2, '-', 'Onset', 'FontSize', font_size,'LabelHorizontalAlignment', 'center', 'HandleVisibility','off', 'FontName', font)
xline(21.5, '-', 'Offset', 'FontSize', font_size,'LabelHorizontalAlignment', 'center', 'HandleVisibility','off', 'FontName', font)

p1 = scatter(21.065, 1,marker_size_scatter, 'black','filled', 'Marker', 'o', 'DisplayName', 'MIMO Flutter');
p2 = scatter(21.0377, 1,marker_size_scatter, 'black','filled', 'Marker', '>', 'DisplayName', 'SISO Flutter');

xline(21, '--','HandleVisibility','off')
xline(24, '--','HandleVisibility','off')
text(20.5, 2, 'No PCO', 'FontSize', font_size, 'FontName', font, 'HorizontalAlignment', 'center')
text(22.5, 2, 'PCO', 'FontSize', font_size, 'FontName', font, 'HorizontalAlignment', 'center')
text(24.6, 2, {'Phase','Flip', 'and', 'PCO'}, 'FontSize', font_size, 'FontName', font, 'HorizontalAlignment', 'center')


% axis square
ax = gca;
ax.FontSize = font_size;
ax.FontName = font;

% set(gca,'FontName',font)  % Set it to times

% exportgraphics(gcf, 'Figures/MIMO_SISO_Comparison/Gain_comparison_AoA_0.pdf', 'Resolution',600)
% saveas(gcf, 'Figures/MIMO_SISO_Comparison/Gain_comparison_AoA_0.jpg')
% 
% fh = figure;
% fh.Units = 'inches';
% fh.Position(3:4) = [3.25,3.5];

% subplot(2, 1, 2)
nexttile(tcl)
plot(SISO_AoA_0.V(1:3), SISO_AoA_0.omega(1:3), '--', 'Marker', 'o','MarkerSize', marker_size,  'color', color_order(1,:), 'HandleVisibility','off','MarkerFaceColor', color_order(1,:))
hold on
plot(SISO_AoA_0.V(3:end), SISO_AoA_0.omega(3:end), '-', 'Marker', 'o','MarkerSize', marker_size,  'color', color_order(1,:),'MarkerFaceColor', color_order(1,:))

% plot(MIMO_AoA_0.V(1:3), MIMO_AoA_0.omega(1:3), 'r--', 'HandleVisibility','off')
% plot(MIMO_AoA_0.V(3:end), MIMO_AoA_0.omega(3:end), 'r-')
% plot(MIMO_raw_eig_AoA_0.V(1:2), MIMO_raw_eig_AoA_0.omega(1:2), 'g--', 'HandleVisibility','off')
% plot(MIMO_raw_eig_AoA_0.V(2:end), MIMO_raw_eig_AoA_0.omega(2:end), 'g-')

plot(MIMO_raw_eig_AoA_0.V(1:2), MIMO_raw_eig_AoA_0.omega(1:2), '--', 'Marker', 's','MarkerSize', marker_size,  'color', color_order(2,:), 'HandleVisibility','off','MarkerFaceColor', color_order(2,:))
plot(MIMO_raw_eig_AoA_0.V(2:end), MIMO_raw_eig_AoA_0.omega(2:end), '-', 'Marker', 's','MarkerSize', marker_size,  'color', color_order(2,:),'MarkerFaceColor', color_order(2,:))

xline(21, '--','HandleVisibility','off')
xline(24, '--','HandleVisibility','off')

scatter(21.065, 20.475, marker_size_scatter,'black','filled', 'Marker', 'o', 'DisplayName', 'MIMO Flutter');
scatter(21.0377, 20.4187,marker_size_scatter, 'black','filled', 'Marker', '>', 'DisplayName', 'SISO Flutter');

% grid on
% grid Minor


ylabel('Phase cross-over frequency [Hz]', 'interpreter', 'latex', 'FontSize', font_size, 'FontName', font)
xlabel('Velocity [m/s]',  'interpreter', 'latex', 'FontSize', font_size, 'FontName', font)
%title('AoA = 0 deg', 'interpreter', 'latex')
% legend('SISO', "MIMO Smoothed Eigenvalues", "MIMO Unsmoothed Eigenvalues", 'interpreter', 'latex', 'Location', 'north')
% leg = legend('SISO', "MIMO", 'interpreter', 'latex', 'Location', 'north', 'FontSize', font_size, 'FontName', font);
% leg.FontName = font;
% leg.FontSize = font_size;
% leg.ItemTokenSize = [x1,x2];

% axis square
ax = gca;
ax.FontSize = font_size;
ax.FontName = font;

leg = legend(nexttile(2), [line1, line2, p2, p1]);
leg.FontName = font;
leg.FontSize = font_size;
leg.ItemTokenSize = [x1,x2];
leg.Location = 'north';

tcl.TileSpacing = 'none';
tcl.Padding = 'none';

exportgraphics(gcf, 'Figures/MIMO_SISO_Comparison/Gain_omega_comparison_AoA_0.pdf','Resolution',600)
saveas(gcf, 'Figures/MIMO_SISO_Comparison/Gain_omega_comparison_AoA_0.jpg')

% exportgraphics(gcf, 'Figures/MIMO_SISO_Comparison/omega_comparison_AoA_0.pdf', 'Resolution',600)
% saveas(gcf, 'Figures/MIMO_SISO_Comparison/omega_comparison_AoA_0.jpg')


fh = figure;
fh.Units = 'inches';
fh.Position(3:4) = [3.25,3.5];
plot(SISO_AoA_0.V(1:3), SISO_AoA_0.dpf(1:3), '--', 'Marker', 'o','MarkerSize', marker_size,  'color', color_order(1,:), 'HandleVisibility','off','MarkerFaceColor', color_order(1,:))
hold on
plot(SISO_AoA_0.V(3:end), SISO_AoA_0.dpf(3:end), '-', 'Marker', 'o','MarkerSize', marker_size,  'color', color_order(1,:),'MarkerFaceColor', color_order(1,:))

% plot(MIMO_AoA_0.V(1:3), MIMO_AoA_0.dpf(1:3), 'r--', 'HandleVisibility','off')
% plot(MIMO_AoA_0.V(3:end), MIMO_AoA_0.dpf(3:end), 'r-')
% plot(MIMO_raw_eig_AoA_0.V(1:2), MIMO_raw_eig_AoA_0.dpf(1:2), 'g--', 'HandleVisibility','off')
% plot(MIMO_raw_eig_AoA_0.V(2:end), MIMO_raw_eig_AoA_0.dpf(2:end), 'g-')

plot(MIMO_raw_eig_AoA_0.V(1:2), MIMO_raw_eig_AoA_0.dpf(1:2), '--', 'Marker', 's','MarkerSize', marker_size,  'color', color_order(2,:), 'HandleVisibility','off','MarkerFaceColor', color_order(2,:))
plot(MIMO_raw_eig_AoA_0.V(2:end), MIMO_raw_eig_AoA_0.dpf(2:end), '-', 'Marker', 's','MarkerSize', marker_size,  'color', color_order(2,:),'MarkerFaceColor', color_order(2,:))

% grid
yline(0,'HandleVisibility','off')

ylabel('$\Delta p_f$ [gram]', 'interpreter', 'latex', 'FontSize', font_size, 'FontName', font)
xlabel('Velocity [m/s]',  'interpreter', 'latex', 'FontSize', font_size, 'FontName', font)
%title('AoA = 0 deg', 'interpreter', 'latex')
% legend('SISO', "MIMO Smoothed Eigenvalues", "MIMO Unsmoothed Eigenvalues", 'interpreter', 'latex', 'Location', 'south')
legend('SISO', "MIMO", 'interpreter', 'latex', 'Location', 'south', 'FontSize', font_size, 'FontName', font)

% scatter(24.2, 1, marker_size, 'red', "filled", 'Marker', '>', 'DisplayName', 'Onset', 'FontSize', font_size,'LabelHorizontalAlignment', 'center', 'HandleVisibility','off')
% scatter(21.5, 1, marker_size, 'green',"filled" , 'Marker', '<', 'DisplayName', 'Offset', 'FontSize', font_size,'LabelHorizontalAlignment', 'center', 'HandleVisibility','off')
axis square
ax = gca;
ax.FontSize = font_size;
ax.FontName = font;

exportgraphics(gcf, 'Figures/MIMO_SISO_Comparison/Dpf_comparison_AoA_0.pdf', 'Resolution',600)
saveas(gcf, 'Figures/MIMO_SISO_Comparison/Dpf_comparison_AoA_0.jpg')


%% AoA = 2

fh = figure;
fh.Units = 'inches';
fh.Position(3:4) = [3.25,3.5];
tcl = tiledlayout(2,1);


% subplot(2, 1, 1)
nexttile(tcl)
plot(SISO_AoA_2.V(1:2), SISO_AoA_2.G(1:2), '--', 'Marker', 'o','MarkerSize', marker_size,  'color', color_order(1,:),'MarkerSize', marker_size,  'color', color_order(1,:),'HandleVisibility','off','MarkerFaceColor', color_order(1,:))
hold on
line1 = plot(SISO_AoA_2.V(2:end), SISO_AoA_2.G(2:end), '-', 'Marker', 'o','MarkerSize', marker_size,  'color', color_order(1,:),'MarkerSize', marker_size,  'color', color_order(1,:), 'DisplayName', 'SISO','MarkerFaceColor', color_order(1,:));

% plot(MIMO_AoA_2.V(1:3), MIMO_AoA_2.G(1:3), 'r--','HandleVisibility','off')
% plot(MIMO_AoA_2.V(3:end), MIMO_AoA_2.G(3:end), 'r-')
% 
% plot(MIMO_raw_eig_AoA_2.V(1:2), MIMO_raw_eig_AoA_2.G(1:2), 'g--','HandleVisibility','off')
% plot(MIMO_raw_eig_AoA_2.V(2:end), MIMO_raw_eig_AoA_2.G(2:end), 'g-')

plot(MIMO_raw_eig_AoA_2.V(1:2), MIMO_raw_eig_AoA_2.G(1:2), '--', 'Marker', 's','MarkerSize', marker_size,  'color', color_order(2,:),'HandleVisibility','off','MarkerFaceColor', color_order(2,:))
line2 = plot(MIMO_raw_eig_AoA_2.V(2:end), MIMO_raw_eig_AoA_2.G(2:end), '-', 'Marker', 's','MarkerSize', marker_size,  'color', color_order(2,:), 'DisplayName', 'MIMO','MarkerFaceColor', color_order(2,:));
% grid on
% grid Minor
yline(1,'HandleVisibility','off')

ylabel('Magnitude', 'interpreter', 'latex', 'FontSize', font_size, 'FontName', font)
% xlabel('Velocity [m/s]',  'interpreter', 'latex', 'FontSize', font_size, 'FontName', font)
set(gca,'XTickLabel',[]);

%title('AoA = 2 deg', 'interpreter', 'latex')
% legend('SISO', "MIMO Smoothed Eigenvalues", "MIMO Unsmoothed Eigenvalues", 'interpreter', 'latex', 'Location', 'southoutside')

% leg = legend('SISO', "MIMO", 'interpreter', 'latex', 'Location', 'northeast', 'FontSize', font_size, 'FontName', font);
% leg.FontName = font;
% leg.FontSize = font_size;
% leg.ItemTokenSize = [x1,x2];

% scatter(21.6, 1, [], 'red', "filled", 'Marker', '>', 'DisplayName', 'Onset', 'FontSize', font_size,'LabelHorizontalAlignment', 'center', 'HandleVisibility','off')
% scatter(21, 1, [], 'green',"filled" , 'Marker', '<', 'DisplayName', 'Offset', 'FontSize', font_size,'LabelHorizontalAlignment', 'center', 'HandleVisibility','off')
xline(21.6, '-', 'Onset', 'FontSize', font_size,'LabelHorizontalAlignment', 'center', 'LabelVerticalAlignment', 'bottom', 'HandleVisibility','off', 'FontName', font)
xline(21, '-', 'Offset', 'FontSize', font_size,'LabelHorizontalAlignment', 'center', 'LabelVerticalAlignment', 'bottom', 'HandleVisibility','off', 'FontName', font)
p1 = scatter(20.0026, 1, marker_size_scatter, 'black','filled', 'Marker', 'o', 'DisplayName', 'MIMO Flutter');
p2 = scatter(19.8377, 1, marker_size_scatter,'black','filled', 'Marker', '>', 'DisplayName', 'SISO Flutter');






xline(20, '--','HandleVisibility','off')
xline(22, '--','HandleVisibility','off')
text(19.5, 3.5, 'No PCO', 'FontSize', font_size, 'FontName', font, 'HorizontalAlignment', 'center')
text(20.5, 3.5, 'PCO', 'FontSize', font_size, 'FontName', font, 'HorizontalAlignment', 'center')
text(22.75, 3.5, {'Phase Flip', 'and PCO'}, 'FontSize', font_size, 'FontName', font, 'HorizontalAlignment', 'center')

% ylim([0,4.5])
% axis square
ax = gca;
ax.FontSize = font_size;
ax.FontName = font;


% exportgraphics(gcf, 'Figures/MIMO_SISO_Comparison/Gain_comparison_AoA_2.pdf', 'Resolution',600)
% saveas(gcf, 'Figures/MIMO_SISO_Comparison/Gain_comparison_AoA_2.jpg')
% 
% fh = figure;
% fh.Units = 'inches';
% fh.Position(3:4) = [3.25,3.5];
% subplot(2, 1, 2)
nexttile(tcl)
plot(SISO_AoA_2.V(1:2), SISO_AoA_2.omega(1:2), '--', 'Marker', 'o','MarkerSize', marker_size,  'color', color_order(1,:),'MarkerSize', marker_size,  'color', color_order(1,:),'HandleVisibility','off','MarkerFaceColor', color_order(1,:))
hold on
plot(SISO_AoA_2.V(2:end), SISO_AoA_2.omega(2:end), '-', 'Marker', 'o','MarkerSize', marker_size,  'color', color_order(1,:),'MarkerSize', marker_size,  'color', color_order(1,:),'MarkerFaceColor', color_order(1,:))

% plot(MIMO_AoA_2.V(1:3), MIMO_AoA_2.omega(1:3), 'r--','HandleVisibility','off')
% plot(MIMO_AoA_2.V(3:end), MIMO_AoA_2.omega(3:end), 'r-')
% 
% plot(MIMO_raw_eig_AoA_2.V(1:2), MIMO_raw_eig_AoA_2.omega(1:2), 'g--','HandleVisibility','off')
% plot(MIMO_raw_eig_AoA_2.V(2:end), MIMO_raw_eig_AoA_2.omega(2:end), 'g-')

plot(MIMO_raw_eig_AoA_2.V(1:2), MIMO_raw_eig_AoA_2.omega(1:2), '--', 'Marker', 's','MarkerSize', marker_size,  'color', color_order(2,:),'HandleVisibility','off','MarkerFaceColor', color_order(2,:))
plot(MIMO_raw_eig_AoA_2.V(2:end), MIMO_raw_eig_AoA_2.omega(2:end), '-', 'Marker', 's','MarkerSize', marker_size,  'color', color_order(2,:),'MarkerFaceColor', color_order(2,:))

xline(20, '--','HandleVisibility','off')
xline(22, '--','HandleVisibility','off')

scatter(20.0026, 20.0185,marker_size_scatter, 'black','filled', 'Marker', 'o', 'DisplayName', 'MIMO Flutter');
scatter(19.8377, 19.9789, marker_size_scatter,'black','filled', 'Marker', '>', 'DisplayName', 'SISO Flutter');

% grid on
% grid Minor

ylabel('Phase cross-over frequency [Hz]', 'interpreter', 'latex', 'FontSize', font_size, 'FontName', font)
xlabel('Velocity [m/s]',  'interpreter', 'latex', 'FontSize', font_size, 'FontName', font)
%title('AoA = 2 deg', 'interpreter', 'latex')
% legend('SISO', "MIMO Smoothed Eigenvalues", "MIMO Unsmoothed Eigenvalues", 'interpreter', 'latex', 'Location', 'north')

% leg = legend('SISO', "MIMO", 'interpreter', 'latex', 'Location', 'north', 'FontSize', font_size, 'FontName', font); % north;
% leg.FontName = font;
% leg.FontSize = font_size;
% leg.ItemTokenSize = [x1,x2];

% leg = legend('SISO', "MIMO", "PFM", 'interpreter', 'latex', 'Location', 'northeast', 'FontSize', font_size, 'FontName', font);
leg = legend(nexttile(2), [line1, line2, p2, p1]);
leg.FontName = font;
leg.FontSize = font_size;
leg.ItemTokenSize = [x1,x2];
leg.Location = 'north';


% axis square
ax = gca;
ax.FontSize = font_size;
ax.FontName = font;

tcl.TileSpacing = 'none';
tcl.Padding = 'none';

exportgraphics(gcf, 'Figures/MIMO_SISO_Comparison/Gain_omega_comparison_AoA_2.pdf', 'Resolution',600)
saveas(gcf, 'Figures/MIMO_SISO_Comparison/Gain_omega_comparison_AoA_2.jpg')
% exportgraphics(gcf, 'Figures/MIMO_SISO_Comparison/omega_comparison_AoA_2.pdf', 'Resolution',600)
% saveas(gcf, 'Figures/MIMO_SISO_Comparison/omega_comparison_AoA_2.jpg')



fh = figure;
fh.Units = 'inches';
fh.Position(3:4) = [3.25,3.5];
plot(SISO_AoA_2.V(1:2), SISO_AoA_2.dpf(1:2), '--', 'Marker', 'o','MarkerSize', marker_size,  'color', color_order(1,:),'HandleVisibility','off','MarkerFaceColor', color_order(1,:))
hold on
plot(SISO_AoA_2.V(2:end), SISO_AoA_2.dpf(2:end), '-', 'Marker', 'o','MarkerSize', marker_size,  'color', color_order(1,:),'MarkerFaceColor', color_order(1,:))

% plot(MIMO_AoA_2.V(1:3), MIMO_AoA_2.dpf(1:3), 'r--','HandleVisibility','off')
% plot(MIMO_AoA_2.V(3:end), MIMO_AoA_2.dpf(3:end), 'r-')
% 
% plot(MIMO_raw_eig_AoA_2.V(1:2), MIMO_raw_eig_AoA_2.dpf(1:2), 'g--','HandleVisibility','off')
% plot(MIMO_raw_eig_AoA_2.V(2:end), MIMO_raw_eig_AoA_2.dpf(2:end), 'g-')


plot(MIMO_raw_eig_AoA_2.V(1:2), MIMO_raw_eig_AoA_2.dpf(1:2), '--', 'Marker', 's','MarkerSize', marker_size,  'color', color_order(2,:),'HandleVisibility','off','MarkerFaceColor', color_order(2,:))
plot(MIMO_raw_eig_AoA_2.V(2:end), MIMO_raw_eig_AoA_2.dpf(2:end), '-', 'Marker', 's','MarkerSize', marker_size,  'color', color_order(2,:),'MarkerFaceColor', color_order(2,:))

yline(0, 'HandleVisibility', 'off')
% grid
% yline(1,'HandleVisibility','off')

ylabel('$\Delta p_f$ [gram]', 'interpreter', 'latex', 'FontSize', font_size, 'FontName', font)
xlabel('Velocity [m/s]',  'interpreter', 'latex', 'FontSize', font_size, 'FontName', font)
%title('AoA = 2 deg', 'interpreter', 'latex')
% legend('SISO', "MIMO Smoothed Eigenvalues", "MIMO Unsmoothed Eigenvalues", 'interpreter', 'latex', 'Location', 'southwest')
legend('SISO', "MIMO", 'interpreter', 'latex', 'Location', 'southwest', 'FontSize', font_size, 'FontName', font)

% scatter(21.6, 1, marker_size,, 'red', "filled", 'Marker', '>', 'DisplayName', 'Onset', 'FontSize', font_size,'LabelHorizontalAlignment', 'center', 'HandleVisibility','off')
% scatter(21, 1, marker_size,, 'green',"filled" , 'Marker', '<', 'DisplayName', 'Offset', 'FontSize', font_size,'LabelHorizontalAlignment', 'center', 'HandleVisibility','off')

axis square
ax = gca;
ax.FontSize = font_size;
ax.FontName = font;

exportgraphics(gcf, 'Figures/MIMO_SISO_Comparison/Dpf_comparison_AoA_2.pdf', 'Resolution',600)
saveas(gcf, 'Figures/MIMO_SISO_Comparison/Dpf_comparison_AoA_2.jpg')


%% AoA = 4

fh = figure;
fh.Units = 'inches';
fh.Position(3:4) = [3.25,3.5];
tcl = tiledlayout(2,1);


% subplot(2, 1, 1)
nexttile(tcl)
plot(SISO_AoA_4.V(1:2), SISO_AoA_4.G(1:2), '--', 'Marker', 'o','MarkerSize', marker_size,  'color', color_order(1,:),'HandleVisibility','off','MarkerFaceColor', color_order(1,:))
hold on
line1 = plot(SISO_AoA_4.V(2:end), SISO_AoA_4.G(2:end), '-', 'Marker', 'o','MarkerSize', marker_size,  'color', color_order(1,:), 'DisplayName', 'SISO','MarkerFaceColor', color_order(1,:));

% plot(MIMO_AoA_4.V(1:2), MIMO_AoA_4.G(1:2), 'r--','HandleVisibility','off')
% hold on
% plot(MIMO_AoA_4.V(2:end), MIMO_AoA_4.G(2:end), 'r-')

% plot(MIMO_raw_eig_AoA_4.V(1:2), MIMO_raw_eig_AoA_4.G(1:2), 'g--','HandleVisibility','off')
% hold on
% plot(MIMO_raw_eig_AoA_4.V(2:end), MIMO_raw_eig_AoA_4.G(2:end), 'g-')

plot(MIMO_raw_eig_AoA_4.V(1:2), MIMO_raw_eig_AoA_4.G(1:2), '--', 'Marker', 's','MarkerSize', marker_size,  'color', color_order(2,:),'HandleVisibility','off','MarkerFaceColor', color_order(2,:))
hold on
line2 = plot(MIMO_raw_eig_AoA_4.V(2:end), MIMO_raw_eig_AoA_4.G(2:end), '-', 'Marker', 's','MarkerSize', marker_size,  'color', color_order(2,:), 'DisplayName', 'MIMO','MarkerFaceColor', color_order(2,:));

% grid
yline(1,'HandleVisibility','off')

ylabel('Magnitude', 'interpreter', 'latex', 'FontSize', font_size, 'FontName', font)
% xlabel('Velocity [m/s]',  'interpreter', 'latex', 'FontSize', font_size, 'FontName', font)
set(gca,'XTickLabel',[]);

%title('AoA = 4 deg', 'interpreter', 'latex')
% legend('SISO', "MIMO Smoothed Eigenvalues", "MIMO Unsmoothed Eigenvalues", 'interpreter', 'latex', 'Location', 'best')
% leg = legend('SISO', "MIMO", 'interpreter', 'latex', 'Location', 'northeast', 'FontSize', font_size, 'FontName', font);
% leg.FontName = font;
% leg.FontSize = font_size;
% leg.ItemTokenSize = [x1,x2];

% scatter(21, 1, marker_size,, 'red', "filled", 'Marker', '>', 'DisplayName', 'Onset', 'FontSize', font_size,'LabelHorizontalAlignment', 'center', 'HandleVisibility','off')
% scatter(19.5, 1, marker_size,, 'green',"filled" , 'Marker', '<', 'DisplayName', 'Offset', 'FontSize', font_size,'LabelHorizontalAlignment', 'center', 'HandleVisibility','off')
xline(21, '-', 'Onset', 'FontSize', font_size,'LabelHorizontalAlignment', 'center', 'HandleVisibility','off', 'FontName', font)
xline(19.5, '-', 'Offset', 'FontSize', font_size,'LabelHorizontalAlignment', 'center', 'HandleVisibility','off', 'FontName', font)
p1 = scatter(18.588, 1,marker_size_scatter, 'black','filled', 'Marker', 'o', 'DisplayName', 'MIMO Flutter');
p2 = scatter(17.9338, 1,marker_size_scatter, 'black','filled', 'Marker', '>', 'DisplayName', 'SISO Flutter');



xline(18.5, '--','HandleVisibility','off')
xline(19, '--','HandleVisibility','off')
text(18.25, 0.5, {'No', 'PCO'}, 'FontSize', font_size, 'FontName', font, 'HorizontalAlignment', 'center')
text(18.76, 0.5, 'PCO', 'FontSize', font_size, 'FontName', font, 'HorizontalAlignment', 'center')
text(20.25, 0.5, {'Phase Flip', 'and PCO'}, 'FontSize', font_size, 'FontName', font, 'HorizontalAlignment', 'center')

xlim([17.8, MIMO_raw_eig_AoA_4.V(end)])

% axis square
ax = gca;
ax.FontSize = font_size;
ax.FontName = font;

% exportgraphics(gcf, 'Figures/MIMO_SISO_Comparison/Gain_comparison_AoA_4.pdf', 'Resolution',600)
% saveas(gcf, 'Figures/MIMO_SISO_Comparison/Gain_comparison_AoA_4.jpg')
% 
% fh = figure;
% fh.Units = 'inches';
% fh.Position(3:4) = [3.25,3.5];
% subplot(2, 1, 2)
nexttile(tcl)
plot(SISO_AoA_4.V(1:2), SISO_AoA_4.omega(1:2), '--', 'Marker', 'o','MarkerSize', marker_size,  'color', color_order(1,:),'HandleVisibility','off','MarkerFaceColor', color_order(1,:))
hold on
plot(SISO_AoA_4.V(2:end), SISO_AoA_4.omega(2:end), '-', 'Marker', 'o','MarkerSize', marker_size,  'color', color_order(1,:),'MarkerFaceColor', color_order(1,:))

% plot(MIMO_AoA_4.V(1:2), MIMO_AoA_4.omega(1:2), 'r--','HandleVisibility','off')
% hold on
% plot(MIMO_AoA_4.V(2:end), MIMO_AoA_4.omega(2:end), 'r-')
% 
% plot(MIMO_raw_eig_AoA_4.V(1:2), MIMO_raw_eig_AoA_4.omega(1:2), 'g--','HandleVisibility','off')
% hold on
% plot(MIMO_raw_eig_AoA_4.V(2:end), MIMO_raw_eig_AoA_4.omega(2:end), 'g-')

plot(MIMO_raw_eig_AoA_4.V(1:2), MIMO_raw_eig_AoA_4.omega(1:2), '--', 'Marker', 's','MarkerSize', marker_size,  'color', color_order(2,:),'HandleVisibility','off','MarkerFaceColor', color_order(2,:))
hold on
plot(MIMO_raw_eig_AoA_4.V(2:end), MIMO_raw_eig_AoA_4.omega(2:end), '-', 'Marker', 's','MarkerSize', marker_size,  'color', color_order(2,:),'MarkerFaceColor', color_order(2,:))

xline(18.5, '--','HandleVisibility','off')
xline(19, '--','HandleVisibility','off')

% grid on
% grid Minor
scatter(18.588, 19.5869,marker_size_scatter, 'black','filled', 'Marker', 'o', 'DisplayName', 'MIMO Flutter');
scatter(17.9338, 19.6094,marker_size_scatter, 'black','filled', 'Marker', '>', 'DisplayName', 'SISO Flutter');


ylabel('Phase cross-over frequency [Hz]', 'interpreter', 'latex', 'FontSize', font_size, 'FontName', font)
xlabel('Velocity [m/s]',  'interpreter', 'latex', 'FontSize', font_size, 'FontName', font)
%title('AoA = 4 deg', 'interpreter', 'latex')
% legend('SISO', "MIMO Smoothed Eigenvalues", "MIMO Unsmoothed Eigenvalues", 'interpreter', 'latex', 'Location', 'best')
% leg = legend('SISO', "MIMO", 'interpreter', 'latex', 'Location', 'northeast', 'FontSize', font_size, 'FontName', font);
% leg.FontName = font;
% leg.FontSize = font_size;
% leg.ItemTokenSize = [x1,x2];

xlim([17.8, MIMO_raw_eig_AoA_4.V(end)])
% axis square
ax = gca;
ax.FontSize = font_size;
ax.FontName = font;

leg = legend(nexttile(2), [line1, line2, p2, p1]);
leg.FontName = font;
leg.FontSize = font_size;
leg.ItemTokenSize = [x1,x2];
leg.Location = 'northeast';

tcl.TileSpacing = 'none';
tcl.Padding = 'none';

exportgraphics(gcf, 'Figures/MIMO_SISO_Comparison/Gain_omega_comparison_AoA_4.pdf', 'Resolution',600)
saveas(gcf, 'Figures/MIMO_SISO_Comparison/Gain_omega_comparison_AoA_4.jpg')
% exportgraphics(gcf, 'Figures/MIMO_SISO_Comparison/omega_comparison_AoA_4.pdf', 'Resolution',600)
% saveas(gcf, 'Figures/MIMO_SISO_Comparison/omega_comparison_AoA_4.jpg')


fh = figure;
fh.Units = 'inches';
fh.Position(3:4) = [3.25,3.5];
plot(SISO_AoA_4.V(1:2), SISO_AoA_4.dpf(1:2), '--', 'Marker', 'o','MarkerSize', marker_size,  'color', color_order(1,:),'HandleVisibility','off','MarkerFaceColor', color_order(1,:))
hold on
plot(SISO_AoA_4.V(2:end), SISO_AoA_4.dpf(2:end), '-', 'Marker', 'o','MarkerSize', marker_size,  'color', color_order(1,:),'MarkerFaceColor', color_order(1,:))

% plot(MIMO_AoA_4.V(1:2), MIMO_AoA_4.dpf(1:2), 'r--','HandleVisibility','off')
% hold on
% plot(MIMO_AoA_4.V(2:end), MIMO_AoA_4.dpf(2:end), 'r-')

% plot(MIMO_raw_eig_AoA_4.V(1:2), MIMO_raw_eig_AoA_4.dpf(1:2), 'g--','HandleVisibility','off')
% hold on
% plot(MIMO_raw_eig_AoA_4.V(2:end), MIMO_raw_eig_AoA_4.dpf(2:end), 'g-')

plot(MIMO_raw_eig_AoA_4.V(1:2), MIMO_raw_eig_AoA_4.dpf(1:2), '--', 'Marker', 's','MarkerSize', marker_size,  'color', color_order(2,:),'HandleVisibility','off','MarkerFaceColor', color_order(2,:))
hold on
plot(MIMO_raw_eig_AoA_4.V(2:end), MIMO_raw_eig_AoA_4.dpf(2:end), '-', 'Marker', 's','MarkerSize', marker_size,  'color', color_order(2,:),'MarkerFaceColor', color_order(2,:))

% grid
yline(0,'HandleVisibility','off')

ylabel('$\Delta p_f$ [gram]', 'interpreter', 'latex', 'FontSize', font_size, 'FontName', font)
xlabel('Velocity [m/s]',  'interpreter', 'latex', 'FontSize', font_size, 'FontName', font)
%title('AoA = 4 deg', 'interpreter', 'latex')
% legend('SISO', "MIMO Smoothed Eigenvalues", "MIMO Unsmoothed Eigenvalues", 'interpreter', 'latex', 'Location', 'best')
legend('SISO', "MIMO", 'interpreter', 'latex', 'Location', 'northeast', 'FontSize', font_size, 'FontName', font)

% scatter(21, 1, marker_size, 'red', "filled", 'Marker', '>', 'DisplayName', 'Onset', 'FontSize', font_size,'LabelHorizontalAlignment', 'center', 'HandleVisibility','off')
% scatter(19.5, 1, marker_size, 'green',"filled" , 'Marker', '<', 'DisplayName', 'Offset', 'FontSize', font_size,'LabelHorizontalAlignment', 'center', 'HandleVisibility','off')
axis square
ax = gca;
ax.FontSize = font_size;
ax.FontName = font;


exportgraphics(gcf, 'Figures/MIMO_SISO_Comparison/Dpf_comparison_AoA_4.pdf', 'Resolution',600)
saveas(gcf, 'Figures/MIMO_SISO_Comparison/Dpf_comparison_AoA_4.jpg')

%% AoA = 6

fh = figure;
fh.Units = 'inches';
fh.Position(3:4) = [3.25,3.5];

tcl = tiledlayout(2,1);

% ,'MarkerFaceColor', 'auto'

% subplot(2, 1, 1)
nexttile(tcl)
plot(SISO_AoA_6.V(1:4), SISO_AoA_6.G(1:4), '--', 'Marker', 'o','MarkerSize', marker_size,  'color', color_order(1,:),'HandleVisibility','off','MarkerFaceColor', color_order(1,:))
hold on
line1 = plot(SISO_AoA_6.V(4:end), SISO_AoA_6.G(4:end), '-', 'Marker', 'o','MarkerSize', marker_size,  'color', color_order(1,:), 'DisplayName', 'SISO','MarkerFaceColor', color_order(1,:));

% plot(MIMO_AoA_6.V(1:4), MIMO_AoA_6.G(1:4), 'r--','HandleVisibility','off')
% hold on
% plot(MIMO_AoA_6.V(4:end), MIMO_AoA_6.G(4:end), 'r-')


% % Check following plot
% plot(MIMO_raw_eig_AoA_6.V(1:3), MIMO_raw_eig_AoA_6.G(1:3), 'g--','HandleVisibility','off')
% plot(MIMO_raw_eig_AoA_6.V(3:end), MIMO_raw_eig_AoA_6.G(3:end), 'g-')

plot(MIMO_raw_eig_AoA_6.V(1:3), MIMO_raw_eig_AoA_6.G(1:3), '--', 'Marker', 's','MarkerSize', marker_size,  'color', color_order(2,:),'HandleVisibility','off','MarkerFaceColor', color_order(2,:))
line2 = plot(MIMO_raw_eig_AoA_6.V(3:end), MIMO_raw_eig_AoA_6.G(3:end), '-', 'Marker', 's','MarkerSize', marker_size,  'color', color_order(2,:), 'DisplayName', 'MIMO','MarkerFaceColor', color_order(2,:));


% grid
yline(1,'HandleVisibility','off')

ylabel('Magnitude', 'interpreter', 'latex', 'FontSize', font_size, 'FontName', font)
% xlabel('Velocity [m/s]',  'interpreter', 'latex', 'FontSize', font_size, 'FontName', font)
set(gca,'XTickLabel',[]);

%title('AoA = 6 deg', 'interpreter', 'latex')
% legend('SISO', "MIMO Smoothed Eigenvalues", "MIMO Unsmoothed Eigenvalues", 'interpreter', 'latex', 'Location', 'best')
% leg = legend('SISO', "MIMO", 'interpreter', 'latex', 'Location', 'northwest', 'FontSize', font_size, 'FontName', font);
% leg.FontName = font;
% leg.FontSize = font_size;
% leg.ItemTokenSize = [x1,x2];

yline(1,'HandleVisibility','off')

% xline(24.2, '-', 'Onset', 'FontSize', font_size,'LabelHorizontalAlignment', 'center', 'HandleVisibility','off')
% xline(21.5, '-', 'Offset', 'FontSize', font_size,'LabelHorizontalAlignment', 'center', 'HandleVisibility','off')
p1 = scatter(19.02, 1,marker_size_scatter, 'black','filled', 'Marker', 'o', 'DisplayName', 'MIMO Flutter');
p2 = scatter(18.2468, 1,marker_size_scatter, 'black','filled', 'Marker', '>', 'DisplayName', 'SISO Flutter');



xline(18, '--','HandleVisibility','off')
xline(19, '--','HandleVisibility','off')
text(17, 1.5, {'No', 'PCO'}, 'FontSize', font_size, 'FontName', font, 'HorizontalAlignment', 'center')
text(18.5, 1.5, 'PCO', 'FontSize', font_size, 'FontName', font, 'HorizontalAlignment', 'center')
text(20, 1.5, {'Phase', 'Flip', 'and PCO'}, 'FontSize', font_size, 'FontName', font, 'HorizontalAlignment', 'center')



% axis square
ax = gca;
ax.FontSize = font_size;
ax.FontName = font;

% exportgraphics(gcf, 'Figures/MIMO_SISO_Comparison/Gain_comparison_AoA_6.pdf', 'Resolution',600)
% saveas(gcf, 'Figures/MIMO_SISO_Comparison/Gain_comparison_AoA_6.jpg')
% 
% fh = figure;
% fh.Units = 'inches';
% fh.Position(3:4) = [3.25,3.5];

% subplot(2, 1, 2)
nexttile(tcl)
plot(SISO_AoA_6.V(1:4), SISO_AoA_6.omega(1:4), '--', 'Marker', 'o','MarkerSize', marker_size,  'color', color_order(1,:),'HandleVisibility','off','MarkerFaceColor', color_order(1,:))
hold on
plot(SISO_AoA_6.V(4:end), SISO_AoA_6.omega(4:end), '-', 'Marker', 'o','MarkerSize', marker_size,  'color', color_order(1,:),'MarkerFaceColor', color_order(1,:))

% plot(MIMO_AoA_6.V(1:4), MIMO_AoA_6.omega(1:4), 'r--','HandleVisibility','off')
% hold on
% plot(MIMO_AoA_6.V(4:end), MIMO_AoA_6.omega(4:end), 'r-')


% % Check following plot
% plot(MIMO_raw_eig_AoA_6.V(1:3), MIMO_raw_eig_AoA_6.omega(1:3), 'g--','HandleVisibility','off')
% plot(MIMO_raw_eig_AoA_6.V(3:end), MIMO_raw_eig_AoA_6.omega(3:end), 'g-')

% Check following plot
plot(MIMO_raw_eig_AoA_6.V(1:3), MIMO_raw_eig_AoA_6.omega(1:3), '--', 'Marker', 's','MarkerSize', marker_size,  'color', color_order(2,:),'HandleVisibility','off','MarkerFaceColor', color_order(2,:))
plot(MIMO_raw_eig_AoA_6.V(3:end), MIMO_raw_eig_AoA_6.omega(3:end), '-', 'Marker', 's','MarkerSize', marker_size,  'color', color_order(2,:),'MarkerFaceColor', color_order(2,:))


% grid
% yline(1,'HandleVisibility','off')

scatter(19.02, 18.8956,marker_size_scatter, 'black','filled', 'Marker', 'o', 'DisplayName', 'MIMO Flutter');
scatter(18.2468, 19.2708,marker_size_scatter, 'black','filled', 'Marker', '>', 'DisplayName', 'SISO Flutter');

ylabel('Phase cross-over frequency [Hz]', 'interpreter', 'latex', 'FontSize', font_size, 'FontName', font)
xlabel('Velocity [m/s]',  'interpreter', 'latex', 'FontSize', font_size, 'FontName', font)

xline(18, '--','HandleVisibility','off')
xline(19, '--','HandleVisibility','off')

%title('AoA = 6 deg', 'interpreter', 'latex')
% legend('SISO', "MIMO Smoothed Eigenvalues", "MIMO Unsmoothed Eigenvalues", 'interpreter', 'latex', 'Location', 'southwest')
% leg = legend('SISO', "MIMO", 'interpreter', 'latex', 'Location', 'southwest', 'FontSize', font_size, 'FontName', font);
% leg.FontName = font;
% leg.FontSize = font_size;
% leg.ItemTokenSize = [x1,x2];

% axis square
ax = gca;
ax.FontSize = font_size;
ax.FontName = font;
% yline(1,'HandleVisibility','off')

leg = legend(nexttile(2), [line1, line2, p2, p1]);
leg.FontName = font;
leg.FontSize = font_size;
leg.ItemTokenSize = [x1,x2];
leg.Location = 'southwest';

tcl.TileSpacing = 'none';
tcl.Padding = 'none';

exportgraphics(gcf, 'Figures/MIMO_SISO_Comparison/Gain_omega_comparison_AoA_6.pdf', 'Resolution',600)
saveas(gcf, 'Figures/MIMO_SISO_Comparison/Gain_omega_comparison_AoA_6.jpg')
% exportgraphics(gcf, 'Figures/MIMO_SISO_Comparison/omega_comparison_AoA_6.pdf', 'Resolution',600)
% saveas(gcf, 'Figures/MIMO_SISO_Comparison/omega_comparison_AoA_6.jpg')




fh = figure;
fh.Units = 'inches';
fh.Position(3:4) = [3.25,3.5];
plot(SISO_AoA_6.V(1:4), SISO_AoA_6.dpf(1:4), '--', 'Marker', 'o','MarkerSize', marker_size,  'color', color_order(1,:),'HandleVisibility','off','MarkerFaceColor', color_order(1,:))
hold on
plot(SISO_AoA_6.V(4:end), SISO_AoA_6.dpf(4:end), '-', 'Marker', 'o','MarkerSize', marker_size,  'color', color_order(1,:),'MarkerFaceColor', color_order(1,:))

% plot(MIMO_AoA_6.V(1:4), MIMO_AoA_6.dpf(1:4), 'r--','HandleVisibility','off')
% hold on
% plot(MIMO_AoA_6.V(4:end), MIMO_AoA_6.dpf(4:end), 'r-')


% % Check following plot
% plot(MIMO_raw_eig_AoA_6.V(1:3), MIMO_raw_eig_AoA_6.dpf(1:3), 'g--','HandleVisibility','off')
% plot(MIMO_raw_eig_AoA_6.V(3:end), MIMO_raw_eig_AoA_6.dpf(3:end), 'g-')

% Check following plot
plot(MIMO_raw_eig_AoA_6.V(1:3), MIMO_raw_eig_AoA_6.dpf(1:3), '--', 'Marker', 's','MarkerSize', marker_size,  'color', color_order(2,:),'HandleVisibility','off','MarkerFaceColor', color_order(2,:))
plot(MIMO_raw_eig_AoA_6.V(3:end), MIMO_raw_eig_AoA_6.dpf(3:end), '-', 'Marker', 's','MarkerSize', marker_size,  'color', color_order(2,:),'MarkerFaceColor', color_order(2,:))


% grid
yline(0,'HandleVisibility','off')

ylabel('$\Delta p_f$ [gram]', 'interpreter', 'latex', 'FontSize', font_size, 'FontName', font)
xlabel('Velocity [m/s]',  'interpreter', 'latex', 'FontSize', font_size, 'FontName', font)
%title('AoA = 6 deg', 'interpreter', 'latex')
% legend('SISO', "MIMO Smoothed Eigenvalues", "MIMO Unsmoothed Eigenvalues", 'interpreter', 'latex', 'Location', 'best')
legend('SISO', "MIMO", 'interpreter', 'latex', 'Location', 'southwest', 'FontSize', font_size, 'FontName', font)



axis square
ax = gca;
ax.FontSize = font_size;
ax.FontName = font;
% yline(1,'HandleVisibility','off')

exportgraphics(gcf, 'Figures/MIMO_SISO_Comparison/Dpf_comparison_AoA_6.pdf', 'Resolution',600)
saveas(gcf, 'Figures/MIMO_SISO_Comparison/Dpf_comparison_AoA_6.jpg')



%% Plot dpf results (MIMO) in single plot
fh = figure;
fh.Units = 'inches';
fh.Position(3:4) = [3.25,3.5];

plot(MIMO_raw_eig_AoA_0.V(1:2), MIMO_raw_eig_AoA_0.dpf(1:2), '--', 'Marker', 's','MarkerSize', marker_size,  'color', color_order(1,:), 'HandleVisibility','off','MarkerFaceColor', color_order(1,:))
hold on
plot(MIMO_raw_eig_AoA_0.V(2:end), MIMO_raw_eig_AoA_0.dpf(2:end), '-', 'Marker', 's','MarkerSize', marker_size,  'color', color_order(1,:),'MarkerFaceColor', color_order(1,:))

plot(MIMO_raw_eig_AoA_2.V(1:2), MIMO_raw_eig_AoA_2.dpf(1:2), '--', 'Marker', 'o','MarkerSize', marker_size,  'color', color_order(2,:), 'HandleVisibility','off','MarkerFaceColor', color_order(2,:))
plot(MIMO_raw_eig_AoA_2.V(2:end), MIMO_raw_eig_AoA_2.dpf(2:end), '-', 'Marker', 'o','MarkerSize', marker_size,  'color', color_order(2,:),'MarkerFaceColor', color_order(2,:))

plot(MIMO_raw_eig_AoA_4.V(1:2), MIMO_raw_eig_AoA_4.dpf(1:2), '--', 'Marker', 'd','MarkerSize', marker_size,  'color', color_order(3,:), 'HandleVisibility','off','MarkerFaceColor', color_order(3,:))
plot(MIMO_raw_eig_AoA_4.V(2:end), MIMO_raw_eig_AoA_4.dpf(2:end), '-', 'Marker', 'd','MarkerSize', marker_size,  'color', color_order(3,:),'MarkerFaceColor', color_order(3,:))

% Check following plot
plot(MIMO_raw_eig_AoA_6.V(1:3), MIMO_raw_eig_AoA_6.dpf(1:3), '--', 'Marker', '^','MarkerSize', marker_size,  'color', color_order(4,:), 'HandleVisibility','off','MarkerFaceColor', color_order(4,:))
plot(MIMO_raw_eig_AoA_6.V(3:end), MIMO_raw_eig_AoA_6.dpf(3:end), '-', 'Marker', '^','MarkerSize', marker_size,  'color', color_order(4,:),'MarkerFaceColor', color_order(4,:))



% grid on
% grid Minor
yline(0,'HandleVisibility','off')

ylabel('$\Delta p_f$ [gram]', 'interpreter', 'latex', 'FontSize', font_size, 'FontName', font)
xlabel('Velocity [m/s]', 'interpreter', 'latex', 'FontSize', font_size, 'FontName', font)
% %title(, 'interpreter', 'latex', 'FontSize', 12)
% legend('SISO', "MIMO Smoothed Eigenvalues", "MIMO Unsmoothed Eigenvalues", 'interpreter', 'latex', 'Location', 'best')
legend('$\alpha = $ 0 degree', '$\alpha = $ 2 degree', '$\alpha = $ 4 degree', '$\alpha = $ 6 degree', 'interpreter', 'latex', 'Location', 'best', 'FontSize', font_size, 'FontName', font)

% yline(1,'HandleVisibility','off')
axis square
ax = gca;
ax.FontSize = font_size;
ax.FontName = font;

exportgraphics(gcf, 'Figures/MIMO_SISO_Comparison/Dpf_comparison_all.pdf', 'Resolution',600)
saveas(gcf, 'Figures/MIMO_SISO_Comparison/Dpf_comparison_all.jpg')
