close all
clc

%% Start new plotting
% font settings
% font = 'Times New Roman';
marker_size = 15;


if AoA == 4
    ldx_lst_smooth = [1,2,4,6];
    ldx_lst_raw = [2, 4, 8, 12]; % 18, 18.5, 20, 21.5 m/s
    ldx_lst_raw = [2, 6, 8]; % 18, 19, 20 m/s
    ldx_lst_raw_lambda_1 = [1, 5, 7];
    leg_pos = 'southeast';
elseif AoA == 2
    ldx_lst_smooth = [1,3,5,7];
    ldx_lst_raw = [2, 6, 10, 14]; % 19, 21, 22, 23.5 m/s
    ldx_lst_raw = [4, 6, 10]; % 20, 21, 22 m/s
    ldx_lst_raw_lambda_1 = [3, 5, 9];
    leg_pos = 'northwest';
elseif AoA == 0
    ldx_lst_smooth = [1,3,6,8,9];
    ldx_lst_raw = [2,6,12,16,18]; % 20, 22, 23.5, 24.5, 25
    ldx_lst_raw = [2, 6,18]; % 20, 22, 25
    ldx_lst_raw_lambda_1 = [1, 5, 17];
    leg_pos = 'southeast';
%     leg_pos = 'best';
elseif AoA == 6
    ldx_lst_smooth = [1,3,5];
    ldx_lst_raw = [2, 6, 10];
    ldx_lst_raw_lambda_1 = [1, 5, 9];
    leg_pos = 'southeast';
end


%% Lambda 2 evolution
fh = figure;
%         fh.WindowState = 'maximized';
% fh.Units = 'centimeters';
% fh.Position = [1, 1, 29, 29];

fh.Units = 'inches';
fh.Position(3:4) = [3.25,3.25];



Vel_lst = repelem(Velocity_AoA_0, 2);

min_lst = [];
max_lst = [];

min_lst_imag = [];
max_lst_imag = [];
for hdx = 1:length(ldx_lst_raw) %1:
    
    % Raw eigenvalues
    ldx = ldx_lst_raw(hdx);
%         colors_start = ["red", "green", "blue", "black"];
%         colors = repmat(colors_start, 1, max(size((lambda_lst_all))));
% 
        marker_symbols = ["o", "o", "<", "<","d", "d", "^", "^", "h", "h", ">", ">", "s", "s", "v", "v",  "p", "p"];
%         markers = repmat(marker_symbols, 1, max(size((lambda_lst_all))));
        lambda_val_raw = lambda_lst_all(ldx, :);
        
        % Smooth found eigenvalues
%         order = 15;
%         framelen = 25;
%         lambda_val = sgolayfilt(lambda_val_raw, order, framelen);
        lambda_val = lambda_val_raw;

%         figure(ldx)
%         fh = figure(n);
% %         fh.WindowState = 'maximized';
%         fh.Units = 'centimeters';
%         fh.Position = [1, 1, 29, 29];
        
        spacing = 1;
%         cmap = jet(length(freq(1:spacing:end)));
        cmap_raw = cool(length(freq(1:spacing:end)));
%         cmap = spring(length(freq(1:spacing:end)));
%         cmap = hsv(length(freq(1:spacing:end)));
%             v = rescale(yourValues, 1, length(data_1_lst)); % Nifty trick!
        v = freq;
%         
        numValues = length(lambda_val(1:spacing:end));
        markerColors = zeros(numValues, 3);
        % Now assign marker colors according to the value of the data.
        for k = 1 : numValues
%                 row = round(v(k));
            row = k;
            markerColors(k, :) = cmap_raw(row, :);
        end 
        
%         if rem(ldx, 2) == 0
% %             title(Vel_lst(ldx) +  " $\lambda_2$",'Interpreter','latex')
% %             condition = string(Vel_lst(ldx)) +  " m/s"; % + " Raw $\lambda_2$";
% %             label_name = condition;
% %             
%         else
% %             title(Vel_lst(ldx) +  " $\lambda_1$",'Interpreter','latex')
% %             condition = string(Vel_lst(ldx)) +  " $\lambda_1$";
% %             label_name = condition;
%         end
        condition = string(Vel_lst(ldx)) +  " m/s"; % + " Raw $\lambda_2$";
        label_name = condition;
        
        % Raw eigenvalues
%         raw_eig = axes;
%         axis(raw_eig, 'off');
        plot(real(lambda_val(1:spacing:end)), imag(lambda_val(1:spacing:end)), 'Color', [0, 0, 0, 0.2],'HandleVisibility','off')
        hold on
        scatter(real(lambda_val(1:spacing:end)), imag(lambda_val(1:spacing:end)), marker_size, markerColors, marker_symbols(ldx), 'filled', 'DisplayName', label_name);
%         plot(real(lambda_val(1:spacing:end)), imag(lambda_val(1:spacing:end)), 'Color', [0, 0, 0, 0.2],'HandleVisibility','off')
%         hold on
%         markerColors
%         f1 = scatter(real(lambda_val(1:spacing:end)), imag(lambda_val(1:spacing:end)), [], 'k', marker_symbols(ldx), 'filled', 'HandleVisibility','off'); %, 'DisplayName', label_name);
%         f1.MarkerFaceAlpha = 0.5;
%         set(gca,'fontsize', font_size) 
        
        
        min_lst = [min_lst, min(real(lambda_val(1:spacing:end)))];
        max_lst = [max_lst, max(real(lambda_val(1:spacing:end)))];
        
        min_lst_imag = [min_lst_imag, min(imag(lambda_val(1:spacing:end)))];
        max_lst_imag = [max_lst_imag, max(imag(lambda_val(1:spacing:end)))];
end
colormap(cmap_raw);
c = colorbar;
% c.Location = 'westoutside';
caxis([min(freq), max(freq)]);
ylabel(c, 'Frequency [Hz]', 'Rotation', 270,'Interpreter','latex', 'FontSize', font_size, 'FontName', font);
c.Label.Position(1) = 3;
% grid
xline(0, 'Alpha', 0.2,'HandleVisibility','off')
yline(0, 'Alpha', 0.2,'HandleVisibility','off')

% % 
% ylabel(c, 'Unsmooth Eigenvalue Frequency [Hz]', 'Rotation', 270,'Interpreter','latex', 'FontSize', font_size);
% c.Label.Position(1) = -3;

x1 = 10;%30;
x2 = 18;
leg = legend('Interpreter','latex', 'FontSize', font_size_legend, 'Location', leg_pos, 'FontName', font);
leg.ItemTokenSize = [x1,x2];

lower_lim = min(min_lst);
lower_lim = floor(lower_lim);
upper_lim = max(max_lst);
upper_lim = ceil(upper_lim);

n_lin = upper_lim - lower_lim + 1;
xtick_lst = linspace(lower_lim, upper_lim, n_lin);
set(gca, 'xtick', xtick_lst);
xlim([lower_lim, upper_lim])


lower_lim = min(min_lst_imag);
lower_lim = floor(lower_lim);
upper_lim = max(max_lst_imag);
upper_lim = ceil(upper_lim);

n_lin = upper_lim - lower_lim + 1;
ytick_lst = linspace(lower_lim, upper_lim, n_lin);
set(gca, 'ytick', ytick_lst);
ylim([lower_lim, upper_lim])

xlabel('Re$\left(\lambda\right)$','Interpreter','latex', 'FontSize', font_size, 'FontName', font)
ylabel('Im$\left(\lambda\right)$','Interpreter','latex', 'FontSize', font_size, 'FontName', font)

% axis square

ax = gca;
ax.FontSize = font_size;
ax.FontName = font;

filepath ='Figures/Eigenvalues/Real_v_Im/evolution/For_Paper/Eigval_lambda_2_evol_AoA_' + string(AoA);
exportgraphics(gcf, filepath + '.pdf', 'Resolution',600);
exportgraphics(gcf, filepath + '.jpg', 'Resolution',600);


%% Lambda 1 evolution
fh = figure;
%         fh.WindowState = 'maximized';
% fh.Units = 'centimeters';
% fh.Position = [1, 1, 29, 29];

fh.Units = 'inches';
fh.Position(3:4) = [3.25,3.25];



Vel_lst = repelem(Velocity_AoA_0, 2);

min_lst = [];
max_lst = [];

min_lst_imag = [];
max_lst_imag = [];

for hdx = 1:length(ldx_lst_raw_lambda_1) %1:
    
    % Raw eigenvalues
    ldx = ldx_lst_raw_lambda_1(hdx);
%         colors_start = ["red", "green", "blue", "black"];
%         colors = repmat(colors_start, 1, max(size((lambda_lst_all))));
% 
        marker_symbols = ["o", "o", "<", "<","d", "d", "^", "^", "h", "h", ">", ">", "s", "s", "v", "v",  "p", "p"];
%         markers = repmat(marker_symbols, 1, max(size((lambda_lst_all))));
        lambda_val_raw = lambda_lst_all(ldx, :);
        
        % Smooth found eigenvalues
%         order = 15;
%         framelen = 25;
%         lambda_val = sgolayfilt(lambda_val_raw, order, framelen);
        lambda_val = lambda_val_raw;

%         figure(ldx)
%         fh = figure(n);
% %         fh.WindowState = 'maximized';
%         fh.Units = 'centimeters';
%         fh.Position = [1, 1, 29, 29];
        
        spacing = 1;
%         cmap = jet(length(freq(1:spacing:end)));
        cmap_raw = cool(length(freq(1:spacing:end)));
%         cmap = spring(length(freq(1:spacing:end)));
%         cmap = hsv(length(freq(1:spacing:end)));
%             v = rescale(yourValues, 1, length(data_1_lst)); % Nifty trick!
        v = freq;
%         
        numValues = length(lambda_val(1:spacing:end));
        markerColors = zeros(numValues, 3);
        % Now assign marker colors according to the value of the data.
        for k = 1 : numValues
%                 row = round(v(k));
            row = k;
            markerColors(k, :) = cmap_raw(row, :);
        end 
        
%         if rem(ldx, 2) == 0
% %             title(Vel_lst(ldx) +  " $\lambda_2$",'Interpreter','latex')
% %             condition = string(Vel_lst(ldx)) +  " m/s"; % + " Raw $\lambda_2$";
% %             label_name = condition;
% %             
%         else
% %             title(Vel_lst(ldx) +  " $\lambda_1$",'Interpreter','latex')
% %             condition = string(Vel_lst(ldx)) +  " $\lambda_1$";
% %             label_name = condition;
%         end
        condition = string(Vel_lst(ldx)) +  " m/s"; % + " Raw $\lambda_2$";
        label_name = condition;
        
        % Raw eigenvalues
%         raw_eig = axes;
%         axis(raw_eig, 'off');
        plot(real(lambda_val(1:spacing:end)), imag(lambda_val(1:spacing:end)), 'Color', [0, 0, 0, 0.2],'HandleVisibility','off')
        hold on
        scatter(real(lambda_val(1:spacing:end)), imag(lambda_val(1:spacing:end)), marker_size, markerColors, marker_symbols(ldx), 'filled', 'DisplayName', label_name);
%         plot(real(lambda_val(1:spacing:end)), imag(lambda_val(1:spacing:end)), 'Color', [0, 0, 0, 0.2],'HandleVisibility','off')
%         hold on
%         markerColors
%         f1 = scatter(real(lambda_val(1:spacing:end)), imag(lambda_val(1:spacing:end)), [], 'k', marker_symbols(ldx), 'filled', 'HandleVisibility','off'); %, 'DisplayName', label_name);
%         f1.MarkerFaceAlpha = 0.5;
%         set(gca,'fontsize', font_size) 
        
        
        min_lst = [min_lst, min(real(lambda_val(1:spacing:end)))];
        max_lst = [max_lst, max(real(lambda_val(1:spacing:end)))];
        
        min_lst_imag = [min_lst_imag, min(imag(lambda_val(1:spacing:end)))];
        max_lst_imag = [max_lst_imag, max(imag(lambda_val(1:spacing:end)))];
end
colormap(cmap_raw);
c = colorbar;
% c.Location = 'westoutside';
caxis([min(freq), max(freq)]);
ylabel(c, 'Frequency [Hz]', 'Rotation', 270,'Interpreter','latex', 'FontSize', font_size, 'FontName', font);
c.Label.Position(1) = 3;
% grid
xline(0, 'Alpha', 0.2,'HandleVisibility','off')
yline(0, 'Alpha', 0.2,'HandleVisibility','off')


% % 
% ylabel(c, 'Unsmooth Eigenvalue Frequency [Hz]', 'Rotation', 270,'Interpreter','latex', 'FontSize', font_size);
% c.Label.Position(1) = -3;

x1 = 10;%30;
x2 = 18;
leg = legend('Interpreter','latex', 'FontSize', font_size_legend, 'Location', leg_pos, 'FontName', font);
leg.ItemTokenSize = [x1,x2];

lower_lim = min(min_lst);
lower_lim = floor(lower_lim);
upper_lim = max(max_lst);
upper_lim = ceil(upper_lim);

n_lin = upper_lim - lower_lim + 1;
xtick_lst = linspace(lower_lim, upper_lim, n_lin);
set(gca, 'xtick', xtick_lst);
xlim([lower_lim, upper_lim])


lower_lim = min(min_lst_imag);
lower_lim = floor(lower_lim);
upper_lim = max(max_lst_imag);
upper_lim = ceil(upper_lim);

n_lin = upper_lim - lower_lim + 1;
ytick_lst = linspace(lower_lim, upper_lim, n_lin);
set(gca, 'ytick', ytick_lst);
ylim([lower_lim, upper_lim])

xlabel('Re$\left(\lambda\right)$','Interpreter','latex', 'FontSize', font_size, 'FontName', font)
ylabel('Im$\left(\lambda\right)$','Interpreter','latex', 'FontSize', font_size, 'FontName', font)

% axis square

ax = gca;
ax.FontSize = font_size;
ax.FontName = font;

filepath ='Figures/Eigenvalues/Real_v_Im/evolution/For_Paper/Eigval_lambda_1_evol_AoA_' + string(AoA);
exportgraphics(gcf, filepath + '.pdf', 'Resolution',600);
exportgraphics(gcf, filepath + '.jpg', 'Resolution',600);



% Vel_lst = Velocity_AoA_0;
% for hdx = 1:length(ldx_lst_smooth) %1:
%     
%    
%         % Smoothed eigenvalues
%         ldx = ldx_lst_smooth(hdx);
%         marker_symbols = ["o", "<","d", "^", "h", ">", "s", "v",  "p",];
% %         markers = repmat(marker_symbols, 1, max(size((lambda_lst_all))));
%         lambda_val_raw = smooth_lambda_2_all(ldx, :);
%         
%         
%         lambda_val = lambda_val_raw;
% 
% %         figure(ldx)
% %         fh = figure(n);
% % %         fh.WindowState = 'maximized';
% %         fh.Units = 'centimeters';
% %         fh.Position = [1, 1, 29, 29];
% %         fh.Units = 'Inches';
% %         fh.Position = [1, 1, 3.25, 3.25];
%         
%         spacing = 1;
% %         cmap = jet(length(freq(1:spacing:end)));
%         cmap_smooth = winter(length(freq(1:spacing:end)));
%         cmap_smooth = cool(length(freq(1:spacing:end)));
% %         cmap = spring(length(freq(1:spacing:end)));
% %         cmap = hsv(length(freq(1:spacing:end)));
% %             v = rescale(yourValues, 1, length(data_1_lst)); % Nifty trick!
%         v = freq;
% %         
%         numValues = length(lambda_val(1:spacing:end));
%         markerColors = zeros(numValues, 3);
%         % Now assign marker colors according to the value of the data.
%         for k = 1 : numValues
% %                 row = round(v(k));
%             row = k;
%             markerColors(k, :) = cmap_smooth(row, :);
%         end 
%         
% %         if rem(ldx, 2) == 0
% %             title(Vel_lst(ldx) +  " $\lambda_2$",'Interpreter','latex')
%         condition = string(Vel_lst(ldx)) +  " m/s";
%         label_name = condition;
%         set(gca,'fontsize', font_size)    
% %         else
% % %             title(Vel_lst(ldx) +  " $\lambda_1$",'Interpreter','latex')
% %             condition = string(Vel_lst(ldx)) +  " $\lambda_1$";
% %             label_name = condition;
% %         end
%         % Smoothed eigenvalues
% %         smooth_eig = axes;
% %         axis(smooth_eig, 'off');
% %         plot(smooth_eig, real(lambda_val(1:spacing:end)), imag(lambda_val(1:spacing:end)), 'Color', [0, 0, 0, 0.2],'HandleVisibility','off')
% %         hold on
% %         scatter(smooth_eig, real(lambda_val(1:spacing:end)), imag(lambda_val(1:spacing:end)), [], markerColors, marker_symbols(ldx), 'filled', 'DisplayName', label_name);
%         
%         plot(real(lambda_val(1:spacing:end)), imag(lambda_val(1:spacing:end)), 'Color', [0, 0, 0, 0.2],'HandleVisibility','off')
%         hold on
%         scatter(real(lambda_val(1:spacing:end)), imag(lambda_val(1:spacing:end)), [], markerColors, marker_symbols(ldx), 'filled', 'DisplayName', label_name);
%         
%         
% 
%         
%         
%         
%         
%         
%         
%         xlabel('Re$\left(\lambda\right)$','Interpreter','latex', 'FontSize', font_size)
%         ylabel('Im$\left(\lambda\right)$','Interpreter','latex', 'FontSize', font_size)
%         
% %         if rem(ldx, 2) == 0
% %             title(Vel_lst(ldx) +  " $\lambda_2$",'Interpreter','latex')
% %             condition = string(Vel_lst(ldx)) +  "_lambda_2";
% %         else
% %             title(Vel_lst(ldx) +  " $\lambda_1$",'Interpreter','latex')
% %             condition = string(Vel_lst(ldx)) +  "_lambda_1";
% %         end
% %         hold on
% %         % % grid()
%         
%         data_1_lst = [];
%         data_2_lst = [];
%         text_freq = [freq(1)];
%         print_freq = linspace(f_min, f_max, f_max-f_min+1);
%         print_text = 1;
%         printed_omega_idx = [];
% %         for omega_idx = 1:spacing:max(size((lambda_val))) % 1:5:max(size((lambda_lst_all)))
% % %             color = colors(omega_idx);
% % %             marker = markers(omega_idx);
% % %            
% %             data_1_lst = [data_1_lst, real(lambda_val(omega_idx))];
% %             data_2_lst = [data_2_lst, imag(lambda_val(omega_idx))];
% %             
% %             if ismember(round(freq(omega_idx), 2), print_freq) == 1 && print_text == 1
% %                 text_freq = [text_freq, freq(omega_idx)];
% %                 text(real(lambda_lst_all(ldx, omega_idx)), imag(lambda_lst_all(ldx, omega_idx)), string(freq(omega_idx)) + ' Hz')
% %                 print_text = 0;
% %                 printed_omega_idx = [printed_omega_idx, omega_idx];
% %             end
% %             if length(printed_omega_idx) > 0 && omega_idx > printed_omega_idx(end) + 10
% %                 print_text = 1;
% %             end
%             
%             
% %             fdx = 150;
% %             
% %             q = colorbar;
% %             set(q, 'ylim', [min(freq), max(freq)]);
%             
% %             scatter(real(lambda_lst_all(ldx, omega_idx)), imag(lambda_lst_all(ldx, omega_idx)),marker, 'MarkerEdgeColor', color)        
%             
% %             if rem(ldx, 2) == 0
% %                 title(Vel_lst(ldx) +  " $\lambda_2$",'Interpreter','latex')
% %                 condition = string(Vel_lst(ldx)) +  "_lambda_2";
% %             else
% %                 title(Vel_lst(ldx) +  " $\lambda_1$",'Interpreter','latex')
% %                 condition = string(Vel_lst(ldx)) +  "_lambda_1";
% %             end
% %             
% %             hold on
% % %             xlim([-8, 8])
% % %             ylim([-8, 8])
% %             xlabel("Re$[\lambda]$",'Interpreter','latex')
% %             ylabel("Im$[\lambda]$",'Interpreter','latex')
% %             
% %             drawnow
% %         end
% %         dx = gradient(data_1_lst) ;
% %         dy = gradient(data_2_lst) ;
% %         figure(ldx)
% %         quiver(data_1_lst,data_2_lst,dx,dy, 1.5)
%         
% %         if savefig == 1
% %             set(gcf,'Units','Inches');
% %             pos = get(gcf,'Position');
% %             set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
% % 
% % 
% %             saveas(gcf, eigval_fig_name_real_im + condition + ".pdf");
% %             saveas(gcf, eigval_fig_name_real_im + condition + ".jpeg");
% %         end
%         
%         
% end
% 
% colormap(cmap_smooth);
% q = colorbar;
% q.Location = 'eastoutside';
%     %%Link them together
% %     linkaxes([smooth_raw, smooth_eig])
%     
% axis square;
% %     qdx = ldx;
% % % grid()
% legend('Interpreter','latex', 'FontSize', font_size_legend, 'Location', leg_pos)
% title("Eigenvalue evolution with frequency AoA = " + AoA + " deg", 'Interpreter','latex')
% 
% % colormap(c, cmap_raw);
% 
% colormap(q, cmap_smooth);
% %     
% % q.Location = 'east';
% caxis([min(freq), max(freq)]);
% % c.Location = 'east';
% caxis([min(freq), max(freq)]);
% 
% %     set(raw_eig, 'CData', cmap_raw);
% 
% 
% %     colormap(raw_eig, 'cool');
% %     q = colorbar(raw_eig, 'Location', 'west');
% %     q.Location = 'west';
% %     caxis(raw_eig, [min(freq), max(freq)]);
% 
% %     ylabel(raw_eig, 'Frequency [Hz]', 'Rotation', 270,'Interpreter','latex', 'FontSize', font_size);
% %     q.Label.Position(1) = 4;
% 
% %     colormap(cmap_smooth);
% %     set(smooth_eig, 'CData', cmap_smooth);
% 
% 
% %     colormap(smooth_eig, 'winter')
% %     c = colorbar(smooth_eig, 'Location', 'east');
% % %     c.Location = 'east';
% %     caxis(smooth_eig, [min(freq), max(freq)]);
% 
% % ylabel(c, 'Unsmoothed Eigenvalue Frequency [hZ]', 'Rotation', 270,'Interpreter','latex', 'FontSize', font_size);
% % c.Label.Position(1) = 4;
% 
% 
% ylabel(q, 'Smooth Eigenvalue Frequency [hZ]', 'Rotation', 270,'Interpreter','latex', 'FontSize', font_size);
% q.Label.Position(1) = 4;
% 
% 
% lower_lim = min(min_lst);
% lower_lim = floor(lower_lim);
% upper_lim = max(max_lst);
% upper_lim = ceil(upper_lim);
% 
% n_lin = upper_lim - lower_lim + 1;
% xtick_lst = linspace(lower_lim, upper_lim, n_lin);
% set(gca, 'xtick', xtick_lst);
% 
% 
% filepath ='Figures/Eigenvalues/Real_v_Im/evolution/Smoothing_Comparison/Smoothing_Comparison_AoA_' + string(AoA);
% exportgraphics(gcf, filepath + '.pdf');
% saveas(gcf, filepath + '.jpg');

    