% clc
% clear all
% close all

function [mag_phase_complex_force, mag_phase_accel_x, mag_phase_accel_y, mag_phase_accel_z, mag_phase_mov_accel,mag_phase_complex_stab_mov_x, mag_phase_complex_stab_mov_y, mag_phase_complex_stab_mov_z] = Calculate_Correction_Factors(method, window)

%% Script starts

% Smoothdata function parameters
% method = 'gaussian';
% window = 70; %10;

%% Load Shaker force Data (.mat files)
% Shaker force: FRF = measured_force_impedance_head/calculated_force_using_accel
% --> Scale FRF data with 1/shaker_force_FRF
shaker_force_horiz_1_file = "Correction_Factors/Shaker_Force/Shaker_Force_FRF_horizontal_1.mat";
shaker_force_horiz_2_file = "Correction_Factors/Shaker_Force/Shaker_Force_FRF_horizontal_2.mat";
shaker_force_vert_1_file = "Correction_Factors/Shaker_Force/Shaker_Force_FRF_vertical_1.mat";
shaker_force_vert_2_file = "Correction_Factors/Shaker_Force/Shaker_Force_FRF_vertical_2.mat";

shaker_force_horiz_1 = load(shaker_force_horiz_1_file).FRF;
shaker_force_horiz_2 = load(shaker_force_horiz_2_file).FRF;
shaker_force_vert_1 = load(shaker_force_vert_1_file).FRF;
shaker_force_vert_2 = load(shaker_force_vert_2_file).FRF;

% Get frequencies
start = shaker_force_horiz_1.x_values.start_value;
step = shaker_force_horiz_1.x_values.increment;
number = shaker_force_horiz_1.x_values.number_of_values;
freq = linspace(0, step*(number-1), number);




% 1) Smooth FRF data of shaker force (for all 4 measurements)
% 2) Take average of the shaker force FRF at each frequency
% 3) Create averaged shaker force FRF

complex_force_horz_1 = shaker_force_horiz_1.y_values.values ;
complex_force_horz_2 = shaker_force_horiz_2.y_values.values ;
complex_force_vert_1 = shaker_force_vert_1.y_values.values ;
complex_force_vert_2 = shaker_force_vert_2.y_values.values ;


complex_force = [complex_force_horz_1, complex_force_horz_2, complex_force_vert_1, complex_force_vert_2];




smooth_mag_db_force_all = [];
smooth_phase_force_all = [];

mag_phase_complex_force_all = [];

for idx = 1:min(size(complex_force))
    complex_force_col = complex_force(:, idx);
    
    mag_force = [];
    phase_force = [];
    for i = 1:length(complex_force_col)
        mag_force = [mag_force; abs(complex_force_col(i))];
        phase_force = [phase_force; angle(complex_force_col(i))];
    end


    % Smooth experimental data
    %     phase = unwrap(phase);
%     mag_db_force_col = mag2db(mag_force);
%     smooth_mag_db_force = smoothdata(mag_db_force_col, method, window);
%     smooth_phase_force = smoothdata(phase_force, method, window);
%     
%     
%     smooth_mag_db_force_all = [smooth_mag_db_force_all, smooth_mag_db_force];
%     smooth_phase_force_all = [smooth_phase_force_all, smooth_phase_force];
    
    
    smooth_complex_force_all = smoothdata(complex_force_col, method, window);
    mag_phase_complex_force_all = [mag_phase_complex_force_all, smooth_complex_force_all];





end

% mag_phase_complex_force_all = [];

% Calculate average of shaker FRF
% Convert TF (mag_db and phase) at omega to complex number
% mag_phase_complex_force = [];
% for jdx =1:min(size(smooth_mag_db_force_all))
%     smooth_mag_db_force = smooth_mag_db_force_all(:, jdx);
%     smooth_phase_force = smooth_phase_force_all(:, jdx);

% Create magnitude and phase from complex number
    
mag_phase_complex_force = [];
% size(mag_phase_complex_force_all)
% mag_phase_complex_force_all(1, :)
% avg_mag_db_force_lst = [];
% avg_phase_force_lst = [];
for m=1:max(size(mag_phase_complex_force_all))
    avg_force = mean(mag_phase_complex_force_all(m, :));
%     avg_phase_force = mean(smooth_phase_force_all(m, :));
    
%     avg_mag_db_force_lst = [avg_mag_db_force_lst, avg_mag_db_force];
%     avg_phase_force_lst = [avg_phase_force_lst, avg_phase_force];
    smooth_complex_number = avg_force;
%     smooth_complex_number = db2mag(avg_mag_db_force)*(cos(avg_phase_force) + j*sin(avg_phase_force));
    mag_phase_complex_force = [mag_phase_complex_force; smooth_complex_number];% [smooth_mag_db, smooth_phase];
end

% mag_phase_complex_force
%% Stabilising mass accelerometer correction factors

% Impedance head data (Impedance head S/N 4399)
filename_actual_accel_x_1 = "Correction_Factors/Actual_accel_Stab_mass/Time_accel_imp_head_x_1.mat";
filename_actual_accel_x_2 = "Correction_Factors/Actual_accel_Stab_mass/Time_accel_imp_head_x_2.mat";

filename_actual_accel_y_1 = "Correction_Factors/Actual_accel_Stab_mass/Time_accel_imp_head_y_1.mat";
filename_actual_accel_y_2 = "Correction_Factors/Actual_accel_Stab_mass/Time_accel_imp_head_y_2.mat";

filename_actual_accel_z_1 = "Correction_Factors/Actual_accel_Stab_mass/Time_accel_imp_head_z_1.mat";
filename_actual_accel_z_2 = "Correction_Factors/Actual_accel_Stab_mass/Time_accel_imp_head_z_2.mat";

% Stabilising mass accelerometer (S/N 1658)
filename_stab_mass_accel_x_1 = "Correction_Factors/Actual_accel_Stab_mass/Time_accel_stab_x_1.mat";
filename_stab_mass_accel_x_2 = "Correction_Factors/Actual_accel_Stab_mass/Time_accel_stab_x_2.mat";

filename_stab_mass_accel_y_1 = "Correction_Factors/Actual_accel_Stab_mass/Time_accel_stab_y_1.mat";
filename_stab_mass_accel_y_2 = "Correction_Factors/Actual_accel_Stab_mass/Time_accel_stab_y_2.mat";

filename_stab_mass_accel_z_1 = "Correction_Factors/Actual_accel_Stab_mass/Time_accel_stab_z_1.mat";
filename_stab_mass_accel_z_2 = "Correction_Factors/Actual_accel_Stab_mass/Time_accel_stab_z_2.mat";

% Load data
actual_accel_x_1 = load(filename_actual_accel_x_1).Time.y_values.values;
actual_accel_x_2 = load(filename_actual_accel_x_2).Time.y_values.values;

actual_accel_y_1 = load(filename_actual_accel_y_1).Time.y_values.values;
actual_accel_y_2 = load(filename_actual_accel_y_2).Time.y_values.values;

actual_accel_z_1 = load(filename_actual_accel_z_1).Time.y_values.values;
actual_accel_z_2 = load(filename_actual_accel_z_2).Time.y_values.values;


stab_mass_accel_x_1 = load(filename_stab_mass_accel_x_1).Time.y_values.values;
stab_mass_accel_x_2 = load(filename_stab_mass_accel_x_2).Time.y_values.values;

stab_mass_accel_y_1 = load(filename_stab_mass_accel_y_1).Time.y_values.values;
stab_mass_accel_y_2 = load(filename_stab_mass_accel_y_2).Time.y_values.values;

stab_mass_accel_z_1 = load(filename_stab_mass_accel_z_1).Time.y_values.values;
stab_mass_accel_z_2 = load(filename_stab_mass_accel_z_2).Time.y_values.values;


freq = linspace(0, 80, length(actual_accel_x_1));

% Smooth data
f_s = 160; % Hz

complex_accel_x_1 = tfestimate(stab_mass_accel_x_1, actual_accel_x_1,[] ,[] ,freq , f_s).';
complex_accel_x_2 = tfestimate(stab_mass_accel_x_2, actual_accel_x_2,[] ,[] , freq, f_s).';

complex_accel_y_1 = tfestimate(stab_mass_accel_y_1, actual_accel_y_1, [],[] , freq, f_s).';
complex_accel_y_2 = tfestimate(stab_mass_accel_y_2, actual_accel_y_2,[] ,[] ,freq , f_s).';

complex_accel_z_1 = tfestimate(stab_mass_accel_z_1, actual_accel_z_1,[] ,[] ,freq , f_s).';
complex_accel_z_2 = tfestimate(stab_mass_accel_z_2, actual_accel_z_2,[] , [],freq , f_s).';

% .' = Transpose, to get FRF's of accelerometers in same shape as FRF of
% force

complex_accel = [complex_accel_x_1, complex_accel_x_2, complex_accel_y_1, complex_accel_y_2, complex_accel_z_1, complex_accel_z_2];




smooth_mag_db_accel_all = [];
smooth_phase_accel_all = [];

smooth_complex_accel_all = [];

for idx = 1:min(size(complex_accel))
    complex_accel_col = complex_accel(:, idx);
    
    mag_accel = [];
    phase_accel = [];
    for i = 1:length(complex_accel_col)
        mag_accel = [mag_accel; abs(complex_accel_col(i))];
        phase_accel = [phase_accel; angle(complex_accel_col(i))];
    end


    % Smooth experimental data
    %     phase = unwrap(phase);
    mag_db_accel_col = mag2db(mag_accel);
    smooth_mag_db_accel = smoothdata(mag_db_accel_col, method, window);
    smooth_phase_accel = smoothdata(phase_accel, method, window);
    
    
    smooth_mag_db_accel_all = [smooth_mag_db_accel_all, smooth_mag_db_accel];
    smooth_phase_accel_all = [smooth_phase_accel_all, smooth_phase_accel];
    
    smooth_complex_accel = smoothdata(complex_accel_col, method, window);
    smooth_complex_accel_all = [smooth_complex_accel_all, smooth_complex_accel];

end

% Average FRF smooth FRF data, and create new complex number which
% represents FRF
mag_phase_accel_x = [];
% avg_mag_db_force_lst_x = [];
% avg_phase_force_lst_x = [];

mag_phase_accel_y = [];
% avg_mag_db_force_lst_y = [];
% avg_phase_force_lst_y = [];

mag_phase_accel_z = [];
% avg_mag_db_force_lst_z = [];
% avg_phase_force_lst_z = [];

for hdx =1:max(size(smooth_mag_db_accel_all))
%     avg_smooth_mag_db_x = mean(smooth_mag_db_accel_all(hdx, 1:2));
%     avg_smooth_phase_x = mean(smooth_phase_accel_all(hdx, 1:2));
% 
%     avg_smooth_mag_db_y = mean(smooth_mag_db_accel_all(hdx, 3:4));
%     avg_smooth_phase_y = mean(smooth_phase_accel_all(hdx, 3:4));
% 
%     avg_smooth_mag_db_z = mean(smooth_mag_db_accel_all(hdx, 5:6));
%     avg_smooth_phase_z = mean(smooth_phase_accel_all(hdx, 5:6));
% 
% 
%     FRF_a_imp_over_a_stab_x = db2mag(avg_smooth_mag_db_x)*(cos(avg_smooth_phase_x) + j*sin(avg_smooth_phase_x));
%     FRF_a_imp_over_a_stab_y = db2mag(avg_smooth_mag_db_y)*(cos(avg_smooth_phase_y) + j*sin(avg_smooth_phase_y));
%     FRF_a_imp_over_a_stab_z = db2mag(avg_smooth_mag_db_z)*(cos(avg_smooth_phase_z) + j*sin(avg_smooth_phase_z));
    FRF_a_imp_over_a_stab_x = mean(smooth_complex_accel_all(hdx, 1:2));
    FRF_a_imp_over_a_stab_y = mean(smooth_complex_accel_all(hdx, 3:4));
    FRF_a_imp_over_a_stab_z = mean(smooth_complex_accel_all(hdx, 5:6));
    
    mag_phase_accel_x = [mag_phase_accel_x, FRF_a_imp_over_a_stab_x];
    mag_phase_accel_y = [mag_phase_accel_y, FRF_a_imp_over_a_stab_y];
    mag_phase_accel_z = [mag_phase_accel_z, FRF_a_imp_over_a_stab_z];
    
end



%% FRF Moving mass correction factors
% Impedance head data (Impedance head S/N 4399)
filename_actual_accel_x_1 = "Correction_Factors/Actual_accel_Stab_mass/Time_accel_imp_head_x_1.mat";
filename_actual_accel_x_2 = "Correction_Factors/Actual_accel_Stab_mass/Time_accel_imp_head_x_2.mat";

filename_actual_accel_y_1 = "Correction_Factors/Actual_accel_Stab_mass/Time_accel_imp_head_y_1.mat";
filename_actual_accel_y_2 = "Correction_Factors/Actual_accel_Stab_mass/Time_accel_imp_head_y_2.mat";

filename_actual_accel_z_1 = "Correction_Factors/Actual_accel_Stab_mass/Time_accel_imp_head_z_1.mat";
filename_actual_accel_z_2 = "Correction_Factors/Actual_accel_Stab_mass/Time_accel_imp_head_z_2.mat";

% Moving mass accelerometer (S/N LW357518)
filename_mov_mass_accel_x_1 = "Correction_Factors/Actual_accel_Stab_mass/Time_accel_mov_x_1.mat";
filename_mov_mass_accel_x_2 = "Correction_Factors/Actual_accel_Stab_mass/Time_accel_mov_x_2.mat";

filename_mov_mass_accel_y_1 = "Correction_Factors/Actual_accel_Stab_mass/Time_accel_mov_y_1.mat";
filename_mov_mass_accel_y_2 = "Correction_Factors/Actual_accel_Stab_mass/Time_accel_mov_y_2.mat";

filename_mov_mass_accel_z_1 = "Correction_Factors/Actual_accel_Stab_mass/Time_accel_mov_z_1.mat";
filename_mov_mass_accel_z_2 = "Correction_Factors/Actual_accel_Stab_mass/Time_accel_mov_z_2.mat";

% Load data
actual_accel_x_1 = load(filename_actual_accel_x_1).Time.y_values.values;
actual_accel_x_2 = load(filename_actual_accel_x_2).Time.y_values.values;

actual_accel_y_1 = load(filename_actual_accel_y_1).Time.y_values.values;
actual_accel_y_2 = load(filename_actual_accel_y_2).Time.y_values.values;

actual_accel_z_1 = load(filename_actual_accel_z_1).Time.y_values.values;
actual_accel_z_2 = load(filename_actual_accel_z_2).Time.y_values.values;


mov_mass_accel_x_1 = load(filename_mov_mass_accel_x_1).Time.y_values.values;
mov_mass_accel_x_2 = load(filename_mov_mass_accel_x_2).Time.y_values.values;

mov_mass_accel_y_1 = load(filename_mov_mass_accel_y_1).Time.y_values.values;
mov_mass_accel_y_2 = load(filename_mov_mass_accel_y_2).Time.y_values.values;

mov_mass_accel_z_1 = load(filename_mov_mass_accel_z_1).Time.y_values.values;
mov_mass_accel_z_2 = load(filename_mov_mass_accel_z_2).Time.y_values.values;



% Smooth data
f_s = 160; % Hz

complex_mov_accel_x_1 = tfestimate(mov_mass_accel_x_1, actual_accel_x_1,[] ,[] ,freq , f_s).';
complex_mov_accel_x_2 = tfestimate(mov_mass_accel_x_2, actual_accel_x_2,[] ,[] , freq, f_s).';

complex_mov_accel_y_1 = tfestimate(mov_mass_accel_y_1, actual_accel_y_1, [],[] , freq, f_s).';
complex_mov_accel_y_2 = tfestimate(mov_mass_accel_y_2, actual_accel_y_2,[] ,[] ,freq , f_s).';

complex_mov_accel_z_1 = tfestimate(mov_mass_accel_z_1, actual_accel_z_1,[] ,[] ,freq , f_s).';
complex_mov_accel_z_2 = tfestimate(mov_mass_accel_z_2, actual_accel_z_2,[] , [],freq , f_s).';

% .' = Transpose, to get FRF's of accelerometers in same shape as FRF of
% force

complex_accel_mov = [complex_mov_accel_x_1, complex_mov_accel_x_2, complex_mov_accel_y_1, complex_mov_accel_y_2, complex_mov_accel_z_1, complex_mov_accel_z_2];




smooth_mag_db_mov_accel_all = [];
smooth_phase_mov_accel_all = [];

mag_phase_mov_accel = [];

for idx = 1:min(size(complex_accel_mov))
    complex_accel_col = complex_accel_mov(:, idx);
    
    mag_accel_mov = [];
    phase_accel_mov = [];
    for i = 1:length(complex_accel_col)
        mag_accel_mov = [mag_accel_mov; abs(complex_accel_col(i))];
        phase_accel_mov = [phase_accel_mov; angle(complex_accel_col(i))];
    end


    % Smooth experimental data
    %     phase = unwrap(phase);
    mag_db_accel_col = mag2db(mag_accel_mov);
    smooth_mag_db_mov_accel = smoothdata(mag_db_accel_col, method, window);
    smooth_phase_mov_accel = smoothdata(phase_accel, method, window);
    
    
    smooth_mag_db_mov_accel_all = [smooth_mag_db_mov_accel_all, smooth_mag_db_mov_accel];
    smooth_phase_mov_accel_all = [smooth_phase_mov_accel_all, smooth_phase_mov_accel];
    
    smooth_complex_mov_accel = smoothdata(complex_accel_col, method, window);
    mag_phase_mov_accel = [mag_phase_mov_accel, smooth_complex_mov_accel];

end

% Average FRF smooth FRF data, and create new complex number which
% represents FRF
% mag_phase_mov_accel_x = [];
% % avg_mag_db_force_lst_x = [];
% % avg_phase_force_lst_x = [];
% 
% mag_phase_mov_accel_y = [];
% % avg_mag_db_force_lst_y = [];
% % avg_phase_force_lst_y = [];
% 
% mag_phase_mov_accel_z = [];
% avg_mag_db_force_lst_z = [];
% avg_phase_force_lst_z = [];

% for hdx =1:max(size(smooth_mag_db_mov_accel_all))
%     avg_smooth_mag_db_x = mean(smooth_mag_db_mov_accel_all(hdx, :));
%     avg_smooth_phase_x = mean(smooth_phase_mov_accel_all(hdx, :));
% 
% %     avg_smooth_mag_db_y = mean(smooth_mag_db_mov_accel_all(hdx, 3:4));
% %     avg_smooth_phase_y = mean(smooth_phase_mov_accel_all(hdx, 3:4));
% % 
% %     avg_smooth_mag_db_z = mean(smooth_mag_db_mov_accel_all(hdx, 5:6));
% %     avg_smooth_phase_z = mean(smooth_phase_mov_accel_all(hdx, 5:6));
% 
% 
%     FRF_a_imp_over_a_mov_x = db2mag(avg_smooth_mag_db_x)*(cos(avg_smooth_phase_x) + j*sin(avg_smooth_phase_x));
% %     FRF_a_imp_over_a_mov_y = db2mag(avg_smooth_mag_db_y)*(cos(avg_smooth_phase_y) + j*sin(avg_smooth_phase_y));
% %     FRF_a_imp_over_a_mov_z = db2mag(avg_smooth_mag_db_z)*(cos(avg_smooth_phase_z) + j*sin(avg_smooth_phase_z));
% %     
%     
%     mag_phase_mov_accel = [mag_phase_accel_x, FRF_a_imp_over_a_mov_x];
% %     mag_phase_mov_accel_y = [mag_phase_accel_y, FRF_a_imp_over_a_mov_y];
% %     mag_phase_mov_accel_z = [mag_phase_accel_z, FRF_a_imp_over_a_mov_z];
%     
% end

%% stabilising_accel/moving_accel

filename_FRF_stab_over_mov_y_1 = "Correction_Factors/Actual_accel_Stab_mass/FRF/FRF_accel_y_1.mat";
filename_FRF_stab_over_mov_y_2 = "Correction_Factors/Actual_accel_Stab_mass/FRF/FRF_accel_y_2.mat";

filename_FRF_stab_over_mov_z_1 = "Correction_Factors/Actual_accel_Stab_mass/FRF/FRF_accel_z_1.mat";
filename_FRF_stab_over_mov_z_2 = "Correction_Factors/Actual_accel_Stab_mass/FRF/FRF_accel_z_2.mat";

f_s = 160; % Hz
FRF_stab_over_mov_x_1 = tfestimate(mov_mass_accel_x_1, -1*stab_mass_accel_x_1,[] ,[] ,freq , f_s);
FRF_stab_over_mov_x_2 = tfestimate(mov_mass_accel_x_2, -1*stab_mass_accel_x_2,[] ,[] ,freq , f_s);

FRF_stab_over_mov_y_1 = load(filename_FRF_stab_over_mov_y_1).FRF;
FRF_stab_over_mov_y_2 = load(filename_FRF_stab_over_mov_y_2).FRF;

FRF_stab_over_mov_z_1 = load(filename_FRF_stab_over_mov_z_1).FRF;
FRF_stab_over_mov_z_2 = load(filename_FRF_stab_over_mov_z_2).FRF;


% Smooth data

% [txy, f]= tfestimate(mov_mass_accel_x_1, -1*stab_mass_accel_x_1,[] ,[] ,freq , f_s);

complex_accel_Stab_mov_x_1 = FRF_stab_over_mov_x_1.' ;
complex_accel_Stab_mov_x_2 = FRF_stab_over_mov_x_2.' ;
complex_accel_Stab_mov_y_1 = FRF_stab_over_mov_y_1.y_values.values ;
complex_accel_Stab_mov_y_2 = FRF_stab_over_mov_y_2.y_values.values ;
complex_accel_Stab_mov_z_1 = FRF_stab_over_mov_z_1.y_values.values ;
complex_accel_Stab_mov_z_2 = FRF_stab_over_mov_z_2.y_values.values ;

% size(complex_accel_Stab_mov_x_1)
% size(complex_accel_Stab_mov_x_2)
% size(complex_accel_Stab_mov_y_1)
% size(complex_accel_Stab_mov_y_2)
% size(complex_accel_Stab_mov_z_1)
% size(complex_accel_Stab_mov_z_2)

% complex_force_stab_mov = [complex_accel_Stab_mov_x_1, complex_accel_Stab_mov_x_2, complex_accel_Stab_mov_y_1,complex_accel_Stab_mov_y_2, complex_accel_Stab_mov_z_1, complex_accel_Stab_mov_z_2];
% 
% 
% 
% 
% smooth_mag_db_stab_mov_all = [];
% smooth_phase_stab_mov_all = [];
% 
% for idx = 1:min(size(complex_force_stab_mov))
%     complex_stab_mov = complex_force_stab_mov(:, idx);
%     
%     mag_stab_mov = [];
%     phase_stab_mov = [];
%     for i = 1:length(complex_stab_mov)
%         mag_stab_mov = [mag_stab_mov; abs(complex_stab_mov(i))];
%         phase_stab_mov = [phase_stab_mov; angle(complex_stab_mov(i))];
%     end
% 
% 
%     % Smooth experimental data
%     %     phase = unwrap(phase);
%     mag_db_stab_mov_col = mag2db(mag_stab_mov);
%     smooth_mag_db_stab_mov = smoothdata(mag_db_stab_mov_col, method, window);
%     smooth_phase_stab_mov = smoothdata(phase_stab_mov, method, window);
%     
%     
%     smooth_mag_db_stab_mov_all = [smooth_mag_db_stab_mov_all, smooth_mag_db_stab_mov];
%     smooth_phase_stab_mov_all = [smooth_phase_stab_mov_all, smooth_phase_stab_mov];
% 
% 
% 
% 
% 
% end
% % size(smooth_mag_db_stab_mov_all)
% % size(smooth_phase_stab_mov_all)
% % mag_phase_complex_force_all = [];
% 
% % Calculate average of Accelerometer FRF
% % Convert TF (mag_db and phase) at omega to complex number
% 
% % Create magnitude and phase from complex number
%     
% mag_phase_complex_stab_mov_x = [];
% mag_phase_complex_stab_mov_y = [];
% mag_phase_complex_stab_mov_z = [];
% 
% avg_mag_db_stab_mov_lst_x = [];
% avg_phase_stab_mov_lst_x = [];
% 
% avg_mag_db_stab_mov_lst_y = [];
% avg_phase_stab_mov_lst_y = [];
% 
% avg_mag_db_stab_mov_lst_z = [];
% avg_phase_stab_mov_lst_z = [];
% 
% for m=1:length(smooth_mag_db_stab_mov)
%     avg_mag_db_stab_mov_x = mean(smooth_mag_db_stab_mov_all(m, 1:2));
%     avg_phase_stab_mov_x = mean(smooth_phase_stab_mov_all(m, 1:2));
%     
%     avg_mag_db_stab_mov_y = mean(smooth_mag_db_stab_mov_all(m, 3:4));
%     avg_phase_stab_mov_y = mean(smooth_phase_stab_mov_all(m, 3:4));
%     
%     avg_mag_db_stab_mov_z = mean(smooth_mag_db_stab_mov_all(m, 5:6));
%     avg_phase_stab_mov_z = mean(smooth_phase_stab_mov_all(m, 5:6));
%     
%     avg_mag_db_stab_mov_lst_x = [avg_mag_db_stab_mov_lst_x, avg_mag_db_stab_mov_x];
%     avg_phase_stab_mov_lst_x = [avg_phase_stab_mov_lst_x, avg_phase_stab_mov_x];
%     
%     avg_mag_db_stab_mov_lst_y = [avg_mag_db_stab_mov_lst_y, avg_mag_db_stab_mov_y];
%     avg_phase_stab_mov_lst_y = [avg_phase_stab_mov_lst_y, avg_phase_stab_mov_y];
%     
%     avg_mag_db_stab_mov_lst_z = [avg_mag_db_stab_mov_lst_z, avg_mag_db_stab_mov_z];
%     avg_phase_stab_mov_lst_z = [avg_phase_stab_mov_lst_z, avg_phase_stab_mov_z];
% 
%     smooth_complex_number_x = db2mag(avg_mag_db_stab_mov_x)*(cos(avg_phase_stab_mov_x) + j*sin(avg_phase_stab_mov_x));
%     mag_phase_complex_stab_mov_x = [mag_phase_complex_stab_mov_x; smooth_complex_number_x];% [smooth_mag_db, smooth_phase];
%     
%     smooth_complex_number_y = db2mag(avg_mag_db_stab_mov_y)*(cos(avg_phase_stab_mov_y) + j*sin(avg_phase_stab_mov_y));
%     mag_phase_complex_stab_mov_y = [mag_phase_complex_stab_mov_y; smooth_complex_number_y];% [smooth_mag_db, smooth_phase];
%     
%     smooth_complex_number_z = db2mag(avg_mag_db_stab_mov_z)*(cos(avg_phase_stab_mov_z) + j*sin(avg_phase_stab_mov_z));
%     mag_phase_complex_stab_mov_z = [mag_phase_complex_stab_mov_z; smooth_complex_number_z];% [smooth_mag_db, smooth_phase];
% end
mag_phase_complex_stab_mov_z = [];
mag_phase_complex_stab_mov_y =[];
mag_phase_complex_stab_mov_x= [];

end