# Experiment data
This dataset contains the numeric results from the experiments described in
the dissertation titled "Self-Organizing Multi-Agent Systems" by C.J. van
Leeuwen.

For the following chapters, the contents of the files are as follows:

## Chapter 2 - Self Organizing State Estimation
Considers the following files:

- fusion.mat

For every figure in chapter 2, this file contains the experiment reulst for
two sensor nodes. Every figure contains a variable for the time and state
estimation error covariance. For figure 4 time and remaining battery life 
in seconds are included.

## Chapter 3 - CoCoA: an (A)DCOP Solver
Considers the following files:

- results_graphColoring_delaunayGraph_i100_d3_n500_t20161118T175401
- results_semirandom_scalefreeGraph_i100_d10_n200_t20160820T064440
- results_sensornet_scalefreeGraph_i100_d11_n50_t20160829T142608

All the files contain `options`, `results`, `settings` and `solvers` 
variables. These variables represent

- `settings, options`: These contain the information of the experiment 
    setup. Typically, the settings represent the experiment setting, (e.g.
    number of repetitions), whereas the options contain the problem options
    (type of graph, constraints, domains etc.)
- `solvers`: The names and classes of solvers included in the experiment
- `results`: For every solver, a struct containing the different 
    performance criteria for every experiment run in cells. Then for every
    experiment run an array for every iteration in the experiment.

## Chapter 4 - Self-organizing Wireless Power Transfer
Considers the following files:

- results_wpt_customWPT_i200_d20_n100_t20170409T025034
- results_wpt_noisy_i200_d20_n9_t20170418T125941
- results_wpt_sizes_i100_d20_n12_t20170414T220031

All contain `options`, `results`, `settings` and `solvers` that are 
identical to the ones for chapter 3.

Then there are two more files:
- example_graph
- dynamic_withpower

These files contain the experiment specific options with additional results
for the simulated time, costs of the LP solver, but also the randomly
instantiated positions for the transmitters, receivers and sensors.

## Chapter 5 - Hybrid DCOPs
Considers the following files:

- asymmetric-speedup_ACLSUB
- symmetric-speedup_MGM2
- manual-graph_MCSMGM
- multi-densities_MGM2
- repeated-exp_DSA

All contain `options`, `results`, `settings` and `solvers` that are 
identical to the ones for chapter 3. Additionally they contain fields
called `initSolver` and `iterSolver` that specify which intialization and
iterative solvers were used respectively.

## Chapter 6 - Self-organizing Smart Grid Planning
Considers the following files:

- rh-lp.mat

For every figure in this chapter this file contains the `price` and `power`
variables resulting from the 24 hour simulation. For the different figures 
this means:

- `fig3` the battery power response
- `fig5` the power and price results of the market operator
- `fig6` the power and price of a congestion agent
- `fig7` the power and price of a storage agent
- `fig8` cumulative powers of different classes of agents

Furthermore in `fig4` the IEEE LV power grid including the selected points 
for the concentrator agents. Finally `fig9` contains the results of the
centralized solvers as well, here the losses are stored for the three types
of solvers for all days in which the algorithms converged. 

